/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen.types;

import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.types.BitwiseType;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.runtime.JSType;

class LongType
extends BitwiseType {
    private static final long serialVersionUID = 1L;
    private static final CompilerConstants.Call VALUE_OF = CompilerConstants.staticCallNoLookup(Long.class, "valueOf", Long.class, Long.TYPE);

    protected LongType(String name) {
        super(name, Long.TYPE, 3, 2);
    }

    protected LongType() {
        this("long");
    }

    @Override
    public Type nextWider() {
        return NUMBER;
    }

    @Override
    public Class<?> getBoxedType() {
        return Long.class;
    }

    @Override
    public char getBytecodeStackType() {
        return 'J';
    }

    @Override
    public Type cmp(MethodVisitor method) {
        method.visitInsn(148);
        return INT;
    }

    @Override
    public Type load(MethodVisitor method, int slot) {
        assert (slot != -1);
        method.visitVarInsn(22, slot);
        return LONG;
    }

    @Override
    public void store(MethodVisitor method, int slot) {
        assert (slot != -1);
        method.visitVarInsn(55, slot);
    }

    @Override
    public Type ldc(MethodVisitor method, Object c) {
        assert (c instanceof Long);
        long value = (Long)c;
        if (value == 0L) {
            method.visitInsn(9);
        } else if (value == 1L) {
            method.visitInsn(10);
        } else {
            method.visitLdcInsn(c);
        }
        return Type.LONG;
    }

    @Override
    public Type convert(MethodVisitor method, Type to) {
        if (this.isEquivalentTo(to)) {
            return to;
        }
        if (to.isNumber()) {
            method.visitInsn(138);
        } else if (to.isInteger()) {
            LongType.invokestatic(method, JSType.TO_INT32_L);
        } else if (to.isBoolean()) {
            method.visitInsn(136);
        } else if (to.isObject()) {
            LongType.invokestatic(method, VALUE_OF);
        } else assert (false) : "Illegal conversion " + this + " -> " + to;
        return to;
    }

    @Override
    public Type add(MethodVisitor method, int programPoint) {
        if (programPoint == -1) {
            method.visitInsn(97);
        } else {
            method.visitInvokeDynamicInsn("ladd", "(JJ)J", MATHBOOTSTRAP, programPoint);
        }
        return LONG;
    }

    @Override
    public Type sub(MethodVisitor method, int programPoint) {
        if (programPoint == -1) {
            method.visitInsn(101);
        } else {
            method.visitInvokeDynamicInsn("lsub", "(JJ)J", MATHBOOTSTRAP, programPoint);
        }
        return LONG;
    }

    @Override
    public Type mul(MethodVisitor method, int programPoint) {
        if (programPoint == -1) {
            method.visitInsn(105);
        } else {
            method.visitInvokeDynamicInsn("lmul", "(JJ)J", MATHBOOTSTRAP, programPoint);
        }
        return LONG;
    }

    @Override
    public Type div(MethodVisitor method, int programPoint) {
        if (programPoint == -1) {
            JSType.DIV_ZERO_LONG.invoke(method);
        } else {
            method.visitInvokeDynamicInsn("ldiv", "(JJ)J", MATHBOOTSTRAP, programPoint);
        }
        return LONG;
    }

    @Override
    public Type rem(MethodVisitor method, int programPoint) {
        if (programPoint == -1) {
            JSType.REM_ZERO_LONG.invoke(method);
        } else {
            method.visitInvokeDynamicInsn("lrem", "(JJ)J", MATHBOOTSTRAP, programPoint);
        }
        return LONG;
    }

    @Override
    public Type shr(MethodVisitor method) {
        method.visitInsn(125);
        return LONG;
    }

    @Override
    public Type sar(MethodVisitor method) {
        method.visitInsn(123);
        return LONG;
    }

    @Override
    public Type shl(MethodVisitor method) {
        method.visitInsn(121);
        return LONG;
    }

    @Override
    public Type and(MethodVisitor method) {
        method.visitInsn(127);
        return LONG;
    }

    @Override
    public Type or(MethodVisitor method) {
        method.visitInsn(129);
        return LONG;
    }

    @Override
    public Type xor(MethodVisitor method) {
        method.visitInsn(131);
        return LONG;
    }

    @Override
    public Type neg(MethodVisitor method, int programPoint) {
        method.visitInvokeDynamicInsn("lneg", "(J)J", MATHBOOTSTRAP, programPoint);
        return LONG;
    }

    @Override
    public void _return(MethodVisitor method) {
        method.visitInsn(173);
    }

    @Override
    public Type loadUndefined(MethodVisitor method) {
        method.visitLdcInsn(0L);
        return LONG;
    }

    @Override
    public Type loadForcedInitializer(MethodVisitor method) {
        method.visitInsn(9);
        return LONG;
    }

    @Override
    public Type cmp(MethodVisitor method, boolean isCmpG) {
        return this.cmp(method);
    }
}

