/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.generics.reflectiveObjects;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;

public class GenericArrayTypeImpl
implements GenericArrayType {
    private final Type genericComponentType;

    private GenericArrayTypeImpl(Type type) {
        this.genericComponentType = type;
    }

    public static GenericArrayTypeImpl make(Type type) {
        return new GenericArrayTypeImpl(type);
    }

    @Override
    public Type getGenericComponentType() {
        return this.genericComponentType;
    }

    public String toString() {
        Type type = this.getGenericComponentType();
        StringBuilder stringBuilder = new StringBuilder();
        if (type instanceof Class) {
            stringBuilder.append(((Class)type).getName());
        } else {
            stringBuilder.append(type.toString());
        }
        stringBuilder.append("[]");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)object;
            Type type = genericArrayType.getGenericComponentType();
            return this.genericComponentType == null ? type == null : this.genericComponentType.equals(type);
        }
        return false;
    }

    public int hashCode() {
        return this.genericComponentType == null ? 0 : this.genericComponentType.hashCode();
    }
}

