/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import sun.net.NetProperties;
import sun.net.www.MeteredStream;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveCleanerEntry;
import sun.net.www.http.KeepAliveStream;

class KeepAliveStreamCleaner
extends LinkedList<KeepAliveCleanerEntry>
implements Runnable {
    protected static int MAX_DATA_REMAINING;
    protected static int MAX_CAPACITY;
    protected static final int TIMEOUT = 5000;
    private static final int MAX_RETRIES = 5;

    KeepAliveStreamCleaner() {
    }

    @Override
    public boolean offer(KeepAliveCleanerEntry keepAliveCleanerEntry) {
        if (this.size() >= MAX_CAPACITY) {
            return false;
        }
        return super.offer(keepAliveCleanerEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        KeepAliveCleanerEntry keepAliveCleanerEntry = null;
        do {
            try {
                Object object = this;
                synchronized (object) {
                    long l = System.currentTimeMillis();
                    long l2 = 5000L;
                    while ((keepAliveCleanerEntry = (KeepAliveCleanerEntry)this.poll()) == null) {
                        this.wait(l2);
                        long l3 = System.currentTimeMillis();
                        long l4 = l3 - l;
                        if (l4 > l2) {
                            keepAliveCleanerEntry = (KeepAliveCleanerEntry)this.poll();
                            break;
                        }
                        l = l3;
                        l2 -= l4;
                    }
                }
                if (keepAliveCleanerEntry == null) break;
                object = keepAliveCleanerEntry.getKeepAliveStream();
                if (object == null) continue;
                Object object2 = object;
                synchronized (object2) {
                    HttpClient httpClient = keepAliveCleanerEntry.getHttpClient();
                    try {
                        if (httpClient != null && !httpClient.isInKeepAliveCache()) {
                            int n = httpClient.getReadTimeout();
                            httpClient.setReadTimeout(5000);
                            long l = ((KeepAliveStream)object).remainingToRead();
                            if (l > 0L) {
                                long l5 = 0L;
                                int n2 = 0;
                                while (l5 < l && n2 < 5) {
                                    if ((l5 = ((MeteredStream)object).skip(l -= l5)) != 0L) continue;
                                    ++n2;
                                }
                                l -= l5;
                            }
                            if (l == 0L) {
                                httpClient.setReadTimeout(n);
                                httpClient.finished();
                            } else {
                                httpClient.closeServer();
                            }
                        }
                    }
                    catch (IOException iOException) {
                        httpClient.closeServer();
                    }
                    finally {
                        ((KeepAliveStream)object).setClosed();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (keepAliveCleanerEntry != null);
    }

    static {
        int n;
        int n2;
        MAX_DATA_REMAINING = 512;
        MAX_CAPACITY = 10;
        MAX_DATA_REMAINING = n2 = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return NetProperties.getInteger("http.KeepAlive.remainingData", MAX_DATA_REMAINING);
            }
        }) * 1024;
        MAX_CAPACITY = n = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return NetProperties.getInteger("http.KeepAlive.queuedConnections", MAX_CAPACITY);
            }
        }).intValue();
    }
}

