/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface ConcurrentMap<K, V>
extends Map<K, V> {
    @Override
    default public V getOrDefault(Object object, V v) {
        Object v2 = this.get(object);
        return v2 != null ? v2 : v;
    }

    @Override
    default public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Objects.requireNonNull(biConsumer);
        for (Map.Entry entry : this.entrySet()) {
            Object v;
            Object k;
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
            biConsumer.accept(k, v);
        }
    }

    @Override
    public V putIfAbsent(K var1, V var2);

    @Override
    public boolean remove(Object var1, Object var2);

    @Override
    public boolean replace(K var1, V var2, V var3);

    @Override
    public V replace(K var1, V var2);

    @Override
    default public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Objects.requireNonNull(biFunction);
        this.forEach((object, object2) -> {
            while (!this.replace(object, object2, biFunction.apply((K)object, (V)object2)) && (object2 = this.get(object)) != null) {
            }
        });
    }

    @Override
    default public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
        V v;
        Objects.requireNonNull(function);
        Object v2 = this.get(k);
        return v2 == null && (v = function.apply(k)) != null && (v2 = this.putIfAbsent(k, v)) == null ? v : v2;
    }

    @Override
    default public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Object v;
        Objects.requireNonNull(biFunction);
        while ((v = this.get(k)) != null) {
            V v2 = biFunction.apply(k, v);
            if (v2 != null) {
                if (!this.replace(k, v, v2)) continue;
                return v2;
            }
            if (!this.remove(k, v)) continue;
            return null;
        }
        return v;
    }

    @Override
    default public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        V v;
        Objects.requireNonNull(biFunction);
        Object v2 = this.get(k);
        while (true) {
            if ((v = biFunction.apply(k, v2)) == null) {
                if (v2 != null || this.containsKey(k)) {
                    if (this.remove(k, v2)) {
                        return null;
                    }
                    v2 = this.get(k);
                    continue;
                }
                return null;
            }
            if (v2 != null) {
                if (this.replace(k, v2, v)) {
                    return v;
                }
                v2 = this.get(k);
                continue;
            }
            v2 = this.putIfAbsent(k, v);
            if (v2 == null) break;
        }
        return v;
    }

    @Override
    default public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        Objects.requireNonNull(biFunction);
        Objects.requireNonNull(v);
        Object v2 = this.get(k);
        while (true) {
            if (v2 != null) {
                V v3 = biFunction.apply(v2, v);
                if (v3 != null) {
                    if (this.replace(k, v2, v3)) {
                        return v3;
                    }
                } else if (this.remove(k, v2)) {
                    return null;
                }
                v2 = this.get(k);
                continue;
            }
            v2 = this.putIfAbsent(k, v);
            if (v2 == null) break;
        }
        return v;
    }
}

