/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XIMCallback
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 8 : 16;
    }

    @Override
    public int getDataSize() {
        return XIMCallback.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XIMCallback(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XIMCallback() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XIMCallback.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public long get_client_data(int n) {
        log.finest("");
        return Native.getLong(this.pData + 0L) + (long)(n * Native.getLongSize());
    }

    public long get_client_data() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_client_data(long l) {
        log.finest("");
        Native.putLong(this.pData + 0L, l);
    }

    public long get_callback(int n) {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8)) + (long)(n * Native.getLongSize());
    }

    public long get_callback() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8));
    }

    public void set_callback(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8), l);
    }

    @Override
    String getName() {
        return "XIMCallback";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("client_data = ").append(this.get_client_data()).append(", ");
        stringBuilder.append("callback = ").append(this.get_callback()).append(", ");
        return stringBuilder.toString();
    }
}

