/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.text.Collator;
import java.util.Comparator;
import javax.swing.DefaultRowSorter;
import javax.swing.table.TableModel;
import javax.swing.table.TableStringConverter;

public class TableRowSorter<M extends TableModel>
extends DefaultRowSorter<M, Integer> {
    private static final Comparator COMPARABLE_COMPARATOR = new ComparableComparator();
    private M tableModel;
    private TableStringConverter stringConverter;

    public TableRowSorter() {
        this(null);
    }

    public TableRowSorter(M m) {
        this.setModel(m);
    }

    public void setModel(M m) {
        this.tableModel = m;
        this.setModelWrapper(new TableRowSorterModelWrapper());
    }

    public void setStringConverter(TableStringConverter tableStringConverter) {
        this.stringConverter = tableStringConverter;
    }

    public TableStringConverter getStringConverter() {
        return this.stringConverter;
    }

    @Override
    public Comparator<?> getComparator(int n) {
        Comparator<?> comparator = super.getComparator(n);
        if (comparator != null) {
            return comparator;
        }
        Class<?> clazz = ((TableModel)this.getModel()).getColumnClass(n);
        if (clazz == String.class) {
            return Collator.getInstance();
        }
        if (Comparable.class.isAssignableFrom(clazz)) {
            return COMPARABLE_COMPARATOR;
        }
        return Collator.getInstance();
    }

    @Override
    protected boolean useToString(int n) {
        Comparator<?> comparator = super.getComparator(n);
        if (comparator != null) {
            return false;
        }
        Class<?> clazz = ((TableModel)this.getModel()).getColumnClass(n);
        if (clazz == String.class) {
            return false;
        }
        return !Comparable.class.isAssignableFrom(clazz);
    }

    private static class ComparableComparator
    implements Comparator {
        private ComparableComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }
    }

    private class TableRowSorterModelWrapper
    extends DefaultRowSorter.ModelWrapper<M, Integer> {
        private TableRowSorterModelWrapper() {
        }

        @Override
        public M getModel() {
            return TableRowSorter.this.tableModel;
        }

        @Override
        public int getColumnCount() {
            return TableRowSorter.this.tableModel == null ? 0 : TableRowSorter.this.tableModel.getColumnCount();
        }

        @Override
        public int getRowCount() {
            return TableRowSorter.this.tableModel == null ? 0 : TableRowSorter.this.tableModel.getRowCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return TableRowSorter.this.tableModel.getValueAt(n, n2);
        }

        @Override
        public String getStringValueAt(int n, int n2) {
            TableStringConverter tableStringConverter = TableRowSorter.this.getStringConverter();
            if (tableStringConverter != null) {
                String string = tableStringConverter.toString(TableRowSorter.this.tableModel, n, n2);
                if (string != null) {
                    return string;
                }
                return "";
            }
            Object object = this.getValueAt(n, n2);
            if (object == null) {
                return "";
            }
            String string = object.toString();
            if (string == null) {
                return "";
            }
            return string;
        }

        @Override
        public Integer getIdentifier(int n) {
            return n;
        }
    }
}

