/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.im.spi.InputMethodDescriptor;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JFrame;
import sun.awt.im.AWTInputMethodPopupMenu;
import sun.awt.im.ExecutableInputMethodManager;
import sun.awt.im.InputMethodLocator;
import sun.awt.im.InputMethodManager;
import sun.awt.im.JInputMethodPopupMenu;

abstract class InputMethodPopupMenu
implements ActionListener {
    InputMethodPopupMenu() {
    }

    static InputMethodPopupMenu getInstance(Component component, String string) {
        if (component instanceof JFrame || component instanceof JDialog) {
            return new JInputMethodPopupMenu(string);
        }
        return new AWTInputMethodPopupMenu(string);
    }

    abstract void show(Component var1, int var2, int var3);

    abstract void removeAll();

    abstract void addSeparator();

    abstract void addToComponent(Component var1);

    abstract Object createSubmenu(String var1);

    abstract void add(Object var1);

    abstract void addMenuItem(String var1, String var2, String var3);

    abstract void addMenuItem(Object var1, String var2, String var3, String var4);

    void addOneInputMethodToMenu(InputMethodLocator inputMethodLocator, String string) {
        int n;
        InputMethodDescriptor inputMethodDescriptor = inputMethodLocator.getDescriptor();
        String string2 = inputMethodDescriptor.getInputMethodDisplayName(null, Locale.getDefault());
        String string3 = inputMethodLocator.getActionCommandString();
        Locale[] localeArray = null;
        try {
            localeArray = inputMethodDescriptor.getAvailableLocales();
            n = localeArray.length;
        }
        catch (AWTException aWTException) {
            n = 0;
        }
        if (n == 0) {
            this.addMenuItem(string2, null, string);
        } else if (n == 1) {
            if (inputMethodDescriptor.hasDynamicLocaleList()) {
                string2 = inputMethodDescriptor.getInputMethodDisplayName(localeArray[0], Locale.getDefault());
                string3 = inputMethodLocator.deriveLocator(localeArray[0]).getActionCommandString();
            }
            this.addMenuItem(string2, string3, string);
        } else {
            Object object = this.createSubmenu(string2);
            this.add(object);
            for (int i = 0; i < n; ++i) {
                Locale locale = localeArray[i];
                String string4 = this.getLocaleName(locale);
                String string5 = inputMethodLocator.deriveLocator(locale).getActionCommandString();
                this.addMenuItem(object, string4, string5, string);
            }
        }
    }

    static boolean isSelected(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.equals(string2)) {
            return true;
        }
        int n = string2.indexOf(10);
        return n != -1 && string2.substring(0, n).equals(string);
    }

    String getLocaleName(Locale locale) {
        String string = locale.toString();
        String string2 = Toolkit.getProperty("AWT.InputMethodLanguage." + string, null);
        if (string2 == null && ((string2 = locale.getDisplayName()) == null || string2.length() == 0)) {
            string2 = string;
        }
        return string2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        ((ExecutableInputMethodManager)InputMethodManager.getInstance()).changeInputMethod(string);
    }
}

