/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.rmi.runtime.Log;
import sun.rmi.transport.proxy.RMIMasterSocketFactory;

class HttpInputStream
extends FilterInputStream {
    protected int bytesLeft;
    protected int bytesLeftAtMark;

    public HttpInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        String string;
        if (inputStream.markSupported()) {
            inputStream.mark(0);
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        String string2 = "Content-length:".toLowerCase();
        boolean bl = false;
        do {
            string = dataInputStream.readLine();
            if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.VERBOSE)) {
                RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "received header line: \"" + string + "\"");
            }
            if (string == null) {
                throw new EOFException();
            }
            if (!string.toLowerCase().startsWith(string2)) continue;
            if (bl) {
                throw new IOException("Multiple Content-length entries found.");
            }
            this.bytesLeft = Integer.parseInt(string.substring(string2.length()).trim());
            bl = true;
        } while (string.length() != 0 && string.charAt(0) != '\r' && string.charAt(0) != '\n');
        if (!bl || this.bytesLeft < 0) {
            this.bytesLeft = Integer.MAX_VALUE;
        }
        this.bytesLeftAtMark = this.bytesLeft;
        if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.VERBOSE)) {
            RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "content length: " + this.bytesLeft);
        }
    }

    @Override
    public int available() throws IOException {
        int n = this.in.available();
        if (n > this.bytesLeft) {
            n = this.bytesLeft;
        }
        return n;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesLeft > 0) {
            int n = this.in.read();
            if (n != -1) {
                --this.bytesLeft;
            }
            if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.VERBOSE)) {
                RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "received byte: '" + ((n & 0x7F) < 32 ? " " : String.valueOf((char)n)) + "' " + n);
            }
            return n;
        }
        RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "read past content length");
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.bytesLeft == 0 && n2 > 0) {
            RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "read past content length");
            return -1;
        }
        if (n2 > this.bytesLeft) {
            n2 = this.bytesLeft;
        }
        int n3 = this.in.read(byArray, n, n2);
        this.bytesLeft -= n3;
        if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.VERBOSE)) {
            RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "read " + n3 + " bytes, " + this.bytesLeft + " remaining");
        }
        return n3;
    }

    @Override
    public void mark(int n) {
        this.in.mark(n);
        if (this.in.markSupported()) {
            this.bytesLeftAtMark = this.bytesLeft;
        }
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.bytesLeft = this.bytesLeftAtMark;
    }

    @Override
    public long skip(long l) throws IOException {
        if (l > (long)this.bytesLeft) {
            l = this.bytesLeft;
        }
        long l2 = this.in.skip(l);
        this.bytesLeft = (int)((long)this.bytesLeft - l2);
        return l2;
    }
}

