/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.PBEKey;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.HashSet;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.PBEKeySpec;

abstract class PBEKeyFactory
extends SecretKeyFactorySpi {
    private String type;
    private static HashSet<String> validTypes = new HashSet(4);

    private PBEKeyFactory(String string) {
        this.type = string;
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof PBEKeySpec)) {
            throw new InvalidKeySpecException("Invalid key spec");
        }
        return new PBEKey((PBEKeySpec)keySpec, this.type);
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        if (secretKey instanceof SecretKey && validTypes.contains(secretKey.getAlgorithm().toUpperCase()) && secretKey.getFormat().equalsIgnoreCase("RAW")) {
            if (clazz != null && PBEKeySpec.class.isAssignableFrom(clazz)) {
                byte[] byArray = secretKey.getEncoded();
                char[] cArray = new char[byArray.length];
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = (char)(byArray[i] & 0x7F);
                }
                PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
                Arrays.fill(cArray, ' ');
                Arrays.fill(byArray, (byte)0);
                return pBEKeySpec;
            }
            throw new InvalidKeySpecException("Invalid key spec");
        }
        throw new InvalidKeySpecException("Invalid key format/algorithm");
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        try {
            if (secretKey != null && validTypes.contains(secretKey.getAlgorithm().toUpperCase()) && secretKey.getFormat().equalsIgnoreCase("RAW")) {
                if (secretKey instanceof PBEKey) {
                    return secretKey;
                }
                PBEKeySpec pBEKeySpec = (PBEKeySpec)this.engineGetKeySpec(secretKey, (Class)PBEKeySpec.class);
                return this.engineGenerateSecret(pBEKeySpec);
            }
            throw new InvalidKeyException("Invalid key format/algorithm");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot translate key: " + invalidKeySpecException.getMessage());
        }
    }

    static {
        validTypes.add("PBEWithMD5AndDES".toUpperCase());
        validTypes.add("PBEWithSHA1AndDESede".toUpperCase());
        validTypes.add("PBEWithSHA1AndRC2_40".toUpperCase());
        validTypes.add("PBEWithMD5AndTripleDES".toUpperCase());
    }

    public static final class PBEWithMD5AndTripleDES
    extends PBEKeyFactory {
        public PBEWithMD5AndTripleDES() {
            super("PBEWithMD5AndTripleDES");
        }
    }

    public static final class PBEWithSHA1AndRC2_40
    extends PBEKeyFactory {
        public PBEWithSHA1AndRC2_40() {
            super("PBEWithSHA1AndRC2_40");
        }
    }

    public static final class PBEWithSHA1AndDESede
    extends PBEKeyFactory {
        public PBEWithSHA1AndDESede() {
            super("PBEWithSHA1AndDESede");
        }
    }

    public static final class PBEWithMD5AndDES
    extends PBEKeyFactory {
        public PBEWithMD5AndDES() {
            super("PBEWithMD5AndDES");
        }
    }
}

