/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Date;
import java.util.TaskQueue;
import java.util.TimerTask;
import java.util.TimerThread;
import java.util.concurrent.atomic.AtomicInteger;

public class Timer {
    private final TaskQueue queue = new TaskQueue();
    private final TimerThread thread = new TimerThread(this.queue);
    private final Object threadReaper = new Object(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            TaskQueue taskQueue = Timer.this.queue;
            synchronized (taskQueue) {
                ((Timer)Timer.this).thread.newTasksMayBeScheduled = false;
                Timer.this.queue.notify();
            }
        }
    };
    private static final AtomicInteger nextSerialNumber = new AtomicInteger(0);

    private static int serialNumber() {
        return nextSerialNumber.getAndIncrement();
    }

    public Timer() {
        this("Timer-" + Timer.serialNumber());
    }

    public Timer(boolean bl) {
        this("Timer-" + Timer.serialNumber(), bl);
    }

    public Timer(String string) {
        this.thread.setName(string);
        this.thread.start();
    }

    public Timer(String string, boolean bl) {
        this.thread.setName(string);
        this.thread.setDaemon(bl);
        this.thread.start();
    }

    public void schedule(TimerTask timerTask, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        this.sched(timerTask, System.currentTimeMillis() + l, 0L);
    }

    public void schedule(TimerTask timerTask, Date date) {
        this.sched(timerTask, date.getTime(), 0L);
    }

    public void schedule(TimerTask timerTask, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(timerTask, System.currentTimeMillis() + l, -l2);
    }

    public void schedule(TimerTask timerTask, Date date, long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(timerTask, date.getTime(), -l);
    }

    public void scheduleAtFixedRate(TimerTask timerTask, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(timerTask, System.currentTimeMillis() + l, l2);
    }

    public void scheduleAtFixedRate(TimerTask timerTask, Date date, long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(timerTask, date.getTime(), l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sched(TimerTask timerTask, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Illegal execution time.");
        }
        if (Math.abs(l2) > 0x3FFFFFFFFFFFFFFFL) {
            l2 >>= 1;
        }
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            if (!this.thread.newTasksMayBeScheduled) {
                throw new IllegalStateException("Timer already cancelled.");
            }
            Object object = timerTask.lock;
            synchronized (object) {
                if (timerTask.state != 0) {
                    throw new IllegalStateException("Task already scheduled or cancelled");
                }
                timerTask.nextExecutionTime = l;
                timerTask.period = l2;
                timerTask.state = 1;
            }
            this.queue.add(timerTask);
            if (this.queue.getMin() == timerTask) {
                this.queue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            this.thread.newTasksMayBeScheduled = false;
            this.queue.clear();
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int purge() {
        int n = 0;
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            for (int i = this.queue.size(); i > 0; --i) {
                if (this.queue.get((int)i).state != 3) continue;
                this.queue.quickRemove(i);
                ++n;
            }
            if (n != 0) {
                this.queue.heapify();
            }
        }
        return n;
    }
}

