/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Chronology;
import java.time.chrono.Era;
import java.time.chrono.HijrahChronology;
import java.time.chrono.IsoChronology;
import java.time.chrono.JapaneseChronology;
import java.time.chrono.MinguoChronology;
import java.time.chrono.Ser;
import java.time.chrono.ThaiBuddhistChronology;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import sun.util.logging.PlatformLogger;

public abstract class AbstractChronology
implements Chronology {
    static final Comparator<ChronoLocalDate> DATE_ORDER = (Comparator & Serializable)(chronoLocalDate, chronoLocalDate2) -> Long.compare(chronoLocalDate.toEpochDay(), chronoLocalDate2.toEpochDay());
    static final Comparator<ChronoLocalDateTime<? extends ChronoLocalDate>> DATE_TIME_ORDER = (Comparator & Serializable)(chronoLocalDateTime, chronoLocalDateTime2) -> {
        int n = Long.compare(chronoLocalDateTime.toLocalDate().toEpochDay(), chronoLocalDateTime2.toLocalDate().toEpochDay());
        if (n == 0) {
            n = Long.compare(chronoLocalDateTime.toLocalTime().toNanoOfDay(), chronoLocalDateTime2.toLocalTime().toNanoOfDay());
        }
        return n;
    };
    static final Comparator<ChronoZonedDateTime<?>> INSTANT_ORDER = (Comparator & Serializable)(chronoZonedDateTime, chronoZonedDateTime2) -> {
        int n = Long.compare(chronoZonedDateTime.toEpochSecond(), chronoZonedDateTime2.toEpochSecond());
        if (n == 0) {
            n = Long.compare(chronoZonedDateTime.toLocalTime().getNano(), chronoZonedDateTime2.toLocalTime().getNano());
        }
        return n;
    };
    private static final ConcurrentHashMap<String, Chronology> CHRONOS_BY_ID = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Chronology> CHRONOS_BY_TYPE = new ConcurrentHashMap();

    static Chronology registerChrono(Chronology chronology) {
        return AbstractChronology.registerChrono(chronology, chronology.getId());
    }

    static Chronology registerChrono(Chronology chronology, String string) {
        String string2;
        Chronology chronology2 = CHRONOS_BY_ID.putIfAbsent(string, chronology);
        if (chronology2 == null && (string2 = chronology.getCalendarType()) != null) {
            CHRONOS_BY_TYPE.putIfAbsent(string2, chronology);
        }
        return chronology2;
    }

    private static boolean initCache() {
        if (CHRONOS_BY_ID.get("ISO") == null) {
            AbstractChronology.registerChrono(HijrahChronology.INSTANCE);
            AbstractChronology.registerChrono(JapaneseChronology.INSTANCE);
            AbstractChronology.registerChrono(MinguoChronology.INSTANCE);
            AbstractChronology.registerChrono(ThaiBuddhistChronology.INSTANCE);
            ServiceLoader<AbstractChronology> serviceLoader = ServiceLoader.load(AbstractChronology.class, null);
            for (AbstractChronology abstractChronology : serviceLoader) {
                String string = abstractChronology.getId();
                if (!string.equals("ISO") && AbstractChronology.registerChrono(abstractChronology) == null) continue;
                PlatformLogger platformLogger = PlatformLogger.getLogger("java.time.chrono");
                platformLogger.warning("Ignoring duplicate Chronology, from ServiceLoader configuration " + string);
            }
            AbstractChronology.registerChrono(IsoChronology.INSTANCE);
            return true;
        }
        return false;
    }

    static Chronology ofLocale(Locale locale) {
        Object object;
        Objects.requireNonNull(locale, "locale");
        String string = locale.getUnicodeLocaleType("ca");
        if (string == null || "iso".equals(string) || "iso8601".equals(string)) {
            return IsoChronology.INSTANCE;
        }
        do {
            if ((object = CHRONOS_BY_TYPE.get(string)) == null) continue;
            return object;
        } while (AbstractChronology.initCache());
        object = ServiceLoader.load(Chronology.class);
        Iterator iterator = ((ServiceLoader)object).iterator();
        while (iterator.hasNext()) {
            Chronology chronology = (Chronology)iterator.next();
            if (!string.equals(chronology.getCalendarType())) continue;
            return chronology;
        }
        throw new DateTimeException("Unknown calendar system: " + string);
    }

    static Chronology of(String string) {
        Object object;
        Objects.requireNonNull(string, "id");
        do {
            if ((object = AbstractChronology.of0(string)) == null) continue;
            return object;
        } while (AbstractChronology.initCache());
        object = ServiceLoader.load(Chronology.class);
        Iterator iterator = ((ServiceLoader)object).iterator();
        while (iterator.hasNext()) {
            Chronology chronology = (Chronology)iterator.next();
            if (!string.equals(chronology.getId()) && !string.equals(chronology.getCalendarType())) continue;
            return chronology;
        }
        throw new DateTimeException("Unknown chronology: " + string);
    }

    private static Chronology of0(String string) {
        Chronology chronology = CHRONOS_BY_ID.get(string);
        if (chronology == null) {
            chronology = CHRONOS_BY_TYPE.get(string);
        }
        return chronology;
    }

    static Set<Chronology> getAvailableChronologies() {
        AbstractChronology.initCache();
        HashSet<Chronology> hashSet = new HashSet<Chronology>(CHRONOS_BY_ID.values());
        ServiceLoader<Chronology> serviceLoader = ServiceLoader.load(Chronology.class);
        for (Chronology chronology : serviceLoader) {
            hashSet.add(chronology);
        }
        return hashSet;
    }

    protected AbstractChronology() {
    }

    @Override
    public ChronoLocalDate resolveDate(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        if (map.containsKey(ChronoField.EPOCH_DAY)) {
            return this.dateEpochDay(map.remove(ChronoField.EPOCH_DAY));
        }
        this.resolveProlepticMonth(map, resolverStyle);
        ChronoLocalDate chronoLocalDate = this.resolveYearOfEra(map, resolverStyle);
        if (chronoLocalDate != null) {
            return chronoLocalDate;
        }
        if (map.containsKey(ChronoField.YEAR)) {
            if (map.containsKey(ChronoField.MONTH_OF_YEAR)) {
                if (map.containsKey(ChronoField.DAY_OF_MONTH)) {
                    return this.resolveYMD(map, resolverStyle);
                }
                if (map.containsKey(ChronoField.ALIGNED_WEEK_OF_MONTH)) {
                    if (map.containsKey(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH)) {
                        return this.resolveYMAA(map, resolverStyle);
                    }
                    if (map.containsKey(ChronoField.DAY_OF_WEEK)) {
                        return this.resolveYMAD(map, resolverStyle);
                    }
                }
            }
            if (map.containsKey(ChronoField.DAY_OF_YEAR)) {
                return this.resolveYD(map, resolverStyle);
            }
            if (map.containsKey(ChronoField.ALIGNED_WEEK_OF_YEAR)) {
                if (map.containsKey(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR)) {
                    return this.resolveYAA(map, resolverStyle);
                }
                if (map.containsKey(ChronoField.DAY_OF_WEEK)) {
                    return this.resolveYAD(map, resolverStyle);
                }
            }
        }
        return null;
    }

    void resolveProlepticMonth(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        Long l = map.remove(ChronoField.PROLEPTIC_MONTH);
        if (l != null) {
            if (resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.PROLEPTIC_MONTH.checkValidValue(l);
            }
            ChronoLocalDate chronoLocalDate = this.dateNow().with(ChronoField.DAY_OF_MONTH, 1L).with(ChronoField.PROLEPTIC_MONTH, l);
            this.addFieldValue(map, ChronoField.MONTH_OF_YEAR, chronoLocalDate.get(ChronoField.MONTH_OF_YEAR));
            this.addFieldValue(map, ChronoField.YEAR, chronoLocalDate.get(ChronoField.YEAR));
        }
    }

    ChronoLocalDate resolveYearOfEra(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        Long l = map.remove(ChronoField.YEAR_OF_ERA);
        if (l != null) {
            Long l2 = map.remove(ChronoField.ERA);
            int n = resolverStyle != ResolverStyle.LENIENT ? this.range(ChronoField.YEAR_OF_ERA).checkValidIntValue(l, ChronoField.YEAR_OF_ERA) : Math.toIntExact(l);
            if (l2 != null) {
                Era era = this.eraOf(this.range(ChronoField.ERA).checkValidIntValue(l2, ChronoField.ERA));
                this.addFieldValue(map, ChronoField.YEAR, this.prolepticYear(era, n));
            } else if (map.containsKey(ChronoField.YEAR)) {
                int n2 = this.range(ChronoField.YEAR).checkValidIntValue(map.get(ChronoField.YEAR), ChronoField.YEAR);
                ChronoLocalDate chronoLocalDate = this.dateYearDay(n2, 1);
                this.addFieldValue(map, ChronoField.YEAR, this.prolepticYear(chronoLocalDate.getEra(), n));
            } else if (resolverStyle == ResolverStyle.STRICT) {
                map.put(ChronoField.YEAR_OF_ERA, l);
            } else {
                List<Era> list = this.eras();
                if (list.isEmpty()) {
                    this.addFieldValue(map, ChronoField.YEAR, n);
                } else {
                    Era era = list.get(list.size() - 1);
                    this.addFieldValue(map, ChronoField.YEAR, this.prolepticYear(era, n));
                }
            }
        } else if (map.containsKey(ChronoField.ERA)) {
            this.range(ChronoField.ERA).checkValidValue(map.get(ChronoField.ERA), ChronoField.ERA);
        }
        return null;
    }

    ChronoLocalDate resolveYMD(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        int n = this.range(ChronoField.YEAR).checkValidIntValue(map.remove(ChronoField.YEAR), ChronoField.YEAR);
        if (resolverStyle == ResolverStyle.LENIENT) {
            long l = Math.subtractExact(map.remove(ChronoField.MONTH_OF_YEAR), 1L);
            long l2 = Math.subtractExact(map.remove(ChronoField.DAY_OF_MONTH), 1L);
            return this.date(n, 1, 1).plus(l, ChronoUnit.MONTHS).plus(l2, ChronoUnit.DAYS);
        }
        int n2 = this.range(ChronoField.MONTH_OF_YEAR).checkValidIntValue(map.remove(ChronoField.MONTH_OF_YEAR), ChronoField.MONTH_OF_YEAR);
        ValueRange valueRange = this.range(ChronoField.DAY_OF_MONTH);
        int n3 = valueRange.checkValidIntValue(map.remove(ChronoField.DAY_OF_MONTH), ChronoField.DAY_OF_MONTH);
        if (resolverStyle == ResolverStyle.SMART) {
            try {
                return this.date(n, n2, n3);
            }
            catch (DateTimeException dateTimeException) {
                return this.date(n, n2, 1).with(TemporalAdjusters.lastDayOfMonth());
            }
        }
        return this.date(n, n2, n3);
    }

    ChronoLocalDate resolveYD(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        int n = this.range(ChronoField.YEAR).checkValidIntValue(map.remove(ChronoField.YEAR), ChronoField.YEAR);
        if (resolverStyle == ResolverStyle.LENIENT) {
            long l = Math.subtractExact(map.remove(ChronoField.DAY_OF_YEAR), 1L);
            return this.dateYearDay(n, 1).plus(l, ChronoUnit.DAYS);
        }
        int n2 = this.range(ChronoField.DAY_OF_YEAR).checkValidIntValue(map.remove(ChronoField.DAY_OF_YEAR), ChronoField.DAY_OF_YEAR);
        return this.dateYearDay(n, n2);
    }

    ChronoLocalDate resolveYMAA(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        int n = this.range(ChronoField.YEAR).checkValidIntValue(map.remove(ChronoField.YEAR), ChronoField.YEAR);
        if (resolverStyle == ResolverStyle.LENIENT) {
            long l = Math.subtractExact(map.remove(ChronoField.MONTH_OF_YEAR), 1L);
            long l2 = Math.subtractExact(map.remove(ChronoField.ALIGNED_WEEK_OF_MONTH), 1L);
            long l3 = Math.subtractExact(map.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH), 1L);
            return this.date(n, 1, 1).plus(l, ChronoUnit.MONTHS).plus(l2, ChronoUnit.WEEKS).plus(l3, ChronoUnit.DAYS);
        }
        int n2 = this.range(ChronoField.MONTH_OF_YEAR).checkValidIntValue(map.remove(ChronoField.MONTH_OF_YEAR), ChronoField.MONTH_OF_YEAR);
        int n3 = this.range(ChronoField.ALIGNED_WEEK_OF_MONTH).checkValidIntValue(map.remove(ChronoField.ALIGNED_WEEK_OF_MONTH), ChronoField.ALIGNED_WEEK_OF_MONTH);
        int n4 = this.range(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH).checkValidIntValue(map.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH), ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH);
        ChronoLocalDate chronoLocalDate = this.date(n, n2, 1).plus((n3 - 1) * 7 + (n4 - 1), ChronoUnit.DAYS);
        if (resolverStyle == ResolverStyle.STRICT && chronoLocalDate.get(ChronoField.MONTH_OF_YEAR) != n2) {
            throw new DateTimeException("Strict mode rejected resolved date as it is in a different month");
        }
        return chronoLocalDate;
    }

    ChronoLocalDate resolveYMAD(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        int n = this.range(ChronoField.YEAR).checkValidIntValue(map.remove(ChronoField.YEAR), ChronoField.YEAR);
        if (resolverStyle == ResolverStyle.LENIENT) {
            long l = Math.subtractExact(map.remove(ChronoField.MONTH_OF_YEAR), 1L);
            long l2 = Math.subtractExact(map.remove(ChronoField.ALIGNED_WEEK_OF_MONTH), 1L);
            long l3 = Math.subtractExact(map.remove(ChronoField.DAY_OF_WEEK), 1L);
            return this.resolveAligned(this.date(n, 1, 1), l, l2, l3);
        }
        int n2 = this.range(ChronoField.MONTH_OF_YEAR).checkValidIntValue(map.remove(ChronoField.MONTH_OF_YEAR), ChronoField.MONTH_OF_YEAR);
        int n3 = this.range(ChronoField.ALIGNED_WEEK_OF_MONTH).checkValidIntValue(map.remove(ChronoField.ALIGNED_WEEK_OF_MONTH), ChronoField.ALIGNED_WEEK_OF_MONTH);
        int n4 = this.range(ChronoField.DAY_OF_WEEK).checkValidIntValue(map.remove(ChronoField.DAY_OF_WEEK), ChronoField.DAY_OF_WEEK);
        ChronoLocalDate chronoLocalDate = this.date(n, n2, 1).plus((n3 - 1) * 7, ChronoUnit.DAYS).with(TemporalAdjusters.nextOrSame(DayOfWeek.of(n4)));
        if (resolverStyle == ResolverStyle.STRICT && chronoLocalDate.get(ChronoField.MONTH_OF_YEAR) != n2) {
            throw new DateTimeException("Strict mode rejected resolved date as it is in a different month");
        }
        return chronoLocalDate;
    }

    ChronoLocalDate resolveYAA(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        int n = this.range(ChronoField.YEAR).checkValidIntValue(map.remove(ChronoField.YEAR), ChronoField.YEAR);
        if (resolverStyle == ResolverStyle.LENIENT) {
            long l = Math.subtractExact(map.remove(ChronoField.ALIGNED_WEEK_OF_YEAR), 1L);
            long l2 = Math.subtractExact(map.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR), 1L);
            return this.dateYearDay(n, 1).plus(l, ChronoUnit.WEEKS).plus(l2, ChronoUnit.DAYS);
        }
        int n2 = this.range(ChronoField.ALIGNED_WEEK_OF_YEAR).checkValidIntValue(map.remove(ChronoField.ALIGNED_WEEK_OF_YEAR), ChronoField.ALIGNED_WEEK_OF_YEAR);
        int n3 = this.range(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR).checkValidIntValue(map.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR), ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR);
        ChronoLocalDate chronoLocalDate = this.dateYearDay(n, 1).plus((n2 - 1) * 7 + (n3 - 1), ChronoUnit.DAYS);
        if (resolverStyle == ResolverStyle.STRICT && chronoLocalDate.get(ChronoField.YEAR) != n) {
            throw new DateTimeException("Strict mode rejected resolved date as it is in a different year");
        }
        return chronoLocalDate;
    }

    ChronoLocalDate resolveYAD(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        int n = this.range(ChronoField.YEAR).checkValidIntValue(map.remove(ChronoField.YEAR), ChronoField.YEAR);
        if (resolverStyle == ResolverStyle.LENIENT) {
            long l = Math.subtractExact(map.remove(ChronoField.ALIGNED_WEEK_OF_YEAR), 1L);
            long l2 = Math.subtractExact(map.remove(ChronoField.DAY_OF_WEEK), 1L);
            return this.resolveAligned(this.dateYearDay(n, 1), 0L, l, l2);
        }
        int n2 = this.range(ChronoField.ALIGNED_WEEK_OF_YEAR).checkValidIntValue(map.remove(ChronoField.ALIGNED_WEEK_OF_YEAR), ChronoField.ALIGNED_WEEK_OF_YEAR);
        int n3 = this.range(ChronoField.DAY_OF_WEEK).checkValidIntValue(map.remove(ChronoField.DAY_OF_WEEK), ChronoField.DAY_OF_WEEK);
        ChronoLocalDate chronoLocalDate = this.dateYearDay(n, 1).plus((n2 - 1) * 7, ChronoUnit.DAYS).with(TemporalAdjusters.nextOrSame(DayOfWeek.of(n3)));
        if (resolverStyle == ResolverStyle.STRICT && chronoLocalDate.get(ChronoField.YEAR) != n) {
            throw new DateTimeException("Strict mode rejected resolved date as it is in a different year");
        }
        return chronoLocalDate;
    }

    ChronoLocalDate resolveAligned(ChronoLocalDate chronoLocalDate, long l, long l2, long l3) {
        ChronoLocalDate chronoLocalDate2 = chronoLocalDate.plus(l, ChronoUnit.MONTHS).plus(l2, ChronoUnit.WEEKS);
        if (l3 > 7L) {
            chronoLocalDate2 = chronoLocalDate2.plus((l3 - 1L) / 7L, ChronoUnit.WEEKS);
            l3 = (l3 - 1L) % 7L + 1L;
        } else if (l3 < 1L) {
            chronoLocalDate2 = chronoLocalDate2.plus(Math.subtractExact(l3, 7L) / 7L, ChronoUnit.WEEKS);
            l3 = (l3 + 6L) % 7L + 1L;
        }
        return chronoLocalDate2.with(TemporalAdjusters.nextOrSame(DayOfWeek.of((int)l3)));
    }

    void addFieldValue(Map<TemporalField, Long> map, ChronoField chronoField, long l) {
        Long l2 = map.get(chronoField);
        if (l2 != null && l2 != l) {
            throw new DateTimeException("Conflict found: " + chronoField + " " + l2 + " differs from " + chronoField + " " + l);
        }
        map.put(chronoField, l);
    }

    @Override
    public int compareTo(Chronology chronology) {
        return this.getId().compareTo(chronology.getId());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AbstractChronology) {
            return this.compareTo((AbstractChronology)object) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() ^ this.getId().hashCode();
    }

    @Override
    public String toString() {
        return this.getId();
    }

    Object writeReplace() {
        return new Ser(1, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ObjectStreamException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.getId());
    }

    static Chronology readExternal(DataInput dataInput) throws IOException {
        String string = dataInput.readUTF();
        return Chronology.of(string);
    }
}

