/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class BlowfishKeyGenerator
extends KeyGeneratorSpi {
    private SecureRandom random = null;
    private int keysize = 16;

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Blowfish key generation does not take any parameters");
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        if (n % 8 != 0 || n < 32 || n > 448) {
            throw new InvalidParameterException("Keysize must be multiple of 8, and can only range from 32 to 448 (inclusive)");
        }
        this.keysize = n / 8;
        this.engineInit(secureRandom);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.random == null) {
            this.random = SunJCE.RANDOM;
        }
        byte[] byArray = new byte[this.keysize];
        this.random.nextBytes(byArray);
        return new SecretKeySpec(byArray, "Blowfish");
    }
}

