/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http.logging;

import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpLogFormatter
extends SimpleFormatter {
    private static volatile Pattern pattern = null;
    private static volatile Pattern cpattern = null;

    public HttpLogFormatter() {
        if (pattern == null) {
            pattern = Pattern.compile("\\{[^\\}]*\\}");
            cpattern = Pattern.compile("[^,\\] ]{2,}");
        }
    }

    @Override
    public String format(LogRecord logRecord) {
        String string = logRecord.getSourceClassName();
        if (string == null || !string.startsWith("sun.net.www.protocol.http") && !string.startsWith("sun.net.www.http")) {
            return super.format(logRecord);
        }
        String string2 = logRecord.getMessage();
        StringBuilder stringBuilder = new StringBuilder("HTTP: ");
        if (string2.startsWith("sun.net.www.MessageHeader@")) {
            Matcher matcher = pattern.matcher(string2);
            while (matcher.find()) {
                int n;
                int n2 = matcher.start();
                String string3 = string2.substring(n2 + 1, (n = matcher.end()) - 1);
                if (string3.startsWith("null: ")) {
                    string3 = string3.substring(6);
                }
                if (string3.endsWith(": null")) {
                    string3 = string3.substring(0, string3.length() - 6);
                }
                stringBuilder.append("\t").append(string3).append("\n");
            }
        } else if (string2.startsWith("Cookies retrieved: {")) {
            String string4 = string2.substring(20);
            stringBuilder.append("Cookies from handler:\n");
            while (string4.length() >= 7) {
                String string5;
                int n;
                int n3;
                Matcher matcher;
                int n4;
                String string6;
                if (string4.startsWith("Cookie=[")) {
                    string6 = string4.substring(8);
                    n4 = string6.indexOf("Cookie2=[");
                    if (n4 > 0) {
                        string6 = string6.substring(0, n4 - 1);
                        string4 = string6.substring(n4);
                    } else {
                        string4 = "";
                    }
                    if (string6.length() < 4) continue;
                    matcher = cpattern.matcher(string6);
                    while (matcher.find()) {
                        n3 = matcher.start();
                        n = matcher.end();
                        if (n3 < 0) continue;
                        string5 = string6.substring(n3 + 1, n > 0 ? n - 1 : string6.length() - 1);
                        stringBuilder.append("\t").append(string5).append("\n");
                    }
                }
                if (!string4.startsWith("Cookie2=[")) continue;
                string6 = string4.substring(9);
                n4 = string6.indexOf("Cookie=[");
                if (n4 > 0) {
                    string6 = string6.substring(0, n4 - 1);
                    string4 = string6.substring(n4);
                } else {
                    string4 = "";
                }
                matcher = cpattern.matcher(string6);
                while (matcher.find()) {
                    n3 = matcher.start();
                    n = matcher.end();
                    if (n3 < 0) continue;
                    string5 = string6.substring(n3 + 1, n > 0 ? n - 1 : string6.length() - 1);
                    stringBuilder.append("\t").append(string5).append("\n");
                }
            }
        } else {
            stringBuilder.append(string2).append("\n");
        }
        return stringBuilder.toString();
    }
}

