/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import sun.reflect.annotation.AnnotationSupport;

public final class Parameter
implements AnnotatedElement {
    private final String name;
    private final int modifiers;
    private final Executable executable;
    private final int index;
    private volatile transient Type parameterTypeCache = null;
    private volatile transient Class<?> parameterClassCache = null;
    private transient Map<Class<? extends Annotation>, Annotation> declaredAnnotations;

    Parameter(String string, int n, Executable executable, int n2) {
        this.name = string;
        this.modifiers = n;
        this.executable = executable;
        this.index = n2;
    }

    public boolean equals(Object object) {
        if (object instanceof Parameter) {
            Parameter parameter = (Parameter)object;
            return parameter.executable.equals(this.executable) && parameter.index == this.index;
        }
        return false;
    }

    public int hashCode() {
        return this.executable.hashCode() ^ this.index;
    }

    public boolean isNamePresent() {
        return this.executable.hasRealParameterData() && this.name != null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Type type = this.getParameterizedType();
        String string = type.getTypeName();
        stringBuilder.append(Modifier.toString(this.getModifiers()));
        if (0 != this.modifiers) {
            stringBuilder.append(' ');
        }
        if (this.isVarArgs()) {
            stringBuilder.append(string.replaceFirst("\\[\\]$", "..."));
        } else {
            stringBuilder.append(string);
        }
        stringBuilder.append(' ');
        stringBuilder.append(this.getName());
        return stringBuilder.toString();
    }

    public Executable getDeclaringExecutable() {
        return this.executable;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        if (this.name == null || this.name.equals("")) {
            return "arg" + this.index;
        }
        return this.name;
    }

    String getRealName() {
        return this.name;
    }

    public Type getParameterizedType() {
        Type type = this.parameterTypeCache;
        if (null == type) {
            this.parameterTypeCache = type = this.executable.getAllGenericParameterTypes()[this.index];
        }
        return type;
    }

    public Class<?> getType() {
        Class<?> clazz = this.parameterClassCache;
        if (null == clazz) {
            this.parameterClassCache = clazz = this.executable.getParameterTypes()[this.index];
        }
        return clazz;
    }

    public AnnotatedType getAnnotatedType() {
        return this.executable.getAnnotatedParameterTypes()[this.index];
    }

    public boolean isImplicit() {
        return Modifier.isMandated(this.getModifiers());
    }

    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    public boolean isVarArgs() {
        return this.executable.isVarArgs() && this.index == this.executable.getParameterCount() - 1;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return (T)((Annotation)clazz.cast(this.declaredAnnotations().get(clazz)));
    }

    @Override
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return AnnotationSupport.getDirectlyAndIndirectlyPresent(this.declaredAnnotations(), clazz);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.executable.getParameterAnnotations()[this.index];
    }

    @Override
    public <T extends Annotation> T getDeclaredAnnotation(Class<T> clazz) {
        return this.getAnnotation(clazz);
    }

    @Override
    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> clazz) {
        return this.getAnnotationsByType(clazz);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    private synchronized Map<Class<? extends Annotation>, Annotation> declaredAnnotations() {
        if (null == this.declaredAnnotations) {
            this.declaredAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
            Annotation[] annotationArray = this.getDeclaredAnnotations();
            for (int i = 0; i < annotationArray.length; ++i) {
                this.declaredAnnotations.put(annotationArray[i].annotationType(), annotationArray[i]);
            }
        }
        return this.declaredAnnotations;
    }
}

