/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.APOptions;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.Ticket;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class APReq {
    public int pvno;
    public int msgType;
    public APOptions apOptions;
    public Ticket ticket;
    public EncryptedData authenticator;

    public APReq(APOptions aPOptions, Ticket ticket, EncryptedData encryptedData) {
        this.pvno = 5;
        this.msgType = 14;
        this.apOptions = aPOptions;
        this.ticket = ticket;
        this.authenticator = encryptedData;
    }

    public APReq(byte[] byArray) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        this.init(new DerValue(byArray));
    }

    public APReq(DerValue derValue) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        this.init(derValue);
    }

    private void init(DerValue derValue) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        if ((derValue.getTag() & 0x1F) != 14 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.pvno = derValue3.getData().getBigInteger().intValue();
        if (this.pvno != 5) {
            throw new KrbApErrException(39);
        }
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.msgType = derValue3.getData().getBigInteger().intValue();
        if (this.msgType != 14) {
            throw new KrbApErrException(40);
        }
        this.apOptions = APOptions.parse(derValue2.getData(), (byte)2, false);
        this.ticket = Ticket.parse(derValue2.getData(), (byte)3, false);
        this.authenticator = EncryptedData.parse(derValue2.getData(), (byte)4, false);
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.pvno));
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.msgType));
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)2), this.apOptions.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)3), this.ticket.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)4), this.authenticator.asn1Encode());
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write(DerValue.createTag((byte)64, true, (byte)14), derOutputStream2);
        return derOutputStream3.toByteArray();
    }
}

