/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerProvider;
import javax.management.remote.JMXProviderException;
import javax.management.remote.JMXServiceURL;

public class JMXConnectorServerFactory {
    public static final String DEFAULT_CLASS_LOADER = "jmx.remote.default.class.loader";
    public static final String DEFAULT_CLASS_LOADER_NAME = "jmx.remote.default.class.loader.name";
    public static final String PROTOCOL_PROVIDER_PACKAGES = "jmx.remote.protocol.provider.pkgs";
    public static final String PROTOCOL_PROVIDER_CLASS_LOADER = "jmx.remote.protocol.provider.class.loader";
    private static final String PROTOCOL_PROVIDER_DEFAULT_PACKAGE = "com.sun.jmx.remote.protocol";
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "JMXConnectorServerFactory");

    private JMXConnectorServerFactory() {
    }

    private static JMXConnectorServer getConnectorServerAsService(ClassLoader classLoader, JMXServiceURL jMXServiceURL, Map<String, ?> map, MBeanServer mBeanServer) throws IOException {
        Iterator<JMXConnectorServerProvider> iterator = JMXConnectorFactory.getProviderIterator(JMXConnectorServerProvider.class, classLoader);
        IOException iOException = null;
        while (iterator.hasNext()) {
            try {
                return iterator.next().newJMXConnectorServer(jMXServiceURL, map, mBeanServer);
            }
            catch (JMXProviderException jMXProviderException) {
                throw jMXProviderException;
            }
            catch (Exception exception) {
                if (logger.traceOn()) {
                    logger.trace("getConnectorAsService", "URL[" + jMXServiceURL + "] Service provider exception: " + exception);
                }
                if (exception instanceof MalformedURLException || iOException != null) continue;
                if (exception instanceof IOException) {
                    iOException = (IOException)exception;
                    continue;
                }
                iOException = EnvHelp.initCause(new IOException(exception.getMessage()), exception);
            }
        }
        if (iOException == null) {
            return null;
        }
        throw iOException;
    }

    public static JMXConnectorServer newJMXConnectorServer(JMXServiceURL jMXServiceURL, Map<String, ?> map, MBeanServer mBeanServer) throws IOException {
        Object object;
        Map<Object, Object> map2;
        if (map == null) {
            map2 = new HashMap();
        } else {
            EnvHelp.checkAttributes(map);
            map2 = new HashMap(map);
        }
        Class<JMXConnectorServerProvider> clazz = JMXConnectorServerProvider.class;
        ClassLoader classLoader = JMXConnectorFactory.resolveClassLoader(map2);
        String string = jMXServiceURL.getProtocol();
        JMXConnectorServerProvider jMXConnectorServerProvider = JMXConnectorFactory.getProvider(jMXServiceURL, map2, "ServerProvider", clazz, classLoader);
        IOException iOException = null;
        if (jMXConnectorServerProvider == null) {
            if (classLoader != null) {
                try {
                    object = JMXConnectorServerFactory.getConnectorServerAsService(classLoader, jMXServiceURL, map2, mBeanServer);
                    if (object != null) {
                        return object;
                    }
                }
                catch (JMXProviderException jMXProviderException) {
                    throw jMXProviderException;
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                }
            }
            jMXConnectorServerProvider = JMXConnectorFactory.getProvider(string, PROTOCOL_PROVIDER_DEFAULT_PACKAGE, JMXConnectorFactory.class.getClassLoader(), "ServerProvider", clazz);
        }
        if (jMXConnectorServerProvider == null) {
            object = new MalformedURLException("Unsupported protocol: " + string);
            if (iOException == null) {
                throw object;
            }
            throw (MalformedURLException)EnvHelp.initCause(object, iOException);
        }
        map2 = Collections.unmodifiableMap(map2);
        return jMXConnectorServerProvider.newJMXConnectorServer(jMXServiceURL, map2, mBeanServer);
    }
}

