/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.text.normalizer.ICUBinary;

final class NormalizerDataReader
implements ICUBinary.Authenticate {
    private DataInputStream dataInputStream;
    private byte[] unicodeVersion;
    private static final byte[] DATA_FORMAT_ID = new byte[]{78, 111, 114, 109};
    private static final byte[] DATA_FORMAT_VERSION = new byte[]{2, 2, 5, 2};

    protected NormalizerDataReader(InputStream inputStream) throws IOException {
        this.unicodeVersion = ICUBinary.readHeader(inputStream, DATA_FORMAT_ID, this);
        this.dataInputStream = new DataInputStream(inputStream);
    }

    protected int[] readIndexes(int n) throws IOException {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.dataInputStream.readInt();
        }
        return nArray;
    }

    protected void read(byte[] byArray, byte[] byArray2, byte[] byArray3, char[] cArray, char[] cArray2) throws IOException {
        int n;
        this.dataInputStream.readFully(byArray);
        for (n = 0; n < cArray.length; ++n) {
            cArray[n] = this.dataInputStream.readChar();
        }
        for (n = 0; n < cArray2.length; ++n) {
            cArray2[n] = this.dataInputStream.readChar();
        }
        this.dataInputStream.readFully(byArray2);
        this.dataInputStream.readFully(byArray3);
    }

    public byte[] getDataFormatVersion() {
        return DATA_FORMAT_VERSION;
    }

    @Override
    public boolean isDataVersionAcceptable(byte[] byArray) {
        return byArray[0] == DATA_FORMAT_VERSION[0] && byArray[2] == DATA_FORMAT_VERSION[2] && byArray[3] == DATA_FORMAT_VERSION[3];
    }

    public byte[] getUnicodeVersion() {
        return this.unicodeVersion;
    }
}

