/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class BlockView
extends BoxView {
    private AttributeSet attr;
    private StyleSheet.BoxPainter painter;
    private CSS.LengthValue cssWidth;
    private CSS.LengthValue cssHeight;

    public BlockView(Element element, int n) {
        super(element, n);
    }

    @Override
    public void setParent(View view) {
        super.setParent(view);
        if (view != null) {
            this.setPropertiesFromAttributes();
        }
    }

    @Override
    protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        if (!BlockView.spanSetFromAttributes(n, sizeRequirements, this.cssWidth, this.cssHeight)) {
            sizeRequirements = super.calculateMajorAxisRequirements(n, sizeRequirements);
        } else {
            SizeRequirements sizeRequirements2 = super.calculateMajorAxisRequirements(n, null);
            int n2 = n == 0 ? this.getLeftInset() + this.getRightInset() : this.getTopInset() + this.getBottomInset();
            sizeRequirements.minimum -= n2;
            sizeRequirements.preferred -= n2;
            sizeRequirements.maximum -= n2;
            this.constrainSize(n, sizeRequirements, sizeRequirements2);
        }
        return sizeRequirements;
    }

    @Override
    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        Object object;
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        if (!BlockView.spanSetFromAttributes(n, sizeRequirements, this.cssWidth, this.cssHeight)) {
            sizeRequirements = super.calculateMinorAxisRequirements(n, sizeRequirements);
        } else {
            object = super.calculateMinorAxisRequirements(n, null);
            int n2 = n == 0 ? this.getLeftInset() + this.getRightInset() : this.getTopInset() + this.getBottomInset();
            sizeRequirements.minimum -= n2;
            sizeRequirements.preferred -= n2;
            sizeRequirements.maximum -= n2;
            this.constrainSize(n, sizeRequirements, (SizeRequirements)object);
        }
        if (n == 0 && (object = this.getAttributes().getAttribute(CSS.Attribute.TEXT_ALIGN)) != null) {
            String string = object.toString();
            sizeRequirements.alignment = string.equals("center") ? 0.5f : (string.equals("right") ? 1.0f : 0.0f);
        }
        return sizeRequirements;
    }

    boolean isPercentage(int n, AttributeSet attributeSet) {
        if (n == 0) {
            if (this.cssWidth != null) {
                return this.cssWidth.isPercentage();
            }
        } else if (this.cssHeight != null) {
            return this.cssHeight.isPercentage();
        }
        return false;
    }

    static boolean spanSetFromAttributes(int n, SizeRequirements sizeRequirements, CSS.LengthValue lengthValue, CSS.LengthValue lengthValue2) {
        if (n == 0) {
            if (lengthValue != null && !lengthValue.isPercentage()) {
                sizeRequirements.preferred = sizeRequirements.maximum = (int)lengthValue.getValue();
                sizeRequirements.minimum = sizeRequirements.maximum;
                return true;
            }
        } else if (lengthValue2 != null && !lengthValue2.isPercentage()) {
            sizeRequirements.preferred = sizeRequirements.maximum = (int)lengthValue2.getValue();
            sizeRequirements.minimum = sizeRequirements.maximum;
            return true;
        }
        return false;
    }

    @Override
    protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = this.getViewCount();
        CSS.Attribute attribute = n2 == 0 ? CSS.Attribute.WIDTH : CSS.Attribute.HEIGHT;
        for (int i = 0; i < n3; ++i) {
            View view = this.getView(i);
            int n4 = (int)view.getMinimumSpan(n2);
            AttributeSet attributeSet = view.getAttributes();
            CSS.LengthValue lengthValue = (CSS.LengthValue)attributeSet.getAttribute(attribute);
            int n5 = lengthValue != null && lengthValue.isPercentage() ? (n4 = Math.max((int)lengthValue.getValue(n), n4)) : (int)view.getMaximumSpan(n2);
            if (n5 < n) {
                float f = view.getAlignment(n2);
                nArray[i] = (int)((float)(n - n5) * f);
                nArray2[i] = n5;
                continue;
            }
            nArray[i] = 0;
            nArray2[i] = Math.max(n4, n);
        }
    }

    @Override
    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = (Rectangle)shape;
        this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        super.paint(graphics, rectangle);
    }

    @Override
    public AttributeSet getAttributes() {
        if (this.attr == null) {
            StyleSheet styleSheet = this.getStyleSheet();
            this.attr = styleSheet.getViewAttributes(this);
        }
        return this.attr;
    }

    @Override
    public int getResizeWeight(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    @Override
    public float getAlignment(int n) {
        switch (n) {
            case 0: {
                return 0.0f;
            }
            case 1: {
                if (this.getViewCount() == 0) {
                    return 0.0f;
                }
                float f = this.getPreferredSpan(1);
                View view = this.getView(0);
                float f2 = view.getPreferredSpan(1);
                float f3 = (int)f != 0 ? f2 * view.getAlignment(1) / f : 0.0f;
                return f3;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, viewFactory);
        int n = documentEvent.getOffset();
        if (n <= this.getStartOffset() && n + documentEvent.getLength() >= this.getEndOffset()) {
            this.setPropertiesFromAttributes();
        }
    }

    @Override
    public float getPreferredSpan(int n) {
        return super.getPreferredSpan(n);
    }

    @Override
    public float getMinimumSpan(int n) {
        return super.getMinimumSpan(n);
    }

    @Override
    public float getMaximumSpan(int n) {
        return super.getMaximumSpan(n);
    }

    protected void setPropertiesFromAttributes() {
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
        this.painter = styleSheet.getBoxPainter(this.attr);
        if (this.attr != null) {
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
        }
        this.cssWidth = (CSS.LengthValue)this.attr.getAttribute(CSS.Attribute.WIDTH);
        this.cssHeight = (CSS.LengthValue)this.attr.getAttribute(CSS.Attribute.HEIGHT);
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    private void constrainSize(int n, SizeRequirements sizeRequirements, SizeRequirements sizeRequirements2) {
        if (sizeRequirements2.minimum > sizeRequirements.minimum) {
            sizeRequirements.minimum = sizeRequirements.preferred = sizeRequirements2.minimum;
            sizeRequirements.maximum = Math.max(sizeRequirements.maximum, sizeRequirements2.maximum);
        }
    }
}

