/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.text.Bidi;

public final class BidiUtils {
    static final char NUMLEVELS = '>';

    public static void getLevels(Bidi bidi, byte[] byArray, int n) {
        int n2 = n + bidi.getLength();
        if (n < 0 || n2 > byArray.length) {
            throw new IndexOutOfBoundsException("levels.length = " + byArray.length + " start: " + n + " limit: " + n2);
        }
        int n3 = bidi.getRunCount();
        int n4 = n;
        for (int i = 0; i < n3; ++i) {
            int n5 = n + bidi.getRunLimit(i);
            byte by = (byte)bidi.getRunLevel(i);
            while (n4 < n5) {
                byArray[n4++] = by;
            }
        }
    }

    public static byte[] getLevels(Bidi bidi) {
        byte[] byArray = new byte[bidi.getLength()];
        BidiUtils.getLevels(bidi, byArray, 0);
        return byArray;
    }

    /*
     * Unable to fully structure code
     */
    public static int[] createVisualToLogicalMap(byte[] var0) {
        var1_1 = var0.length;
        var2_2 = new int[var1_1];
        var3_3 = 63;
        var4_4 = 0;
        for (var5_5 = 0; var5_5 < var1_1; ++var5_5) {
            var2_2[var5_5] = var5_5;
            var6_6 = var0[var5_5];
            if (var6_6 > var4_4) {
                var4_4 = var6_6;
            }
            if ((var6_6 & 1) == 0 || var6_6 >= var3_3) continue;
            var3_3 = var6_6;
        }
        while (var4_4 >= var3_3) {
            var5_5 = 0;
            block2: while (true) {
                if (var5_5 < var1_1 && var0[var5_5] < var4_4) {
                    ++var5_5;
                    continue;
                }
                if ((var6_6 = var5_5++) == var0.length) break;
                while (var5_5 < var1_1 && var0[var5_5] >= var4_4) {
                    ++var5_5;
                }
                var7_7 = var5_5 - 1;
                while (true) {
                    if (var6_6 < var7_7) ** break;
                    continue block2;
                    var8_8 = var2_2[var6_6];
                    var2_2[var6_6] = var2_2[var7_7];
                    var2_2[var7_7] = var8_8;
                    ++var6_6;
                    --var7_7;
                }
                break;
            }
            var4_4 = (byte)(var4_4 - 1);
        }
        return var2_2;
    }

    public static int[] createInverseMap(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[nArray[i]] = i;
        }
        return nArray2;
    }

    public static int[] createContiguousOrder(int[] nArray) {
        if (nArray != null) {
            return BidiUtils.computeContiguousOrder(nArray, 0, nArray.length);
        }
        return null;
    }

    private static int[] computeContiguousOrder(int[] nArray, int n, int n2) {
        int n3;
        int[] nArray2 = new int[n2 - n];
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            nArray2[n3] = n3 + n;
        }
        for (n3 = 0; n3 < nArray2.length - 1; ++n3) {
            int n4;
            int n5 = n3;
            int n6 = nArray[nArray2[n5]];
            for (n4 = n3; n4 < nArray2.length; ++n4) {
                if (nArray[nArray2[n4]] >= n6) continue;
                n5 = n4;
                n6 = nArray[nArray2[n5]];
            }
            n4 = nArray2[n3];
            nArray2[n3] = nArray2[n5];
            nArray2[n5] = n4;
        }
        if (n != 0) {
            n3 = 0;
            while (n3 < nArray2.length) {
                int n7 = n3++;
                nArray2[n7] = nArray2[n7] - n;
            }
        }
        for (n3 = 0; n3 < nArray2.length && nArray2[n3] == n3; ++n3) {
        }
        if (n3 == nArray2.length) {
            return null;
        }
        return BidiUtils.createInverseMap(nArray2);
    }

    public static int[] createNormalizedMap(int[] nArray, byte[] byArray, int n, int n2) {
        if (nArray != null) {
            if (n != 0 || n2 != nArray.length) {
                boolean bl;
                boolean bl2;
                byte by;
                if (byArray == null) {
                    by = 0;
                    bl2 = true;
                    bl = true;
                } else if (byArray[n] == byArray[n2 - 1]) {
                    int n3;
                    by = byArray[n];
                    bl = (by & 1) == 0;
                    for (n3 = n; n3 < n2 && byArray[n3] >= by; ++n3) {
                        if (!bl) continue;
                        bl = byArray[n3] == by;
                    }
                    bl2 = n3 == n2;
                } else {
                    bl2 = false;
                    by = 0;
                    bl = false;
                }
                if (bl2) {
                    if (bl) {
                        return null;
                    }
                    int[] nArray2 = new int[n2 - n];
                    int n4 = (by & 1) != 0 ? nArray[n2 - 1] : nArray[n];
                    if (n4 == 0) {
                        System.arraycopy(nArray, n, nArray2, 0, n2 - n);
                    } else {
                        for (int i = 0; i < nArray2.length; ++i) {
                            nArray2[i] = nArray[i + n] - n4;
                        }
                    }
                    return nArray2;
                }
                return BidiUtils.computeContiguousOrder(nArray, n, n2);
            }
            return nArray;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static void reorderVisually(byte[] var0, Object[] var1_1) {
        var2_2 = var0.length;
        var3_3 = 63;
        var4_4 = 0;
        for (var5_5 = 0; var5_5 < var2_2; ++var5_5) {
            var6_6 = var0[var5_5];
            if (var6_6 > var4_4) {
                var4_4 = var6_6;
            }
            if ((var6_6 & 1) == 0 || var6_6 >= var3_3) continue;
            var3_3 = var6_6;
        }
        while (var4_4 >= var3_3) {
            var5_5 = 0;
            block2: while (true) {
                if (var5_5 < var2_2 && var0[var5_5] < var4_4) {
                    ++var5_5;
                    continue;
                }
                if ((var6_6 = var5_5++) == var0.length) break;
                while (var5_5 < var2_2 && var0[var5_5] >= var4_4) {
                    ++var5_5;
                }
                var7_7 = var5_5 - 1;
                while (true) {
                    if (var6_6 < var7_7) ** break;
                    continue block2;
                    var8_8 = var1_1[var6_6];
                    var1_1[var6_6] = var1_1[var7_7];
                    var1_1[var7_7] = var8_8;
                    ++var6_6;
                    --var7_7;
                }
                break;
            }
            var4_4 = (byte)(var4_4 - 1);
        }
    }
}

