/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.CRenderer;
import sun.java2d.OSXSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.loops.XORComposite;
import sun.java2d.pipe.DrawImagePipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.TextPipe;

public class CompositeCRenderer
extends CRenderer
implements PixelDrawPipe,
PixelFillPipe,
ShapeDrawPipe,
DrawImagePipe,
TextPipe {
    static final int fPadding = 4;
    static final int fPaddingHalf = 2;
    private static AffineTransform sIdentityMatrix = new AffineTransform();
    AffineTransform ShapeTM = new AffineTransform();
    Rectangle2D ShapeBounds = new Rectangle2D.Float();
    Line2D line = new Line2D.Float();
    Rectangle2D rectangle = new Rectangle2D.Float();
    RoundRectangle2D roundrectangle = new RoundRectangle2D.Float();
    Ellipse2D ellipse = new Ellipse2D.Float();
    Arc2D arc = new Arc2D.Float();

    @Override
    public synchronized void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.line.setLine(n, n2, n3, n4);
        this.draw(sunGraphics2D, this.line);
    }

    @Override
    public synchronized void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.rectangle.setRect(n, n2, n3, n4);
        this.draw(sunGraphics2D, this.rectangle);
    }

    @Override
    public synchronized void drawRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.roundrectangle.setRoundRect(n, n2, n3, n4, n5, n6);
        this.draw(sunGraphics2D, this.roundrectangle);
    }

    @Override
    public synchronized void drawOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.ellipse.setFrame(n, n2, n3, n4);
        this.draw(sunGraphics2D, this.ellipse);
    }

    @Override
    public synchronized void drawArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.arc.setArc(n, n2, n3, n4, n5, n6, 0);
        this.draw(sunGraphics2D, this.arc);
    }

    @Override
    public synchronized void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.doPolygon(sunGraphics2D, nArray, nArray2, n, false, false);
    }

    @Override
    public synchronized void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.doPolygon(sunGraphics2D, nArray, nArray2, n, true, false);
    }

    @Override
    public synchronized void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.rectangle.setRect(n, n2, n3, n4);
        this.fill(sunGraphics2D, this.rectangle);
    }

    @Override
    public synchronized void fillRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.roundrectangle.setRoundRect(n, n2, n3, n4, n5, n6);
        this.fill(sunGraphics2D, this.roundrectangle);
    }

    @Override
    public synchronized void fillOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.ellipse.setFrame(n, n2, n3, n4);
        this.fill(sunGraphics2D, this.ellipse);
    }

    @Override
    public synchronized void fillArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.arc.setArc(n, n2, n3, n4, n5, n6, 2);
        this.fill(sunGraphics2D, this.arc);
    }

    @Override
    public synchronized void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.doPolygon(sunGraphics2D, nArray, nArray2, n, true, true);
    }

    public synchronized void doPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
        GeneralPath generalPath = new GeneralPath(1, n);
        generalPath.moveTo(nArray[0], nArray2[0]);
        for (int i = 1; i < n; ++i) {
            generalPath.lineTo(nArray[i], nArray2[i]);
        }
        if (bl && (nArray[0] != nArray[n - 1] || nArray2[0] != nArray2[n - 1])) {
            generalPath.lineTo(nArray[0], nArray2[0]);
        }
        this.doShape(sunGraphics2D, (OSXSurfaceData)sunGraphics2D.getSurfaceData(), generalPath, bl2);
    }

    @Override
    public synchronized void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        this.doShape(sunGraphics2D, (OSXSurfaceData)sunGraphics2D.getSurfaceData(), shape, false);
    }

    @Override
    public synchronized void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        this.doShape(sunGraphics2D, (OSXSurfaceData)sunGraphics2D.getSurfaceData(), shape, true);
    }

    void doShape(SunGraphics2D sunGraphics2D, OSXSurfaceData oSXSurfaceData, Shape shape, boolean bl) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        if (rectangle2D.getWidth() < 0.0 || rectangle2D.getHeight() < 0.0) {
            return;
        }
        Rectangle2D rectangle2D2 = this.padBounds(sunGraphics2D, shape);
        this.clipBounds(sunGraphics2D, rectangle2D2);
        if (!rectangle2D2.isEmpty()) {
            BufferedImage bufferedImage = oSXSurfaceData.getCompositingSrcImage((int)rectangle2D2.getWidth(), (int)rectangle2D2.getHeight());
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.ShapeTM.setToTranslation(-rectangle2D2.getX(), -rectangle2D2.getY());
            this.ShapeTM.concatenate(sunGraphics2D.transform);
            graphics2D.setTransform(this.ShapeTM);
            graphics2D.setRenderingHints(sunGraphics2D.getRenderingHints());
            graphics2D.setPaint(sunGraphics2D.getPaint());
            graphics2D.setStroke(sunGraphics2D.getStroke());
            if (bl) {
                graphics2D.fill(shape);
            } else {
                graphics2D.draw(shape);
            }
            graphics2D.dispose();
            this.composite(sunGraphics2D, oSXSurfaceData, bufferedImage, rectangle2D2);
        }
    }

    @Override
    public synchronized void drawString(SunGraphics2D sunGraphics2D, String string, double d, double d2) {
        this.drawGlyphVector(sunGraphics2D, sunGraphics2D.getFont().createGlyphVector(sunGraphics2D.getFontRenderContext(), string), d, d2);
    }

    @Override
    public synchronized void drawChars(SunGraphics2D sunGraphics2D, char[] cArray, int n, int n2, int n3, int n4) {
        this.drawString(sunGraphics2D, new String(cArray, n, n2), n3, n4);
    }

    public synchronized void drawGlyphVector(SunGraphics2D sunGraphics2D, GlyphVector glyphVector, double d, double d2) {
        this.drawGlyphVector(sunGraphics2D, glyphVector, (float)d, (float)d2);
    }

    @Override
    public synchronized void drawGlyphVector(SunGraphics2D sunGraphics2D, GlyphVector glyphVector, float f, float f2) {
        OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
        Shape shape = glyphVector.getOutline(f, f2);
        Rectangle2D rectangle2D = this.padBounds(sunGraphics2D, shape);
        this.clipBounds(sunGraphics2D, rectangle2D);
        if (!rectangle2D.isEmpty()) {
            BufferedImage bufferedImage = oSXSurfaceData.getCompositingSrcImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.ShapeTM.setToTranslation(-rectangle2D.getX(), -rectangle2D.getY());
            this.ShapeTM.concatenate(sunGraphics2D.transform);
            graphics2D.setTransform(this.ShapeTM);
            graphics2D.setPaint(sunGraphics2D.getPaint());
            graphics2D.setStroke(sunGraphics2D.getStroke());
            graphics2D.setFont(sunGraphics2D.getFont());
            graphics2D.setRenderingHints(sunGraphics2D.getRenderingHints());
            graphics2D.drawGlyphVector(glyphVector, f, f2);
            graphics2D.dispose();
            this.composite(sunGraphics2D, oSXSurfaceData, bufferedImage, rectangle2D);
        }
    }

    @Override
    protected boolean blitImage(SunGraphics2D sunGraphics2D, Image image, boolean bl, boolean bl2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color) {
        boolean bl3;
        OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
        n5 = !bl2 ? n5 : n5 - n7;
        n6 = !bl ? n6 : n6 - n8;
        this.ShapeBounds.setFrame(n5, n6, n7, n8);
        Rectangle2D rectangle2D = this.ShapeBounds;
        boolean bl4 = bl3 = sunGraphics2D.transformState >= 3;
        if (!bl3) {
            double d = Math.floor(rectangle2D.getX() + (double)sunGraphics2D.transX);
            double d2 = Math.floor(rectangle2D.getY() + (double)sunGraphics2D.transY);
            double d3 = Math.ceil(rectangle2D.getWidth()) + (double)(d < rectangle2D.getX() ? 1 : 0);
            double d4 = Math.ceil(rectangle2D.getHeight()) + (double)(d2 < rectangle2D.getY() ? 1 : 0);
            rectangle2D.setRect(d, d2, d3, d4);
        } else {
            Shape shape = sunGraphics2D.transform.createTransformedShape(rectangle2D);
            rectangle2D = shape.getBounds2D();
            double d = Math.floor(rectangle2D.getX());
            double d5 = Math.floor(rectangle2D.getY());
            double d6 = Math.ceil(rectangle2D.getWidth()) + (double)(d < rectangle2D.getX() ? 1 : 0);
            double d7 = Math.ceil(rectangle2D.getHeight()) + (double)(d5 < rectangle2D.getY() ? 1 : 0);
            rectangle2D.setRect(d, d5, d6, d7);
        }
        this.clipBounds(sunGraphics2D, rectangle2D);
        if (!rectangle2D.isEmpty()) {
            BufferedImage bufferedImage = oSXSurfaceData.getCompositingSrcImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.ShapeTM.setToTranslation(-rectangle2D.getX(), -rectangle2D.getY());
            this.ShapeTM.concatenate(sunGraphics2D.transform);
            graphics2D.setTransform(this.ShapeTM);
            graphics2D.setRenderingHints(sunGraphics2D.getRenderingHints());
            graphics2D.setComposite(AlphaComposite.Src);
            int n9 = !bl2 ? n + n3 : n - n3;
            int n10 = !bl ? n2 + n4 : n2 - n4;
            graphics2D.drawImage(image, n5, n6, n5 + n7, n6 + n8, n, n2, n9, n10, null);
            graphics2D.dispose();
            this.composite(sunGraphics2D, oSXSurfaceData, bufferedImage, rectangle2D);
        }
        return true;
    }

    Rectangle2D padBounds(SunGraphics2D sunGraphics2D, Shape shape) {
        shape = sunGraphics2D.transformShape(shape);
        int n = 2;
        int n2 = 4;
        if (sunGraphics2D.stroke != null) {
            if (sunGraphics2D.stroke instanceof BasicStroke) {
                int n3 = (int)(((BasicStroke)sunGraphics2D.stroke).getLineWidth() + 0.5f);
                int n4 = n3 / 2 + 1;
                n += n4;
                n2 += 2 * n4;
            } else {
                shape = sunGraphics2D.stroke.createStrokedShape(shape);
            }
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        rectangle2D.setRect(rectangle2D.getX() - (double)n, rectangle2D.getY() - (double)n, rectangle2D.getWidth() + (double)n2, rectangle2D.getHeight() + (double)n2);
        double d = Math.floor(rectangle2D.getX());
        double d2 = Math.floor(rectangle2D.getY());
        double d3 = Math.ceil(rectangle2D.getWidth()) + (double)(d < rectangle2D.getX() ? 1 : 0);
        double d4 = Math.ceil(rectangle2D.getHeight()) + (double)(d2 < rectangle2D.getY() ? 1 : 0);
        rectangle2D.setRect(d, d2, d3, d4);
        return rectangle2D;
    }

    void clipBounds(SunGraphics2D sunGraphics2D, Rectangle2D rectangle2D) {
        Region region = sunGraphics2D.clipRegion.getIntersectionXYWH((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        rectangle2D.setRect(region.getLoX(), region.getLoY(), region.getWidth(), region.getHeight());
    }

    BufferedImage getSurfacePixels(SunGraphics2D sunGraphics2D, OSXSurfaceData oSXSurfaceData, int n, int n2, int n3, int n4) {
        BufferedImage bufferedImage = oSXSurfaceData.getCompositingDstInImage(n3, n4);
        return oSXSurfaceData.copyArea(sunGraphics2D, n, n2, n3, n4, bufferedImage);
    }

    void composite(SunGraphics2D sunGraphics2D, OSXSurfaceData oSXSurfaceData, BufferedImage bufferedImage, Rectangle2D rectangle2D) {
        int n = (int)rectangle2D.getX();
        int n2 = (int)rectangle2D.getY();
        int n3 = (int)rectangle2D.getWidth();
        int n4 = (int)rectangle2D.getHeight();
        boolean bl = false;
        Composite composite = sunGraphics2D.getComposite();
        if (composite instanceof XORComposite) {
            try {
                bl = oSXSurfaceData.xorSurfacePixels(sunGraphics2D, bufferedImage, n, n2, n3, n4, ((XORComposite)composite).getXorColor().getRGB());
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        if (!bl) {
            Object object;
            Object object2;
            BufferedImage bufferedImage2 = this.getSurfacePixels(sunGraphics2D, oSXSurfaceData, n, n2, n3, n4);
            BufferedImage bufferedImage3 = null;
            if (composite instanceof XORComposite) {
                try {
                    object2 = (OSXSurfaceData)BufImgSurfaceData.createData(bufferedImage2);
                    bl = ((OSXSurfaceData)object2).xorSurfacePixels(sunGraphics2D, bufferedImage, 0, 0, n3, n4, ((XORComposite)composite).getXorColor().getRGB());
                    bufferedImage3 = bufferedImage2;
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            if (!bl) {
                bufferedImage3 = oSXSurfaceData.getCompositingDstOutImage(n3, n4);
                object2 = bufferedImage.getRaster();
                object = bufferedImage2.getRaster();
                WritableRaster writableRaster = bufferedImage3.getRaster();
                CompositeContext compositeContext = composite.createContext(bufferedImage.getColorModel(), bufferedImage3.getColorModel(), sunGraphics2D.getRenderingHints());
                compositeContext.compose((Raster)object2, (Raster)object, writableRaster);
                compositeContext.dispose();
            }
            object2 = sunGraphics2D.getComposite();
            object = sunGraphics2D.getTransform();
            int n5 = sunGraphics2D.constrainX;
            int n6 = sunGraphics2D.constrainY;
            sunGraphics2D.setComposite(AlphaComposite.SrcOver);
            sunGraphics2D.constrainX = 0;
            sunGraphics2D.constrainY = 0;
            sunGraphics2D.setTransform(sIdentityMatrix);
            sunGraphics2D.drawImage(bufferedImage3, n, n2, n + n3, n2 + n4, 0, 0, n3, n4, null);
            sunGraphics2D.constrainX = n5;
            sunGraphics2D.constrainY = n6;
            sunGraphics2D.setTransform((AffineTransform)object);
            sunGraphics2D.setComposite((Composite)object2);
        }
    }
}

