/*
 * Copyright (C) 2017  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef _gc_9_1_SH_MASK_HEADER
#define _gc_9_1_SH_MASK_HEADER


// addressBlock: gc_grbmdec
//GRBM_CNTL
#define GRBM_CNTL__READ_TIMEOUT__SHIFT                                                                        0x0
#define GRBM_CNTL__REPORT_LAST_RDERR__SHIFT                                                                   0x1f
#define GRBM_CNTL__READ_TIMEOUT_MASK                                                                          0x000000FFL
#define GRBM_CNTL__REPORT_LAST_RDERR_MASK                                                                     0x80000000L
//GRBM_SKEW_CNTL
#define GRBM_SKEW_CNTL__SKEW_TOP_THRESHOLD__SHIFT                                                             0x0
#define GRBM_SKEW_CNTL__SKEW_COUNT__SHIFT                                                                     0x6
#define GRBM_SKEW_CNTL__SKEW_TOP_THRESHOLD_MASK                                                               0x0000003FL
#define GRBM_SKEW_CNTL__SKEW_COUNT_MASK                                                                       0x00000FC0L
//GRBM_STATUS2
#define GRBM_STATUS2__ME0PIPE1_CMDFIFO_AVAIL__SHIFT                                                           0x0
#define GRBM_STATUS2__ME0PIPE1_CF_RQ_PENDING__SHIFT                                                           0x4
#define GRBM_STATUS2__ME0PIPE1_PF_RQ_PENDING__SHIFT                                                           0x5
#define GRBM_STATUS2__ME1PIPE0_RQ_PENDING__SHIFT                                                              0x6
#define GRBM_STATUS2__ME1PIPE1_RQ_PENDING__SHIFT                                                              0x7
#define GRBM_STATUS2__ME1PIPE2_RQ_PENDING__SHIFT                                                              0x8
#define GRBM_STATUS2__ME1PIPE3_RQ_PENDING__SHIFT                                                              0x9
#define GRBM_STATUS2__ME2PIPE0_RQ_PENDING__SHIFT                                                              0xa
#define GRBM_STATUS2__ME2PIPE1_RQ_PENDING__SHIFT                                                              0xb
#define GRBM_STATUS2__ME2PIPE2_RQ_PENDING__SHIFT                                                              0xc
#define GRBM_STATUS2__ME2PIPE3_RQ_PENDING__SHIFT                                                              0xd
#define GRBM_STATUS2__RLC_RQ_PENDING__SHIFT                                                                   0xe
#define GRBM_STATUS2__UTCL2_BUSY__SHIFT                                                                       0xf
#define GRBM_STATUS2__EA_BUSY__SHIFT                                                                          0x10
#define GRBM_STATUS2__RMI_BUSY__SHIFT                                                                         0x11
#define GRBM_STATUS2__UTCL2_RQ_PENDING__SHIFT                                                                 0x12
#define GRBM_STATUS2__CPF_RQ_PENDING__SHIFT                                                                   0x13
#define GRBM_STATUS2__EA_LINK_BUSY__SHIFT                                                                     0x14
#define GRBM_STATUS2__RLC_BUSY__SHIFT                                                                         0x18
#define GRBM_STATUS2__TC_BUSY__SHIFT                                                                          0x19
#define GRBM_STATUS2__TCC_CC_RESIDENT__SHIFT                                                                  0x1a
#define GRBM_STATUS2__CPF_BUSY__SHIFT                                                                         0x1c
#define GRBM_STATUS2__CPC_BUSY__SHIFT                                                                         0x1d
#define GRBM_STATUS2__CPG_BUSY__SHIFT                                                                         0x1e
#define GRBM_STATUS2__CPAXI_BUSY__SHIFT                                                                       0x1f
#define GRBM_STATUS2__ME0PIPE1_CMDFIFO_AVAIL_MASK                                                             0x0000000FL
#define GRBM_STATUS2__ME0PIPE1_CF_RQ_PENDING_MASK                                                             0x00000010L
#define GRBM_STATUS2__ME0PIPE1_PF_RQ_PENDING_MASK                                                             0x00000020L
#define GRBM_STATUS2__ME1PIPE0_RQ_PENDING_MASK                                                                0x00000040L
#define GRBM_STATUS2__ME1PIPE1_RQ_PENDING_MASK                                                                0x00000080L
#define GRBM_STATUS2__ME1PIPE2_RQ_PENDING_MASK                                                                0x00000100L
#define GRBM_STATUS2__ME1PIPE3_RQ_PENDING_MASK                                                                0x00000200L
#define GRBM_STATUS2__ME2PIPE0_RQ_PENDING_MASK                                                                0x00000400L
#define GRBM_STATUS2__ME2PIPE1_RQ_PENDING_MASK                                                                0x00000800L
#define GRBM_STATUS2__ME2PIPE2_RQ_PENDING_MASK                                                                0x00001000L
#define GRBM_STATUS2__ME2PIPE3_RQ_PENDING_MASK                                                                0x00002000L
#define GRBM_STATUS2__RLC_RQ_PENDING_MASK                                                                     0x00004000L
#define GRBM_STATUS2__UTCL2_BUSY_MASK                                                                         0x00008000L
#define GRBM_STATUS2__EA_BUSY_MASK                                                                            0x00010000L
#define GRBM_STATUS2__RMI_BUSY_MASK                                                                           0x00020000L
#define GRBM_STATUS2__UTCL2_RQ_PENDING_MASK                                                                   0x00040000L
#define GRBM_STATUS2__CPF_RQ_PENDING_MASK                                                                     0x00080000L
#define GRBM_STATUS2__EA_LINK_BUSY_MASK                                                                       0x00100000L
#define GRBM_STATUS2__RLC_BUSY_MASK                                                                           0x01000000L
#define GRBM_STATUS2__TC_BUSY_MASK                                                                            0x02000000L
#define GRBM_STATUS2__TCC_CC_RESIDENT_MASK                                                                    0x04000000L
#define GRBM_STATUS2__CPF_BUSY_MASK                                                                           0x10000000L
#define GRBM_STATUS2__CPC_BUSY_MASK                                                                           0x20000000L
#define GRBM_STATUS2__CPG_BUSY_MASK                                                                           0x40000000L
#define GRBM_STATUS2__CPAXI_BUSY_MASK                                                                         0x80000000L
//GRBM_PWR_CNTL
#define GRBM_PWR_CNTL__ALL_REQ_TYPE__SHIFT                                                                    0x0
#define GRBM_PWR_CNTL__GFX_REQ_TYPE__SHIFT                                                                    0x2
#define GRBM_PWR_CNTL__ALL_RSP_TYPE__SHIFT                                                                    0x4
#define GRBM_PWR_CNTL__GFX_RSP_TYPE__SHIFT                                                                    0x6
#define GRBM_PWR_CNTL__GFX_REQ_EN__SHIFT                                                                      0xe
#define GRBM_PWR_CNTL__ALL_REQ_EN__SHIFT                                                                      0xf
#define GRBM_PWR_CNTL__ALL_REQ_TYPE_MASK                                                                      0x00000003L
#define GRBM_PWR_CNTL__GFX_REQ_TYPE_MASK                                                                      0x0000000CL
#define GRBM_PWR_CNTL__ALL_RSP_TYPE_MASK                                                                      0x00000030L
#define GRBM_PWR_CNTL__GFX_RSP_TYPE_MASK                                                                      0x000000C0L
#define GRBM_PWR_CNTL__GFX_REQ_EN_MASK                                                                        0x00004000L
#define GRBM_PWR_CNTL__ALL_REQ_EN_MASK                                                                        0x00008000L
//GRBM_STATUS
#define GRBM_STATUS__ME0PIPE0_CMDFIFO_AVAIL__SHIFT                                                            0x0
#define GRBM_STATUS__RSMU_RQ_PENDING__SHIFT                                                                   0x5
#define GRBM_STATUS__ME0PIPE0_CF_RQ_PENDING__SHIFT                                                            0x7
#define GRBM_STATUS__ME0PIPE0_PF_RQ_PENDING__SHIFT                                                            0x8
#define GRBM_STATUS__GDS_DMA_RQ_PENDING__SHIFT                                                                0x9
#define GRBM_STATUS__DB_CLEAN__SHIFT                                                                          0xc
#define GRBM_STATUS__CB_CLEAN__SHIFT                                                                          0xd
#define GRBM_STATUS__TA_BUSY__SHIFT                                                                           0xe
#define GRBM_STATUS__GDS_BUSY__SHIFT                                                                          0xf
#define GRBM_STATUS__WD_BUSY_NO_DMA__SHIFT                                                                    0x10
#define GRBM_STATUS__VGT_BUSY__SHIFT                                                                          0x11
#define GRBM_STATUS__IA_BUSY_NO_DMA__SHIFT                                                                    0x12
#define GRBM_STATUS__IA_BUSY__SHIFT                                                                           0x13
#define GRBM_STATUS__SX_BUSY__SHIFT                                                                           0x14
#define GRBM_STATUS__WD_BUSY__SHIFT                                                                           0x15
#define GRBM_STATUS__SPI_BUSY__SHIFT                                                                          0x16
#define GRBM_STATUS__BCI_BUSY__SHIFT                                                                          0x17
#define GRBM_STATUS__SC_BUSY__SHIFT                                                                           0x18
#define GRBM_STATUS__PA_BUSY__SHIFT                                                                           0x19
#define GRBM_STATUS__DB_BUSY__SHIFT                                                                           0x1a
#define GRBM_STATUS__CP_COHERENCY_BUSY__SHIFT                                                                 0x1c
#define GRBM_STATUS__CP_BUSY__SHIFT                                                                           0x1d
#define GRBM_STATUS__CB_BUSY__SHIFT                                                                           0x1e
#define GRBM_STATUS__GUI_ACTIVE__SHIFT                                                                        0x1f
#define GRBM_STATUS__ME0PIPE0_CMDFIFO_AVAIL_MASK                                                              0x0000000FL
#define GRBM_STATUS__RSMU_RQ_PENDING_MASK                                                                     0x00000020L
#define GRBM_STATUS__ME0PIPE0_CF_RQ_PENDING_MASK                                                              0x00000080L
#define GRBM_STATUS__ME0PIPE0_PF_RQ_PENDING_MASK                                                              0x00000100L
#define GRBM_STATUS__GDS_DMA_RQ_PENDING_MASK                                                                  0x00000200L
#define GRBM_STATUS__DB_CLEAN_MASK                                                                            0x00001000L
#define GRBM_STATUS__CB_CLEAN_MASK                                                                            0x00002000L
#define GRBM_STATUS__TA_BUSY_MASK                                                                             0x00004000L
#define GRBM_STATUS__GDS_BUSY_MASK                                                                            0x00008000L
#define GRBM_STATUS__WD_BUSY_NO_DMA_MASK                                                                      0x00010000L
#define GRBM_STATUS__VGT_BUSY_MASK                                                                            0x00020000L
#define GRBM_STATUS__IA_BUSY_NO_DMA_MASK                                                                      0x00040000L
#define GRBM_STATUS__IA_BUSY_MASK                                                                             0x00080000L
#define GRBM_STATUS__SX_BUSY_MASK                                                                             0x00100000L
#define GRBM_STATUS__WD_BUSY_MASK                                                                             0x00200000L
#define GRBM_STATUS__SPI_BUSY_MASK                                                                            0x00400000L
#define GRBM_STATUS__BCI_BUSY_MASK                                                                            0x00800000L
#define GRBM_STATUS__SC_BUSY_MASK                                                                             0x01000000L
#define GRBM_STATUS__PA_BUSY_MASK                                                                             0x02000000L
#define GRBM_STATUS__DB_BUSY_MASK                                                                             0x04000000L
#define GRBM_STATUS__CP_COHERENCY_BUSY_MASK                                                                   0x10000000L
#define GRBM_STATUS__CP_BUSY_MASK                                                                             0x20000000L
#define GRBM_STATUS__CB_BUSY_MASK                                                                             0x40000000L
#define GRBM_STATUS__GUI_ACTIVE_MASK                                                                          0x80000000L
//GRBM_STATUS_SE0
#define GRBM_STATUS_SE0__DB_CLEAN__SHIFT                                                                      0x1
#define GRBM_STATUS_SE0__CB_CLEAN__SHIFT                                                                      0x2
#define GRBM_STATUS_SE0__RMI_BUSY__SHIFT                                                                      0x15
#define GRBM_STATUS_SE0__BCI_BUSY__SHIFT                                                                      0x16
#define GRBM_STATUS_SE0__VGT_BUSY__SHIFT                                                                      0x17
#define GRBM_STATUS_SE0__PA_BUSY__SHIFT                                                                       0x18
#define GRBM_STATUS_SE0__TA_BUSY__SHIFT                                                                       0x19
#define GRBM_STATUS_SE0__SX_BUSY__SHIFT                                                                       0x1a
#define GRBM_STATUS_SE0__SPI_BUSY__SHIFT                                                                      0x1b
#define GRBM_STATUS_SE0__SC_BUSY__SHIFT                                                                       0x1d
#define GRBM_STATUS_SE0__DB_BUSY__SHIFT                                                                       0x1e
#define GRBM_STATUS_SE0__CB_BUSY__SHIFT                                                                       0x1f
#define GRBM_STATUS_SE0__DB_CLEAN_MASK                                                                        0x00000002L
#define GRBM_STATUS_SE0__CB_CLEAN_MASK                                                                        0x00000004L
#define GRBM_STATUS_SE0__RMI_BUSY_MASK                                                                        0x00200000L
#define GRBM_STATUS_SE0__BCI_BUSY_MASK                                                                        0x00400000L
#define GRBM_STATUS_SE0__VGT_BUSY_MASK                                                                        0x00800000L
#define GRBM_STATUS_SE0__PA_BUSY_MASK                                                                         0x01000000L
#define GRBM_STATUS_SE0__TA_BUSY_MASK                                                                         0x02000000L
#define GRBM_STATUS_SE0__SX_BUSY_MASK                                                                         0x04000000L
#define GRBM_STATUS_SE0__SPI_BUSY_MASK                                                                        0x08000000L
#define GRBM_STATUS_SE0__SC_BUSY_MASK                                                                         0x20000000L
#define GRBM_STATUS_SE0__DB_BUSY_MASK                                                                         0x40000000L
#define GRBM_STATUS_SE0__CB_BUSY_MASK                                                                         0x80000000L
//GRBM_STATUS_SE1
#define GRBM_STATUS_SE1__DB_CLEAN__SHIFT                                                                      0x1
#define GRBM_STATUS_SE1__CB_CLEAN__SHIFT                                                                      0x2
#define GRBM_STATUS_SE1__RMI_BUSY__SHIFT                                                                      0x15
#define GRBM_STATUS_SE1__BCI_BUSY__SHIFT                                                                      0x16
#define GRBM_STATUS_SE1__VGT_BUSY__SHIFT                                                                      0x17
#define GRBM_STATUS_SE1__PA_BUSY__SHIFT                                                                       0x18
#define GRBM_STATUS_SE1__TA_BUSY__SHIFT                                                                       0x19
#define GRBM_STATUS_SE1__SX_BUSY__SHIFT                                                                       0x1a
#define GRBM_STATUS_SE1__SPI_BUSY__SHIFT                                                                      0x1b
#define GRBM_STATUS_SE1__SC_BUSY__SHIFT                                                                       0x1d
#define GRBM_STATUS_SE1__DB_BUSY__SHIFT                                                                       0x1e
#define GRBM_STATUS_SE1__CB_BUSY__SHIFT                                                                       0x1f
#define GRBM_STATUS_SE1__DB_CLEAN_MASK                                                                        0x00000002L
#define GRBM_STATUS_SE1__CB_CLEAN_MASK                                                                        0x00000004L
#define GRBM_STATUS_SE1__RMI_BUSY_MASK                                                                        0x00200000L
#define GRBM_STATUS_SE1__BCI_BUSY_MASK                                                                        0x00400000L
#define GRBM_STATUS_SE1__VGT_BUSY_MASK                                                                        0x00800000L
#define GRBM_STATUS_SE1__PA_BUSY_MASK                                                                         0x01000000L
#define GRBM_STATUS_SE1__TA_BUSY_MASK                                                                         0x02000000L
#define GRBM_STATUS_SE1__SX_BUSY_MASK                                                                         0x04000000L
#define GRBM_STATUS_SE1__SPI_BUSY_MASK                                                                        0x08000000L
#define GRBM_STATUS_SE1__SC_BUSY_MASK                                                                         0x20000000L
#define GRBM_STATUS_SE1__DB_BUSY_MASK                                                                         0x40000000L
#define GRBM_STATUS_SE1__CB_BUSY_MASK                                                                         0x80000000L
//GRBM_SOFT_RESET
#define GRBM_SOFT_RESET__SOFT_RESET_CP__SHIFT                                                                 0x0
#define GRBM_SOFT_RESET__SOFT_RESET_RLC__SHIFT                                                                0x2
#define GRBM_SOFT_RESET__SOFT_RESET_GFX__SHIFT                                                                0x10
#define GRBM_SOFT_RESET__SOFT_RESET_CPF__SHIFT                                                                0x11
#define GRBM_SOFT_RESET__SOFT_RESET_CPC__SHIFT                                                                0x12
#define GRBM_SOFT_RESET__SOFT_RESET_CPG__SHIFT                                                                0x13
#define GRBM_SOFT_RESET__SOFT_RESET_CAC__SHIFT                                                                0x14
#define GRBM_SOFT_RESET__SOFT_RESET_CPAXI__SHIFT                                                              0x15
#define GRBM_SOFT_RESET__SOFT_RESET_EA__SHIFT                                                                 0x16
#define GRBM_SOFT_RESET__SOFT_RESET_CP_MASK                                                                   0x00000001L
#define GRBM_SOFT_RESET__SOFT_RESET_RLC_MASK                                                                  0x00000004L
#define GRBM_SOFT_RESET__SOFT_RESET_GFX_MASK                                                                  0x00010000L
#define GRBM_SOFT_RESET__SOFT_RESET_CPF_MASK                                                                  0x00020000L
#define GRBM_SOFT_RESET__SOFT_RESET_CPC_MASK                                                                  0x00040000L
#define GRBM_SOFT_RESET__SOFT_RESET_CPG_MASK                                                                  0x00080000L
#define GRBM_SOFT_RESET__SOFT_RESET_CAC_MASK                                                                  0x00100000L
#define GRBM_SOFT_RESET__SOFT_RESET_CPAXI_MASK                                                                0x00200000L
#define GRBM_SOFT_RESET__SOFT_RESET_EA_MASK                                                                   0x00400000L
//GRBM_CGTT_CLK_CNTL
#define GRBM_CGTT_CLK_CNTL__ON_DELAY__SHIFT                                                                   0x0
#define GRBM_CGTT_CLK_CNTL__OFF_HYSTERESIS__SHIFT                                                             0x4
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE7__SHIFT                                                       0x10
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE6__SHIFT                                                       0x11
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE5__SHIFT                                                       0x12
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE4__SHIFT                                                       0x13
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE3__SHIFT                                                       0x14
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE2__SHIFT                                                       0x15
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE1__SHIFT                                                       0x16
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE0__SHIFT                                                       0x17
#define GRBM_CGTT_CLK_CNTL__SOFT_OVERRIDE_DYN__SHIFT                                                          0x1e
#define GRBM_CGTT_CLK_CNTL__ON_DELAY_MASK                                                                     0x0000000FL
#define GRBM_CGTT_CLK_CNTL__OFF_HYSTERESIS_MASK                                                               0x00000FF0L
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE7_MASK                                                         0x00010000L
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE6_MASK                                                         0x00020000L
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE5_MASK                                                         0x00040000L
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE4_MASK                                                         0x00080000L
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE3_MASK                                                         0x00100000L
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE2_MASK                                                         0x00200000L
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE1_MASK                                                         0x00400000L
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE0_MASK                                                         0x00800000L
#define GRBM_CGTT_CLK_CNTL__SOFT_OVERRIDE_DYN_MASK                                                            0x40000000L
//GRBM_GFX_CLKEN_CNTL
#define GRBM_GFX_CLKEN_CNTL__PREFIX_DELAY_CNT__SHIFT                                                          0x0
#define GRBM_GFX_CLKEN_CNTL__POST_DELAY_CNT__SHIFT                                                            0x8
#define GRBM_GFX_CLKEN_CNTL__PREFIX_DELAY_CNT_MASK                                                            0x0000000FL
#define GRBM_GFX_CLKEN_CNTL__POST_DELAY_CNT_MASK                                                              0x00001F00L
//GRBM_WAIT_IDLE_CLOCKS
#define GRBM_WAIT_IDLE_CLOCKS__WAIT_IDLE_CLOCKS__SHIFT                                                        0x0
#define GRBM_WAIT_IDLE_CLOCKS__WAIT_IDLE_CLOCKS_MASK                                                          0x000000FFL
//GRBM_STATUS_SE2
#define GRBM_STATUS_SE2__DB_CLEAN__SHIFT                                                                      0x1
#define GRBM_STATUS_SE2__CB_CLEAN__SHIFT                                                                      0x2
#define GRBM_STATUS_SE2__RMI_BUSY__SHIFT                                                                      0x15
#define GRBM_STATUS_SE2__BCI_BUSY__SHIFT                                                                      0x16
#define GRBM_STATUS_SE2__VGT_BUSY__SHIFT                                                                      0x17
#define GRBM_STATUS_SE2__PA_BUSY__SHIFT                                                                       0x18
#define GRBM_STATUS_SE2__TA_BUSY__SHIFT                                                                       0x19
#define GRBM_STATUS_SE2__SX_BUSY__SHIFT                                                                       0x1a
#define GRBM_STATUS_SE2__SPI_BUSY__SHIFT                                                                      0x1b
#define GRBM_STATUS_SE2__SC_BUSY__SHIFT                                                                       0x1d
#define GRBM_STATUS_SE2__DB_BUSY__SHIFT                                                                       0x1e
#define GRBM_STATUS_SE2__CB_BUSY__SHIFT                                                                       0x1f
#define GRBM_STATUS_SE2__DB_CLEAN_MASK                                                                        0x00000002L
#define GRBM_STATUS_SE2__CB_CLEAN_MASK                                                                        0x00000004L
#define GRBM_STATUS_SE2__RMI_BUSY_MASK                                                                        0x00200000L
#define GRBM_STATUS_SE2__BCI_BUSY_MASK                                                                        0x00400000L
#define GRBM_STATUS_SE2__VGT_BUSY_MASK                                                                        0x00800000L
#define GRBM_STATUS_SE2__PA_BUSY_MASK                                                                         0x01000000L
#define GRBM_STATUS_SE2__TA_BUSY_MASK                                                                         0x02000000L
#define GRBM_STATUS_SE2__SX_BUSY_MASK                                                                         0x04000000L
#define GRBM_STATUS_SE2__SPI_BUSY_MASK                                                                        0x08000000L
#define GRBM_STATUS_SE2__SC_BUSY_MASK                                                                         0x20000000L
#define GRBM_STATUS_SE2__DB_BUSY_MASK                                                                         0x40000000L
#define GRBM_STATUS_SE2__CB_BUSY_MASK                                                                         0x80000000L
//GRBM_STATUS_SE3
#define GRBM_STATUS_SE3__DB_CLEAN__SHIFT                                                                      0x1
#define GRBM_STATUS_SE3__CB_CLEAN__SHIFT                                                                      0x2
#define GRBM_STATUS_SE3__RMI_BUSY__SHIFT                                                                      0x15
#define GRBM_STATUS_SE3__BCI_BUSY__SHIFT                                                                      0x16
#define GRBM_STATUS_SE3__VGT_BUSY__SHIFT                                                                      0x17
#define GRBM_STATUS_SE3__PA_BUSY__SHIFT                                                                       0x18
#define GRBM_STATUS_SE3__TA_BUSY__SHIFT                                                                       0x19
#define GRBM_STATUS_SE3__SX_BUSY__SHIFT                                                                       0x1a
#define GRBM_STATUS_SE3__SPI_BUSY__SHIFT                                                                      0x1b
#define GRBM_STATUS_SE3__SC_BUSY__SHIFT                                                                       0x1d
#define GRBM_STATUS_SE3__DB_BUSY__SHIFT                                                                       0x1e
#define GRBM_STATUS_SE3__CB_BUSY__SHIFT                                                                       0x1f
#define GRBM_STATUS_SE3__DB_CLEAN_MASK                                                                        0x00000002L
#define GRBM_STATUS_SE3__CB_CLEAN_MASK                                                                        0x00000004L
#define GRBM_STATUS_SE3__RMI_BUSY_MASK                                                                        0x00200000L
#define GRBM_STATUS_SE3__BCI_BUSY_MASK                                                                        0x00400000L
#define GRBM_STATUS_SE3__VGT_BUSY_MASK                                                                        0x00800000L
#define GRBM_STATUS_SE3__PA_BUSY_MASK                                                                         0x01000000L
#define GRBM_STATUS_SE3__TA_BUSY_MASK                                                                         0x02000000L
#define GRBM_STATUS_SE3__SX_BUSY_MASK                                                                         0x04000000L
#define GRBM_STATUS_SE3__SPI_BUSY_MASK                                                                        0x08000000L
#define GRBM_STATUS_SE3__SC_BUSY_MASK                                                                         0x20000000L
#define GRBM_STATUS_SE3__DB_BUSY_MASK                                                                         0x40000000L
#define GRBM_STATUS_SE3__CB_BUSY_MASK                                                                         0x80000000L
//GRBM_READ_ERROR
#define GRBM_READ_ERROR__READ_ADDRESS__SHIFT                                                                  0x2
#define GRBM_READ_ERROR__READ_PIPEID__SHIFT                                                                   0x14
#define GRBM_READ_ERROR__READ_MEID__SHIFT                                                                     0x16
#define GRBM_READ_ERROR__READ_ERROR__SHIFT                                                                    0x1f
#define GRBM_READ_ERROR__READ_ADDRESS_MASK                                                                    0x0003FFFCL
#define GRBM_READ_ERROR__READ_PIPEID_MASK                                                                     0x00300000L
#define GRBM_READ_ERROR__READ_MEID_MASK                                                                       0x00C00000L
#define GRBM_READ_ERROR__READ_ERROR_MASK                                                                      0x80000000L
//GRBM_READ_ERROR2
#define GRBM_READ_ERROR2__READ_REQUESTER_CPF__SHIFT                                                           0x10
#define GRBM_READ_ERROR2__READ_REQUESTER_RSMU__SHIFT                                                          0x11
#define GRBM_READ_ERROR2__READ_REQUESTER_RLC__SHIFT                                                           0x12
#define GRBM_READ_ERROR2__READ_REQUESTER_GDS_DMA__SHIFT                                                       0x13
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE0_CF__SHIFT                                                   0x14
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE0_PF__SHIFT                                                   0x15
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE1_CF__SHIFT                                                   0x16
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE1_PF__SHIFT                                                   0x17
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE0__SHIFT                                                      0x18
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE1__SHIFT                                                      0x19
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE2__SHIFT                                                      0x1a
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE3__SHIFT                                                      0x1b
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE0__SHIFT                                                      0x1c
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE1__SHIFT                                                      0x1d
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE2__SHIFT                                                      0x1e
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE3__SHIFT                                                      0x1f
#define GRBM_READ_ERROR2__READ_REQUESTER_CPF_MASK                                                             0x00010000L
#define GRBM_READ_ERROR2__READ_REQUESTER_RSMU_MASK                                                            0x00020000L
#define GRBM_READ_ERROR2__READ_REQUESTER_RLC_MASK                                                             0x00040000L
#define GRBM_READ_ERROR2__READ_REQUESTER_GDS_DMA_MASK                                                         0x00080000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE0_CF_MASK                                                     0x00100000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE0_PF_MASK                                                     0x00200000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE1_CF_MASK                                                     0x00400000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE1_PF_MASK                                                     0x00800000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE0_MASK                                                        0x01000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE1_MASK                                                        0x02000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE2_MASK                                                        0x04000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE3_MASK                                                        0x08000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE0_MASK                                                        0x10000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE1_MASK                                                        0x20000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE2_MASK                                                        0x40000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE3_MASK                                                        0x80000000L
//GRBM_INT_CNTL
#define GRBM_INT_CNTL__RDERR_INT_ENABLE__SHIFT                                                                0x0
#define GRBM_INT_CNTL__GUI_IDLE_INT_ENABLE__SHIFT                                                             0x13
#define GRBM_INT_CNTL__RDERR_INT_ENABLE_MASK                                                                  0x00000001L
#define GRBM_INT_CNTL__GUI_IDLE_INT_ENABLE_MASK                                                               0x00080000L
//GRBM_TRAP_OP
#define GRBM_TRAP_OP__RW__SHIFT                                                                               0x0
#define GRBM_TRAP_OP__RW_MASK                                                                                 0x00000001L
//GRBM_TRAP_ADDR
#define GRBM_TRAP_ADDR__DATA__SHIFT                                                                           0x0
#define GRBM_TRAP_ADDR__DATA_MASK                                                                             0x0003FFFFL
//GRBM_TRAP_ADDR_MSK
#define GRBM_TRAP_ADDR_MSK__DATA__SHIFT                                                                       0x0
#define GRBM_TRAP_ADDR_MSK__DATA_MASK                                                                         0x0003FFFFL
//GRBM_TRAP_WD
#define GRBM_TRAP_WD__DATA__SHIFT                                                                             0x0
#define GRBM_TRAP_WD__DATA_MASK                                                                               0xFFFFFFFFL
//GRBM_TRAP_WD_MSK
#define GRBM_TRAP_WD_MSK__DATA__SHIFT                                                                         0x0
#define GRBM_TRAP_WD_MSK__DATA_MASK                                                                           0xFFFFFFFFL
//GRBM_DSM_BYPASS
#define GRBM_DSM_BYPASS__BYPASS_BITS__SHIFT                                                                   0x0
#define GRBM_DSM_BYPASS__BYPASS_EN__SHIFT                                                                     0x2
#define GRBM_DSM_BYPASS__BYPASS_BITS_MASK                                                                     0x00000003L
#define GRBM_DSM_BYPASS__BYPASS_EN_MASK                                                                       0x00000004L
//GRBM_WRITE_ERROR
#define GRBM_WRITE_ERROR__WRITE_REQUESTER_RLC__SHIFT                                                          0x0
#define GRBM_WRITE_ERROR__WRITE_REQUESTER_RSMU__SHIFT                                                         0x1
#define GRBM_WRITE_ERROR__WRITE_SSRCID__SHIFT                                                                 0x2
#define GRBM_WRITE_ERROR__WRITE_VFID__SHIFT                                                                   0x5
#define GRBM_WRITE_ERROR__WRITE_VF__SHIFT                                                                     0xc
#define GRBM_WRITE_ERROR__WRITE_VMID__SHIFT                                                                   0xd
#define GRBM_WRITE_ERROR__WRITE_PIPEID__SHIFT                                                                 0x14
#define GRBM_WRITE_ERROR__WRITE_MEID__SHIFT                                                                   0x16
#define GRBM_WRITE_ERROR__WRITE_ERROR__SHIFT                                                                  0x1f
#define GRBM_WRITE_ERROR__WRITE_REQUESTER_RLC_MASK                                                            0x00000001L
#define GRBM_WRITE_ERROR__WRITE_REQUESTER_RSMU_MASK                                                           0x00000002L
#define GRBM_WRITE_ERROR__WRITE_SSRCID_MASK                                                                   0x0000001CL
#define GRBM_WRITE_ERROR__WRITE_VFID_MASK                                                                     0x000001E0L
#define GRBM_WRITE_ERROR__WRITE_VF_MASK                                                                       0x00001000L
#define GRBM_WRITE_ERROR__WRITE_VMID_MASK                                                                     0x0001E000L
#define GRBM_WRITE_ERROR__WRITE_PIPEID_MASK                                                                   0x00300000L
#define GRBM_WRITE_ERROR__WRITE_MEID_MASK                                                                     0x00C00000L
#define GRBM_WRITE_ERROR__WRITE_ERROR_MASK                                                                    0x80000000L
//GRBM_IOV_ERROR
#define GRBM_IOV_ERROR__IOV_ADDR__SHIFT                                                                       0x2
#define GRBM_IOV_ERROR__IOV_VFID__SHIFT                                                                       0x14
#define GRBM_IOV_ERROR__IOV_VF__SHIFT                                                                         0x1a
#define GRBM_IOV_ERROR__IOV_OP__SHIFT                                                                         0x1b
#define GRBM_IOV_ERROR__IOV_ERROR__SHIFT                                                                      0x1f
#define GRBM_IOV_ERROR__IOV_ADDR_MASK                                                                         0x000FFFFCL
#define GRBM_IOV_ERROR__IOV_VFID_MASK                                                                         0x03F00000L
#define GRBM_IOV_ERROR__IOV_VF_MASK                                                                           0x04000000L
#define GRBM_IOV_ERROR__IOV_OP_MASK                                                                           0x08000000L
#define GRBM_IOV_ERROR__IOV_ERROR_MASK                                                                        0x80000000L
//GRBM_CHIP_REVISION
#define GRBM_CHIP_REVISION__CHIP_REVISION__SHIFT                                                              0x0
#define GRBM_CHIP_REVISION__CHIP_REVISION_MASK                                                                0x000000FFL
//GRBM_GFX_CNTL
#define GRBM_GFX_CNTL__PIPEID__SHIFT                                                                          0x0
#define GRBM_GFX_CNTL__MEID__SHIFT                                                                            0x2
#define GRBM_GFX_CNTL__VMID__SHIFT                                                                            0x4
#define GRBM_GFX_CNTL__QUEUEID__SHIFT                                                                         0x8
#define GRBM_GFX_CNTL__PIPEID_MASK                                                                            0x00000003L
#define GRBM_GFX_CNTL__MEID_MASK                                                                              0x0000000CL
#define GRBM_GFX_CNTL__VMID_MASK                                                                              0x000000F0L
#define GRBM_GFX_CNTL__QUEUEID_MASK                                                                           0x00000700L
//GRBM_RSMU_CFG
#define GRBM_RSMU_CFG__APERTURE_ID__SHIFT                                                                     0x0
#define GRBM_RSMU_CFG__QOS__SHIFT                                                                             0xc
#define GRBM_RSMU_CFG__POSTED_WR__SHIFT                                                                       0x10
#define GRBM_RSMU_CFG__APERTURE_ID_MASK                                                                       0x00000FFFL
#define GRBM_RSMU_CFG__QOS_MASK                                                                               0x0000F000L
#define GRBM_RSMU_CFG__POSTED_WR_MASK                                                                         0x00010000L
//GRBM_IH_CREDIT
#define GRBM_IH_CREDIT__CREDIT_VALUE__SHIFT                                                                   0x0
#define GRBM_IH_CREDIT__IH_CLIENT_ID__SHIFT                                                                   0x10
#define GRBM_IH_CREDIT__CREDIT_VALUE_MASK                                                                     0x00000003L
#define GRBM_IH_CREDIT__IH_CLIENT_ID_MASK                                                                     0x00FF0000L
//GRBM_PWR_CNTL2
#define GRBM_PWR_CNTL2__PWR_REQUEST_HALT__SHIFT                                                               0x10
#define GRBM_PWR_CNTL2__PWR_GFX3D_REQUEST_HALT__SHIFT                                                         0x14
#define GRBM_PWR_CNTL2__PWR_REQUEST_HALT_MASK                                                                 0x00010000L
#define GRBM_PWR_CNTL2__PWR_GFX3D_REQUEST_HALT_MASK                                                           0x00100000L
//GRBM_UTCL2_INVAL_RANGE_START
#define GRBM_UTCL2_INVAL_RANGE_START__DATA__SHIFT                                                             0x0
#define GRBM_UTCL2_INVAL_RANGE_START__DATA_MASK                                                               0x0003FFFFL
//GRBM_UTCL2_INVAL_RANGE_END
#define GRBM_UTCL2_INVAL_RANGE_END__DATA__SHIFT                                                               0x0
#define GRBM_UTCL2_INVAL_RANGE_END__DATA_MASK                                                                 0x0003FFFFL
//GRBM_RSMU_READ_ERROR
#define GRBM_RSMU_READ_ERROR__RSMU_READ_ADDRESS__SHIFT                                                        0x2
#define GRBM_RSMU_READ_ERROR__RSMU_READ_VF__SHIFT                                                             0x14
#define GRBM_RSMU_READ_ERROR__RSMU_READ_VFID__SHIFT                                                           0x15
#define GRBM_RSMU_READ_ERROR__RSMU_READ_ERROR_TYPE__SHIFT                                                     0x1b
#define GRBM_RSMU_READ_ERROR__RSMU_READ_ERROR__SHIFT                                                          0x1f
#define GRBM_RSMU_READ_ERROR__RSMU_READ_ADDRESS_MASK                                                          0x000FFFFCL
#define GRBM_RSMU_READ_ERROR__RSMU_READ_VF_MASK                                                               0x00100000L
#define GRBM_RSMU_READ_ERROR__RSMU_READ_VFID_MASK                                                             0x07E00000L
#define GRBM_RSMU_READ_ERROR__RSMU_READ_ERROR_TYPE_MASK                                                       0x08000000L
#define GRBM_RSMU_READ_ERROR__RSMU_READ_ERROR_MASK                                                            0x80000000L
//GRBM_CHICKEN_BITS
#define GRBM_CHICKEN_BITS__DISABLE_CP_VMID_RESET_REQ__SHIFT                                                   0x0
#define GRBM_CHICKEN_BITS__DISABLE_CP_VMID_RESET_REQ_MASK                                                     0x00000001L
//GRBM_NOWHERE
#define GRBM_NOWHERE__DATA__SHIFT                                                                             0x0
#define GRBM_NOWHERE__DATA_MASK                                                                               0xFFFFFFFFL
//GRBM_SCRATCH_REG0
#define GRBM_SCRATCH_REG0__SCRATCH_REG0__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG0__SCRATCH_REG0_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG1
#define GRBM_SCRATCH_REG1__SCRATCH_REG1__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG1__SCRATCH_REG1_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG2
#define GRBM_SCRATCH_REG2__SCRATCH_REG2__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG2__SCRATCH_REG2_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG3
#define GRBM_SCRATCH_REG3__SCRATCH_REG3__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG3__SCRATCH_REG3_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG4
#define GRBM_SCRATCH_REG4__SCRATCH_REG4__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG4__SCRATCH_REG4_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG5
#define GRBM_SCRATCH_REG5__SCRATCH_REG5__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG5__SCRATCH_REG5_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG6
#define GRBM_SCRATCH_REG6__SCRATCH_REG6__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG6__SCRATCH_REG6_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG7
#define GRBM_SCRATCH_REG7__SCRATCH_REG7__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG7__SCRATCH_REG7_MASK                                                                  0xFFFFFFFFL


// addressBlock: gc_cpdec
//CP_CPC_STATUS
#define CP_CPC_STATUS__MEC1_BUSY__SHIFT                                                                       0x0
#define CP_CPC_STATUS__MEC2_BUSY__SHIFT                                                                       0x1
#define CP_CPC_STATUS__DC0_BUSY__SHIFT                                                                        0x2
#define CP_CPC_STATUS__DC1_BUSY__SHIFT                                                                        0x3
#define CP_CPC_STATUS__RCIU1_BUSY__SHIFT                                                                      0x4
#define CP_CPC_STATUS__RCIU2_BUSY__SHIFT                                                                      0x5
#define CP_CPC_STATUS__ROQ1_BUSY__SHIFT                                                                       0x6
#define CP_CPC_STATUS__ROQ2_BUSY__SHIFT                                                                       0x7
#define CP_CPC_STATUS__TCIU_BUSY__SHIFT                                                                       0xa
#define CP_CPC_STATUS__SCRATCH_RAM_BUSY__SHIFT                                                                0xb
#define CP_CPC_STATUS__QU_BUSY__SHIFT                                                                         0xc
#define CP_CPC_STATUS__UTCL2IU_BUSY__SHIFT                                                                    0xd
#define CP_CPC_STATUS__SAVE_RESTORE_BUSY__SHIFT                                                               0xe
#define CP_CPC_STATUS__CPG_CPC_BUSY__SHIFT                                                                    0x1d
#define CP_CPC_STATUS__CPF_CPC_BUSY__SHIFT                                                                    0x1e
#define CP_CPC_STATUS__CPC_BUSY__SHIFT                                                                        0x1f
#define CP_CPC_STATUS__MEC1_BUSY_MASK                                                                         0x00000001L
#define CP_CPC_STATUS__MEC2_BUSY_MASK                                                                         0x00000002L
#define CP_CPC_STATUS__DC0_BUSY_MASK                                                                          0x00000004L
#define CP_CPC_STATUS__DC1_BUSY_MASK                                                                          0x00000008L
#define CP_CPC_STATUS__RCIU1_BUSY_MASK                                                                        0x00000010L
#define CP_CPC_STATUS__RCIU2_BUSY_MASK                                                                        0x00000020L
#define CP_CPC_STATUS__ROQ1_BUSY_MASK                                                                         0x00000040L
#define CP_CPC_STATUS__ROQ2_BUSY_MASK                                                                         0x00000080L
#define CP_CPC_STATUS__TCIU_BUSY_MASK                                                                         0x00000400L
#define CP_CPC_STATUS__SCRATCH_RAM_BUSY_MASK                                                                  0x00000800L
#define CP_CPC_STATUS__QU_BUSY_MASK                                                                           0x00001000L
#define CP_CPC_STATUS__UTCL2IU_BUSY_MASK                                                                      0x00002000L
#define CP_CPC_STATUS__SAVE_RESTORE_BUSY_MASK                                                                 0x00004000L
#define CP_CPC_STATUS__CPG_CPC_BUSY_MASK                                                                      0x20000000L
#define CP_CPC_STATUS__CPF_CPC_BUSY_MASK                                                                      0x40000000L
#define CP_CPC_STATUS__CPC_BUSY_MASK                                                                          0x80000000L
//CP_CPC_BUSY_STAT
#define CP_CPC_BUSY_STAT__MEC1_LOAD_BUSY__SHIFT                                                               0x0
#define CP_CPC_BUSY_STAT__MEC1_SEMAPOHRE_BUSY__SHIFT                                                          0x1
#define CP_CPC_BUSY_STAT__MEC1_MUTEX_BUSY__SHIFT                                                              0x2
#define CP_CPC_BUSY_STAT__MEC1_MESSAGE_BUSY__SHIFT                                                            0x3
#define CP_CPC_BUSY_STAT__MEC1_EOP_QUEUE_BUSY__SHIFT                                                          0x4
#define CP_CPC_BUSY_STAT__MEC1_IQ_QUEUE_BUSY__SHIFT                                                           0x5
#define CP_CPC_BUSY_STAT__MEC1_IB_QUEUE_BUSY__SHIFT                                                           0x6
#define CP_CPC_BUSY_STAT__MEC1_TC_BUSY__SHIFT                                                                 0x7
#define CP_CPC_BUSY_STAT__MEC1_DMA_BUSY__SHIFT                                                                0x8
#define CP_CPC_BUSY_STAT__MEC1_PARTIAL_FLUSH_BUSY__SHIFT                                                      0x9
#define CP_CPC_BUSY_STAT__MEC1_PIPE0_BUSY__SHIFT                                                              0xa
#define CP_CPC_BUSY_STAT__MEC1_PIPE1_BUSY__SHIFT                                                              0xb
#define CP_CPC_BUSY_STAT__MEC1_PIPE2_BUSY__SHIFT                                                              0xc
#define CP_CPC_BUSY_STAT__MEC1_PIPE3_BUSY__SHIFT                                                              0xd
#define CP_CPC_BUSY_STAT__MEC2_LOAD_BUSY__SHIFT                                                               0x10
#define CP_CPC_BUSY_STAT__MEC2_SEMAPOHRE_BUSY__SHIFT                                                          0x11
#define CP_CPC_BUSY_STAT__MEC2_MUTEX_BUSY__SHIFT                                                              0x12
#define CP_CPC_BUSY_STAT__MEC2_MESSAGE_BUSY__SHIFT                                                            0x13
#define CP_CPC_BUSY_STAT__MEC2_EOP_QUEUE_BUSY__SHIFT                                                          0x14
#define CP_CPC_BUSY_STAT__MEC2_IQ_QUEUE_BUSY__SHIFT                                                           0x15
#define CP_CPC_BUSY_STAT__MEC2_IB_QUEUE_BUSY__SHIFT                                                           0x16
#define CP_CPC_BUSY_STAT__MEC2_TC_BUSY__SHIFT                                                                 0x17
#define CP_CPC_BUSY_STAT__MEC2_DMA_BUSY__SHIFT                                                                0x18
#define CP_CPC_BUSY_STAT__MEC2_PARTIAL_FLUSH_BUSY__SHIFT                                                      0x19
#define CP_CPC_BUSY_STAT__MEC2_PIPE0_BUSY__SHIFT                                                              0x1a
#define CP_CPC_BUSY_STAT__MEC2_PIPE1_BUSY__SHIFT                                                              0x1b
#define CP_CPC_BUSY_STAT__MEC2_PIPE2_BUSY__SHIFT                                                              0x1c
#define CP_CPC_BUSY_STAT__MEC2_PIPE3_BUSY__SHIFT                                                              0x1d
#define CP_CPC_BUSY_STAT__MEC1_LOAD_BUSY_MASK                                                                 0x00000001L
#define CP_CPC_BUSY_STAT__MEC1_SEMAPOHRE_BUSY_MASK                                                            0x00000002L
#define CP_CPC_BUSY_STAT__MEC1_MUTEX_BUSY_MASK                                                                0x00000004L
#define CP_CPC_BUSY_STAT__MEC1_MESSAGE_BUSY_MASK                                                              0x00000008L
#define CP_CPC_BUSY_STAT__MEC1_EOP_QUEUE_BUSY_MASK                                                            0x00000010L
#define CP_CPC_BUSY_STAT__MEC1_IQ_QUEUE_BUSY_MASK                                                             0x00000020L
#define CP_CPC_BUSY_STAT__MEC1_IB_QUEUE_BUSY_MASK                                                             0x00000040L
#define CP_CPC_BUSY_STAT__MEC1_TC_BUSY_MASK                                                                   0x00000080L
#define CP_CPC_BUSY_STAT__MEC1_DMA_BUSY_MASK                                                                  0x00000100L
#define CP_CPC_BUSY_STAT__MEC1_PARTIAL_FLUSH_BUSY_MASK                                                        0x00000200L
#define CP_CPC_BUSY_STAT__MEC1_PIPE0_BUSY_MASK                                                                0x00000400L
#define CP_CPC_BUSY_STAT__MEC1_PIPE1_BUSY_MASK                                                                0x00000800L
#define CP_CPC_BUSY_STAT__MEC1_PIPE2_BUSY_MASK                                                                0x00001000L
#define CP_CPC_BUSY_STAT__MEC1_PIPE3_BUSY_MASK                                                                0x00002000L
#define CP_CPC_BUSY_STAT__MEC2_LOAD_BUSY_MASK                                                                 0x00010000L
#define CP_CPC_BUSY_STAT__MEC2_SEMAPOHRE_BUSY_MASK                                                            0x00020000L
#define CP_CPC_BUSY_STAT__MEC2_MUTEX_BUSY_MASK                                                                0x00040000L
#define CP_CPC_BUSY_STAT__MEC2_MESSAGE_BUSY_MASK                                                              0x00080000L
#define CP_CPC_BUSY_STAT__MEC2_EOP_QUEUE_BUSY_MASK                                                            0x00100000L
#define CP_CPC_BUSY_STAT__MEC2_IQ_QUEUE_BUSY_MASK                                                             0x00200000L
#define CP_CPC_BUSY_STAT__MEC2_IB_QUEUE_BUSY_MASK                                                             0x00400000L
#define CP_CPC_BUSY_STAT__MEC2_TC_BUSY_MASK                                                                   0x00800000L
#define CP_CPC_BUSY_STAT__MEC2_DMA_BUSY_MASK                                                                  0x01000000L
#define CP_CPC_BUSY_STAT__MEC2_PARTIAL_FLUSH_BUSY_MASK                                                        0x02000000L
#define CP_CPC_BUSY_STAT__MEC2_PIPE0_BUSY_MASK                                                                0x04000000L
#define CP_CPC_BUSY_STAT__MEC2_PIPE1_BUSY_MASK                                                                0x08000000L
#define CP_CPC_BUSY_STAT__MEC2_PIPE2_BUSY_MASK                                                                0x10000000L
#define CP_CPC_BUSY_STAT__MEC2_PIPE3_BUSY_MASK                                                                0x20000000L
//CP_CPC_STALLED_STAT1
#define CP_CPC_STALLED_STAT1__RCIU_TX_FREE_STALL__SHIFT                                                       0x3
#define CP_CPC_STALLED_STAT1__RCIU_PRIV_VIOLATION__SHIFT                                                      0x4
#define CP_CPC_STALLED_STAT1__TCIU_TX_FREE_STALL__SHIFT                                                       0x6
#define CP_CPC_STALLED_STAT1__MEC1_DECODING_PACKET__SHIFT                                                     0x8
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_RCIU__SHIFT                                                        0x9
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_RCIU_READ__SHIFT                                                   0xa
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_ROQ_DATA__SHIFT                                                    0xd
#define CP_CPC_STALLED_STAT1__MEC2_DECODING_PACKET__SHIFT                                                     0x10
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_RCIU__SHIFT                                                        0x11
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_RCIU_READ__SHIFT                                                   0x12
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_ROQ_DATA__SHIFT                                                    0x15
#define CP_CPC_STALLED_STAT1__UTCL2IU_WAITING_ON_FREE__SHIFT                                                  0x16
#define CP_CPC_STALLED_STAT1__UTCL2IU_WAITING_ON_TAGS__SHIFT                                                  0x17
#define CP_CPC_STALLED_STAT1__UTCL1_WAITING_ON_TRANS__SHIFT                                                   0x18
#define CP_CPC_STALLED_STAT1__RCIU_TX_FREE_STALL_MASK                                                         0x00000008L
#define CP_CPC_STALLED_STAT1__RCIU_PRIV_VIOLATION_MASK                                                        0x00000010L
#define CP_CPC_STALLED_STAT1__TCIU_TX_FREE_STALL_MASK                                                         0x00000040L
#define CP_CPC_STALLED_STAT1__MEC1_DECODING_PACKET_MASK                                                       0x00000100L
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_RCIU_MASK                                                          0x00000200L
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_RCIU_READ_MASK                                                     0x00000400L
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_ROQ_DATA_MASK                                                      0x00002000L
#define CP_CPC_STALLED_STAT1__MEC2_DECODING_PACKET_MASK                                                       0x00010000L
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_RCIU_MASK                                                          0x00020000L
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_RCIU_READ_MASK                                                     0x00040000L
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_ROQ_DATA_MASK                                                      0x00200000L
#define CP_CPC_STALLED_STAT1__UTCL2IU_WAITING_ON_FREE_MASK                                                    0x00400000L
#define CP_CPC_STALLED_STAT1__UTCL2IU_WAITING_ON_TAGS_MASK                                                    0x00800000L
#define CP_CPC_STALLED_STAT1__UTCL1_WAITING_ON_TRANS_MASK                                                     0x01000000L
//CP_CPF_STATUS
#define CP_CPF_STATUS__POST_WPTR_GFX_BUSY__SHIFT                                                              0x0
#define CP_CPF_STATUS__CSF_BUSY__SHIFT                                                                        0x1
#define CP_CPF_STATUS__ROQ_ALIGN_BUSY__SHIFT                                                                  0x4
#define CP_CPF_STATUS__ROQ_RING_BUSY__SHIFT                                                                   0x5
#define CP_CPF_STATUS__ROQ_INDIRECT1_BUSY__SHIFT                                                              0x6
#define CP_CPF_STATUS__ROQ_INDIRECT2_BUSY__SHIFT                                                              0x7
#define CP_CPF_STATUS__ROQ_STATE_BUSY__SHIFT                                                                  0x8
#define CP_CPF_STATUS__ROQ_CE_RING_BUSY__SHIFT                                                                0x9
#define CP_CPF_STATUS__ROQ_CE_INDIRECT1_BUSY__SHIFT                                                           0xa
#define CP_CPF_STATUS__ROQ_CE_INDIRECT2_BUSY__SHIFT                                                           0xb
#define CP_CPF_STATUS__SEMAPHORE_BUSY__SHIFT                                                                  0xc
#define CP_CPF_STATUS__INTERRUPT_BUSY__SHIFT                                                                  0xd
#define CP_CPF_STATUS__TCIU_BUSY__SHIFT                                                                       0xe
#define CP_CPF_STATUS__HQD_BUSY__SHIFT                                                                        0xf
#define CP_CPF_STATUS__PRT_BUSY__SHIFT                                                                        0x10
#define CP_CPF_STATUS__UTCL2IU_BUSY__SHIFT                                                                    0x11
#define CP_CPF_STATUS__CPF_GFX_BUSY__SHIFT                                                                    0x1a
#define CP_CPF_STATUS__CPF_CMP_BUSY__SHIFT                                                                    0x1b
#define CP_CPF_STATUS__GRBM_CPF_STAT_BUSY__SHIFT                                                              0x1c
#define CP_CPF_STATUS__CPC_CPF_BUSY__SHIFT                                                                    0x1e
#define CP_CPF_STATUS__CPF_BUSY__SHIFT                                                                        0x1f
#define CP_CPF_STATUS__POST_WPTR_GFX_BUSY_MASK                                                                0x00000001L
#define CP_CPF_STATUS__CSF_BUSY_MASK                                                                          0x00000002L
#define CP_CPF_STATUS__ROQ_ALIGN_BUSY_MASK                                                                    0x00000010L
#define CP_CPF_STATUS__ROQ_RING_BUSY_MASK                                                                     0x00000020L
#define CP_CPF_STATUS__ROQ_INDIRECT1_BUSY_MASK                                                                0x00000040L
#define CP_CPF_STATUS__ROQ_INDIRECT2_BUSY_MASK                                                                0x00000080L
#define CP_CPF_STATUS__ROQ_STATE_BUSY_MASK                                                                    0x00000100L
#define CP_CPF_STATUS__ROQ_CE_RING_BUSY_MASK                                                                  0x00000200L
#define CP_CPF_STATUS__ROQ_CE_INDIRECT1_BUSY_MASK                                                             0x00000400L
#define CP_CPF_STATUS__ROQ_CE_INDIRECT2_BUSY_MASK                                                             0x00000800L
#define CP_CPF_STATUS__SEMAPHORE_BUSY_MASK                                                                    0x00001000L
#define CP_CPF_STATUS__INTERRUPT_BUSY_MASK                                                                    0x00002000L
#define CP_CPF_STATUS__TCIU_BUSY_MASK                                                                         0x00004000L
#define CP_CPF_STATUS__HQD_BUSY_MASK                                                                          0x00008000L
#define CP_CPF_STATUS__PRT_BUSY_MASK                                                                          0x00010000L
#define CP_CPF_STATUS__UTCL2IU_BUSY_MASK                                                                      0x00020000L
#define CP_CPF_STATUS__CPF_GFX_BUSY_MASK                                                                      0x04000000L
#define CP_CPF_STATUS__CPF_CMP_BUSY_MASK                                                                      0x08000000L
#define CP_CPF_STATUS__GRBM_CPF_STAT_BUSY_MASK                                                                0x30000000L
#define CP_CPF_STATUS__CPC_CPF_BUSY_MASK                                                                      0x40000000L
#define CP_CPF_STATUS__CPF_BUSY_MASK                                                                          0x80000000L
//CP_CPF_BUSY_STAT
#define CP_CPF_BUSY_STAT__REG_BUS_FIFO_BUSY__SHIFT                                                            0x0
#define CP_CPF_BUSY_STAT__CSF_RING_BUSY__SHIFT                                                                0x1
#define CP_CPF_BUSY_STAT__CSF_INDIRECT1_BUSY__SHIFT                                                           0x2
#define CP_CPF_BUSY_STAT__CSF_INDIRECT2_BUSY__SHIFT                                                           0x3
#define CP_CPF_BUSY_STAT__CSF_STATE_BUSY__SHIFT                                                               0x4
#define CP_CPF_BUSY_STAT__CSF_CE_INDR1_BUSY__SHIFT                                                            0x5
#define CP_CPF_BUSY_STAT__CSF_CE_INDR2_BUSY__SHIFT                                                            0x6
#define CP_CPF_BUSY_STAT__CSF_ARBITER_BUSY__SHIFT                                                             0x7
#define CP_CPF_BUSY_STAT__CSF_INPUT_BUSY__SHIFT                                                               0x8
#define CP_CPF_BUSY_STAT__OUTSTANDING_READ_TAGS__SHIFT                                                        0x9
#define CP_CPF_BUSY_STAT__HPD_PROCESSING_EOP_BUSY__SHIFT                                                      0xb
#define CP_CPF_BUSY_STAT__HQD_DISPATCH_BUSY__SHIFT                                                            0xc
#define CP_CPF_BUSY_STAT__HQD_IQ_TIMER_BUSY__SHIFT                                                            0xd
#define CP_CPF_BUSY_STAT__HQD_DMA_OFFLOAD_BUSY__SHIFT                                                         0xe
#define CP_CPF_BUSY_STAT__HQD_WAIT_SEMAPHORE_BUSY__SHIFT                                                      0xf
#define CP_CPF_BUSY_STAT__HQD_SIGNAL_SEMAPHORE_BUSY__SHIFT                                                    0x10
#define CP_CPF_BUSY_STAT__HQD_MESSAGE_BUSY__SHIFT                                                             0x11
#define CP_CPF_BUSY_STAT__HQD_PQ_FETCHER_BUSY__SHIFT                                                          0x12
#define CP_CPF_BUSY_STAT__HQD_IB_FETCHER_BUSY__SHIFT                                                          0x13
#define CP_CPF_BUSY_STAT__HQD_IQ_FETCHER_BUSY__SHIFT                                                          0x14
#define CP_CPF_BUSY_STAT__HQD_EOP_FETCHER_BUSY__SHIFT                                                         0x15
#define CP_CPF_BUSY_STAT__HQD_CONSUMED_RPTR_BUSY__SHIFT                                                       0x16
#define CP_CPF_BUSY_STAT__HQD_FETCHER_ARB_BUSY__SHIFT                                                         0x17
#define CP_CPF_BUSY_STAT__HQD_ROQ_ALIGN_BUSY__SHIFT                                                           0x18
#define CP_CPF_BUSY_STAT__HQD_ROQ_EOP_BUSY__SHIFT                                                             0x19
#define CP_CPF_BUSY_STAT__HQD_ROQ_IQ_BUSY__SHIFT                                                              0x1a
#define CP_CPF_BUSY_STAT__HQD_ROQ_PQ_BUSY__SHIFT                                                              0x1b
#define CP_CPF_BUSY_STAT__HQD_ROQ_IB_BUSY__SHIFT                                                              0x1c
#define CP_CPF_BUSY_STAT__HQD_WPTR_POLL_BUSY__SHIFT                                                           0x1d
#define CP_CPF_BUSY_STAT__HQD_PQ_BUSY__SHIFT                                                                  0x1e
#define CP_CPF_BUSY_STAT__HQD_IB_BUSY__SHIFT                                                                  0x1f
#define CP_CPF_BUSY_STAT__REG_BUS_FIFO_BUSY_MASK                                                              0x00000001L
#define CP_CPF_BUSY_STAT__CSF_RING_BUSY_MASK                                                                  0x00000002L
#define CP_CPF_BUSY_STAT__CSF_INDIRECT1_BUSY_MASK                                                             0x00000004L
#define CP_CPF_BUSY_STAT__CSF_INDIRECT2_BUSY_MASK                                                             0x00000008L
#define CP_CPF_BUSY_STAT__CSF_STATE_BUSY_MASK                                                                 0x00000010L
#define CP_CPF_BUSY_STAT__CSF_CE_INDR1_BUSY_MASK                                                              0x00000020L
#define CP_CPF_BUSY_STAT__CSF_CE_INDR2_BUSY_MASK                                                              0x00000040L
#define CP_CPF_BUSY_STAT__CSF_ARBITER_BUSY_MASK                                                               0x00000080L
#define CP_CPF_BUSY_STAT__CSF_INPUT_BUSY_MASK                                                                 0x00000100L
#define CP_CPF_BUSY_STAT__OUTSTANDING_READ_TAGS_MASK                                                          0x00000200L
#define CP_CPF_BUSY_STAT__HPD_PROCESSING_EOP_BUSY_MASK                                                        0x00000800L
#define CP_CPF_BUSY_STAT__HQD_DISPATCH_BUSY_MASK                                                              0x00001000L
#define CP_CPF_BUSY_STAT__HQD_IQ_TIMER_BUSY_MASK                                                              0x00002000L
#define CP_CPF_BUSY_STAT__HQD_DMA_OFFLOAD_BUSY_MASK                                                           0x00004000L
#define CP_CPF_BUSY_STAT__HQD_WAIT_SEMAPHORE_BUSY_MASK                                                        0x00008000L
#define CP_CPF_BUSY_STAT__HQD_SIGNAL_SEMAPHORE_BUSY_MASK                                                      0x00010000L
#define CP_CPF_BUSY_STAT__HQD_MESSAGE_BUSY_MASK                                                               0x00020000L
#define CP_CPF_BUSY_STAT__HQD_PQ_FETCHER_BUSY_MASK                                                            0x00040000L
#define CP_CPF_BUSY_STAT__HQD_IB_FETCHER_BUSY_MASK                                                            0x00080000L
#define CP_CPF_BUSY_STAT__HQD_IQ_FETCHER_BUSY_MASK                                                            0x00100000L
#define CP_CPF_BUSY_STAT__HQD_EOP_FETCHER_BUSY_MASK                                                           0x00200000L
#define CP_CPF_BUSY_STAT__HQD_CONSUMED_RPTR_BUSY_MASK                                                         0x00400000L
#define CP_CPF_BUSY_STAT__HQD_FETCHER_ARB_BUSY_MASK                                                           0x00800000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_ALIGN_BUSY_MASK                                                             0x01000000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_EOP_BUSY_MASK                                                               0x02000000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_IQ_BUSY_MASK                                                                0x04000000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_PQ_BUSY_MASK                                                                0x08000000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_IB_BUSY_MASK                                                                0x10000000L
#define CP_CPF_BUSY_STAT__HQD_WPTR_POLL_BUSY_MASK                                                             0x20000000L
#define CP_CPF_BUSY_STAT__HQD_PQ_BUSY_MASK                                                                    0x40000000L
#define CP_CPF_BUSY_STAT__HQD_IB_BUSY_MASK                                                                    0x80000000L
//CP_CPF_STALLED_STAT1
#define CP_CPF_STALLED_STAT1__RING_FETCHING_DATA__SHIFT                                                       0x0
#define CP_CPF_STALLED_STAT1__INDR1_FETCHING_DATA__SHIFT                                                      0x1
#define CP_CPF_STALLED_STAT1__INDR2_FETCHING_DATA__SHIFT                                                      0x2
#define CP_CPF_STALLED_STAT1__STATE_FETCHING_DATA__SHIFT                                                      0x3
#define CP_CPF_STALLED_STAT1__TCIU_WAITING_ON_FREE__SHIFT                                                     0x5
#define CP_CPF_STALLED_STAT1__TCIU_WAITING_ON_TAGS__SHIFT                                                     0x6
#define CP_CPF_STALLED_STAT1__UTCL2IU_WAITING_ON_FREE__SHIFT                                                  0x7
#define CP_CPF_STALLED_STAT1__UTCL2IU_WAITING_ON_TAGS__SHIFT                                                  0x8
#define CP_CPF_STALLED_STAT1__GFX_UTCL1_WAITING_ON_TRANS__SHIFT                                               0x9
#define CP_CPF_STALLED_STAT1__CMP_UTCL1_WAITING_ON_TRANS__SHIFT                                               0xa
#define CP_CPF_STALLED_STAT1__RCIU_WAITING_ON_FREE__SHIFT                                                     0xb
#define CP_CPF_STALLED_STAT1__RING_FETCHING_DATA_MASK                                                         0x00000001L
#define CP_CPF_STALLED_STAT1__INDR1_FETCHING_DATA_MASK                                                        0x00000002L
#define CP_CPF_STALLED_STAT1__INDR2_FETCHING_DATA_MASK                                                        0x00000004L
#define CP_CPF_STALLED_STAT1__STATE_FETCHING_DATA_MASK                                                        0x00000008L
#define CP_CPF_STALLED_STAT1__TCIU_WAITING_ON_FREE_MASK                                                       0x00000020L
#define CP_CPF_STALLED_STAT1__TCIU_WAITING_ON_TAGS_MASK                                                       0x00000040L
#define CP_CPF_STALLED_STAT1__UTCL2IU_WAITING_ON_FREE_MASK                                                    0x00000080L
#define CP_CPF_STALLED_STAT1__UTCL2IU_WAITING_ON_TAGS_MASK                                                    0x00000100L
#define CP_CPF_STALLED_STAT1__GFX_UTCL1_WAITING_ON_TRANS_MASK                                                 0x00000200L
#define CP_CPF_STALLED_STAT1__CMP_UTCL1_WAITING_ON_TRANS_MASK                                                 0x00000400L
#define CP_CPF_STALLED_STAT1__RCIU_WAITING_ON_FREE_MASK                                                       0x00000800L
//CP_CPC_GRBM_FREE_COUNT
#define CP_CPC_GRBM_FREE_COUNT__FREE_COUNT__SHIFT                                                             0x0
#define CP_CPC_GRBM_FREE_COUNT__FREE_COUNT_MASK                                                               0x0000003FL
//CP_MEC_CNTL
#define CP_MEC_CNTL__MEC_INVALIDATE_ICACHE__SHIFT                                                             0x4
#define CP_MEC_CNTL__MEC_ME1_PIPE0_RESET__SHIFT                                                               0x10
#define CP_MEC_CNTL__MEC_ME1_PIPE1_RESET__SHIFT                                                               0x11
#define CP_MEC_CNTL__MEC_ME1_PIPE2_RESET__SHIFT                                                               0x12
#define CP_MEC_CNTL__MEC_ME1_PIPE3_RESET__SHIFT                                                               0x13
#define CP_MEC_CNTL__MEC_ME2_PIPE0_RESET__SHIFT                                                               0x14
#define CP_MEC_CNTL__MEC_ME2_PIPE1_RESET__SHIFT                                                               0x15
#define CP_MEC_CNTL__MEC_ME2_HALT__SHIFT                                                                      0x1c
#define CP_MEC_CNTL__MEC_ME2_STEP__SHIFT                                                                      0x1d
#define CP_MEC_CNTL__MEC_ME1_HALT__SHIFT                                                                      0x1e
#define CP_MEC_CNTL__MEC_ME1_STEP__SHIFT                                                                      0x1f
#define CP_MEC_CNTL__MEC_INVALIDATE_ICACHE_MASK                                                               0x00000010L
#define CP_MEC_CNTL__MEC_ME1_PIPE0_RESET_MASK                                                                 0x00010000L
#define CP_MEC_CNTL__MEC_ME1_PIPE1_RESET_MASK                                                                 0x00020000L
#define CP_MEC_CNTL__MEC_ME1_PIPE2_RESET_MASK                                                                 0x00040000L
#define CP_MEC_CNTL__MEC_ME1_PIPE3_RESET_MASK                                                                 0x00080000L
#define CP_MEC_CNTL__MEC_ME2_PIPE0_RESET_MASK                                                                 0x00100000L
#define CP_MEC_CNTL__MEC_ME2_PIPE1_RESET_MASK                                                                 0x00200000L
#define CP_MEC_CNTL__MEC_ME2_HALT_MASK                                                                        0x10000000L
#define CP_MEC_CNTL__MEC_ME2_STEP_MASK                                                                        0x20000000L
#define CP_MEC_CNTL__MEC_ME1_HALT_MASK                                                                        0x40000000L
#define CP_MEC_CNTL__MEC_ME1_STEP_MASK                                                                        0x80000000L
//CP_MEC_ME1_HEADER_DUMP
#define CP_MEC_ME1_HEADER_DUMP__HEADER_DUMP__SHIFT                                                            0x0
#define CP_MEC_ME1_HEADER_DUMP__HEADER_DUMP_MASK                                                              0xFFFFFFFFL
//CP_MEC_ME2_HEADER_DUMP
#define CP_MEC_ME2_HEADER_DUMP__HEADER_DUMP__SHIFT                                                            0x0
#define CP_MEC_ME2_HEADER_DUMP__HEADER_DUMP_MASK                                                              0xFFFFFFFFL
//CP_CPC_SCRATCH_INDEX
#define CP_CPC_SCRATCH_INDEX__SCRATCH_INDEX__SHIFT                                                            0x0
#define CP_CPC_SCRATCH_INDEX__SCRATCH_INDEX_MASK                                                              0x000001FFL
//CP_CPC_SCRATCH_DATA
#define CP_CPC_SCRATCH_DATA__SCRATCH_DATA__SHIFT                                                              0x0
#define CP_CPC_SCRATCH_DATA__SCRATCH_DATA_MASK                                                                0xFFFFFFFFL
//CP_CPF_GRBM_FREE_COUNT
#define CP_CPF_GRBM_FREE_COUNT__FREE_COUNT__SHIFT                                                             0x0
#define CP_CPF_GRBM_FREE_COUNT__FREE_COUNT_MASK                                                               0x00000007L
//CP_CPC_HALT_HYST_COUNT
#define CP_CPC_HALT_HYST_COUNT__COUNT__SHIFT                                                                  0x0
#define CP_CPC_HALT_HYST_COUNT__COUNT_MASK                                                                    0x0000000FL
//CP_PRT_LOD_STATS_CNTL0
#define CP_PRT_LOD_STATS_CNTL0__BU_SIZE__SHIFT                                                                0x0
#define CP_PRT_LOD_STATS_CNTL0__BU_SIZE_MASK                                                                  0xFFFFFFFFL
//CP_PRT_LOD_STATS_CNTL1
#define CP_PRT_LOD_STATS_CNTL1__BASE_LO__SHIFT                                                                0x0
#define CP_PRT_LOD_STATS_CNTL1__BASE_LO_MASK                                                                  0xFFFFFFFFL
//CP_PRT_LOD_STATS_CNTL2
#define CP_PRT_LOD_STATS_CNTL2__BASE_HI__SHIFT                                                                0x0
#define CP_PRT_LOD_STATS_CNTL2__BASE_HI_MASK                                                                  0x000003FFL
//CP_PRT_LOD_STATS_CNTL3
#define CP_PRT_LOD_STATS_CNTL3__INTERVAL__SHIFT                                                               0x2
#define CP_PRT_LOD_STATS_CNTL3__RESET_CNT__SHIFT                                                              0xa
#define CP_PRT_LOD_STATS_CNTL3__RESET_FORCE__SHIFT                                                            0x12
#define CP_PRT_LOD_STATS_CNTL3__REPORT_AND_RESET__SHIFT                                                       0x13
#define CP_PRT_LOD_STATS_CNTL3__MC_VMID__SHIFT                                                                0x17
#define CP_PRT_LOD_STATS_CNTL3__CACHE_POLICY__SHIFT                                                           0x1c
#define CP_PRT_LOD_STATS_CNTL3__INTERVAL_MASK                                                                 0x000003FCL
#define CP_PRT_LOD_STATS_CNTL3__RESET_CNT_MASK                                                                0x0003FC00L
#define CP_PRT_LOD_STATS_CNTL3__RESET_FORCE_MASK                                                              0x00040000L
#define CP_PRT_LOD_STATS_CNTL3__REPORT_AND_RESET_MASK                                                         0x00080000L
#define CP_PRT_LOD_STATS_CNTL3__MC_VMID_MASK                                                                  0x07800000L
#define CP_PRT_LOD_STATS_CNTL3__CACHE_POLICY_MASK                                                             0x10000000L
//CP_CE_COMPARE_COUNT
#define CP_CE_COMPARE_COUNT__COMPARE_COUNT__SHIFT                                                             0x0
#define CP_CE_COMPARE_COUNT__COMPARE_COUNT_MASK                                                               0xFFFFFFFFL
//CP_CE_DE_COUNT
#define CP_CE_DE_COUNT__DRAW_ENGINE_COUNT__SHIFT                                                              0x0
#define CP_CE_DE_COUNT__DRAW_ENGINE_COUNT_MASK                                                                0xFFFFFFFFL
//CP_DE_CE_COUNT
#define CP_DE_CE_COUNT__CONST_ENGINE_COUNT__SHIFT                                                             0x0
#define CP_DE_CE_COUNT__CONST_ENGINE_COUNT_MASK                                                               0xFFFFFFFFL
//CP_DE_LAST_INVAL_COUNT
#define CP_DE_LAST_INVAL_COUNT__LAST_INVAL_COUNT__SHIFT                                                       0x0
#define CP_DE_LAST_INVAL_COUNT__LAST_INVAL_COUNT_MASK                                                         0xFFFFFFFFL
//CP_DE_DE_COUNT
#define CP_DE_DE_COUNT__DRAW_ENGINE_COUNT__SHIFT                                                              0x0
#define CP_DE_DE_COUNT__DRAW_ENGINE_COUNT_MASK                                                                0xFFFFFFFFL
//CP_STALLED_STAT3
#define CP_STALLED_STAT3__CE_TO_CSF_NOT_RDY_TO_RCV__SHIFT                                                     0x0
#define CP_STALLED_STAT3__CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV__SHIFT                                        0x1
#define CP_STALLED_STAT3__CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER__SHIFT                                     0x2
#define CP_STALLED_STAT3__CE_TO_RAM_INIT_NOT_RDY__SHIFT                                                       0x3
#define CP_STALLED_STAT3__CE_TO_RAM_DUMP_NOT_RDY__SHIFT                                                       0x4
#define CP_STALLED_STAT3__CE_TO_RAM_WRITE_NOT_RDY__SHIFT                                                      0x5
#define CP_STALLED_STAT3__CE_TO_INC_FIFO_NOT_RDY_TO_RCV__SHIFT                                                0x6
#define CP_STALLED_STAT3__CE_TO_WR_FIFO_NOT_RDY_TO_RCV__SHIFT                                                 0x7
#define CP_STALLED_STAT3__CE_WAITING_ON_BUFFER_DATA__SHIFT                                                    0xa
#define CP_STALLED_STAT3__CE_WAITING_ON_CE_BUFFER_FLAG__SHIFT                                                 0xb
#define CP_STALLED_STAT3__CE_WAITING_ON_DE_COUNTER__SHIFT                                                     0xc
#define CP_STALLED_STAT3__CE_WAITING_ON_DE_COUNTER_UNDERFLOW__SHIFT                                           0xd
#define CP_STALLED_STAT3__TCIU_WAITING_ON_FREE__SHIFT                                                         0xe
#define CP_STALLED_STAT3__TCIU_WAITING_ON_TAGS__SHIFT                                                         0xf
#define CP_STALLED_STAT3__CE_STALLED_ON_TC_WR_CONFIRM__SHIFT                                                  0x10
#define CP_STALLED_STAT3__CE_STALLED_ON_ATOMIC_RTN_DATA__SHIFT                                                0x11
#define CP_STALLED_STAT3__UTCL2IU_WAITING_ON_FREE__SHIFT                                                      0x12
#define CP_STALLED_STAT3__UTCL2IU_WAITING_ON_TAGS__SHIFT                                                      0x13
#define CP_STALLED_STAT3__UTCL1_WAITING_ON_TRANS__SHIFT                                                       0x14
#define CP_STALLED_STAT3__CE_TO_CSF_NOT_RDY_TO_RCV_MASK                                                       0x00000001L
#define CP_STALLED_STAT3__CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV_MASK                                          0x00000002L
#define CP_STALLED_STAT3__CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER_MASK                                       0x00000004L
#define CP_STALLED_STAT3__CE_TO_RAM_INIT_NOT_RDY_MASK                                                         0x00000008L
#define CP_STALLED_STAT3__CE_TO_RAM_DUMP_NOT_RDY_MASK                                                         0x00000010L
#define CP_STALLED_STAT3__CE_TO_RAM_WRITE_NOT_RDY_MASK                                                        0x00000020L
#define CP_STALLED_STAT3__CE_TO_INC_FIFO_NOT_RDY_TO_RCV_MASK                                                  0x00000040L
#define CP_STALLED_STAT3__CE_TO_WR_FIFO_NOT_RDY_TO_RCV_MASK                                                   0x00000080L
#define CP_STALLED_STAT3__CE_WAITING_ON_BUFFER_DATA_MASK                                                      0x00000400L
#define CP_STALLED_STAT3__CE_WAITING_ON_CE_BUFFER_FLAG_MASK                                                   0x00000800L
#define CP_STALLED_STAT3__CE_WAITING_ON_DE_COUNTER_MASK                                                       0x00001000L
#define CP_STALLED_STAT3__CE_WAITING_ON_DE_COUNTER_UNDERFLOW_MASK                                             0x00002000L
#define CP_STALLED_STAT3__TCIU_WAITING_ON_FREE_MASK                                                           0x00004000L
#define CP_STALLED_STAT3__TCIU_WAITING_ON_TAGS_MASK                                                           0x00008000L
#define CP_STALLED_STAT3__CE_STALLED_ON_TC_WR_CONFIRM_MASK                                                    0x00010000L
#define CP_STALLED_STAT3__CE_STALLED_ON_ATOMIC_RTN_DATA_MASK                                                  0x00020000L
#define CP_STALLED_STAT3__UTCL2IU_WAITING_ON_FREE_MASK                                                        0x00040000L
#define CP_STALLED_STAT3__UTCL2IU_WAITING_ON_TAGS_MASK                                                        0x00080000L
#define CP_STALLED_STAT3__UTCL1_WAITING_ON_TRANS_MASK                                                         0x00100000L
//CP_STALLED_STAT1
#define CP_STALLED_STAT1__RBIU_TO_DMA_NOT_RDY_TO_RCV__SHIFT                                                   0x0
#define CP_STALLED_STAT1__RBIU_TO_SEM_NOT_RDY_TO_RCV__SHIFT                                                   0x2
#define CP_STALLED_STAT1__RBIU_TO_MEMWR_NOT_RDY_TO_RCV__SHIFT                                                 0x4
#define CP_STALLED_STAT1__ME_HAS_ACTIVE_CE_BUFFER_FLAG__SHIFT                                                 0xa
#define CP_STALLED_STAT1__ME_HAS_ACTIVE_DE_BUFFER_FLAG__SHIFT                                                 0xb
#define CP_STALLED_STAT1__ME_STALLED_ON_TC_WR_CONFIRM__SHIFT                                                  0xc
#define CP_STALLED_STAT1__ME_STALLED_ON_ATOMIC_RTN_DATA__SHIFT                                                0xd
#define CP_STALLED_STAT1__ME_WAITING_ON_TC_READ_DATA__SHIFT                                                   0xe
#define CP_STALLED_STAT1__ME_WAITING_ON_REG_READ_DATA__SHIFT                                                  0xf
#define CP_STALLED_STAT1__RCIU_WAITING_ON_GDS_FREE__SHIFT                                                     0x17
#define CP_STALLED_STAT1__RCIU_WAITING_ON_GRBM_FREE__SHIFT                                                    0x18
#define CP_STALLED_STAT1__RCIU_WAITING_ON_VGT_FREE__SHIFT                                                     0x19
#define CP_STALLED_STAT1__RCIU_STALLED_ON_ME_READ__SHIFT                                                      0x1a
#define CP_STALLED_STAT1__RCIU_STALLED_ON_DMA_READ__SHIFT                                                     0x1b
#define CP_STALLED_STAT1__RCIU_STALLED_ON_APPEND_READ__SHIFT                                                  0x1c
#define CP_STALLED_STAT1__RCIU_HALTED_BY_REG_VIOLATION__SHIFT                                                 0x1d
#define CP_STALLED_STAT1__RBIU_TO_DMA_NOT_RDY_TO_RCV_MASK                                                     0x00000001L
#define CP_STALLED_STAT1__RBIU_TO_SEM_NOT_RDY_TO_RCV_MASK                                                     0x00000004L
#define CP_STALLED_STAT1__RBIU_TO_MEMWR_NOT_RDY_TO_RCV_MASK                                                   0x00000010L
#define CP_STALLED_STAT1__ME_HAS_ACTIVE_CE_BUFFER_FLAG_MASK                                                   0x00000400L
#define CP_STALLED_STAT1__ME_HAS_ACTIVE_DE_BUFFER_FLAG_MASK                                                   0x00000800L
#define CP_STALLED_STAT1__ME_STALLED_ON_TC_WR_CONFIRM_MASK                                                    0x00001000L
#define CP_STALLED_STAT1__ME_STALLED_ON_ATOMIC_RTN_DATA_MASK                                                  0x00002000L
#define CP_STALLED_STAT1__ME_WAITING_ON_TC_READ_DATA_MASK                                                     0x00004000L
#define CP_STALLED_STAT1__ME_WAITING_ON_REG_READ_DATA_MASK                                                    0x00008000L
#define CP_STALLED_STAT1__RCIU_WAITING_ON_GDS_FREE_MASK                                                       0x00800000L
#define CP_STALLED_STAT1__RCIU_WAITING_ON_GRBM_FREE_MASK                                                      0x01000000L
#define CP_STALLED_STAT1__RCIU_WAITING_ON_VGT_FREE_MASK                                                       0x02000000L
#define CP_STALLED_STAT1__RCIU_STALLED_ON_ME_READ_MASK                                                        0x04000000L
#define CP_STALLED_STAT1__RCIU_STALLED_ON_DMA_READ_MASK                                                       0x08000000L
#define CP_STALLED_STAT1__RCIU_STALLED_ON_APPEND_READ_MASK                                                    0x10000000L
#define CP_STALLED_STAT1__RCIU_HALTED_BY_REG_VIOLATION_MASK                                                   0x20000000L
//CP_STALLED_STAT2
#define CP_STALLED_STAT2__PFP_TO_CSF_NOT_RDY_TO_RCV__SHIFT                                                    0x0
#define CP_STALLED_STAT2__PFP_TO_MEQ_NOT_RDY_TO_RCV__SHIFT                                                    0x1
#define CP_STALLED_STAT2__PFP_TO_RCIU_NOT_RDY_TO_RCV__SHIFT                                                   0x2
#define CP_STALLED_STAT2__PFP_TO_VGT_WRITES_PENDING__SHIFT                                                    0x4
#define CP_STALLED_STAT2__PFP_RCIU_READ_PENDING__SHIFT                                                        0x5
#define CP_STALLED_STAT2__PFP_WAITING_ON_BUFFER_DATA__SHIFT                                                   0x8
#define CP_STALLED_STAT2__ME_WAIT_ON_CE_COUNTER__SHIFT                                                        0x9
#define CP_STALLED_STAT2__ME_WAIT_ON_AVAIL_BUFFER__SHIFT                                                      0xa
#define CP_STALLED_STAT2__GFX_CNTX_NOT_AVAIL_TO_ME__SHIFT                                                     0xb
#define CP_STALLED_STAT2__ME_RCIU_NOT_RDY_TO_RCV__SHIFT                                                       0xc
#define CP_STALLED_STAT2__ME_TO_CONST_NOT_RDY_TO_RCV__SHIFT                                                   0xd
#define CP_STALLED_STAT2__ME_WAITING_DATA_FROM_PFP__SHIFT                                                     0xe
#define CP_STALLED_STAT2__ME_WAITING_ON_PARTIAL_FLUSH__SHIFT                                                  0xf
#define CP_STALLED_STAT2__MEQ_TO_ME_NOT_RDY_TO_RCV__SHIFT                                                     0x10
#define CP_STALLED_STAT2__STQ_TO_ME_NOT_RDY_TO_RCV__SHIFT                                                     0x11
#define CP_STALLED_STAT2__ME_WAITING_DATA_FROM_STQ__SHIFT                                                     0x12
#define CP_STALLED_STAT2__PFP_STALLED_ON_TC_WR_CONFIRM__SHIFT                                                 0x13
#define CP_STALLED_STAT2__PFP_STALLED_ON_ATOMIC_RTN_DATA__SHIFT                                               0x14
#define CP_STALLED_STAT2__EOPD_FIFO_NEEDS_SC_EOP_DONE__SHIFT                                                  0x15
#define CP_STALLED_STAT2__EOPD_FIFO_NEEDS_WR_CONFIRM__SHIFT                                                   0x16
#define CP_STALLED_STAT2__STRMO_WR_OF_PRIM_DATA_PENDING__SHIFT                                                0x17
#define CP_STALLED_STAT2__PIPE_STATS_WR_DATA_PENDING__SHIFT                                                   0x18
#define CP_STALLED_STAT2__APPEND_RDY_WAIT_ON_CS_DONE__SHIFT                                                   0x19
#define CP_STALLED_STAT2__APPEND_RDY_WAIT_ON_PS_DONE__SHIFT                                                   0x1a
#define CP_STALLED_STAT2__APPEND_WAIT_ON_WR_CONFIRM__SHIFT                                                    0x1b
#define CP_STALLED_STAT2__APPEND_ACTIVE_PARTITION__SHIFT                                                      0x1c
#define CP_STALLED_STAT2__APPEND_WAITING_TO_SEND_MEMWRITE__SHIFT                                              0x1d
#define CP_STALLED_STAT2__SURF_SYNC_NEEDS_IDLE_CNTXS__SHIFT                                                   0x1e
#define CP_STALLED_STAT2__SURF_SYNC_NEEDS_ALL_CLEAN__SHIFT                                                    0x1f
#define CP_STALLED_STAT2__PFP_TO_CSF_NOT_RDY_TO_RCV_MASK                                                      0x00000001L
#define CP_STALLED_STAT2__PFP_TO_MEQ_NOT_RDY_TO_RCV_MASK                                                      0x00000002L
#define CP_STALLED_STAT2__PFP_TO_RCIU_NOT_RDY_TO_RCV_MASK                                                     0x00000004L
#define CP_STALLED_STAT2__PFP_TO_VGT_WRITES_PENDING_MASK                                                      0x00000010L
#define CP_STALLED_STAT2__PFP_RCIU_READ_PENDING_MASK                                                          0x00000020L
#define CP_STALLED_STAT2__PFP_WAITING_ON_BUFFER_DATA_MASK                                                     0x00000100L
#define CP_STALLED_STAT2__ME_WAIT_ON_CE_COUNTER_MASK                                                          0x00000200L
#define CP_STALLED_STAT2__ME_WAIT_ON_AVAIL_BUFFER_MASK                                                        0x00000400L
#define CP_STALLED_STAT2__GFX_CNTX_NOT_AVAIL_TO_ME_MASK                                                       0x00000800L
#define CP_STALLED_STAT2__ME_RCIU_NOT_RDY_TO_RCV_MASK                                                         0x00001000L
#define CP_STALLED_STAT2__ME_TO_CONST_NOT_RDY_TO_RCV_MASK                                                     0x00002000L
#define CP_STALLED_STAT2__ME_WAITING_DATA_FROM_PFP_MASK                                                       0x00004000L
#define CP_STALLED_STAT2__ME_WAITING_ON_PARTIAL_FLUSH_MASK                                                    0x00008000L
#define CP_STALLED_STAT2__MEQ_TO_ME_NOT_RDY_TO_RCV_MASK                                                       0x00010000L
#define CP_STALLED_STAT2__STQ_TO_ME_NOT_RDY_TO_RCV_MASK                                                       0x00020000L
#define CP_STALLED_STAT2__ME_WAITING_DATA_FROM_STQ_MASK                                                       0x00040000L
#define CP_STALLED_STAT2__PFP_STALLED_ON_TC_WR_CONFIRM_MASK                                                   0x00080000L
#define CP_STALLED_STAT2__PFP_STALLED_ON_ATOMIC_RTN_DATA_MASK                                                 0x00100000L
#define CP_STALLED_STAT2__EOPD_FIFO_NEEDS_SC_EOP_DONE_MASK                                                    0x00200000L
#define CP_STALLED_STAT2__EOPD_FIFO_NEEDS_WR_CONFIRM_MASK                                                     0x00400000L
#define CP_STALLED_STAT2__STRMO_WR_OF_PRIM_DATA_PENDING_MASK                                                  0x00800000L
#define CP_STALLED_STAT2__PIPE_STATS_WR_DATA_PENDING_MASK                                                     0x01000000L
#define CP_STALLED_STAT2__APPEND_RDY_WAIT_ON_CS_DONE_MASK                                                     0x02000000L
#define CP_STALLED_STAT2__APPEND_RDY_WAIT_ON_PS_DONE_MASK                                                     0x04000000L
#define CP_STALLED_STAT2__APPEND_WAIT_ON_WR_CONFIRM_MASK                                                      0x08000000L
#define CP_STALLED_STAT2__APPEND_ACTIVE_PARTITION_MASK                                                        0x10000000L
#define CP_STALLED_STAT2__APPEND_WAITING_TO_SEND_MEMWRITE_MASK                                                0x20000000L
#define CP_STALLED_STAT2__SURF_SYNC_NEEDS_IDLE_CNTXS_MASK                                                     0x40000000L
#define CP_STALLED_STAT2__SURF_SYNC_NEEDS_ALL_CLEAN_MASK                                                      0x80000000L
//CP_BUSY_STAT
#define CP_BUSY_STAT__REG_BUS_FIFO_BUSY__SHIFT                                                                0x0
#define CP_BUSY_STAT__COHER_CNT_NEQ_ZERO__SHIFT                                                               0x6
#define CP_BUSY_STAT__PFP_PARSING_PACKETS__SHIFT                                                              0x7
#define CP_BUSY_STAT__ME_PARSING_PACKETS__SHIFT                                                               0x8
#define CP_BUSY_STAT__RCIU_PFP_BUSY__SHIFT                                                                    0x9
#define CP_BUSY_STAT__RCIU_ME_BUSY__SHIFT                                                                     0xa
#define CP_BUSY_STAT__SEM_CMDFIFO_NOT_EMPTY__SHIFT                                                            0xc
#define CP_BUSY_STAT__SEM_FAILED_AND_HOLDING__SHIFT                                                           0xd
#define CP_BUSY_STAT__SEM_POLLING_FOR_PASS__SHIFT                                                             0xe
#define CP_BUSY_STAT__GFX_CONTEXT_BUSY__SHIFT                                                                 0xf
#define CP_BUSY_STAT__ME_PARSER_BUSY__SHIFT                                                                   0x11
#define CP_BUSY_STAT__EOP_DONE_BUSY__SHIFT                                                                    0x12
#define CP_BUSY_STAT__STRM_OUT_BUSY__SHIFT                                                                    0x13
#define CP_BUSY_STAT__PIPE_STATS_BUSY__SHIFT                                                                  0x14
#define CP_BUSY_STAT__RCIU_CE_BUSY__SHIFT                                                                     0x15
#define CP_BUSY_STAT__CE_PARSING_PACKETS__SHIFT                                                               0x16
#define CP_BUSY_STAT__REG_BUS_FIFO_BUSY_MASK                                                                  0x00000001L
#define CP_BUSY_STAT__COHER_CNT_NEQ_ZERO_MASK                                                                 0x00000040L
#define CP_BUSY_STAT__PFP_PARSING_PACKETS_MASK                                                                0x00000080L
#define CP_BUSY_STAT__ME_PARSING_PACKETS_MASK                                                                 0x00000100L
#define CP_BUSY_STAT__RCIU_PFP_BUSY_MASK                                                                      0x00000200L
#define CP_BUSY_STAT__RCIU_ME_BUSY_MASK                                                                       0x00000400L
#define CP_BUSY_STAT__SEM_CMDFIFO_NOT_EMPTY_MASK                                                              0x00001000L
#define CP_BUSY_STAT__SEM_FAILED_AND_HOLDING_MASK                                                             0x00002000L
#define CP_BUSY_STAT__SEM_POLLING_FOR_PASS_MASK                                                               0x00004000L
#define CP_BUSY_STAT__GFX_CONTEXT_BUSY_MASK                                                                   0x00008000L
#define CP_BUSY_STAT__ME_PARSER_BUSY_MASK                                                                     0x00020000L
#define CP_BUSY_STAT__EOP_DONE_BUSY_MASK                                                                      0x00040000L
#define CP_BUSY_STAT__STRM_OUT_BUSY_MASK                                                                      0x00080000L
#define CP_BUSY_STAT__PIPE_STATS_BUSY_MASK                                                                    0x00100000L
#define CP_BUSY_STAT__RCIU_CE_BUSY_MASK                                                                       0x00200000L
#define CP_BUSY_STAT__CE_PARSING_PACKETS_MASK                                                                 0x00400000L
//CP_STAT
#define CP_STAT__ROQ_RING_BUSY__SHIFT                                                                         0x9
#define CP_STAT__ROQ_INDIRECT1_BUSY__SHIFT                                                                    0xa
#define CP_STAT__ROQ_INDIRECT2_BUSY__SHIFT                                                                    0xb
#define CP_STAT__ROQ_STATE_BUSY__SHIFT                                                                        0xc
#define CP_STAT__DC_BUSY__SHIFT                                                                               0xd
#define CP_STAT__UTCL2IU_BUSY__SHIFT                                                                          0xe
#define CP_STAT__PFP_BUSY__SHIFT                                                                              0xf
#define CP_STAT__MEQ_BUSY__SHIFT                                                                              0x10
#define CP_STAT__ME_BUSY__SHIFT                                                                               0x11
#define CP_STAT__QUERY_BUSY__SHIFT                                                                            0x12
#define CP_STAT__SEMAPHORE_BUSY__SHIFT                                                                        0x13
#define CP_STAT__INTERRUPT_BUSY__SHIFT                                                                        0x14
#define CP_STAT__SURFACE_SYNC_BUSY__SHIFT                                                                     0x15
#define CP_STAT__DMA_BUSY__SHIFT                                                                              0x16
#define CP_STAT__RCIU_BUSY__SHIFT                                                                             0x17
#define CP_STAT__SCRATCH_RAM_BUSY__SHIFT                                                                      0x18
#define CP_STAT__CE_BUSY__SHIFT                                                                               0x1a
#define CP_STAT__TCIU_BUSY__SHIFT                                                                             0x1b
#define CP_STAT__ROQ_CE_RING_BUSY__SHIFT                                                                      0x1c
#define CP_STAT__ROQ_CE_INDIRECT1_BUSY__SHIFT                                                                 0x1d
#define CP_STAT__ROQ_CE_INDIRECT2_BUSY__SHIFT                                                                 0x1e
#define CP_STAT__CP_BUSY__SHIFT                                                                               0x1f
#define CP_STAT__ROQ_RING_BUSY_MASK                                                                           0x00000200L
#define CP_STAT__ROQ_INDIRECT1_BUSY_MASK                                                                      0x00000400L
#define CP_STAT__ROQ_INDIRECT2_BUSY_MASK                                                                      0x00000800L
#define CP_STAT__ROQ_STATE_BUSY_MASK                                                                          0x00001000L
#define CP_STAT__DC_BUSY_MASK                                                                                 0x00002000L
#define CP_STAT__UTCL2IU_BUSY_MASK                                                                            0x00004000L
#define CP_STAT__PFP_BUSY_MASK                                                                                0x00008000L
#define CP_STAT__MEQ_BUSY_MASK                                                                                0x00010000L
#define CP_STAT__ME_BUSY_MASK                                                                                 0x00020000L
#define CP_STAT__QUERY_BUSY_MASK                                                                              0x00040000L
#define CP_STAT__SEMAPHORE_BUSY_MASK                                                                          0x00080000L
#define CP_STAT__INTERRUPT_BUSY_MASK                                                                          0x00100000L
#define CP_STAT__SURFACE_SYNC_BUSY_MASK                                                                       0x00200000L
#define CP_STAT__DMA_BUSY_MASK                                                                                0x00400000L
#define CP_STAT__RCIU_BUSY_MASK                                                                               0x00800000L
#define CP_STAT__SCRATCH_RAM_BUSY_MASK                                                                        0x01000000L
#define CP_STAT__CE_BUSY_MASK                                                                                 0x04000000L
#define CP_STAT__TCIU_BUSY_MASK                                                                               0x08000000L
#define CP_STAT__ROQ_CE_RING_BUSY_MASK                                                                        0x10000000L
#define CP_STAT__ROQ_CE_INDIRECT1_BUSY_MASK                                                                   0x20000000L
#define CP_STAT__ROQ_CE_INDIRECT2_BUSY_MASK                                                                   0x40000000L
#define CP_STAT__CP_BUSY_MASK                                                                                 0x80000000L
//CP_ME_HEADER_DUMP
#define CP_ME_HEADER_DUMP__ME_HEADER_DUMP__SHIFT                                                              0x0
#define CP_ME_HEADER_DUMP__ME_HEADER_DUMP_MASK                                                                0xFFFFFFFFL
//CP_PFP_HEADER_DUMP
#define CP_PFP_HEADER_DUMP__PFP_HEADER_DUMP__SHIFT                                                            0x0
#define CP_PFP_HEADER_DUMP__PFP_HEADER_DUMP_MASK                                                              0xFFFFFFFFL
//CP_GRBM_FREE_COUNT
#define CP_GRBM_FREE_COUNT__FREE_COUNT__SHIFT                                                                 0x0
#define CP_GRBM_FREE_COUNT__FREE_COUNT_GDS__SHIFT                                                             0x8
#define CP_GRBM_FREE_COUNT__FREE_COUNT_PFP__SHIFT                                                             0x10
#define CP_GRBM_FREE_COUNT__FREE_COUNT_MASK                                                                   0x0000003FL
#define CP_GRBM_FREE_COUNT__FREE_COUNT_GDS_MASK                                                               0x00003F00L
#define CP_GRBM_FREE_COUNT__FREE_COUNT_PFP_MASK                                                               0x003F0000L
//CP_CE_HEADER_DUMP
#define CP_CE_HEADER_DUMP__CE_HEADER_DUMP__SHIFT                                                              0x0
#define CP_CE_HEADER_DUMP__CE_HEADER_DUMP_MASK                                                                0xFFFFFFFFL
//CP_PFP_INSTR_PNTR
#define CP_PFP_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                  0x0
#define CP_PFP_INSTR_PNTR__INSTR_PNTR_MASK                                                                    0x0000FFFFL
//CP_ME_INSTR_PNTR
#define CP_ME_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                   0x0
#define CP_ME_INSTR_PNTR__INSTR_PNTR_MASK                                                                     0x0000FFFFL
//CP_CE_INSTR_PNTR
#define CP_CE_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                   0x0
#define CP_CE_INSTR_PNTR__INSTR_PNTR_MASK                                                                     0x0000FFFFL
//CP_MEC1_INSTR_PNTR
#define CP_MEC1_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                 0x0
#define CP_MEC1_INSTR_PNTR__INSTR_PNTR_MASK                                                                   0x0000FFFFL
//CP_MEC2_INSTR_PNTR
#define CP_MEC2_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                 0x0
#define CP_MEC2_INSTR_PNTR__INSTR_PNTR_MASK                                                                   0x0000FFFFL
//CP_CSF_STAT
#define CP_CSF_STAT__BUFFER_REQUEST_COUNT__SHIFT                                                              0x8
#define CP_CSF_STAT__BUFFER_REQUEST_COUNT_MASK                                                                0x0001FF00L
//CP_ME_CNTL
#define CP_ME_CNTL__CE_INVALIDATE_ICACHE__SHIFT                                                               0x4
#define CP_ME_CNTL__PFP_INVALIDATE_ICACHE__SHIFT                                                              0x6
#define CP_ME_CNTL__ME_INVALIDATE_ICACHE__SHIFT                                                               0x8
#define CP_ME_CNTL__CE_PIPE0_RESET__SHIFT                                                                     0x10
#define CP_ME_CNTL__CE_PIPE1_RESET__SHIFT                                                                     0x11
#define CP_ME_CNTL__PFP_PIPE0_RESET__SHIFT                                                                    0x12
#define CP_ME_CNTL__PFP_PIPE1_RESET__SHIFT                                                                    0x13
#define CP_ME_CNTL__ME_PIPE0_RESET__SHIFT                                                                     0x14
#define CP_ME_CNTL__ME_PIPE1_RESET__SHIFT                                                                     0x15
#define CP_ME_CNTL__CE_HALT__SHIFT                                                                            0x18
#define CP_ME_CNTL__CE_STEP__SHIFT                                                                            0x19
#define CP_ME_CNTL__PFP_HALT__SHIFT                                                                           0x1a
#define CP_ME_CNTL__PFP_STEP__SHIFT                                                                           0x1b
#define CP_ME_CNTL__ME_HALT__SHIFT                                                                            0x1c
#define CP_ME_CNTL__ME_STEP__SHIFT                                                                            0x1d
#define CP_ME_CNTL__CE_INVALIDATE_ICACHE_MASK                                                                 0x00000010L
#define CP_ME_CNTL__PFP_INVALIDATE_ICACHE_MASK                                                                0x00000040L
#define CP_ME_CNTL__ME_INVALIDATE_ICACHE_MASK                                                                 0x00000100L
#define CP_ME_CNTL__CE_PIPE0_RESET_MASK                                                                       0x00010000L
#define CP_ME_CNTL__CE_PIPE1_RESET_MASK                                                                       0x00020000L
#define CP_ME_CNTL__PFP_PIPE0_RESET_MASK                                                                      0x00040000L
#define CP_ME_CNTL__PFP_PIPE1_RESET_MASK                                                                      0x00080000L
#define CP_ME_CNTL__ME_PIPE0_RESET_MASK                                                                       0x00100000L
#define CP_ME_CNTL__ME_PIPE1_RESET_MASK                                                                       0x00200000L
#define CP_ME_CNTL__CE_HALT_MASK                                                                              0x01000000L
#define CP_ME_CNTL__CE_STEP_MASK                                                                              0x02000000L
#define CP_ME_CNTL__PFP_HALT_MASK                                                                             0x04000000L
#define CP_ME_CNTL__PFP_STEP_MASK                                                                             0x08000000L
#define CP_ME_CNTL__ME_HALT_MASK                                                                              0x10000000L
#define CP_ME_CNTL__ME_STEP_MASK                                                                              0x20000000L
//CP_CNTX_STAT
#define CP_CNTX_STAT__ACTIVE_HP3D_CONTEXTS__SHIFT                                                             0x0
#define CP_CNTX_STAT__CURRENT_HP3D_CONTEXT__SHIFT                                                             0x8
#define CP_CNTX_STAT__ACTIVE_GFX_CONTEXTS__SHIFT                                                              0x14
#define CP_CNTX_STAT__CURRENT_GFX_CONTEXT__SHIFT                                                              0x1c
#define CP_CNTX_STAT__ACTIVE_HP3D_CONTEXTS_MASK                                                               0x000000FFL
#define CP_CNTX_STAT__CURRENT_HP3D_CONTEXT_MASK                                                               0x00000700L
#define CP_CNTX_STAT__ACTIVE_GFX_CONTEXTS_MASK                                                                0x0FF00000L
#define CP_CNTX_STAT__CURRENT_GFX_CONTEXT_MASK                                                                0x70000000L
//CP_ME_PREEMPTION
#define CP_ME_PREEMPTION__OBSOLETE__SHIFT                                                                     0x0
#define CP_ME_PREEMPTION__OBSOLETE_MASK                                                                       0x00000001L
//CP_ROQ_THRESHOLDS
#define CP_ROQ_THRESHOLDS__IB1_START__SHIFT                                                                   0x0
#define CP_ROQ_THRESHOLDS__IB2_START__SHIFT                                                                   0x8
#define CP_ROQ_THRESHOLDS__IB1_START_MASK                                                                     0x000000FFL
#define CP_ROQ_THRESHOLDS__IB2_START_MASK                                                                     0x0000FF00L
//CP_MEQ_STQ_THRESHOLD
#define CP_MEQ_STQ_THRESHOLD__STQ_START__SHIFT                                                                0x0
#define CP_MEQ_STQ_THRESHOLD__STQ_START_MASK                                                                  0x000000FFL
//CP_RB2_RPTR
#define CP_RB2_RPTR__RB_RPTR__SHIFT                                                                           0x0
#define CP_RB2_RPTR__RB_RPTR_MASK                                                                             0x000FFFFFL
//CP_RB1_RPTR
#define CP_RB1_RPTR__RB_RPTR__SHIFT                                                                           0x0
#define CP_RB1_RPTR__RB_RPTR_MASK                                                                             0x000FFFFFL
//CP_RB0_RPTR
#define CP_RB0_RPTR__RB_RPTR__SHIFT                                                                           0x0
#define CP_RB0_RPTR__RB_RPTR_MASK                                                                             0x000FFFFFL
//CP_RB_RPTR
#define CP_RB_RPTR__RB_RPTR__SHIFT                                                                            0x0
#define CP_RB_RPTR__RB_RPTR_MASK                                                                              0x000FFFFFL
//CP_RB_WPTR_DELAY
#define CP_RB_WPTR_DELAY__PRE_WRITE_TIMER__SHIFT                                                              0x0
#define CP_RB_WPTR_DELAY__PRE_WRITE_LIMIT__SHIFT                                                              0x1c
#define CP_RB_WPTR_DELAY__PRE_WRITE_TIMER_MASK                                                                0x0FFFFFFFL
#define CP_RB_WPTR_DELAY__PRE_WRITE_LIMIT_MASK                                                                0xF0000000L
//CP_RB_WPTR_POLL_CNTL
#define CP_RB_WPTR_POLL_CNTL__POLL_FREQUENCY__SHIFT                                                           0x0
#define CP_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                          0x10
#define CP_RB_WPTR_POLL_CNTL__POLL_FREQUENCY_MASK                                                             0x0000FFFFL
#define CP_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                            0xFFFF0000L
//CP_ROQ1_THRESHOLDS
#define CP_ROQ1_THRESHOLDS__RB1_START__SHIFT                                                                  0x0
#define CP_ROQ1_THRESHOLDS__RB2_START__SHIFT                                                                  0x8
#define CP_ROQ1_THRESHOLDS__R0_IB1_START__SHIFT                                                               0x10
#define CP_ROQ1_THRESHOLDS__R1_IB1_START__SHIFT                                                               0x18
#define CP_ROQ1_THRESHOLDS__RB1_START_MASK                                                                    0x000000FFL
#define CP_ROQ1_THRESHOLDS__RB2_START_MASK                                                                    0x0000FF00L
#define CP_ROQ1_THRESHOLDS__R0_IB1_START_MASK                                                                 0x00FF0000L
#define CP_ROQ1_THRESHOLDS__R1_IB1_START_MASK                                                                 0xFF000000L
//CP_ROQ2_THRESHOLDS
#define CP_ROQ2_THRESHOLDS__R2_IB1_START__SHIFT                                                               0x0
#define CP_ROQ2_THRESHOLDS__R0_IB2_START__SHIFT                                                               0x8
#define CP_ROQ2_THRESHOLDS__R1_IB2_START__SHIFT                                                               0x10
#define CP_ROQ2_THRESHOLDS__R2_IB2_START__SHIFT                                                               0x18
#define CP_ROQ2_THRESHOLDS__R2_IB1_START_MASK                                                                 0x000000FFL
#define CP_ROQ2_THRESHOLDS__R0_IB2_START_MASK                                                                 0x0000FF00L
#define CP_ROQ2_THRESHOLDS__R1_IB2_START_MASK                                                                 0x00FF0000L
#define CP_ROQ2_THRESHOLDS__R2_IB2_START_MASK                                                                 0xFF000000L
//CP_STQ_THRESHOLDS
#define CP_STQ_THRESHOLDS__STQ0_START__SHIFT                                                                  0x0
#define CP_STQ_THRESHOLDS__STQ1_START__SHIFT                                                                  0x8
#define CP_STQ_THRESHOLDS__STQ2_START__SHIFT                                                                  0x10
#define CP_STQ_THRESHOLDS__STQ0_START_MASK                                                                    0x000000FFL
#define CP_STQ_THRESHOLDS__STQ1_START_MASK                                                                    0x0000FF00L
#define CP_STQ_THRESHOLDS__STQ2_START_MASK                                                                    0x00FF0000L
//CP_QUEUE_THRESHOLDS
#define CP_QUEUE_THRESHOLDS__ROQ_IB1_START__SHIFT                                                             0x0
#define CP_QUEUE_THRESHOLDS__ROQ_IB2_START__SHIFT                                                             0x8
#define CP_QUEUE_THRESHOLDS__ROQ_IB1_START_MASK                                                               0x0000003FL
#define CP_QUEUE_THRESHOLDS__ROQ_IB2_START_MASK                                                               0x00003F00L
//CP_MEQ_THRESHOLDS
#define CP_MEQ_THRESHOLDS__MEQ1_START__SHIFT                                                                  0x0
#define CP_MEQ_THRESHOLDS__MEQ2_START__SHIFT                                                                  0x8
#define CP_MEQ_THRESHOLDS__MEQ1_START_MASK                                                                    0x000000FFL
#define CP_MEQ_THRESHOLDS__MEQ2_START_MASK                                                                    0x0000FF00L
//CP_ROQ_AVAIL
#define CP_ROQ_AVAIL__ROQ_CNT_RING__SHIFT                                                                     0x0
#define CP_ROQ_AVAIL__ROQ_CNT_IB1__SHIFT                                                                      0x10
#define CP_ROQ_AVAIL__ROQ_CNT_RING_MASK                                                                       0x000007FFL
#define CP_ROQ_AVAIL__ROQ_CNT_IB1_MASK                                                                        0x07FF0000L
//CP_STQ_AVAIL
#define CP_STQ_AVAIL__STQ_CNT__SHIFT                                                                          0x0
#define CP_STQ_AVAIL__STQ_CNT_MASK                                                                            0x000001FFL
//CP_ROQ2_AVAIL
#define CP_ROQ2_AVAIL__ROQ_CNT_IB2__SHIFT                                                                     0x0
#define CP_ROQ2_AVAIL__ROQ_CNT_IB2_MASK                                                                       0x000007FFL
//CP_MEQ_AVAIL
#define CP_MEQ_AVAIL__MEQ_CNT__SHIFT                                                                          0x0
#define CP_MEQ_AVAIL__MEQ_CNT_MASK                                                                            0x000003FFL
//CP_CMD_INDEX
#define CP_CMD_INDEX__CMD_INDEX__SHIFT                                                                        0x0
#define CP_CMD_INDEX__CMD_ME_SEL__SHIFT                                                                       0xc
#define CP_CMD_INDEX__CMD_QUEUE_SEL__SHIFT                                                                    0x10
#define CP_CMD_INDEX__CMD_INDEX_MASK                                                                          0x000007FFL
#define CP_CMD_INDEX__CMD_ME_SEL_MASK                                                                         0x00003000L
#define CP_CMD_INDEX__CMD_QUEUE_SEL_MASK                                                                      0x00070000L
//CP_CMD_DATA
#define CP_CMD_DATA__CMD_DATA__SHIFT                                                                          0x0
#define CP_CMD_DATA__CMD_DATA_MASK                                                                            0xFFFFFFFFL
//CP_ROQ_RB_STAT
#define CP_ROQ_RB_STAT__ROQ_RPTR_PRIMARY__SHIFT                                                               0x0
#define CP_ROQ_RB_STAT__ROQ_WPTR_PRIMARY__SHIFT                                                               0x10
#define CP_ROQ_RB_STAT__ROQ_RPTR_PRIMARY_MASK                                                                 0x000003FFL
#define CP_ROQ_RB_STAT__ROQ_WPTR_PRIMARY_MASK                                                                 0x03FF0000L
//CP_ROQ_IB1_STAT
#define CP_ROQ_IB1_STAT__ROQ_RPTR_INDIRECT1__SHIFT                                                            0x0
#define CP_ROQ_IB1_STAT__ROQ_WPTR_INDIRECT1__SHIFT                                                            0x10
#define CP_ROQ_IB1_STAT__ROQ_RPTR_INDIRECT1_MASK                                                              0x000003FFL
#define CP_ROQ_IB1_STAT__ROQ_WPTR_INDIRECT1_MASK                                                              0x03FF0000L
//CP_ROQ_IB2_STAT
#define CP_ROQ_IB2_STAT__ROQ_RPTR_INDIRECT2__SHIFT                                                            0x0
#define CP_ROQ_IB2_STAT__ROQ_WPTR_INDIRECT2__SHIFT                                                            0x10
#define CP_ROQ_IB2_STAT__ROQ_RPTR_INDIRECT2_MASK                                                              0x000003FFL
#define CP_ROQ_IB2_STAT__ROQ_WPTR_INDIRECT2_MASK                                                              0x03FF0000L
//CP_STQ_STAT
#define CP_STQ_STAT__STQ_RPTR__SHIFT                                                                          0x0
#define CP_STQ_STAT__STQ_RPTR_MASK                                                                            0x000003FFL
//CP_STQ_WR_STAT
#define CP_STQ_WR_STAT__STQ_WPTR__SHIFT                                                                       0x0
#define CP_STQ_WR_STAT__STQ_WPTR_MASK                                                                         0x000003FFL
//CP_MEQ_STAT
#define CP_MEQ_STAT__MEQ_RPTR__SHIFT                                                                          0x0
#define CP_MEQ_STAT__MEQ_WPTR__SHIFT                                                                          0x10
#define CP_MEQ_STAT__MEQ_RPTR_MASK                                                                            0x000003FFL
#define CP_MEQ_STAT__MEQ_WPTR_MASK                                                                            0x03FF0000L
//CP_CEQ1_AVAIL
#define CP_CEQ1_AVAIL__CEQ_CNT_RING__SHIFT                                                                    0x0
#define CP_CEQ1_AVAIL__CEQ_CNT_IB1__SHIFT                                                                     0x10
#define CP_CEQ1_AVAIL__CEQ_CNT_RING_MASK                                                                      0x000007FFL
#define CP_CEQ1_AVAIL__CEQ_CNT_IB1_MASK                                                                       0x07FF0000L
//CP_CEQ2_AVAIL
#define CP_CEQ2_AVAIL__CEQ_CNT_IB2__SHIFT                                                                     0x0
#define CP_CEQ2_AVAIL__CEQ_CNT_IB2_MASK                                                                       0x000007FFL
//CP_CE_ROQ_RB_STAT
#define CP_CE_ROQ_RB_STAT__CEQ_RPTR_PRIMARY__SHIFT                                                            0x0
#define CP_CE_ROQ_RB_STAT__CEQ_WPTR_PRIMARY__SHIFT                                                            0x10
#define CP_CE_ROQ_RB_STAT__CEQ_RPTR_PRIMARY_MASK                                                              0x000003FFL
#define CP_CE_ROQ_RB_STAT__CEQ_WPTR_PRIMARY_MASK                                                              0x03FF0000L
//CP_CE_ROQ_IB1_STAT
#define CP_CE_ROQ_IB1_STAT__CEQ_RPTR_INDIRECT1__SHIFT                                                         0x0
#define CP_CE_ROQ_IB1_STAT__CEQ_WPTR_INDIRECT1__SHIFT                                                         0x10
#define CP_CE_ROQ_IB1_STAT__CEQ_RPTR_INDIRECT1_MASK                                                           0x000003FFL
#define CP_CE_ROQ_IB1_STAT__CEQ_WPTR_INDIRECT1_MASK                                                           0x03FF0000L
//CP_CE_ROQ_IB2_STAT
#define CP_CE_ROQ_IB2_STAT__CEQ_RPTR_INDIRECT2__SHIFT                                                         0x0
#define CP_CE_ROQ_IB2_STAT__CEQ_WPTR_INDIRECT2__SHIFT                                                         0x10
#define CP_CE_ROQ_IB2_STAT__CEQ_RPTR_INDIRECT2_MASK                                                           0x000003FFL
#define CP_CE_ROQ_IB2_STAT__CEQ_WPTR_INDIRECT2_MASK                                                           0x03FF0000L
#define CP_INT_STAT_DEBUG__PRIV_INSTR_INT_ASSERTED__SHIFT                                                     0x16
#define CP_INT_STAT_DEBUG__PRIV_REG_INT_ASSERTED__SHIFT                                                       0x17
#define CP_INT_STAT_DEBUG__PRIV_INSTR_INT_ASSERTED_MASK                                                       0x00400000L
#define CP_INT_STAT_DEBUG__PRIV_REG_INT_ASSERTED_MASK                                                         0x00800000L


// addressBlock: gc_padec
//VGT_VTX_VECT_EJECT_REG
#define VGT_VTX_VECT_EJECT_REG__PRIM_COUNT__SHIFT                                                             0x0
#define VGT_VTX_VECT_EJECT_REG__PRIM_COUNT_MASK                                                               0x0000007FL
//VGT_DMA_DATA_FIFO_DEPTH
#define VGT_DMA_DATA_FIFO_DEPTH__DMA_DATA_FIFO_DEPTH__SHIFT                                                   0x0
#define VGT_DMA_DATA_FIFO_DEPTH__DMA2DRAW_FIFO_DEPTH__SHIFT                                                   0x9
#define VGT_DMA_DATA_FIFO_DEPTH__DMA_DATA_FIFO_DEPTH_MASK                                                     0x000001FFL
#define VGT_DMA_DATA_FIFO_DEPTH__DMA2DRAW_FIFO_DEPTH_MASK                                                     0x0007FE00L
//VGT_DMA_REQ_FIFO_DEPTH
#define VGT_DMA_REQ_FIFO_DEPTH__DMA_REQ_FIFO_DEPTH__SHIFT                                                     0x0
#define VGT_DMA_REQ_FIFO_DEPTH__DMA_REQ_FIFO_DEPTH_MASK                                                       0x0000003FL
//VGT_DRAW_INIT_FIFO_DEPTH
#define VGT_DRAW_INIT_FIFO_DEPTH__DRAW_INIT_FIFO_DEPTH__SHIFT                                                 0x0
#define VGT_DRAW_INIT_FIFO_DEPTH__DRAW_INIT_FIFO_DEPTH_MASK                                                   0x0000003FL
//VGT_LAST_COPY_STATE
#define VGT_LAST_COPY_STATE__SRC_STATE_ID__SHIFT                                                              0x0
#define VGT_LAST_COPY_STATE__DST_STATE_ID__SHIFT                                                              0x10
#define VGT_LAST_COPY_STATE__SRC_STATE_ID_MASK                                                                0x00000007L
#define VGT_LAST_COPY_STATE__DST_STATE_ID_MASK                                                                0x00070000L
//VGT_CACHE_INVALIDATION
#define VGT_CACHE_INVALIDATION__CACHE_INVALIDATION__SHIFT                                                     0x0
#define VGT_CACHE_INVALIDATION__DIS_INSTANCING_OPT__SHIFT                                                     0x4
#define VGT_CACHE_INVALIDATION__VS_NO_EXTRA_BUFFER__SHIFT                                                     0x5
#define VGT_CACHE_INVALIDATION__AUTO_INVLD_EN__SHIFT                                                          0x6
#define VGT_CACHE_INVALIDATION__USE_GS_DONE__SHIFT                                                            0x9
#define VGT_CACHE_INVALIDATION__DIS_RANGE_FULL_INVLD__SHIFT                                                   0xb
#define VGT_CACHE_INVALIDATION__GS_LATE_ALLOC_EN__SHIFT                                                       0xc
#define VGT_CACHE_INVALIDATION__STREAMOUT_FULL_FLUSH__SHIFT                                                   0xd
#define VGT_CACHE_INVALIDATION__ES_LIMIT__SHIFT                                                               0x10
#define VGT_CACHE_INVALIDATION__ENABLE_PING_PONG__SHIFT                                                       0x15
#define VGT_CACHE_INVALIDATION__OPT_FLOW_CNTL_1__SHIFT                                                        0x16
#define VGT_CACHE_INVALIDATION__OPT_FLOW_CNTL_2__SHIFT                                                        0x19
#define VGT_CACHE_INVALIDATION__EN_WAVE_MERGE__SHIFT                                                          0x1c
#define VGT_CACHE_INVALIDATION__ENABLE_PING_PONG_EOI__SHIFT                                                   0x1d
#define VGT_CACHE_INVALIDATION__CACHE_INVALIDATION_MASK                                                       0x00000003L
#define VGT_CACHE_INVALIDATION__DIS_INSTANCING_OPT_MASK                                                       0x00000010L
#define VGT_CACHE_INVALIDATION__VS_NO_EXTRA_BUFFER_MASK                                                       0x00000020L
#define VGT_CACHE_INVALIDATION__AUTO_INVLD_EN_MASK                                                            0x000000C0L
#define VGT_CACHE_INVALIDATION__USE_GS_DONE_MASK                                                              0x00000200L
#define VGT_CACHE_INVALIDATION__DIS_RANGE_FULL_INVLD_MASK                                                     0x00000800L
#define VGT_CACHE_INVALIDATION__GS_LATE_ALLOC_EN_MASK                                                         0x00001000L
#define VGT_CACHE_INVALIDATION__STREAMOUT_FULL_FLUSH_MASK                                                     0x00002000L
#define VGT_CACHE_INVALIDATION__ES_LIMIT_MASK                                                                 0x001F0000L
#define VGT_CACHE_INVALIDATION__ENABLE_PING_PONG_MASK                                                         0x00200000L
#define VGT_CACHE_INVALIDATION__OPT_FLOW_CNTL_1_MASK                                                          0x01C00000L
#define VGT_CACHE_INVALIDATION__OPT_FLOW_CNTL_2_MASK                                                          0x0E000000L
#define VGT_CACHE_INVALIDATION__EN_WAVE_MERGE_MASK                                                            0x10000000L
#define VGT_CACHE_INVALIDATION__ENABLE_PING_PONG_EOI_MASK                                                     0x20000000L
//VGT_STRMOUT_DELAY
#define VGT_STRMOUT_DELAY__SKIP_DELAY__SHIFT                                                                  0x0
#define VGT_STRMOUT_DELAY__SE0_WD_DELAY__SHIFT                                                                0x8
#define VGT_STRMOUT_DELAY__SE1_WD_DELAY__SHIFT                                                                0xb
#define VGT_STRMOUT_DELAY__SE2_WD_DELAY__SHIFT                                                                0xe
#define VGT_STRMOUT_DELAY__SE3_WD_DELAY__SHIFT                                                                0x11
#define VGT_STRMOUT_DELAY__SKIP_DELAY_MASK                                                                    0x000000FFL
#define VGT_STRMOUT_DELAY__SE0_WD_DELAY_MASK                                                                  0x00000700L
#define VGT_STRMOUT_DELAY__SE1_WD_DELAY_MASK                                                                  0x00003800L
#define VGT_STRMOUT_DELAY__SE2_WD_DELAY_MASK                                                                  0x0001C000L
#define VGT_STRMOUT_DELAY__SE3_WD_DELAY_MASK                                                                  0x000E0000L
//VGT_FIFO_DEPTHS
#define VGT_FIFO_DEPTHS__VS_DEALLOC_TBL_DEPTH__SHIFT                                                          0x0
#define VGT_FIFO_DEPTHS__RESERVED_0__SHIFT                                                                    0x7
#define VGT_FIFO_DEPTHS__CLIPP_FIFO_DEPTH__SHIFT                                                              0x8
#define VGT_FIFO_DEPTHS__HSINPUT_FIFO_DEPTH__SHIFT                                                            0x16
#define VGT_FIFO_DEPTHS__VS_DEALLOC_TBL_DEPTH_MASK                                                            0x0000007FL
#define VGT_FIFO_DEPTHS__RESERVED_0_MASK                                                                      0x00000080L
#define VGT_FIFO_DEPTHS__CLIPP_FIFO_DEPTH_MASK                                                                0x003FFF00L
#define VGT_FIFO_DEPTHS__HSINPUT_FIFO_DEPTH_MASK                                                              0x0FC00000L
//VGT_GS_VERTEX_REUSE
#define VGT_GS_VERTEX_REUSE__VERT_REUSE__SHIFT                                                                0x0
#define VGT_GS_VERTEX_REUSE__VERT_REUSE_MASK                                                                  0x0000001FL
//VGT_MC_LAT_CNTL
#define VGT_MC_LAT_CNTL__MC_TIME_STAMP_RES__SHIFT                                                             0x0
#define VGT_MC_LAT_CNTL__MC_TIME_STAMP_RES_MASK                                                               0x0000000FL
//IA_CNTL_STATUS
#define IA_CNTL_STATUS__IA_BUSY__SHIFT                                                                        0x0
#define IA_CNTL_STATUS__IA_DMA_BUSY__SHIFT                                                                    0x1
#define IA_CNTL_STATUS__IA_DMA_REQ_BUSY__SHIFT                                                                0x2
#define IA_CNTL_STATUS__IA_GRP_BUSY__SHIFT                                                                    0x3
#define IA_CNTL_STATUS__IA_ADC_BUSY__SHIFT                                                                    0x4
#define IA_CNTL_STATUS__IA_BUSY_MASK                                                                          0x00000001L
#define IA_CNTL_STATUS__IA_DMA_BUSY_MASK                                                                      0x00000002L
#define IA_CNTL_STATUS__IA_DMA_REQ_BUSY_MASK                                                                  0x00000004L
#define IA_CNTL_STATUS__IA_GRP_BUSY_MASK                                                                      0x00000008L
#define IA_CNTL_STATUS__IA_ADC_BUSY_MASK                                                                      0x00000010L
//VGT_CNTL_STATUS
#define VGT_CNTL_STATUS__VGT_BUSY__SHIFT                                                                      0x0
#define VGT_CNTL_STATUS__VGT_OUT_INDX_BUSY__SHIFT                                                             0x1
#define VGT_CNTL_STATUS__VGT_OUT_BUSY__SHIFT                                                                  0x2
#define VGT_CNTL_STATUS__VGT_PT_BUSY__SHIFT                                                                   0x3
#define VGT_CNTL_STATUS__VGT_TE_BUSY__SHIFT                                                                   0x4
#define VGT_CNTL_STATUS__VGT_VR_BUSY__SHIFT                                                                   0x5
#define VGT_CNTL_STATUS__VGT_PI_BUSY__SHIFT                                                                   0x6
#define VGT_CNTL_STATUS__VGT_GS_BUSY__SHIFT                                                                   0x7
#define VGT_CNTL_STATUS__VGT_HS_BUSY__SHIFT                                                                   0x8
#define VGT_CNTL_STATUS__VGT_TE11_BUSY__SHIFT                                                                 0x9
#define VGT_CNTL_STATUS__VGT_PRIMGEN_BUSY__SHIFT                                                              0xa
#define VGT_CNTL_STATUS__VGT_BUSY_MASK                                                                        0x00000001L
#define VGT_CNTL_STATUS__VGT_OUT_INDX_BUSY_MASK                                                               0x00000002L
#define VGT_CNTL_STATUS__VGT_OUT_BUSY_MASK                                                                    0x00000004L
#define VGT_CNTL_STATUS__VGT_PT_BUSY_MASK                                                                     0x00000008L
#define VGT_CNTL_STATUS__VGT_TE_BUSY_MASK                                                                     0x00000010L
#define VGT_CNTL_STATUS__VGT_VR_BUSY_MASK                                                                     0x00000020L
#define VGT_CNTL_STATUS__VGT_PI_BUSY_MASK                                                                     0x00000040L
#define VGT_CNTL_STATUS__VGT_GS_BUSY_MASK                                                                     0x00000080L
#define VGT_CNTL_STATUS__VGT_HS_BUSY_MASK                                                                     0x00000100L
#define VGT_CNTL_STATUS__VGT_TE11_BUSY_MASK                                                                   0x00000200L
#define VGT_CNTL_STATUS__VGT_PRIMGEN_BUSY_MASK                                                                0x00000400L
//WD_CNTL_STATUS
#define WD_CNTL_STATUS__WD_BUSY__SHIFT                                                                        0x0
#define WD_CNTL_STATUS__WD_SPL_DMA_BUSY__SHIFT                                                                0x1
#define WD_CNTL_STATUS__WD_SPL_DI_BUSY__SHIFT                                                                 0x2
#define WD_CNTL_STATUS__WD_ADC_BUSY__SHIFT                                                                    0x3
#define WD_CNTL_STATUS__WD_BUSY_MASK                                                                          0x00000001L
#define WD_CNTL_STATUS__WD_SPL_DMA_BUSY_MASK                                                                  0x00000002L
#define WD_CNTL_STATUS__WD_SPL_DI_BUSY_MASK                                                                   0x00000004L
#define WD_CNTL_STATUS__WD_ADC_BUSY_MASK                                                                      0x00000008L
//CC_GC_PRIM_CONFIG
#define CC_GC_PRIM_CONFIG__INACTIVE_IA__SHIFT                                                                 0x10
#define CC_GC_PRIM_CONFIG__INACTIVE_VGT_PA__SHIFT                                                             0x18
#define CC_GC_PRIM_CONFIG__INACTIVE_IA_MASK                                                                   0x00030000L
#define CC_GC_PRIM_CONFIG__INACTIVE_VGT_PA_MASK                                                               0x0F000000L
//GC_USER_PRIM_CONFIG
#define GC_USER_PRIM_CONFIG__INACTIVE_IA__SHIFT                                                               0x10
#define GC_USER_PRIM_CONFIG__INACTIVE_VGT_PA__SHIFT                                                           0x18
#define GC_USER_PRIM_CONFIG__INACTIVE_IA_MASK                                                                 0x00030000L
#define GC_USER_PRIM_CONFIG__INACTIVE_VGT_PA_MASK                                                             0x0F000000L
//WD_QOS
#define WD_QOS__DRAW_STALL__SHIFT                                                                             0x0
#define WD_QOS__DRAW_STALL_MASK                                                                               0x00000001L
//WD_UTCL1_CNTL
#define WD_UTCL1_CNTL__XNACK_REDO_TIMER_CNT__SHIFT                                                            0x0
#define WD_UTCL1_CNTL__VMID_RESET_MODE__SHIFT                                                                 0x17
#define WD_UTCL1_CNTL__DROP_MODE__SHIFT                                                                       0x18
#define WD_UTCL1_CNTL__BYPASS__SHIFT                                                                          0x19
#define WD_UTCL1_CNTL__INVALIDATE__SHIFT                                                                      0x1a
#define WD_UTCL1_CNTL__FRAG_LIMIT_MODE__SHIFT                                                                 0x1b
#define WD_UTCL1_CNTL__FORCE_SNOOP__SHIFT                                                                     0x1c
#define WD_UTCL1_CNTL__FORCE_SD_VMID_DIRTY__SHIFT                                                             0x1d
#define WD_UTCL1_CNTL__XNACK_REDO_TIMER_CNT_MASK                                                              0x000FFFFFL
#define WD_UTCL1_CNTL__VMID_RESET_MODE_MASK                                                                   0x00800000L
#define WD_UTCL1_CNTL__DROP_MODE_MASK                                                                         0x01000000L
#define WD_UTCL1_CNTL__BYPASS_MASK                                                                            0x02000000L
#define WD_UTCL1_CNTL__INVALIDATE_MASK                                                                        0x04000000L
#define WD_UTCL1_CNTL__FRAG_LIMIT_MODE_MASK                                                                   0x08000000L
#define WD_UTCL1_CNTL__FORCE_SNOOP_MASK                                                                       0x10000000L
#define WD_UTCL1_CNTL__FORCE_SD_VMID_DIRTY_MASK                                                               0x20000000L
//WD_UTCL1_STATUS
#define WD_UTCL1_STATUS__FAULT_DETECTED__SHIFT                                                                0x0
#define WD_UTCL1_STATUS__RETRY_DETECTED__SHIFT                                                                0x1
#define WD_UTCL1_STATUS__PRT_DETECTED__SHIFT                                                                  0x2
#define WD_UTCL1_STATUS__FAULT_UTCL1ID__SHIFT                                                                 0x8
#define WD_UTCL1_STATUS__RETRY_UTCL1ID__SHIFT                                                                 0x10
#define WD_UTCL1_STATUS__PRT_UTCL1ID__SHIFT                                                                   0x18
#define WD_UTCL1_STATUS__FAULT_DETECTED_MASK                                                                  0x00000001L
#define WD_UTCL1_STATUS__RETRY_DETECTED_MASK                                                                  0x00000002L
#define WD_UTCL1_STATUS__PRT_DETECTED_MASK                                                                    0x00000004L
#define WD_UTCL1_STATUS__FAULT_UTCL1ID_MASK                                                                   0x00003F00L
#define WD_UTCL1_STATUS__RETRY_UTCL1ID_MASK                                                                   0x003F0000L
#define WD_UTCL1_STATUS__PRT_UTCL1ID_MASK                                                                     0x3F000000L
//IA_UTCL1_CNTL
#define IA_UTCL1_CNTL__XNACK_REDO_TIMER_CNT__SHIFT                                                            0x0
#define IA_UTCL1_CNTL__VMID_RESET_MODE__SHIFT                                                                 0x17
#define IA_UTCL1_CNTL__DROP_MODE__SHIFT                                                                       0x18
#define IA_UTCL1_CNTL__BYPASS__SHIFT                                                                          0x19
#define IA_UTCL1_CNTL__INVALIDATE__SHIFT                                                                      0x1a
#define IA_UTCL1_CNTL__FRAG_LIMIT_MODE__SHIFT                                                                 0x1b
#define IA_UTCL1_CNTL__FORCE_SNOOP__SHIFT                                                                     0x1c
#define IA_UTCL1_CNTL__FORCE_SD_VMID_DIRTY__SHIFT                                                             0x1d
#define IA_UTCL1_CNTL__XNACK_REDO_TIMER_CNT_MASK                                                              0x000FFFFFL
#define IA_UTCL1_CNTL__VMID_RESET_MODE_MASK                                                                   0x00800000L
#define IA_UTCL1_CNTL__DROP_MODE_MASK                                                                         0x01000000L
#define IA_UTCL1_CNTL__BYPASS_MASK                                                                            0x02000000L
#define IA_UTCL1_CNTL__INVALIDATE_MASK                                                                        0x04000000L
#define IA_UTCL1_CNTL__FRAG_LIMIT_MODE_MASK                                                                   0x08000000L
#define IA_UTCL1_CNTL__FORCE_SNOOP_MASK                                                                       0x10000000L
#define IA_UTCL1_CNTL__FORCE_SD_VMID_DIRTY_MASK                                                               0x20000000L
//IA_UTCL1_STATUS
#define IA_UTCL1_STATUS__FAULT_DETECTED__SHIFT                                                                0x0
#define IA_UTCL1_STATUS__RETRY_DETECTED__SHIFT                                                                0x1
#define IA_UTCL1_STATUS__PRT_DETECTED__SHIFT                                                                  0x2
#define IA_UTCL1_STATUS__FAULT_UTCL1ID__SHIFT                                                                 0x8
#define IA_UTCL1_STATUS__RETRY_UTCL1ID__SHIFT                                                                 0x10
#define IA_UTCL1_STATUS__PRT_UTCL1ID__SHIFT                                                                   0x18
#define IA_UTCL1_STATUS__FAULT_DETECTED_MASK                                                                  0x00000001L
#define IA_UTCL1_STATUS__RETRY_DETECTED_MASK                                                                  0x00000002L
#define IA_UTCL1_STATUS__PRT_DETECTED_MASK                                                                    0x00000004L
#define IA_UTCL1_STATUS__FAULT_UTCL1ID_MASK                                                                   0x00003F00L
#define IA_UTCL1_STATUS__RETRY_UTCL1ID_MASK                                                                   0x003F0000L
#define IA_UTCL1_STATUS__PRT_UTCL1ID_MASK                                                                     0x3F000000L
//VGT_SYS_CONFIG
#define VGT_SYS_CONFIG__DUAL_CORE_EN__SHIFT                                                                   0x0
#define VGT_SYS_CONFIG__MAX_LS_HS_THDGRP__SHIFT                                                               0x1
#define VGT_SYS_CONFIG__ADC_EVENT_FILTER_DISABLE__SHIFT                                                       0x7
#define VGT_SYS_CONFIG__DUAL_CORE_EN_MASK                                                                     0x00000001L
#define VGT_SYS_CONFIG__MAX_LS_HS_THDGRP_MASK                                                                 0x0000007EL
#define VGT_SYS_CONFIG__ADC_EVENT_FILTER_DISABLE_MASK                                                         0x00000080L
//VGT_VS_MAX_WAVE_ID
#define VGT_VS_MAX_WAVE_ID__MAX_WAVE_ID__SHIFT                                                                0x0
#define VGT_VS_MAX_WAVE_ID__MAX_WAVE_ID_MASK                                                                  0x00000FFFL
//VGT_GS_MAX_WAVE_ID
#define VGT_GS_MAX_WAVE_ID__MAX_WAVE_ID__SHIFT                                                                0x0
#define VGT_GS_MAX_WAVE_ID__MAX_WAVE_ID_MASK                                                                  0x00000FFFL
//GFX_PIPE_CONTROL
#define GFX_PIPE_CONTROL__HYSTERESIS_CNT__SHIFT                                                               0x0
#define GFX_PIPE_CONTROL__RESERVED__SHIFT                                                                     0xd
#define GFX_PIPE_CONTROL__CONTEXT_SUSPEND_EN__SHIFT                                                           0x10
#define GFX_PIPE_CONTROL__HYSTERESIS_CNT_MASK                                                                 0x00001FFFL
#define GFX_PIPE_CONTROL__RESERVED_MASK                                                                       0x0000E000L
#define GFX_PIPE_CONTROL__CONTEXT_SUSPEND_EN_MASK                                                             0x00010000L
//CC_GC_SHADER_ARRAY_CONFIG
#define CC_GC_SHADER_ARRAY_CONFIG__INACTIVE_CUS__SHIFT                                                        0x10
#define CC_GC_SHADER_ARRAY_CONFIG__INACTIVE_CUS_MASK                                                          0xFFFF0000L
//GC_USER_SHADER_ARRAY_CONFIG
#define GC_USER_SHADER_ARRAY_CONFIG__INACTIVE_CUS__SHIFT                                                      0x10
#define GC_USER_SHADER_ARRAY_CONFIG__INACTIVE_CUS_MASK                                                        0xFFFF0000L
//VGT_DMA_PRIMITIVE_TYPE
#define VGT_DMA_PRIMITIVE_TYPE__PRIM_TYPE__SHIFT                                                              0x0
#define VGT_DMA_PRIMITIVE_TYPE__PRIM_TYPE_MASK                                                                0x0000003FL
//VGT_DMA_CONTROL
#define VGT_DMA_CONTROL__PRIMGROUP_SIZE__SHIFT                                                                0x0
#define VGT_DMA_CONTROL__IA_SWITCH_ON_EOP__SHIFT                                                              0x11
#define VGT_DMA_CONTROL__SWITCH_ON_EOI__SHIFT                                                                 0x13
#define VGT_DMA_CONTROL__WD_SWITCH_ON_EOP__SHIFT                                                              0x14
#define VGT_DMA_CONTROL__EN_INST_OPT_BASIC__SHIFT                                                             0x15
#define VGT_DMA_CONTROL__EN_INST_OPT_ADV__SHIFT                                                               0x16
#define VGT_DMA_CONTROL__HW_USE_ONLY__SHIFT                                                                   0x17
#define VGT_DMA_CONTROL__PRIMGROUP_SIZE_MASK                                                                  0x0000FFFFL
#define VGT_DMA_CONTROL__IA_SWITCH_ON_EOP_MASK                                                                0x00020000L
#define VGT_DMA_CONTROL__SWITCH_ON_EOI_MASK                                                                   0x00080000L
#define VGT_DMA_CONTROL__WD_SWITCH_ON_EOP_MASK                                                                0x00100000L
#define VGT_DMA_CONTROL__EN_INST_OPT_BASIC_MASK                                                               0x00200000L
#define VGT_DMA_CONTROL__EN_INST_OPT_ADV_MASK                                                                 0x00400000L
#define VGT_DMA_CONTROL__HW_USE_ONLY_MASK                                                                     0x00800000L
//VGT_DMA_LS_HS_CONFIG
#define VGT_DMA_LS_HS_CONFIG__HS_NUM_INPUT_CP__SHIFT                                                          0x8
#define VGT_DMA_LS_HS_CONFIG__HS_NUM_INPUT_CP_MASK                                                            0x00003F00L
//WD_BUF_RESOURCE_1
#define WD_BUF_RESOURCE_1__POS_BUF_SIZE__SHIFT                                                                0x0
#define WD_BUF_RESOURCE_1__INDEX_BUF_SIZE__SHIFT                                                              0x10
#define WD_BUF_RESOURCE_1__POS_BUF_SIZE_MASK                                                                  0x0000FFFFL
#define WD_BUF_RESOURCE_1__INDEX_BUF_SIZE_MASK                                                                0xFFFF0000L
//WD_BUF_RESOURCE_2
#define WD_BUF_RESOURCE_2__PARAM_BUF_SIZE__SHIFT                                                              0x0
#define WD_BUF_RESOURCE_2__ADDR_MODE__SHIFT                                                                   0xf
#define WD_BUF_RESOURCE_2__CNTL_SB_BUF_SIZE__SHIFT                                                            0x10
#define WD_BUF_RESOURCE_2__PARAM_BUF_SIZE_MASK                                                                0x00001FFFL
#define WD_BUF_RESOURCE_2__ADDR_MODE_MASK                                                                     0x00008000L
#define WD_BUF_RESOURCE_2__CNTL_SB_BUF_SIZE_MASK                                                              0xFFFF0000L
//PA_CL_CNTL_STATUS
#define PA_CL_CNTL_STATUS__UTC_FAULT_DETECTED__SHIFT                                                          0x0
#define PA_CL_CNTL_STATUS__UTC_RETRY_DETECTED__SHIFT                                                          0x1
#define PA_CL_CNTL_STATUS__UTC_PRT_DETECTED__SHIFT                                                            0x2
#define PA_CL_CNTL_STATUS__UTC_FAULT_DETECTED_MASK                                                            0x00000001L
#define PA_CL_CNTL_STATUS__UTC_RETRY_DETECTED_MASK                                                            0x00000002L
#define PA_CL_CNTL_STATUS__UTC_PRT_DETECTED_MASK                                                              0x00000004L
//PA_CL_ENHANCE
#define PA_CL_ENHANCE__CLIP_VTX_REORDER_ENA__SHIFT                                                            0x0
#define PA_CL_ENHANCE__NUM_CLIP_SEQ__SHIFT                                                                    0x1
#define PA_CL_ENHANCE__CLIPPED_PRIM_SEQ_STALL__SHIFT                                                          0x3
#define PA_CL_ENHANCE__VE_NAN_PROC_DISABLE__SHIFT                                                             0x4
#define PA_CL_ENHANCE__IGNORE_PIPELINE_RESET__SHIFT                                                           0x6
#define PA_CL_ENHANCE__KILL_INNER_EDGE_FLAGS__SHIFT                                                           0x7
#define PA_CL_ENHANCE__NGG_PA_TO_ALL_SC__SHIFT                                                                0x8
#define PA_CL_ENHANCE__TC_LATENCY_TIME_STAMP_RESOLUTION__SHIFT                                                0x9
#define PA_CL_ENHANCE__NGG_BYPASS_PRIM_FILTER__SHIFT                                                          0xb
#define PA_CL_ENHANCE__NGG_SIDEBAND_MEMORY_DEPTH__SHIFT                                                       0xc
#define PA_CL_ENHANCE__NGG_PRIM_INDICES_FIFO_DEPTH__SHIFT                                                     0xe
#define PA_CL_ENHANCE__ECO_SPARE3__SHIFT                                                                      0x1c
#define PA_CL_ENHANCE__ECO_SPARE2__SHIFT                                                                      0x1d
#define PA_CL_ENHANCE__ECO_SPARE1__SHIFT                                                                      0x1e
#define PA_CL_ENHANCE__ECO_SPARE0__SHIFT                                                                      0x1f
#define PA_CL_ENHANCE__CLIP_VTX_REORDER_ENA_MASK                                                              0x00000001L
#define PA_CL_ENHANCE__NUM_CLIP_SEQ_MASK                                                                      0x00000006L
#define PA_CL_ENHANCE__CLIPPED_PRIM_SEQ_STALL_MASK                                                            0x00000008L
#define PA_CL_ENHANCE__VE_NAN_PROC_DISABLE_MASK                                                               0x00000010L
#define PA_CL_ENHANCE__IGNORE_PIPELINE_RESET_MASK                                                             0x00000040L
#define PA_CL_ENHANCE__KILL_INNER_EDGE_FLAGS_MASK                                                             0x00000080L
#define PA_CL_ENHANCE__NGG_PA_TO_ALL_SC_MASK                                                                  0x00000100L
#define PA_CL_ENHANCE__TC_LATENCY_TIME_STAMP_RESOLUTION_MASK                                                  0x00000600L
#define PA_CL_ENHANCE__NGG_BYPASS_PRIM_FILTER_MASK                                                            0x00000800L
#define PA_CL_ENHANCE__NGG_SIDEBAND_MEMORY_DEPTH_MASK                                                         0x00003000L
#define PA_CL_ENHANCE__NGG_PRIM_INDICES_FIFO_DEPTH_MASK                                                       0x0001C000L
#define PA_CL_ENHANCE__ECO_SPARE3_MASK                                                                        0x10000000L
#define PA_CL_ENHANCE__ECO_SPARE2_MASK                                                                        0x20000000L
#define PA_CL_ENHANCE__ECO_SPARE1_MASK                                                                        0x40000000L
#define PA_CL_ENHANCE__ECO_SPARE0_MASK                                                                        0x80000000L
//PA_SU_CNTL_STATUS
#define PA_SU_CNTL_STATUS__SU_BUSY__SHIFT                                                                     0x1f
#define PA_SU_CNTL_STATUS__SU_BUSY_MASK                                                                       0x80000000L
//PA_SC_FIFO_DEPTH_CNTL
#define PA_SC_FIFO_DEPTH_CNTL__DEPTH__SHIFT                                                                   0x0
#define PA_SC_FIFO_DEPTH_CNTL__DEPTH_MASK                                                                     0x000003FFL
//PA_SC_P3D_TRAP_SCREEN_HV_LOCK
#define PA_SC_P3D_TRAP_SCREEN_HV_LOCK__DISABLE_NON_PRIV_WRITES__SHIFT                                         0x0
#define PA_SC_P3D_TRAP_SCREEN_HV_LOCK__DISABLE_NON_PRIV_WRITES_MASK                                           0x00000001L
//PA_SC_HP3D_TRAP_SCREEN_HV_LOCK
#define PA_SC_HP3D_TRAP_SCREEN_HV_LOCK__DISABLE_NON_PRIV_WRITES__SHIFT                                        0x0
#define PA_SC_HP3D_TRAP_SCREEN_HV_LOCK__DISABLE_NON_PRIV_WRITES_MASK                                          0x00000001L
//PA_SC_TRAP_SCREEN_HV_LOCK
#define PA_SC_TRAP_SCREEN_HV_LOCK__DISABLE_NON_PRIV_WRITES__SHIFT                                             0x0
#define PA_SC_TRAP_SCREEN_HV_LOCK__DISABLE_NON_PRIV_WRITES_MASK                                               0x00000001L
//PA_SC_FORCE_EOV_MAX_CNTS
#define PA_SC_FORCE_EOV_MAX_CNTS__FORCE_EOV_MAX_CLK_CNT__SHIFT                                                0x0
#define PA_SC_FORCE_EOV_MAX_CNTS__FORCE_EOV_MAX_REZ_CNT__SHIFT                                                0x10
#define PA_SC_FORCE_EOV_MAX_CNTS__FORCE_EOV_MAX_CLK_CNT_MASK                                                  0x0000FFFFL
#define PA_SC_FORCE_EOV_MAX_CNTS__FORCE_EOV_MAX_REZ_CNT_MASK                                                  0xFFFF0000L
//PA_SC_BINNER_EVENT_CNTL_0
#define PA_SC_BINNER_EVENT_CNTL_0__RESERVED_0__SHIFT                                                          0x0
#define PA_SC_BINNER_EVENT_CNTL_0__SAMPLE_STREAMOUTSTATS1__SHIFT                                              0x2
#define PA_SC_BINNER_EVENT_CNTL_0__SAMPLE_STREAMOUTSTATS2__SHIFT                                              0x4
#define PA_SC_BINNER_EVENT_CNTL_0__SAMPLE_STREAMOUTSTATS3__SHIFT                                              0x6
#define PA_SC_BINNER_EVENT_CNTL_0__CACHE_FLUSH_TS__SHIFT                                                      0x8
#define PA_SC_BINNER_EVENT_CNTL_0__CONTEXT_DONE__SHIFT                                                        0xa
#define PA_SC_BINNER_EVENT_CNTL_0__CACHE_FLUSH__SHIFT                                                         0xc
#define PA_SC_BINNER_EVENT_CNTL_0__CS_PARTIAL_FLUSH__SHIFT                                                    0xe
#define PA_SC_BINNER_EVENT_CNTL_0__VGT_STREAMOUT_SYNC__SHIFT                                                  0x10
#define PA_SC_BINNER_EVENT_CNTL_0__RESERVED_9__SHIFT                                                          0x12
#define PA_SC_BINNER_EVENT_CNTL_0__VGT_STREAMOUT_RESET__SHIFT                                                 0x14
#define PA_SC_BINNER_EVENT_CNTL_0__END_OF_PIPE_INCR_DE__SHIFT                                                 0x16
#define PA_SC_BINNER_EVENT_CNTL_0__END_OF_PIPE_IB_END__SHIFT                                                  0x18
#define PA_SC_BINNER_EVENT_CNTL_0__RST_PIX_CNT__SHIFT                                                         0x1a
#define PA_SC_BINNER_EVENT_CNTL_0__BREAK_BATCH__SHIFT                                                         0x1c
#define PA_SC_BINNER_EVENT_CNTL_0__VS_PARTIAL_FLUSH__SHIFT                                                    0x1e
#define PA_SC_BINNER_EVENT_CNTL_0__RESERVED_0_MASK                                                            0x00000003L
#define PA_SC_BINNER_EVENT_CNTL_0__SAMPLE_STREAMOUTSTATS1_MASK                                                0x0000000CL
#define PA_SC_BINNER_EVENT_CNTL_0__SAMPLE_STREAMOUTSTATS2_MASK                                                0x00000030L
#define PA_SC_BINNER_EVENT_CNTL_0__SAMPLE_STREAMOUTSTATS3_MASK                                                0x000000C0L
#define PA_SC_BINNER_EVENT_CNTL_0__CACHE_FLUSH_TS_MASK                                                        0x00000300L
#define PA_SC_BINNER_EVENT_CNTL_0__CONTEXT_DONE_MASK                                                          0x00000C00L
#define PA_SC_BINNER_EVENT_CNTL_0__CACHE_FLUSH_MASK                                                           0x00003000L
#define PA_SC_BINNER_EVENT_CNTL_0__CS_PARTIAL_FLUSH_MASK                                                      0x0000C000L
#define PA_SC_BINNER_EVENT_CNTL_0__VGT_STREAMOUT_SYNC_MASK                                                    0x00030000L
#define PA_SC_BINNER_EVENT_CNTL_0__RESERVED_9_MASK                                                            0x000C0000L
#define PA_SC_BINNER_EVENT_CNTL_0__VGT_STREAMOUT_RESET_MASK                                                   0x00300000L
#define PA_SC_BINNER_EVENT_CNTL_0__END_OF_PIPE_INCR_DE_MASK                                                   0x00C00000L
#define PA_SC_BINNER_EVENT_CNTL_0__END_OF_PIPE_IB_END_MASK                                                    0x03000000L
#define PA_SC_BINNER_EVENT_CNTL_0__RST_PIX_CNT_MASK                                                           0x0C000000L
#define PA_SC_BINNER_EVENT_CNTL_0__BREAK_BATCH_MASK                                                           0x30000000L
#define PA_SC_BINNER_EVENT_CNTL_0__VS_PARTIAL_FLUSH_MASK                                                      0xC0000000L
//PA_SC_BINNER_EVENT_CNTL_1
#define PA_SC_BINNER_EVENT_CNTL_1__PS_PARTIAL_FLUSH__SHIFT                                                    0x0
#define PA_SC_BINNER_EVENT_CNTL_1__FLUSH_HS_OUTPUT__SHIFT                                                     0x2
#define PA_SC_BINNER_EVENT_CNTL_1__FLUSH_DFSM__SHIFT                                                          0x4
#define PA_SC_BINNER_EVENT_CNTL_1__RESET_TO_LOWEST_VGT__SHIFT                                                 0x6
#define PA_SC_BINNER_EVENT_CNTL_1__CACHE_FLUSH_AND_INV_TS_EVENT__SHIFT                                        0x8
#define PA_SC_BINNER_EVENT_CNTL_1__ZPASS_DONE__SHIFT                                                          0xa
#define PA_SC_BINNER_EVENT_CNTL_1__CACHE_FLUSH_AND_INV_EVENT__SHIFT                                           0xc
#define PA_SC_BINNER_EVENT_CNTL_1__PERFCOUNTER_START__SHIFT                                                   0xe
#define PA_SC_BINNER_EVENT_CNTL_1__PERFCOUNTER_STOP__SHIFT                                                    0x10
#define PA_SC_BINNER_EVENT_CNTL_1__PIPELINESTAT_START__SHIFT                                                  0x12
#define PA_SC_BINNER_EVENT_CNTL_1__PIPELINESTAT_STOP__SHIFT                                                   0x14
#define PA_SC_BINNER_EVENT_CNTL_1__PERFCOUNTER_SAMPLE__SHIFT                                                  0x16
#define PA_SC_BINNER_EVENT_CNTL_1__FLUSH_ES_OUTPUT__SHIFT                                                     0x18
#define PA_SC_BINNER_EVENT_CNTL_1__FLUSH_GS_OUTPUT__SHIFT                                                     0x1a
#define PA_SC_BINNER_EVENT_CNTL_1__SAMPLE_PIPELINESTAT__SHIFT                                                 0x1c
#define PA_SC_BINNER_EVENT_CNTL_1__SO_VGTSTREAMOUT_FLUSH__SHIFT                                               0x1e
#define PA_SC_BINNER_EVENT_CNTL_1__PS_PARTIAL_FLUSH_MASK                                                      0x00000003L
#define PA_SC_BINNER_EVENT_CNTL_1__FLUSH_HS_OUTPUT_MASK                                                       0x0000000CL
#define PA_SC_BINNER_EVENT_CNTL_1__FLUSH_DFSM_MASK                                                            0x00000030L
#define PA_SC_BINNER_EVENT_CNTL_1__RESET_TO_LOWEST_VGT_MASK                                                   0x000000C0L
#define PA_SC_BINNER_EVENT_CNTL_1__CACHE_FLUSH_AND_INV_TS_EVENT_MASK                                          0x00000300L
#define PA_SC_BINNER_EVENT_CNTL_1__ZPASS_DONE_MASK                                                            0x00000C00L
#define PA_SC_BINNER_EVENT_CNTL_1__CACHE_FLUSH_AND_INV_EVENT_MASK                                             0x00003000L
#define PA_SC_BINNER_EVENT_CNTL_1__PERFCOUNTER_START_MASK                                                     0x0000C000L
#define PA_SC_BINNER_EVENT_CNTL_1__PERFCOUNTER_STOP_MASK                                                      0x00030000L
#define PA_SC_BINNER_EVENT_CNTL_1__PIPELINESTAT_START_MASK                                                    0x000C0000L
#define PA_SC_BINNER_EVENT_CNTL_1__PIPELINESTAT_STOP_MASK                                                     0x00300000L
#define PA_SC_BINNER_EVENT_CNTL_1__PERFCOUNTER_SAMPLE_MASK                                                    0x00C00000L
#define PA_SC_BINNER_EVENT_CNTL_1__FLUSH_ES_OUTPUT_MASK                                                       0x03000000L
#define PA_SC_BINNER_EVENT_CNTL_1__FLUSH_GS_OUTPUT_MASK                                                       0x0C000000L
#define PA_SC_BINNER_EVENT_CNTL_1__SAMPLE_PIPELINESTAT_MASK                                                   0x30000000L
#define PA_SC_BINNER_EVENT_CNTL_1__SO_VGTSTREAMOUT_FLUSH_MASK                                                 0xC0000000L
//PA_SC_BINNER_EVENT_CNTL_2
#define PA_SC_BINNER_EVENT_CNTL_2__SAMPLE_STREAMOUTSTATS__SHIFT                                               0x0
#define PA_SC_BINNER_EVENT_CNTL_2__RESET_VTX_CNT__SHIFT                                                       0x2
#define PA_SC_BINNER_EVENT_CNTL_2__BLOCK_CONTEXT_DONE__SHIFT                                                  0x4
#define PA_SC_BINNER_EVENT_CNTL_2__CS_CONTEXT_DONE__SHIFT                                                     0x6
#define PA_SC_BINNER_EVENT_CNTL_2__VGT_FLUSH__SHIFT                                                           0x8
#define PA_SC_BINNER_EVENT_CNTL_2__TGID_ROLLOVER__SHIFT                                                       0xa
#define PA_SC_BINNER_EVENT_CNTL_2__SQ_NON_EVENT__SHIFT                                                        0xc
#define PA_SC_BINNER_EVENT_CNTL_2__SC_SEND_DB_VPZ__SHIFT                                                      0xe
#define PA_SC_BINNER_EVENT_CNTL_2__BOTTOM_OF_PIPE_TS__SHIFT                                                   0x10
#define PA_SC_BINNER_EVENT_CNTL_2__FLUSH_SX_TS__SHIFT                                                         0x12
#define PA_SC_BINNER_EVENT_CNTL_2__DB_CACHE_FLUSH_AND_INV__SHIFT                                              0x14
#define PA_SC_BINNER_EVENT_CNTL_2__FLUSH_AND_INV_DB_DATA_TS__SHIFT                                            0x16
#define PA_SC_BINNER_EVENT_CNTL_2__FLUSH_AND_INV_DB_META__SHIFT                                               0x18
#define PA_SC_BINNER_EVENT_CNTL_2__FLUSH_AND_INV_CB_DATA_TS__SHIFT                                            0x1a
#define PA_SC_BINNER_EVENT_CNTL_2__FLUSH_AND_INV_CB_META__SHIFT                                               0x1c
#define PA_SC_BINNER_EVENT_CNTL_2__CS_DONE__SHIFT                                                             0x1e
#define PA_SC_BINNER_EVENT_CNTL_2__SAMPLE_STREAMOUTSTATS_MASK                                                 0x00000003L
#define PA_SC_BINNER_EVENT_CNTL_2__RESET_VTX_CNT_MASK                                                         0x0000000CL
#define PA_SC_BINNER_EVENT_CNTL_2__BLOCK_CONTEXT_DONE_MASK                                                    0x00000030L
#define PA_SC_BINNER_EVENT_CNTL_2__CS_CONTEXT_DONE_MASK                                                       0x000000C0L
#define PA_SC_BINNER_EVENT_CNTL_2__VGT_FLUSH_MASK                                                             0x00000300L
#define PA_SC_BINNER_EVENT_CNTL_2__TGID_ROLLOVER_MASK                                                         0x00000C00L
#define PA_SC_BINNER_EVENT_CNTL_2__SQ_NON_EVENT_MASK                                                          0x00003000L
#define PA_SC_BINNER_EVENT_CNTL_2__SC_SEND_DB_VPZ_MASK                                                        0x0000C000L
#define PA_SC_BINNER_EVENT_CNTL_2__BOTTOM_OF_PIPE_TS_MASK                                                     0x00030000L
#define PA_SC_BINNER_EVENT_CNTL_2__FLUSH_SX_TS_MASK                                                           0x000C0000L
#define PA_SC_BINNER_EVENT_CNTL_2__DB_CACHE_FLUSH_AND_INV_MASK                                                0x00300000L
#define PA_SC_BINNER_EVENT_CNTL_2__FLUSH_AND_INV_DB_DATA_TS_MASK                                              0x00C00000L
#define PA_SC_BINNER_EVENT_CNTL_2__FLUSH_AND_INV_DB_META_MASK                                                 0x03000000L
#define PA_SC_BINNER_EVENT_CNTL_2__FLUSH_AND_INV_CB_DATA_TS_MASK                                              0x0C000000L
#define PA_SC_BINNER_EVENT_CNTL_2__FLUSH_AND_INV_CB_META_MASK                                                 0x30000000L
#define PA_SC_BINNER_EVENT_CNTL_2__CS_DONE_MASK                                                               0xC0000000L
//PA_SC_BINNER_EVENT_CNTL_3
#define PA_SC_BINNER_EVENT_CNTL_3__PS_DONE__SHIFT                                                             0x0
#define PA_SC_BINNER_EVENT_CNTL_3__FLUSH_AND_INV_CB_PIXEL_DATA__SHIFT                                         0x2
#define PA_SC_BINNER_EVENT_CNTL_3__SX_CB_RAT_ACK_REQUEST__SHIFT                                               0x4
#define PA_SC_BINNER_EVENT_CNTL_3__THREAD_TRACE_START__SHIFT                                                  0x6
#define PA_SC_BINNER_EVENT_CNTL_3__THREAD_TRACE_STOP__SHIFT                                                   0x8
#define PA_SC_BINNER_EVENT_CNTL_3__THREAD_TRACE_MARKER__SHIFT                                                 0xa
#define PA_SC_BINNER_EVENT_CNTL_3__THREAD_TRACE_FLUSH__SHIFT                                                  0xc
#define PA_SC_BINNER_EVENT_CNTL_3__THREAD_TRACE_FINISH__SHIFT                                                 0xe
#define PA_SC_BINNER_EVENT_CNTL_3__PIXEL_PIPE_STAT_CONTROL__SHIFT                                             0x10
#define PA_SC_BINNER_EVENT_CNTL_3__PIXEL_PIPE_STAT_DUMP__SHIFT                                                0x12
#define PA_SC_BINNER_EVENT_CNTL_3__PIXEL_PIPE_STAT_RESET__SHIFT                                               0x14
#define PA_SC_BINNER_EVENT_CNTL_3__CONTEXT_SUSPEND__SHIFT                                                     0x16
#define PA_SC_BINNER_EVENT_CNTL_3__OFFCHIP_HS_DEALLOC__SHIFT                                                  0x18
#define PA_SC_BINNER_EVENT_CNTL_3__ENABLE_NGG_PIPELINE__SHIFT                                                 0x1a
#define PA_SC_BINNER_EVENT_CNTL_3__ENABLE_LEGACY_PIPELINE__SHIFT                                              0x1c
#define PA_SC_BINNER_EVENT_CNTL_3__RESERVED_63__SHIFT                                                         0x1e
#define PA_SC_BINNER_EVENT_CNTL_3__PS_DONE_MASK                                                               0x00000003L
#define PA_SC_BINNER_EVENT_CNTL_3__FLUSH_AND_INV_CB_PIXEL_DATA_MASK                                           0x0000000CL
#define PA_SC_BINNER_EVENT_CNTL_3__SX_CB_RAT_ACK_REQUEST_MASK                                                 0x00000030L
#define PA_SC_BINNER_EVENT_CNTL_3__THREAD_TRACE_START_MASK                                                    0x000000C0L
#define PA_SC_BINNER_EVENT_CNTL_3__THREAD_TRACE_STOP_MASK                                                     0x00000300L
#define PA_SC_BINNER_EVENT_CNTL_3__THREAD_TRACE_MARKER_MASK                                                   0x00000C00L
#define PA_SC_BINNER_EVENT_CNTL_3__THREAD_TRACE_FLUSH_MASK                                                    0x00003000L
#define PA_SC_BINNER_EVENT_CNTL_3__THREAD_TRACE_FINISH_MASK                                                   0x0000C000L
#define PA_SC_BINNER_EVENT_CNTL_3__PIXEL_PIPE_STAT_CONTROL_MASK                                               0x00030000L
#define PA_SC_BINNER_EVENT_CNTL_3__PIXEL_PIPE_STAT_DUMP_MASK                                                  0x000C0000L
#define PA_SC_BINNER_EVENT_CNTL_3__PIXEL_PIPE_STAT_RESET_MASK                                                 0x00300000L
#define PA_SC_BINNER_EVENT_CNTL_3__CONTEXT_SUSPEND_MASK                                                       0x00C00000L
#define PA_SC_BINNER_EVENT_CNTL_3__OFFCHIP_HS_DEALLOC_MASK                                                    0x03000000L
#define PA_SC_BINNER_EVENT_CNTL_3__ENABLE_NGG_PIPELINE_MASK                                                   0x0C000000L
#define PA_SC_BINNER_EVENT_CNTL_3__ENABLE_LEGACY_PIPELINE_MASK                                                0x30000000L
#define PA_SC_BINNER_EVENT_CNTL_3__RESERVED_63_MASK                                                           0xC0000000L
//PA_SC_BINNER_TIMEOUT_COUNTER
#define PA_SC_BINNER_TIMEOUT_COUNTER__THRESHOLD__SHIFT                                                        0x0
#define PA_SC_BINNER_TIMEOUT_COUNTER__THRESHOLD_MASK                                                          0xFFFFFFFFL
//PA_SC_BINNER_PERF_CNTL_0
#define PA_SC_BINNER_PERF_CNTL_0__BIN_HIST_NUM_PRIMS_THRESHOLD__SHIFT                                         0x0
#define PA_SC_BINNER_PERF_CNTL_0__BATCH_HIST_NUM_PRIMS_THRESHOLD__SHIFT                                       0xa
#define PA_SC_BINNER_PERF_CNTL_0__BIN_HIST_NUM_CONTEXT_THRESHOLD__SHIFT                                       0x14
#define PA_SC_BINNER_PERF_CNTL_0__BATCH_HIST_NUM_CONTEXT_THRESHOLD__SHIFT                                     0x17
#define PA_SC_BINNER_PERF_CNTL_0__BIN_HIST_NUM_PRIMS_THRESHOLD_MASK                                           0x000003FFL
#define PA_SC_BINNER_PERF_CNTL_0__BATCH_HIST_NUM_PRIMS_THRESHOLD_MASK                                         0x000FFC00L
#define PA_SC_BINNER_PERF_CNTL_0__BIN_HIST_NUM_CONTEXT_THRESHOLD_MASK                                         0x00700000L
#define PA_SC_BINNER_PERF_CNTL_0__BATCH_HIST_NUM_CONTEXT_THRESHOLD_MASK                                       0x03800000L
//PA_SC_BINNER_PERF_CNTL_1
#define PA_SC_BINNER_PERF_CNTL_1__BIN_HIST_NUM_PERSISTENT_STATE_THRESHOLD__SHIFT                              0x0
#define PA_SC_BINNER_PERF_CNTL_1__BATCH_HIST_NUM_PERSISTENT_STATE_THRESHOLD__SHIFT                            0x5
#define PA_SC_BINNER_PERF_CNTL_1__BATCH_HIST_NUM_TRIV_REJECTED_PRIMS_THRESHOLD__SHIFT                         0xa
#define PA_SC_BINNER_PERF_CNTL_1__BIN_HIST_NUM_PERSISTENT_STATE_THRESHOLD_MASK                                0x0000001FL
#define PA_SC_BINNER_PERF_CNTL_1__BATCH_HIST_NUM_PERSISTENT_STATE_THRESHOLD_MASK                              0x000003E0L
#define PA_SC_BINNER_PERF_CNTL_1__BATCH_HIST_NUM_TRIV_REJECTED_PRIMS_THRESHOLD_MASK                           0x03FFFC00L
//PA_SC_BINNER_PERF_CNTL_2
#define PA_SC_BINNER_PERF_CNTL_2__BATCH_HIST_NUM_ROWS_PER_PRIM_THRESHOLD__SHIFT                               0x0
#define PA_SC_BINNER_PERF_CNTL_2__BATCH_HIST_NUM_COLUMNS_PER_ROW_THRESHOLD__SHIFT                             0xb
#define PA_SC_BINNER_PERF_CNTL_2__BATCH_HIST_NUM_ROWS_PER_PRIM_THRESHOLD_MASK                                 0x000007FFL
#define PA_SC_BINNER_PERF_CNTL_2__BATCH_HIST_NUM_COLUMNS_PER_ROW_THRESHOLD_MASK                               0x003FF800L
//PA_SC_BINNER_PERF_CNTL_3
#define PA_SC_BINNER_PERF_CNTL_3__BATCH_HIST_NUM_PS_WAVE_BREAKS_THRESHOLD__SHIFT                              0x0
#define PA_SC_BINNER_PERF_CNTL_3__BATCH_HIST_NUM_PS_WAVE_BREAKS_THRESHOLD_MASK                                0xFFFFFFFFL
//PA_SC_FIFO_SIZE
#define PA_SC_FIFO_SIZE__SC_FRONTEND_PRIM_FIFO_SIZE__SHIFT                                                    0x0
#define PA_SC_FIFO_SIZE__SC_BACKEND_PRIM_FIFO_SIZE__SHIFT                                                     0x6
#define PA_SC_FIFO_SIZE__SC_HIZ_TILE_FIFO_SIZE__SHIFT                                                         0xf
#define PA_SC_FIFO_SIZE__SC_EARLYZ_TILE_FIFO_SIZE__SHIFT                                                      0x15
#define PA_SC_FIFO_SIZE__SC_FRONTEND_PRIM_FIFO_SIZE_MASK                                                      0x0000003FL
#define PA_SC_FIFO_SIZE__SC_BACKEND_PRIM_FIFO_SIZE_MASK                                                       0x00007FC0L
#define PA_SC_FIFO_SIZE__SC_HIZ_TILE_FIFO_SIZE_MASK                                                           0x001F8000L
#define PA_SC_FIFO_SIZE__SC_EARLYZ_TILE_FIFO_SIZE_MASK                                                        0xFFE00000L
//PA_SC_IF_FIFO_SIZE
#define PA_SC_IF_FIFO_SIZE__SC_DB_TILE_IF_FIFO_SIZE__SHIFT                                                    0x0
#define PA_SC_IF_FIFO_SIZE__SC_DB_QUAD_IF_FIFO_SIZE__SHIFT                                                    0x6
#define PA_SC_IF_FIFO_SIZE__SC_SPI_IF_FIFO_SIZE__SHIFT                                                        0xc
#define PA_SC_IF_FIFO_SIZE__SC_BCI_IF_FIFO_SIZE__SHIFT                                                        0x12
#define PA_SC_IF_FIFO_SIZE__SC_DB_TILE_IF_FIFO_SIZE_MASK                                                      0x0000003FL
#define PA_SC_IF_FIFO_SIZE__SC_DB_QUAD_IF_FIFO_SIZE_MASK                                                      0x00000FC0L
#define PA_SC_IF_FIFO_SIZE__SC_SPI_IF_FIFO_SIZE_MASK                                                          0x0003F000L
#define PA_SC_IF_FIFO_SIZE__SC_BCI_IF_FIFO_SIZE_MASK                                                          0x00FC0000L
//PA_SC_PKR_WAVE_TABLE_CNTL
#define PA_SC_PKR_WAVE_TABLE_CNTL__SIZE__SHIFT                                                                0x0
#define PA_SC_PKR_WAVE_TABLE_CNTL__SIZE_MASK                                                                  0x0000003FL
//PA_UTCL1_CNTL1
#define PA_UTCL1_CNTL1__FORCE_4K_L2_RESP__SHIFT                                                               0x0
#define PA_UTCL1_CNTL1__GPUVM_64K_DEFAULT__SHIFT                                                              0x1
#define PA_UTCL1_CNTL1__GPUVM_PERM_MODE__SHIFT                                                                0x2
#define PA_UTCL1_CNTL1__RESP_MODE__SHIFT                                                                      0x3
#define PA_UTCL1_CNTL1__RESP_FAULT_MODE__SHIFT                                                                0x5
#define PA_UTCL1_CNTL1__CLIENTID__SHIFT                                                                       0x7
#define PA_UTCL1_CNTL1__SPARE__SHIFT                                                                          0x10
#define PA_UTCL1_CNTL1__ENABLE_PUSH_LFIFO__SHIFT                                                              0x11
#define PA_UTCL1_CNTL1__ENABLE_LFIFO_PRI_ARB__SHIFT                                                           0x12
#define PA_UTCL1_CNTL1__REG_INV_VMID__SHIFT                                                                   0x13
#define PA_UTCL1_CNTL1__REG_INV_ALL_VMID__SHIFT                                                               0x17
#define PA_UTCL1_CNTL1__REG_INV_TOGGLE__SHIFT                                                                 0x18
#define PA_UTCL1_CNTL1__INVALIDATE_ALL_VMID__SHIFT                                                            0x19
#define PA_UTCL1_CNTL1__FORCE_MISS__SHIFT                                                                     0x1a
#define PA_UTCL1_CNTL1__FORCE_IN_ORDER__SHIFT                                                                 0x1b
#define PA_UTCL1_CNTL1__REDUCE_FIFO_DEPTH_BY_2__SHIFT                                                         0x1c
#define PA_UTCL1_CNTL1__REDUCE_CACHE_SIZE_BY_2__SHIFT                                                         0x1e
#define PA_UTCL1_CNTL1__FORCE_4K_L2_RESP_MASK                                                                 0x00000001L
#define PA_UTCL1_CNTL1__GPUVM_64K_DEFAULT_MASK                                                                0x00000002L
#define PA_UTCL1_CNTL1__GPUVM_PERM_MODE_MASK                                                                  0x00000004L
#define PA_UTCL1_CNTL1__RESP_MODE_MASK                                                                        0x00000018L
#define PA_UTCL1_CNTL1__RESP_FAULT_MODE_MASK                                                                  0x00000060L
#define PA_UTCL1_CNTL1__CLIENTID_MASK                                                                         0x0000FF80L
#define PA_UTCL1_CNTL1__SPARE_MASK                                                                            0x00010000L
#define PA_UTCL1_CNTL1__ENABLE_PUSH_LFIFO_MASK                                                                0x00020000L
#define PA_UTCL1_CNTL1__ENABLE_LFIFO_PRI_ARB_MASK                                                             0x00040000L
#define PA_UTCL1_CNTL1__REG_INV_VMID_MASK                                                                     0x00780000L
#define PA_UTCL1_CNTL1__REG_INV_ALL_VMID_MASK                                                                 0x00800000L
#define PA_UTCL1_CNTL1__REG_INV_TOGGLE_MASK                                                                   0x01000000L
#define PA_UTCL1_CNTL1__INVALIDATE_ALL_VMID_MASK                                                              0x02000000L
#define PA_UTCL1_CNTL1__FORCE_MISS_MASK                                                                       0x04000000L
#define PA_UTCL1_CNTL1__FORCE_IN_ORDER_MASK                                                                   0x08000000L
#define PA_UTCL1_CNTL1__REDUCE_FIFO_DEPTH_BY_2_MASK                                                           0x30000000L
#define PA_UTCL1_CNTL1__REDUCE_CACHE_SIZE_BY_2_MASK                                                           0xC0000000L
//PA_UTCL1_CNTL2
#define PA_UTCL1_CNTL2__SPARE1__SHIFT                                                                         0x0
#define PA_UTCL1_CNTL2__SPARE2__SHIFT                                                                         0x8
#define PA_UTCL1_CNTL2__MTYPE_OVRD_DIS__SHIFT                                                                 0x9
#define PA_UTCL1_CNTL2__LINE_VALID__SHIFT                                                                     0xa
#define PA_UTCL1_CNTL2__SPARE3__SHIFT                                                                         0xb
#define PA_UTCL1_CNTL2__GPUVM_INV_MODE__SHIFT                                                                 0xc
#define PA_UTCL1_CNTL2__ENABLE_SHOOTDOWN_OPT__SHIFT                                                           0xd
#define PA_UTCL1_CNTL2__FORCE_SNOOP__SHIFT                                                                    0xe
#define PA_UTCL1_CNTL2__FORCE_GPUVM_INV_ACK__SHIFT                                                            0xf
#define PA_UTCL1_CNTL2__SPARE4__SHIFT                                                                         0x10
#define PA_UTCL1_CNTL2__ENABLE_PERF_EVENT_RD_WR__SHIFT                                                        0x12
#define PA_UTCL1_CNTL2__PERF_EVENT_RD_WR__SHIFT                                                               0x13
#define PA_UTCL1_CNTL2__ENABLE_PERF_EVENT_VMID__SHIFT                                                         0x14
#define PA_UTCL1_CNTL2__PERF_EVENT_VMID__SHIFT                                                                0x15
#define PA_UTCL1_CNTL2__SPARE5__SHIFT                                                                         0x19
#define PA_UTCL1_CNTL2__FORCE_FRAG_2M_TO_64K__SHIFT                                                           0x1a
#define PA_UTCL1_CNTL2__RESERVED__SHIFT                                                                       0x1b
#define PA_UTCL1_CNTL2__SPARE1_MASK                                                                           0x000000FFL
#define PA_UTCL1_CNTL2__SPARE2_MASK                                                                           0x00000100L
#define PA_UTCL1_CNTL2__MTYPE_OVRD_DIS_MASK                                                                   0x00000200L
#define PA_UTCL1_CNTL2__LINE_VALID_MASK                                                                       0x00000400L
#define PA_UTCL1_CNTL2__SPARE3_MASK                                                                           0x00000800L
#define PA_UTCL1_CNTL2__GPUVM_INV_MODE_MASK                                                                   0x00001000L
#define PA_UTCL1_CNTL2__ENABLE_SHOOTDOWN_OPT_MASK                                                             0x00002000L
#define PA_UTCL1_CNTL2__FORCE_SNOOP_MASK                                                                      0x00004000L
#define PA_UTCL1_CNTL2__FORCE_GPUVM_INV_ACK_MASK                                                              0x00008000L
#define PA_UTCL1_CNTL2__SPARE4_MASK                                                                           0x00030000L
#define PA_UTCL1_CNTL2__ENABLE_PERF_EVENT_RD_WR_MASK                                                          0x00040000L
#define PA_UTCL1_CNTL2__PERF_EVENT_RD_WR_MASK                                                                 0x00080000L
#define PA_UTCL1_CNTL2__ENABLE_PERF_EVENT_VMID_MASK                                                           0x00100000L
#define PA_UTCL1_CNTL2__PERF_EVENT_VMID_MASK                                                                  0x01E00000L
#define PA_UTCL1_CNTL2__SPARE5_MASK                                                                           0x02000000L
#define PA_UTCL1_CNTL2__FORCE_FRAG_2M_TO_64K_MASK                                                             0x04000000L
#define PA_UTCL1_CNTL2__RESERVED_MASK                                                                         0xF8000000L
//PA_SIDEBAND_REQUEST_DELAYS
#define PA_SIDEBAND_REQUEST_DELAYS__RETRY_DELAY__SHIFT                                                        0x0
#define PA_SIDEBAND_REQUEST_DELAYS__INITIAL_DELAY__SHIFT                                                      0x10
#define PA_SIDEBAND_REQUEST_DELAYS__RETRY_DELAY_MASK                                                          0x0000FFFFL
#define PA_SIDEBAND_REQUEST_DELAYS__INITIAL_DELAY_MASK                                                        0xFFFF0000L
//PA_SC_ENHANCE
#define PA_SC_ENHANCE__ENABLE_PA_SC_OUT_OF_ORDER__SHIFT                                                       0x0
#define PA_SC_ENHANCE__DISABLE_SC_DB_TILE_FIX__SHIFT                                                          0x1
#define PA_SC_ENHANCE__DISABLE_AA_MASK_FULL_FIX__SHIFT                                                        0x2
#define PA_SC_ENHANCE__ENABLE_1XMSAA_SAMPLE_LOCATIONS__SHIFT                                                  0x3
#define PA_SC_ENHANCE__ENABLE_1XMSAA_SAMPLE_LOC_CENTROID__SHIFT                                               0x4
#define PA_SC_ENHANCE__DISABLE_SCISSOR_FIX__SHIFT                                                             0x5
#define PA_SC_ENHANCE__SEND_UNLIT_STILES_TO_PACKER__SHIFT                                                     0x6
#define PA_SC_ENHANCE__DISABLE_DUALGRAD_PERF_OPTIMIZATION__SHIFT                                              0x7
#define PA_SC_ENHANCE__DISABLE_SC_PROCESS_RESET_PRIM__SHIFT                                                   0x8
#define PA_SC_ENHANCE__DISABLE_SC_PROCESS_RESET_SUPERTILE__SHIFT                                              0x9
#define PA_SC_ENHANCE__DISABLE_SC_PROCESS_RESET_TILE__SHIFT                                                   0xa
#define PA_SC_ENHANCE__DISABLE_PA_SC_GUIDANCE__SHIFT                                                          0xb
#define PA_SC_ENHANCE__DISABLE_EOV_ALL_CTRL_ONLY_COMBINATIONS__SHIFT                                          0xc
#define PA_SC_ENHANCE__ENABLE_MULTICYCLE_BUBBLE_FREEZE__SHIFT                                                 0xd
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_PA_SC_GUIDANCE__SHIFT                                             0xe
#define PA_SC_ENHANCE__ENABLE_OUT_OF_ORDER_POLY_MODE__SHIFT                                                   0xf
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_EOP_SYNC_NULL_PRIMS_LAST__SHIFT                                   0x10
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_THRESHOLD_SWITCHING__SHIFT                                        0x11
#define PA_SC_ENHANCE__ENABLE_OUT_OF_ORDER_THRESHOLD_SWITCH_AT_EOPG_ONLY__SHIFT                               0x12
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_DESIRED_FIFO_EMPTY_SWITCHING__SHIFT                               0x13
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_SELECTED_FIFO_EMPTY_SWITCHING__SHIFT                              0x14
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_EMPTY_SWITCHING_HYSTERYSIS__SHIFT                                 0x15
#define PA_SC_ENHANCE__ENABLE_OUT_OF_ORDER_DESIRED_FIFO_IS_NEXT_FEID__SHIFT                                   0x16
#define PA_SC_ENHANCE__DISABLE_OOO_NO_EOPG_SKEW_DESIRED_FIFO_IS_CURRENT_FIFO__SHIFT                           0x17
#define PA_SC_ENHANCE__OOO_DISABLE_EOP_ON_FIRST_LIVE_PRIM_HIT__SHIFT                                          0x18
#define PA_SC_ENHANCE__OOO_DISABLE_EOPG_SKEW_THRESHOLD_SWITCHING__SHIFT                                       0x19
#define PA_SC_ENHANCE__DISABLE_EOP_LINE_STIPPLE_RESET__SHIFT                                                  0x1a
#define PA_SC_ENHANCE__DISABLE_VPZ_EOP_LINE_STIPPLE_RESET__SHIFT                                              0x1b
#define PA_SC_ENHANCE__IOO_DISABLE_SCAN_UNSELECTED_FIFOS_FOR_DUAL_GFX_RING_CHANGE__SHIFT                      0x1c
#define PA_SC_ENHANCE__OOO_USE_ABSOLUTE_FIFO_COUNT_IN_THRESHOLD_SWITCHING__SHIFT                              0x1d
#define PA_SC_ENHANCE__ENABLE_PA_SC_OUT_OF_ORDER_MASK                                                         0x00000001L
#define PA_SC_ENHANCE__DISABLE_SC_DB_TILE_FIX_MASK                                                            0x00000002L
#define PA_SC_ENHANCE__DISABLE_AA_MASK_FULL_FIX_MASK                                                          0x00000004L
#define PA_SC_ENHANCE__ENABLE_1XMSAA_SAMPLE_LOCATIONS_MASK                                                    0x00000008L
#define PA_SC_ENHANCE__ENABLE_1XMSAA_SAMPLE_LOC_CENTROID_MASK                                                 0x00000010L
#define PA_SC_ENHANCE__DISABLE_SCISSOR_FIX_MASK                                                               0x00000020L
#define PA_SC_ENHANCE__SEND_UNLIT_STILES_TO_PACKER_MASK                                                       0x00000040L
#define PA_SC_ENHANCE__DISABLE_DUALGRAD_PERF_OPTIMIZATION_MASK                                                0x00000080L
#define PA_SC_ENHANCE__DISABLE_SC_PROCESS_RESET_PRIM_MASK                                                     0x00000100L
#define PA_SC_ENHANCE__DISABLE_SC_PROCESS_RESET_SUPERTILE_MASK                                                0x00000200L
#define PA_SC_ENHANCE__DISABLE_SC_PROCESS_RESET_TILE_MASK                                                     0x00000400L
#define PA_SC_ENHANCE__DISABLE_PA_SC_GUIDANCE_MASK                                                            0x00000800L
#define PA_SC_ENHANCE__DISABLE_EOV_ALL_CTRL_ONLY_COMBINATIONS_MASK                                            0x00001000L
#define PA_SC_ENHANCE__ENABLE_MULTICYCLE_BUBBLE_FREEZE_MASK                                                   0x00002000L
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_PA_SC_GUIDANCE_MASK                                               0x00004000L
#define PA_SC_ENHANCE__ENABLE_OUT_OF_ORDER_POLY_MODE_MASK                                                     0x00008000L
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_EOP_SYNC_NULL_PRIMS_LAST_MASK                                     0x00010000L
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_THRESHOLD_SWITCHING_MASK                                          0x00020000L
#define PA_SC_ENHANCE__ENABLE_OUT_OF_ORDER_THRESHOLD_SWITCH_AT_EOPG_ONLY_MASK                                 0x00040000L
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_DESIRED_FIFO_EMPTY_SWITCHING_MASK                                 0x00080000L
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_SELECTED_FIFO_EMPTY_SWITCHING_MASK                                0x00100000L
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_EMPTY_SWITCHING_HYSTERYSIS_MASK                                   0x00200000L
#define PA_SC_ENHANCE__ENABLE_OUT_OF_ORDER_DESIRED_FIFO_IS_NEXT_FEID_MASK                                     0x00400000L
#define PA_SC_ENHANCE__DISABLE_OOO_NO_EOPG_SKEW_DESIRED_FIFO_IS_CURRENT_FIFO_MASK                             0x00800000L
#define PA_SC_ENHANCE__OOO_DISABLE_EOP_ON_FIRST_LIVE_PRIM_HIT_MASK                                            0x01000000L
#define PA_SC_ENHANCE__OOO_DISABLE_EOPG_SKEW_THRESHOLD_SWITCHING_MASK                                         0x02000000L
#define PA_SC_ENHANCE__DISABLE_EOP_LINE_STIPPLE_RESET_MASK                                                    0x04000000L
#define PA_SC_ENHANCE__DISABLE_VPZ_EOP_LINE_STIPPLE_RESET_MASK                                                0x08000000L
#define PA_SC_ENHANCE__IOO_DISABLE_SCAN_UNSELECTED_FIFOS_FOR_DUAL_GFX_RING_CHANGE_MASK                        0x10000000L
#define PA_SC_ENHANCE__OOO_USE_ABSOLUTE_FIFO_COUNT_IN_THRESHOLD_SWITCHING_MASK                                0x20000000L
//PA_SC_ENHANCE_1
#define PA_SC_ENHANCE_1__REALIGN_DQUADS_OVERRIDE_ENABLE__SHIFT                                                0x0
#define PA_SC_ENHANCE_1__REALIGN_DQUADS_OVERRIDE__SHIFT                                                       0x1
#define PA_SC_ENHANCE_1__DISABLE_SC_BINNING__SHIFT                                                            0x3
#define PA_SC_ENHANCE_1__BYPASS_PBB__SHIFT                                                                    0x4
#define PA_SC_ENHANCE_1__ECO_SPARE0__SHIFT                                                                    0x5
#define PA_SC_ENHANCE_1__ECO_SPARE1__SHIFT                                                                    0x6
#define PA_SC_ENHANCE_1__ECO_SPARE2__SHIFT                                                                    0x7
#define PA_SC_ENHANCE_1__ECO_SPARE3__SHIFT                                                                    0x8
#define PA_SC_ENHANCE_1__DISABLE_SC_PROCESS_RESET_PBB__SHIFT                                                  0x9
#define PA_SC_ENHANCE_1__DISABLE_PBB_SCISSOR_OPT__SHIFT                                                       0xa
#define PA_SC_ENHANCE_1__ENABLE_DFSM_FLUSH_EVENT_TO_FLUSH_POPS_CAM__SHIFT                                     0xb
#define PA_SC_ENHANCE_1__DISABLE_PACKER_GRAD_FDCE_ENHANCE__SHIFT                                              0xd
#define PA_SC_ENHANCE_1__DISABLE_SC_DB_TILE_INTF_FINE_CLOCK_GATE__SHIFT                                       0xe
#define PA_SC_ENHANCE_1__DISABLE_SC_PIPELINE_RESET_LEGACY_MODE_TRANSITION__SHIFT                              0xf
#define PA_SC_ENHANCE_1__DISABLE_PACKER_ODC_ENHANCE__SHIFT                                                    0x10
#define PA_SC_ENHANCE_1__ALLOW_SCALE_LINE_WIDTH_PAD_WITH_BINNING__SHIFT                                       0x11
#define PA_SC_ENHANCE_1__OPTIMAL_BIN_SELECTION__SHIFT                                                         0x12
#define PA_SC_ENHANCE_1__DISABLE_FORCE_SOP_ALL_EVENTS__SHIFT                                                  0x13
#define PA_SC_ENHANCE_1__DISABLE_PBB_CLK_OPTIMIZATION__SHIFT                                                  0x14
#define PA_SC_ENHANCE_1__DISABLE_PBB_SCISSOR_CLK_OPTIMIZATION__SHIFT                                          0x15
#define PA_SC_ENHANCE_1__DISABLE_PBB_BINNING_CLK_OPTIMIZATION__SHIFT                                          0x16
#define PA_SC_ENHANCE_1__RSVD__SHIFT                                                                          0x17
#define PA_SC_ENHANCE_1__REALIGN_DQUADS_OVERRIDE_ENABLE_MASK                                                  0x00000001L
#define PA_SC_ENHANCE_1__REALIGN_DQUADS_OVERRIDE_MASK                                                         0x00000006L
#define PA_SC_ENHANCE_1__DISABLE_SC_BINNING_MASK                                                              0x00000008L
#define PA_SC_ENHANCE_1__BYPASS_PBB_MASK                                                                      0x00000010L
#define PA_SC_ENHANCE_1__ECO_SPARE0_MASK                                                                      0x00000020L
#define PA_SC_ENHANCE_1__ECO_SPARE1_MASK                                                                      0x00000040L
#define PA_SC_ENHANCE_1__ECO_SPARE2_MASK                                                                      0x00000080L
#define PA_SC_ENHANCE_1__ECO_SPARE3_MASK                                                                      0x00000100L
#define PA_SC_ENHANCE_1__DISABLE_SC_PROCESS_RESET_PBB_MASK                                                    0x00000200L
#define PA_SC_ENHANCE_1__DISABLE_PBB_SCISSOR_OPT_MASK                                                         0x00000400L
#define PA_SC_ENHANCE_1__ENABLE_DFSM_FLUSH_EVENT_TO_FLUSH_POPS_CAM_MASK                                       0x00000800L
#define PA_SC_ENHANCE_1__DISABLE_PACKER_GRAD_FDCE_ENHANCE_MASK                                                0x00002000L
#define PA_SC_ENHANCE_1__DISABLE_SC_DB_TILE_INTF_FINE_CLOCK_GATE_MASK                                         0x00004000L
#define PA_SC_ENHANCE_1__DISABLE_SC_PIPELINE_RESET_LEGACY_MODE_TRANSITION_MASK                                0x00008000L
#define PA_SC_ENHANCE_1__DISABLE_PACKER_ODC_ENHANCE_MASK                                                      0x00010000L
#define PA_SC_ENHANCE_1__ALLOW_SCALE_LINE_WIDTH_PAD_WITH_BINNING_MASK                                         0x00020000L
#define PA_SC_ENHANCE_1__OPTIMAL_BIN_SELECTION_MASK                                                           0x00040000L
#define PA_SC_ENHANCE_1__DISABLE_FORCE_SOP_ALL_EVENTS_MASK                                                    0x00080000L
#define PA_SC_ENHANCE_1__DISABLE_PBB_CLK_OPTIMIZATION_MASK                                                    0x00100000L
#define PA_SC_ENHANCE_1__DISABLE_PBB_SCISSOR_CLK_OPTIMIZATION_MASK                                            0x00200000L
#define PA_SC_ENHANCE_1__DISABLE_PBB_BINNING_CLK_OPTIMIZATION_MASK                                            0x00400000L
#define PA_SC_ENHANCE_1__RSVD_MASK                                                                            0xFF800000L
//PA_SC_DSM_CNTL
#define PA_SC_DSM_CNTL__FORCE_EOV_REZ_0__SHIFT                                                                0x0
#define PA_SC_DSM_CNTL__FORCE_EOV_REZ_1__SHIFT                                                                0x1
#define PA_SC_DSM_CNTL__FORCE_EOV_REZ_0_MASK                                                                  0x00000001L
#define PA_SC_DSM_CNTL__FORCE_EOV_REZ_1_MASK                                                                  0x00000002L
//PA_SC_TILE_STEERING_CREST_OVERRIDE
#define PA_SC_TILE_STEERING_CREST_OVERRIDE__ONE_RB_MODE_ENABLE__SHIFT                                         0x0
#define PA_SC_TILE_STEERING_CREST_OVERRIDE__SE_SELECT__SHIFT                                                  0x1
#define PA_SC_TILE_STEERING_CREST_OVERRIDE__RB_SELECT__SHIFT                                                  0x5
#define PA_SC_TILE_STEERING_CREST_OVERRIDE__ONE_RB_MODE_ENABLE_MASK                                           0x00000001L
#define PA_SC_TILE_STEERING_CREST_OVERRIDE__SE_SELECT_MASK                                                    0x00000006L
#define PA_SC_TILE_STEERING_CREST_OVERRIDE__RB_SELECT_MASK                                                    0x00000060L


// addressBlock: gc_sqdec
//SQ_CONFIG
#define SQ_CONFIG__UNUSED__SHIFT                                                                              0x0
#define SQ_CONFIG__OVERRIDE_ALU_BUSY__SHIFT                                                                   0x7
#define SQ_CONFIG__OVERRIDE_LDS_IDX_BUSY__SHIFT                                                               0xb
#define SQ_CONFIG__EARLY_TA_DONE_DISABLE__SHIFT                                                               0xc
#define SQ_CONFIG__DUA_FLAT_LOCK_ENABLE__SHIFT                                                                0xd
#define SQ_CONFIG__DUA_LDS_BYPASS_DISABLE__SHIFT                                                              0xe
#define SQ_CONFIG__DUA_FLAT_LDS_PINGPONG_DISABLE__SHIFT                                                       0xf
#define SQ_CONFIG__DISABLE_VMEM_SOFT_CLAUSE__SHIFT                                                            0x10
#define SQ_CONFIG__DISABLE_SMEM_SOFT_CLAUSE__SHIFT                                                            0x11
#define SQ_CONFIG__ENABLE_HIPRIO_ON_EXP_RDY_VS__SHIFT                                                         0x12
#define SQ_CONFIG__PRIO_VAL_ON_EXP_RDY_VS__SHIFT                                                              0x13
#define SQ_CONFIG__REPLAY_SLEEP_CNT__SHIFT                                                                    0x15
#define SQ_CONFIG__DISABLE_SP_VGPR_WRITE_SKIP__SHIFT                                                          0x1c
#define SQ_CONFIG__DISABLE_SP_REDUNDANT_THREAD_GATING__SHIFT                                                  0x1d
#define SQ_CONFIG__DISABLE_FLAT_SOFT_CLAUSE__SHIFT                                                            0x1e
#define SQ_CONFIG__DISABLE_MIMG_SOFT_CLAUSE__SHIFT                                                            0x1f
#define SQ_CONFIG__UNUSED_MASK                                                                                0x0000007FL
#define SQ_CONFIG__OVERRIDE_ALU_BUSY_MASK                                                                     0x00000080L
#define SQ_CONFIG__OVERRIDE_LDS_IDX_BUSY_MASK                                                                 0x00000800L
#define SQ_CONFIG__EARLY_TA_DONE_DISABLE_MASK                                                                 0x00001000L
#define SQ_CONFIG__DUA_FLAT_LOCK_ENABLE_MASK                                                                  0x00002000L
#define SQ_CONFIG__DUA_LDS_BYPASS_DISABLE_MASK                                                                0x00004000L
#define SQ_CONFIG__DUA_FLAT_LDS_PINGPONG_DISABLE_MASK                                                         0x00008000L
#define SQ_CONFIG__DISABLE_VMEM_SOFT_CLAUSE_MASK                                                              0x00010000L
#define SQ_CONFIG__DISABLE_SMEM_SOFT_CLAUSE_MASK                                                              0x00020000L
#define SQ_CONFIG__ENABLE_HIPRIO_ON_EXP_RDY_VS_MASK                                                           0x00040000L
#define SQ_CONFIG__PRIO_VAL_ON_EXP_RDY_VS_MASK                                                                0x00180000L
#define SQ_CONFIG__REPLAY_SLEEP_CNT_MASK                                                                      0x0FE00000L
#define SQ_CONFIG__DISABLE_SP_VGPR_WRITE_SKIP_MASK                                                            0x10000000L
#define SQ_CONFIG__DISABLE_SP_REDUNDANT_THREAD_GATING_MASK                                                    0x20000000L
#define SQ_CONFIG__DISABLE_FLAT_SOFT_CLAUSE_MASK                                                              0x40000000L
#define SQ_CONFIG__DISABLE_MIMG_SOFT_CLAUSE_MASK                                                              0x80000000L
//SQC_CONFIG
#define SQC_CONFIG__INST_CACHE_SIZE__SHIFT                                                                    0x0
#define SQC_CONFIG__DATA_CACHE_SIZE__SHIFT                                                                    0x2
#define SQC_CONFIG__MISS_FIFO_DEPTH__SHIFT                                                                    0x4
#define SQC_CONFIG__HIT_FIFO_DEPTH__SHIFT                                                                     0x6
#define SQC_CONFIG__FORCE_ALWAYS_MISS__SHIFT                                                                  0x7
#define SQC_CONFIG__FORCE_IN_ORDER__SHIFT                                                                     0x8
#define SQC_CONFIG__IDENTITY_HASH_BANK__SHIFT                                                                 0x9
#define SQC_CONFIG__IDENTITY_HASH_SET__SHIFT                                                                  0xa
#define SQC_CONFIG__PER_VMID_INV_DISABLE__SHIFT                                                               0xb
#define SQC_CONFIG__EVICT_LRU__SHIFT                                                                          0xc
#define SQC_CONFIG__FORCE_2_BANK__SHIFT                                                                       0xe
#define SQC_CONFIG__FORCE_1_BANK__SHIFT                                                                       0xf
#define SQC_CONFIG__LS_DISABLE_CLOCKS__SHIFT                                                                  0x10
#define SQC_CONFIG__INST_PRF_COUNT__SHIFT                                                                     0x18
#define SQC_CONFIG__INST_PRF_FILTER_DIS__SHIFT                                                                0x1a
#define SQC_CONFIG__INST_CACHE_SIZE_MASK                                                                      0x00000003L
#define SQC_CONFIG__DATA_CACHE_SIZE_MASK                                                                      0x0000000CL
#define SQC_CONFIG__MISS_FIFO_DEPTH_MASK                                                                      0x00000030L
#define SQC_CONFIG__HIT_FIFO_DEPTH_MASK                                                                       0x00000040L
#define SQC_CONFIG__FORCE_ALWAYS_MISS_MASK                                                                    0x00000080L
#define SQC_CONFIG__FORCE_IN_ORDER_MASK                                                                       0x00000100L
#define SQC_CONFIG__IDENTITY_HASH_BANK_MASK                                                                   0x00000200L
#define SQC_CONFIG__IDENTITY_HASH_SET_MASK                                                                    0x00000400L
#define SQC_CONFIG__PER_VMID_INV_DISABLE_MASK                                                                 0x00000800L
#define SQC_CONFIG__EVICT_LRU_MASK                                                                            0x00003000L
#define SQC_CONFIG__FORCE_2_BANK_MASK                                                                         0x00004000L
#define SQC_CONFIG__FORCE_1_BANK_MASK                                                                         0x00008000L
#define SQC_CONFIG__LS_DISABLE_CLOCKS_MASK                                                                    0x00FF0000L
#define SQC_CONFIG__INST_PRF_COUNT_MASK                                                                       0x03000000L
#define SQC_CONFIG__INST_PRF_FILTER_DIS_MASK                                                                  0x04000000L
//LDS_CONFIG
#define LDS_CONFIG__ADDR_OUT_OF_RANGE_REPORTING__SHIFT                                                        0x0
#define LDS_CONFIG__ADDR_OUT_OF_RANGE_REPORTING_MASK                                                          0x00000001L
//SQ_RANDOM_WAVE_PRI
#define SQ_RANDOM_WAVE_PRI__RET__SHIFT                                                                        0x0
#define SQ_RANDOM_WAVE_PRI__RUI__SHIFT                                                                        0x7
#define SQ_RANDOM_WAVE_PRI__RNG__SHIFT                                                                        0xa
#define SQ_RANDOM_WAVE_PRI__RET_MASK                                                                          0x0000007FL
#define SQ_RANDOM_WAVE_PRI__RUI_MASK                                                                          0x00000380L
#define SQ_RANDOM_WAVE_PRI__RNG_MASK                                                                          0x007FFC00L
//SQ_REG_CREDITS
#define SQ_REG_CREDITS__SRBM_CREDITS__SHIFT                                                                   0x0
#define SQ_REG_CREDITS__CMD_CREDITS__SHIFT                                                                    0x8
#define SQ_REG_CREDITS__REG_BUSY__SHIFT                                                                       0x1c
#define SQ_REG_CREDITS__SRBM_OVERFLOW__SHIFT                                                                  0x1d
#define SQ_REG_CREDITS__IMMED_OVERFLOW__SHIFT                                                                 0x1e
#define SQ_REG_CREDITS__CMD_OVERFLOW__SHIFT                                                                   0x1f
#define SQ_REG_CREDITS__SRBM_CREDITS_MASK                                                                     0x0000003FL
#define SQ_REG_CREDITS__CMD_CREDITS_MASK                                                                      0x00000F00L
#define SQ_REG_CREDITS__REG_BUSY_MASK                                                                         0x10000000L
#define SQ_REG_CREDITS__SRBM_OVERFLOW_MASK                                                                    0x20000000L
#define SQ_REG_CREDITS__IMMED_OVERFLOW_MASK                                                                   0x40000000L
#define SQ_REG_CREDITS__CMD_OVERFLOW_MASK                                                                     0x80000000L
//SQ_FIFO_SIZES
#define SQ_FIFO_SIZES__INTERRUPT_FIFO_SIZE__SHIFT                                                             0x0
#define SQ_FIFO_SIZES__TTRACE_FIFO_SIZE__SHIFT                                                                0x8
#define SQ_FIFO_SIZES__EXPORT_BUF_SIZE__SHIFT                                                                 0x10
#define SQ_FIFO_SIZES__VMEM_DATA_FIFO_SIZE__SHIFT                                                             0x12
#define SQ_FIFO_SIZES__INTERRUPT_FIFO_SIZE_MASK                                                               0x0000000FL
#define SQ_FIFO_SIZES__TTRACE_FIFO_SIZE_MASK                                                                  0x00000F00L
#define SQ_FIFO_SIZES__EXPORT_BUF_SIZE_MASK                                                                   0x00030000L
#define SQ_FIFO_SIZES__VMEM_DATA_FIFO_SIZE_MASK                                                               0x000C0000L
//SQ_DSM_CNTL
#define SQ_DSM_CNTL__WAVEFRONT_STALL_0__SHIFT                                                                 0x0
#define SQ_DSM_CNTL__WAVEFRONT_STALL_1__SHIFT                                                                 0x1
#define SQ_DSM_CNTL__SPI_BACKPRESSURE_0__SHIFT                                                                0x2
#define SQ_DSM_CNTL__SPI_BACKPRESSURE_1__SHIFT                                                                0x3
#define SQ_DSM_CNTL__SEL_DSM_SGPR_IRRITATOR_DATA0__SHIFT                                                      0x8
#define SQ_DSM_CNTL__SEL_DSM_SGPR_IRRITATOR_DATA1__SHIFT                                                      0x9
#define SQ_DSM_CNTL__SGPR_ENABLE_SINGLE_WRITE__SHIFT                                                          0xa
#define SQ_DSM_CNTL__SEL_DSM_LDS_IRRITATOR_DATA0__SHIFT                                                       0x10
#define SQ_DSM_CNTL__SEL_DSM_LDS_IRRITATOR_DATA1__SHIFT                                                       0x11
#define SQ_DSM_CNTL__LDS_ENABLE_SINGLE_WRITE01__SHIFT                                                         0x12
#define SQ_DSM_CNTL__SEL_DSM_LDS_IRRITATOR_DATA2__SHIFT                                                       0x13
#define SQ_DSM_CNTL__SEL_DSM_LDS_IRRITATOR_DATA3__SHIFT                                                       0x14
#define SQ_DSM_CNTL__LDS_ENABLE_SINGLE_WRITE23__SHIFT                                                         0x15
#define SQ_DSM_CNTL__SEL_DSM_SP_IRRITATOR_DATA0__SHIFT                                                        0x18
#define SQ_DSM_CNTL__SEL_DSM_SP_IRRITATOR_DATA1__SHIFT                                                        0x19
#define SQ_DSM_CNTL__SP_ENABLE_SINGLE_WRITE__SHIFT                                                            0x1a
#define SQ_DSM_CNTL__WAVEFRONT_STALL_0_MASK                                                                   0x00000001L
#define SQ_DSM_CNTL__WAVEFRONT_STALL_1_MASK                                                                   0x00000002L
#define SQ_DSM_CNTL__SPI_BACKPRESSURE_0_MASK                                                                  0x00000004L
#define SQ_DSM_CNTL__SPI_BACKPRESSURE_1_MASK                                                                  0x00000008L
#define SQ_DSM_CNTL__SEL_DSM_SGPR_IRRITATOR_DATA0_MASK                                                        0x00000100L
#define SQ_DSM_CNTL__SEL_DSM_SGPR_IRRITATOR_DATA1_MASK                                                        0x00000200L
#define SQ_DSM_CNTL__SGPR_ENABLE_SINGLE_WRITE_MASK                                                            0x00000400L
#define SQ_DSM_CNTL__SEL_DSM_LDS_IRRITATOR_DATA0_MASK                                                         0x00010000L
#define SQ_DSM_CNTL__SEL_DSM_LDS_IRRITATOR_DATA1_MASK                                                         0x00020000L
#define SQ_DSM_CNTL__LDS_ENABLE_SINGLE_WRITE01_MASK                                                           0x00040000L
#define SQ_DSM_CNTL__SEL_DSM_LDS_IRRITATOR_DATA2_MASK                                                         0x00080000L
#define SQ_DSM_CNTL__SEL_DSM_LDS_IRRITATOR_DATA3_MASK                                                         0x00100000L
#define SQ_DSM_CNTL__LDS_ENABLE_SINGLE_WRITE23_MASK                                                           0x00200000L
#define SQ_DSM_CNTL__SEL_DSM_SP_IRRITATOR_DATA0_MASK                                                          0x01000000L
#define SQ_DSM_CNTL__SEL_DSM_SP_IRRITATOR_DATA1_MASK                                                          0x02000000L
#define SQ_DSM_CNTL__SP_ENABLE_SINGLE_WRITE_MASK                                                              0x04000000L
//SQ_DSM_CNTL2
#define SQ_DSM_CNTL2__SGPR_ENABLE_ERROR_INJECT__SHIFT                                                         0x0
#define SQ_DSM_CNTL2__SGPR_SELECT_INJECT_DELAY__SHIFT                                                         0x2
#define SQ_DSM_CNTL2__LDS_D_ENABLE_ERROR_INJECT__SHIFT                                                        0x3
#define SQ_DSM_CNTL2__LDS_D_SELECT_INJECT_DELAY__SHIFT                                                        0x5
#define SQ_DSM_CNTL2__LDS_I_ENABLE_ERROR_INJECT__SHIFT                                                        0x6
#define SQ_DSM_CNTL2__LDS_I_SELECT_INJECT_DELAY__SHIFT                                                        0x8
#define SQ_DSM_CNTL2__SP_ENABLE_ERROR_INJECT__SHIFT                                                           0x9
#define SQ_DSM_CNTL2__SP_SELECT_INJECT_DELAY__SHIFT                                                           0xb
#define SQ_DSM_CNTL2__LDS_INJECT_DELAY__SHIFT                                                                 0xe
#define SQ_DSM_CNTL2__SP_INJECT_DELAY__SHIFT                                                                  0x14
#define SQ_DSM_CNTL2__SQ_INJECT_DELAY__SHIFT                                                                  0x1a
#define SQ_DSM_CNTL2__SGPR_ENABLE_ERROR_INJECT_MASK                                                           0x00000003L
#define SQ_DSM_CNTL2__SGPR_SELECT_INJECT_DELAY_MASK                                                           0x00000004L
#define SQ_DSM_CNTL2__LDS_D_ENABLE_ERROR_INJECT_MASK                                                          0x00000018L
#define SQ_DSM_CNTL2__LDS_D_SELECT_INJECT_DELAY_MASK                                                          0x00000020L
#define SQ_DSM_CNTL2__LDS_I_ENABLE_ERROR_INJECT_MASK                                                          0x000000C0L
#define SQ_DSM_CNTL2__LDS_I_SELECT_INJECT_DELAY_MASK                                                          0x00000100L
#define SQ_DSM_CNTL2__SP_ENABLE_ERROR_INJECT_MASK                                                             0x00000600L
#define SQ_DSM_CNTL2__SP_SELECT_INJECT_DELAY_MASK                                                             0x00000800L
#define SQ_DSM_CNTL2__LDS_INJECT_DELAY_MASK                                                                   0x000FC000L
#define SQ_DSM_CNTL2__SP_INJECT_DELAY_MASK                                                                    0x03F00000L
#define SQ_DSM_CNTL2__SQ_INJECT_DELAY_MASK                                                                    0xFC000000L
//SQ_RUNTIME_CONFIG
#define SQ_RUNTIME_CONFIG__ENABLE_TEX_ARB_OLDEST__SHIFT                                                       0x0
#define SQ_RUNTIME_CONFIG__ENABLE_TEX_ARB_OLDEST_MASK                                                         0x00000001L
//SH_MEM_BASES
#define SH_MEM_BASES__PRIVATE_BASE__SHIFT                                                                     0x0
#define SH_MEM_BASES__SHARED_BASE__SHIFT                                                                      0x10
#define SH_MEM_BASES__PRIVATE_BASE_MASK                                                                       0x0000FFFFL
#define SH_MEM_BASES__SHARED_BASE_MASK                                                                        0xFFFF0000L
//SH_MEM_CONFIG
#define SH_MEM_CONFIG__ADDRESS_MODE__SHIFT                                                                    0x0
#define SH_MEM_CONFIG__ALIGNMENT_MODE__SHIFT                                                                  0x3
#define SH_MEM_CONFIG__RETRY_DISABLE__SHIFT                                                                   0xc
#define SH_MEM_CONFIG__PRIVATE_NV__SHIFT                                                                      0xd
#define SH_MEM_CONFIG__ADDRESS_MODE_MASK                                                                      0x00000001L
#define SH_MEM_CONFIG__ALIGNMENT_MODE_MASK                                                                    0x00000018L
#define SH_MEM_CONFIG__RETRY_DISABLE_MASK                                                                     0x00001000L
#define SH_MEM_CONFIG__PRIVATE_NV_MASK                                                                        0x00002000L
//CC_GC_SHADER_RATE_CONFIG
#define CC_GC_SHADER_RATE_CONFIG__DPFP_RATE__SHIFT                                                            0x1
#define CC_GC_SHADER_RATE_CONFIG__SQC_BALANCE_DISABLE__SHIFT                                                  0x3
#define CC_GC_SHADER_RATE_CONFIG__HALF_LDS__SHIFT                                                             0x4
#define CC_GC_SHADER_RATE_CONFIG__DPFP_RATE_MASK                                                              0x00000006L
#define CC_GC_SHADER_RATE_CONFIG__SQC_BALANCE_DISABLE_MASK                                                    0x00000008L
#define CC_GC_SHADER_RATE_CONFIG__HALF_LDS_MASK                                                               0x00000010L
//GC_USER_SHADER_RATE_CONFIG
#define GC_USER_SHADER_RATE_CONFIG__DPFP_RATE__SHIFT                                                          0x1
#define GC_USER_SHADER_RATE_CONFIG__SQC_BALANCE_DISABLE__SHIFT                                                0x3
#define GC_USER_SHADER_RATE_CONFIG__HALF_LDS__SHIFT                                                           0x4
#define GC_USER_SHADER_RATE_CONFIG__DPFP_RATE_MASK                                                            0x00000006L
#define GC_USER_SHADER_RATE_CONFIG__SQC_BALANCE_DISABLE_MASK                                                  0x00000008L
#define GC_USER_SHADER_RATE_CONFIG__HALF_LDS_MASK                                                             0x00000010L
//SQ_INTERRUPT_AUTO_MASK
#define SQ_INTERRUPT_AUTO_MASK__MASK__SHIFT                                                                   0x0
#define SQ_INTERRUPT_AUTO_MASK__MASK_MASK                                                                     0x00FFFFFFL
//SQ_INTERRUPT_MSG_CTRL
#define SQ_INTERRUPT_MSG_CTRL__STALL__SHIFT                                                                   0x0
#define SQ_INTERRUPT_MSG_CTRL__STALL_MASK                                                                     0x00000001L
//SQ_UTCL1_CNTL1
#define SQ_UTCL1_CNTL1__FORCE_4K_L2_RESP__SHIFT                                                               0x0
#define SQ_UTCL1_CNTL1__GPUVM_64K_DEF__SHIFT                                                                  0x1
#define SQ_UTCL1_CNTL1__GPUVM_PERM_MODE__SHIFT                                                                0x2
#define SQ_UTCL1_CNTL1__RESP_MODE__SHIFT                                                                      0x3
#define SQ_UTCL1_CNTL1__RESP_FAULT_MODE__SHIFT                                                                0x5
#define SQ_UTCL1_CNTL1__CLIENTID__SHIFT                                                                       0x7
#define SQ_UTCL1_CNTL1__USERVM_DIS__SHIFT                                                                     0x10
#define SQ_UTCL1_CNTL1__ENABLE_PUSH_LFIFO__SHIFT                                                              0x11
#define SQ_UTCL1_CNTL1__ENABLE_LFIFO_PRI_ARB__SHIFT                                                           0x12
#define SQ_UTCL1_CNTL1__REG_INVALIDATE_VMID__SHIFT                                                            0x13
#define SQ_UTCL1_CNTL1__REG_INVALIDATE_ALL_VMID__SHIFT                                                        0x17
#define SQ_UTCL1_CNTL1__REG_INVALIDATE_TOGGLE__SHIFT                                                          0x18
#define SQ_UTCL1_CNTL1__REG_INVALIDATE_ALL__SHIFT                                                             0x19
#define SQ_UTCL1_CNTL1__FORCE_MISS__SHIFT                                                                     0x1a
#define SQ_UTCL1_CNTL1__FORCE_IN_ORDER__SHIFT                                                                 0x1b
#define SQ_UTCL1_CNTL1__REDUCE_FIFO_DEPTH_BY_2__SHIFT                                                         0x1c
#define SQ_UTCL1_CNTL1__REDUCE_CACHE_SIZE_BY_2__SHIFT                                                         0x1e
#define SQ_UTCL1_CNTL1__FORCE_4K_L2_RESP_MASK                                                                 0x00000001L
#define SQ_UTCL1_CNTL1__GPUVM_64K_DEF_MASK                                                                    0x00000002L
#define SQ_UTCL1_CNTL1__GPUVM_PERM_MODE_MASK                                                                  0x00000004L
#define SQ_UTCL1_CNTL1__RESP_MODE_MASK                                                                        0x00000018L
#define SQ_UTCL1_CNTL1__RESP_FAULT_MODE_MASK                                                                  0x00000060L
#define SQ_UTCL1_CNTL1__CLIENTID_MASK                                                                         0x0000FF80L
#define SQ_UTCL1_CNTL1__USERVM_DIS_MASK                                                                       0x00010000L
#define SQ_UTCL1_CNTL1__ENABLE_PUSH_LFIFO_MASK                                                                0x00020000L
#define SQ_UTCL1_CNTL1__ENABLE_LFIFO_PRI_ARB_MASK                                                             0x00040000L
#define SQ_UTCL1_CNTL1__REG_INVALIDATE_VMID_MASK                                                              0x00780000L
#define SQ_UTCL1_CNTL1__REG_INVALIDATE_ALL_VMID_MASK                                                          0x00800000L
#define SQ_UTCL1_CNTL1__REG_INVALIDATE_TOGGLE_MASK                                                            0x01000000L
#define SQ_UTCL1_CNTL1__REG_INVALIDATE_ALL_MASK                                                               0x02000000L
#define SQ_UTCL1_CNTL1__FORCE_MISS_MASK                                                                       0x04000000L
#define SQ_UTCL1_CNTL1__FORCE_IN_ORDER_MASK                                                                   0x08000000L
#define SQ_UTCL1_CNTL1__REDUCE_FIFO_DEPTH_BY_2_MASK                                                           0x30000000L
#define SQ_UTCL1_CNTL1__REDUCE_CACHE_SIZE_BY_2_MASK                                                           0xC0000000L
//SQ_UTCL1_CNTL2
#define SQ_UTCL1_CNTL2__SPARE__SHIFT                                                                          0x0
#define SQ_UTCL1_CNTL2__LFIFO_SCAN_DISABLE__SHIFT                                                             0x8
#define SQ_UTCL1_CNTL2__MTYPE_OVRD_DIS__SHIFT                                                                 0x9
#define SQ_UTCL1_CNTL2__LINE_VALID__SHIFT                                                                     0xa
#define SQ_UTCL1_CNTL2__DIS_EDC__SHIFT                                                                        0xb
#define SQ_UTCL1_CNTL2__GPUVM_INV_MODE__SHIFT                                                                 0xc
#define SQ_UTCL1_CNTL2__SHOOTDOWN_OPT__SHIFT                                                                  0xd
#define SQ_UTCL1_CNTL2__FORCE_SNOOP__SHIFT                                                                    0xe
#define SQ_UTCL1_CNTL2__FORCE_GPUVM_INV_ACK__SHIFT                                                            0xf
#define SQ_UTCL1_CNTL2__RETRY_TIMER__SHIFT                                                                    0x10
#define SQ_UTCL1_CNTL2__FORCE_FRAG_2M_TO_64K__SHIFT                                                           0x1a
#define SQ_UTCL1_CNTL2__PREFETCH_PAGE__SHIFT                                                                  0x1c
#define SQ_UTCL1_CNTL2__SPARE_MASK                                                                            0x000000FFL
#define SQ_UTCL1_CNTL2__LFIFO_SCAN_DISABLE_MASK                                                               0x00000100L
#define SQ_UTCL1_CNTL2__MTYPE_OVRD_DIS_MASK                                                                   0x00000200L
#define SQ_UTCL1_CNTL2__LINE_VALID_MASK                                                                       0x00000400L
#define SQ_UTCL1_CNTL2__DIS_EDC_MASK                                                                          0x00000800L
#define SQ_UTCL1_CNTL2__GPUVM_INV_MODE_MASK                                                                   0x00001000L
#define SQ_UTCL1_CNTL2__SHOOTDOWN_OPT_MASK                                                                    0x00002000L
#define SQ_UTCL1_CNTL2__FORCE_SNOOP_MASK                                                                      0x00004000L
#define SQ_UTCL1_CNTL2__FORCE_GPUVM_INV_ACK_MASK                                                              0x00008000L
#define SQ_UTCL1_CNTL2__RETRY_TIMER_MASK                                                                      0x007F0000L
#define SQ_UTCL1_CNTL2__FORCE_FRAG_2M_TO_64K_MASK                                                             0x04000000L
#define SQ_UTCL1_CNTL2__PREFETCH_PAGE_MASK                                                                    0xF0000000L
//SQ_UTCL1_STATUS
#define SQ_UTCL1_STATUS__FAULT_DETECTED__SHIFT                                                                0x0
#define SQ_UTCL1_STATUS__RETRY_DETECTED__SHIFT                                                                0x1
#define SQ_UTCL1_STATUS__PRT_DETECTED__SHIFT                                                                  0x2
#define SQ_UTCL1_STATUS__RESERVED__SHIFT                                                                      0x3
#define SQ_UTCL1_STATUS__UNUSED__SHIFT                                                                        0x10
#define SQ_UTCL1_STATUS__FAULT_DETECTED_MASK                                                                  0x00000001L
#define SQ_UTCL1_STATUS__RETRY_DETECTED_MASK                                                                  0x00000002L
#define SQ_UTCL1_STATUS__PRT_DETECTED_MASK                                                                    0x00000004L
#define SQ_UTCL1_STATUS__RESERVED_MASK                                                                        0x0000FFF8L
#define SQ_UTCL1_STATUS__UNUSED_MASK                                                                          0xFFFF0000L
//SQ_SHADER_TBA_LO
#define SQ_SHADER_TBA_LO__ADDR_LO__SHIFT                                                                      0x0
#define SQ_SHADER_TBA_LO__ADDR_LO_MASK                                                                        0xFFFFFFFFL
//SQ_SHADER_TBA_HI
#define SQ_SHADER_TBA_HI__ADDR_HI__SHIFT                                                                      0x0
#define SQ_SHADER_TBA_HI__ADDR_HI_MASK                                                                        0x000000FFL
//SQ_SHADER_TMA_LO
#define SQ_SHADER_TMA_LO__ADDR_LO__SHIFT                                                                      0x0
#define SQ_SHADER_TMA_LO__ADDR_LO_MASK                                                                        0xFFFFFFFFL
//SQ_SHADER_TMA_HI
#define SQ_SHADER_TMA_HI__ADDR_HI__SHIFT                                                                      0x0
#define SQ_SHADER_TMA_HI__ADDR_HI_MASK                                                                        0x000000FFL
//SQC_DSM_CNTL
#define SQC_DSM_CNTL__INST_UTCL1_LFIFO_DSM_IRRITATOR_DATA__SHIFT                                              0x0
#define SQC_DSM_CNTL__INST_UTCL1_LFIFO_ENABLE_SINGLE_WRITE__SHIFT                                             0x2
#define SQC_DSM_CNTL__DATA_CU0_WRITE_DATA_BUF_DSM_IRRITATOR_DATA__SHIFT                                       0x3
#define SQC_DSM_CNTL__DATA_CU0_WRITE_DATA_BUF_ENABLE_SINGLE_WRITE__SHIFT                                      0x5
#define SQC_DSM_CNTL__DATA_CU0_UTCL1_LFIFO_DSM_IRRITATOR_DATA__SHIFT                                          0x6
#define SQC_DSM_CNTL__DATA_CU0_UTCL1_LFIFO_ENABLE_SINGLE_WRITE__SHIFT                                         0x8
#define SQC_DSM_CNTL__DATA_CU1_WRITE_DATA_BUF_DSM_IRRITATOR_DATA__SHIFT                                       0x9
#define SQC_DSM_CNTL__DATA_CU1_WRITE_DATA_BUF_ENABLE_SINGLE_WRITE__SHIFT                                      0xb
#define SQC_DSM_CNTL__DATA_CU1_UTCL1_LFIFO_DSM_IRRITATOR_DATA__SHIFT                                          0xc
#define SQC_DSM_CNTL__DATA_CU1_UTCL1_LFIFO_ENABLE_SINGLE_WRITE__SHIFT                                         0xe
#define SQC_DSM_CNTL__DATA_CU2_WRITE_DATA_BUF_DSM_IRRITATOR_DATA__SHIFT                                       0xf
#define SQC_DSM_CNTL__DATA_CU2_WRITE_DATA_BUF_ENABLE_SINGLE_WRITE__SHIFT                                      0x11
#define SQC_DSM_CNTL__DATA_CU2_UTCL1_LFIFO_DSM_IRRITATOR_DATA__SHIFT                                          0x12
#define SQC_DSM_CNTL__DATA_CU2_UTCL1_LFIFO_ENABLE_SINGLE_WRITE__SHIFT                                         0x14
#define SQC_DSM_CNTL__INST_UTCL1_LFIFO_DSM_IRRITATOR_DATA_MASK                                                0x00000003L
#define SQC_DSM_CNTL__INST_UTCL1_LFIFO_ENABLE_SINGLE_WRITE_MASK                                               0x00000004L
#define SQC_DSM_CNTL__DATA_CU0_WRITE_DATA_BUF_DSM_IRRITATOR_DATA_MASK                                         0x00000018L
#define SQC_DSM_CNTL__DATA_CU0_WRITE_DATA_BUF_ENABLE_SINGLE_WRITE_MASK                                        0x00000020L
#define SQC_DSM_CNTL__DATA_CU0_UTCL1_LFIFO_DSM_IRRITATOR_DATA_MASK                                            0x000000C0L
#define SQC_DSM_CNTL__DATA_CU0_UTCL1_LFIFO_ENABLE_SINGLE_WRITE_MASK                                           0x00000100L
#define SQC_DSM_CNTL__DATA_CU1_WRITE_DATA_BUF_DSM_IRRITATOR_DATA_MASK                                         0x00000600L
#define SQC_DSM_CNTL__DATA_CU1_WRITE_DATA_BUF_ENABLE_SINGLE_WRITE_MASK                                        0x00000800L
#define SQC_DSM_CNTL__DATA_CU1_UTCL1_LFIFO_DSM_IRRITATOR_DATA_MASK                                            0x00003000L
#define SQC_DSM_CNTL__DATA_CU1_UTCL1_LFIFO_ENABLE_SINGLE_WRITE_MASK                                           0x00004000L
#define SQC_DSM_CNTL__DATA_CU2_WRITE_DATA_BUF_DSM_IRRITATOR_DATA_MASK                                         0x00018000L
#define SQC_DSM_CNTL__DATA_CU2_WRITE_DATA_BUF_ENABLE_SINGLE_WRITE_MASK                                        0x00020000L
#define SQC_DSM_CNTL__DATA_CU2_UTCL1_LFIFO_DSM_IRRITATOR_DATA_MASK                                            0x000C0000L
#define SQC_DSM_CNTL__DATA_CU2_UTCL1_LFIFO_ENABLE_SINGLE_WRITE_MASK                                           0x00100000L
//SQC_DSM_CNTLA
#define SQC_DSM_CNTLA__INST_TAG_RAM_DSM_IRRITATOR_DATA__SHIFT                                                 0x0
#define SQC_DSM_CNTLA__INST_TAG_RAM_ENABLE_SINGLE_WRITE__SHIFT                                                0x2
#define SQC_DSM_CNTLA__INST_UTCL1_MISS_FIFO_DSM_IRRITATOR_DATA__SHIFT                                         0x3
#define SQC_DSM_CNTLA__INST_UTCL1_MISS_FIFO_ENABLE_SINGLE_WRITE__SHIFT                                        0x5
#define SQC_DSM_CNTLA__INST_MISS_FIFO_DSM_IRRITATOR_DATA__SHIFT                                               0x6
#define SQC_DSM_CNTLA__INST_MISS_FIFO_ENABLE_SINGLE_WRITE__SHIFT                                              0x8
#define SQC_DSM_CNTLA__INST_BANK_RAM_DSM_IRRITATOR_DATA__SHIFT                                                0x9
#define SQC_DSM_CNTLA__INST_BANK_RAM_ENABLE_SINGLE_WRITE__SHIFT                                               0xb
#define SQC_DSM_CNTLA__DATA_TAG_RAM_DSM_IRRITATOR_DATA__SHIFT                                                 0xc
#define SQC_DSM_CNTLA__DATA_TAG_RAM_ENABLE_SINGLE_WRITE__SHIFT                                                0xe
#define SQC_DSM_CNTLA__DATA_HIT_FIFO_DSM_IRRITATOR_DATA__SHIFT                                                0xf
#define SQC_DSM_CNTLA__DATA_HIT_FIFO_ENABLE_SINGLE_WRITE__SHIFT                                               0x11
#define SQC_DSM_CNTLA__DATA_MISS_FIFO_DSM_IRRITATOR_DATA__SHIFT                                               0x12
#define SQC_DSM_CNTLA__DATA_MISS_FIFO_ENABLE_SINGLE_WRITE__SHIFT                                              0x14
#define SQC_DSM_CNTLA__DATA_DIRTY_BIT_RAM_DSM_IRRITATOR_DATA__SHIFT                                           0x15
#define SQC_DSM_CNTLA__DATA_DIRTY_BIT_RAM_ENABLE_SINGLE_WRITE__SHIFT                                          0x17
#define SQC_DSM_CNTLA__DATA_BANK_RAM_DSM_IRRITATOR_DATA__SHIFT                                                0x18
#define SQC_DSM_CNTLA__DATA_BANK_RAM_ENABLE_SINGLE_WRITE__SHIFT                                               0x1a
#define SQC_DSM_CNTLA__INST_TAG_RAM_DSM_IRRITATOR_DATA_MASK                                                   0x00000003L
#define SQC_DSM_CNTLA__INST_TAG_RAM_ENABLE_SINGLE_WRITE_MASK                                                  0x00000004L
#define SQC_DSM_CNTLA__INST_UTCL1_MISS_FIFO_DSM_IRRITATOR_DATA_MASK                                           0x00000018L
#define SQC_DSM_CNTLA__INST_UTCL1_MISS_FIFO_ENABLE_SINGLE_WRITE_MASK                                          0x00000020L
#define SQC_DSM_CNTLA__INST_MISS_FIFO_DSM_IRRITATOR_DATA_MASK                                                 0x000000C0L
#define SQC_DSM_CNTLA__INST_MISS_FIFO_ENABLE_SINGLE_WRITE_MASK                                                0x00000100L
#define SQC_DSM_CNTLA__INST_BANK_RAM_DSM_IRRITATOR_DATA_MASK                                                  0x00000600L
#define SQC_DSM_CNTLA__INST_BANK_RAM_ENABLE_SINGLE_WRITE_MASK                                                 0x00000800L
#define SQC_DSM_CNTLA__DATA_TAG_RAM_DSM_IRRITATOR_DATA_MASK                                                   0x00003000L
#define SQC_DSM_CNTLA__DATA_TAG_RAM_ENABLE_SINGLE_WRITE_MASK                                                  0x00004000L
#define SQC_DSM_CNTLA__DATA_HIT_FIFO_DSM_IRRITATOR_DATA_MASK                                                  0x00018000L
#define SQC_DSM_CNTLA__DATA_HIT_FIFO_ENABLE_SINGLE_WRITE_MASK                                                 0x00020000L
#define SQC_DSM_CNTLA__DATA_MISS_FIFO_DSM_IRRITATOR_DATA_MASK                                                 0x000C0000L
#define SQC_DSM_CNTLA__DATA_MISS_FIFO_ENABLE_SINGLE_WRITE_MASK                                                0x00100000L
#define SQC_DSM_CNTLA__DATA_DIRTY_BIT_RAM_DSM_IRRITATOR_DATA_MASK                                             0x00600000L
#define SQC_DSM_CNTLA__DATA_DIRTY_BIT_RAM_ENABLE_SINGLE_WRITE_MASK                                            0x00800000L
#define SQC_DSM_CNTLA__DATA_BANK_RAM_DSM_IRRITATOR_DATA_MASK                                                  0x03000000L
#define SQC_DSM_CNTLA__DATA_BANK_RAM_ENABLE_SINGLE_WRITE_MASK                                                 0x04000000L
//SQC_DSM_CNTLB
#define SQC_DSM_CNTLB__INST_TAG_RAM_DSM_IRRITATOR_DATA__SHIFT                                                 0x0
#define SQC_DSM_CNTLB__INST_TAG_RAM_ENABLE_SINGLE_WRITE__SHIFT                                                0x2
#define SQC_DSM_CNTLB__INST_UTCL1_MISS_FIFO_DSM_IRRITATOR_DATA__SHIFT                                         0x3
#define SQC_DSM_CNTLB__INST_UTCL1_MISS_FIFO_ENABLE_SINGLE_WRITE__SHIFT                                        0x5
#define SQC_DSM_CNTLB__INST_MISS_FIFO_DSM_IRRITATOR_DATA__SHIFT                                               0x6
#define SQC_DSM_CNTLB__INST_MISS_FIFO_ENABLE_SINGLE_WRITE__SHIFT                                              0x8
#define SQC_DSM_CNTLB__INST_BANK_RAM_DSM_IRRITATOR_DATA__SHIFT                                                0x9
#define SQC_DSM_CNTLB__INST_BANK_RAM_ENABLE_SINGLE_WRITE__SHIFT                                               0xb
#define SQC_DSM_CNTLB__DATA_TAG_RAM_DSM_IRRITATOR_DATA__SHIFT                                                 0xc
#define SQC_DSM_CNTLB__DATA_TAG_RAM_ENABLE_SINGLE_WRITE__SHIFT                                                0xe
#define SQC_DSM_CNTLB__DATA_HIT_FIFO_DSM_IRRITATOR_DATA__SHIFT                                                0xf
#define SQC_DSM_CNTLB__DATA_HIT_FIFO_ENABLE_SINGLE_WRITE__SHIFT                                               0x11
#define SQC_DSM_CNTLB__DATA_MISS_FIFO_DSM_IRRITATOR_DATA__SHIFT                                               0x12
#define SQC_DSM_CNTLB__DATA_MISS_FIFO_ENABLE_SINGLE_WRITE__SHIFT                                              0x14
#define SQC_DSM_CNTLB__DATA_DIRTY_BIT_RAM_DSM_IRRITATOR_DATA__SHIFT                                           0x15
#define SQC_DSM_CNTLB__DATA_DIRTY_BIT_RAM_ENABLE_SINGLE_WRITE__SHIFT                                          0x17
#define SQC_DSM_CNTLB__DATA_BANK_RAM_DSM_IRRITATOR_DATA__SHIFT                                                0x18
#define SQC_DSM_CNTLB__DATA_BANK_RAM_ENABLE_SINGLE_WRITE__SHIFT                                               0x1a
#define SQC_DSM_CNTLB__INST_TAG_RAM_DSM_IRRITATOR_DATA_MASK                                                   0x00000003L
#define SQC_DSM_CNTLB__INST_TAG_RAM_ENABLE_SINGLE_WRITE_MASK                                                  0x00000004L
#define SQC_DSM_CNTLB__INST_UTCL1_MISS_FIFO_DSM_IRRITATOR_DATA_MASK                                           0x00000018L
#define SQC_DSM_CNTLB__INST_UTCL1_MISS_FIFO_ENABLE_SINGLE_WRITE_MASK                                          0x00000020L
#define SQC_DSM_CNTLB__INST_MISS_FIFO_DSM_IRRITATOR_DATA_MASK                                                 0x000000C0L
#define SQC_DSM_CNTLB__INST_MISS_FIFO_ENABLE_SINGLE_WRITE_MASK                                                0x00000100L
#define SQC_DSM_CNTLB__INST_BANK_RAM_DSM_IRRITATOR_DATA_MASK                                                  0x00000600L
#define SQC_DSM_CNTLB__INST_BANK_RAM_ENABLE_SINGLE_WRITE_MASK                                                 0x00000800L
#define SQC_DSM_CNTLB__DATA_TAG_RAM_DSM_IRRITATOR_DATA_MASK                                                   0x00003000L
#define SQC_DSM_CNTLB__DATA_TAG_RAM_ENABLE_SINGLE_WRITE_MASK                                                  0x00004000L
#define SQC_DSM_CNTLB__DATA_HIT_FIFO_DSM_IRRITATOR_DATA_MASK                                                  0x00018000L
#define SQC_DSM_CNTLB__DATA_HIT_FIFO_ENABLE_SINGLE_WRITE_MASK                                                 0x00020000L
#define SQC_DSM_CNTLB__DATA_MISS_FIFO_DSM_IRRITATOR_DATA_MASK                                                 0x000C0000L
#define SQC_DSM_CNTLB__DATA_MISS_FIFO_ENABLE_SINGLE_WRITE_MASK                                                0x00100000L
#define SQC_DSM_CNTLB__DATA_DIRTY_BIT_RAM_DSM_IRRITATOR_DATA_MASK                                             0x00600000L
#define SQC_DSM_CNTLB__DATA_DIRTY_BIT_RAM_ENABLE_SINGLE_WRITE_MASK                                            0x00800000L
#define SQC_DSM_CNTLB__DATA_BANK_RAM_DSM_IRRITATOR_DATA_MASK                                                  0x03000000L
#define SQC_DSM_CNTLB__DATA_BANK_RAM_ENABLE_SINGLE_WRITE_MASK                                                 0x04000000L
//SQC_DSM_CNTL2
#define SQC_DSM_CNTL2__INST_UTCL1_LFIFO_ENABLE_ERROR_INJECT__SHIFT                                            0x0
#define SQC_DSM_CNTL2__INST_UTCL1_LFIFO_SELECT_INJECT_DELAY__SHIFT                                            0x2
#define SQC_DSM_CNTL2__DATA_CU0_WRITE_DATA_BUF_ENABLE_ERROR_INJECT__SHIFT                                     0x3
#define SQC_DSM_CNTL2__DATA_CU0_WRITE_DATA_BUF_SELECT_INJECT_DELAY__SHIFT                                     0x5
#define SQC_DSM_CNTL2__DATA_CU0_UTCL1_LFIFO_ENABLE_ERROR_INJECT__SHIFT                                        0x6
#define SQC_DSM_CNTL2__DATA_CU0_UTCL1_LFIFO_SELECT_INJECT_DELAY__SHIFT                                        0x8
#define SQC_DSM_CNTL2__DATA_CU1_WRITE_DATA_BUF_ENABLE_ERROR_INJECT__SHIFT                                     0x9
#define SQC_DSM_CNTL2__DATA_CU1_WRITE_DATA_BUF_SELECT_INJECT_DELAY__SHIFT                                     0xb
#define SQC_DSM_CNTL2__DATA_CU1_UTCL1_LFIFO_ENABLE_ERROR_INJECT__SHIFT                                        0xc
#define SQC_DSM_CNTL2__DATA_CU1_UTCL1_LFIFO_SELECT_INJECT_DELAY__SHIFT                                        0xe
#define SQC_DSM_CNTL2__DATA_CU2_WRITE_DATA_BUF_ENABLE_ERROR_INJECT__SHIFT                                     0xf
#define SQC_DSM_CNTL2__DATA_CU2_WRITE_DATA_BUF_SELECT_INJECT_DELAY__SHIFT                                     0x11
#define SQC_DSM_CNTL2__DATA_CU2_UTCL1_LFIFO_ENABLE_ERROR_INJECT__SHIFT                                        0x12
#define SQC_DSM_CNTL2__DATA_CU2_UTCL1_LFIFO_SELECT_INJECT_DELAY__SHIFT                                        0x14
#define SQC_DSM_CNTL2__INJECT_DELAY__SHIFT                                                                    0x1a
#define SQC_DSM_CNTL2__INST_UTCL1_LFIFO_ENABLE_ERROR_INJECT_MASK                                              0x00000003L
#define SQC_DSM_CNTL2__INST_UTCL1_LFIFO_SELECT_INJECT_DELAY_MASK                                              0x00000004L
#define SQC_DSM_CNTL2__DATA_CU0_WRITE_DATA_BUF_ENABLE_ERROR_INJECT_MASK                                       0x00000018L
#define SQC_DSM_CNTL2__DATA_CU0_WRITE_DATA_BUF_SELECT_INJECT_DELAY_MASK                                       0x00000020L
#define SQC_DSM_CNTL2__DATA_CU0_UTCL1_LFIFO_ENABLE_ERROR_INJECT_MASK                                          0x000000C0L
#define SQC_DSM_CNTL2__DATA_CU0_UTCL1_LFIFO_SELECT_INJECT_DELAY_MASK                                          0x00000100L
#define SQC_DSM_CNTL2__DATA_CU1_WRITE_DATA_BUF_ENABLE_ERROR_INJECT_MASK                                       0x00000600L
#define SQC_DSM_CNTL2__DATA_CU1_WRITE_DATA_BUF_SELECT_INJECT_DELAY_MASK                                       0x00000800L
#define SQC_DSM_CNTL2__DATA_CU1_UTCL1_LFIFO_ENABLE_ERROR_INJECT_MASK                                          0x00003000L
#define SQC_DSM_CNTL2__DATA_CU1_UTCL1_LFIFO_SELECT_INJECT_DELAY_MASK                                          0x00004000L
#define SQC_DSM_CNTL2__DATA_CU2_WRITE_DATA_BUF_ENABLE_ERROR_INJECT_MASK                                       0x00018000L
#define SQC_DSM_CNTL2__DATA_CU2_WRITE_DATA_BUF_SELECT_INJECT_DELAY_MASK                                       0x00020000L
#define SQC_DSM_CNTL2__DATA_CU2_UTCL1_LFIFO_ENABLE_ERROR_INJECT_MASK                                          0x000C0000L
#define SQC_DSM_CNTL2__DATA_CU2_UTCL1_LFIFO_SELECT_INJECT_DELAY_MASK                                          0x00100000L
#define SQC_DSM_CNTL2__INJECT_DELAY_MASK                                                                      0xFC000000L
//SQC_DSM_CNTL2A
#define SQC_DSM_CNTL2A__INST_TAG_RAM_ENABLE_ERROR_INJECT__SHIFT                                               0x0
#define SQC_DSM_CNTL2A__INST_TAG_RAM_SELECT_INJECT_DELAY__SHIFT                                               0x2
#define SQC_DSM_CNTL2A__INST_UTCL1_MISS_FIFO_ENABLE_ERROR_INJECT__SHIFT                                       0x3
#define SQC_DSM_CNTL2A__INST_UTCL1_MISS_FIFO_SELECT_INJECT_DELAY__SHIFT                                       0x5
#define SQC_DSM_CNTL2A__INST_MISS_FIFO_ENABLE_ERROR_INJECT__SHIFT                                             0x6
#define SQC_DSM_CNTL2A__INST_MISS_FIFO_SELECT_INJECT_DELAY__SHIFT                                             0x8
#define SQC_DSM_CNTL2A__INST_BANK_RAM_ENABLE_ERROR_INJECT__SHIFT                                              0x9
#define SQC_DSM_CNTL2A__INST_BANK_RAM_SELECT_INJECT_DELAY__SHIFT                                              0xb
#define SQC_DSM_CNTL2A__DATA_TAG_RAM_ENABLE_ERROR_INJECT__SHIFT                                               0xc
#define SQC_DSM_CNTL2A__DATA_TAG_RAM_SELECT_INJECT_DELAY__SHIFT                                               0xe
#define SQC_DSM_CNTL2A__DATA_HIT_FIFO_ENABLE_ERROR_INJECT__SHIFT                                              0xf
#define SQC_DSM_CNTL2A__DATA_HIT_FIFO_SELECT_INJECT_DELAY__SHIFT                                              0x11
#define SQC_DSM_CNTL2A__DATA_MISS_FIFO_ENABLE_ERROR_INJECT__SHIFT                                             0x12
#define SQC_DSM_CNTL2A__DATA_MISS_FIFO_SELECT_INJECT_DELAY__SHIFT                                             0x14
#define SQC_DSM_CNTL2A__DATA_DIRTY_BIT_RAM_ENABLE_ERROR_INJECT__SHIFT                                         0x15
#define SQC_DSM_CNTL2A__DATA_DIRTY_BIT_RAM_SELECT_INJECT_DELAY__SHIFT                                         0x17
#define SQC_DSM_CNTL2A__DATA_BANK_RAM_ENABLE_ERROR_INJECT__SHIFT                                              0x18
#define SQC_DSM_CNTL2A__DATA_BANK_RAM_SELECT_INJECT_DELAY__SHIFT                                              0x1a
#define SQC_DSM_CNTL2A__INST_TAG_RAM_ENABLE_ERROR_INJECT_MASK                                                 0x00000003L
#define SQC_DSM_CNTL2A__INST_TAG_RAM_SELECT_INJECT_DELAY_MASK                                                 0x00000004L
#define SQC_DSM_CNTL2A__INST_UTCL1_MISS_FIFO_ENABLE_ERROR_INJECT_MASK                                         0x00000018L
#define SQC_DSM_CNTL2A__INST_UTCL1_MISS_FIFO_SELECT_INJECT_DELAY_MASK                                         0x00000020L
#define SQC_DSM_CNTL2A__INST_MISS_FIFO_ENABLE_ERROR_INJECT_MASK                                               0x000000C0L
#define SQC_DSM_CNTL2A__INST_MISS_FIFO_SELECT_INJECT_DELAY_MASK                                               0x00000100L
#define SQC_DSM_CNTL2A__INST_BANK_RAM_ENABLE_ERROR_INJECT_MASK                                                0x00000600L
#define SQC_DSM_CNTL2A__INST_BANK_RAM_SELECT_INJECT_DELAY_MASK                                                0x00000800L
#define SQC_DSM_CNTL2A__DATA_TAG_RAM_ENABLE_ERROR_INJECT_MASK                                                 0x00003000L
#define SQC_DSM_CNTL2A__DATA_TAG_RAM_SELECT_INJECT_DELAY_MASK                                                 0x00004000L
#define SQC_DSM_CNTL2A__DATA_HIT_FIFO_ENABLE_ERROR_INJECT_MASK                                                0x00018000L
#define SQC_DSM_CNTL2A__DATA_HIT_FIFO_SELECT_INJECT_DELAY_MASK                                                0x00020000L
#define SQC_DSM_CNTL2A__DATA_MISS_FIFO_ENABLE_ERROR_INJECT_MASK                                               0x000C0000L
#define SQC_DSM_CNTL2A__DATA_MISS_FIFO_SELECT_INJECT_DELAY_MASK                                               0x00100000L
#define SQC_DSM_CNTL2A__DATA_DIRTY_BIT_RAM_ENABLE_ERROR_INJECT_MASK                                           0x00600000L
#define SQC_DSM_CNTL2A__DATA_DIRTY_BIT_RAM_SELECT_INJECT_DELAY_MASK                                           0x00800000L
#define SQC_DSM_CNTL2A__DATA_BANK_RAM_ENABLE_ERROR_INJECT_MASK                                                0x03000000L
#define SQC_DSM_CNTL2A__DATA_BANK_RAM_SELECT_INJECT_DELAY_MASK                                                0x04000000L
//SQC_DSM_CNTL2B
#define SQC_DSM_CNTL2B__INST_TAG_RAM_ENABLE_ERROR_INJECT__SHIFT                                               0x0
#define SQC_DSM_CNTL2B__INST_TAG_RAM_SELECT_INJECT_DELAY__SHIFT                                               0x2
#define SQC_DSM_CNTL2B__INST_UTCL1_MISS_FIFO_ENABLE_ERROR_INJECT__SHIFT                                       0x3
#define SQC_DSM_CNTL2B__INST_UTCL1_MISS_FIFO_SELECT_INJECT_DELAY__SHIFT                                       0x5
#define SQC_DSM_CNTL2B__INST_MISS_FIFO_ENABLE_ERROR_INJECT__SHIFT                                             0x6
#define SQC_DSM_CNTL2B__INST_MISS_FIFO_SELECT_INJECT_DELAY__SHIFT                                             0x8
#define SQC_DSM_CNTL2B__INST_BANK_RAM_ENABLE_ERROR_INJECT__SHIFT                                              0x9
#define SQC_DSM_CNTL2B__INST_BANK_RAM_SELECT_INJECT_DELAY__SHIFT                                              0xb
#define SQC_DSM_CNTL2B__DATA_TAG_RAM_ENABLE_ERROR_INJECT__SHIFT                                               0xc
#define SQC_DSM_CNTL2B__DATA_TAG_RAM_SELECT_INJECT_DELAY__SHIFT                                               0xe
#define SQC_DSM_CNTL2B__DATA_HIT_FIFO_ENABLE_ERROR_INJECT__SHIFT                                              0xf
#define SQC_DSM_CNTL2B__DATA_HIT_FIFO_SELECT_INJECT_DELAY__SHIFT                                              0x11
#define SQC_DSM_CNTL2B__DATA_MISS_FIFO_ENABLE_ERROR_INJECT__SHIFT                                             0x12
#define SQC_DSM_CNTL2B__DATA_MISS_FIFO_SELECT_INJECT_DELAY__SHIFT                                             0x14
#define SQC_DSM_CNTL2B__DATA_DIRTY_BIT_RAM_ENABLE_ERROR_INJECT__SHIFT                                         0x15
#define SQC_DSM_CNTL2B__DATA_DIRTY_BIT_RAM_SELECT_INJECT_DELAY__SHIFT                                         0x17
#define SQC_DSM_CNTL2B__DATA_BANK_RAM_ENABLE_ERROR_INJECT__SHIFT                                              0x18
#define SQC_DSM_CNTL2B__DATA_BANK_RAM_SELECT_INJECT_DELAY__SHIFT                                              0x1a
#define SQC_DSM_CNTL2B__INST_TAG_RAM_ENABLE_ERROR_INJECT_MASK                                                 0x00000003L
#define SQC_DSM_CNTL2B__INST_TAG_RAM_SELECT_INJECT_DELAY_MASK                                                 0x00000004L
#define SQC_DSM_CNTL2B__INST_UTCL1_MISS_FIFO_ENABLE_ERROR_INJECT_MASK                                         0x00000018L
#define SQC_DSM_CNTL2B__INST_UTCL1_MISS_FIFO_SELECT_INJECT_DELAY_MASK                                         0x00000020L
#define SQC_DSM_CNTL2B__INST_MISS_FIFO_ENABLE_ERROR_INJECT_MASK                                               0x000000C0L
#define SQC_DSM_CNTL2B__INST_MISS_FIFO_SELECT_INJECT_DELAY_MASK                                               0x00000100L
#define SQC_DSM_CNTL2B__INST_BANK_RAM_ENABLE_ERROR_INJECT_MASK                                                0x00000600L
#define SQC_DSM_CNTL2B__INST_BANK_RAM_SELECT_INJECT_DELAY_MASK                                                0x00000800L
#define SQC_DSM_CNTL2B__DATA_TAG_RAM_ENABLE_ERROR_INJECT_MASK                                                 0x00003000L
#define SQC_DSM_CNTL2B__DATA_TAG_RAM_SELECT_INJECT_DELAY_MASK                                                 0x00004000L
#define SQC_DSM_CNTL2B__DATA_HIT_FIFO_ENABLE_ERROR_INJECT_MASK                                                0x00018000L
#define SQC_DSM_CNTL2B__DATA_HIT_FIFO_SELECT_INJECT_DELAY_MASK                                                0x00020000L
#define SQC_DSM_CNTL2B__DATA_MISS_FIFO_ENABLE_ERROR_INJECT_MASK                                               0x000C0000L
#define SQC_DSM_CNTL2B__DATA_MISS_FIFO_SELECT_INJECT_DELAY_MASK                                               0x00100000L
#define SQC_DSM_CNTL2B__DATA_DIRTY_BIT_RAM_ENABLE_ERROR_INJECT_MASK                                           0x00600000L
#define SQC_DSM_CNTL2B__DATA_DIRTY_BIT_RAM_SELECT_INJECT_DELAY_MASK                                           0x00800000L
#define SQC_DSM_CNTL2B__DATA_BANK_RAM_ENABLE_ERROR_INJECT_MASK                                                0x03000000L
#define SQC_DSM_CNTL2B__DATA_BANK_RAM_SELECT_INJECT_DELAY_MASK                                                0x04000000L
//SQC_EDC_FUE_CNTL
#define SQC_EDC_FUE_CNTL__BLOCK_FUE_FLAGS__SHIFT                                                              0x0
#define SQC_EDC_FUE_CNTL__FUE_INTERRUPT_ENABLES__SHIFT                                                        0x10
#define SQC_EDC_FUE_CNTL__BLOCK_FUE_FLAGS_MASK                                                                0x0000FFFFL
#define SQC_EDC_FUE_CNTL__FUE_INTERRUPT_ENABLES_MASK                                                          0xFFFF0000L
//SQC_EDC_CNT2
#define SQC_EDC_CNT2__INST_BANKA_TAG_RAM_SEC_COUNT__SHIFT                                                     0x0
#define SQC_EDC_CNT2__INST_BANKA_TAG_RAM_DED_COUNT__SHIFT                                                     0x2
#define SQC_EDC_CNT2__INST_BANKA_BANK_RAM_SEC_COUNT__SHIFT                                                    0x4
#define SQC_EDC_CNT2__INST_BANKA_BANK_RAM_DED_COUNT__SHIFT                                                    0x6
#define SQC_EDC_CNT2__DATA_BANKA_TAG_RAM_SEC_COUNT__SHIFT                                                     0x8
#define SQC_EDC_CNT2__DATA_BANKA_TAG_RAM_DED_COUNT__SHIFT                                                     0xa
#define SQC_EDC_CNT2__DATA_BANKA_BANK_RAM_SEC_COUNT__SHIFT                                                    0xc
#define SQC_EDC_CNT2__DATA_BANKA_BANK_RAM_DED_COUNT__SHIFT                                                    0xe
#define SQC_EDC_CNT2__INST_BANKA_UTCL1_MISS_FIFO_SED_COUNT__SHIFT                                             0x10
#define SQC_EDC_CNT2__INST_BANKA_MISS_FIFO_SED_COUNT__SHIFT                                                   0x12
#define SQC_EDC_CNT2__DATA_BANKA_HIT_FIFO_SED_COUNT__SHIFT                                                    0x14
#define SQC_EDC_CNT2__DATA_BANKA_MISS_FIFO_SED_COUNT__SHIFT                                                   0x16
#define SQC_EDC_CNT2__DATA_BANKA_DIRTY_BIT_RAM_SED_COUNT__SHIFT                                               0x18
#define SQC_EDC_CNT2__INST_UTCL1_LFIFO_SEC_COUNT__SHIFT                                                       0x1a
#define SQC_EDC_CNT2__INST_UTCL1_LFIFO_DED_COUNT__SHIFT                                                       0x1c
#define SQC_EDC_CNT2__INST_BANKA_TAG_RAM_SEC_COUNT_MASK                                                       0x00000003L
#define SQC_EDC_CNT2__INST_BANKA_TAG_RAM_DED_COUNT_MASK                                                       0x0000000CL
#define SQC_EDC_CNT2__INST_BANKA_BANK_RAM_SEC_COUNT_MASK                                                      0x00000030L
#define SQC_EDC_CNT2__INST_BANKA_BANK_RAM_DED_COUNT_MASK                                                      0x000000C0L
#define SQC_EDC_CNT2__DATA_BANKA_TAG_RAM_SEC_COUNT_MASK                                                       0x00000300L
#define SQC_EDC_CNT2__DATA_BANKA_TAG_RAM_DED_COUNT_MASK                                                       0x00000C00L
#define SQC_EDC_CNT2__DATA_BANKA_BANK_RAM_SEC_COUNT_MASK                                                      0x00003000L
#define SQC_EDC_CNT2__DATA_BANKA_BANK_RAM_DED_COUNT_MASK                                                      0x0000C000L
#define SQC_EDC_CNT2__INST_BANKA_UTCL1_MISS_FIFO_SED_COUNT_MASK                                               0x00030000L
#define SQC_EDC_CNT2__INST_BANKA_MISS_FIFO_SED_COUNT_MASK                                                     0x000C0000L
#define SQC_EDC_CNT2__DATA_BANKA_HIT_FIFO_SED_COUNT_MASK                                                      0x00300000L
#define SQC_EDC_CNT2__DATA_BANKA_MISS_FIFO_SED_COUNT_MASK                                                     0x00C00000L
#define SQC_EDC_CNT2__DATA_BANKA_DIRTY_BIT_RAM_SED_COUNT_MASK                                                 0x03000000L
#define SQC_EDC_CNT2__INST_UTCL1_LFIFO_SEC_COUNT_MASK                                                         0x0C000000L
#define SQC_EDC_CNT2__INST_UTCL1_LFIFO_DED_COUNT_MASK                                                         0x30000000L
//SQC_EDC_CNT3
#define SQC_EDC_CNT3__INST_BANKB_TAG_RAM_SEC_COUNT__SHIFT                                                     0x0
#define SQC_EDC_CNT3__INST_BANKB_TAG_RAM_DED_COUNT__SHIFT                                                     0x2
#define SQC_EDC_CNT3__INST_BANKB_BANK_RAM_SEC_COUNT__SHIFT                                                    0x4
#define SQC_EDC_CNT3__INST_BANKB_BANK_RAM_DED_COUNT__SHIFT                                                    0x6
#define SQC_EDC_CNT3__DATA_BANKB_TAG_RAM_SEC_COUNT__SHIFT                                                     0x8
#define SQC_EDC_CNT3__DATA_BANKB_TAG_RAM_DED_COUNT__SHIFT                                                     0xa
#define SQC_EDC_CNT3__DATA_BANKB_BANK_RAM_SEC_COUNT__SHIFT                                                    0xc
#define SQC_EDC_CNT3__DATA_BANKB_BANK_RAM_DED_COUNT__SHIFT                                                    0xe
#define SQC_EDC_CNT3__INST_BANKB_UTCL1_MISS_FIFO_SED_COUNT__SHIFT                                             0x10
#define SQC_EDC_CNT3__INST_BANKB_MISS_FIFO_SED_COUNT__SHIFT                                                   0x12
#define SQC_EDC_CNT3__DATA_BANKB_HIT_FIFO_SED_COUNT__SHIFT                                                    0x14
#define SQC_EDC_CNT3__DATA_BANKB_MISS_FIFO_SED_COUNT__SHIFT                                                   0x16
#define SQC_EDC_CNT3__DATA_BANKB_DIRTY_BIT_RAM_SED_COUNT__SHIFT                                               0x18
#define SQC_EDC_CNT3__INST_BANKB_TAG_RAM_SEC_COUNT_MASK                                                       0x00000003L
#define SQC_EDC_CNT3__INST_BANKB_TAG_RAM_DED_COUNT_MASK                                                       0x0000000CL
#define SQC_EDC_CNT3__INST_BANKB_BANK_RAM_SEC_COUNT_MASK                                                      0x00000030L
#define SQC_EDC_CNT3__INST_BANKB_BANK_RAM_DED_COUNT_MASK                                                      0x000000C0L
#define SQC_EDC_CNT3__DATA_BANKB_TAG_RAM_SEC_COUNT_MASK                                                       0x00000300L
#define SQC_EDC_CNT3__DATA_BANKB_TAG_RAM_DED_COUNT_MASK                                                       0x00000C00L
#define SQC_EDC_CNT3__DATA_BANKB_BANK_RAM_SEC_COUNT_MASK                                                      0x00003000L
#define SQC_EDC_CNT3__DATA_BANKB_BANK_RAM_DED_COUNT_MASK                                                      0x0000C000L
#define SQC_EDC_CNT3__INST_BANKB_UTCL1_MISS_FIFO_SED_COUNT_MASK                                               0x00030000L
#define SQC_EDC_CNT3__INST_BANKB_MISS_FIFO_SED_COUNT_MASK                                                     0x000C0000L
#define SQC_EDC_CNT3__DATA_BANKB_HIT_FIFO_SED_COUNT_MASK                                                      0x00300000L
#define SQC_EDC_CNT3__DATA_BANKB_MISS_FIFO_SED_COUNT_MASK                                                     0x00C00000L
#define SQC_EDC_CNT3__DATA_BANKB_DIRTY_BIT_RAM_SED_COUNT_MASK                                                 0x03000000L
//SQ_REG_TIMESTAMP
#define SQ_REG_TIMESTAMP__TIMESTAMP__SHIFT                                                                    0x0
#define SQ_REG_TIMESTAMP__TIMESTAMP_MASK                                                                      0x000000FFL
//SQ_CMD_TIMESTAMP
#define SQ_CMD_TIMESTAMP__TIMESTAMP__SHIFT                                                                    0x0
#define SQ_CMD_TIMESTAMP__TIMESTAMP_MASK                                                                      0x000000FFL
//SQ_IND_INDEX
#define SQ_IND_INDEX__WAVE_ID__SHIFT                                                                          0x0
#define SQ_IND_INDEX__SIMD_ID__SHIFT                                                                          0x4
#define SQ_IND_INDEX__THREAD_ID__SHIFT                                                                        0x6
#define SQ_IND_INDEX__AUTO_INCR__SHIFT                                                                        0xc
#define SQ_IND_INDEX__FORCE_READ__SHIFT                                                                       0xd
#define SQ_IND_INDEX__READ_TIMEOUT__SHIFT                                                                     0xe
#define SQ_IND_INDEX__UNINDEXED__SHIFT                                                                        0xf
#define SQ_IND_INDEX__INDEX__SHIFT                                                                            0x10
#define SQ_IND_INDEX__WAVE_ID_MASK                                                                            0x0000000FL
#define SQ_IND_INDEX__SIMD_ID_MASK                                                                            0x00000030L
#define SQ_IND_INDEX__THREAD_ID_MASK                                                                          0x00000FC0L
#define SQ_IND_INDEX__AUTO_INCR_MASK                                                                          0x00001000L
#define SQ_IND_INDEX__FORCE_READ_MASK                                                                         0x00002000L
#define SQ_IND_INDEX__READ_TIMEOUT_MASK                                                                       0x00004000L
#define SQ_IND_INDEX__UNINDEXED_MASK                                                                          0x00008000L
#define SQ_IND_INDEX__INDEX_MASK                                                                              0xFFFF0000L
//SQ_IND_DATA
#define SQ_IND_DATA__DATA__SHIFT                                                                              0x0
#define SQ_IND_DATA__DATA_MASK                                                                                0xFFFFFFFFL
//SQ_CMD
#define SQ_CMD__CMD__SHIFT                                                                                    0x0
#define SQ_CMD__MODE__SHIFT                                                                                   0x4
#define SQ_CMD__CHECK_VMID__SHIFT                                                                             0x7
#define SQ_CMD__DATA__SHIFT                                                                                   0x8
#define SQ_CMD__WAVE_ID__SHIFT                                                                                0x10
#define SQ_CMD__SIMD_ID__SHIFT                                                                                0x14
#define SQ_CMD__QUEUE_ID__SHIFT                                                                               0x18
#define SQ_CMD__VM_ID__SHIFT                                                                                  0x1c
#define SQ_CMD__CMD_MASK                                                                                      0x00000007L
#define SQ_CMD__MODE_MASK                                                                                     0x00000070L
#define SQ_CMD__CHECK_VMID_MASK                                                                               0x00000080L
#define SQ_CMD__DATA_MASK                                                                                     0x00000F00L
#define SQ_CMD__WAVE_ID_MASK                                                                                  0x000F0000L
#define SQ_CMD__SIMD_ID_MASK                                                                                  0x00300000L
#define SQ_CMD__QUEUE_ID_MASK                                                                                 0x07000000L
#define SQ_CMD__VM_ID_MASK                                                                                    0xF0000000L
//SQ_TIME_HI
#define SQ_TIME_HI__TIME__SHIFT                                                                               0x0
#define SQ_TIME_HI__TIME_MASK                                                                                 0xFFFFFFFFL
//SQ_TIME_LO
#define SQ_TIME_LO__TIME__SHIFT                                                                               0x0
#define SQ_TIME_LO__TIME_MASK                                                                                 0xFFFFFFFFL
//SQ_DS_0
#define SQ_DS_0__OFFSET0__SHIFT                                                                               0x0
#define SQ_DS_0__OFFSET1__SHIFT                                                                               0x8
#define SQ_DS_0__GDS__SHIFT                                                                                   0x10
#define SQ_DS_0__OP__SHIFT                                                                                    0x11
#define SQ_DS_0__ENCODING__SHIFT                                                                              0x1a
#define SQ_DS_0__OFFSET0_MASK                                                                                 0x000000FFL
#define SQ_DS_0__OFFSET1_MASK                                                                                 0x0000FF00L
#define SQ_DS_0__GDS_MASK                                                                                     0x00010000L
#define SQ_DS_0__OP_MASK                                                                                      0x01FE0000L
#define SQ_DS_0__ENCODING_MASK                                                                                0xFC000000L
//SQ_DS_1
#define SQ_DS_1__ADDR__SHIFT                                                                                  0x0
#define SQ_DS_1__DATA0__SHIFT                                                                                 0x8
#define SQ_DS_1__DATA1__SHIFT                                                                                 0x10
#define SQ_DS_1__VDST__SHIFT                                                                                  0x18
#define SQ_DS_1__ADDR_MASK                                                                                    0x000000FFL
#define SQ_DS_1__DATA0_MASK                                                                                   0x0000FF00L
#define SQ_DS_1__DATA1_MASK                                                                                   0x00FF0000L
#define SQ_DS_1__VDST_MASK                                                                                    0xFF000000L
//SQ_EXP_0
#define SQ_EXP_0__EN__SHIFT                                                                                   0x0
#define SQ_EXP_0__TGT__SHIFT                                                                                  0x4
#define SQ_EXP_0__COMPR__SHIFT                                                                                0xa
#define SQ_EXP_0__DONE__SHIFT                                                                                 0xb
#define SQ_EXP_0__VM__SHIFT                                                                                   0xc
#define SQ_EXP_0__ENCODING__SHIFT                                                                             0x1a
#define SQ_EXP_0__EN_MASK                                                                                     0x0000000FL
#define SQ_EXP_0__TGT_MASK                                                                                    0x000003F0L
#define SQ_EXP_0__COMPR_MASK                                                                                  0x00000400L
#define SQ_EXP_0__DONE_MASK                                                                                   0x00000800L
#define SQ_EXP_0__VM_MASK                                                                                     0x00001000L
#define SQ_EXP_0__ENCODING_MASK                                                                               0xFC000000L
//SQ_EXP_1
#define SQ_EXP_1__VSRC0__SHIFT                                                                                0x0
#define SQ_EXP_1__VSRC1__SHIFT                                                                                0x8
#define SQ_EXP_1__VSRC2__SHIFT                                                                                0x10
#define SQ_EXP_1__VSRC3__SHIFT                                                                                0x18
#define SQ_EXP_1__VSRC0_MASK                                                                                  0x000000FFL
#define SQ_EXP_1__VSRC1_MASK                                                                                  0x0000FF00L
#define SQ_EXP_1__VSRC2_MASK                                                                                  0x00FF0000L
#define SQ_EXP_1__VSRC3_MASK                                                                                  0xFF000000L
//SQ_FLAT_0
#define SQ_FLAT_0__OFFSET__SHIFT                                                                              0x0
#define SQ_FLAT_0__LDS__SHIFT                                                                                 0xd
#define SQ_FLAT_0__SEG__SHIFT                                                                                 0xe
#define SQ_FLAT_0__GLC__SHIFT                                                                                 0x10
#define SQ_FLAT_0__SLC__SHIFT                                                                                 0x11
#define SQ_FLAT_0__OP__SHIFT                                                                                  0x12
#define SQ_FLAT_0__ENCODING__SHIFT                                                                            0x1a
#define SQ_FLAT_0__OFFSET_MASK                                                                                0x00000FFFL
#define SQ_FLAT_0__LDS_MASK                                                                                   0x00002000L
#define SQ_FLAT_0__SEG_MASK                                                                                   0x0000C000L
#define SQ_FLAT_0__GLC_MASK                                                                                   0x00010000L
#define SQ_FLAT_0__SLC_MASK                                                                                   0x00020000L
#define SQ_FLAT_0__OP_MASK                                                                                    0x01FC0000L
#define SQ_FLAT_0__ENCODING_MASK                                                                              0xFC000000L
//SQ_FLAT_1
#define SQ_FLAT_1__ADDR__SHIFT                                                                                0x0
#define SQ_FLAT_1__DATA__SHIFT                                                                                0x8
#define SQ_FLAT_1__SADDR__SHIFT                                                                               0x10
#define SQ_FLAT_1__NV__SHIFT                                                                                  0x17
#define SQ_FLAT_1__VDST__SHIFT                                                                                0x18
#define SQ_FLAT_1__ADDR_MASK                                                                                  0x000000FFL
#define SQ_FLAT_1__DATA_MASK                                                                                  0x0000FF00L
#define SQ_FLAT_1__SADDR_MASK                                                                                 0x007F0000L
#define SQ_FLAT_1__NV_MASK                                                                                    0x00800000L
#define SQ_FLAT_1__VDST_MASK                                                                                  0xFF000000L
//SQ_GLBL_0
#define SQ_GLBL_0__OFFSET__SHIFT                                                                              0x0
#define SQ_GLBL_0__LDS__SHIFT                                                                                 0xd
#define SQ_GLBL_0__SEG__SHIFT                                                                                 0xe
#define SQ_GLBL_0__GLC__SHIFT                                                                                 0x10
#define SQ_GLBL_0__SLC__SHIFT                                                                                 0x11
#define SQ_GLBL_0__OP__SHIFT                                                                                  0x12
#define SQ_GLBL_0__ENCODING__SHIFT                                                                            0x1a
#define SQ_GLBL_0__OFFSET_MASK                                                                                0x00001FFFL
#define SQ_GLBL_0__LDS_MASK                                                                                   0x00002000L
#define SQ_GLBL_0__SEG_MASK                                                                                   0x0000C000L
#define SQ_GLBL_0__GLC_MASK                                                                                   0x00010000L
#define SQ_GLBL_0__SLC_MASK                                                                                   0x00020000L
#define SQ_GLBL_0__OP_MASK                                                                                    0x01FC0000L
#define SQ_GLBL_0__ENCODING_MASK                                                                              0xFC000000L
//SQ_GLBL_1
#define SQ_GLBL_1__ADDR__SHIFT                                                                                0x0
#define SQ_GLBL_1__DATA__SHIFT                                                                                0x8
#define SQ_GLBL_1__SADDR__SHIFT                                                                               0x10
#define SQ_GLBL_1__NV__SHIFT                                                                                  0x17
#define SQ_GLBL_1__VDST__SHIFT                                                                                0x18
#define SQ_GLBL_1__ADDR_MASK                                                                                  0x000000FFL
#define SQ_GLBL_1__DATA_MASK                                                                                  0x0000FF00L
#define SQ_GLBL_1__SADDR_MASK                                                                                 0x007F0000L
#define SQ_GLBL_1__NV_MASK                                                                                    0x00800000L
#define SQ_GLBL_1__VDST_MASK                                                                                  0xFF000000L
//SQ_INST
#define SQ_INST__ENCODING__SHIFT                                                                              0x0
#define SQ_INST__ENCODING_MASK                                                                                0xFFFFFFFFL
//SQ_MIMG_0
#define SQ_MIMG_0__OPM__SHIFT                                                                                 0x0
#define SQ_MIMG_0__DMASK__SHIFT                                                                               0x8
#define SQ_MIMG_0__UNORM__SHIFT                                                                               0xc
#define SQ_MIMG_0__GLC__SHIFT                                                                                 0xd
#define SQ_MIMG_0__DA__SHIFT                                                                                  0xe
#define SQ_MIMG_0__A16__SHIFT                                                                                 0xf
#define SQ_MIMG_0__TFE__SHIFT                                                                                 0x10
#define SQ_MIMG_0__LWE__SHIFT                                                                                 0x11
#define SQ_MIMG_0__OP__SHIFT                                                                                  0x12
#define SQ_MIMG_0__SLC__SHIFT                                                                                 0x19
#define SQ_MIMG_0__ENCODING__SHIFT                                                                            0x1a
#define SQ_MIMG_0__OPM_MASK                                                                                   0x00000001L
#define SQ_MIMG_0__DMASK_MASK                                                                                 0x00000F00L
#define SQ_MIMG_0__UNORM_MASK                                                                                 0x00001000L
#define SQ_MIMG_0__GLC_MASK                                                                                   0x00002000L
#define SQ_MIMG_0__DA_MASK                                                                                    0x00004000L
#define SQ_MIMG_0__A16_MASK                                                                                   0x00008000L
#define SQ_MIMG_0__TFE_MASK                                                                                   0x00010000L
#define SQ_MIMG_0__LWE_MASK                                                                                   0x00020000L
#define SQ_MIMG_0__OP_MASK                                                                                    0x01FC0000L
#define SQ_MIMG_0__SLC_MASK                                                                                   0x02000000L
#define SQ_MIMG_0__ENCODING_MASK                                                                              0xFC000000L
//SQ_MIMG_1
#define SQ_MIMG_1__VADDR__SHIFT                                                                               0x0
#define SQ_MIMG_1__VDATA__SHIFT                                                                               0x8
#define SQ_MIMG_1__SRSRC__SHIFT                                                                               0x10
#define SQ_MIMG_1__SSAMP__SHIFT                                                                               0x15
#define SQ_MIMG_1__D16__SHIFT                                                                                 0x1f
#define SQ_MIMG_1__VADDR_MASK                                                                                 0x000000FFL
#define SQ_MIMG_1__VDATA_MASK                                                                                 0x0000FF00L
#define SQ_MIMG_1__SRSRC_MASK                                                                                 0x001F0000L
#define SQ_MIMG_1__SSAMP_MASK                                                                                 0x03E00000L
#define SQ_MIMG_1__D16_MASK                                                                                   0x80000000L
//SQ_MTBUF_0
#define SQ_MTBUF_0__OFFSET__SHIFT                                                                             0x0
#define SQ_MTBUF_0__OFFEN__SHIFT                                                                              0xc
#define SQ_MTBUF_0__IDXEN__SHIFT                                                                              0xd
#define SQ_MTBUF_0__GLC__SHIFT                                                                                0xe
#define SQ_MTBUF_0__OP__SHIFT                                                                                 0xf
#define SQ_MTBUF_0__DFMT__SHIFT                                                                               0x13
#define SQ_MTBUF_0__NFMT__SHIFT                                                                               0x17
#define SQ_MTBUF_0__ENCODING__SHIFT                                                                           0x1a
#define SQ_MTBUF_0__OFFSET_MASK                                                                               0x00000FFFL
#define SQ_MTBUF_0__OFFEN_MASK                                                                                0x00001000L
#define SQ_MTBUF_0__IDXEN_MASK                                                                                0x00002000L
#define SQ_MTBUF_0__GLC_MASK                                                                                  0x00004000L
#define SQ_MTBUF_0__OP_MASK                                                                                   0x00078000L
#define SQ_MTBUF_0__DFMT_MASK                                                                                 0x00780000L
#define SQ_MTBUF_0__NFMT_MASK                                                                                 0x03800000L
#define SQ_MTBUF_0__ENCODING_MASK                                                                             0xFC000000L
//SQ_MTBUF_1
#define SQ_MTBUF_1__VADDR__SHIFT                                                                              0x0
#define SQ_MTBUF_1__VDATA__SHIFT                                                                              0x8
#define SQ_MTBUF_1__SRSRC__SHIFT                                                                              0x10
#define SQ_MTBUF_1__SLC__SHIFT                                                                                0x16
#define SQ_MTBUF_1__TFE__SHIFT                                                                                0x17
#define SQ_MTBUF_1__SOFFSET__SHIFT                                                                            0x18
#define SQ_MTBUF_1__VADDR_MASK                                                                                0x000000FFL
#define SQ_MTBUF_1__VDATA_MASK                                                                                0x0000FF00L
#define SQ_MTBUF_1__SRSRC_MASK                                                                                0x001F0000L
#define SQ_MTBUF_1__SLC_MASK                                                                                  0x00400000L
#define SQ_MTBUF_1__TFE_MASK                                                                                  0x00800000L
#define SQ_MTBUF_1__SOFFSET_MASK                                                                              0xFF000000L
//SQ_MUBUF_0
#define SQ_MUBUF_0__OFFSET__SHIFT                                                                             0x0
#define SQ_MUBUF_0__OFFEN__SHIFT                                                                              0xc
#define SQ_MUBUF_0__IDXEN__SHIFT                                                                              0xd
#define SQ_MUBUF_0__GLC__SHIFT                                                                                0xe
#define SQ_MUBUF_0__LDS__SHIFT                                                                                0x10
#define SQ_MUBUF_0__SLC__SHIFT                                                                                0x11
#define SQ_MUBUF_0__OP__SHIFT                                                                                 0x12
#define SQ_MUBUF_0__ENCODING__SHIFT                                                                           0x1a
#define SQ_MUBUF_0__OFFSET_MASK                                                                               0x00000FFFL
#define SQ_MUBUF_0__OFFEN_MASK                                                                                0x00001000L
#define SQ_MUBUF_0__IDXEN_MASK                                                                                0x00002000L
#define SQ_MUBUF_0__GLC_MASK                                                                                  0x00004000L
#define SQ_MUBUF_0__LDS_MASK                                                                                  0x00010000L
#define SQ_MUBUF_0__SLC_MASK                                                                                  0x00020000L
#define SQ_MUBUF_0__OP_MASK                                                                                   0x01FC0000L
#define SQ_MUBUF_0__ENCODING_MASK                                                                             0xFC000000L
//SQ_MUBUF_1
#define SQ_MUBUF_1__VADDR__SHIFT                                                                              0x0
#define SQ_MUBUF_1__VDATA__SHIFT                                                                              0x8
#define SQ_MUBUF_1__SRSRC__SHIFT                                                                              0x10
#define SQ_MUBUF_1__TFE__SHIFT                                                                                0x17
#define SQ_MUBUF_1__SOFFSET__SHIFT                                                                            0x18
#define SQ_MUBUF_1__VADDR_MASK                                                                                0x000000FFL
#define SQ_MUBUF_1__VDATA_MASK                                                                                0x0000FF00L
#define SQ_MUBUF_1__SRSRC_MASK                                                                                0x001F0000L
#define SQ_MUBUF_1__TFE_MASK                                                                                  0x00800000L
#define SQ_MUBUF_1__SOFFSET_MASK                                                                              0xFF000000L
//SQ_SCRATCH_0
#define SQ_SCRATCH_0__OFFSET__SHIFT                                                                           0x0
#define SQ_SCRATCH_0__LDS__SHIFT                                                                              0xd
#define SQ_SCRATCH_0__SEG__SHIFT                                                                              0xe
#define SQ_SCRATCH_0__GLC__SHIFT                                                                              0x10
#define SQ_SCRATCH_0__SLC__SHIFT                                                                              0x11
#define SQ_SCRATCH_0__OP__SHIFT                                                                               0x12
#define SQ_SCRATCH_0__ENCODING__SHIFT                                                                         0x1a
#define SQ_SCRATCH_0__OFFSET_MASK                                                                             0x00001FFFL
#define SQ_SCRATCH_0__LDS_MASK                                                                                0x00002000L
#define SQ_SCRATCH_0__SEG_MASK                                                                                0x0000C000L
#define SQ_SCRATCH_0__GLC_MASK                                                                                0x00010000L
#define SQ_SCRATCH_0__SLC_MASK                                                                                0x00020000L
#define SQ_SCRATCH_0__OP_MASK                                                                                 0x01FC0000L
#define SQ_SCRATCH_0__ENCODING_MASK                                                                           0xFC000000L
//SQ_SCRATCH_1
#define SQ_SCRATCH_1__ADDR__SHIFT                                                                             0x0
#define SQ_SCRATCH_1__DATA__SHIFT                                                                             0x8
#define SQ_SCRATCH_1__SADDR__SHIFT                                                                            0x10
#define SQ_SCRATCH_1__NV__SHIFT                                                                               0x17
#define SQ_SCRATCH_1__VDST__SHIFT                                                                             0x18
#define SQ_SCRATCH_1__ADDR_MASK                                                                               0x000000FFL
#define SQ_SCRATCH_1__DATA_MASK                                                                               0x0000FF00L
#define SQ_SCRATCH_1__SADDR_MASK                                                                              0x007F0000L
#define SQ_SCRATCH_1__NV_MASK                                                                                 0x00800000L
#define SQ_SCRATCH_1__VDST_MASK                                                                               0xFF000000L
//SQ_SMEM_0
#define SQ_SMEM_0__SBASE__SHIFT                                                                               0x0
#define SQ_SMEM_0__SDATA__SHIFT                                                                               0x6
#define SQ_SMEM_0__SOFFSET_EN__SHIFT                                                                          0xe
#define SQ_SMEM_0__NV__SHIFT                                                                                  0xf
#define SQ_SMEM_0__GLC__SHIFT                                                                                 0x10
#define SQ_SMEM_0__IMM__SHIFT                                                                                 0x11
#define SQ_SMEM_0__OP__SHIFT                                                                                  0x12
#define SQ_SMEM_0__ENCODING__SHIFT                                                                            0x1a
#define SQ_SMEM_0__SBASE_MASK                                                                                 0x0000003FL
#define SQ_SMEM_0__SDATA_MASK                                                                                 0x00001FC0L
#define SQ_SMEM_0__SOFFSET_EN_MASK                                                                            0x00004000L
#define SQ_SMEM_0__NV_MASK                                                                                    0x00008000L
#define SQ_SMEM_0__GLC_MASK                                                                                   0x00010000L
#define SQ_SMEM_0__IMM_MASK                                                                                   0x00020000L
#define SQ_SMEM_0__OP_MASK                                                                                    0x03FC0000L
#define SQ_SMEM_0__ENCODING_MASK                                                                              0xFC000000L
//SQ_SMEM_1
#define SQ_SMEM_1__OFFSET__SHIFT                                                                              0x0
#define SQ_SMEM_1__SOFFSET__SHIFT                                                                             0x19
#define SQ_SMEM_1__OFFSET_MASK                                                                                0x001FFFFFL
#define SQ_SMEM_1__SOFFSET_MASK                                                                               0xFE000000L
//SQ_SOP1
#define SQ_SOP1__SSRC0__SHIFT                                                                                 0x0
#define SQ_SOP1__OP__SHIFT                                                                                    0x8
#define SQ_SOP1__SDST__SHIFT                                                                                  0x10
#define SQ_SOP1__ENCODING__SHIFT                                                                              0x17
#define SQ_SOP1__SSRC0_MASK                                                                                   0x000000FFL
#define SQ_SOP1__OP_MASK                                                                                      0x0000FF00L
#define SQ_SOP1__SDST_MASK                                                                                    0x007F0000L
#define SQ_SOP1__ENCODING_MASK                                                                                0xFF800000L
//SQ_SOP2
#define SQ_SOP2__SSRC0__SHIFT                                                                                 0x0
#define SQ_SOP2__SSRC1__SHIFT                                                                                 0x8
#define SQ_SOP2__SDST__SHIFT                                                                                  0x10
#define SQ_SOP2__OP__SHIFT                                                                                    0x17
#define SQ_SOP2__ENCODING__SHIFT                                                                              0x1e
#define SQ_SOP2__SSRC0_MASK                                                                                   0x000000FFL
#define SQ_SOP2__SSRC1_MASK                                                                                   0x0000FF00L
#define SQ_SOP2__SDST_MASK                                                                                    0x007F0000L
#define SQ_SOP2__OP_MASK                                                                                      0x3F800000L
#define SQ_SOP2__ENCODING_MASK                                                                                0xC0000000L
//SQ_SOPC
#define SQ_SOPC__SSRC0__SHIFT                                                                                 0x0
#define SQ_SOPC__SSRC1__SHIFT                                                                                 0x8
#define SQ_SOPC__OP__SHIFT                                                                                    0x10
#define SQ_SOPC__ENCODING__SHIFT                                                                              0x17
#define SQ_SOPC__SSRC0_MASK                                                                                   0x000000FFL
#define SQ_SOPC__SSRC1_MASK                                                                                   0x0000FF00L
#define SQ_SOPC__OP_MASK                                                                                      0x007F0000L
#define SQ_SOPC__ENCODING_MASK                                                                                0xFF800000L
//SQ_SOPK
#define SQ_SOPK__SIMM16__SHIFT                                                                                0x0
#define SQ_SOPK__SDST__SHIFT                                                                                  0x10
#define SQ_SOPK__OP__SHIFT                                                                                    0x17
#define SQ_SOPK__ENCODING__SHIFT                                                                              0x1c
#define SQ_SOPK__SIMM16_MASK                                                                                  0x0000FFFFL
#define SQ_SOPK__SDST_MASK                                                                                    0x007F0000L
#define SQ_SOPK__OP_MASK                                                                                      0x0F800000L
#define SQ_SOPK__ENCODING_MASK                                                                                0xF0000000L
//SQ_SOPP
#define SQ_SOPP__SIMM16__SHIFT                                                                                0x0
#define SQ_SOPP__OP__SHIFT                                                                                    0x10
#define SQ_SOPP__ENCODING__SHIFT                                                                              0x17
#define SQ_SOPP__SIMM16_MASK                                                                                  0x0000FFFFL
#define SQ_SOPP__OP_MASK                                                                                      0x007F0000L
#define SQ_SOPP__ENCODING_MASK                                                                                0xFF800000L
//SQ_VINTRP
#define SQ_VINTRP__VSRC__SHIFT                                                                                0x0
#define SQ_VINTRP__ATTRCHAN__SHIFT                                                                            0x8
#define SQ_VINTRP__ATTR__SHIFT                                                                                0xa
#define SQ_VINTRP__OP__SHIFT                                                                                  0x10
#define SQ_VINTRP__VDST__SHIFT                                                                                0x12
#define SQ_VINTRP__ENCODING__SHIFT                                                                            0x1a
#define SQ_VINTRP__VSRC_MASK                                                                                  0x000000FFL
#define SQ_VINTRP__ATTRCHAN_MASK                                                                              0x00000300L
#define SQ_VINTRP__ATTR_MASK                                                                                  0x0000FC00L
#define SQ_VINTRP__OP_MASK                                                                                    0x00030000L
#define SQ_VINTRP__VDST_MASK                                                                                  0x03FC0000L
#define SQ_VINTRP__ENCODING_MASK                                                                              0xFC000000L
//SQ_VOP1
#define SQ_VOP1__SRC0__SHIFT                                                                                  0x0
#define SQ_VOP1__OP__SHIFT                                                                                    0x9
#define SQ_VOP1__VDST__SHIFT                                                                                  0x11
#define SQ_VOP1__ENCODING__SHIFT                                                                              0x19
#define SQ_VOP1__SRC0_MASK                                                                                    0x000001FFL
#define SQ_VOP1__OP_MASK                                                                                      0x0001FE00L
#define SQ_VOP1__VDST_MASK                                                                                    0x01FE0000L
#define SQ_VOP1__ENCODING_MASK                                                                                0xFE000000L
//SQ_VOP2
#define SQ_VOP2__SRC0__SHIFT                                                                                  0x0
#define SQ_VOP2__VSRC1__SHIFT                                                                                 0x9
#define SQ_VOP2__VDST__SHIFT                                                                                  0x11
#define SQ_VOP2__OP__SHIFT                                                                                    0x19
#define SQ_VOP2__ENCODING__SHIFT                                                                              0x1f
#define SQ_VOP2__SRC0_MASK                                                                                    0x000001FFL
#define SQ_VOP2__VSRC1_MASK                                                                                   0x0001FE00L
#define SQ_VOP2__VDST_MASK                                                                                    0x01FE0000L
#define SQ_VOP2__OP_MASK                                                                                      0x7E000000L
#define SQ_VOP2__ENCODING_MASK                                                                                0x80000000L
//SQ_VOP3P_0
#define SQ_VOP3P_0__VDST__SHIFT                                                                               0x0
#define SQ_VOP3P_0__NEG_HI__SHIFT                                                                             0x8
#define SQ_VOP3P_0__OP_SEL__SHIFT                                                                             0xb
#define SQ_VOP3P_0__OP_SEL_HI_2__SHIFT                                                                        0xe
#define SQ_VOP3P_0__CLAMP__SHIFT                                                                              0xf
#define SQ_VOP3P_0__OP__SHIFT                                                                                 0x10
#define SQ_VOP3P_0__ENCODING__SHIFT                                                                           0x17
#define SQ_VOP3P_0__VDST_MASK                                                                                 0x000000FFL
#define SQ_VOP3P_0__NEG_HI_MASK                                                                               0x00000700L
#define SQ_VOP3P_0__OP_SEL_MASK                                                                               0x00003800L
#define SQ_VOP3P_0__OP_SEL_HI_2_MASK                                                                          0x00004000L
#define SQ_VOP3P_0__CLAMP_MASK                                                                                0x00008000L
#define SQ_VOP3P_0__OP_MASK                                                                                   0x007F0000L
#define SQ_VOP3P_0__ENCODING_MASK                                                                             0xFF800000L
//SQ_VOP3P_1
#define SQ_VOP3P_1__SRC0__SHIFT                                                                               0x0
#define SQ_VOP3P_1__SRC1__SHIFT                                                                               0x9
#define SQ_VOP3P_1__SRC2__SHIFT                                                                               0x12
#define SQ_VOP3P_1__OP_SEL_HI__SHIFT                                                                          0x1b
#define SQ_VOP3P_1__NEG__SHIFT                                                                                0x1d
#define SQ_VOP3P_1__SRC0_MASK                                                                                 0x000001FFL
#define SQ_VOP3P_1__SRC1_MASK                                                                                 0x0003FE00L
#define SQ_VOP3P_1__SRC2_MASK                                                                                 0x07FC0000L
#define SQ_VOP3P_1__OP_SEL_HI_MASK                                                                            0x18000000L
#define SQ_VOP3P_1__NEG_MASK                                                                                  0xE0000000L
//SQ_VOP3_0
#define SQ_VOP3_0__VDST__SHIFT                                                                                0x0
#define SQ_VOP3_0__ABS__SHIFT                                                                                 0x8
#define SQ_VOP3_0__OP_SEL__SHIFT                                                                              0xb
#define SQ_VOP3_0__CLAMP__SHIFT                                                                               0xf
#define SQ_VOP3_0__OP__SHIFT                                                                                  0x10
#define SQ_VOP3_0__ENCODING__SHIFT                                                                            0x1a
#define SQ_VOP3_0__VDST_MASK                                                                                  0x000000FFL
#define SQ_VOP3_0__ABS_MASK                                                                                   0x00000700L
#define SQ_VOP3_0__OP_SEL_MASK                                                                                0x00007800L
#define SQ_VOP3_0__CLAMP_MASK                                                                                 0x00008000L
#define SQ_VOP3_0__OP_MASK                                                                                    0x03FF0000L
#define SQ_VOP3_0__ENCODING_MASK                                                                              0xFC000000L
//SQ_VOP3_0_SDST_ENC
#define SQ_VOP3_0_SDST_ENC__VDST__SHIFT                                                                       0x0
#define SQ_VOP3_0_SDST_ENC__SDST__SHIFT                                                                       0x8
#define SQ_VOP3_0_SDST_ENC__CLAMP__SHIFT                                                                      0xf
#define SQ_VOP3_0_SDST_ENC__OP__SHIFT                                                                         0x10
#define SQ_VOP3_0_SDST_ENC__ENCODING__SHIFT                                                                   0x1a
#define SQ_VOP3_0_SDST_ENC__VDST_MASK                                                                         0x000000FFL
#define SQ_VOP3_0_SDST_ENC__SDST_MASK                                                                         0x00007F00L
#define SQ_VOP3_0_SDST_ENC__CLAMP_MASK                                                                        0x00008000L
#define SQ_VOP3_0_SDST_ENC__OP_MASK                                                                           0x03FF0000L
#define SQ_VOP3_0_SDST_ENC__ENCODING_MASK                                                                     0xFC000000L
//SQ_VOP3_1
#define SQ_VOP3_1__SRC0__SHIFT                                                                                0x0
#define SQ_VOP3_1__SRC1__SHIFT                                                                                0x9
#define SQ_VOP3_1__SRC2__SHIFT                                                                                0x12
#define SQ_VOP3_1__OMOD__SHIFT                                                                                0x1b
#define SQ_VOP3_1__NEG__SHIFT                                                                                 0x1d
#define SQ_VOP3_1__SRC0_MASK                                                                                  0x000001FFL
#define SQ_VOP3_1__SRC1_MASK                                                                                  0x0003FE00L
#define SQ_VOP3_1__SRC2_MASK                                                                                  0x07FC0000L
#define SQ_VOP3_1__OMOD_MASK                                                                                  0x18000000L
#define SQ_VOP3_1__NEG_MASK                                                                                   0xE0000000L
//SQ_VOPC
#define SQ_VOPC__SRC0__SHIFT                                                                                  0x0
#define SQ_VOPC__VSRC1__SHIFT                                                                                 0x9
#define SQ_VOPC__OP__SHIFT                                                                                    0x11
#define SQ_VOPC__ENCODING__SHIFT                                                                              0x19
#define SQ_VOPC__SRC0_MASK                                                                                    0x000001FFL
#define SQ_VOPC__VSRC1_MASK                                                                                   0x0001FE00L
#define SQ_VOPC__OP_MASK                                                                                      0x01FE0000L
#define SQ_VOPC__ENCODING_MASK                                                                                0xFE000000L
//SQ_VOP_DPP
#define SQ_VOP_DPP__SRC0__SHIFT                                                                               0x0
#define SQ_VOP_DPP__DPP_CTRL__SHIFT                                                                           0x8
#define SQ_VOP_DPP__BOUND_CTRL__SHIFT                                                                         0x13
#define SQ_VOP_DPP__SRC0_NEG__SHIFT                                                                           0x14
#define SQ_VOP_DPP__SRC0_ABS__SHIFT                                                                           0x15
#define SQ_VOP_DPP__SRC1_NEG__SHIFT                                                                           0x16
#define SQ_VOP_DPP__SRC1_ABS__SHIFT                                                                           0x17
#define SQ_VOP_DPP__BANK_MASK__SHIFT                                                                          0x18
#define SQ_VOP_DPP__ROW_MASK__SHIFT                                                                           0x1c
#define SQ_VOP_DPP__SRC0_MASK                                                                                 0x000000FFL
#define SQ_VOP_DPP__DPP_CTRL_MASK                                                                             0x0001FF00L
#define SQ_VOP_DPP__BOUND_CTRL_MASK                                                                           0x00080000L
#define SQ_VOP_DPP__SRC0_NEG_MASK                                                                             0x00100000L
#define SQ_VOP_DPP__SRC0_ABS_MASK                                                                             0x00200000L
#define SQ_VOP_DPP__SRC1_NEG_MASK                                                                             0x00400000L
#define SQ_VOP_DPP__SRC1_ABS_MASK                                                                             0x00800000L
#define SQ_VOP_DPP__BANK_MASK_MASK                                                                            0x0F000000L
#define SQ_VOP_DPP__ROW_MASK_MASK                                                                             0xF0000000L
//SQ_VOP_SDWA
#define SQ_VOP_SDWA__SRC0__SHIFT                                                                              0x0
#define SQ_VOP_SDWA__DST_SEL__SHIFT                                                                           0x8
#define SQ_VOP_SDWA__DST_UNUSED__SHIFT                                                                        0xb
#define SQ_VOP_SDWA__CLAMP__SHIFT                                                                             0xd
#define SQ_VOP_SDWA__OMOD__SHIFT                                                                              0xe
#define SQ_VOP_SDWA__SRC0_SEL__SHIFT                                                                          0x10
#define SQ_VOP_SDWA__SRC0_SEXT__SHIFT                                                                         0x13
#define SQ_VOP_SDWA__SRC0_NEG__SHIFT                                                                          0x14
#define SQ_VOP_SDWA__SRC0_ABS__SHIFT                                                                          0x15
#define SQ_VOP_SDWA__S0__SHIFT                                                                                0x17
#define SQ_VOP_SDWA__SRC1_SEL__SHIFT                                                                          0x18
#define SQ_VOP_SDWA__SRC1_SEXT__SHIFT                                                                         0x1b
#define SQ_VOP_SDWA__SRC1_NEG__SHIFT                                                                          0x1c
#define SQ_VOP_SDWA__SRC1_ABS__SHIFT                                                                          0x1d
#define SQ_VOP_SDWA__S1__SHIFT                                                                                0x1f
#define SQ_VOP_SDWA__SRC0_MASK                                                                                0x000000FFL
#define SQ_VOP_SDWA__DST_SEL_MASK                                                                             0x00000700L
#define SQ_VOP_SDWA__DST_UNUSED_MASK                                                                          0x00001800L
#define SQ_VOP_SDWA__CLAMP_MASK                                                                               0x00002000L
#define SQ_VOP_SDWA__OMOD_MASK                                                                                0x0000C000L
#define SQ_VOP_SDWA__SRC0_SEL_MASK                                                                            0x00070000L
#define SQ_VOP_SDWA__SRC0_SEXT_MASK                                                                           0x00080000L
#define SQ_VOP_SDWA__SRC0_NEG_MASK                                                                            0x00100000L
#define SQ_VOP_SDWA__SRC0_ABS_MASK                                                                            0x00200000L
#define SQ_VOP_SDWA__S0_MASK                                                                                  0x00800000L
#define SQ_VOP_SDWA__SRC1_SEL_MASK                                                                            0x07000000L
#define SQ_VOP_SDWA__SRC1_SEXT_MASK                                                                           0x08000000L
#define SQ_VOP_SDWA__SRC1_NEG_MASK                                                                            0x10000000L
#define SQ_VOP_SDWA__SRC1_ABS_MASK                                                                            0x20000000L
#define SQ_VOP_SDWA__S1_MASK                                                                                  0x80000000L
//SQ_VOP_SDWA_SDST_ENC
#define SQ_VOP_SDWA_SDST_ENC__SRC0__SHIFT                                                                     0x0
#define SQ_VOP_SDWA_SDST_ENC__SDST__SHIFT                                                                     0x8
#define SQ_VOP_SDWA_SDST_ENC__SD__SHIFT                                                                       0xf
#define SQ_VOP_SDWA_SDST_ENC__SRC0_SEL__SHIFT                                                                 0x10
#define SQ_VOP_SDWA_SDST_ENC__SRC0_SEXT__SHIFT                                                                0x13
#define SQ_VOP_SDWA_SDST_ENC__SRC0_NEG__SHIFT                                                                 0x14
#define SQ_VOP_SDWA_SDST_ENC__SRC0_ABS__SHIFT                                                                 0x15
#define SQ_VOP_SDWA_SDST_ENC__S0__SHIFT                                                                       0x17
#define SQ_VOP_SDWA_SDST_ENC__SRC1_SEL__SHIFT                                                                 0x18
#define SQ_VOP_SDWA_SDST_ENC__SRC1_SEXT__SHIFT                                                                0x1b
#define SQ_VOP_SDWA_SDST_ENC__SRC1_NEG__SHIFT                                                                 0x1c
#define SQ_VOP_SDWA_SDST_ENC__SRC1_ABS__SHIFT                                                                 0x1d
#define SQ_VOP_SDWA_SDST_ENC__S1__SHIFT                                                                       0x1f
#define SQ_VOP_SDWA_SDST_ENC__SRC0_MASK                                                                       0x000000FFL
#define SQ_VOP_SDWA_SDST_ENC__SDST_MASK                                                                       0x00007F00L
#define SQ_VOP_SDWA_SDST_ENC__SD_MASK                                                                         0x00008000L
#define SQ_VOP_SDWA_SDST_ENC__SRC0_SEL_MASK                                                                   0x00070000L
#define SQ_VOP_SDWA_SDST_ENC__SRC0_SEXT_MASK                                                                  0x00080000L
#define SQ_VOP_SDWA_SDST_ENC__SRC0_NEG_MASK                                                                   0x00100000L
#define SQ_VOP_SDWA_SDST_ENC__SRC0_ABS_MASK                                                                   0x00200000L
#define SQ_VOP_SDWA_SDST_ENC__S0_MASK                                                                         0x00800000L
#define SQ_VOP_SDWA_SDST_ENC__SRC1_SEL_MASK                                                                   0x07000000L
#define SQ_VOP_SDWA_SDST_ENC__SRC1_SEXT_MASK                                                                  0x08000000L
#define SQ_VOP_SDWA_SDST_ENC__SRC1_NEG_MASK                                                                   0x10000000L
#define SQ_VOP_SDWA_SDST_ENC__SRC1_ABS_MASK                                                                   0x20000000L
#define SQ_VOP_SDWA_SDST_ENC__S1_MASK                                                                         0x80000000L
//SQ_LB_CTR_CTRL
#define SQ_LB_CTR_CTRL__START__SHIFT                                                                          0x0
#define SQ_LB_CTR_CTRL__LOAD__SHIFT                                                                           0x1
#define SQ_LB_CTR_CTRL__CLEAR__SHIFT                                                                          0x2
#define SQ_LB_CTR_CTRL__START_MASK                                                                            0x00000001L
#define SQ_LB_CTR_CTRL__LOAD_MASK                                                                             0x00000002L
#define SQ_LB_CTR_CTRL__CLEAR_MASK                                                                            0x00000004L
//SQ_LB_DATA0
#define SQ_LB_DATA0__DATA__SHIFT                                                                              0x0
#define SQ_LB_DATA0__DATA_MASK                                                                                0xFFFFFFFFL
//SQ_LB_DATA1
#define SQ_LB_DATA1__DATA__SHIFT                                                                              0x0
#define SQ_LB_DATA1__DATA_MASK                                                                                0xFFFFFFFFL
//SQ_LB_DATA2
#define SQ_LB_DATA2__DATA__SHIFT                                                                              0x0
#define SQ_LB_DATA2__DATA_MASK                                                                                0xFFFFFFFFL
//SQ_LB_DATA3
#define SQ_LB_DATA3__DATA__SHIFT                                                                              0x0
#define SQ_LB_DATA3__DATA_MASK                                                                                0xFFFFFFFFL
//SQ_LB_CTR_SEL
#define SQ_LB_CTR_SEL__SEL0__SHIFT                                                                            0x0
#define SQ_LB_CTR_SEL__SEL1__SHIFT                                                                            0x4
#define SQ_LB_CTR_SEL__SEL2__SHIFT                                                                            0x8
#define SQ_LB_CTR_SEL__SEL3__SHIFT                                                                            0xc
#define SQ_LB_CTR_SEL__SEL0_MASK                                                                              0x0000000FL
#define SQ_LB_CTR_SEL__SEL1_MASK                                                                              0x000000F0L
#define SQ_LB_CTR_SEL__SEL2_MASK                                                                              0x00000F00L
#define SQ_LB_CTR_SEL__SEL3_MASK                                                                              0x0000F000L
//SQ_LB_CTR0_CU
#define SQ_LB_CTR0_CU__SH0_MASK__SHIFT                                                                        0x0
#define SQ_LB_CTR0_CU__SH1_MASK__SHIFT                                                                        0x10
#define SQ_LB_CTR0_CU__SH0_MASK_MASK                                                                          0x0000FFFFL
#define SQ_LB_CTR0_CU__SH1_MASK_MASK                                                                          0xFFFF0000L
//SQ_LB_CTR1_CU
#define SQ_LB_CTR1_CU__SH0_MASK__SHIFT                                                                        0x0
#define SQ_LB_CTR1_CU__SH1_MASK__SHIFT                                                                        0x10
#define SQ_LB_CTR1_CU__SH0_MASK_MASK                                                                          0x0000FFFFL
#define SQ_LB_CTR1_CU__SH1_MASK_MASK                                                                          0xFFFF0000L
//SQ_LB_CTR2_CU
#define SQ_LB_CTR2_CU__SH0_MASK__SHIFT                                                                        0x0
#define SQ_LB_CTR2_CU__SH1_MASK__SHIFT                                                                        0x10
#define SQ_LB_CTR2_CU__SH0_MASK_MASK                                                                          0x0000FFFFL
#define SQ_LB_CTR2_CU__SH1_MASK_MASK                                                                          0xFFFF0000L
//SQ_LB_CTR3_CU
#define SQ_LB_CTR3_CU__SH0_MASK__SHIFT                                                                        0x0
#define SQ_LB_CTR3_CU__SH1_MASK__SHIFT                                                                        0x10
#define SQ_LB_CTR3_CU__SH0_MASK_MASK                                                                          0x0000FFFFL
#define SQ_LB_CTR3_CU__SH1_MASK_MASK                                                                          0xFFFF0000L
//SQC_EDC_CNT
#define SQC_EDC_CNT__DATA_CU0_WRITE_DATA_BUF_SEC_COUNT__SHIFT                                                 0x0
#define SQC_EDC_CNT__DATA_CU0_WRITE_DATA_BUF_DED_COUNT__SHIFT                                                 0x2
#define SQC_EDC_CNT__DATA_CU0_UTCL1_LFIFO_SEC_COUNT__SHIFT                                                    0x4
#define SQC_EDC_CNT__DATA_CU0_UTCL1_LFIFO_DED_COUNT__SHIFT                                                    0x6
#define SQC_EDC_CNT__DATA_CU1_WRITE_DATA_BUF_SEC_COUNT__SHIFT                                                 0x8
#define SQC_EDC_CNT__DATA_CU1_WRITE_DATA_BUF_DED_COUNT__SHIFT                                                 0xa
#define SQC_EDC_CNT__DATA_CU1_UTCL1_LFIFO_SEC_COUNT__SHIFT                                                    0xc
#define SQC_EDC_CNT__DATA_CU1_UTCL1_LFIFO_DED_COUNT__SHIFT                                                    0xe
#define SQC_EDC_CNT__DATA_CU2_WRITE_DATA_BUF_SEC_COUNT__SHIFT                                                 0x10
#define SQC_EDC_CNT__DATA_CU2_WRITE_DATA_BUF_DED_COUNT__SHIFT                                                 0x12
#define SQC_EDC_CNT__DATA_CU2_UTCL1_LFIFO_SEC_COUNT__SHIFT                                                    0x14
#define SQC_EDC_CNT__DATA_CU2_UTCL1_LFIFO_DED_COUNT__SHIFT                                                    0x16
#define SQC_EDC_CNT__DATA_CU3_WRITE_DATA_BUF_SEC_COUNT__SHIFT                                                 0x18
#define SQC_EDC_CNT__DATA_CU3_WRITE_DATA_BUF_DED_COUNT__SHIFT                                                 0x1a
#define SQC_EDC_CNT__DATA_CU3_UTCL1_LFIFO_SEC_COUNT__SHIFT                                                    0x1c
#define SQC_EDC_CNT__DATA_CU3_UTCL1_LFIFO_DED_COUNT__SHIFT                                                    0x1e
#define SQC_EDC_CNT__DATA_CU0_WRITE_DATA_BUF_SEC_COUNT_MASK                                                   0x00000003L
#define SQC_EDC_CNT__DATA_CU0_WRITE_DATA_BUF_DED_COUNT_MASK                                                   0x0000000CL
#define SQC_EDC_CNT__DATA_CU0_UTCL1_LFIFO_SEC_COUNT_MASK                                                      0x00000030L
#define SQC_EDC_CNT__DATA_CU0_UTCL1_LFIFO_DED_COUNT_MASK                                                      0x000000C0L
#define SQC_EDC_CNT__DATA_CU1_WRITE_DATA_BUF_SEC_COUNT_MASK                                                   0x00000300L
#define SQC_EDC_CNT__DATA_CU1_WRITE_DATA_BUF_DED_COUNT_MASK                                                   0x00000C00L
#define SQC_EDC_CNT__DATA_CU1_UTCL1_LFIFO_SEC_COUNT_MASK                                                      0x00003000L
#define SQC_EDC_CNT__DATA_CU1_UTCL1_LFIFO_DED_COUNT_MASK                                                      0x0000C000L
#define SQC_EDC_CNT__DATA_CU2_WRITE_DATA_BUF_SEC_COUNT_MASK                                                   0x00030000L
#define SQC_EDC_CNT__DATA_CU2_WRITE_DATA_BUF_DED_COUNT_MASK                                                   0x000C0000L
#define SQC_EDC_CNT__DATA_CU2_UTCL1_LFIFO_SEC_COUNT_MASK                                                      0x00300000L
#define SQC_EDC_CNT__DATA_CU2_UTCL1_LFIFO_DED_COUNT_MASK                                                      0x00C00000L
#define SQC_EDC_CNT__DATA_CU3_WRITE_DATA_BUF_SEC_COUNT_MASK                                                   0x03000000L
#define SQC_EDC_CNT__DATA_CU3_WRITE_DATA_BUF_DED_COUNT_MASK                                                   0x0C000000L
#define SQC_EDC_CNT__DATA_CU3_UTCL1_LFIFO_SEC_COUNT_MASK                                                      0x30000000L
#define SQC_EDC_CNT__DATA_CU3_UTCL1_LFIFO_DED_COUNT_MASK                                                      0xC0000000L
//SQ_EDC_SEC_CNT
#define SQ_EDC_SEC_CNT__LDS_SEC__SHIFT                                                                        0x0
#define SQ_EDC_SEC_CNT__SGPR_SEC__SHIFT                                                                       0x8
#define SQ_EDC_SEC_CNT__VGPR_SEC__SHIFT                                                                       0x10
#define SQ_EDC_SEC_CNT__LDS_SEC_MASK                                                                          0x000000FFL
#define SQ_EDC_SEC_CNT__SGPR_SEC_MASK                                                                         0x0000FF00L
#define SQ_EDC_SEC_CNT__VGPR_SEC_MASK                                                                         0x00FF0000L
//SQ_EDC_DED_CNT
#define SQ_EDC_DED_CNT__LDS_DED__SHIFT                                                                        0x0
#define SQ_EDC_DED_CNT__SGPR_DED__SHIFT                                                                       0x8
#define SQ_EDC_DED_CNT__VGPR_DED__SHIFT                                                                       0x10
#define SQ_EDC_DED_CNT__LDS_DED_MASK                                                                          0x000000FFL
#define SQ_EDC_DED_CNT__SGPR_DED_MASK                                                                         0x0000FF00L
#define SQ_EDC_DED_CNT__VGPR_DED_MASK                                                                         0x00FF0000L
//SQ_EDC_INFO
#define SQ_EDC_INFO__WAVE_ID__SHIFT                                                                           0x0
#define SQ_EDC_INFO__SIMD_ID__SHIFT                                                                           0x4
#define SQ_EDC_INFO__SOURCE__SHIFT                                                                            0x6
#define SQ_EDC_INFO__VM_ID__SHIFT                                                                             0x9
#define SQ_EDC_INFO__WAVE_ID_MASK                                                                             0x0000000FL
#define SQ_EDC_INFO__SIMD_ID_MASK                                                                             0x00000030L
#define SQ_EDC_INFO__SOURCE_MASK                                                                              0x000001C0L
#define SQ_EDC_INFO__VM_ID_MASK                                                                               0x00001E00L
//SQ_EDC_CNT
#define SQ_EDC_CNT__LDS_D_SEC_COUNT__SHIFT                                                                    0x0
#define SQ_EDC_CNT__LDS_D_DED_COUNT__SHIFT                                                                    0x2
#define SQ_EDC_CNT__LDS_I_SEC_COUNT__SHIFT                                                                    0x4
#define SQ_EDC_CNT__LDS_I_DED_COUNT__SHIFT                                                                    0x6
#define SQ_EDC_CNT__SGPR_SEC_COUNT__SHIFT                                                                     0x8
#define SQ_EDC_CNT__SGPR_DED_COUNT__SHIFT                                                                     0xa
#define SQ_EDC_CNT__VGPR0_SEC_COUNT__SHIFT                                                                    0xc
#define SQ_EDC_CNT__VGPR0_DED_COUNT__SHIFT                                                                    0xe
#define SQ_EDC_CNT__VGPR1_SEC_COUNT__SHIFT                                                                    0x10
#define SQ_EDC_CNT__VGPR1_DED_COUNT__SHIFT                                                                    0x12
#define SQ_EDC_CNT__VGPR2_SEC_COUNT__SHIFT                                                                    0x14
#define SQ_EDC_CNT__VGPR2_DED_COUNT__SHIFT                                                                    0x16
#define SQ_EDC_CNT__VGPR3_SEC_COUNT__SHIFT                                                                    0x18
#define SQ_EDC_CNT__VGPR3_DED_COUNT__SHIFT                                                                    0x1a
#define SQ_EDC_CNT__LDS_D_SEC_COUNT_MASK                                                                      0x00000003L
#define SQ_EDC_CNT__LDS_D_DED_COUNT_MASK                                                                      0x0000000CL
#define SQ_EDC_CNT__LDS_I_SEC_COUNT_MASK                                                                      0x00000030L
#define SQ_EDC_CNT__LDS_I_DED_COUNT_MASK                                                                      0x000000C0L
#define SQ_EDC_CNT__SGPR_SEC_COUNT_MASK                                                                       0x00000300L
#define SQ_EDC_CNT__SGPR_DED_COUNT_MASK                                                                       0x00000C00L
#define SQ_EDC_CNT__VGPR0_SEC_COUNT_MASK                                                                      0x00003000L
#define SQ_EDC_CNT__VGPR0_DED_COUNT_MASK                                                                      0x0000C000L
#define SQ_EDC_CNT__VGPR1_SEC_COUNT_MASK                                                                      0x00030000L
#define SQ_EDC_CNT__VGPR1_DED_COUNT_MASK                                                                      0x000C0000L
#define SQ_EDC_CNT__VGPR2_SEC_COUNT_MASK                                                                      0x00300000L
#define SQ_EDC_CNT__VGPR2_DED_COUNT_MASK                                                                      0x00C00000L
#define SQ_EDC_CNT__VGPR3_SEC_COUNT_MASK                                                                      0x03000000L
#define SQ_EDC_CNT__VGPR3_DED_COUNT_MASK                                                                      0x0C000000L
//SQ_EDC_FUE_CNTL
#define SQ_EDC_FUE_CNTL__BLOCK_FUE_FLAGS__SHIFT                                                               0x0
#define SQ_EDC_FUE_CNTL__FUE_INTERRUPT_ENABLES__SHIFT                                                         0x10
#define SQ_EDC_FUE_CNTL__BLOCK_FUE_FLAGS_MASK                                                                 0x0000FFFFL
#define SQ_EDC_FUE_CNTL__FUE_INTERRUPT_ENABLES_MASK                                                           0xFFFF0000L
//SQ_THREAD_TRACE_WORD_CMN
#define SQ_THREAD_TRACE_WORD_CMN__TOKEN_TYPE__SHIFT                                                           0x0
#define SQ_THREAD_TRACE_WORD_CMN__TIME_DELTA__SHIFT                                                           0x4
#define SQ_THREAD_TRACE_WORD_CMN__TOKEN_TYPE_MASK                                                             0x000FL
#define SQ_THREAD_TRACE_WORD_CMN__TIME_DELTA_MASK                                                             0x0010L
//SQ_THREAD_TRACE_WORD_EVENT
#define SQ_THREAD_TRACE_WORD_EVENT__TOKEN_TYPE__SHIFT                                                         0x0
#define SQ_THREAD_TRACE_WORD_EVENT__TIME_DELTA__SHIFT                                                         0x4
#define SQ_THREAD_TRACE_WORD_EVENT__SH_ID__SHIFT                                                              0x5
#define SQ_THREAD_TRACE_WORD_EVENT__STAGE__SHIFT                                                              0x6
#define SQ_THREAD_TRACE_WORD_EVENT__EVENT_TYPE__SHIFT                                                         0xa
#define SQ_THREAD_TRACE_WORD_EVENT__TOKEN_TYPE_MASK                                                           0x000FL
#define SQ_THREAD_TRACE_WORD_EVENT__TIME_DELTA_MASK                                                           0x0010L
#define SQ_THREAD_TRACE_WORD_EVENT__SH_ID_MASK                                                                0x0020L
#define SQ_THREAD_TRACE_WORD_EVENT__STAGE_MASK                                                                0x01C0L
#define SQ_THREAD_TRACE_WORD_EVENT__EVENT_TYPE_MASK                                                           0xFC00L
//SQ_THREAD_TRACE_WORD_INST
#define SQ_THREAD_TRACE_WORD_INST__TOKEN_TYPE__SHIFT                                                          0x0
#define SQ_THREAD_TRACE_WORD_INST__TIME_DELTA__SHIFT                                                          0x4
#define SQ_THREAD_TRACE_WORD_INST__WAVE_ID__SHIFT                                                             0x5
#define SQ_THREAD_TRACE_WORD_INST__SIMD_ID__SHIFT                                                             0x9
#define SQ_THREAD_TRACE_WORD_INST__INST_TYPE__SHIFT                                                           0xb
#define SQ_THREAD_TRACE_WORD_INST__TOKEN_TYPE_MASK                                                            0x000FL
#define SQ_THREAD_TRACE_WORD_INST__TIME_DELTA_MASK                                                            0x0010L
#define SQ_THREAD_TRACE_WORD_INST__WAVE_ID_MASK                                                               0x01E0L
#define SQ_THREAD_TRACE_WORD_INST__SIMD_ID_MASK                                                               0x0600L
#define SQ_THREAD_TRACE_WORD_INST__INST_TYPE_MASK                                                             0xF800L
//SQ_THREAD_TRACE_WORD_INST_PC_1_OF_2
#define SQ_THREAD_TRACE_WORD_INST_PC_1_OF_2__TOKEN_TYPE__SHIFT                                                0x0
#define SQ_THREAD_TRACE_WORD_INST_PC_1_OF_2__TIME_DELTA__SHIFT                                                0x4
#define SQ_THREAD_TRACE_WORD_INST_PC_1_OF_2__WAVE_ID__SHIFT                                                   0x5
#define SQ_THREAD_TRACE_WORD_INST_PC_1_OF_2__SIMD_ID__SHIFT                                                   0x9
#define SQ_THREAD_TRACE_WORD_INST_PC_1_OF_2__TRAP_ERROR__SHIFT                                                0xf
#define SQ_THREAD_TRACE_WORD_INST_PC_1_OF_2__PC_LO__SHIFT                                                     0x10
#define SQ_THREAD_TRACE_WORD_INST_PC_1_OF_2__TOKEN_TYPE_MASK                                                  0x0000000FL
#define SQ_THREAD_TRACE_WORD_INST_PC_1_OF_2__TIME_DELTA_MASK                                                  0x00000010L
#define SQ_THREAD_TRACE_WORD_INST_PC_1_OF_2__WAVE_ID_MASK                                                     0x000001E0L
#define SQ_THREAD_TRACE_WORD_INST_PC_1_OF_2__SIMD_ID_MASK                                                     0x00000600L
#define SQ_THREAD_TRACE_WORD_INST_PC_1_OF_2__TRAP_ERROR_MASK                                                  0x00008000L
#define SQ_THREAD_TRACE_WORD_INST_PC_1_OF_2__PC_LO_MASK                                                       0xFFFF0000L
//SQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2
#define SQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2__TOKEN_TYPE__SHIFT                                          0x0
#define SQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2__TIME_DELTA__SHIFT                                          0x4
#define SQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2__SH_ID__SHIFT                                               0x5
#define SQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2__CU_ID__SHIFT                                               0x6
#define SQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2__WAVE_ID__SHIFT                                             0xa
#define SQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2__SIMD_ID__SHIFT                                             0xe
#define SQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2__DATA_LO__SHIFT                                             0x10
#define SQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2__TOKEN_TYPE_MASK                                            0x0000000FL
#define SQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2__TIME_DELTA_MASK                                            0x00000010L
#define SQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2__SH_ID_MASK                                                 0x00000020L
#define SQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2__CU_ID_MASK                                                 0x000003C0L
#define SQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2__WAVE_ID_MASK                                               0x00003C00L
#define SQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2__SIMD_ID_MASK                                               0x0000C000L
#define SQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2__DATA_LO_MASK                                               0xFFFF0000L
//SQ_THREAD_TRACE_WORD_ISSUE
#define SQ_THREAD_TRACE_WORD_ISSUE__TOKEN_TYPE__SHIFT                                                         0x0
#define SQ_THREAD_TRACE_WORD_ISSUE__TIME_DELTA__SHIFT                                                         0x4
#define SQ_THREAD_TRACE_WORD_ISSUE__SIMD_ID__SHIFT                                                            0x5
#define SQ_THREAD_TRACE_WORD_ISSUE__INST0__SHIFT                                                              0x8
#define SQ_THREAD_TRACE_WORD_ISSUE__INST1__SHIFT                                                              0xa
#define SQ_THREAD_TRACE_WORD_ISSUE__INST2__SHIFT                                                              0xc
#define SQ_THREAD_TRACE_WORD_ISSUE__INST3__SHIFT                                                              0xe
#define SQ_THREAD_TRACE_WORD_ISSUE__INST4__SHIFT                                                              0x10
#define SQ_THREAD_TRACE_WORD_ISSUE__INST5__SHIFT                                                              0x12
#define SQ_THREAD_TRACE_WORD_ISSUE__INST6__SHIFT                                                              0x14
#define SQ_THREAD_TRACE_WORD_ISSUE__INST7__SHIFT                                                              0x16
#define SQ_THREAD_TRACE_WORD_ISSUE__INST8__SHIFT                                                              0x18
#define SQ_THREAD_TRACE_WORD_ISSUE__INST9__SHIFT                                                              0x1a
#define SQ_THREAD_TRACE_WORD_ISSUE__TOKEN_TYPE_MASK                                                           0x0000000FL
#define SQ_THREAD_TRACE_WORD_ISSUE__TIME_DELTA_MASK                                                           0x00000010L
#define SQ_THREAD_TRACE_WORD_ISSUE__SIMD_ID_MASK                                                              0x00000060L
#define SQ_THREAD_TRACE_WORD_ISSUE__INST0_MASK                                                                0x00000300L
#define SQ_THREAD_TRACE_WORD_ISSUE__INST1_MASK                                                                0x00000C00L
#define SQ_THREAD_TRACE_WORD_ISSUE__INST2_MASK                                                                0x00003000L
#define SQ_THREAD_TRACE_WORD_ISSUE__INST3_MASK                                                                0x0000C000L
#define SQ_THREAD_TRACE_WORD_ISSUE__INST4_MASK                                                                0x00030000L
#define SQ_THREAD_TRACE_WORD_ISSUE__INST5_MASK                                                                0x000C0000L
#define SQ_THREAD_TRACE_WORD_ISSUE__INST6_MASK                                                                0x00300000L
#define SQ_THREAD_TRACE_WORD_ISSUE__INST7_MASK                                                                0x00C00000L
#define SQ_THREAD_TRACE_WORD_ISSUE__INST8_MASK                                                                0x03000000L
#define SQ_THREAD_TRACE_WORD_ISSUE__INST9_MASK                                                                0x0C000000L
//SQ_THREAD_TRACE_WORD_MISC
#define SQ_THREAD_TRACE_WORD_MISC__TOKEN_TYPE__SHIFT                                                          0x0
#define SQ_THREAD_TRACE_WORD_MISC__TIME_DELTA__SHIFT                                                          0x4
#define SQ_THREAD_TRACE_WORD_MISC__SH_ID__SHIFT                                                               0xc
#define SQ_THREAD_TRACE_WORD_MISC__MISC_TOKEN_TYPE__SHIFT                                                     0xd
#define SQ_THREAD_TRACE_WORD_MISC__TOKEN_TYPE_MASK                                                            0x000FL
#define SQ_THREAD_TRACE_WORD_MISC__TIME_DELTA_MASK                                                            0x0FF0L
#define SQ_THREAD_TRACE_WORD_MISC__SH_ID_MASK                                                                 0x1000L
#define SQ_THREAD_TRACE_WORD_MISC__MISC_TOKEN_TYPE_MASK                                                       0xE000L
//SQ_THREAD_TRACE_WORD_PERF_1_OF_2
#define SQ_THREAD_TRACE_WORD_PERF_1_OF_2__TOKEN_TYPE__SHIFT                                                   0x0
#define SQ_THREAD_TRACE_WORD_PERF_1_OF_2__TIME_DELTA__SHIFT                                                   0x4
#define SQ_THREAD_TRACE_WORD_PERF_1_OF_2__SH_ID__SHIFT                                                        0x5
#define SQ_THREAD_TRACE_WORD_PERF_1_OF_2__CU_ID__SHIFT                                                        0x6
#define SQ_THREAD_TRACE_WORD_PERF_1_OF_2__CNTR_BANK__SHIFT                                                    0xa
#define SQ_THREAD_TRACE_WORD_PERF_1_OF_2__CNTR0__SHIFT                                                        0xc
#define SQ_THREAD_TRACE_WORD_PERF_1_OF_2__CNTR1_LO__SHIFT                                                     0x19
#define SQ_THREAD_TRACE_WORD_PERF_1_OF_2__TOKEN_TYPE_MASK                                                     0x0000000FL
#define SQ_THREAD_TRACE_WORD_PERF_1_OF_2__TIME_DELTA_MASK                                                     0x00000010L
#define SQ_THREAD_TRACE_WORD_PERF_1_OF_2__SH_ID_MASK                                                          0x00000020L
#define SQ_THREAD_TRACE_WORD_PERF_1_OF_2__CU_ID_MASK                                                          0x000003C0L
#define SQ_THREAD_TRACE_WORD_PERF_1_OF_2__CNTR_BANK_MASK                                                      0x00000C00L
#define SQ_THREAD_TRACE_WORD_PERF_1_OF_2__CNTR0_MASK                                                          0x01FFF000L
#define SQ_THREAD_TRACE_WORD_PERF_1_OF_2__CNTR1_LO_MASK                                                       0xFE000000L
//SQ_THREAD_TRACE_WORD_REG_1_OF_2
#define SQ_THREAD_TRACE_WORD_REG_1_OF_2__TOKEN_TYPE__SHIFT                                                    0x0
#define SQ_THREAD_TRACE_WORD_REG_1_OF_2__TIME_DELTA__SHIFT                                                    0x4
#define SQ_THREAD_TRACE_WORD_REG_1_OF_2__PIPE_ID__SHIFT                                                       0x5
#define SQ_THREAD_TRACE_WORD_REG_1_OF_2__ME_ID__SHIFT                                                         0x7
#define SQ_THREAD_TRACE_WORD_REG_1_OF_2__REG_DROPPED_PREV__SHIFT                                              0x9
#define SQ_THREAD_TRACE_WORD_REG_1_OF_2__REG_TYPE__SHIFT                                                      0xa
#define SQ_THREAD_TRACE_WORD_REG_1_OF_2__REG_PRIV__SHIFT                                                      0xe
#define SQ_THREAD_TRACE_WORD_REG_1_OF_2__REG_OP__SHIFT                                                        0xf
#define SQ_THREAD_TRACE_WORD_REG_1_OF_2__REG_ADDR__SHIFT                                                      0x10
#define SQ_THREAD_TRACE_WORD_REG_1_OF_2__TOKEN_TYPE_MASK                                                      0x0000000FL
#define SQ_THREAD_TRACE_WORD_REG_1_OF_2__TIME_DELTA_MASK                                                      0x00000010L
#define SQ_THREAD_TRACE_WORD_REG_1_OF_2__PIPE_ID_MASK                                                         0x00000060L
#define SQ_THREAD_TRACE_WORD_REG_1_OF_2__ME_ID_MASK                                                           0x00000180L
#define SQ_THREAD_TRACE_WORD_REG_1_OF_2__REG_DROPPED_PREV_MASK                                                0x00000200L
#define SQ_THREAD_TRACE_WORD_REG_1_OF_2__REG_TYPE_MASK                                                        0x00001C00L
#define SQ_THREAD_TRACE_WORD_REG_1_OF_2__REG_PRIV_MASK                                                        0x00004000L
#define SQ_THREAD_TRACE_WORD_REG_1_OF_2__REG_OP_MASK                                                          0x00008000L
#define SQ_THREAD_TRACE_WORD_REG_1_OF_2__REG_ADDR_MASK                                                        0xFFFF0000L
//SQ_THREAD_TRACE_WORD_REG_2_OF_2
#define SQ_THREAD_TRACE_WORD_REG_2_OF_2__DATA__SHIFT                                                          0x0
#define SQ_THREAD_TRACE_WORD_REG_2_OF_2__DATA_MASK                                                            0xFFFFFFFFL
//SQ_THREAD_TRACE_WORD_REG_CS_1_OF_2
#define SQ_THREAD_TRACE_WORD_REG_CS_1_OF_2__TOKEN_TYPE__SHIFT                                                 0x0
#define SQ_THREAD_TRACE_WORD_REG_CS_1_OF_2__TIME_DELTA__SHIFT                                                 0x4
#define SQ_THREAD_TRACE_WORD_REG_CS_1_OF_2__PIPE_ID__SHIFT                                                    0x5
#define SQ_THREAD_TRACE_WORD_REG_CS_1_OF_2__ME_ID__SHIFT                                                      0x7
#define SQ_THREAD_TRACE_WORD_REG_CS_1_OF_2__REG_ADDR__SHIFT                                                   0x9
#define SQ_THREAD_TRACE_WORD_REG_CS_1_OF_2__DATA_LO__SHIFT                                                    0x10
#define SQ_THREAD_TRACE_WORD_REG_CS_1_OF_2__TOKEN_TYPE_MASK                                                   0x0000000FL
#define SQ_THREAD_TRACE_WORD_REG_CS_1_OF_2__TIME_DELTA_MASK                                                   0x00000010L
#define SQ_THREAD_TRACE_WORD_REG_CS_1_OF_2__PIPE_ID_MASK                                                      0x00000060L
#define SQ_THREAD_TRACE_WORD_REG_CS_1_OF_2__ME_ID_MASK                                                        0x00000180L
#define SQ_THREAD_TRACE_WORD_REG_CS_1_OF_2__REG_ADDR_MASK                                                     0x0000FE00L
#define SQ_THREAD_TRACE_WORD_REG_CS_1_OF_2__DATA_LO_MASK                                                      0xFFFF0000L
//SQ_THREAD_TRACE_WORD_REG_CS_2_OF_2
#define SQ_THREAD_TRACE_WORD_REG_CS_2_OF_2__DATA_HI__SHIFT                                                    0x0
#define SQ_THREAD_TRACE_WORD_REG_CS_2_OF_2__DATA_HI_MASK                                                      0x0000FFFFL
//SQ_THREAD_TRACE_WORD_TIMESTAMP_1_OF_2
#define SQ_THREAD_TRACE_WORD_TIMESTAMP_1_OF_2__TOKEN_TYPE__SHIFT                                              0x0
#define SQ_THREAD_TRACE_WORD_TIMESTAMP_1_OF_2__TIME_LO__SHIFT                                                 0x10
#define SQ_THREAD_TRACE_WORD_TIMESTAMP_1_OF_2__TOKEN_TYPE_MASK                                                0x0000000FL
#define SQ_THREAD_TRACE_WORD_TIMESTAMP_1_OF_2__TIME_LO_MASK                                                   0xFFFF0000L
//SQ_THREAD_TRACE_WORD_WAVE
#define SQ_THREAD_TRACE_WORD_WAVE__TOKEN_TYPE__SHIFT                                                          0x0
#define SQ_THREAD_TRACE_WORD_WAVE__TIME_DELTA__SHIFT                                                          0x4
#define SQ_THREAD_TRACE_WORD_WAVE__SH_ID__SHIFT                                                               0x5
#define SQ_THREAD_TRACE_WORD_WAVE__CU_ID__SHIFT                                                               0x6
#define SQ_THREAD_TRACE_WORD_WAVE__WAVE_ID__SHIFT                                                             0xa
#define SQ_THREAD_TRACE_WORD_WAVE__SIMD_ID__SHIFT                                                             0xe
#define SQ_THREAD_TRACE_WORD_WAVE__TOKEN_TYPE_MASK                                                            0x000FL
#define SQ_THREAD_TRACE_WORD_WAVE__TIME_DELTA_MASK                                                            0x0010L
#define SQ_THREAD_TRACE_WORD_WAVE__SH_ID_MASK                                                                 0x0020L
#define SQ_THREAD_TRACE_WORD_WAVE__CU_ID_MASK                                                                 0x03C0L
#define SQ_THREAD_TRACE_WORD_WAVE__WAVE_ID_MASK                                                               0x3C00L
#define SQ_THREAD_TRACE_WORD_WAVE__SIMD_ID_MASK                                                               0xC000L
//SQ_THREAD_TRACE_WORD_WAVE_START
#define SQ_THREAD_TRACE_WORD_WAVE_START__TOKEN_TYPE__SHIFT                                                    0x0
#define SQ_THREAD_TRACE_WORD_WAVE_START__TIME_DELTA__SHIFT                                                    0x4
#define SQ_THREAD_TRACE_WORD_WAVE_START__SH_ID__SHIFT                                                         0x5
#define SQ_THREAD_TRACE_WORD_WAVE_START__CU_ID__SHIFT                                                         0x6
#define SQ_THREAD_TRACE_WORD_WAVE_START__WAVE_ID__SHIFT                                                       0xa
#define SQ_THREAD_TRACE_WORD_WAVE_START__SIMD_ID__SHIFT                                                       0xe
#define SQ_THREAD_TRACE_WORD_WAVE_START__DISPATCHER__SHIFT                                                    0x10
#define SQ_THREAD_TRACE_WORD_WAVE_START__VS_NO_ALLOC_OR_GROUPED__SHIFT                                        0x15
#define SQ_THREAD_TRACE_WORD_WAVE_START__COUNT__SHIFT                                                         0x16
#define SQ_THREAD_TRACE_WORD_WAVE_START__TG_ID__SHIFT                                                         0x1d
#define SQ_THREAD_TRACE_WORD_WAVE_START__TOKEN_TYPE_MASK                                                      0x0000000FL
#define SQ_THREAD_TRACE_WORD_WAVE_START__TIME_DELTA_MASK                                                      0x00000010L
#define SQ_THREAD_TRACE_WORD_WAVE_START__SH_ID_MASK                                                           0x00000020L
#define SQ_THREAD_TRACE_WORD_WAVE_START__CU_ID_MASK                                                           0x000003C0L
#define SQ_THREAD_TRACE_WORD_WAVE_START__WAVE_ID_MASK                                                         0x00003C00L
#define SQ_THREAD_TRACE_WORD_WAVE_START__SIMD_ID_MASK                                                         0x0000C000L
#define SQ_THREAD_TRACE_WORD_WAVE_START__DISPATCHER_MASK                                                      0x001F0000L
#define SQ_THREAD_TRACE_WORD_WAVE_START__VS_NO_ALLOC_OR_GROUPED_MASK                                          0x00200000L
#define SQ_THREAD_TRACE_WORD_WAVE_START__COUNT_MASK                                                           0x1FC00000L
#define SQ_THREAD_TRACE_WORD_WAVE_START__TG_ID_MASK                                                           0xE0000000L
//SQ_THREAD_TRACE_WORD_INST_PC_2_OF_2
#define SQ_THREAD_TRACE_WORD_INST_PC_2_OF_2__PC_HI__SHIFT                                                     0x0
#define SQ_THREAD_TRACE_WORD_INST_PC_2_OF_2__PC_HI_MASK                                                       0x00FFFFFFL
//SQ_THREAD_TRACE_WORD_INST_USERDATA_2_OF_2
#define SQ_THREAD_TRACE_WORD_INST_USERDATA_2_OF_2__DATA_HI__SHIFT                                             0x0
#define SQ_THREAD_TRACE_WORD_INST_USERDATA_2_OF_2__DATA_HI_MASK                                               0xFFFFL
//SQ_THREAD_TRACE_WORD_PERF_2_OF_2
#define SQ_THREAD_TRACE_WORD_PERF_2_OF_2__CNTR1_HI__SHIFT                                                     0x0
#define SQ_THREAD_TRACE_WORD_PERF_2_OF_2__CNTR2__SHIFT                                                        0x6
#define SQ_THREAD_TRACE_WORD_PERF_2_OF_2__CNTR3__SHIFT                                                        0x13
#define SQ_THREAD_TRACE_WORD_PERF_2_OF_2__CNTR1_HI_MASK                                                       0x0000003FL
#define SQ_THREAD_TRACE_WORD_PERF_2_OF_2__CNTR2_MASK                                                          0x0007FFC0L
#define SQ_THREAD_TRACE_WORD_PERF_2_OF_2__CNTR3_MASK                                                          0xFFF80000L
//SQ_THREAD_TRACE_WORD_TIMESTAMP_2_OF_2
#define SQ_THREAD_TRACE_WORD_TIMESTAMP_2_OF_2__TIME_HI__SHIFT                                                 0x0
#define SQ_THREAD_TRACE_WORD_TIMESTAMP_2_OF_2__TIME_HI_MASK                                                   0xFFFFFFFFL
//SQ_WREXEC_EXEC_HI
#define SQ_WREXEC_EXEC_HI__ADDR_HI__SHIFT                                                                     0x0
#define SQ_WREXEC_EXEC_HI__FIRST_WAVE__SHIFT                                                                  0x1a
#define SQ_WREXEC_EXEC_HI__ATC__SHIFT                                                                         0x1b
#define SQ_WREXEC_EXEC_HI__MTYPE__SHIFT                                                                       0x1c
#define SQ_WREXEC_EXEC_HI__MSB__SHIFT                                                                         0x1f
#define SQ_WREXEC_EXEC_HI__ADDR_HI_MASK                                                                       0x0000FFFFL
#define SQ_WREXEC_EXEC_HI__FIRST_WAVE_MASK                                                                    0x04000000L
#define SQ_WREXEC_EXEC_HI__ATC_MASK                                                                           0x08000000L
#define SQ_WREXEC_EXEC_HI__MTYPE_MASK                                                                         0x70000000L
#define SQ_WREXEC_EXEC_HI__MSB_MASK                                                                           0x80000000L
//SQ_WREXEC_EXEC_LO
#define SQ_WREXEC_EXEC_LO__ADDR_LO__SHIFT                                                                     0x0
#define SQ_WREXEC_EXEC_LO__ADDR_LO_MASK                                                                       0xFFFFFFFFL
//SQ_BUF_RSRC_WORD0
#define SQ_BUF_RSRC_WORD0__BASE_ADDRESS__SHIFT                                                                0x0
#define SQ_BUF_RSRC_WORD0__BASE_ADDRESS_MASK                                                                  0xFFFFFFFFL
//SQ_BUF_RSRC_WORD1
#define SQ_BUF_RSRC_WORD1__BASE_ADDRESS_HI__SHIFT                                                             0x0
#define SQ_BUF_RSRC_WORD1__STRIDE__SHIFT                                                                      0x10
#define SQ_BUF_RSRC_WORD1__CACHE_SWIZZLE__SHIFT                                                               0x1e
#define SQ_BUF_RSRC_WORD1__SWIZZLE_ENABLE__SHIFT                                                              0x1f
#define SQ_BUF_RSRC_WORD1__BASE_ADDRESS_HI_MASK                                                               0x0000FFFFL
#define SQ_BUF_RSRC_WORD1__STRIDE_MASK                                                                        0x3FFF0000L
#define SQ_BUF_RSRC_WORD1__CACHE_SWIZZLE_MASK                                                                 0x40000000L
#define SQ_BUF_RSRC_WORD1__SWIZZLE_ENABLE_MASK                                                                0x80000000L
//SQ_BUF_RSRC_WORD2
#define SQ_BUF_RSRC_WORD2__NUM_RECORDS__SHIFT                                                                 0x0
#define SQ_BUF_RSRC_WORD2__NUM_RECORDS_MASK                                                                   0xFFFFFFFFL
//SQ_BUF_RSRC_WORD3
#define SQ_BUF_RSRC_WORD3__DST_SEL_X__SHIFT                                                                   0x0
#define SQ_BUF_RSRC_WORD3__DST_SEL_Y__SHIFT                                                                   0x3
#define SQ_BUF_RSRC_WORD3__DST_SEL_Z__SHIFT                                                                   0x6
#define SQ_BUF_RSRC_WORD3__DST_SEL_W__SHIFT                                                                   0x9
#define SQ_BUF_RSRC_WORD3__NUM_FORMAT__SHIFT                                                                  0xc
#define SQ_BUF_RSRC_WORD3__DATA_FORMAT__SHIFT                                                                 0xf
#define SQ_BUF_RSRC_WORD3__USER_VM_ENABLE__SHIFT                                                              0x13
#define SQ_BUF_RSRC_WORD3__USER_VM_MODE__SHIFT                                                                0x14
#define SQ_BUF_RSRC_WORD3__INDEX_STRIDE__SHIFT                                                                0x15
#define SQ_BUF_RSRC_WORD3__ADD_TID_ENABLE__SHIFT                                                              0x17
#define SQ_BUF_RSRC_WORD3__NV__SHIFT                                                                          0x1b
#define SQ_BUF_RSRC_WORD3__TYPE__SHIFT                                                                        0x1e
#define SQ_BUF_RSRC_WORD3__DST_SEL_X_MASK                                                                     0x00000007L
#define SQ_BUF_RSRC_WORD3__DST_SEL_Y_MASK                                                                     0x00000038L
#define SQ_BUF_RSRC_WORD3__DST_SEL_Z_MASK                                                                     0x000001C0L
#define SQ_BUF_RSRC_WORD3__DST_SEL_W_MASK                                                                     0x00000E00L
#define SQ_BUF_RSRC_WORD3__NUM_FORMAT_MASK                                                                    0x00007000L
#define SQ_BUF_RSRC_WORD3__DATA_FORMAT_MASK                                                                   0x00078000L
#define SQ_BUF_RSRC_WORD3__USER_VM_ENABLE_MASK                                                                0x00080000L
#define SQ_BUF_RSRC_WORD3__USER_VM_MODE_MASK                                                                  0x00100000L
#define SQ_BUF_RSRC_WORD3__INDEX_STRIDE_MASK                                                                  0x00600000L
#define SQ_BUF_RSRC_WORD3__ADD_TID_ENABLE_MASK                                                                0x00800000L
#define SQ_BUF_RSRC_WORD3__NV_MASK                                                                            0x08000000L
#define SQ_BUF_RSRC_WORD3__TYPE_MASK                                                                          0xC0000000L
//SQ_IMG_RSRC_WORD0
#define SQ_IMG_RSRC_WORD0__BASE_ADDRESS__SHIFT                                                                0x0
#define SQ_IMG_RSRC_WORD0__BASE_ADDRESS_MASK                                                                  0xFFFFFFFFL
//SQ_IMG_RSRC_WORD1
#define SQ_IMG_RSRC_WORD1__BASE_ADDRESS_HI__SHIFT                                                             0x0
#define SQ_IMG_RSRC_WORD1__MIN_LOD__SHIFT                                                                     0x8
#define SQ_IMG_RSRC_WORD1__DATA_FORMAT__SHIFT                                                                 0x14
#define SQ_IMG_RSRC_WORD1__NUM_FORMAT__SHIFT                                                                  0x1a
#define SQ_IMG_RSRC_WORD1__NV__SHIFT                                                                          0x1e
#define SQ_IMG_RSRC_WORD1__META_DIRECT__SHIFT                                                                 0x1f
#define SQ_IMG_RSRC_WORD1__BASE_ADDRESS_HI_MASK                                                               0x000000FFL
#define SQ_IMG_RSRC_WORD1__MIN_LOD_MASK                                                                       0x000FFF00L
#define SQ_IMG_RSRC_WORD1__DATA_FORMAT_MASK                                                                   0x03F00000L
#define SQ_IMG_RSRC_WORD1__NUM_FORMAT_MASK                                                                    0x3C000000L
#define SQ_IMG_RSRC_WORD1__NV_MASK                                                                            0x40000000L
#define SQ_IMG_RSRC_WORD1__META_DIRECT_MASK                                                                   0x80000000L
//SQ_IMG_RSRC_WORD2
#define SQ_IMG_RSRC_WORD2__WIDTH__SHIFT                                                                       0x0
#define SQ_IMG_RSRC_WORD2__HEIGHT__SHIFT                                                                      0xe
#define SQ_IMG_RSRC_WORD2__PERF_MOD__SHIFT                                                                    0x1c
#define SQ_IMG_RSRC_WORD2__WIDTH_MASK                                                                         0x00003FFFL
#define SQ_IMG_RSRC_WORD2__HEIGHT_MASK                                                                        0x0FFFC000L
#define SQ_IMG_RSRC_WORD2__PERF_MOD_MASK                                                                      0x70000000L
//SQ_IMG_RSRC_WORD3
#define SQ_IMG_RSRC_WORD3__DST_SEL_X__SHIFT                                                                   0x0
#define SQ_IMG_RSRC_WORD3__DST_SEL_Y__SHIFT                                                                   0x3
#define SQ_IMG_RSRC_WORD3__DST_SEL_Z__SHIFT                                                                   0x6
#define SQ_IMG_RSRC_WORD3__DST_SEL_W__SHIFT                                                                   0x9
#define SQ_IMG_RSRC_WORD3__BASE_LEVEL__SHIFT                                                                  0xc
#define SQ_IMG_RSRC_WORD3__LAST_LEVEL__SHIFT                                                                  0x10
#define SQ_IMG_RSRC_WORD3__SW_MODE__SHIFT                                                                     0x14
#define SQ_IMG_RSRC_WORD3__TYPE__SHIFT                                                                        0x1c
#define SQ_IMG_RSRC_WORD3__DST_SEL_X_MASK                                                                     0x00000007L
#define SQ_IMG_RSRC_WORD3__DST_SEL_Y_MASK                                                                     0x00000038L
#define SQ_IMG_RSRC_WORD3__DST_SEL_Z_MASK                                                                     0x000001C0L
#define SQ_IMG_RSRC_WORD3__DST_SEL_W_MASK                                                                     0x00000E00L
#define SQ_IMG_RSRC_WORD3__BASE_LEVEL_MASK                                                                    0x0000F000L
#define SQ_IMG_RSRC_WORD3__LAST_LEVEL_MASK                                                                    0x000F0000L
#define SQ_IMG_RSRC_WORD3__SW_MODE_MASK                                                                       0x01F00000L
#define SQ_IMG_RSRC_WORD3__TYPE_MASK                                                                          0xF0000000L
//SQ_IMG_RSRC_WORD4
#define SQ_IMG_RSRC_WORD4__DEPTH__SHIFT                                                                       0x0
#define SQ_IMG_RSRC_WORD4__PITCH__SHIFT                                                                       0xd
#define SQ_IMG_RSRC_WORD4__BC_SWIZZLE__SHIFT                                                                  0x1d
#define SQ_IMG_RSRC_WORD4__DEPTH_MASK                                                                         0x00001FFFL
#define SQ_IMG_RSRC_WORD4__PITCH_MASK                                                                         0x1FFFE000L
#define SQ_IMG_RSRC_WORD4__BC_SWIZZLE_MASK                                                                    0xE0000000L
//SQ_IMG_RSRC_WORD5
#define SQ_IMG_RSRC_WORD5__BASE_ARRAY__SHIFT                                                                  0x0
#define SQ_IMG_RSRC_WORD5__ARRAY_PITCH__SHIFT                                                                 0xd
#define SQ_IMG_RSRC_WORD5__META_DATA_ADDRESS__SHIFT                                                           0x11
#define SQ_IMG_RSRC_WORD5__META_LINEAR__SHIFT                                                                 0x19
#define SQ_IMG_RSRC_WORD5__META_PIPE_ALIGNED__SHIFT                                                           0x1a
#define SQ_IMG_RSRC_WORD5__META_RB_ALIGNED__SHIFT                                                             0x1b
#define SQ_IMG_RSRC_WORD5__MAX_MIP__SHIFT                                                                     0x1c
#define SQ_IMG_RSRC_WORD5__BASE_ARRAY_MASK                                                                    0x00001FFFL
#define SQ_IMG_RSRC_WORD5__ARRAY_PITCH_MASK                                                                   0x0001E000L
#define SQ_IMG_RSRC_WORD5__META_DATA_ADDRESS_MASK                                                             0x01FE0000L
#define SQ_IMG_RSRC_WORD5__META_LINEAR_MASK                                                                   0x02000000L
#define SQ_IMG_RSRC_WORD5__META_PIPE_ALIGNED_MASK                                                             0x04000000L
#define SQ_IMG_RSRC_WORD5__META_RB_ALIGNED_MASK                                                               0x08000000L
#define SQ_IMG_RSRC_WORD5__MAX_MIP_MASK                                                                       0xF0000000L
//SQ_IMG_RSRC_WORD6
#define SQ_IMG_RSRC_WORD6__MIN_LOD_WARN__SHIFT                                                                0x0
#define SQ_IMG_RSRC_WORD6__COUNTER_BANK_ID__SHIFT                                                             0xc
#define SQ_IMG_RSRC_WORD6__LOD_HDW_CNT_EN__SHIFT                                                              0x14
#define SQ_IMG_RSRC_WORD6__COMPRESSION_EN__SHIFT                                                              0x15
#define SQ_IMG_RSRC_WORD6__ALPHA_IS_ON_MSB__SHIFT                                                             0x16
#define SQ_IMG_RSRC_WORD6__COLOR_TRANSFORM__SHIFT                                                             0x17
#define SQ_IMG_RSRC_WORD6__LOST_ALPHA_BITS__SHIFT                                                             0x18
#define SQ_IMG_RSRC_WORD6__LOST_COLOR_BITS__SHIFT                                                             0x1c
#define SQ_IMG_RSRC_WORD6__MIN_LOD_WARN_MASK                                                                  0x00000FFFL
#define SQ_IMG_RSRC_WORD6__COUNTER_BANK_ID_MASK                                                               0x000FF000L
#define SQ_IMG_RSRC_WORD6__LOD_HDW_CNT_EN_MASK                                                                0x00100000L
#define SQ_IMG_RSRC_WORD6__COMPRESSION_EN_MASK                                                                0x00200000L
#define SQ_IMG_RSRC_WORD6__ALPHA_IS_ON_MSB_MASK                                                               0x00400000L
#define SQ_IMG_RSRC_WORD6__COLOR_TRANSFORM_MASK                                                               0x00800000L
#define SQ_IMG_RSRC_WORD6__LOST_ALPHA_BITS_MASK                                                               0x0F000000L
#define SQ_IMG_RSRC_WORD6__LOST_COLOR_BITS_MASK                                                               0xF0000000L
//SQ_IMG_RSRC_WORD7
#define SQ_IMG_RSRC_WORD7__META_DATA_ADDRESS__SHIFT                                                           0x0
#define SQ_IMG_RSRC_WORD7__META_DATA_ADDRESS_MASK                                                             0xFFFFFFFFL
//SQ_IMG_SAMP_WORD0
#define SQ_IMG_SAMP_WORD0__CLAMP_X__SHIFT                                                                     0x0
#define SQ_IMG_SAMP_WORD0__CLAMP_Y__SHIFT                                                                     0x3
#define SQ_IMG_SAMP_WORD0__CLAMP_Z__SHIFT                                                                     0x6
#define SQ_IMG_SAMP_WORD0__MAX_ANISO_RATIO__SHIFT                                                             0x9
#define SQ_IMG_SAMP_WORD0__DEPTH_COMPARE_FUNC__SHIFT                                                          0xc
#define SQ_IMG_SAMP_WORD0__FORCE_UNNORMALIZED__SHIFT                                                          0xf
#define SQ_IMG_SAMP_WORD0__ANISO_THRESHOLD__SHIFT                                                             0x10
#define SQ_IMG_SAMP_WORD0__MC_COORD_TRUNC__SHIFT                                                              0x13
#define SQ_IMG_SAMP_WORD0__FORCE_DEGAMMA__SHIFT                                                               0x14
#define SQ_IMG_SAMP_WORD0__ANISO_BIAS__SHIFT                                                                  0x15
#define SQ_IMG_SAMP_WORD0__TRUNC_COORD__SHIFT                                                                 0x1b
#define SQ_IMG_SAMP_WORD0__DISABLE_CUBE_WRAP__SHIFT                                                           0x1c
#define SQ_IMG_SAMP_WORD0__FILTER_MODE__SHIFT                                                                 0x1d
#define SQ_IMG_SAMP_WORD0__COMPAT_MODE__SHIFT                                                                 0x1f
#define SQ_IMG_SAMP_WORD0__CLAMP_X_MASK                                                                       0x00000007L
#define SQ_IMG_SAMP_WORD0__CLAMP_Y_MASK                                                                       0x00000038L
#define SQ_IMG_SAMP_WORD0__CLAMP_Z_MASK                                                                       0x000001C0L
#define SQ_IMG_SAMP_WORD0__MAX_ANISO_RATIO_MASK                                                               0x00000E00L
#define SQ_IMG_SAMP_WORD0__DEPTH_COMPARE_FUNC_MASK                                                            0x00007000L
#define SQ_IMG_SAMP_WORD0__FORCE_UNNORMALIZED_MASK                                                            0x00008000L
#define SQ_IMG_SAMP_WORD0__ANISO_THRESHOLD_MASK                                                               0x00070000L
#define SQ_IMG_SAMP_WORD0__MC_COORD_TRUNC_MASK                                                                0x00080000L
#define SQ_IMG_SAMP_WORD0__FORCE_DEGAMMA_MASK                                                                 0x00100000L
#define SQ_IMG_SAMP_WORD0__ANISO_BIAS_MASK                                                                    0x07E00000L
#define SQ_IMG_SAMP_WORD0__TRUNC_COORD_MASK                                                                   0x08000000L
#define SQ_IMG_SAMP_WORD0__DISABLE_CUBE_WRAP_MASK                                                             0x10000000L
#define SQ_IMG_SAMP_WORD0__FILTER_MODE_MASK                                                                   0x60000000L
#define SQ_IMG_SAMP_WORD0__COMPAT_MODE_MASK                                                                   0x80000000L
//SQ_IMG_SAMP_WORD1
#define SQ_IMG_SAMP_WORD1__MIN_LOD__SHIFT                                                                     0x0
#define SQ_IMG_SAMP_WORD1__MAX_LOD__SHIFT                                                                     0xc
#define SQ_IMG_SAMP_WORD1__PERF_MIP__SHIFT                                                                    0x18
#define SQ_IMG_SAMP_WORD1__PERF_Z__SHIFT                                                                      0x1c
#define SQ_IMG_SAMP_WORD1__MIN_LOD_MASK                                                                       0x00000FFFL
#define SQ_IMG_SAMP_WORD1__MAX_LOD_MASK                                                                       0x00FFF000L
#define SQ_IMG_SAMP_WORD1__PERF_MIP_MASK                                                                      0x0F000000L
#define SQ_IMG_SAMP_WORD1__PERF_Z_MASK                                                                        0xF0000000L
//SQ_IMG_SAMP_WORD2
#define SQ_IMG_SAMP_WORD2__LOD_BIAS__SHIFT                                                                    0x0
#define SQ_IMG_SAMP_WORD2__LOD_BIAS_SEC__SHIFT                                                                0xe
#define SQ_IMG_SAMP_WORD2__XY_MAG_FILTER__SHIFT                                                               0x14
#define SQ_IMG_SAMP_WORD2__XY_MIN_FILTER__SHIFT                                                               0x16
#define SQ_IMG_SAMP_WORD2__Z_FILTER__SHIFT                                                                    0x18
#define SQ_IMG_SAMP_WORD2__MIP_FILTER__SHIFT                                                                  0x1a
#define SQ_IMG_SAMP_WORD2__MIP_POINT_PRECLAMP__SHIFT                                                          0x1c
#define SQ_IMG_SAMP_WORD2__BLEND_ZERO_PRT__SHIFT                                                              0x1d
#define SQ_IMG_SAMP_WORD2__FILTER_PREC_FIX__SHIFT                                                             0x1e
#define SQ_IMG_SAMP_WORD2__ANISO_OVERRIDE__SHIFT                                                              0x1f
#define SQ_IMG_SAMP_WORD2__LOD_BIAS_MASK                                                                      0x00003FFFL
#define SQ_IMG_SAMP_WORD2__LOD_BIAS_SEC_MASK                                                                  0x000FC000L
#define SQ_IMG_SAMP_WORD2__XY_MAG_FILTER_MASK                                                                 0x00300000L
#define SQ_IMG_SAMP_WORD2__XY_MIN_FILTER_MASK                                                                 0x00C00000L
#define SQ_IMG_SAMP_WORD2__Z_FILTER_MASK                                                                      0x03000000L
#define SQ_IMG_SAMP_WORD2__MIP_FILTER_MASK                                                                    0x0C000000L
#define SQ_IMG_SAMP_WORD2__MIP_POINT_PRECLAMP_MASK                                                            0x10000000L
#define SQ_IMG_SAMP_WORD2__BLEND_ZERO_PRT_MASK                                                                0x20000000L
#define SQ_IMG_SAMP_WORD2__FILTER_PREC_FIX_MASK                                                               0x40000000L
#define SQ_IMG_SAMP_WORD2__ANISO_OVERRIDE_MASK                                                                0x80000000L
//SQ_IMG_SAMP_WORD3
#define SQ_IMG_SAMP_WORD3__BORDER_COLOR_PTR__SHIFT                                                            0x0
#define SQ_IMG_SAMP_WORD3__SKIP_DEGAMMA__SHIFT                                                                0xc
#define SQ_IMG_SAMP_WORD3__BORDER_COLOR_TYPE__SHIFT                                                           0x1e
#define SQ_IMG_SAMP_WORD3__BORDER_COLOR_PTR_MASK                                                              0x00000FFFL
#define SQ_IMG_SAMP_WORD3__SKIP_DEGAMMA_MASK                                                                  0x00001000L
#define SQ_IMG_SAMP_WORD3__BORDER_COLOR_TYPE_MASK                                                             0xC0000000L
//SQ_FLAT_SCRATCH_WORD0
#define SQ_FLAT_SCRATCH_WORD0__SIZE__SHIFT                                                                    0x0
#define SQ_FLAT_SCRATCH_WORD0__SIZE_MASK                                                                      0x0007FFFFL
//SQ_FLAT_SCRATCH_WORD1
#define SQ_FLAT_SCRATCH_WORD1__OFFSET__SHIFT                                                                  0x0
#define SQ_FLAT_SCRATCH_WORD1__OFFSET_MASK                                                                    0x00FFFFFFL
//SQ_M0_GPR_IDX_WORD
#define SQ_M0_GPR_IDX_WORD__INDEX__SHIFT                                                                      0x0
#define SQ_M0_GPR_IDX_WORD__VSRC0_REL__SHIFT                                                                  0xc
#define SQ_M0_GPR_IDX_WORD__VSRC1_REL__SHIFT                                                                  0xd
#define SQ_M0_GPR_IDX_WORD__VSRC2_REL__SHIFT                                                                  0xe
#define SQ_M0_GPR_IDX_WORD__VDST_REL__SHIFT                                                                   0xf
#define SQ_M0_GPR_IDX_WORD__INDEX_MASK                                                                        0x000000FFL
#define SQ_M0_GPR_IDX_WORD__VSRC0_REL_MASK                                                                    0x00001000L
#define SQ_M0_GPR_IDX_WORD__VSRC1_REL_MASK                                                                    0x00002000L
#define SQ_M0_GPR_IDX_WORD__VSRC2_REL_MASK                                                                    0x00004000L
#define SQ_M0_GPR_IDX_WORD__VDST_REL_MASK                                                                     0x00008000L
//SQC_ICACHE_UTCL1_CNTL1
#define SQC_ICACHE_UTCL1_CNTL1__FORCE_4K_L2_RESP__SHIFT                                                       0x0
#define SQC_ICACHE_UTCL1_CNTL1__GPUVM_64K_DEF__SHIFT                                                          0x1
#define SQC_ICACHE_UTCL1_CNTL1__GPUVM_PERM_MODE__SHIFT                                                        0x2
#define SQC_ICACHE_UTCL1_CNTL1__RESP_MODE__SHIFT                                                              0x3
#define SQC_ICACHE_UTCL1_CNTL1__RESP_FAULT_MODE__SHIFT                                                        0x5
#define SQC_ICACHE_UTCL1_CNTL1__CLIENTID__SHIFT                                                               0x7
#define SQC_ICACHE_UTCL1_CNTL1__ENABLE_PUSH_LFIFO__SHIFT                                                      0x11
#define SQC_ICACHE_UTCL1_CNTL1__ENABLE_LFIFO_PRI_ARB__SHIFT                                                   0x12
#define SQC_ICACHE_UTCL1_CNTL1__REG_INVALIDATE_VMID__SHIFT                                                    0x13
#define SQC_ICACHE_UTCL1_CNTL1__REG_INVALIDATE_ALL_VMID__SHIFT                                                0x17
#define SQC_ICACHE_UTCL1_CNTL1__REG_INVALIDATE_TOGGLE__SHIFT                                                  0x18
#define SQC_ICACHE_UTCL1_CNTL1__CLIENT_INVALIDATE_ALL_VMID__SHIFT                                             0x19
#define SQC_ICACHE_UTCL1_CNTL1__FORCE_MISS__SHIFT                                                             0x1a
#define SQC_ICACHE_UTCL1_CNTL1__FORCE_IN_ORDER__SHIFT                                                         0x1b
#define SQC_ICACHE_UTCL1_CNTL1__REDUCE_FIFO_DEPTH_BY_2__SHIFT                                                 0x1c
#define SQC_ICACHE_UTCL1_CNTL1__REDUCE_CACHE_SIZE_BY_2__SHIFT                                                 0x1e
#define SQC_ICACHE_UTCL1_CNTL1__FORCE_4K_L2_RESP_MASK                                                         0x00000001L
#define SQC_ICACHE_UTCL1_CNTL1__GPUVM_64K_DEF_MASK                                                            0x00000002L
#define SQC_ICACHE_UTCL1_CNTL1__GPUVM_PERM_MODE_MASK                                                          0x00000004L
#define SQC_ICACHE_UTCL1_CNTL1__RESP_MODE_MASK                                                                0x00000018L
#define SQC_ICACHE_UTCL1_CNTL1__RESP_FAULT_MODE_MASK                                                          0x00000060L
#define SQC_ICACHE_UTCL1_CNTL1__CLIENTID_MASK                                                                 0x0000FF80L
#define SQC_ICACHE_UTCL1_CNTL1__ENABLE_PUSH_LFIFO_MASK                                                        0x00020000L
#define SQC_ICACHE_UTCL1_CNTL1__ENABLE_LFIFO_PRI_ARB_MASK                                                     0x00040000L
#define SQC_ICACHE_UTCL1_CNTL1__REG_INVALIDATE_VMID_MASK                                                      0x00780000L
#define SQC_ICACHE_UTCL1_CNTL1__REG_INVALIDATE_ALL_VMID_MASK                                                  0x00800000L
#define SQC_ICACHE_UTCL1_CNTL1__REG_INVALIDATE_TOGGLE_MASK                                                    0x01000000L
#define SQC_ICACHE_UTCL1_CNTL1__CLIENT_INVALIDATE_ALL_VMID_MASK                                               0x02000000L
#define SQC_ICACHE_UTCL1_CNTL1__FORCE_MISS_MASK                                                               0x04000000L
#define SQC_ICACHE_UTCL1_CNTL1__FORCE_IN_ORDER_MASK                                                           0x08000000L
#define SQC_ICACHE_UTCL1_CNTL1__REDUCE_FIFO_DEPTH_BY_2_MASK                                                   0x30000000L
#define SQC_ICACHE_UTCL1_CNTL1__REDUCE_CACHE_SIZE_BY_2_MASK                                                   0xC0000000L
//SQC_ICACHE_UTCL1_CNTL2
#define SQC_ICACHE_UTCL1_CNTL2__SPARE__SHIFT                                                                  0x0
#define SQC_ICACHE_UTCL1_CNTL2__LFIFO_SCAN_DISABLE__SHIFT                                                     0x8
#define SQC_ICACHE_UTCL1_CNTL2__MTYPE_OVRD_DIS__SHIFT                                                         0x9
#define SQC_ICACHE_UTCL1_CNTL2__LINE_VALID__SHIFT                                                             0xa
#define SQC_ICACHE_UTCL1_CNTL2__DIS_EDC__SHIFT                                                                0xb
#define SQC_ICACHE_UTCL1_CNTL2__GPUVM_INV_MODE__SHIFT                                                         0xc
#define SQC_ICACHE_UTCL1_CNTL2__SHOOTDOWN_OPT__SHIFT                                                          0xd
#define SQC_ICACHE_UTCL1_CNTL2__FORCE_SNOOP__SHIFT                                                            0xe
#define SQC_ICACHE_UTCL1_CNTL2__FORCE_GPUVM_INV_ACK__SHIFT                                                    0xf
#define SQC_ICACHE_UTCL1_CNTL2__ARB_BURST_MODE__SHIFT                                                         0x10
#define SQC_ICACHE_UTCL1_CNTL2__ENABLE_PERF_EVENT_RD_WR__SHIFT                                                0x12
#define SQC_ICACHE_UTCL1_CNTL2__PERF_EVENT_RD_WR__SHIFT                                                       0x13
#define SQC_ICACHE_UTCL1_CNTL2__ENABLE_PERF_EVENT_VMID__SHIFT                                                 0x14
#define SQC_ICACHE_UTCL1_CNTL2__PERF_EVENT_VMID__SHIFT                                                        0x15
#define SQC_ICACHE_UTCL1_CNTL2__FORCE_FRAG_2M_TO_64K__SHIFT                                                   0x1a
#define SQC_ICACHE_UTCL1_CNTL2__SPARE_MASK                                                                    0x000000FFL
#define SQC_ICACHE_UTCL1_CNTL2__LFIFO_SCAN_DISABLE_MASK                                                       0x00000100L
#define SQC_ICACHE_UTCL1_CNTL2__MTYPE_OVRD_DIS_MASK                                                           0x00000200L
#define SQC_ICACHE_UTCL1_CNTL2__LINE_VALID_MASK                                                               0x00000400L
#define SQC_ICACHE_UTCL1_CNTL2__DIS_EDC_MASK                                                                  0x00000800L
#define SQC_ICACHE_UTCL1_CNTL2__GPUVM_INV_MODE_MASK                                                           0x00001000L
#define SQC_ICACHE_UTCL1_CNTL2__SHOOTDOWN_OPT_MASK                                                            0x00002000L
#define SQC_ICACHE_UTCL1_CNTL2__FORCE_SNOOP_MASK                                                              0x00004000L
#define SQC_ICACHE_UTCL1_CNTL2__FORCE_GPUVM_INV_ACK_MASK                                                      0x00008000L
#define SQC_ICACHE_UTCL1_CNTL2__ARB_BURST_MODE_MASK                                                           0x00030000L
#define SQC_ICACHE_UTCL1_CNTL2__ENABLE_PERF_EVENT_RD_WR_MASK                                                  0x00040000L
#define SQC_ICACHE_UTCL1_CNTL2__PERF_EVENT_RD_WR_MASK                                                         0x00080000L
#define SQC_ICACHE_UTCL1_CNTL2__ENABLE_PERF_EVENT_VMID_MASK                                                   0x00100000L
#define SQC_ICACHE_UTCL1_CNTL2__PERF_EVENT_VMID_MASK                                                          0x01E00000L
#define SQC_ICACHE_UTCL1_CNTL2__FORCE_FRAG_2M_TO_64K_MASK                                                     0x04000000L
//SQC_DCACHE_UTCL1_CNTL1
#define SQC_DCACHE_UTCL1_CNTL1__FORCE_4K_L2_RESP__SHIFT                                                       0x0
#define SQC_DCACHE_UTCL1_CNTL1__GPUVM_64K_DEF__SHIFT                                                          0x1
#define SQC_DCACHE_UTCL1_CNTL1__GPUVM_PERM_MODE__SHIFT                                                        0x2
#define SQC_DCACHE_UTCL1_CNTL1__RESP_MODE__SHIFT                                                              0x3
#define SQC_DCACHE_UTCL1_CNTL1__RESP_FAULT_MODE__SHIFT                                                        0x5
#define SQC_DCACHE_UTCL1_CNTL1__CLIENTID__SHIFT                                                               0x7
#define SQC_DCACHE_UTCL1_CNTL1__ENABLE_PUSH_LFIFO__SHIFT                                                      0x11
#define SQC_DCACHE_UTCL1_CNTL1__ENABLE_LFIFO_PRI_ARB__SHIFT                                                   0x12
#define SQC_DCACHE_UTCL1_CNTL1__REG_INVALIDATE_VMID__SHIFT                                                    0x13
#define SQC_DCACHE_UTCL1_CNTL1__REG_INVALIDATE_ALL_VMID__SHIFT                                                0x17
#define SQC_DCACHE_UTCL1_CNTL1__REG_INVALIDATE_TOGGLE__SHIFT                                                  0x18
#define SQC_DCACHE_UTCL1_CNTL1__CLIENT_INVALIDATE_ALL_VMID__SHIFT                                             0x19
#define SQC_DCACHE_UTCL1_CNTL1__FORCE_MISS__SHIFT                                                             0x1a
#define SQC_DCACHE_UTCL1_CNTL1__FORCE_IN_ORDER__SHIFT                                                         0x1b
#define SQC_DCACHE_UTCL1_CNTL1__REDUCE_FIFO_DEPTH_BY_2__SHIFT                                                 0x1c
#define SQC_DCACHE_UTCL1_CNTL1__REDUCE_CACHE_SIZE_BY_2__SHIFT                                                 0x1e
#define SQC_DCACHE_UTCL1_CNTL1__FORCE_4K_L2_RESP_MASK                                                         0x00000001L
#define SQC_DCACHE_UTCL1_CNTL1__GPUVM_64K_DEF_MASK                                                            0x00000002L
#define SQC_DCACHE_UTCL1_CNTL1__GPUVM_PERM_MODE_MASK                                                          0x00000004L
#define SQC_DCACHE_UTCL1_CNTL1__RESP_MODE_MASK                                                                0x00000018L
#define SQC_DCACHE_UTCL1_CNTL1__RESP_FAULT_MODE_MASK                                                          0x00000060L
#define SQC_DCACHE_UTCL1_CNTL1__CLIENTID_MASK                                                                 0x0000FF80L
#define SQC_DCACHE_UTCL1_CNTL1__ENABLE_PUSH_LFIFO_MASK                                                        0x00020000L
#define SQC_DCACHE_UTCL1_CNTL1__ENABLE_LFIFO_PRI_ARB_MASK                                                     0x00040000L
#define SQC_DCACHE_UTCL1_CNTL1__REG_INVALIDATE_VMID_MASK                                                      0x00780000L
#define SQC_DCACHE_UTCL1_CNTL1__REG_INVALIDATE_ALL_VMID_MASK                                                  0x00800000L
#define SQC_DCACHE_UTCL1_CNTL1__REG_INVALIDATE_TOGGLE_MASK                                                    0x01000000L
#define SQC_DCACHE_UTCL1_CNTL1__CLIENT_INVALIDATE_ALL_VMID_MASK                                               0x02000000L
#define SQC_DCACHE_UTCL1_CNTL1__FORCE_MISS_MASK                                                               0x04000000L
#define SQC_DCACHE_UTCL1_CNTL1__FORCE_IN_ORDER_MASK                                                           0x08000000L
#define SQC_DCACHE_UTCL1_CNTL1__REDUCE_FIFO_DEPTH_BY_2_MASK                                                   0x30000000L
#define SQC_DCACHE_UTCL1_CNTL1__REDUCE_CACHE_SIZE_BY_2_MASK                                                   0xC0000000L
//SQC_DCACHE_UTCL1_CNTL2
#define SQC_DCACHE_UTCL1_CNTL2__SPARE__SHIFT                                                                  0x0
#define SQC_DCACHE_UTCL1_CNTL2__LFIFO_SCAN_DISABLE__SHIFT                                                     0x8
#define SQC_DCACHE_UTCL1_CNTL2__MTYPE_OVRD_DIS__SHIFT                                                         0x9
#define SQC_DCACHE_UTCL1_CNTL2__LINE_VALID__SHIFT                                                             0xa
#define SQC_DCACHE_UTCL1_CNTL2__DIS_EDC__SHIFT                                                                0xb
#define SQC_DCACHE_UTCL1_CNTL2__GPUVM_INV_MODE__SHIFT                                                         0xc
#define SQC_DCACHE_UTCL1_CNTL2__SHOOTDOWN_OPT__SHIFT                                                          0xd
#define SQC_DCACHE_UTCL1_CNTL2__FORCE_SNOOP__SHIFT                                                            0xe
#define SQC_DCACHE_UTCL1_CNTL2__FORCE_GPUVM_INV_ACK__SHIFT                                                    0xf
#define SQC_DCACHE_UTCL1_CNTL2__ARB_BURST_MODE__SHIFT                                                         0x10
#define SQC_DCACHE_UTCL1_CNTL2__ENABLE_PERF_EVENT_RD_WR__SHIFT                                                0x12
#define SQC_DCACHE_UTCL1_CNTL2__PERF_EVENT_RD_WR__SHIFT                                                       0x13
#define SQC_DCACHE_UTCL1_CNTL2__ENABLE_PERF_EVENT_VMID__SHIFT                                                 0x14
#define SQC_DCACHE_UTCL1_CNTL2__PERF_EVENT_VMID__SHIFT                                                        0x15
#define SQC_DCACHE_UTCL1_CNTL2__FORCE_FRAG_2M_TO_64K__SHIFT                                                   0x1a
#define SQC_DCACHE_UTCL1_CNTL2__SPARE_MASK                                                                    0x000000FFL
#define SQC_DCACHE_UTCL1_CNTL2__LFIFO_SCAN_DISABLE_MASK                                                       0x00000100L
#define SQC_DCACHE_UTCL1_CNTL2__MTYPE_OVRD_DIS_MASK                                                           0x00000200L
#define SQC_DCACHE_UTCL1_CNTL2__LINE_VALID_MASK                                                               0x00000400L
#define SQC_DCACHE_UTCL1_CNTL2__DIS_EDC_MASK                                                                  0x00000800L
#define SQC_DCACHE_UTCL1_CNTL2__GPUVM_INV_MODE_MASK                                                           0x00001000L
#define SQC_DCACHE_UTCL1_CNTL2__SHOOTDOWN_OPT_MASK                                                            0x00002000L
#define SQC_DCACHE_UTCL1_CNTL2__FORCE_SNOOP_MASK                                                              0x00004000L
#define SQC_DCACHE_UTCL1_CNTL2__FORCE_GPUVM_INV_ACK_MASK                                                      0x00008000L
#define SQC_DCACHE_UTCL1_CNTL2__ARB_BURST_MODE_MASK                                                           0x00030000L
#define SQC_DCACHE_UTCL1_CNTL2__ENABLE_PERF_EVENT_RD_WR_MASK                                                  0x00040000L
#define SQC_DCACHE_UTCL1_CNTL2__PERF_EVENT_RD_WR_MASK                                                         0x00080000L
#define SQC_DCACHE_UTCL1_CNTL2__ENABLE_PERF_EVENT_VMID_MASK                                                   0x00100000L
#define SQC_DCACHE_UTCL1_CNTL2__PERF_EVENT_VMID_MASK                                                          0x01E00000L
#define SQC_DCACHE_UTCL1_CNTL2__FORCE_FRAG_2M_TO_64K_MASK                                                     0x04000000L
//SQC_ICACHE_UTCL1_STATUS
#define SQC_ICACHE_UTCL1_STATUS__FAULT_DETECTED__SHIFT                                                        0x0
#define SQC_ICACHE_UTCL1_STATUS__RETRY_DETECTED__SHIFT                                                        0x1
#define SQC_ICACHE_UTCL1_STATUS__PRT_DETECTED__SHIFT                                                          0x2
#define SQC_ICACHE_UTCL1_STATUS__FAULT_DETECTED_MASK                                                          0x00000001L
#define SQC_ICACHE_UTCL1_STATUS__RETRY_DETECTED_MASK                                                          0x00000002L
#define SQC_ICACHE_UTCL1_STATUS__PRT_DETECTED_MASK                                                            0x00000004L
//SQC_DCACHE_UTCL1_STATUS
#define SQC_DCACHE_UTCL1_STATUS__FAULT_DETECTED__SHIFT                                                        0x0
#define SQC_DCACHE_UTCL1_STATUS__RETRY_DETECTED__SHIFT                                                        0x1
#define SQC_DCACHE_UTCL1_STATUS__PRT_DETECTED__SHIFT                                                          0x2
#define SQC_DCACHE_UTCL1_STATUS__FAULT_DETECTED_MASK                                                          0x00000001L
#define SQC_DCACHE_UTCL1_STATUS__RETRY_DETECTED_MASK                                                          0x00000002L
#define SQC_DCACHE_UTCL1_STATUS__PRT_DETECTED_MASK                                                            0x00000004L


// addressBlock: gc_shsdec
//SX_DEBUG_1
#define SX_DEBUG_1__SX_DB_QUAD_CREDIT__SHIFT                                                                  0x0
#define SX_DEBUG_1__DISABLE_BLEND_OPT_DONT_RD_DST__SHIFT                                                      0x8
#define SX_DEBUG_1__DISABLE_BLEND_OPT_BYPASS__SHIFT                                                           0x9
#define SX_DEBUG_1__DISABLE_BLEND_OPT_DISCARD_PIXEL__SHIFT                                                    0xa
#define SX_DEBUG_1__DISABLE_QUAD_PAIR_OPT__SHIFT                                                              0xb
#define SX_DEBUG_1__DISABLE_PIX_EN_ZERO_OPT__SHIFT                                                            0xc
#define SX_DEBUG_1__PC_CFG__SHIFT                                                                             0xd
#define SX_DEBUG_1__DEBUG_DATA__SHIFT                                                                         0xe
#define SX_DEBUG_1__SX_DB_QUAD_CREDIT_MASK                                                                    0x0000007FL
#define SX_DEBUG_1__DISABLE_BLEND_OPT_DONT_RD_DST_MASK                                                        0x00000100L
#define SX_DEBUG_1__DISABLE_BLEND_OPT_BYPASS_MASK                                                             0x00000200L
#define SX_DEBUG_1__DISABLE_BLEND_OPT_DISCARD_PIXEL_MASK                                                      0x00000400L
#define SX_DEBUG_1__DISABLE_QUAD_PAIR_OPT_MASK                                                                0x00000800L
#define SX_DEBUG_1__DISABLE_PIX_EN_ZERO_OPT_MASK                                                              0x00001000L
#define SX_DEBUG_1__PC_CFG_MASK                                                                               0x00002000L
#define SX_DEBUG_1__DEBUG_DATA_MASK                                                                           0xFFFFC000L
//SPI_PS_MAX_WAVE_ID
#define SPI_PS_MAX_WAVE_ID__MAX_WAVE_ID__SHIFT                                                                0x0
#define SPI_PS_MAX_WAVE_ID__MAX_COLLISION_WAVE_ID__SHIFT                                                      0x10
#define SPI_PS_MAX_WAVE_ID__MAX_WAVE_ID_MASK                                                                  0x00000FFFL
#define SPI_PS_MAX_WAVE_ID__MAX_COLLISION_WAVE_ID_MASK                                                        0x03FF0000L
//SPI_START_PHASE
#define SPI_START_PHASE__VGPR_START_PHASE__SHIFT                                                              0x0
#define SPI_START_PHASE__SGPR_START_PHASE__SHIFT                                                              0x2
#define SPI_START_PHASE__WAVE_START_PHASE__SHIFT                                                              0x4
#define SPI_START_PHASE__VGPR_START_PHASE_MASK                                                                0x00000003L
#define SPI_START_PHASE__SGPR_START_PHASE_MASK                                                                0x0000000CL
#define SPI_START_PHASE__WAVE_START_PHASE_MASK                                                                0x00000030L
//SPI_GFX_CNTL
#define SPI_GFX_CNTL__RESET_COUNTS__SHIFT                                                                     0x0
#define SPI_GFX_CNTL__RESET_COUNTS_MASK                                                                       0x00000001L
//SPI_DSM_CNTL
#define SPI_DSM_CNTL__SPI_SR_MEM_DSM_IRRITATOR_DATA__SHIFT                                                    0x0
#define SPI_DSM_CNTL__SPI_SR_MEM_ENABLE_SINGLE_WRITE__SHIFT                                                   0x2
#define SPI_DSM_CNTL__UNUSED__SHIFT                                                                           0x3
#define SPI_DSM_CNTL__SPI_SR_MEM_DSM_IRRITATOR_DATA_MASK                                                      0x00000003L
#define SPI_DSM_CNTL__SPI_SR_MEM_ENABLE_SINGLE_WRITE_MASK                                                     0x00000004L
#define SPI_DSM_CNTL__UNUSED_MASK                                                                             0xFFFFFFF8L
//SPI_DSM_CNTL2
#define SPI_DSM_CNTL2__SPI_SR_MEM_ENABLE_ERROR_INJECT__SHIFT                                                  0x0
#define SPI_DSM_CNTL2__SPI_SR_MEM_SELECT_INJECT_DELAY__SHIFT                                                  0x2
#define SPI_DSM_CNTL2__SPI_SR_MEM_INJECT_DELAY__SHIFT                                                         0x4
#define SPI_DSM_CNTL2__UNUSED__SHIFT                                                                          0xa
#define SPI_DSM_CNTL2__SPI_SR_MEM_ENABLE_ERROR_INJECT_MASK                                                    0x00000003L
#define SPI_DSM_CNTL2__SPI_SR_MEM_SELECT_INJECT_DELAY_MASK                                                    0x00000004L
#define SPI_DSM_CNTL2__SPI_SR_MEM_INJECT_DELAY_MASK                                                           0x000003F0L
#define SPI_DSM_CNTL2__UNUSED_MASK                                                                            0xFFFFFC00L
//SPI_EDC_CNT
#define SPI_EDC_CNT__SPI_SR_MEM_SED_COUNT__SHIFT                                                              0x0
#define SPI_EDC_CNT__SPI_SR_MEM_SED_COUNT_MASK                                                                0x00000003L
//SPI_CONFIG_PS_CU_EN
#define SPI_CONFIG_PS_CU_EN__ENABLE__SHIFT                                                                    0x0
#define SPI_CONFIG_PS_CU_EN__PKR0_CU_EN__SHIFT                                                                0x1
#define SPI_CONFIG_PS_CU_EN__PKR1_CU_EN__SHIFT                                                                0x10
#define SPI_CONFIG_PS_CU_EN__ENABLE_MASK                                                                      0x00000001L
#define SPI_CONFIG_PS_CU_EN__PKR0_CU_EN_MASK                                                                  0x0000FFFEL
#define SPI_CONFIG_PS_CU_EN__PKR1_CU_EN_MASK                                                                  0xFFFF0000L
//SPI_WF_LIFETIME_CNTL
#define SPI_WF_LIFETIME_CNTL__SAMPLE_PERIOD__SHIFT                                                            0x0
#define SPI_WF_LIFETIME_CNTL__EN__SHIFT                                                                       0x4
#define SPI_WF_LIFETIME_CNTL__SAMPLE_PERIOD_MASK                                                              0x0000000FL
#define SPI_WF_LIFETIME_CNTL__EN_MASK                                                                         0x00000010L
//SPI_WF_LIFETIME_LIMIT_0
#define SPI_WF_LIFETIME_LIMIT_0__MAX_CNT__SHIFT                                                               0x0
#define SPI_WF_LIFETIME_LIMIT_0__EN_WARN__SHIFT                                                               0x1f
#define SPI_WF_LIFETIME_LIMIT_0__MAX_CNT_MASK                                                                 0x7FFFFFFFL
#define SPI_WF_LIFETIME_LIMIT_0__EN_WARN_MASK                                                                 0x80000000L
//SPI_WF_LIFETIME_LIMIT_1
#define SPI_WF_LIFETIME_LIMIT_1__MAX_CNT__SHIFT                                                               0x0
#define SPI_WF_LIFETIME_LIMIT_1__EN_WARN__SHIFT                                                               0x1f
#define SPI_WF_LIFETIME_LIMIT_1__MAX_CNT_MASK                                                                 0x7FFFFFFFL
#define SPI_WF_LIFETIME_LIMIT_1__EN_WARN_MASK                                                                 0x80000000L
//SPI_WF_LIFETIME_LIMIT_2
#define SPI_WF_LIFETIME_LIMIT_2__MAX_CNT__SHIFT                                                               0x0
#define SPI_WF_LIFETIME_LIMIT_2__EN_WARN__SHIFT                                                               0x1f
#define SPI_WF_LIFETIME_LIMIT_2__MAX_CNT_MASK                                                                 0x7FFFFFFFL
#define SPI_WF_LIFETIME_LIMIT_2__EN_WARN_MASK                                                                 0x80000000L
//SPI_WF_LIFETIME_LIMIT_3
#define SPI_WF_LIFETIME_LIMIT_3__MAX_CNT__SHIFT                                                               0x0
#define SPI_WF_LIFETIME_LIMIT_3__EN_WARN__SHIFT                                                               0x1f
#define SPI_WF_LIFETIME_LIMIT_3__MAX_CNT_MASK                                                                 0x7FFFFFFFL
#define SPI_WF_LIFETIME_LIMIT_3__EN_WARN_MASK                                                                 0x80000000L
//SPI_WF_LIFETIME_LIMIT_4
#define SPI_WF_LIFETIME_LIMIT_4__MAX_CNT__SHIFT                                                               0x0
#define SPI_WF_LIFETIME_LIMIT_4__EN_WARN__SHIFT                                                               0x1f
#define SPI_WF_LIFETIME_LIMIT_4__MAX_CNT_MASK                                                                 0x7FFFFFFFL
#define SPI_WF_LIFETIME_LIMIT_4__EN_WARN_MASK                                                                 0x80000000L
//SPI_WF_LIFETIME_LIMIT_5
#define SPI_WF_LIFETIME_LIMIT_5__MAX_CNT__SHIFT                                                               0x0
#define SPI_WF_LIFETIME_LIMIT_5__EN_WARN__SHIFT                                                               0x1f
#define SPI_WF_LIFETIME_LIMIT_5__MAX_CNT_MASK                                                                 0x7FFFFFFFL
#define SPI_WF_LIFETIME_LIMIT_5__EN_WARN_MASK                                                                 0x80000000L
//SPI_WF_LIFETIME_LIMIT_6
#define SPI_WF_LIFETIME_LIMIT_6__MAX_CNT__SHIFT                                                               0x0
#define SPI_WF_LIFETIME_LIMIT_6__EN_WARN__SHIFT                                                               0x1f
#define SPI_WF_LIFETIME_LIMIT_6__MAX_CNT_MASK                                                                 0x7FFFFFFFL
#define SPI_WF_LIFETIME_LIMIT_6__EN_WARN_MASK                                                                 0x80000000L
//SPI_WF_LIFETIME_LIMIT_7
#define SPI_WF_LIFETIME_LIMIT_7__MAX_CNT__SHIFT                                                               0x0
#define SPI_WF_LIFETIME_LIMIT_7__EN_WARN__SHIFT                                                               0x1f
#define SPI_WF_LIFETIME_LIMIT_7__MAX_CNT_MASK                                                                 0x7FFFFFFFL
#define SPI_WF_LIFETIME_LIMIT_7__EN_WARN_MASK                                                                 0x80000000L
//SPI_WF_LIFETIME_LIMIT_8
#define SPI_WF_LIFETIME_LIMIT_8__MAX_CNT__SHIFT                                                               0x0
#define SPI_WF_LIFETIME_LIMIT_8__EN_WARN__SHIFT                                                               0x1f
#define SPI_WF_LIFETIME_LIMIT_8__MAX_CNT_MASK                                                                 0x7FFFFFFFL
#define SPI_WF_LIFETIME_LIMIT_8__EN_WARN_MASK                                                                 0x80000000L
//SPI_WF_LIFETIME_LIMIT_9
#define SPI_WF_LIFETIME_LIMIT_9__MAX_CNT__SHIFT                                                               0x0
#define SPI_WF_LIFETIME_LIMIT_9__EN_WARN__SHIFT                                                               0x1f
#define SPI_WF_LIFETIME_LIMIT_9__MAX_CNT_MASK                                                                 0x7FFFFFFFL
#define SPI_WF_LIFETIME_LIMIT_9__EN_WARN_MASK                                                                 0x80000000L
//SPI_WF_LIFETIME_STATUS_0
#define SPI_WF_LIFETIME_STATUS_0__MAX_CNT__SHIFT                                                              0x0
#define SPI_WF_LIFETIME_STATUS_0__INT_SENT__SHIFT                                                             0x1f
#define SPI_WF_LIFETIME_STATUS_0__MAX_CNT_MASK                                                                0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_0__INT_SENT_MASK                                                               0x80000000L
//SPI_WF_LIFETIME_STATUS_1
#define SPI_WF_LIFETIME_STATUS_1__MAX_CNT__SHIFT                                                              0x0
#define SPI_WF_LIFETIME_STATUS_1__INT_SENT__SHIFT                                                             0x1f
#define SPI_WF_LIFETIME_STATUS_1__MAX_CNT_MASK                                                                0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_1__INT_SENT_MASK                                                               0x80000000L
//SPI_WF_LIFETIME_STATUS_2
#define SPI_WF_LIFETIME_STATUS_2__MAX_CNT__SHIFT                                                              0x0
#define SPI_WF_LIFETIME_STATUS_2__INT_SENT__SHIFT                                                             0x1f
#define SPI_WF_LIFETIME_STATUS_2__MAX_CNT_MASK                                                                0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_2__INT_SENT_MASK                                                               0x80000000L
//SPI_WF_LIFETIME_STATUS_3
#define SPI_WF_LIFETIME_STATUS_3__MAX_CNT__SHIFT                                                              0x0
#define SPI_WF_LIFETIME_STATUS_3__INT_SENT__SHIFT                                                             0x1f
#define SPI_WF_LIFETIME_STATUS_3__MAX_CNT_MASK                                                                0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_3__INT_SENT_MASK                                                               0x80000000L
//SPI_WF_LIFETIME_STATUS_4
#define SPI_WF_LIFETIME_STATUS_4__MAX_CNT__SHIFT                                                              0x0
#define SPI_WF_LIFETIME_STATUS_4__INT_SENT__SHIFT                                                             0x1f
#define SPI_WF_LIFETIME_STATUS_4__MAX_CNT_MASK                                                                0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_4__INT_SENT_MASK                                                               0x80000000L
//SPI_WF_LIFETIME_STATUS_5
#define SPI_WF_LIFETIME_STATUS_5__MAX_CNT__SHIFT                                                              0x0
#define SPI_WF_LIFETIME_STATUS_5__INT_SENT__SHIFT                                                             0x1f
#define SPI_WF_LIFETIME_STATUS_5__MAX_CNT_MASK                                                                0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_5__INT_SENT_MASK                                                               0x80000000L
//SPI_WF_LIFETIME_STATUS_6
#define SPI_WF_LIFETIME_STATUS_6__MAX_CNT__SHIFT                                                              0x0
#define SPI_WF_LIFETIME_STATUS_6__INT_SENT__SHIFT                                                             0x1f
#define SPI_WF_LIFETIME_STATUS_6__MAX_CNT_MASK                                                                0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_6__INT_SENT_MASK                                                               0x80000000L
//SPI_WF_LIFETIME_STATUS_7
#define SPI_WF_LIFETIME_STATUS_7__MAX_CNT__SHIFT                                                              0x0
#define SPI_WF_LIFETIME_STATUS_7__INT_SENT__SHIFT                                                             0x1f
#define SPI_WF_LIFETIME_STATUS_7__MAX_CNT_MASK                                                                0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_7__INT_SENT_MASK                                                               0x80000000L
//SPI_WF_LIFETIME_STATUS_8
#define SPI_WF_LIFETIME_STATUS_8__MAX_CNT__SHIFT                                                              0x0
#define SPI_WF_LIFETIME_STATUS_8__INT_SENT__SHIFT                                                             0x1f
#define SPI_WF_LIFETIME_STATUS_8__MAX_CNT_MASK                                                                0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_8__INT_SENT_MASK                                                               0x80000000L
//SPI_WF_LIFETIME_STATUS_9
#define SPI_WF_LIFETIME_STATUS_9__MAX_CNT__SHIFT                                                              0x0
#define SPI_WF_LIFETIME_STATUS_9__INT_SENT__SHIFT                                                             0x1f
#define SPI_WF_LIFETIME_STATUS_9__MAX_CNT_MASK                                                                0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_9__INT_SENT_MASK                                                               0x80000000L
//SPI_WF_LIFETIME_STATUS_10
#define SPI_WF_LIFETIME_STATUS_10__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_10__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_10__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_10__INT_SENT_MASK                                                              0x80000000L
//SPI_WF_LIFETIME_STATUS_11
#define SPI_WF_LIFETIME_STATUS_11__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_11__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_11__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_11__INT_SENT_MASK                                                              0x80000000L
//SPI_WF_LIFETIME_STATUS_12
#define SPI_WF_LIFETIME_STATUS_12__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_12__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_12__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_12__INT_SENT_MASK                                                              0x80000000L
//SPI_WF_LIFETIME_STATUS_13
#define SPI_WF_LIFETIME_STATUS_13__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_13__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_13__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_13__INT_SENT_MASK                                                              0x80000000L
//SPI_WF_LIFETIME_STATUS_14
#define SPI_WF_LIFETIME_STATUS_14__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_14__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_14__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_14__INT_SENT_MASK                                                              0x80000000L
//SPI_WF_LIFETIME_STATUS_15
#define SPI_WF_LIFETIME_STATUS_15__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_15__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_15__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_15__INT_SENT_MASK                                                              0x80000000L
//SPI_WF_LIFETIME_STATUS_16
#define SPI_WF_LIFETIME_STATUS_16__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_16__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_16__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_16__INT_SENT_MASK                                                              0x80000000L
//SPI_WF_LIFETIME_STATUS_17
#define SPI_WF_LIFETIME_STATUS_17__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_17__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_17__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_17__INT_SENT_MASK                                                              0x80000000L
//SPI_WF_LIFETIME_STATUS_18
#define SPI_WF_LIFETIME_STATUS_18__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_18__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_18__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_18__INT_SENT_MASK                                                              0x80000000L
//SPI_WF_LIFETIME_STATUS_19
#define SPI_WF_LIFETIME_STATUS_19__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_19__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_19__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_19__INT_SENT_MASK                                                              0x80000000L
//SPI_WF_LIFETIME_STATUS_20
#define SPI_WF_LIFETIME_STATUS_20__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_20__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_20__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_20__INT_SENT_MASK                                                              0x80000000L
//SPI_LB_CTR_CTRL
#define SPI_LB_CTR_CTRL__LOAD__SHIFT                                                                          0x0
#define SPI_LB_CTR_CTRL__WAVES_SELECT__SHIFT                                                                  0x1
#define SPI_LB_CTR_CTRL__CLEAR_ON_READ__SHIFT                                                                 0x3
#define SPI_LB_CTR_CTRL__RESET_COUNTS__SHIFT                                                                  0x4
#define SPI_LB_CTR_CTRL__LOAD_MASK                                                                            0x00000001L
#define SPI_LB_CTR_CTRL__WAVES_SELECT_MASK                                                                    0x00000006L
#define SPI_LB_CTR_CTRL__CLEAR_ON_READ_MASK                                                                   0x00000008L
#define SPI_LB_CTR_CTRL__RESET_COUNTS_MASK                                                                    0x00000010L
//SPI_LB_CU_MASK
#define SPI_LB_CU_MASK__CU_MASK__SHIFT                                                                        0x0
#define SPI_LB_CU_MASK__CU_MASK_MASK                                                                          0xFFFFL
//SPI_LB_DATA_REG
#define SPI_LB_DATA_REG__CNT_DATA__SHIFT                                                                      0x0
#define SPI_LB_DATA_REG__CNT_DATA_MASK                                                                        0xFFFFFFFFL
//SPI_PG_ENABLE_STATIC_CU_MASK
#define SPI_PG_ENABLE_STATIC_CU_MASK__CU_MASK__SHIFT                                                          0x0
#define SPI_PG_ENABLE_STATIC_CU_MASK__CU_MASK_MASK                                                            0xFFFFL
//SPI_GDS_CREDITS
#define SPI_GDS_CREDITS__DS_DATA_CREDITS__SHIFT                                                               0x0
#define SPI_GDS_CREDITS__DS_CMD_CREDITS__SHIFT                                                                0x8
#define SPI_GDS_CREDITS__UNUSED__SHIFT                                                                        0x10
#define SPI_GDS_CREDITS__DS_DATA_CREDITS_MASK                                                                 0x000000FFL
#define SPI_GDS_CREDITS__DS_CMD_CREDITS_MASK                                                                  0x0000FF00L
#define SPI_GDS_CREDITS__UNUSED_MASK                                                                          0xFFFF0000L
//SPI_SX_EXPORT_BUFFER_SIZES
#define SPI_SX_EXPORT_BUFFER_SIZES__COLOR_BUFFER_SIZE__SHIFT                                                  0x0
#define SPI_SX_EXPORT_BUFFER_SIZES__POSITION_BUFFER_SIZE__SHIFT                                               0x10
#define SPI_SX_EXPORT_BUFFER_SIZES__COLOR_BUFFER_SIZE_MASK                                                    0x0000FFFFL
#define SPI_SX_EXPORT_BUFFER_SIZES__POSITION_BUFFER_SIZE_MASK                                                 0xFFFF0000L
//SPI_SX_SCOREBOARD_BUFFER_SIZES
#define SPI_SX_SCOREBOARD_BUFFER_SIZES__COLOR_SCOREBOARD_SIZE__SHIFT                                          0x0
#define SPI_SX_SCOREBOARD_BUFFER_SIZES__POSITION_SCOREBOARD_SIZE__SHIFT                                       0x10
#define SPI_SX_SCOREBOARD_BUFFER_SIZES__COLOR_SCOREBOARD_SIZE_MASK                                            0x0000FFFFL
#define SPI_SX_SCOREBOARD_BUFFER_SIZES__POSITION_SCOREBOARD_SIZE_MASK                                         0xFFFF0000L
//SPI_CSQ_WF_ACTIVE_STATUS
#define SPI_CSQ_WF_ACTIVE_STATUS__ACTIVE__SHIFT                                                               0x0
#define SPI_CSQ_WF_ACTIVE_STATUS__ACTIVE_MASK                                                                 0xFFFFFFFFL
//SPI_CSQ_WF_ACTIVE_COUNT_0
#define SPI_CSQ_WF_ACTIVE_COUNT_0__COUNT__SHIFT                                                               0x0
#define SPI_CSQ_WF_ACTIVE_COUNT_0__EVENTS__SHIFT                                                              0x10
#define SPI_CSQ_WF_ACTIVE_COUNT_0__COUNT_MASK                                                                 0x000007FFL
#define SPI_CSQ_WF_ACTIVE_COUNT_0__EVENTS_MASK                                                                0x07FF0000L
//SPI_CSQ_WF_ACTIVE_COUNT_1
#define SPI_CSQ_WF_ACTIVE_COUNT_1__COUNT__SHIFT                                                               0x0
#define SPI_CSQ_WF_ACTIVE_COUNT_1__EVENTS__SHIFT                                                              0x10
#define SPI_CSQ_WF_ACTIVE_COUNT_1__COUNT_MASK                                                                 0x000007FFL
#define SPI_CSQ_WF_ACTIVE_COUNT_1__EVENTS_MASK                                                                0x07FF0000L
//SPI_CSQ_WF_ACTIVE_COUNT_2
#define SPI_CSQ_WF_ACTIVE_COUNT_2__COUNT__SHIFT                                                               0x0
#define SPI_CSQ_WF_ACTIVE_COUNT_2__EVENTS__SHIFT                                                              0x10
#define SPI_CSQ_WF_ACTIVE_COUNT_2__COUNT_MASK                                                                 0x000007FFL
#define SPI_CSQ_WF_ACTIVE_COUNT_2__EVENTS_MASK                                                                0x07FF0000L
//SPI_CSQ_WF_ACTIVE_COUNT_3
#define SPI_CSQ_WF_ACTIVE_COUNT_3__COUNT__SHIFT                                                               0x0
#define SPI_CSQ_WF_ACTIVE_COUNT_3__EVENTS__SHIFT                                                              0x10
#define SPI_CSQ_WF_ACTIVE_COUNT_3__COUNT_MASK                                                                 0x000007FFL
#define SPI_CSQ_WF_ACTIVE_COUNT_3__EVENTS_MASK                                                                0x07FF0000L
//SPI_CSQ_WF_ACTIVE_COUNT_4
#define SPI_CSQ_WF_ACTIVE_COUNT_4__COUNT__SHIFT                                                               0x0
#define SPI_CSQ_WF_ACTIVE_COUNT_4__EVENTS__SHIFT                                                              0x10
#define SPI_CSQ_WF_ACTIVE_COUNT_4__COUNT_MASK                                                                 0x000007FFL
#define SPI_CSQ_WF_ACTIVE_COUNT_4__EVENTS_MASK                                                                0x07FF0000L
//SPI_CSQ_WF_ACTIVE_COUNT_5
#define SPI_CSQ_WF_ACTIVE_COUNT_5__COUNT__SHIFT                                                               0x0
#define SPI_CSQ_WF_ACTIVE_COUNT_5__EVENTS__SHIFT                                                              0x10
#define SPI_CSQ_WF_ACTIVE_COUNT_5__COUNT_MASK                                                                 0x000007FFL
#define SPI_CSQ_WF_ACTIVE_COUNT_5__EVENTS_MASK                                                                0x07FF0000L
//SPI_CSQ_WF_ACTIVE_COUNT_6
#define SPI_CSQ_WF_ACTIVE_COUNT_6__COUNT__SHIFT                                                               0x0
#define SPI_CSQ_WF_ACTIVE_COUNT_6__EVENTS__SHIFT                                                              0x10
#define SPI_CSQ_WF_ACTIVE_COUNT_6__COUNT_MASK                                                                 0x000007FFL
#define SPI_CSQ_WF_ACTIVE_COUNT_6__EVENTS_MASK                                                                0x07FF0000L
//SPI_CSQ_WF_ACTIVE_COUNT_7
#define SPI_CSQ_WF_ACTIVE_COUNT_7__COUNT__SHIFT                                                               0x0
#define SPI_CSQ_WF_ACTIVE_COUNT_7__EVENTS__SHIFT                                                              0x10
#define SPI_CSQ_WF_ACTIVE_COUNT_7__COUNT_MASK                                                                 0x000007FFL
#define SPI_CSQ_WF_ACTIVE_COUNT_7__EVENTS_MASK                                                                0x07FF0000L
//SPI_LB_DATA_WAVES
#define SPI_LB_DATA_WAVES__COUNT0__SHIFT                                                                      0x0
#define SPI_LB_DATA_WAVES__COUNT1__SHIFT                                                                      0x10
#define SPI_LB_DATA_WAVES__COUNT0_MASK                                                                        0x0000FFFFL
#define SPI_LB_DATA_WAVES__COUNT1_MASK                                                                        0xFFFF0000L
//SPI_LB_DATA_PERCU_WAVE_HSGS
#define SPI_LB_DATA_PERCU_WAVE_HSGS__CU_USED_HS__SHIFT                                                        0x0
#define SPI_LB_DATA_PERCU_WAVE_HSGS__CU_USED_GS__SHIFT                                                        0x10
#define SPI_LB_DATA_PERCU_WAVE_HSGS__CU_USED_HS_MASK                                                          0x0000FFFFL
#define SPI_LB_DATA_PERCU_WAVE_HSGS__CU_USED_GS_MASK                                                          0xFFFF0000L
//SPI_LB_DATA_PERCU_WAVE_VSPS
#define SPI_LB_DATA_PERCU_WAVE_VSPS__CU_USED_VS__SHIFT                                                        0x0
#define SPI_LB_DATA_PERCU_WAVE_VSPS__CU_USED_PS__SHIFT                                                        0x10
#define SPI_LB_DATA_PERCU_WAVE_VSPS__CU_USED_VS_MASK                                                          0x0000FFFFL
#define SPI_LB_DATA_PERCU_WAVE_VSPS__CU_USED_PS_MASK                                                          0xFFFF0000L
//SPI_LB_DATA_PERCU_WAVE_CS
#define SPI_LB_DATA_PERCU_WAVE_CS__ACTIVE__SHIFT                                                              0x0
#define SPI_LB_DATA_PERCU_WAVE_CS__ACTIVE_MASK                                                                0xFFFFL
//SPI_P0_TRAP_SCREEN_PSBA_LO
#define SPI_P0_TRAP_SCREEN_PSBA_LO__MEM_BASE__SHIFT                                                           0x0
#define SPI_P0_TRAP_SCREEN_PSBA_LO__MEM_BASE_MASK                                                             0xFFFFFFFFL
//SPI_P0_TRAP_SCREEN_PSBA_HI
#define SPI_P0_TRAP_SCREEN_PSBA_HI__MEM_BASE__SHIFT                                                           0x0
#define SPI_P0_TRAP_SCREEN_PSBA_HI__MEM_BASE_MASK                                                             0xFFL
//SPI_P0_TRAP_SCREEN_PSMA_LO
#define SPI_P0_TRAP_SCREEN_PSMA_LO__MEM_BASE__SHIFT                                                           0x0
#define SPI_P0_TRAP_SCREEN_PSMA_LO__MEM_BASE_MASK                                                             0xFFFFFFFFL
//SPI_P0_TRAP_SCREEN_PSMA_HI
#define SPI_P0_TRAP_SCREEN_PSMA_HI__MEM_BASE__SHIFT                                                           0x0
#define SPI_P0_TRAP_SCREEN_PSMA_HI__MEM_BASE_MASK                                                             0xFFL
//SPI_P0_TRAP_SCREEN_GPR_MIN
#define SPI_P0_TRAP_SCREEN_GPR_MIN__VGPR_MIN__SHIFT                                                           0x0
#define SPI_P0_TRAP_SCREEN_GPR_MIN__SGPR_MIN__SHIFT                                                           0x6
#define SPI_P0_TRAP_SCREEN_GPR_MIN__VGPR_MIN_MASK                                                             0x003FL
#define SPI_P0_TRAP_SCREEN_GPR_MIN__SGPR_MIN_MASK                                                             0x03C0L
//SPI_P1_TRAP_SCREEN_PSBA_LO
#define SPI_P1_TRAP_SCREEN_PSBA_LO__MEM_BASE__SHIFT                                                           0x0
#define SPI_P1_TRAP_SCREEN_PSBA_LO__MEM_BASE_MASK                                                             0xFFFFFFFFL
//SPI_P1_TRAP_SCREEN_PSBA_HI
#define SPI_P1_TRAP_SCREEN_PSBA_HI__MEM_BASE__SHIFT                                                           0x0
#define SPI_P1_TRAP_SCREEN_PSBA_HI__MEM_BASE_MASK                                                             0xFFL
//SPI_P1_TRAP_SCREEN_PSMA_LO
#define SPI_P1_TRAP_SCREEN_PSMA_LO__MEM_BASE__SHIFT                                                           0x0
#define SPI_P1_TRAP_SCREEN_PSMA_LO__MEM_BASE_MASK                                                             0xFFFFFFFFL
//SPI_P1_TRAP_SCREEN_PSMA_HI
#define SPI_P1_TRAP_SCREEN_PSMA_HI__MEM_BASE__SHIFT                                                           0x0
#define SPI_P1_TRAP_SCREEN_PSMA_HI__MEM_BASE_MASK                                                             0xFFL
//SPI_P1_TRAP_SCREEN_GPR_MIN
#define SPI_P1_TRAP_SCREEN_GPR_MIN__VGPR_MIN__SHIFT                                                           0x0
#define SPI_P1_TRAP_SCREEN_GPR_MIN__SGPR_MIN__SHIFT                                                           0x6
#define SPI_P1_TRAP_SCREEN_GPR_MIN__VGPR_MIN_MASK                                                             0x003FL
#define SPI_P1_TRAP_SCREEN_GPR_MIN__SGPR_MIN_MASK                                                             0x03C0L


// addressBlock: gc_tpdec
//TD_CNTL
#define TD_CNTL__SYNC_PHASE_SH__SHIFT                                                                         0x0
#define TD_CNTL__SYNC_PHASE_VC_SMX__SHIFT                                                                     0x4
#define TD_CNTL__PAD_STALL_EN__SHIFT                                                                          0x8
#define TD_CNTL__EXTEND_LDS_STALL__SHIFT                                                                      0x9
#define TD_CNTL__LDS_STALL_PHASE_ADJUST__SHIFT                                                                0xb
#define TD_CNTL__PRECISION_COMPATIBILITY__SHIFT                                                               0xf
#define TD_CNTL__GATHER4_FLOAT_MODE__SHIFT                                                                    0x10
#define TD_CNTL__LD_FLOAT_MODE__SHIFT                                                                         0x12
#define TD_CNTL__GATHER4_DX9_MODE__SHIFT                                                                      0x13
#define TD_CNTL__DISABLE_POWER_THROTTLE__SHIFT                                                                0x14
#define TD_CNTL__ENABLE_ROUND_TO_ZERO__SHIFT                                                                  0x15
#define TD_CNTL__DISABLE_2BIT_SIGNED_FORMAT__SHIFT                                                            0x17
#define TD_CNTL__DISABLE_MM_QNAN_COMPARE_RESULT__SHIFT                                                        0x18
#define TD_CNTL__SYNC_PHASE_SH_MASK                                                                           0x00000003L
#define TD_CNTL__SYNC_PHASE_VC_SMX_MASK                                                                       0x00000030L
#define TD_CNTL__PAD_STALL_EN_MASK                                                                            0x00000100L
#define TD_CNTL__EXTEND_LDS_STALL_MASK                                                                        0x00000600L
#define TD_CNTL__LDS_STALL_PHASE_ADJUST_MASK                                                                  0x00001800L
#define TD_CNTL__PRECISION_COMPATIBILITY_MASK                                                                 0x00008000L
#define TD_CNTL__GATHER4_FLOAT_MODE_MASK                                                                      0x00010000L
#define TD_CNTL__LD_FLOAT_MODE_MASK                                                                           0x00040000L
#define TD_CNTL__GATHER4_DX9_MODE_MASK                                                                        0x00080000L
#define TD_CNTL__DISABLE_POWER_THROTTLE_MASK                                                                  0x00100000L
#define TD_CNTL__ENABLE_ROUND_TO_ZERO_MASK                                                                    0x00200000L
#define TD_CNTL__DISABLE_2BIT_SIGNED_FORMAT_MASK                                                              0x00800000L
#define TD_CNTL__DISABLE_MM_QNAN_COMPARE_RESULT_MASK                                                          0x01000000L
//TD_STATUS
#define TD_STATUS__BUSY__SHIFT                                                                                0x1f
#define TD_STATUS__BUSY_MASK                                                                                  0x80000000L
//TD_DSM_CNTL
#define TD_DSM_CNTL__TD_SS_FIFO_LO_DSM_IRRITATOR_DATA__SHIFT                                                  0x0
#define TD_DSM_CNTL__TD_SS_FIFO_LO_ENABLE_SINGLE_WRITE__SHIFT                                                 0x2
#define TD_DSM_CNTL__TD_SS_FIFO_HI_DSM_IRRITATOR_DATA__SHIFT                                                  0x3
#define TD_DSM_CNTL__TD_SS_FIFO_HI_ENABLE_SINGLE_WRITE__SHIFT                                                 0x5
#define TD_DSM_CNTL__TD_CS_FIFO_DSM_IRRITATOR_DATA__SHIFT                                                     0x6
#define TD_DSM_CNTL__TD_CS_FIFO_ENABLE_SINGLE_WRITE__SHIFT                                                    0x8
#define TD_DSM_CNTL__TD_SS_FIFO_LO_DSM_IRRITATOR_DATA_MASK                                                    0x00000003L
#define TD_DSM_CNTL__TD_SS_FIFO_LO_ENABLE_SINGLE_WRITE_MASK                                                   0x00000004L
#define TD_DSM_CNTL__TD_SS_FIFO_HI_DSM_IRRITATOR_DATA_MASK                                                    0x00000018L
#define TD_DSM_CNTL__TD_SS_FIFO_HI_ENABLE_SINGLE_WRITE_MASK                                                   0x00000020L
#define TD_DSM_CNTL__TD_CS_FIFO_DSM_IRRITATOR_DATA_MASK                                                       0x000000C0L
#define TD_DSM_CNTL__TD_CS_FIFO_ENABLE_SINGLE_WRITE_MASK                                                      0x00000100L
//TD_DSM_CNTL2
#define TD_DSM_CNTL2__TD_SS_FIFO_LO_ENABLE_ERROR_INJECT__SHIFT                                                0x0
#define TD_DSM_CNTL2__TD_SS_FIFO_LO_SELECT_INJECT_DELAY__SHIFT                                                0x2
#define TD_DSM_CNTL2__TD_SS_FIFO_HI_ENABLE_ERROR_INJECT__SHIFT                                                0x3
#define TD_DSM_CNTL2__TD_SS_FIFO_HI_SELECT_INJECT_DELAY__SHIFT                                                0x5
#define TD_DSM_CNTL2__TD_CS_FIFO_ENABLE_ERROR_INJECT__SHIFT                                                   0x6
#define TD_DSM_CNTL2__TD_CS_FIFO_SELECT_INJECT_DELAY__SHIFT                                                   0x8
#define TD_DSM_CNTL2__TD_INJECT_DELAY__SHIFT                                                                  0x1a
#define TD_DSM_CNTL2__TD_SS_FIFO_LO_ENABLE_ERROR_INJECT_MASK                                                  0x00000003L
#define TD_DSM_CNTL2__TD_SS_FIFO_LO_SELECT_INJECT_DELAY_MASK                                                  0x00000004L
#define TD_DSM_CNTL2__TD_SS_FIFO_HI_ENABLE_ERROR_INJECT_MASK                                                  0x00000018L
#define TD_DSM_CNTL2__TD_SS_FIFO_HI_SELECT_INJECT_DELAY_MASK                                                  0x00000020L
#define TD_DSM_CNTL2__TD_CS_FIFO_ENABLE_ERROR_INJECT_MASK                                                     0x000000C0L
#define TD_DSM_CNTL2__TD_CS_FIFO_SELECT_INJECT_DELAY_MASK                                                     0x00000100L
#define TD_DSM_CNTL2__TD_INJECT_DELAY_MASK                                                                    0xFC000000L
//TD_SCRATCH
#define TD_SCRATCH__SCRATCH__SHIFT                                                                            0x0
#define TD_SCRATCH__SCRATCH_MASK                                                                              0xFFFFFFFFL
//TA_CNTL
#define TA_CNTL__FX_XNACK_CREDIT__SHIFT                                                                       0x0
#define TA_CNTL__SQ_XNACK_CREDIT__SHIFT                                                                       0x9
#define TA_CNTL__TC_DATA_CREDIT__SHIFT                                                                        0xd
#define TA_CNTL__ALIGNER_CREDIT__SHIFT                                                                        0x10
#define TA_CNTL__TD_FIFO_CREDIT__SHIFT                                                                        0x16
#define TA_CNTL__FX_XNACK_CREDIT_MASK                                                                         0x0000007FL
#define TA_CNTL__SQ_XNACK_CREDIT_MASK                                                                         0x00001E00L
#define TA_CNTL__TC_DATA_CREDIT_MASK                                                                          0x0000E000L
#define TA_CNTL__ALIGNER_CREDIT_MASK                                                                          0x001F0000L
#define TA_CNTL__TD_FIFO_CREDIT_MASK                                                                          0xFFC00000L
//TA_CNTL_AUX
#define TA_CNTL_AUX__SCOAL_DSWIZZLE_N__SHIFT                                                                  0x0
#define TA_CNTL_AUX__RESERVED__SHIFT                                                                          0x1
#define TA_CNTL_AUX__TFAULT_EN_OVERRIDE__SHIFT                                                                0x5
#define TA_CNTL_AUX__GATHERH_DST_SEL__SHIFT                                                                   0x6
#define TA_CNTL_AUX__DISABLE_GATHER4_BC_SWIZZLE__SHIFT                                                        0x7
#define TA_CNTL_AUX__NONIMG_ANISO_BYPASS__SHIFT                                                               0x9
#define TA_CNTL_AUX__ANISO_HALF_THRESH__SHIFT                                                                 0xa
#define TA_CNTL_AUX__ANISO_ERROR_FP_VBIAS__SHIFT                                                              0xc
#define TA_CNTL_AUX__ANISO_STEP_ORDER__SHIFT                                                                  0xd
#define TA_CNTL_AUX__ANISO_STEP__SHIFT                                                                        0xe
#define TA_CNTL_AUX__MINMAG_UNNORM__SHIFT                                                                     0xf
#define TA_CNTL_AUX__ANISO_WEIGHT_MODE__SHIFT                                                                 0x10
#define TA_CNTL_AUX__ANISO_RATIO_LUT__SHIFT                                                                   0x11
#define TA_CNTL_AUX__ANISO_TAP__SHIFT                                                                         0x12
#define TA_CNTL_AUX__ANISO_MIP_ADJ_MODE__SHIFT                                                                0x13
#define TA_CNTL_AUX__DETERMINISM_RESERVED_DISABLE__SHIFT                                                      0x14
#define TA_CNTL_AUX__DETERMINISM_OPCODE_STRICT_DISABLE__SHIFT                                                 0x15
#define TA_CNTL_AUX__DETERMINISM_MISC_DISABLE__SHIFT                                                          0x16
#define TA_CNTL_AUX__DETERMINISM_SAMPLE_C_DFMT_DISABLE__SHIFT                                                 0x17
#define TA_CNTL_AUX__DETERMINISM_SAMPLER_MSAA_DISABLE__SHIFT                                                  0x18
#define TA_CNTL_AUX__DETERMINISM_WRITEOP_READFMT_DISABLE__SHIFT                                               0x19
#define TA_CNTL_AUX__DETERMINISM_DFMT_NFMT_DISABLE__SHIFT                                                     0x1a
#define TA_CNTL_AUX__DISABLE_DWORD_X2_COALESCE__SHIFT                                                         0x1b
#define TA_CNTL_AUX__CUBEMAP_SLICE_CLAMP__SHIFT                                                               0x1c
#define TA_CNTL_AUX__TRUNC_SMALL_NEG__SHIFT                                                                   0x1d
#define TA_CNTL_AUX__ARRAY_ROUND_MODE__SHIFT                                                                  0x1e
#define TA_CNTL_AUX__SCOAL_DSWIZZLE_N_MASK                                                                    0x00000001L
#define TA_CNTL_AUX__RESERVED_MASK                                                                            0x0000000EL
#define TA_CNTL_AUX__TFAULT_EN_OVERRIDE_MASK                                                                  0x00000020L
#define TA_CNTL_AUX__GATHERH_DST_SEL_MASK                                                                     0x00000040L
#define TA_CNTL_AUX__DISABLE_GATHER4_BC_SWIZZLE_MASK                                                          0x00000080L
#define TA_CNTL_AUX__NONIMG_ANISO_BYPASS_MASK                                                                 0x00000200L
#define TA_CNTL_AUX__ANISO_HALF_THRESH_MASK                                                                   0x00000C00L
#define TA_CNTL_AUX__ANISO_ERROR_FP_VBIAS_MASK                                                                0x00001000L
#define TA_CNTL_AUX__ANISO_STEP_ORDER_MASK                                                                    0x00002000L
#define TA_CNTL_AUX__ANISO_STEP_MASK                                                                          0x00004000L
#define TA_CNTL_AUX__MINMAG_UNNORM_MASK                                                                       0x00008000L
#define TA_CNTL_AUX__ANISO_WEIGHT_MODE_MASK                                                                   0x00010000L
#define TA_CNTL_AUX__ANISO_RATIO_LUT_MASK                                                                     0x00020000L
#define TA_CNTL_AUX__ANISO_TAP_MASK                                                                           0x00040000L
#define TA_CNTL_AUX__ANISO_MIP_ADJ_MODE_MASK                                                                  0x00080000L
#define TA_CNTL_AUX__DETERMINISM_RESERVED_DISABLE_MASK                                                        0x00100000L
#define TA_CNTL_AUX__DETERMINISM_OPCODE_STRICT_DISABLE_MASK                                                   0x00200000L
#define TA_CNTL_AUX__DETERMINISM_MISC_DISABLE_MASK                                                            0x00400000L
#define TA_CNTL_AUX__DETERMINISM_SAMPLE_C_DFMT_DISABLE_MASK                                                   0x00800000L
#define TA_CNTL_AUX__DETERMINISM_SAMPLER_MSAA_DISABLE_MASK                                                    0x01000000L
#define TA_CNTL_AUX__DETERMINISM_WRITEOP_READFMT_DISABLE_MASK                                                 0x02000000L
#define TA_CNTL_AUX__DETERMINISM_DFMT_NFMT_DISABLE_MASK                                                       0x04000000L
#define TA_CNTL_AUX__DISABLE_DWORD_X2_COALESCE_MASK                                                           0x08000000L
#define TA_CNTL_AUX__CUBEMAP_SLICE_CLAMP_MASK                                                                 0x10000000L
#define TA_CNTL_AUX__TRUNC_SMALL_NEG_MASK                                                                     0x20000000L
#define TA_CNTL_AUX__ARRAY_ROUND_MODE_MASK                                                                    0xC0000000L
//TA_RESERVED_010C
#define TA_RESERVED_010C__Unused__SHIFT                                                                       0x0
#define TA_RESERVED_010C__Unused_MASK                                                                         0xFFFFFFFFL
//TA_STATUS
#define TA_STATUS__FG_PFIFO_EMPTYB__SHIFT                                                                     0xc
#define TA_STATUS__FG_LFIFO_EMPTYB__SHIFT                                                                     0xd
#define TA_STATUS__FG_SFIFO_EMPTYB__SHIFT                                                                     0xe
#define TA_STATUS__FL_PFIFO_EMPTYB__SHIFT                                                                     0x10
#define TA_STATUS__FL_LFIFO_EMPTYB__SHIFT                                                                     0x11
#define TA_STATUS__FL_SFIFO_EMPTYB__SHIFT                                                                     0x12
#define TA_STATUS__FA_PFIFO_EMPTYB__SHIFT                                                                     0x14
#define TA_STATUS__FA_LFIFO_EMPTYB__SHIFT                                                                     0x15
#define TA_STATUS__FA_SFIFO_EMPTYB__SHIFT                                                                     0x16
#define TA_STATUS__IN_BUSY__SHIFT                                                                             0x18
#define TA_STATUS__FG_BUSY__SHIFT                                                                             0x19
#define TA_STATUS__LA_BUSY__SHIFT                                                                             0x1a
#define TA_STATUS__FL_BUSY__SHIFT                                                                             0x1b
#define TA_STATUS__TA_BUSY__SHIFT                                                                             0x1c
#define TA_STATUS__FA_BUSY__SHIFT                                                                             0x1d
#define TA_STATUS__AL_BUSY__SHIFT                                                                             0x1e
#define TA_STATUS__BUSY__SHIFT                                                                                0x1f
#define TA_STATUS__FG_PFIFO_EMPTYB_MASK                                                                       0x00001000L
#define TA_STATUS__FG_LFIFO_EMPTYB_MASK                                                                       0x00002000L
#define TA_STATUS__FG_SFIFO_EMPTYB_MASK                                                                       0x00004000L
#define TA_STATUS__FL_PFIFO_EMPTYB_MASK                                                                       0x00010000L
#define TA_STATUS__FL_LFIFO_EMPTYB_MASK                                                                       0x00020000L
#define TA_STATUS__FL_SFIFO_EMPTYB_MASK                                                                       0x00040000L
#define TA_STATUS__FA_PFIFO_EMPTYB_MASK                                                                       0x00100000L
#define TA_STATUS__FA_LFIFO_EMPTYB_MASK                                                                       0x00200000L
#define TA_STATUS__FA_SFIFO_EMPTYB_MASK                                                                       0x00400000L
#define TA_STATUS__IN_BUSY_MASK                                                                               0x01000000L
#define TA_STATUS__FG_BUSY_MASK                                                                               0x02000000L
#define TA_STATUS__LA_BUSY_MASK                                                                               0x04000000L
#define TA_STATUS__FL_BUSY_MASK                                                                               0x08000000L
#define TA_STATUS__TA_BUSY_MASK                                                                               0x10000000L
#define TA_STATUS__FA_BUSY_MASK                                                                               0x20000000L
#define TA_STATUS__AL_BUSY_MASK                                                                               0x40000000L
#define TA_STATUS__BUSY_MASK                                                                                  0x80000000L
//TA_SCRATCH
#define TA_SCRATCH__SCRATCH__SHIFT                                                                            0x0
#define TA_SCRATCH__SCRATCH_MASK                                                                              0xFFFFFFFFL


// addressBlock: gc_gdsdec
//GDS_CONFIG
#define GDS_CONFIG__SH0_GPR_PHASE_SEL__SHIFT                                                                  0x1
#define GDS_CONFIG__SH1_GPR_PHASE_SEL__SHIFT                                                                  0x3
#define GDS_CONFIG__SH2_GPR_PHASE_SEL__SHIFT                                                                  0x5
#define GDS_CONFIG__SH3_GPR_PHASE_SEL__SHIFT                                                                  0x7
#define GDS_CONFIG__SH0_GPR_PHASE_SEL_MASK                                                                    0x00000006L
#define GDS_CONFIG__SH1_GPR_PHASE_SEL_MASK                                                                    0x00000018L
#define GDS_CONFIG__SH2_GPR_PHASE_SEL_MASK                                                                    0x00000060L
#define GDS_CONFIG__SH3_GPR_PHASE_SEL_MASK                                                                    0x00000180L
//GDS_CNTL_STATUS
#define GDS_CNTL_STATUS__GDS_BUSY__SHIFT                                                                      0x0
#define GDS_CNTL_STATUS__GRBM_WBUF_BUSY__SHIFT                                                                0x1
#define GDS_CNTL_STATUS__ORD_APP_BUSY__SHIFT                                                                  0x2
#define GDS_CNTL_STATUS__DS_BANK_CONFLICT__SHIFT                                                              0x3
#define GDS_CNTL_STATUS__DS_ADDR_CONFLICT__SHIFT                                                              0x4
#define GDS_CNTL_STATUS__DS_WR_CLAMP__SHIFT                                                                   0x5
#define GDS_CNTL_STATUS__DS_RD_CLAMP__SHIFT                                                                   0x6
#define GDS_CNTL_STATUS__GRBM_RBUF_BUSY__SHIFT                                                                0x7
#define GDS_CNTL_STATUS__DS_BUSY__SHIFT                                                                       0x8
#define GDS_CNTL_STATUS__GWS_BUSY__SHIFT                                                                      0x9
#define GDS_CNTL_STATUS__ORD_FIFO_BUSY__SHIFT                                                                 0xa
#define GDS_CNTL_STATUS__CREDIT_BUSY0__SHIFT                                                                  0xb
#define GDS_CNTL_STATUS__CREDIT_BUSY1__SHIFT                                                                  0xc
#define GDS_CNTL_STATUS__CREDIT_BUSY2__SHIFT                                                                  0xd
#define GDS_CNTL_STATUS__CREDIT_BUSY3__SHIFT                                                                  0xe
#define GDS_CNTL_STATUS__GDS_BUSY_MASK                                                                        0x00000001L
#define GDS_CNTL_STATUS__GRBM_WBUF_BUSY_MASK                                                                  0x00000002L
#define GDS_CNTL_STATUS__ORD_APP_BUSY_MASK                                                                    0x00000004L
#define GDS_CNTL_STATUS__DS_BANK_CONFLICT_MASK                                                                0x00000008L
#define GDS_CNTL_STATUS__DS_ADDR_CONFLICT_MASK                                                                0x00000010L
#define GDS_CNTL_STATUS__DS_WR_CLAMP_MASK                                                                     0x00000020L
#define GDS_CNTL_STATUS__DS_RD_CLAMP_MASK                                                                     0x00000040L
#define GDS_CNTL_STATUS__GRBM_RBUF_BUSY_MASK                                                                  0x00000080L
#define GDS_CNTL_STATUS__DS_BUSY_MASK                                                                         0x00000100L
#define GDS_CNTL_STATUS__GWS_BUSY_MASK                                                                        0x00000200L
#define GDS_CNTL_STATUS__ORD_FIFO_BUSY_MASK                                                                   0x00000400L
#define GDS_CNTL_STATUS__CREDIT_BUSY0_MASK                                                                    0x00000800L
#define GDS_CNTL_STATUS__CREDIT_BUSY1_MASK                                                                    0x00001000L
#define GDS_CNTL_STATUS__CREDIT_BUSY2_MASK                                                                    0x00002000L
#define GDS_CNTL_STATUS__CREDIT_BUSY3_MASK                                                                    0x00004000L
//GDS_ENHANCE2
#define GDS_ENHANCE2__MISC__SHIFT                                                                             0x0
#define GDS_ENHANCE2__UNUSED__SHIFT                                                                           0x10
#define GDS_ENHANCE2__MISC_MASK                                                                               0x0000FFFFL
#define GDS_ENHANCE2__UNUSED_MASK                                                                             0xFFFF0000L
//GDS_PROTECTION_FAULT
#define GDS_PROTECTION_FAULT__WRITE_DIS__SHIFT                                                                0x0
#define GDS_PROTECTION_FAULT__FAULT_DETECTED__SHIFT                                                           0x1
#define GDS_PROTECTION_FAULT__GRBM__SHIFT                                                                     0x2
#define GDS_PROTECTION_FAULT__SH_ID__SHIFT                                                                    0x3
#define GDS_PROTECTION_FAULT__CU_ID__SHIFT                                                                    0x6
#define GDS_PROTECTION_FAULT__SIMD_ID__SHIFT                                                                  0xa
#define GDS_PROTECTION_FAULT__WAVE_ID__SHIFT                                                                  0xc
#define GDS_PROTECTION_FAULT__ADDRESS__SHIFT                                                                  0x10
#define GDS_PROTECTION_FAULT__WRITE_DIS_MASK                                                                  0x00000001L
#define GDS_PROTECTION_FAULT__FAULT_DETECTED_MASK                                                             0x00000002L
#define GDS_PROTECTION_FAULT__GRBM_MASK                                                                       0x00000004L
#define GDS_PROTECTION_FAULT__SH_ID_MASK                                                                      0x00000038L
#define GDS_PROTECTION_FAULT__CU_ID_MASK                                                                      0x000003C0L
#define GDS_PROTECTION_FAULT__SIMD_ID_MASK                                                                    0x00000C00L
#define GDS_PROTECTION_FAULT__WAVE_ID_MASK                                                                    0x0000F000L
#define GDS_PROTECTION_FAULT__ADDRESS_MASK                                                                    0xFFFF0000L
//GDS_VM_PROTECTION_FAULT
#define GDS_VM_PROTECTION_FAULT__WRITE_DIS__SHIFT                                                             0x0
#define GDS_VM_PROTECTION_FAULT__FAULT_DETECTED__SHIFT                                                        0x1
#define GDS_VM_PROTECTION_FAULT__GWS__SHIFT                                                                   0x2
#define GDS_VM_PROTECTION_FAULT__OA__SHIFT                                                                    0x3
#define GDS_VM_PROTECTION_FAULT__GRBM__SHIFT                                                                  0x4
#define GDS_VM_PROTECTION_FAULT__TMZ__SHIFT                                                                   0x5
#define GDS_VM_PROTECTION_FAULT__VMID__SHIFT                                                                  0x8
#define GDS_VM_PROTECTION_FAULT__ADDRESS__SHIFT                                                               0x10
#define GDS_VM_PROTECTION_FAULT__WRITE_DIS_MASK                                                               0x00000001L
#define GDS_VM_PROTECTION_FAULT__FAULT_DETECTED_MASK                                                          0x00000002L
#define GDS_VM_PROTECTION_FAULT__GWS_MASK                                                                     0x00000004L
#define GDS_VM_PROTECTION_FAULT__OA_MASK                                                                      0x00000008L
#define GDS_VM_PROTECTION_FAULT__GRBM_MASK                                                                    0x00000010L
#define GDS_VM_PROTECTION_FAULT__TMZ_MASK                                                                     0x00000020L
#define GDS_VM_PROTECTION_FAULT__VMID_MASK                                                                    0x00000F00L
#define GDS_VM_PROTECTION_FAULT__ADDRESS_MASK                                                                 0xFFFF0000L
//GDS_EDC_CNT
#define GDS_EDC_CNT__GDS_MEM_DED__SHIFT                                                                       0x0
#define GDS_EDC_CNT__GDS_INPUT_QUEUE_SED__SHIFT                                                               0x2
#define GDS_EDC_CNT__GDS_MEM_SEC__SHIFT                                                                       0x4
#define GDS_EDC_CNT__UNUSED__SHIFT                                                                            0x6
#define GDS_EDC_CNT__GDS_MEM_DED_MASK                                                                         0x00000003L
#define GDS_EDC_CNT__GDS_INPUT_QUEUE_SED_MASK                                                                 0x0000000CL
#define GDS_EDC_CNT__GDS_MEM_SEC_MASK                                                                         0x00000030L
#define GDS_EDC_CNT__UNUSED_MASK                                                                              0xFFFFFFC0L
//GDS_EDC_GRBM_CNT
#define GDS_EDC_GRBM_CNT__DED__SHIFT                                                                          0x0
#define GDS_EDC_GRBM_CNT__SEC__SHIFT                                                                          0x2
#define GDS_EDC_GRBM_CNT__UNUSED__SHIFT                                                                       0x4
#define GDS_EDC_GRBM_CNT__DED_MASK                                                                            0x00000003L
#define GDS_EDC_GRBM_CNT__SEC_MASK                                                                            0x0000000CL
#define GDS_EDC_GRBM_CNT__UNUSED_MASK                                                                         0xFFFFFFF0L
//GDS_EDC_OA_DED
#define GDS_EDC_OA_DED__ME0_GFXHP3D_PIX_DED__SHIFT                                                            0x0
#define GDS_EDC_OA_DED__ME0_GFXHP3D_VTX_DED__SHIFT                                                            0x1
#define GDS_EDC_OA_DED__ME0_CS_DED__SHIFT                                                                     0x2
#define GDS_EDC_OA_DED__ME0_GFXHP3D_GS_DED__SHIFT                                                             0x3
#define GDS_EDC_OA_DED__ME1_PIPE0_DED__SHIFT                                                                  0x4
#define GDS_EDC_OA_DED__ME1_PIPE1_DED__SHIFT                                                                  0x5
#define GDS_EDC_OA_DED__ME1_PIPE2_DED__SHIFT                                                                  0x6
#define GDS_EDC_OA_DED__ME1_PIPE3_DED__SHIFT                                                                  0x7
#define GDS_EDC_OA_DED__ME2_PIPE0_DED__SHIFT                                                                  0x8
#define GDS_EDC_OA_DED__ME2_PIPE1_DED__SHIFT                                                                  0x9
#define GDS_EDC_OA_DED__ME2_PIPE2_DED__SHIFT                                                                  0xa
#define GDS_EDC_OA_DED__ME2_PIPE3_DED__SHIFT                                                                  0xb
#define GDS_EDC_OA_DED__UNUSED1__SHIFT                                                                        0xc
#define GDS_EDC_OA_DED__ME0_GFXHP3D_PIX_DED_MASK                                                              0x00000001L
#define GDS_EDC_OA_DED__ME0_GFXHP3D_VTX_DED_MASK                                                              0x00000002L
#define GDS_EDC_OA_DED__ME0_CS_DED_MASK                                                                       0x00000004L
#define GDS_EDC_OA_DED__ME0_GFXHP3D_GS_DED_MASK                                                               0x00000008L
#define GDS_EDC_OA_DED__ME1_PIPE0_DED_MASK                                                                    0x00000010L
#define GDS_EDC_OA_DED__ME1_PIPE1_DED_MASK                                                                    0x00000020L
#define GDS_EDC_OA_DED__ME1_PIPE2_DED_MASK                                                                    0x00000040L
#define GDS_EDC_OA_DED__ME1_PIPE3_DED_MASK                                                                    0x00000080L
#define GDS_EDC_OA_DED__ME2_PIPE0_DED_MASK                                                                    0x00000100L
#define GDS_EDC_OA_DED__ME2_PIPE1_DED_MASK                                                                    0x00000200L
#define GDS_EDC_OA_DED__ME2_PIPE2_DED_MASK                                                                    0x00000400L
#define GDS_EDC_OA_DED__ME2_PIPE3_DED_MASK                                                                    0x00000800L
#define GDS_EDC_OA_DED__UNUSED1_MASK                                                                          0xFFFFF000L
//GDS_DSM_CNTL
#define GDS_DSM_CNTL__SEL_DSM_GDS_MEM_IRRITATOR_DATA_0__SHIFT                                                 0x0
#define GDS_DSM_CNTL__SEL_DSM_GDS_MEM_IRRITATOR_DATA_1__SHIFT                                                 0x1
#define GDS_DSM_CNTL__GDS_MEM_ENABLE_SINGLE_WRITE__SHIFT                                                      0x2
#define GDS_DSM_CNTL__SEL_DSM_GDS_INPUT_QUEUE_IRRITATOR_DATA_0__SHIFT                                         0x3
#define GDS_DSM_CNTL__SEL_DSM_GDS_INPUT_QUEUE_IRRITATOR_DATA_1__SHIFT                                         0x4
#define GDS_DSM_CNTL__GDS_INPUT_QUEUE_ENABLE_SINGLE_WRITE__SHIFT                                              0x5
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_CMD_RAM_IRRITATOR_DATA_0__SHIFT                                         0x6
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_CMD_RAM_IRRITATOR_DATA_1__SHIFT                                         0x7
#define GDS_DSM_CNTL__GDS_PHY_CMD_RAM_ENABLE_SINGLE_WRITE__SHIFT                                              0x8
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_DATA_RAM_IRRITATOR_DATA_0__SHIFT                                        0x9
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_DATA_RAM_IRRITATOR_DATA_1__SHIFT                                        0xa
#define GDS_DSM_CNTL__GDS_PHY_DATA_RAM_ENABLE_SINGLE_WRITE__SHIFT                                             0xb
#define GDS_DSM_CNTL__SEL_DSM_GDS_PIPE_MEM_IRRITATOR_DATA_0__SHIFT                                            0xc
#define GDS_DSM_CNTL__SEL_DSM_GDS_PIPE_MEM_IRRITATOR_DATA_1__SHIFT                                            0xd
#define GDS_DSM_CNTL__GDS_PIPE_MEM_ENABLE_SINGLE_WRITE__SHIFT                                                 0xe
#define GDS_DSM_CNTL__UNUSED__SHIFT                                                                           0xf
#define GDS_DSM_CNTL__SEL_DSM_GDS_MEM_IRRITATOR_DATA_0_MASK                                                   0x00000001L
#define GDS_DSM_CNTL__SEL_DSM_GDS_MEM_IRRITATOR_DATA_1_MASK                                                   0x00000002L
#define GDS_DSM_CNTL__GDS_MEM_ENABLE_SINGLE_WRITE_MASK                                                        0x00000004L
#define GDS_DSM_CNTL__SEL_DSM_GDS_INPUT_QUEUE_IRRITATOR_DATA_0_MASK                                           0x00000008L
#define GDS_DSM_CNTL__SEL_DSM_GDS_INPUT_QUEUE_IRRITATOR_DATA_1_MASK                                           0x00000010L
#define GDS_DSM_CNTL__GDS_INPUT_QUEUE_ENABLE_SINGLE_WRITE_MASK                                                0x00000020L
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_CMD_RAM_IRRITATOR_DATA_0_MASK                                           0x00000040L
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_CMD_RAM_IRRITATOR_DATA_1_MASK                                           0x00000080L
#define GDS_DSM_CNTL__GDS_PHY_CMD_RAM_ENABLE_SINGLE_WRITE_MASK                                                0x00000100L
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_DATA_RAM_IRRITATOR_DATA_0_MASK                                          0x00000200L
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_DATA_RAM_IRRITATOR_DATA_1_MASK                                          0x00000400L
#define GDS_DSM_CNTL__GDS_PHY_DATA_RAM_ENABLE_SINGLE_WRITE_MASK                                               0x00000800L
#define GDS_DSM_CNTL__SEL_DSM_GDS_PIPE_MEM_IRRITATOR_DATA_0_MASK                                              0x00001000L
#define GDS_DSM_CNTL__SEL_DSM_GDS_PIPE_MEM_IRRITATOR_DATA_1_MASK                                              0x00002000L
#define GDS_DSM_CNTL__GDS_PIPE_MEM_ENABLE_SINGLE_WRITE_MASK                                                   0x00004000L
#define GDS_DSM_CNTL__UNUSED_MASK                                                                             0xFFFF8000L
//GDS_EDC_OA_PHY_CNT
#define GDS_EDC_OA_PHY_CNT__ME0_CS_PIPE_MEM_SEC__SHIFT                                                        0x0
#define GDS_EDC_OA_PHY_CNT__ME0_CS_PIPE_MEM_DED__SHIFT                                                        0x2
#define GDS_EDC_OA_PHY_CNT__PHY_CMD_RAM_MEM_SEC__SHIFT                                                        0x4
#define GDS_EDC_OA_PHY_CNT__PHY_CMD_RAM_MEM_DED__SHIFT                                                        0x6
#define GDS_EDC_OA_PHY_CNT__PHY_DATA_RAM_MEM_SED__SHIFT                                                       0x8
#define GDS_EDC_OA_PHY_CNT__UNUSED1__SHIFT                                                                    0xa
#define GDS_EDC_OA_PHY_CNT__ME0_CS_PIPE_MEM_SEC_MASK                                                          0x00000003L
#define GDS_EDC_OA_PHY_CNT__ME0_CS_PIPE_MEM_DED_MASK                                                          0x0000000CL
#define GDS_EDC_OA_PHY_CNT__PHY_CMD_RAM_MEM_SEC_MASK                                                          0x00000030L
#define GDS_EDC_OA_PHY_CNT__PHY_CMD_RAM_MEM_DED_MASK                                                          0x000000C0L
#define GDS_EDC_OA_PHY_CNT__PHY_DATA_RAM_MEM_SED_MASK                                                         0x00000300L
#define GDS_EDC_OA_PHY_CNT__UNUSED1_MASK                                                                      0xFFFFFC00L
//GDS_EDC_OA_PIPE_CNT
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE0_PIPE_MEM_SEC__SHIFT                                                    0x0
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE0_PIPE_MEM_DED__SHIFT                                                    0x2
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE1_PIPE_MEM_SEC__SHIFT                                                    0x4
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE1_PIPE_MEM_DED__SHIFT                                                    0x6
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE2_PIPE_MEM_SEC__SHIFT                                                    0x8
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE2_PIPE_MEM_DED__SHIFT                                                    0xa
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE3_PIPE_MEM_SEC__SHIFT                                                    0xc
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE3_PIPE_MEM_DED__SHIFT                                                    0xe
#define GDS_EDC_OA_PIPE_CNT__UNUSED__SHIFT                                                                    0x10
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE0_PIPE_MEM_SEC_MASK                                                      0x00000003L
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE0_PIPE_MEM_DED_MASK                                                      0x0000000CL
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE1_PIPE_MEM_SEC_MASK                                                      0x00000030L
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE1_PIPE_MEM_DED_MASK                                                      0x000000C0L
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE2_PIPE_MEM_SEC_MASK                                                      0x00000300L
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE2_PIPE_MEM_DED_MASK                                                      0x00000C00L
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE3_PIPE_MEM_SEC_MASK                                                      0x00003000L
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE3_PIPE_MEM_DED_MASK                                                      0x0000C000L
#define GDS_EDC_OA_PIPE_CNT__UNUSED_MASK                                                                      0xFFFF0000L
//GDS_DSM_CNTL2
#define GDS_DSM_CNTL2__GDS_MEM_ENABLE_ERROR_INJECT__SHIFT                                                     0x0
#define GDS_DSM_CNTL2__GDS_MEM_SELECT_INJECT_DELAY__SHIFT                                                     0x2
#define GDS_DSM_CNTL2__GDS_INPUT_QUEUE_ENABLE_ERROR_INJECT__SHIFT                                             0x3
#define GDS_DSM_CNTL2__GDS_INPUT_QUEUE_SELECT_INJECT_DELAY__SHIFT                                             0x5
#define GDS_DSM_CNTL2__GDS_PHY_CMD_RAM_ENABLE_ERROR_INJECT__SHIFT                                             0x6
#define GDS_DSM_CNTL2__GDS_PHY_CMD_RAM_SELECT_INJECT_DELAY__SHIFT                                             0x8
#define GDS_DSM_CNTL2__GDS_PHY_DATA_RAM_ENABLE_ERROR_INJECT__SHIFT                                            0x9
#define GDS_DSM_CNTL2__GDS_PHY_DATA_RAM_SELECT_INJECT_DELAY__SHIFT                                            0xb
#define GDS_DSM_CNTL2__GDS_PIPE_MEM_ENABLE_ERROR_INJECT__SHIFT                                                0xc
#define GDS_DSM_CNTL2__GDS_PIPE_MEM_SELECT_INJECT_DELAY__SHIFT                                                0xe
#define GDS_DSM_CNTL2__UNUSED__SHIFT                                                                          0xf
#define GDS_DSM_CNTL2__GDS_INJECT_DELAY__SHIFT                                                                0x1a
#define GDS_DSM_CNTL2__GDS_MEM_ENABLE_ERROR_INJECT_MASK                                                       0x00000003L
#define GDS_DSM_CNTL2__GDS_MEM_SELECT_INJECT_DELAY_MASK                                                       0x00000004L
#define GDS_DSM_CNTL2__GDS_INPUT_QUEUE_ENABLE_ERROR_INJECT_MASK                                               0x00000018L
#define GDS_DSM_CNTL2__GDS_INPUT_QUEUE_SELECT_INJECT_DELAY_MASK                                               0x00000020L
#define GDS_DSM_CNTL2__GDS_PHY_CMD_RAM_ENABLE_ERROR_INJECT_MASK                                               0x000000C0L
#define GDS_DSM_CNTL2__GDS_PHY_CMD_RAM_SELECT_INJECT_DELAY_MASK                                               0x00000100L
#define GDS_DSM_CNTL2__GDS_PHY_DATA_RAM_ENABLE_ERROR_INJECT_MASK                                              0x00000600L
#define GDS_DSM_CNTL2__GDS_PHY_DATA_RAM_SELECT_INJECT_DELAY_MASK                                              0x00000800L
#define GDS_DSM_CNTL2__GDS_PIPE_MEM_ENABLE_ERROR_INJECT_MASK                                                  0x00003000L
#define GDS_DSM_CNTL2__GDS_PIPE_MEM_SELECT_INJECT_DELAY_MASK                                                  0x00004000L
#define GDS_DSM_CNTL2__UNUSED_MASK                                                                            0x03FF8000L
#define GDS_DSM_CNTL2__GDS_INJECT_DELAY_MASK                                                                  0xFC000000L
//GDS_WD_GDS_CSB
#define GDS_WD_GDS_CSB__COUNTER__SHIFT                                                                        0x0
#define GDS_WD_GDS_CSB__UNUSED__SHIFT                                                                         0xd
#define GDS_WD_GDS_CSB__COUNTER_MASK                                                                          0x00001FFFL
#define GDS_WD_GDS_CSB__UNUSED_MASK                                                                           0xFFFFE000L


// addressBlock: gc_rbdec
//DB_DEBUG
#define DB_DEBUG__DEBUG_STENCIL_COMPRESS_DISABLE__SHIFT                                                       0x0
#define DB_DEBUG__DEBUG_DEPTH_COMPRESS_DISABLE__SHIFT                                                         0x1
#define DB_DEBUG__FETCH_FULL_Z_TILE__SHIFT                                                                    0x2
#define DB_DEBUG__FETCH_FULL_STENCIL_TILE__SHIFT                                                              0x3
#define DB_DEBUG__FORCE_Z_MODE__SHIFT                                                                         0x4
#define DB_DEBUG__DEBUG_FORCE_DEPTH_READ__SHIFT                                                               0x6
#define DB_DEBUG__DEBUG_FORCE_STENCIL_READ__SHIFT                                                             0x7
#define DB_DEBUG__DEBUG_FORCE_HIZ_ENABLE__SHIFT                                                               0x8
#define DB_DEBUG__DEBUG_FORCE_HIS_ENABLE0__SHIFT                                                              0xa
#define DB_DEBUG__DEBUG_FORCE_HIS_ENABLE1__SHIFT                                                              0xc
#define DB_DEBUG__DEBUG_FAST_Z_DISABLE__SHIFT                                                                 0xe
#define DB_DEBUG__DEBUG_FAST_STENCIL_DISABLE__SHIFT                                                           0xf
#define DB_DEBUG__DEBUG_NOOP_CULL_DISABLE__SHIFT                                                              0x10
#define DB_DEBUG__DISABLE_SUMM_SQUADS__SHIFT                                                                  0x11
#define DB_DEBUG__DEPTH_CACHE_FORCE_MISS__SHIFT                                                               0x12
#define DB_DEBUG__DEBUG_FORCE_FULL_Z_RANGE__SHIFT                                                             0x13
#define DB_DEBUG__NEVER_FREE_Z_ONLY__SHIFT                                                                    0x15
#define DB_DEBUG__ZPASS_COUNTS_LOOK_AT_PIPE_STAT_EVENTS__SHIFT                                                0x16
#define DB_DEBUG__DISABLE_VPORT_ZPLANE_OPTIMIZATION__SHIFT                                                    0x17
#define DB_DEBUG__DECOMPRESS_AFTER_N_ZPLANES__SHIFT                                                           0x18
#define DB_DEBUG__ONE_FREE_IN_FLIGHT__SHIFT                                                                   0x1c
#define DB_DEBUG__FORCE_MISS_IF_NOT_INFLIGHT__SHIFT                                                           0x1d
#define DB_DEBUG__DISABLE_DEPTH_SURFACE_SYNC__SHIFT                                                           0x1e
#define DB_DEBUG__DISABLE_HTILE_SURFACE_SYNC__SHIFT                                                           0x1f
#define DB_DEBUG__DEBUG_STENCIL_COMPRESS_DISABLE_MASK                                                         0x00000001L
#define DB_DEBUG__DEBUG_DEPTH_COMPRESS_DISABLE_MASK                                                           0x00000002L
#define DB_DEBUG__FETCH_FULL_Z_TILE_MASK                                                                      0x00000004L
#define DB_DEBUG__FETCH_FULL_STENCIL_TILE_MASK                                                                0x00000008L
#define DB_DEBUG__FORCE_Z_MODE_MASK                                                                           0x00000030L
#define DB_DEBUG__DEBUG_FORCE_DEPTH_READ_MASK                                                                 0x00000040L
#define DB_DEBUG__DEBUG_FORCE_STENCIL_READ_MASK                                                               0x00000080L
#define DB_DEBUG__DEBUG_FORCE_HIZ_ENABLE_MASK                                                                 0x00000300L
#define DB_DEBUG__DEBUG_FORCE_HIS_ENABLE0_MASK                                                                0x00000C00L
#define DB_DEBUG__DEBUG_FORCE_HIS_ENABLE1_MASK                                                                0x00003000L
#define DB_DEBUG__DEBUG_FAST_Z_DISABLE_MASK                                                                   0x00004000L
#define DB_DEBUG__DEBUG_FAST_STENCIL_DISABLE_MASK                                                             0x00008000L
#define DB_DEBUG__DEBUG_NOOP_CULL_DISABLE_MASK                                                                0x00010000L
#define DB_DEBUG__DISABLE_SUMM_SQUADS_MASK                                                                    0x00020000L
#define DB_DEBUG__DEPTH_CACHE_FORCE_MISS_MASK                                                                 0x00040000L
#define DB_DEBUG__DEBUG_FORCE_FULL_Z_RANGE_MASK                                                               0x00180000L
#define DB_DEBUG__NEVER_FREE_Z_ONLY_MASK                                                                      0x00200000L
#define DB_DEBUG__ZPASS_COUNTS_LOOK_AT_PIPE_STAT_EVENTS_MASK                                                  0x00400000L
#define DB_DEBUG__DISABLE_VPORT_ZPLANE_OPTIMIZATION_MASK                                                      0x00800000L
#define DB_DEBUG__DECOMPRESS_AFTER_N_ZPLANES_MASK                                                             0x0F000000L
#define DB_DEBUG__ONE_FREE_IN_FLIGHT_MASK                                                                     0x10000000L
#define DB_DEBUG__FORCE_MISS_IF_NOT_INFLIGHT_MASK                                                             0x20000000L
#define DB_DEBUG__DISABLE_DEPTH_SURFACE_SYNC_MASK                                                             0x40000000L
#define DB_DEBUG__DISABLE_HTILE_SURFACE_SYNC_MASK                                                             0x80000000L
//DB_DEBUG2
#define DB_DEBUG2__ALLOW_COMPZ_BYTE_MASKING__SHIFT                                                            0x0
#define DB_DEBUG2__DISABLE_TC_ZRANGE_L0_CACHE__SHIFT                                                          0x1
#define DB_DEBUG2__DISABLE_TC_MASK_L0_CACHE__SHIFT                                                            0x2
#define DB_DEBUG2__DTR_ROUND_ROBIN_ARB__SHIFT                                                                 0x3
#define DB_DEBUG2__DTR_PREZ_STALLS_FOR_ETF_ROOM__SHIFT                                                        0x4
#define DB_DEBUG2__DISABLE_PREZL_FIFO_STALL__SHIFT                                                            0x5
#define DB_DEBUG2__DISABLE_PREZL_FIFO_STALL_REZ__SHIFT                                                        0x6
#define DB_DEBUG2__ENABLE_VIEWPORT_STALL_ON_ALL__SHIFT                                                        0x7
#define DB_DEBUG2__OPTIMIZE_HIZ_MATCHES_FB_DISABLE__SHIFT                                                     0x8
#define DB_DEBUG2__CLK_OFF_DELAY__SHIFT                                                                       0x9
#define DB_DEBUG2__DISABLE_TILE_COVERED_FOR_PS_ITER__SHIFT                                                    0xe
#define DB_DEBUG2__ENABLE_SUBTILE_GROUPING__SHIFT                                                             0xf
#define DB_DEBUG2__RESERVED__SHIFT                                                                            0x10
#define DB_DEBUG2__DISABLE_NULL_EOT_FORWARDING__SHIFT                                                         0x11
#define DB_DEBUG2__DISABLE_DTT_DATA_FORWARDING__SHIFT                                                         0x12
#define DB_DEBUG2__DISABLE_QUAD_COHERENCY_STALL__SHIFT                                                        0x13
#define DB_DEBUG2__ENABLE_PREZ_OF_REZ_SUMM__SHIFT                                                             0x1c
#define DB_DEBUG2__DISABLE_PREZL_VIEWPORT_STALL__SHIFT                                                        0x1d
#define DB_DEBUG2__DISABLE_SINGLE_STENCIL_QUAD_SUMM__SHIFT                                                    0x1e
#define DB_DEBUG2__DISABLE_WRITE_STALL_ON_RDWR_CONFLICT__SHIFT                                                0x1f
#define DB_DEBUG2__ALLOW_COMPZ_BYTE_MASKING_MASK                                                              0x00000001L
#define DB_DEBUG2__DISABLE_TC_ZRANGE_L0_CACHE_MASK                                                            0x00000002L
#define DB_DEBUG2__DISABLE_TC_MASK_L0_CACHE_MASK                                                              0x00000004L
#define DB_DEBUG2__DTR_ROUND_ROBIN_ARB_MASK                                                                   0x00000008L
#define DB_DEBUG2__DTR_PREZ_STALLS_FOR_ETF_ROOM_MASK                                                          0x00000010L
#define DB_DEBUG2__DISABLE_PREZL_FIFO_STALL_MASK                                                              0x00000020L
#define DB_DEBUG2__DISABLE_PREZL_FIFO_STALL_REZ_MASK                                                          0x00000040L
#define DB_DEBUG2__ENABLE_VIEWPORT_STALL_ON_ALL_MASK                                                          0x00000080L
#define DB_DEBUG2__OPTIMIZE_HIZ_MATCHES_FB_DISABLE_MASK                                                       0x00000100L
#define DB_DEBUG2__CLK_OFF_DELAY_MASK                                                                         0x00003E00L
#define DB_DEBUG2__DISABLE_TILE_COVERED_FOR_PS_ITER_MASK                                                      0x00004000L
#define DB_DEBUG2__ENABLE_SUBTILE_GROUPING_MASK                                                               0x00008000L
#define DB_DEBUG2__RESERVED_MASK                                                                              0x00010000L
#define DB_DEBUG2__DISABLE_NULL_EOT_FORWARDING_MASK                                                           0x00020000L
#define DB_DEBUG2__DISABLE_DTT_DATA_FORWARDING_MASK                                                           0x00040000L
#define DB_DEBUG2__DISABLE_QUAD_COHERENCY_STALL_MASK                                                          0x00080000L
#define DB_DEBUG2__ENABLE_PREZ_OF_REZ_SUMM_MASK                                                               0x10000000L
#define DB_DEBUG2__DISABLE_PREZL_VIEWPORT_STALL_MASK                                                          0x20000000L
#define DB_DEBUG2__DISABLE_SINGLE_STENCIL_QUAD_SUMM_MASK                                                      0x40000000L
#define DB_DEBUG2__DISABLE_WRITE_STALL_ON_RDWR_CONFLICT_MASK                                                  0x80000000L
//DB_DEBUG3
#define DB_DEBUG3__DISABLE_CLEAR_ZRANGE_CORRECTION__SHIFT                                                     0x0
#define DB_DEBUG3__ROUND_ZRANGE_CORRECTION__SHIFT                                                             0x1
#define DB_DEBUG3__FORCE_DB_IS_GOOD__SHIFT                                                                    0x2
#define DB_DEBUG3__DISABLE_TL_SSO_NULL_SUPPRESSION__SHIFT                                                     0x3
#define DB_DEBUG3__DISABLE_HIZ_ON_VPORT_CLAMP__SHIFT                                                          0x4
#define DB_DEBUG3__EQAA_INTERPOLATE_COMP_Z__SHIFT                                                             0x5
#define DB_DEBUG3__EQAA_INTERPOLATE_SRC_Z__SHIFT                                                              0x6
#define DB_DEBUG3__DISABLE_TCP_CAM_BYPASS__SHIFT                                                              0x7
#define DB_DEBUG3__DISABLE_ZCMP_DIRTY_SUPPRESSION__SHIFT                                                      0x8
#define DB_DEBUG3__DISABLE_REDUNDANT_PLANE_FLUSHES_OPT__SHIFT                                                 0x9
#define DB_DEBUG3__DISABLE_RECOMP_TO_1ZPLANE_WITHOUT_FASTOP__SHIFT                                            0xa
#define DB_DEBUG3__ENABLE_INCOHERENT_EQAA_READS__SHIFT                                                        0xb
#define DB_DEBUG3__DISABLE_OP_Z_DATA_FORWARDING__SHIFT                                                        0xc
#define DB_DEBUG3__DISABLE_OP_DF_BYPASS__SHIFT                                                                0xd
#define DB_DEBUG3__DISABLE_OP_DF_WRITE_COMBINE__SHIFT                                                         0xe
#define DB_DEBUG3__DISABLE_OP_DF_DIRECT_FEEDBACK__SHIFT                                                       0xf
#define DB_DEBUG3__ALLOW_RF2P_RW_COLLISION__SHIFT                                                             0x10
#define DB_DEBUG3__SLOW_PREZ_TO_A2M_OMASK_RATE__SHIFT                                                         0x11
#define DB_DEBUG3__DISABLE_OP_S_DATA_FORWARDING__SHIFT                                                        0x12
#define DB_DEBUG3__DISABLE_TC_UPDATE_WRITE_COMBINE__SHIFT                                                     0x13
#define DB_DEBUG3__DISABLE_HZ_TC_WRITE_COMBINE__SHIFT                                                         0x14
#define DB_DEBUG3__ENABLE_RECOMP_ZDIRTY_SUPPRESSION_OPT__SHIFT                                                0x15
#define DB_DEBUG3__ENABLE_TC_MA_ROUND_ROBIN_ARB__SHIFT                                                        0x16
#define DB_DEBUG3__DISABLE_RAM_READ_SUPPRESION_ON_FWD__SHIFT                                                  0x17
#define DB_DEBUG3__DISABLE_EQAA_A2M_PERF_OPT__SHIFT                                                           0x18
#define DB_DEBUG3__DISABLE_DI_DT_STALL__SHIFT                                                                 0x19
#define DB_DEBUG3__ENABLE_DB_PROCESS_RESET__SHIFT                                                             0x1a
#define DB_DEBUG3__DISABLE_OVERRASTERIZATION_FIX__SHIFT                                                       0x1b
#define DB_DEBUG3__DONT_INSERT_CONTEXT_SUSPEND__SHIFT                                                         0x1c
#define DB_DEBUG3__DONT_DELETE_CONTEXT_SUSPEND__SHIFT                                                         0x1d
#define DB_DEBUG3__DISABLE_4XAA_2P_DELAYED_WRITE__SHIFT                                                       0x1e
#define DB_DEBUG3__DISABLE_4XAA_2P_INTERLEAVED_PMASK__SHIFT                                                   0x1f
#define DB_DEBUG3__DISABLE_CLEAR_ZRANGE_CORRECTION_MASK                                                       0x00000001L
#define DB_DEBUG3__ROUND_ZRANGE_CORRECTION_MASK                                                               0x00000002L
#define DB_DEBUG3__FORCE_DB_IS_GOOD_MASK                                                                      0x00000004L
#define DB_DEBUG3__DISABLE_TL_SSO_NULL_SUPPRESSION_MASK                                                       0x00000008L
#define DB_DEBUG3__DISABLE_HIZ_ON_VPORT_CLAMP_MASK                                                            0x00000010L
#define DB_DEBUG3__EQAA_INTERPOLATE_COMP_Z_MASK                                                               0x00000020L
#define DB_DEBUG3__EQAA_INTERPOLATE_SRC_Z_MASK                                                                0x00000040L
#define DB_DEBUG3__DISABLE_TCP_CAM_BYPASS_MASK                                                                0x00000080L
#define DB_DEBUG3__DISABLE_ZCMP_DIRTY_SUPPRESSION_MASK                                                        0x00000100L
#define DB_DEBUG3__DISABLE_REDUNDANT_PLANE_FLUSHES_OPT_MASK                                                   0x00000200L
#define DB_DEBUG3__DISABLE_RECOMP_TO_1ZPLANE_WITHOUT_FASTOP_MASK                                              0x00000400L
#define DB_DEBUG3__ENABLE_INCOHERENT_EQAA_READS_MASK                                                          0x00000800L
#define DB_DEBUG3__DISABLE_OP_Z_DATA_FORWARDING_MASK                                                          0x00001000L
#define DB_DEBUG3__DISABLE_OP_DF_BYPASS_MASK                                                                  0x00002000L
#define DB_DEBUG3__DISABLE_OP_DF_WRITE_COMBINE_MASK                                                           0x00004000L
#define DB_DEBUG3__DISABLE_OP_DF_DIRECT_FEEDBACK_MASK                                                         0x00008000L
#define DB_DEBUG3__ALLOW_RF2P_RW_COLLISION_MASK                                                               0x00010000L
#define DB_DEBUG3__SLOW_PREZ_TO_A2M_OMASK_RATE_MASK                                                           0x00020000L
#define DB_DEBUG3__DISABLE_OP_S_DATA_FORWARDING_MASK                                                          0x00040000L
#define DB_DEBUG3__DISABLE_TC_UPDATE_WRITE_COMBINE_MASK                                                       0x00080000L
#define DB_DEBUG3__DISABLE_HZ_TC_WRITE_COMBINE_MASK                                                           0x00100000L
#define DB_DEBUG3__ENABLE_RECOMP_ZDIRTY_SUPPRESSION_OPT_MASK                                                  0x00200000L
#define DB_DEBUG3__ENABLE_TC_MA_ROUND_ROBIN_ARB_MASK                                                          0x00400000L
#define DB_DEBUG3__DISABLE_RAM_READ_SUPPRESION_ON_FWD_MASK                                                    0x00800000L
#define DB_DEBUG3__DISABLE_EQAA_A2M_PERF_OPT_MASK                                                             0x01000000L
#define DB_DEBUG3__DISABLE_DI_DT_STALL_MASK                                                                   0x02000000L
#define DB_DEBUG3__ENABLE_DB_PROCESS_RESET_MASK                                                               0x04000000L
#define DB_DEBUG3__DISABLE_OVERRASTERIZATION_FIX_MASK                                                         0x08000000L
#define DB_DEBUG3__DONT_INSERT_CONTEXT_SUSPEND_MASK                                                           0x10000000L
#define DB_DEBUG3__DONT_DELETE_CONTEXT_SUSPEND_MASK                                                           0x20000000L
#define DB_DEBUG3__DISABLE_4XAA_2P_DELAYED_WRITE_MASK                                                         0x40000000L
#define DB_DEBUG3__DISABLE_4XAA_2P_INTERLEAVED_PMASK_MASK                                                     0x80000000L
//DB_DEBUG4
#define DB_DEBUG4__DISABLE_QC_Z_MASK_SUMMATION__SHIFT                                                         0x0
#define DB_DEBUG4__DISABLE_QC_STENCIL_MASK_SUMMATION__SHIFT                                                   0x1
#define DB_DEBUG4__DISABLE_RESUMM_TO_SINGLE_STENCIL__SHIFT                                                    0x2
#define DB_DEBUG4__DISABLE_PREZ_POSTZ_DTILE_CONFLICT_STALL__SHIFT                                             0x3
#define DB_DEBUG4__DISABLE_4XAA_2P_ZD_HOLDOFF__SHIFT                                                          0x4
#define DB_DEBUG4__ENABLE_A2M_DQUAD_OPTIMIZATION__SHIFT                                                       0x5
#define DB_DEBUG4__ENABLE_DBCB_SLOW_FORMAT_COLLAPSE__SHIFT                                                    0x6
#define DB_DEBUG4__ALWAYS_ON_RMI_CLK_EN__SHIFT                                                                0x7
#define DB_DEBUG4__DFSM_CONVERT_PASSTHROUGH_TO_BYPASS__SHIFT                                                  0x8
#define DB_DEBUG4__DISABLE_UNMAPPED_Z_INDICATOR__SHIFT                                                        0x9
#define DB_DEBUG4__DISABLE_UNMAPPED_S_INDICATOR__SHIFT                                                        0xa
#define DB_DEBUG4__DISABLE_UNMAPPED_H_INDICATOR__SHIFT                                                        0xb
#define DB_DEBUG4__DISABLE_SEPARATE_DFSM_CLK__SHIFT                                                           0xc
#define DB_DEBUG4__DISABLE_DTT_FAST_HTILENACK_LOOKUP__SHIFT                                                   0xd
#define DB_DEBUG4__DISABLE_RESCHECK_MEMCOHER_OPTIMIZATION__SHIFT                                              0xe
#define DB_DEBUG4__DISABLE_TS_WRITE_L0__SHIFT                                                                 0xf
#define DB_DEBUG4__DISABLE_DYNAMIC_RAM_LIGHT_SLEEP_MODE__SHIFT                                                0x10
#define DB_DEBUG4__DISABLE_HIZ_Q1_TS_COLLISION_DETECT__SHIFT                                                  0x11
#define DB_DEBUG4__DISABLE_HIZ_Q2_TS_COLLISION_DETECT__SHIFT                                                  0x12
#define DB_DEBUG4__DB_EXTRA_DEBUG4__SHIFT                                                                     0x13
#define DB_DEBUG4__DISABLE_QC_Z_MASK_SUMMATION_MASK                                                           0x00000001L
#define DB_DEBUG4__DISABLE_QC_STENCIL_MASK_SUMMATION_MASK                                                     0x00000002L
#define DB_DEBUG4__DISABLE_RESUMM_TO_SINGLE_STENCIL_MASK                                                      0x00000004L
#define DB_DEBUG4__DISABLE_PREZ_POSTZ_DTILE_CONFLICT_STALL_MASK                                               0x00000008L
#define DB_DEBUG4__DISABLE_4XAA_2P_ZD_HOLDOFF_MASK                                                            0x00000010L
#define DB_DEBUG4__ENABLE_A2M_DQUAD_OPTIMIZATION_MASK                                                         0x00000020L
#define DB_DEBUG4__ENABLE_DBCB_SLOW_FORMAT_COLLAPSE_MASK                                                      0x00000040L
#define DB_DEBUG4__ALWAYS_ON_RMI_CLK_EN_MASK                                                                  0x00000080L
#define DB_DEBUG4__DFSM_CONVERT_PASSTHROUGH_TO_BYPASS_MASK                                                    0x00000100L
#define DB_DEBUG4__DISABLE_UNMAPPED_Z_INDICATOR_MASK                                                          0x00000200L
#define DB_DEBUG4__DISABLE_UNMAPPED_S_INDICATOR_MASK                                                          0x00000400L
#define DB_DEBUG4__DISABLE_UNMAPPED_H_INDICATOR_MASK                                                          0x00000800L
#define DB_DEBUG4__DISABLE_SEPARATE_DFSM_CLK_MASK                                                             0x00001000L
#define DB_DEBUG4__DISABLE_DTT_FAST_HTILENACK_LOOKUP_MASK                                                     0x00002000L
#define DB_DEBUG4__DISABLE_RESCHECK_MEMCOHER_OPTIMIZATION_MASK                                                0x00004000L
#define DB_DEBUG4__DISABLE_TS_WRITE_L0_MASK                                                                   0x00008000L
#define DB_DEBUG4__DISABLE_DYNAMIC_RAM_LIGHT_SLEEP_MODE_MASK                                                  0x00010000L
#define DB_DEBUG4__DISABLE_HIZ_Q1_TS_COLLISION_DETECT_MASK                                                    0x00020000L
#define DB_DEBUG4__DISABLE_HIZ_Q2_TS_COLLISION_DETECT_MASK                                                    0x00040000L
#define DB_DEBUG4__DB_EXTRA_DEBUG4_MASK                                                                       0xFFF80000L
//DB_CREDIT_LIMIT
#define DB_CREDIT_LIMIT__DB_SC_TILE_CREDITS__SHIFT                                                            0x0
#define DB_CREDIT_LIMIT__DB_SC_QUAD_CREDITS__SHIFT                                                            0x5
#define DB_CREDIT_LIMIT__DB_CB_LQUAD_CREDITS__SHIFT                                                           0xa
#define DB_CREDIT_LIMIT__DB_CB_TILE_CREDITS__SHIFT                                                            0x18
#define DB_CREDIT_LIMIT__DB_SC_TILE_CREDITS_MASK                                                              0x0000001FL
#define DB_CREDIT_LIMIT__DB_SC_QUAD_CREDITS_MASK                                                              0x000003E0L
#define DB_CREDIT_LIMIT__DB_CB_LQUAD_CREDITS_MASK                                                             0x00001C00L
#define DB_CREDIT_LIMIT__DB_CB_TILE_CREDITS_MASK                                                              0x7F000000L
//DB_WATERMARKS
#define DB_WATERMARKS__DEPTH_FREE__SHIFT                                                                      0x0
#define DB_WATERMARKS__DEPTH_FLUSH__SHIFT                                                                     0x5
#define DB_WATERMARKS__FORCE_SUMMARIZE__SHIFT                                                                 0xb
#define DB_WATERMARKS__DEPTH_PENDING_FREE__SHIFT                                                              0xf
#define DB_WATERMARKS__DEPTH_CACHELINE_FREE__SHIFT                                                            0x14
#define DB_WATERMARKS__AUTO_FLUSH_HTILE__SHIFT                                                                0x1e
#define DB_WATERMARKS__AUTO_FLUSH_QUAD__SHIFT                                                                 0x1f
#define DB_WATERMARKS__DEPTH_FREE_MASK                                                                        0x0000001FL
#define DB_WATERMARKS__DEPTH_FLUSH_MASK                                                                       0x000007E0L
#define DB_WATERMARKS__FORCE_SUMMARIZE_MASK                                                                   0x00007800L
#define DB_WATERMARKS__DEPTH_PENDING_FREE_MASK                                                                0x000F8000L
#define DB_WATERMARKS__DEPTH_CACHELINE_FREE_MASK                                                              0x0FF00000L
#define DB_WATERMARKS__AUTO_FLUSH_HTILE_MASK                                                                  0x40000000L
#define DB_WATERMARKS__AUTO_FLUSH_QUAD_MASK                                                                   0x80000000L
//DB_SUBTILE_CONTROL
#define DB_SUBTILE_CONTROL__MSAA1_X__SHIFT                                                                    0x0
#define DB_SUBTILE_CONTROL__MSAA1_Y__SHIFT                                                                    0x2
#define DB_SUBTILE_CONTROL__MSAA2_X__SHIFT                                                                    0x4
#define DB_SUBTILE_CONTROL__MSAA2_Y__SHIFT                                                                    0x6
#define DB_SUBTILE_CONTROL__MSAA4_X__SHIFT                                                                    0x8
#define DB_SUBTILE_CONTROL__MSAA4_Y__SHIFT                                                                    0xa
#define DB_SUBTILE_CONTROL__MSAA8_X__SHIFT                                                                    0xc
#define DB_SUBTILE_CONTROL__MSAA8_Y__SHIFT                                                                    0xe
#define DB_SUBTILE_CONTROL__MSAA16_X__SHIFT                                                                   0x10
#define DB_SUBTILE_CONTROL__MSAA16_Y__SHIFT                                                                   0x12
#define DB_SUBTILE_CONTROL__MSAA1_X_MASK                                                                      0x00000003L
#define DB_SUBTILE_CONTROL__MSAA1_Y_MASK                                                                      0x0000000CL
#define DB_SUBTILE_CONTROL__MSAA2_X_MASK                                                                      0x00000030L
#define DB_SUBTILE_CONTROL__MSAA2_Y_MASK                                                                      0x000000C0L
#define DB_SUBTILE_CONTROL__MSAA4_X_MASK                                                                      0x00000300L
#define DB_SUBTILE_CONTROL__MSAA4_Y_MASK                                                                      0x00000C00L
#define DB_SUBTILE_CONTROL__MSAA8_X_MASK                                                                      0x00003000L
#define DB_SUBTILE_CONTROL__MSAA8_Y_MASK                                                                      0x0000C000L
#define DB_SUBTILE_CONTROL__MSAA16_X_MASK                                                                     0x00030000L
#define DB_SUBTILE_CONTROL__MSAA16_Y_MASK                                                                     0x000C0000L
//DB_FREE_CACHELINES
#define DB_FREE_CACHELINES__FREE_DTILE_DEPTH__SHIFT                                                           0x0
#define DB_FREE_CACHELINES__FREE_PLANE_DEPTH__SHIFT                                                           0x7
#define DB_FREE_CACHELINES__FREE_Z_DEPTH__SHIFT                                                               0xe
#define DB_FREE_CACHELINES__FREE_HTILE_DEPTH__SHIFT                                                           0x14
#define DB_FREE_CACHELINES__QUAD_READ_REQS__SHIFT                                                             0x18
#define DB_FREE_CACHELINES__FREE_DTILE_DEPTH_MASK                                                             0x0000007FL
#define DB_FREE_CACHELINES__FREE_PLANE_DEPTH_MASK                                                             0x00003F80L
#define DB_FREE_CACHELINES__FREE_Z_DEPTH_MASK                                                                 0x000FC000L
#define DB_FREE_CACHELINES__FREE_HTILE_DEPTH_MASK                                                             0x00F00000L
#define DB_FREE_CACHELINES__QUAD_READ_REQS_MASK                                                               0xFF000000L
//DB_FIFO_DEPTH1
#define DB_FIFO_DEPTH1__DB_RMI_RDREQ_CREDITS__SHIFT                                                           0x0
#define DB_FIFO_DEPTH1__DB_RMI_WRREQ_CREDITS__SHIFT                                                           0x5
#define DB_FIFO_DEPTH1__MCC_DEPTH__SHIFT                                                                      0xa
#define DB_FIFO_DEPTH1__QC_DEPTH__SHIFT                                                                       0x10
#define DB_FIFO_DEPTH1__LTILE_PROBE_FIFO_DEPTH__SHIFT                                                         0x15
#define DB_FIFO_DEPTH1__DB_RMI_RDREQ_CREDITS_MASK                                                             0x0000001FL
#define DB_FIFO_DEPTH1__DB_RMI_WRREQ_CREDITS_MASK                                                             0x000003E0L
#define DB_FIFO_DEPTH1__MCC_DEPTH_MASK                                                                        0x0000FC00L
#define DB_FIFO_DEPTH1__QC_DEPTH_MASK                                                                         0x001F0000L
#define DB_FIFO_DEPTH1__LTILE_PROBE_FIFO_DEPTH_MASK                                                           0x1FE00000L
//DB_FIFO_DEPTH2
#define DB_FIFO_DEPTH2__EQUAD_FIFO_DEPTH__SHIFT                                                               0x0
#define DB_FIFO_DEPTH2__ETILE_OP_FIFO_DEPTH__SHIFT                                                            0x8
#define DB_FIFO_DEPTH2__LQUAD_FIFO_DEPTH__SHIFT                                                               0xf
#define DB_FIFO_DEPTH2__LTILE_OP_FIFO_DEPTH__SHIFT                                                            0x19
#define DB_FIFO_DEPTH2__EQUAD_FIFO_DEPTH_MASK                                                                 0x000000FFL
#define DB_FIFO_DEPTH2__ETILE_OP_FIFO_DEPTH_MASK                                                              0x00007F00L
#define DB_FIFO_DEPTH2__LQUAD_FIFO_DEPTH_MASK                                                                 0x01FF8000L
#define DB_FIFO_DEPTH2__LTILE_OP_FIFO_DEPTH_MASK                                                              0xFE000000L
//DB_EXCEPTION_CONTROL
#define DB_EXCEPTION_CONTROL__EARLY_Z_PANIC_DISABLE__SHIFT                                                    0x0
#define DB_EXCEPTION_CONTROL__LATE_Z_PANIC_DISABLE__SHIFT                                                     0x1
#define DB_EXCEPTION_CONTROL__RE_Z_PANIC_DISABLE__SHIFT                                                       0x2
#define DB_EXCEPTION_CONTROL__EARLY_Z_PANIC_DISABLE_MASK                                                      0x00000001L
#define DB_EXCEPTION_CONTROL__LATE_Z_PANIC_DISABLE_MASK                                                       0x00000002L
#define DB_EXCEPTION_CONTROL__RE_Z_PANIC_DISABLE_MASK                                                         0x00000004L
//DB_RING_CONTROL
#define DB_RING_CONTROL__COUNTER_CONTROL__SHIFT                                                               0x0
#define DB_RING_CONTROL__COUNTER_CONTROL_MASK                                                                 0x00000003L
//DB_MEM_ARB_WATERMARKS
#define DB_MEM_ARB_WATERMARKS__CLIENT0_WATERMARK__SHIFT                                                       0x0
#define DB_MEM_ARB_WATERMARKS__CLIENT1_WATERMARK__SHIFT                                                       0x8
#define DB_MEM_ARB_WATERMARKS__CLIENT2_WATERMARK__SHIFT                                                       0x10
#define DB_MEM_ARB_WATERMARKS__CLIENT3_WATERMARK__SHIFT                                                       0x18
#define DB_MEM_ARB_WATERMARKS__CLIENT0_WATERMARK_MASK                                                         0x00000007L
#define DB_MEM_ARB_WATERMARKS__CLIENT1_WATERMARK_MASK                                                         0x00000700L
#define DB_MEM_ARB_WATERMARKS__CLIENT2_WATERMARK_MASK                                                         0x00070000L
#define DB_MEM_ARB_WATERMARKS__CLIENT3_WATERMARK_MASK                                                         0x07000000L
//DB_RMI_CACHE_POLICY
#define DB_RMI_CACHE_POLICY__Z_RD__SHIFT                                                                      0x0
#define DB_RMI_CACHE_POLICY__S_RD__SHIFT                                                                      0x1
#define DB_RMI_CACHE_POLICY__HTILE_RD__SHIFT                                                                  0x2
#define DB_RMI_CACHE_POLICY__Z_WR__SHIFT                                                                      0x8
#define DB_RMI_CACHE_POLICY__S_WR__SHIFT                                                                      0x9
#define DB_RMI_CACHE_POLICY__HTILE_WR__SHIFT                                                                  0xa
#define DB_RMI_CACHE_POLICY__ZPCPSD_WR__SHIFT                                                                 0xb
#define DB_RMI_CACHE_POLICY__CC_RD__SHIFT                                                                     0x10
#define DB_RMI_CACHE_POLICY__FMASK_RD__SHIFT                                                                  0x11
#define DB_RMI_CACHE_POLICY__CMASK_RD__SHIFT                                                                  0x12
#define DB_RMI_CACHE_POLICY__DCC_RD__SHIFT                                                                    0x13
#define DB_RMI_CACHE_POLICY__CC_WR__SHIFT                                                                     0x18
#define DB_RMI_CACHE_POLICY__FMASK_WR__SHIFT                                                                  0x19
#define DB_RMI_CACHE_POLICY__CMASK_WR__SHIFT                                                                  0x1a
#define DB_RMI_CACHE_POLICY__DCC_WR__SHIFT                                                                    0x1b
#define DB_RMI_CACHE_POLICY__Z_RD_MASK                                                                        0x00000001L
#define DB_RMI_CACHE_POLICY__S_RD_MASK                                                                        0x00000002L
#define DB_RMI_CACHE_POLICY__HTILE_RD_MASK                                                                    0x00000004L
#define DB_RMI_CACHE_POLICY__Z_WR_MASK                                                                        0x00000100L
#define DB_RMI_CACHE_POLICY__S_WR_MASK                                                                        0x00000200L
#define DB_RMI_CACHE_POLICY__HTILE_WR_MASK                                                                    0x00000400L
#define DB_RMI_CACHE_POLICY__ZPCPSD_WR_MASK                                                                   0x00000800L
#define DB_RMI_CACHE_POLICY__CC_RD_MASK                                                                       0x00010000L
#define DB_RMI_CACHE_POLICY__FMASK_RD_MASK                                                                    0x00020000L
#define DB_RMI_CACHE_POLICY__CMASK_RD_MASK                                                                    0x00040000L
#define DB_RMI_CACHE_POLICY__DCC_RD_MASK                                                                      0x00080000L
#define DB_RMI_CACHE_POLICY__CC_WR_MASK                                                                       0x01000000L
#define DB_RMI_CACHE_POLICY__FMASK_WR_MASK                                                                    0x02000000L
#define DB_RMI_CACHE_POLICY__CMASK_WR_MASK                                                                    0x04000000L
#define DB_RMI_CACHE_POLICY__DCC_WR_MASK                                                                      0x08000000L
//DB_DFSM_CONFIG
#define DB_DFSM_CONFIG__BYPASS_DFSM__SHIFT                                                                    0x0
#define DB_DFSM_CONFIG__DISABLE_PUNCHOUT__SHIFT                                                               0x1
#define DB_DFSM_CONFIG__DISABLE_POPS__SHIFT                                                                   0x2
#define DB_DFSM_CONFIG__FORCE_FLUSH__SHIFT                                                                    0x3
#define DB_DFSM_CONFIG__MIDDLE_PIPE_MAX_DEPTH__SHIFT                                                          0x8
#define DB_DFSM_CONFIG__BYPASS_DFSM_MASK                                                                      0x00000001L
#define DB_DFSM_CONFIG__DISABLE_PUNCHOUT_MASK                                                                 0x00000002L
#define DB_DFSM_CONFIG__DISABLE_POPS_MASK                                                                     0x00000004L
#define DB_DFSM_CONFIG__FORCE_FLUSH_MASK                                                                      0x00000008L
#define DB_DFSM_CONFIG__MIDDLE_PIPE_MAX_DEPTH_MASK                                                            0x00007F00L
//DB_DFSM_WATERMARK
#define DB_DFSM_WATERMARK__DFSM_HIGH_WATERMARK__SHIFT                                                         0x0
#define DB_DFSM_WATERMARK__POPS_HIGH_WATERMARK__SHIFT                                                         0x10
#define DB_DFSM_WATERMARK__DFSM_HIGH_WATERMARK_MASK                                                           0x0000FFFFL
#define DB_DFSM_WATERMARK__POPS_HIGH_WATERMARK_MASK                                                           0xFFFF0000L
//DB_DFSM_TILES_IN_FLIGHT
#define DB_DFSM_TILES_IN_FLIGHT__HIGH_WATERMARK__SHIFT                                                        0x0
#define DB_DFSM_TILES_IN_FLIGHT__HARD_LIMIT__SHIFT                                                            0x10
#define DB_DFSM_TILES_IN_FLIGHT__HIGH_WATERMARK_MASK                                                          0x0000FFFFL
#define DB_DFSM_TILES_IN_FLIGHT__HARD_LIMIT_MASK                                                              0xFFFF0000L
//DB_DFSM_PRIMS_IN_FLIGHT
#define DB_DFSM_PRIMS_IN_FLIGHT__HIGH_WATERMARK__SHIFT                                                        0x0
#define DB_DFSM_PRIMS_IN_FLIGHT__HARD_LIMIT__SHIFT                                                            0x10
#define DB_DFSM_PRIMS_IN_FLIGHT__HIGH_WATERMARK_MASK                                                          0x0000FFFFL
#define DB_DFSM_PRIMS_IN_FLIGHT__HARD_LIMIT_MASK                                                              0xFFFF0000L
//DB_DFSM_WATCHDOG
#define DB_DFSM_WATCHDOG__TIMER_TARGET__SHIFT                                                                 0x0
#define DB_DFSM_WATCHDOG__TIMER_TARGET_MASK                                                                   0xFFFFFFFFL
//DB_DFSM_FLUSH_ENABLE
#define DB_DFSM_FLUSH_ENABLE__PRIMARY_EVENTS__SHIFT                                                           0x0
#define DB_DFSM_FLUSH_ENABLE__AUX_FORCE_PASSTHRU__SHIFT                                                       0x18
#define DB_DFSM_FLUSH_ENABLE__AUX_EVENTS__SHIFT                                                               0x1c
#define DB_DFSM_FLUSH_ENABLE__PRIMARY_EVENTS_MASK                                                             0x000003FFL
#define DB_DFSM_FLUSH_ENABLE__AUX_FORCE_PASSTHRU_MASK                                                         0x0F000000L
#define DB_DFSM_FLUSH_ENABLE__AUX_EVENTS_MASK                                                                 0xF0000000L
//DB_DFSM_FLUSH_AUX_EVENT
#define DB_DFSM_FLUSH_AUX_EVENT__EVENT_A__SHIFT                                                               0x0
#define DB_DFSM_FLUSH_AUX_EVENT__EVENT_B__SHIFT                                                               0x8
#define DB_DFSM_FLUSH_AUX_EVENT__EVENT_C__SHIFT                                                               0x10
#define DB_DFSM_FLUSH_AUX_EVENT__EVENT_D__SHIFT                                                               0x18
#define DB_DFSM_FLUSH_AUX_EVENT__EVENT_A_MASK                                                                 0x000000FFL
#define DB_DFSM_FLUSH_AUX_EVENT__EVENT_B_MASK                                                                 0x0000FF00L
#define DB_DFSM_FLUSH_AUX_EVENT__EVENT_C_MASK                                                                 0x00FF0000L
#define DB_DFSM_FLUSH_AUX_EVENT__EVENT_D_MASK                                                                 0xFF000000L
//CC_RB_REDUNDANCY
#define CC_RB_REDUNDANCY__FAILED_RB0__SHIFT                                                                   0x8
#define CC_RB_REDUNDANCY__EN_REDUNDANCY0__SHIFT                                                               0xc
#define CC_RB_REDUNDANCY__FAILED_RB1__SHIFT                                                                   0x10
#define CC_RB_REDUNDANCY__EN_REDUNDANCY1__SHIFT                                                               0x14
#define CC_RB_REDUNDANCY__FAILED_RB0_MASK                                                                     0x00000F00L
#define CC_RB_REDUNDANCY__EN_REDUNDANCY0_MASK                                                                 0x00001000L
#define CC_RB_REDUNDANCY__FAILED_RB1_MASK                                                                     0x000F0000L
#define CC_RB_REDUNDANCY__EN_REDUNDANCY1_MASK                                                                 0x00100000L
//CC_RB_BACKEND_DISABLE
#define CC_RB_BACKEND_DISABLE__BACKEND_DISABLE__SHIFT                                                         0x10
#define CC_RB_BACKEND_DISABLE__BACKEND_DISABLE_MASK                                                           0x00FF0000L
//GB_ADDR_CONFIG
#define GB_ADDR_CONFIG__NUM_PIPES__SHIFT                                                                      0x0
#define GB_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE__SHIFT                                                           0x3
#define GB_ADDR_CONFIG__MAX_COMPRESSED_FRAGS__SHIFT                                                           0x6
#define GB_ADDR_CONFIG__BANK_INTERLEAVE_SIZE__SHIFT                                                           0x8
#define GB_ADDR_CONFIG__NUM_BANKS__SHIFT                                                                      0xc
#define GB_ADDR_CONFIG__SHADER_ENGINE_TILE_SIZE__SHIFT                                                        0x10
#define GB_ADDR_CONFIG__NUM_SHADER_ENGINES__SHIFT                                                             0x13
#define GB_ADDR_CONFIG__NUM_GPUS__SHIFT                                                                       0x15
#define GB_ADDR_CONFIG__MULTI_GPU_TILE_SIZE__SHIFT                                                            0x18
#define GB_ADDR_CONFIG__NUM_RB_PER_SE__SHIFT                                                                  0x1a
#define GB_ADDR_CONFIG__ROW_SIZE__SHIFT                                                                       0x1c
#define GB_ADDR_CONFIG__NUM_LOWER_PIPES__SHIFT                                                                0x1e
#define GB_ADDR_CONFIG__SE_ENABLE__SHIFT                                                                      0x1f
#define GB_ADDR_CONFIG__NUM_PIPES_MASK                                                                        0x00000007L
#define GB_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE_MASK                                                             0x00000038L
#define GB_ADDR_CONFIG__MAX_COMPRESSED_FRAGS_MASK                                                             0x000000C0L
#define GB_ADDR_CONFIG__BANK_INTERLEAVE_SIZE_MASK                                                             0x00000700L
#define GB_ADDR_CONFIG__NUM_BANKS_MASK                                                                        0x00007000L
#define GB_ADDR_CONFIG__SHADER_ENGINE_TILE_SIZE_MASK                                                          0x00070000L
#define GB_ADDR_CONFIG__NUM_SHADER_ENGINES_MASK                                                               0x00180000L
#define GB_ADDR_CONFIG__NUM_GPUS_MASK                                                                         0x00E00000L
#define GB_ADDR_CONFIG__MULTI_GPU_TILE_SIZE_MASK                                                              0x03000000L
#define GB_ADDR_CONFIG__NUM_RB_PER_SE_MASK                                                                    0x0C000000L
#define GB_ADDR_CONFIG__ROW_SIZE_MASK                                                                         0x30000000L
#define GB_ADDR_CONFIG__NUM_LOWER_PIPES_MASK                                                                  0x40000000L
#define GB_ADDR_CONFIG__SE_ENABLE_MASK                                                                        0x80000000L
//GB_BACKEND_MAP
#define GB_BACKEND_MAP__BACKEND_MAP__SHIFT                                                                    0x0
#define GB_BACKEND_MAP__BACKEND_MAP_MASK                                                                      0xFFFFFFFFL
//GB_GPU_ID
#define GB_GPU_ID__GPU_ID__SHIFT                                                                              0x0
#define GB_GPU_ID__GPU_ID_MASK                                                                                0x0000000FL
//CC_RB_DAISY_CHAIN
#define CC_RB_DAISY_CHAIN__RB_0__SHIFT                                                                        0x0
#define CC_RB_DAISY_CHAIN__RB_1__SHIFT                                                                        0x4
#define CC_RB_DAISY_CHAIN__RB_2__SHIFT                                                                        0x8
#define CC_RB_DAISY_CHAIN__RB_3__SHIFT                                                                        0xc
#define CC_RB_DAISY_CHAIN__RB_4__SHIFT                                                                        0x10
#define CC_RB_DAISY_CHAIN__RB_5__SHIFT                                                                        0x14
#define CC_RB_DAISY_CHAIN__RB_6__SHIFT                                                                        0x18
#define CC_RB_DAISY_CHAIN__RB_7__SHIFT                                                                        0x1c
#define CC_RB_DAISY_CHAIN__RB_0_MASK                                                                          0x0000000FL
#define CC_RB_DAISY_CHAIN__RB_1_MASK                                                                          0x000000F0L
#define CC_RB_DAISY_CHAIN__RB_2_MASK                                                                          0x00000F00L
#define CC_RB_DAISY_CHAIN__RB_3_MASK                                                                          0x0000F000L
#define CC_RB_DAISY_CHAIN__RB_4_MASK                                                                          0x000F0000L
#define CC_RB_DAISY_CHAIN__RB_5_MASK                                                                          0x00F00000L
#define CC_RB_DAISY_CHAIN__RB_6_MASK                                                                          0x0F000000L
#define CC_RB_DAISY_CHAIN__RB_7_MASK                                                                          0xF0000000L
//GB_ADDR_CONFIG_READ
#define GB_ADDR_CONFIG_READ__NUM_PIPES__SHIFT                                                                 0x0
#define GB_ADDR_CONFIG_READ__PIPE_INTERLEAVE_SIZE__SHIFT                                                      0x3
#define GB_ADDR_CONFIG_READ__MAX_COMPRESSED_FRAGS__SHIFT                                                      0x6
#define GB_ADDR_CONFIG_READ__BANK_INTERLEAVE_SIZE__SHIFT                                                      0x8
#define GB_ADDR_CONFIG_READ__NUM_BANKS__SHIFT                                                                 0xc
#define GB_ADDR_CONFIG_READ__SHADER_ENGINE_TILE_SIZE__SHIFT                                                   0x10
#define GB_ADDR_CONFIG_READ__NUM_SHADER_ENGINES__SHIFT                                                        0x13
#define GB_ADDR_CONFIG_READ__NUM_GPUS__SHIFT                                                                  0x15
#define GB_ADDR_CONFIG_READ__MULTI_GPU_TILE_SIZE__SHIFT                                                       0x18
#define GB_ADDR_CONFIG_READ__NUM_RB_PER_SE__SHIFT                                                             0x1a
#define GB_ADDR_CONFIG_READ__ROW_SIZE__SHIFT                                                                  0x1c
#define GB_ADDR_CONFIG_READ__NUM_LOWER_PIPES__SHIFT                                                           0x1e
#define GB_ADDR_CONFIG_READ__SE_ENABLE__SHIFT                                                                 0x1f
#define GB_ADDR_CONFIG_READ__NUM_PIPES_MASK                                                                   0x00000007L
#define GB_ADDR_CONFIG_READ__PIPE_INTERLEAVE_SIZE_MASK                                                        0x00000038L
#define GB_ADDR_CONFIG_READ__MAX_COMPRESSED_FRAGS_MASK                                                        0x000000C0L
#define GB_ADDR_CONFIG_READ__BANK_INTERLEAVE_SIZE_MASK                                                        0x00000700L
#define GB_ADDR_CONFIG_READ__NUM_BANKS_MASK                                                                   0x00007000L
#define GB_ADDR_CONFIG_READ__SHADER_ENGINE_TILE_SIZE_MASK                                                     0x00070000L
#define GB_ADDR_CONFIG_READ__NUM_SHADER_ENGINES_MASK                                                          0x00180000L
#define GB_ADDR_CONFIG_READ__NUM_GPUS_MASK                                                                    0x00E00000L
#define GB_ADDR_CONFIG_READ__MULTI_GPU_TILE_SIZE_MASK                                                         0x03000000L
#define GB_ADDR_CONFIG_READ__NUM_RB_PER_SE_MASK                                                               0x0C000000L
#define GB_ADDR_CONFIG_READ__ROW_SIZE_MASK                                                                    0x30000000L
#define GB_ADDR_CONFIG_READ__NUM_LOWER_PIPES_MASK                                                             0x40000000L
#define GB_ADDR_CONFIG_READ__SE_ENABLE_MASK                                                                   0x80000000L
//GB_TILE_MODE0
#define GB_TILE_MODE0__ARRAY_MODE__SHIFT                                                                      0x2
#define GB_TILE_MODE0__PIPE_CONFIG__SHIFT                                                                     0x6
#define GB_TILE_MODE0__TILE_SPLIT__SHIFT                                                                      0xb
#define GB_TILE_MODE0__MICRO_TILE_MODE_NEW__SHIFT                                                             0x16
#define GB_TILE_MODE0__SAMPLE_SPLIT__SHIFT                                                                    0x19
#define GB_TILE_MODE0__ARRAY_MODE_MASK                                                                        0x0000003CL
#define GB_TILE_MODE0__PIPE_CONFIG_MASK                                                                       0x000007C0L
#define GB_TILE_MODE0__TILE_SPLIT_MASK                                                                        0x00003800L
#define GB_TILE_MODE0__MICRO_TILE_MODE_NEW_MASK                                                               0x01C00000L
#define GB_TILE_MODE0__SAMPLE_SPLIT_MASK                                                                      0x06000000L
//GB_TILE_MODE1
#define GB_TILE_MODE1__ARRAY_MODE__SHIFT                                                                      0x2
#define GB_TILE_MODE1__PIPE_CONFIG__SHIFT                                                                     0x6
#define GB_TILE_MODE1__TILE_SPLIT__SHIFT                                                                      0xb
#define GB_TILE_MODE1__MICRO_TILE_MODE_NEW__SHIFT                                                             0x16
#define GB_TILE_MODE1__SAMPLE_SPLIT__SHIFT                                                                    0x19
#define GB_TILE_MODE1__ARRAY_MODE_MASK                                                                        0x0000003CL
#define GB_TILE_MODE1__PIPE_CONFIG_MASK                                                                       0x000007C0L
#define GB_TILE_MODE1__TILE_SPLIT_MASK                                                                        0x00003800L
#define GB_TILE_MODE1__MICRO_TILE_MODE_NEW_MASK                                                               0x01C00000L
#define GB_TILE_MODE1__SAMPLE_SPLIT_MASK                                                                      0x06000000L
//GB_TILE_MODE2
#define GB_TILE_MODE2__ARRAY_MODE__SHIFT                                                                      0x2
#define GB_TILE_MODE2__PIPE_CONFIG__SHIFT                                                                     0x6
#define GB_TILE_MODE2__TILE_SPLIT__SHIFT                                                                      0xb
#define GB_TILE_MODE2__MICRO_TILE_MODE_NEW__SHIFT                                                             0x16
#define GB_TILE_MODE2__SAMPLE_SPLIT__SHIFT                                                                    0x19
#define GB_TILE_MODE2__ARRAY_MODE_MASK                                                                        0x0000003CL
#define GB_TILE_MODE2__PIPE_CONFIG_MASK                                                                       0x000007C0L
#define GB_TILE_MODE2__TILE_SPLIT_MASK                                                                        0x00003800L
#define GB_TILE_MODE2__MICRO_TILE_MODE_NEW_MASK                                                               0x01C00000L
#define GB_TILE_MODE2__SAMPLE_SPLIT_MASK                                                                      0x06000000L
//GB_TILE_MODE3
#define GB_TILE_MODE3__ARRAY_MODE__SHIFT                                                                      0x2
#define GB_TILE_MODE3__PIPE_CONFIG__SHIFT                                                                     0x6
#define GB_TILE_MODE3__TILE_SPLIT__SHIFT                                                                      0xb
#define GB_TILE_MODE3__MICRO_TILE_MODE_NEW__SHIFT                                                             0x16
#define GB_TILE_MODE3__SAMPLE_SPLIT__SHIFT                                                                    0x19
#define GB_TILE_MODE3__ARRAY_MODE_MASK                                                                        0x0000003CL
#define GB_TILE_MODE3__PIPE_CONFIG_MASK                                                                       0x000007C0L
#define GB_TILE_MODE3__TILE_SPLIT_MASK                                                                        0x00003800L
#define GB_TILE_MODE3__MICRO_TILE_MODE_NEW_MASK                                                               0x01C00000L
#define GB_TILE_MODE3__SAMPLE_SPLIT_MASK                                                                      0x06000000L
//GB_TILE_MODE4
#define GB_TILE_MODE4__ARRAY_MODE__SHIFT                                                                      0x2
#define GB_TILE_MODE4__PIPE_CONFIG__SHIFT                                                                     0x6
#define GB_TILE_MODE4__TILE_SPLIT__SHIFT                                                                      0xb
#define GB_TILE_MODE4__MICRO_TILE_MODE_NEW__SHIFT                                                             0x16
#define GB_TILE_MODE4__SAMPLE_SPLIT__SHIFT                                                                    0x19
#define GB_TILE_MODE4__ARRAY_MODE_MASK                                                                        0x0000003CL
#define GB_TILE_MODE4__PIPE_CONFIG_MASK                                                                       0x000007C0L
#define GB_TILE_MODE4__TILE_SPLIT_MASK                                                                        0x00003800L
#define GB_TILE_MODE4__MICRO_TILE_MODE_NEW_MASK                                                               0x01C00000L
#define GB_TILE_MODE4__SAMPLE_SPLIT_MASK                                                                      0x06000000L
//GB_TILE_MODE5
#define GB_TILE_MODE5__ARRAY_MODE__SHIFT                                                                      0x2
#define GB_TILE_MODE5__PIPE_CONFIG__SHIFT                                                                     0x6
#define GB_TILE_MODE5__TILE_SPLIT__SHIFT                                                                      0xb
#define GB_TILE_MODE5__MICRO_TILE_MODE_NEW__SHIFT                                                             0x16
#define GB_TILE_MODE5__SAMPLE_SPLIT__SHIFT                                                                    0x19
#define GB_TILE_MODE5__ARRAY_MODE_MASK                                                                        0x0000003CL
#define GB_TILE_MODE5__PIPE_CONFIG_MASK                                                                       0x000007C0L
#define GB_TILE_MODE5__TILE_SPLIT_MASK                                                                        0x00003800L
#define GB_TILE_MODE5__MICRO_TILE_MODE_NEW_MASK                                                               0x01C00000L
#define GB_TILE_MODE5__SAMPLE_SPLIT_MASK                                                                      0x06000000L
//GB_TILE_MODE6
#define GB_TILE_MODE6__ARRAY_MODE__SHIFT                                                                      0x2
#define GB_TILE_MODE6__PIPE_CONFIG__SHIFT                                                                     0x6
#define GB_TILE_MODE6__TILE_SPLIT__SHIFT                                                                      0xb
#define GB_TILE_MODE6__MICRO_TILE_MODE_NEW__SHIFT                                                             0x16
#define GB_TILE_MODE6__SAMPLE_SPLIT__SHIFT                                                                    0x19
#define GB_TILE_MODE6__ARRAY_MODE_MASK                                                                        0x0000003CL
#define GB_TILE_MODE6__PIPE_CONFIG_MASK                                                                       0x000007C0L
#define GB_TILE_MODE6__TILE_SPLIT_MASK                                                                        0x00003800L
#define GB_TILE_MODE6__MICRO_TILE_MODE_NEW_MASK                                                               0x01C00000L
#define GB_TILE_MODE6__SAMPLE_SPLIT_MASK                                                                      0x06000000L
//GB_TILE_MODE7
#define GB_TILE_MODE7__ARRAY_MODE__SHIFT                                                                      0x2
#define GB_TILE_MODE7__PIPE_CONFIG__SHIFT                                                                     0x6
#define GB_TILE_MODE7__TILE_SPLIT__SHIFT                                                                      0xb
#define GB_TILE_MODE7__MICRO_TILE_MODE_NEW__SHIFT                                                             0x16
#define GB_TILE_MODE7__SAMPLE_SPLIT__SHIFT                                                                    0x19
#define GB_TILE_MODE7__ARRAY_MODE_MASK                                                                        0x0000003CL
#define GB_TILE_MODE7__PIPE_CONFIG_MASK                                                                       0x000007C0L
#define GB_TILE_MODE7__TILE_SPLIT_MASK                                                                        0x00003800L
#define GB_TILE_MODE7__MICRO_TILE_MODE_NEW_MASK                                                               0x01C00000L
#define GB_TILE_MODE7__SAMPLE_SPLIT_MASK                                                                      0x06000000L
//GB_TILE_MODE8
#define GB_TILE_MODE8__ARRAY_MODE__SHIFT                                                                      0x2
#define GB_TILE_MODE8__PIPE_CONFIG__SHIFT                                                                     0x6
#define GB_TILE_MODE8__TILE_SPLIT__SHIFT                                                                      0xb
#define GB_TILE_MODE8__MICRO_TILE_MODE_NEW__SHIFT                                                             0x16
#define GB_TILE_MODE8__SAMPLE_SPLIT__SHIFT                                                                    0x19
#define GB_TILE_MODE8__ARRAY_MODE_MASK                                                                        0x0000003CL
#define GB_TILE_MODE8__PIPE_CONFIG_MASK                                                                       0x000007C0L
#define GB_TILE_MODE8__TILE_SPLIT_MASK                                                                        0x00003800L
#define GB_TILE_MODE8__MICRO_TILE_MODE_NEW_MASK                                                               0x01C00000L
#define GB_TILE_MODE8__SAMPLE_SPLIT_MASK                                                                      0x06000000L
//GB_TILE_MODE9
#define GB_TILE_MODE9__ARRAY_MODE__SHIFT                                                                      0x2
#define GB_TILE_MODE9__PIPE_CONFIG__SHIFT                                                                     0x6
#define GB_TILE_MODE9__TILE_SPLIT__SHIFT                                                                      0xb
#define GB_TILE_MODE9__MICRO_TILE_MODE_NEW__SHIFT                                                             0x16
#define GB_TILE_MODE9__SAMPLE_SPLIT__SHIFT                                                                    0x19
#define GB_TILE_MODE9__ARRAY_MODE_MASK                                                                        0x0000003CL
#define GB_TILE_MODE9__PIPE_CONFIG_MASK                                                                       0x000007C0L
#define GB_TILE_MODE9__TILE_SPLIT_MASK                                                                        0x00003800L
#define GB_TILE_MODE9__MICRO_TILE_MODE_NEW_MASK                                                               0x01C00000L
#define GB_TILE_MODE9__SAMPLE_SPLIT_MASK                                                                      0x06000000L
//GB_TILE_MODE10
#define GB_TILE_MODE10__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE10__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE10__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE10__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE10__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE10__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE10__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE10__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE10__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE10__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE11
#define GB_TILE_MODE11__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE11__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE11__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE11__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE11__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE11__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE11__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE11__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE11__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE11__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE12
#define GB_TILE_MODE12__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE12__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE12__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE12__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE12__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE12__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE12__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE12__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE12__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE12__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE13
#define GB_TILE_MODE13__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE13__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE13__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE13__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE13__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE13__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE13__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE13__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE13__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE13__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE14
#define GB_TILE_MODE14__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE14__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE14__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE14__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE14__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE14__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE14__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE14__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE14__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE14__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE15
#define GB_TILE_MODE15__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE15__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE15__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE15__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE15__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE15__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE15__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE15__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE15__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE15__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE16
#define GB_TILE_MODE16__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE16__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE16__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE16__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE16__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE16__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE16__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE16__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE16__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE16__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE17
#define GB_TILE_MODE17__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE17__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE17__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE17__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE17__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE17__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE17__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE17__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE17__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE17__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE18
#define GB_TILE_MODE18__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE18__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE18__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE18__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE18__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE18__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE18__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE18__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE18__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE18__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE19
#define GB_TILE_MODE19__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE19__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE19__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE19__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE19__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE19__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE19__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE19__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE19__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE19__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE20
#define GB_TILE_MODE20__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE20__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE20__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE20__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE20__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE20__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE20__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE20__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE20__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE20__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE21
#define GB_TILE_MODE21__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE21__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE21__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE21__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE21__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE21__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE21__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE21__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE21__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE21__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE22
#define GB_TILE_MODE22__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE22__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE22__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE22__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE22__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE22__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE22__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE22__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE22__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE22__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE23
#define GB_TILE_MODE23__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE23__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE23__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE23__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE23__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE23__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE23__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE23__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE23__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE23__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE24
#define GB_TILE_MODE24__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE24__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE24__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE24__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE24__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE24__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE24__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE24__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE24__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE24__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE25
#define GB_TILE_MODE25__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE25__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE25__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE25__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE25__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE25__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE25__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE25__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE25__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE25__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE26
#define GB_TILE_MODE26__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE26__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE26__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE26__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE26__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE26__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE26__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE26__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE26__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE26__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE27
#define GB_TILE_MODE27__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE27__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE27__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE27__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE27__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE27__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE27__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE27__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE27__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE27__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE28
#define GB_TILE_MODE28__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE28__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE28__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE28__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE28__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE28__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE28__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE28__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE28__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE28__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE29
#define GB_TILE_MODE29__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE29__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE29__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE29__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE29__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE29__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE29__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE29__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE29__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE29__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE30
#define GB_TILE_MODE30__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE30__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE30__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE30__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE30__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE30__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE30__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE30__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE30__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE30__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_TILE_MODE31
#define GB_TILE_MODE31__ARRAY_MODE__SHIFT                                                                     0x2
#define GB_TILE_MODE31__PIPE_CONFIG__SHIFT                                                                    0x6
#define GB_TILE_MODE31__TILE_SPLIT__SHIFT                                                                     0xb
#define GB_TILE_MODE31__MICRO_TILE_MODE_NEW__SHIFT                                                            0x16
#define GB_TILE_MODE31__SAMPLE_SPLIT__SHIFT                                                                   0x19
#define GB_TILE_MODE31__ARRAY_MODE_MASK                                                                       0x0000003CL
#define GB_TILE_MODE31__PIPE_CONFIG_MASK                                                                      0x000007C0L
#define GB_TILE_MODE31__TILE_SPLIT_MASK                                                                       0x00003800L
#define GB_TILE_MODE31__MICRO_TILE_MODE_NEW_MASK                                                              0x01C00000L
#define GB_TILE_MODE31__SAMPLE_SPLIT_MASK                                                                     0x06000000L
//GB_MACROTILE_MODE0
#define GB_MACROTILE_MODE0__BANK_WIDTH__SHIFT                                                                 0x0
#define GB_MACROTILE_MODE0__BANK_HEIGHT__SHIFT                                                                0x2
#define GB_MACROTILE_MODE0__MACRO_TILE_ASPECT__SHIFT                                                          0x4
#define GB_MACROTILE_MODE0__NUM_BANKS__SHIFT                                                                  0x6
#define GB_MACROTILE_MODE0__BANK_WIDTH_MASK                                                                   0x00000003L
#define GB_MACROTILE_MODE0__BANK_HEIGHT_MASK                                                                  0x0000000CL
#define GB_MACROTILE_MODE0__MACRO_TILE_ASPECT_MASK                                                            0x00000030L
#define GB_MACROTILE_MODE0__NUM_BANKS_MASK                                                                    0x000000C0L
//GB_MACROTILE_MODE1
#define GB_MACROTILE_MODE1__BANK_WIDTH__SHIFT                                                                 0x0
#define GB_MACROTILE_MODE1__BANK_HEIGHT__SHIFT                                                                0x2
#define GB_MACROTILE_MODE1__MACRO_TILE_ASPECT__SHIFT                                                          0x4
#define GB_MACROTILE_MODE1__NUM_BANKS__SHIFT                                                                  0x6
#define GB_MACROTILE_MODE1__BANK_WIDTH_MASK                                                                   0x00000003L
#define GB_MACROTILE_MODE1__BANK_HEIGHT_MASK                                                                  0x0000000CL
#define GB_MACROTILE_MODE1__MACRO_TILE_ASPECT_MASK                                                            0x00000030L
#define GB_MACROTILE_MODE1__NUM_BANKS_MASK                                                                    0x000000C0L
//GB_MACROTILE_MODE2
#define GB_MACROTILE_MODE2__BANK_WIDTH__SHIFT                                                                 0x0
#define GB_MACROTILE_MODE2__BANK_HEIGHT__SHIFT                                                                0x2
#define GB_MACROTILE_MODE2__MACRO_TILE_ASPECT__SHIFT                                                          0x4
#define GB_MACROTILE_MODE2__NUM_BANKS__SHIFT                                                                  0x6
#define GB_MACROTILE_MODE2__BANK_WIDTH_MASK                                                                   0x00000003L
#define GB_MACROTILE_MODE2__BANK_HEIGHT_MASK                                                                  0x0000000CL
#define GB_MACROTILE_MODE2__MACRO_TILE_ASPECT_MASK                                                            0x00000030L
#define GB_MACROTILE_MODE2__NUM_BANKS_MASK                                                                    0x000000C0L
//GB_MACROTILE_MODE3
#define GB_MACROTILE_MODE3__BANK_WIDTH__SHIFT                                                                 0x0
#define GB_MACROTILE_MODE3__BANK_HEIGHT__SHIFT                                                                0x2
#define GB_MACROTILE_MODE3__MACRO_TILE_ASPECT__SHIFT                                                          0x4
#define GB_MACROTILE_MODE3__NUM_BANKS__SHIFT                                                                  0x6
#define GB_MACROTILE_MODE3__BANK_WIDTH_MASK                                                                   0x00000003L
#define GB_MACROTILE_MODE3__BANK_HEIGHT_MASK                                                                  0x0000000CL
#define GB_MACROTILE_MODE3__MACRO_TILE_ASPECT_MASK                                                            0x00000030L
#define GB_MACROTILE_MODE3__NUM_BANKS_MASK                                                                    0x000000C0L
//GB_MACROTILE_MODE4
#define GB_MACROTILE_MODE4__BANK_WIDTH__SHIFT                                                                 0x0
#define GB_MACROTILE_MODE4__BANK_HEIGHT__SHIFT                                                                0x2
#define GB_MACROTILE_MODE4__MACRO_TILE_ASPECT__SHIFT                                                          0x4
#define GB_MACROTILE_MODE4__NUM_BANKS__SHIFT                                                                  0x6
#define GB_MACROTILE_MODE4__BANK_WIDTH_MASK                                                                   0x00000003L
#define GB_MACROTILE_MODE4__BANK_HEIGHT_MASK                                                                  0x0000000CL
#define GB_MACROTILE_MODE4__MACRO_TILE_ASPECT_MASK                                                            0x00000030L
#define GB_MACROTILE_MODE4__NUM_BANKS_MASK                                                                    0x000000C0L
//GB_MACROTILE_MODE5
#define GB_MACROTILE_MODE5__BANK_WIDTH__SHIFT                                                                 0x0
#define GB_MACROTILE_MODE5__BANK_HEIGHT__SHIFT                                                                0x2
#define GB_MACROTILE_MODE5__MACRO_TILE_ASPECT__SHIFT                                                          0x4
#define GB_MACROTILE_MODE5__NUM_BANKS__SHIFT                                                                  0x6
#define GB_MACROTILE_MODE5__BANK_WIDTH_MASK                                                                   0x00000003L
#define GB_MACROTILE_MODE5__BANK_HEIGHT_MASK                                                                  0x0000000CL
#define GB_MACROTILE_MODE5__MACRO_TILE_ASPECT_MASK                                                            0x00000030L
#define GB_MACROTILE_MODE5__NUM_BANKS_MASK                                                                    0x000000C0L
//GB_MACROTILE_MODE6
#define GB_MACROTILE_MODE6__BANK_WIDTH__SHIFT                                                                 0x0
#define GB_MACROTILE_MODE6__BANK_HEIGHT__SHIFT                                                                0x2
#define GB_MACROTILE_MODE6__MACRO_TILE_ASPECT__SHIFT                                                          0x4
#define GB_MACROTILE_MODE6__NUM_BANKS__SHIFT                                                                  0x6
#define GB_MACROTILE_MODE6__BANK_WIDTH_MASK                                                                   0x00000003L
#define GB_MACROTILE_MODE6__BANK_HEIGHT_MASK                                                                  0x0000000CL
#define GB_MACROTILE_MODE6__MACRO_TILE_ASPECT_MASK                                                            0x00000030L
#define GB_MACROTILE_MODE6__NUM_BANKS_MASK                                                                    0x000000C0L
//GB_MACROTILE_MODE7
#define GB_MACROTILE_MODE7__BANK_WIDTH__SHIFT                                                                 0x0
#define GB_MACROTILE_MODE7__BANK_HEIGHT__SHIFT                                                                0x2
#define GB_MACROTILE_MODE7__MACRO_TILE_ASPECT__SHIFT                                                          0x4
#define GB_MACROTILE_MODE7__NUM_BANKS__SHIFT                                                                  0x6
#define GB_MACROTILE_MODE7__BANK_WIDTH_MASK                                                                   0x00000003L
#define GB_MACROTILE_MODE7__BANK_HEIGHT_MASK                                                                  0x0000000CL
#define GB_MACROTILE_MODE7__MACRO_TILE_ASPECT_MASK                                                            0x00000030L
#define GB_MACROTILE_MODE7__NUM_BANKS_MASK                                                                    0x000000C0L
//GB_MACROTILE_MODE8
#define GB_MACROTILE_MODE8__BANK_WIDTH__SHIFT                                                                 0x0
#define GB_MACROTILE_MODE8__BANK_HEIGHT__SHIFT                                                                0x2
#define GB_MACROTILE_MODE8__MACRO_TILE_ASPECT__SHIFT                                                          0x4
#define GB_MACROTILE_MODE8__NUM_BANKS__SHIFT                                                                  0x6
#define GB_MACROTILE_MODE8__BANK_WIDTH_MASK                                                                   0x00000003L
#define GB_MACROTILE_MODE8__BANK_HEIGHT_MASK                                                                  0x0000000CL
#define GB_MACROTILE_MODE8__MACRO_TILE_ASPECT_MASK                                                            0x00000030L
#define GB_MACROTILE_MODE8__NUM_BANKS_MASK                                                                    0x000000C0L
//GB_MACROTILE_MODE9
#define GB_MACROTILE_MODE9__BANK_WIDTH__SHIFT                                                                 0x0
#define GB_MACROTILE_MODE9__BANK_HEIGHT__SHIFT                                                                0x2
#define GB_MACROTILE_MODE9__MACRO_TILE_ASPECT__SHIFT                                                          0x4
#define GB_MACROTILE_MODE9__NUM_BANKS__SHIFT                                                                  0x6
#define GB_MACROTILE_MODE9__BANK_WIDTH_MASK                                                                   0x00000003L
#define GB_MACROTILE_MODE9__BANK_HEIGHT_MASK                                                                  0x0000000CL
#define GB_MACROTILE_MODE9__MACRO_TILE_ASPECT_MASK                                                            0x00000030L
#define GB_MACROTILE_MODE9__NUM_BANKS_MASK                                                                    0x000000C0L
//GB_MACROTILE_MODE10
#define GB_MACROTILE_MODE10__BANK_WIDTH__SHIFT                                                                0x0
#define GB_MACROTILE_MODE10__BANK_HEIGHT__SHIFT                                                               0x2
#define GB_MACROTILE_MODE10__MACRO_TILE_ASPECT__SHIFT                                                         0x4
#define GB_MACROTILE_MODE10__NUM_BANKS__SHIFT                                                                 0x6
#define GB_MACROTILE_MODE10__BANK_WIDTH_MASK                                                                  0x00000003L
#define GB_MACROTILE_MODE10__BANK_HEIGHT_MASK                                                                 0x0000000CL
#define GB_MACROTILE_MODE10__MACRO_TILE_ASPECT_MASK                                                           0x00000030L
#define GB_MACROTILE_MODE10__NUM_BANKS_MASK                                                                   0x000000C0L
//GB_MACROTILE_MODE11
#define GB_MACROTILE_MODE11__BANK_WIDTH__SHIFT                                                                0x0
#define GB_MACROTILE_MODE11__BANK_HEIGHT__SHIFT                                                               0x2
#define GB_MACROTILE_MODE11__MACRO_TILE_ASPECT__SHIFT                                                         0x4
#define GB_MACROTILE_MODE11__NUM_BANKS__SHIFT                                                                 0x6
#define GB_MACROTILE_MODE11__BANK_WIDTH_MASK                                                                  0x00000003L
#define GB_MACROTILE_MODE11__BANK_HEIGHT_MASK                                                                 0x0000000CL
#define GB_MACROTILE_MODE11__MACRO_TILE_ASPECT_MASK                                                           0x00000030L
#define GB_MACROTILE_MODE11__NUM_BANKS_MASK                                                                   0x000000C0L
//GB_MACROTILE_MODE12
#define GB_MACROTILE_MODE12__BANK_WIDTH__SHIFT                                                                0x0
#define GB_MACROTILE_MODE12__BANK_HEIGHT__SHIFT                                                               0x2
#define GB_MACROTILE_MODE12__MACRO_TILE_ASPECT__SHIFT                                                         0x4
#define GB_MACROTILE_MODE12__NUM_BANKS__SHIFT                                                                 0x6
#define GB_MACROTILE_MODE12__BANK_WIDTH_MASK                                                                  0x00000003L
#define GB_MACROTILE_MODE12__BANK_HEIGHT_MASK                                                                 0x0000000CL
#define GB_MACROTILE_MODE12__MACRO_TILE_ASPECT_MASK                                                           0x00000030L
#define GB_MACROTILE_MODE12__NUM_BANKS_MASK                                                                   0x000000C0L
//GB_MACROTILE_MODE13
#define GB_MACROTILE_MODE13__BANK_WIDTH__SHIFT                                                                0x0
#define GB_MACROTILE_MODE13__BANK_HEIGHT__SHIFT                                                               0x2
#define GB_MACROTILE_MODE13__MACRO_TILE_ASPECT__SHIFT                                                         0x4
#define GB_MACROTILE_MODE13__NUM_BANKS__SHIFT                                                                 0x6
#define GB_MACROTILE_MODE13__BANK_WIDTH_MASK                                                                  0x00000003L
#define GB_MACROTILE_MODE13__BANK_HEIGHT_MASK                                                                 0x0000000CL
#define GB_MACROTILE_MODE13__MACRO_TILE_ASPECT_MASK                                                           0x00000030L
#define GB_MACROTILE_MODE13__NUM_BANKS_MASK                                                                   0x000000C0L
//GB_MACROTILE_MODE14
#define GB_MACROTILE_MODE14__BANK_WIDTH__SHIFT                                                                0x0
#define GB_MACROTILE_MODE14__BANK_HEIGHT__SHIFT                                                               0x2
#define GB_MACROTILE_MODE14__MACRO_TILE_ASPECT__SHIFT                                                         0x4
#define GB_MACROTILE_MODE14__NUM_BANKS__SHIFT                                                                 0x6
#define GB_MACROTILE_MODE14__BANK_WIDTH_MASK                                                                  0x00000003L
#define GB_MACROTILE_MODE14__BANK_HEIGHT_MASK                                                                 0x0000000CL
#define GB_MACROTILE_MODE14__MACRO_TILE_ASPECT_MASK                                                           0x00000030L
#define GB_MACROTILE_MODE14__NUM_BANKS_MASK                                                                   0x000000C0L
//GB_MACROTILE_MODE15
#define GB_MACROTILE_MODE15__BANK_WIDTH__SHIFT                                                                0x0
#define GB_MACROTILE_MODE15__BANK_HEIGHT__SHIFT                                                               0x2
#define GB_MACROTILE_MODE15__MACRO_TILE_ASPECT__SHIFT                                                         0x4
#define GB_MACROTILE_MODE15__NUM_BANKS__SHIFT                                                                 0x6
#define GB_MACROTILE_MODE15__BANK_WIDTH_MASK                                                                  0x00000003L
#define GB_MACROTILE_MODE15__BANK_HEIGHT_MASK                                                                 0x0000000CL
#define GB_MACROTILE_MODE15__MACRO_TILE_ASPECT_MASK                                                           0x00000030L
#define GB_MACROTILE_MODE15__NUM_BANKS_MASK                                                                   0x000000C0L
//CB_HW_CONTROL
#define CB_HW_CONTROL__CM_CACHE_EVICT_POINT__SHIFT                                                            0x0
#define CB_HW_CONTROL__FC_CACHE_EVICT_POINT__SHIFT                                                            0x6
#define CB_HW_CONTROL__CC_CACHE_EVICT_POINT__SHIFT                                                            0xc
#define CB_HW_CONTROL__ALLOW_MRT_WITH_DUAL_SOURCE__SHIFT                                                      0x10
#define CB_HW_CONTROL__DISABLE_INTNORM_LE11BPC_CLAMPING__SHIFT                                                0x12
#define CB_HW_CONTROL__FORCE_NEEDS_DST__SHIFT                                                                 0x13
#define CB_HW_CONTROL__FORCE_ALWAYS_TOGGLE__SHIFT                                                             0x14
#define CB_HW_CONTROL__DISABLE_BLEND_OPT_RESULT_EQ_DEST__SHIFT                                                0x15
#define CB_HW_CONTROL__DISABLE_FULL_WRITE_MASK__SHIFT                                                         0x16
#define CB_HW_CONTROL__DISABLE_RESOLVE_OPT_FOR_SINGLE_FRAG__SHIFT                                             0x17
#define CB_HW_CONTROL__DISABLE_BLEND_OPT_DONT_RD_DST__SHIFT                                                   0x18
#define CB_HW_CONTROL__DISABLE_BLEND_OPT_BYPASS__SHIFT                                                        0x19
#define CB_HW_CONTROL__DISABLE_BLEND_OPT_DISCARD_PIXEL__SHIFT                                                 0x1a
#define CB_HW_CONTROL__DISABLE_BLEND_OPT_WHEN_DISABLED_SRCALPHA_IS_USED__SHIFT                                0x1b
#define CB_HW_CONTROL__PRIORITIZE_FC_WR_OVER_FC_RD_ON_CMASK_CONFLICT__SHIFT                                   0x1c
#define CB_HW_CONTROL__PRIORITIZE_FC_EVICT_OVER_FOP_RD_ON_BANK_CONFLICT__SHIFT                                0x1d
#define CB_HW_CONTROL__DISABLE_CC_IB_SERIALIZER_STATE_OPT__SHIFT                                              0x1e
#define CB_HW_CONTROL__DISABLE_PIXEL_IN_QUAD_FIX_FOR_LINEAR_SURFACE__SHIFT                                    0x1f
#define CB_HW_CONTROL__CM_CACHE_EVICT_POINT_MASK                                                              0x0000000FL
#define CB_HW_CONTROL__FC_CACHE_EVICT_POINT_MASK                                                              0x000003C0L
#define CB_HW_CONTROL__CC_CACHE_EVICT_POINT_MASK                                                              0x0000F000L
#define CB_HW_CONTROL__ALLOW_MRT_WITH_DUAL_SOURCE_MASK                                                        0x00010000L
#define CB_HW_CONTROL__DISABLE_INTNORM_LE11BPC_CLAMPING_MASK                                                  0x00040000L
#define CB_HW_CONTROL__FORCE_NEEDS_DST_MASK                                                                   0x00080000L
#define CB_HW_CONTROL__FORCE_ALWAYS_TOGGLE_MASK                                                               0x00100000L
#define CB_HW_CONTROL__DISABLE_BLEND_OPT_RESULT_EQ_DEST_MASK                                                  0x00200000L
#define CB_HW_CONTROL__DISABLE_FULL_WRITE_MASK_MASK                                                           0x00400000L
#define CB_HW_CONTROL__DISABLE_RESOLVE_OPT_FOR_SINGLE_FRAG_MASK                                               0x00800000L
#define CB_HW_CONTROL__DISABLE_BLEND_OPT_DONT_RD_DST_MASK                                                     0x01000000L
#define CB_HW_CONTROL__DISABLE_BLEND_OPT_BYPASS_MASK                                                          0x02000000L
#define CB_HW_CONTROL__DISABLE_BLEND_OPT_DISCARD_PIXEL_MASK                                                   0x04000000L
#define CB_HW_CONTROL__DISABLE_BLEND_OPT_WHEN_DISABLED_SRCALPHA_IS_USED_MASK                                  0x08000000L
#define CB_HW_CONTROL__PRIORITIZE_FC_WR_OVER_FC_RD_ON_CMASK_CONFLICT_MASK                                     0x10000000L
#define CB_HW_CONTROL__PRIORITIZE_FC_EVICT_OVER_FOP_RD_ON_BANK_CONFLICT_MASK                                  0x20000000L
#define CB_HW_CONTROL__DISABLE_CC_IB_SERIALIZER_STATE_OPT_MASK                                                0x40000000L
#define CB_HW_CONTROL__DISABLE_PIXEL_IN_QUAD_FIX_FOR_LINEAR_SURFACE_MASK                                      0x80000000L
//CB_HW_CONTROL_1
#define CB_HW_CONTROL_1__CM_CACHE_NUM_TAGS__SHIFT                                                             0x0
#define CB_HW_CONTROL_1__FC_CACHE_NUM_TAGS__SHIFT                                                             0x5
#define CB_HW_CONTROL_1__CC_CACHE_NUM_TAGS__SHIFT                                                             0xb
#define CB_HW_CONTROL_1__CM_TILE_FIFO_DEPTH__SHIFT                                                            0x11
#define CB_HW_CONTROL_1__RMI_CREDITS__SHIFT                                                                   0x1a
#define CB_HW_CONTROL_1__CM_CACHE_NUM_TAGS_MASK                                                               0x0000001FL
#define CB_HW_CONTROL_1__FC_CACHE_NUM_TAGS_MASK                                                               0x000007E0L
#define CB_HW_CONTROL_1__CC_CACHE_NUM_TAGS_MASK                                                               0x0001F800L
#define CB_HW_CONTROL_1__CM_TILE_FIFO_DEPTH_MASK                                                              0x03FE0000L
#define CB_HW_CONTROL_1__RMI_CREDITS_MASK                                                                     0xFC000000L
//CB_HW_CONTROL_2
#define CB_HW_CONTROL_2__CC_EVEN_ODD_FIFO_DEPTH__SHIFT                                                        0x0
#define CB_HW_CONTROL_2__FC_RDLAT_TILE_FIFO_DEPTH__SHIFT                                                      0x8
#define CB_HW_CONTROL_2__FC_RDLAT_QUAD_FIFO_DEPTH__SHIFT                                                      0xf
#define CB_HW_CONTROL_2__DRR_ASSUMED_FIFO_DEPTH_DIV8__SHIFT                                                   0x18
#define CB_HW_CONTROL_2__CHICKEN_BITS__SHIFT                                                                  0x1c
#define CB_HW_CONTROL_2__CC_EVEN_ODD_FIFO_DEPTH_MASK                                                          0x000000FFL
#define CB_HW_CONTROL_2__FC_RDLAT_TILE_FIFO_DEPTH_MASK                                                        0x00007F00L
#define CB_HW_CONTROL_2__FC_RDLAT_QUAD_FIFO_DEPTH_MASK                                                        0x007F8000L
#define CB_HW_CONTROL_2__DRR_ASSUMED_FIFO_DEPTH_DIV8_MASK                                                     0x0F000000L
#define CB_HW_CONTROL_2__CHICKEN_BITS_MASK                                                                    0xF0000000L
//CB_HW_CONTROL_3
#define CB_HW_CONTROL_3__DISABLE_SLOW_MODE_EMPTY_HALF_QUAD_KILL__SHIFT                                        0x0
#define CB_HW_CONTROL_3__RAM_ADDRESS_CONFLICTS_DISALLOWED__SHIFT                                              0x1
#define CB_HW_CONTROL_3__DISABLE_FAST_CLEAR_FETCH_OPT__SHIFT                                                  0x2
#define CB_HW_CONTROL_3__DISABLE_QUAD_MARKER_DROP_STOP__SHIFT                                                 0x3
#define CB_HW_CONTROL_3__DISABLE_OVERWRITE_COMBINER_CAM_CLR__SHIFT                                            0x4
#define CB_HW_CONTROL_3__DISABLE_CC_CACHE_OVWR_STATUS_ACCUM__SHIFT                                            0x5
#define CB_HW_CONTROL_3__DISABLE_CC_CACHE_OVWR_KEY_MOD__SHIFT                                                 0x6
#define CB_HW_CONTROL_3__DISABLE_CC_CACHE_PANIC_GATING__SHIFT                                                 0x7
#define CB_HW_CONTROL_3__DISABLE_OVERWRITE_COMBINER_TARGET_MASK_VALIDATION__SHIFT                             0x8
#define CB_HW_CONTROL_3__SPLIT_ALL_FAST_MODE_TRANSFERS__SHIFT                                                 0x9
#define CB_HW_CONTROL_3__DISABLE_SHADER_BLEND_OPTS__SHIFT                                                     0xa
#define CB_HW_CONTROL_3__DISABLE_CMASK_LAST_QUAD_INSERTION__SHIFT                                             0xb
#define CB_HW_CONTROL_3__DISABLE_ROP3_FIXES_OF_BUG_511967__SHIFT                                              0xc
#define CB_HW_CONTROL_3__DISABLE_ROP3_FIXES_OF_BUG_520657__SHIFT                                              0xd
#define CB_HW_CONTROL_3__DISABLE_OC_FIXES_OF_BUG_522542__SHIFT                                                0xe
#define CB_HW_CONTROL_3__FORCE_RMI_LAST_HIGH__SHIFT                                                           0xf
#define CB_HW_CONTROL_3__FORCE_RMI_CLKEN_HIGH__SHIFT                                                          0x10
#define CB_HW_CONTROL_3__DISABLE_EARLY_WRACKS_CC__SHIFT                                                       0x11
#define CB_HW_CONTROL_3__DISABLE_EARLY_WRACKS_FC__SHIFT                                                       0x12
#define CB_HW_CONTROL_3__DISABLE_EARLY_WRACKS_DC__SHIFT                                                       0x13
#define CB_HW_CONTROL_3__DISABLE_EARLY_WRACKS_CM__SHIFT                                                       0x14
#define CB_HW_CONTROL_3__DISABLE_NACK_PROCESSING_CC__SHIFT                                                    0x15
#define CB_HW_CONTROL_3__DISABLE_NACK_PROCESSING_FC__SHIFT                                                    0x16
#define CB_HW_CONTROL_3__DISABLE_NACK_PROCESSING_DC__SHIFT                                                    0x17
#define CB_HW_CONTROL_3__DISABLE_NACK_PROCESSING_CM__SHIFT                                                    0x18
#define CB_HW_CONTROL_3__DISABLE_NACK_COLOR_RD_WR_OPT__SHIFT                                                  0x19
#define CB_HW_CONTROL_3__DISABLE_BLENDER_CLOCK_GATING__SHIFT                                                  0x1a
#define CB_HW_CONTROL_3__DISABLE_DUALSRC_WITH_OBJPRIMID_FIX__SHIFT                                            0x1b
#define CB_HW_CONTROL_3__COLOR_CACHE_PREFETCH_NUM_CLS__SHIFT                                                  0x1c
#define CB_HW_CONTROL_3__DISABLE_SLOW_MODE_EMPTY_HALF_QUAD_KILL_MASK                                          0x00000001L
#define CB_HW_CONTROL_3__RAM_ADDRESS_CONFLICTS_DISALLOWED_MASK                                                0x00000002L
#define CB_HW_CONTROL_3__DISABLE_FAST_CLEAR_FETCH_OPT_MASK                                                    0x00000004L
#define CB_HW_CONTROL_3__DISABLE_QUAD_MARKER_DROP_STOP_MASK                                                   0x00000008L
#define CB_HW_CONTROL_3__DISABLE_OVERWRITE_COMBINER_CAM_CLR_MASK                                              0x00000010L
#define CB_HW_CONTROL_3__DISABLE_CC_CACHE_OVWR_STATUS_ACCUM_MASK                                              0x00000020L
#define CB_HW_CONTROL_3__DISABLE_CC_CACHE_OVWR_KEY_MOD_MASK                                                   0x00000040L
#define CB_HW_CONTROL_3__DISABLE_CC_CACHE_PANIC_GATING_MASK                                                   0x00000080L
#define CB_HW_CONTROL_3__DISABLE_OVERWRITE_COMBINER_TARGET_MASK_VALIDATION_MASK                               0x00000100L
#define CB_HW_CONTROL_3__SPLIT_ALL_FAST_MODE_TRANSFERS_MASK                                                   0x00000200L
#define CB_HW_CONTROL_3__DISABLE_SHADER_BLEND_OPTS_MASK                                                       0x00000400L
#define CB_HW_CONTROL_3__DISABLE_CMASK_LAST_QUAD_INSERTION_MASK                                               0x00000800L
#define CB_HW_CONTROL_3__DISABLE_ROP3_FIXES_OF_BUG_511967_MASK                                                0x00001000L
#define CB_HW_CONTROL_3__DISABLE_ROP3_FIXES_OF_BUG_520657_MASK                                                0x00002000L
#define CB_HW_CONTROL_3__DISABLE_OC_FIXES_OF_BUG_522542_MASK                                                  0x00004000L
#define CB_HW_CONTROL_3__FORCE_RMI_LAST_HIGH_MASK                                                             0x00008000L
#define CB_HW_CONTROL_3__FORCE_RMI_CLKEN_HIGH_MASK                                                            0x00010000L
#define CB_HW_CONTROL_3__DISABLE_EARLY_WRACKS_CC_MASK                                                         0x00020000L
#define CB_HW_CONTROL_3__DISABLE_EARLY_WRACKS_FC_MASK                                                         0x00040000L
#define CB_HW_CONTROL_3__DISABLE_EARLY_WRACKS_DC_MASK                                                         0x00080000L
#define CB_HW_CONTROL_3__DISABLE_EARLY_WRACKS_CM_MASK                                                         0x00100000L
#define CB_HW_CONTROL_3__DISABLE_NACK_PROCESSING_CC_MASK                                                      0x00200000L
#define CB_HW_CONTROL_3__DISABLE_NACK_PROCESSING_FC_MASK                                                      0x00400000L
#define CB_HW_CONTROL_3__DISABLE_NACK_PROCESSING_DC_MASK                                                      0x00800000L
#define CB_HW_CONTROL_3__DISABLE_NACK_PROCESSING_CM_MASK                                                      0x01000000L
#define CB_HW_CONTROL_3__DISABLE_NACK_COLOR_RD_WR_OPT_MASK                                                    0x02000000L
#define CB_HW_CONTROL_3__DISABLE_BLENDER_CLOCK_GATING_MASK                                                    0x04000000L
#define CB_HW_CONTROL_3__DISABLE_DUALSRC_WITH_OBJPRIMID_FIX_MASK                                              0x08000000L
#define CB_HW_CONTROL_3__COLOR_CACHE_PREFETCH_NUM_CLS_MASK                                                    0x30000000L
//CB_HW_MEM_ARBITER_RD
#define CB_HW_MEM_ARBITER_RD__MODE__SHIFT                                                                     0x0
#define CB_HW_MEM_ARBITER_RD__IGNORE_URGENT_AGE__SHIFT                                                        0x2
#define CB_HW_MEM_ARBITER_RD__BREAK_GROUP_AGE__SHIFT                                                          0x6
#define CB_HW_MEM_ARBITER_RD__WEIGHT_CC__SHIFT                                                                0xa
#define CB_HW_MEM_ARBITER_RD__WEIGHT_FC__SHIFT                                                                0xc
#define CB_HW_MEM_ARBITER_RD__WEIGHT_CM__SHIFT                                                                0xe
#define CB_HW_MEM_ARBITER_RD__WEIGHT_DC__SHIFT                                                                0x10
#define CB_HW_MEM_ARBITER_RD__WEIGHT_DECAY_REQS__SHIFT                                                        0x12
#define CB_HW_MEM_ARBITER_RD__WEIGHT_DECAY_NOREQS__SHIFT                                                      0x14
#define CB_HW_MEM_ARBITER_RD__WEIGHT_IGNORE_NUM_TIDS__SHIFT                                                   0x16
#define CB_HW_MEM_ARBITER_RD__SCALE_AGE__SHIFT                                                                0x17
#define CB_HW_MEM_ARBITER_RD__SCALE_WEIGHT__SHIFT                                                             0x1a
#define CB_HW_MEM_ARBITER_RD__SEND_LASTS_WITHIN_GROUPS__SHIFT                                                 0x1d
#define CB_HW_MEM_ARBITER_RD__MODE_MASK                                                                       0x00000003L
#define CB_HW_MEM_ARBITER_RD__IGNORE_URGENT_AGE_MASK                                                          0x0000003CL
#define CB_HW_MEM_ARBITER_RD__BREAK_GROUP_AGE_MASK                                                            0x000003C0L
#define CB_HW_MEM_ARBITER_RD__WEIGHT_CC_MASK                                                                  0x00000C00L
#define CB_HW_MEM_ARBITER_RD__WEIGHT_FC_MASK                                                                  0x00003000L
#define CB_HW_MEM_ARBITER_RD__WEIGHT_CM_MASK                                                                  0x0000C000L
#define CB_HW_MEM_ARBITER_RD__WEIGHT_DC_MASK                                                                  0x00030000L
#define CB_HW_MEM_ARBITER_RD__WEIGHT_DECAY_REQS_MASK                                                          0x000C0000L
#define CB_HW_MEM_ARBITER_RD__WEIGHT_DECAY_NOREQS_MASK                                                        0x00300000L
#define CB_HW_MEM_ARBITER_RD__WEIGHT_IGNORE_NUM_TIDS_MASK                                                     0x00400000L
#define CB_HW_MEM_ARBITER_RD__SCALE_AGE_MASK                                                                  0x03800000L
#define CB_HW_MEM_ARBITER_RD__SCALE_WEIGHT_MASK                                                               0x1C000000L
#define CB_HW_MEM_ARBITER_RD__SEND_LASTS_WITHIN_GROUPS_MASK                                                   0x20000000L
//CB_HW_MEM_ARBITER_WR
#define CB_HW_MEM_ARBITER_WR__MODE__SHIFT                                                                     0x0
#define CB_HW_MEM_ARBITER_WR__IGNORE_URGENT_AGE__SHIFT                                                        0x2
#define CB_HW_MEM_ARBITER_WR__BREAK_GROUP_AGE__SHIFT                                                          0x6
#define CB_HW_MEM_ARBITER_WR__WEIGHT_CC__SHIFT                                                                0xa
#define CB_HW_MEM_ARBITER_WR__WEIGHT_FC__SHIFT                                                                0xc
#define CB_HW_MEM_ARBITER_WR__WEIGHT_CM__SHIFT                                                                0xe
#define CB_HW_MEM_ARBITER_WR__WEIGHT_DC__SHIFT                                                                0x10
#define CB_HW_MEM_ARBITER_WR__WEIGHT_DECAY_REQS__SHIFT                                                        0x12
#define CB_HW_MEM_ARBITER_WR__WEIGHT_DECAY_NOREQS__SHIFT                                                      0x14
#define CB_HW_MEM_ARBITER_WR__WEIGHT_IGNORE_BYTE_MASK__SHIFT                                                  0x16
#define CB_HW_MEM_ARBITER_WR__SCALE_AGE__SHIFT                                                                0x17
#define CB_HW_MEM_ARBITER_WR__SCALE_WEIGHT__SHIFT                                                             0x1a
#define CB_HW_MEM_ARBITER_WR__SEND_LASTS_WITHIN_GROUPS__SHIFT                                                 0x1d
#define CB_HW_MEM_ARBITER_WR__MODE_MASK                                                                       0x00000003L
#define CB_HW_MEM_ARBITER_WR__IGNORE_URGENT_AGE_MASK                                                          0x0000003CL
#define CB_HW_MEM_ARBITER_WR__BREAK_GROUP_AGE_MASK                                                            0x000003C0L
#define CB_HW_MEM_ARBITER_WR__WEIGHT_CC_MASK                                                                  0x00000C00L
#define CB_HW_MEM_ARBITER_WR__WEIGHT_FC_MASK                                                                  0x00003000L
#define CB_HW_MEM_ARBITER_WR__WEIGHT_CM_MASK                                                                  0x0000C000L
#define CB_HW_MEM_ARBITER_WR__WEIGHT_DC_MASK                                                                  0x00030000L
#define CB_HW_MEM_ARBITER_WR__WEIGHT_DECAY_REQS_MASK                                                          0x000C0000L
#define CB_HW_MEM_ARBITER_WR__WEIGHT_DECAY_NOREQS_MASK                                                        0x00300000L
#define CB_HW_MEM_ARBITER_WR__WEIGHT_IGNORE_BYTE_MASK_MASK                                                    0x00400000L
#define CB_HW_MEM_ARBITER_WR__SCALE_AGE_MASK                                                                  0x03800000L
#define CB_HW_MEM_ARBITER_WR__SCALE_WEIGHT_MASK                                                               0x1C000000L
#define CB_HW_MEM_ARBITER_WR__SEND_LASTS_WITHIN_GROUPS_MASK                                                   0x20000000L
//CB_DCC_CONFIG
#define CB_DCC_CONFIG__OVERWRITE_COMBINER_DEPTH__SHIFT                                                        0x0
#define CB_DCC_CONFIG__OVERWRITE_COMBINER_DISABLE__SHIFT                                                      0x5
#define CB_DCC_CONFIG__OVERWRITE_COMBINER_CC_POP_DISABLE__SHIFT                                               0x6
#define CB_DCC_CONFIG__FC_RDLAT_KEYID_FIFO_DEPTH__SHIFT                                                       0x8
#define CB_DCC_CONFIG__READ_RETURN_SKID_FIFO_DEPTH__SHIFT                                                     0x10
#define CB_DCC_CONFIG__DCC_CACHE_EVICT_POINT__SHIFT                                                           0x18
#define CB_DCC_CONFIG__DCC_CACHE_NUM_TAGS__SHIFT                                                              0x1c
#define CB_DCC_CONFIG__OVERWRITE_COMBINER_DEPTH_MASK                                                          0x0000001FL
#define CB_DCC_CONFIG__OVERWRITE_COMBINER_DISABLE_MASK                                                        0x00000020L
#define CB_DCC_CONFIG__OVERWRITE_COMBINER_CC_POP_DISABLE_MASK                                                 0x00000040L
#define CB_DCC_CONFIG__FC_RDLAT_KEYID_FIFO_DEPTH_MASK                                                         0x0000FF00L
#define CB_DCC_CONFIG__READ_RETURN_SKID_FIFO_DEPTH_MASK                                                       0x007F0000L
#define CB_DCC_CONFIG__DCC_CACHE_EVICT_POINT_MASK                                                             0x0F000000L
#define CB_DCC_CONFIG__DCC_CACHE_NUM_TAGS_MASK                                                                0xF0000000L
//GC_USER_RB_REDUNDANCY
#define GC_USER_RB_REDUNDANCY__FAILED_RB0__SHIFT                                                              0x8
#define GC_USER_RB_REDUNDANCY__EN_REDUNDANCY0__SHIFT                                                          0xc
#define GC_USER_RB_REDUNDANCY__FAILED_RB1__SHIFT                                                              0x10
#define GC_USER_RB_REDUNDANCY__EN_REDUNDANCY1__SHIFT                                                          0x14
#define GC_USER_RB_REDUNDANCY__FAILED_RB0_MASK                                                                0x00000F00L
#define GC_USER_RB_REDUNDANCY__EN_REDUNDANCY0_MASK                                                            0x00001000L
#define GC_USER_RB_REDUNDANCY__FAILED_RB1_MASK                                                                0x000F0000L
#define GC_USER_RB_REDUNDANCY__EN_REDUNDANCY1_MASK                                                            0x00100000L
//GC_USER_RB_BACKEND_DISABLE
#define GC_USER_RB_BACKEND_DISABLE__BACKEND_DISABLE__SHIFT                                                    0x10
#define GC_USER_RB_BACKEND_DISABLE__BACKEND_DISABLE_MASK                                                      0x00FF0000L


// addressBlock: gc_ea_gceadec2
//GCEA_EDC_CNT
#define GCEA_EDC_CNT__DRAMRD_CMDMEM_SEC_COUNT__SHIFT                                                          0x0
#define GCEA_EDC_CNT__DRAMRD_CMDMEM_DED_COUNT__SHIFT                                                          0x2
#define GCEA_EDC_CNT__DRAMWR_CMDMEM_SEC_COUNT__SHIFT                                                          0x4
#define GCEA_EDC_CNT__DRAMWR_CMDMEM_DED_COUNT__SHIFT                                                          0x6
#define GCEA_EDC_CNT__DRAMWR_DATAMEM_SEC_COUNT__SHIFT                                                         0x8
#define GCEA_EDC_CNT__DRAMWR_DATAMEM_DED_COUNT__SHIFT                                                         0xa
#define GCEA_EDC_CNT__RRET_TAGMEM_SEC_COUNT__SHIFT                                                            0xc
#define GCEA_EDC_CNT__RRET_TAGMEM_DED_COUNT__SHIFT                                                            0xe
#define GCEA_EDC_CNT__WRET_TAGMEM_SEC_COUNT__SHIFT                                                            0x10
#define GCEA_EDC_CNT__WRET_TAGMEM_DED_COUNT__SHIFT                                                            0x12
#define GCEA_EDC_CNT__DRAMRD_PAGEMEM_SED_COUNT__SHIFT                                                         0x14
#define GCEA_EDC_CNT__DRAMWR_PAGEMEM_SED_COUNT__SHIFT                                                         0x16
#define GCEA_EDC_CNT__IORD_CMDMEM_SED_COUNT__SHIFT                                                            0x18
#define GCEA_EDC_CNT__IOWR_CMDMEM_SED_COUNT__SHIFT                                                            0x1a
#define GCEA_EDC_CNT__IOWR_DATAMEM_SED_COUNT__SHIFT                                                           0x1c
#define GCEA_EDC_CNT__DRAMRD_CMDMEM_SEC_COUNT_MASK                                                            0x00000003L
#define GCEA_EDC_CNT__DRAMRD_CMDMEM_DED_COUNT_MASK                                                            0x0000000CL
#define GCEA_EDC_CNT__DRAMWR_CMDMEM_SEC_COUNT_MASK                                                            0x00000030L
#define GCEA_EDC_CNT__DRAMWR_CMDMEM_DED_COUNT_MASK                                                            0x000000C0L
#define GCEA_EDC_CNT__DRAMWR_DATAMEM_SEC_COUNT_MASK                                                           0x00000300L
#define GCEA_EDC_CNT__DRAMWR_DATAMEM_DED_COUNT_MASK                                                           0x00000C00L
#define GCEA_EDC_CNT__RRET_TAGMEM_SEC_COUNT_MASK                                                              0x00003000L
#define GCEA_EDC_CNT__RRET_TAGMEM_DED_COUNT_MASK                                                              0x0000C000L
#define GCEA_EDC_CNT__WRET_TAGMEM_SEC_COUNT_MASK                                                              0x00030000L
#define GCEA_EDC_CNT__WRET_TAGMEM_DED_COUNT_MASK                                                              0x000C0000L
#define GCEA_EDC_CNT__DRAMRD_PAGEMEM_SED_COUNT_MASK                                                           0x00300000L
#define GCEA_EDC_CNT__DRAMWR_PAGEMEM_SED_COUNT_MASK                                                           0x00C00000L
#define GCEA_EDC_CNT__IORD_CMDMEM_SED_COUNT_MASK                                                              0x03000000L
#define GCEA_EDC_CNT__IOWR_CMDMEM_SED_COUNT_MASK                                                              0x0C000000L
#define GCEA_EDC_CNT__IOWR_DATAMEM_SED_COUNT_MASK                                                             0x30000000L
//GCEA_EDC_CNT2
#define GCEA_EDC_CNT2__GMIRD_CMDMEM_SEC_COUNT__SHIFT                                                          0x0
#define GCEA_EDC_CNT2__GMIRD_CMDMEM_DED_COUNT__SHIFT                                                          0x2
#define GCEA_EDC_CNT2__GMIWR_CMDMEM_SEC_COUNT__SHIFT                                                          0x4
#define GCEA_EDC_CNT2__GMIWR_CMDMEM_DED_COUNT__SHIFT                                                          0x6
#define GCEA_EDC_CNT2__GMIWR_DATAMEM_SEC_COUNT__SHIFT                                                         0x8
#define GCEA_EDC_CNT2__GMIWR_DATAMEM_DED_COUNT__SHIFT                                                         0xa
#define GCEA_EDC_CNT2__GMIRD_PAGEMEM_SED_COUNT__SHIFT                                                         0xc
#define GCEA_EDC_CNT2__GMIWR_PAGEMEM_SED_COUNT__SHIFT                                                         0xe
#define GCEA_EDC_CNT2__GMIRD_CMDMEM_SEC_COUNT_MASK                                                            0x00000003L
#define GCEA_EDC_CNT2__GMIRD_CMDMEM_DED_COUNT_MASK                                                            0x0000000CL
#define GCEA_EDC_CNT2__GMIWR_CMDMEM_SEC_COUNT_MASK                                                            0x00000030L
#define GCEA_EDC_CNT2__GMIWR_CMDMEM_DED_COUNT_MASK                                                            0x000000C0L
#define GCEA_EDC_CNT2__GMIWR_DATAMEM_SEC_COUNT_MASK                                                           0x00000300L
#define GCEA_EDC_CNT2__GMIWR_DATAMEM_DED_COUNT_MASK                                                           0x00000C00L
#define GCEA_EDC_CNT2__GMIRD_PAGEMEM_SED_COUNT_MASK                                                           0x00003000L
#define GCEA_EDC_CNT2__GMIWR_PAGEMEM_SED_COUNT_MASK                                                           0x0000C000L
//GCEA_DSM_CNTL
#define GCEA_DSM_CNTL__DRAMRD_CMDMEM_DSM_IRRITATOR_DATA__SHIFT                                                0x0
#define GCEA_DSM_CNTL__DRAMRD_CMDMEM_ENABLE_SINGLE_WRITE__SHIFT                                               0x2
#define GCEA_DSM_CNTL__DRAMWR_CMDMEM_DSM_IRRITATOR_DATA__SHIFT                                                0x3
#define GCEA_DSM_CNTL__DRAMWR_CMDMEM_ENABLE_SINGLE_WRITE__SHIFT                                               0x5
#define GCEA_DSM_CNTL__DRAMWR_DATAMEM_DSM_IRRITATOR_DATA__SHIFT                                               0x6
#define GCEA_DSM_CNTL__DRAMWR_DATAMEM_ENABLE_SINGLE_WRITE__SHIFT                                              0x8
#define GCEA_DSM_CNTL__RRET_TAGMEM_DSM_IRRITATOR_DATA__SHIFT                                                  0x9
#define GCEA_DSM_CNTL__RRET_TAGMEM_ENABLE_SINGLE_WRITE__SHIFT                                                 0xb
#define GCEA_DSM_CNTL__WRET_TAGMEM_DSM_IRRITATOR_DATA__SHIFT                                                  0xc
#define GCEA_DSM_CNTL__WRET_TAGMEM_ENABLE_SINGLE_WRITE__SHIFT                                                 0xe
#define GCEA_DSM_CNTL__GMIRD_CMDMEM_DSM_IRRITATOR_DATA__SHIFT                                                 0xf
#define GCEA_DSM_CNTL__GMIRD_CMDMEM_ENABLE_SINGLE_WRITE__SHIFT                                                0x11
#define GCEA_DSM_CNTL__GMIWR_CMDMEM_DSM_IRRITATOR_DATA__SHIFT                                                 0x12
#define GCEA_DSM_CNTL__GMIWR_CMDMEM_ENABLE_SINGLE_WRITE__SHIFT                                                0x14
#define GCEA_DSM_CNTL__GMIWR_DATAMEM_DSM_IRRITATOR_DATA__SHIFT                                                0x15
#define GCEA_DSM_CNTL__GMIWR_DATAMEM_ENABLE_SINGLE_WRITE__SHIFT                                               0x17
#define GCEA_DSM_CNTL__DRAMRD_CMDMEM_DSM_IRRITATOR_DATA_MASK                                                  0x00000003L
#define GCEA_DSM_CNTL__DRAMRD_CMDMEM_ENABLE_SINGLE_WRITE_MASK                                                 0x00000004L
#define GCEA_DSM_CNTL__DRAMWR_CMDMEM_DSM_IRRITATOR_DATA_MASK                                                  0x00000018L
#define GCEA_DSM_CNTL__DRAMWR_CMDMEM_ENABLE_SINGLE_WRITE_MASK                                                 0x00000020L
#define GCEA_DSM_CNTL__DRAMWR_DATAMEM_DSM_IRRITATOR_DATA_MASK                                                 0x000000C0L
#define GCEA_DSM_CNTL__DRAMWR_DATAMEM_ENABLE_SINGLE_WRITE_MASK                                                0x00000100L
#define GCEA_DSM_CNTL__RRET_TAGMEM_DSM_IRRITATOR_DATA_MASK                                                    0x00000600L
#define GCEA_DSM_CNTL__RRET_TAGMEM_ENABLE_SINGLE_WRITE_MASK                                                   0x00000800L
#define GCEA_DSM_CNTL__WRET_TAGMEM_DSM_IRRITATOR_DATA_MASK                                                    0x00003000L
#define GCEA_DSM_CNTL__WRET_TAGMEM_ENABLE_SINGLE_WRITE_MASK                                                   0x00004000L
#define GCEA_DSM_CNTL__GMIRD_CMDMEM_DSM_IRRITATOR_DATA_MASK                                                   0x00018000L
#define GCEA_DSM_CNTL__GMIRD_CMDMEM_ENABLE_SINGLE_WRITE_MASK                                                  0x00020000L
#define GCEA_DSM_CNTL__GMIWR_CMDMEM_DSM_IRRITATOR_DATA_MASK                                                   0x000C0000L
#define GCEA_DSM_CNTL__GMIWR_CMDMEM_ENABLE_SINGLE_WRITE_MASK                                                  0x00100000L
#define GCEA_DSM_CNTL__GMIWR_DATAMEM_DSM_IRRITATOR_DATA_MASK                                                  0x00600000L
#define GCEA_DSM_CNTL__GMIWR_DATAMEM_ENABLE_SINGLE_WRITE_MASK                                                 0x00800000L
//GCEA_DSM_CNTLA
#define GCEA_DSM_CNTLA__DRAMRD_PAGEMEM_DSM_IRRITATOR_DATA__SHIFT                                              0x0
#define GCEA_DSM_CNTLA__DRAMRD_PAGEMEM_ENABLE_SINGLE_WRITE__SHIFT                                             0x2
#define GCEA_DSM_CNTLA__DRAMWR_PAGEMEM_DSM_IRRITATOR_DATA__SHIFT                                              0x3
#define GCEA_DSM_CNTLA__DRAMWR_PAGEMEM_ENABLE_SINGLE_WRITE__SHIFT                                             0x5
#define GCEA_DSM_CNTLA__IORD_CMDMEM_DSM_IRRITATOR_DATA__SHIFT                                                 0x6
#define GCEA_DSM_CNTLA__IORD_CMDMEM_ENABLE_SINGLE_WRITE__SHIFT                                                0x8
#define GCEA_DSM_CNTLA__IOWR_CMDMEM_DSM_IRRITATOR_DATA__SHIFT                                                 0x9
#define GCEA_DSM_CNTLA__IOWR_CMDMEM_ENABLE_SINGLE_WRITE__SHIFT                                                0xb
#define GCEA_DSM_CNTLA__IOWR_DATAMEM_DSM_IRRITATOR_DATA__SHIFT                                                0xc
#define GCEA_DSM_CNTLA__IOWR_DATAMEM_ENABLE_SINGLE_WRITE__SHIFT                                               0xe
#define GCEA_DSM_CNTLA__GMIRD_PAGEMEM_DSM_IRRITATOR_DATA__SHIFT                                               0xf
#define GCEA_DSM_CNTLA__GMIRD_PAGEMEM_ENABLE_SINGLE_WRITE__SHIFT                                              0x11
#define GCEA_DSM_CNTLA__GMIWR_PAGEMEM_DSM_IRRITATOR_DATA__SHIFT                                               0x12
#define GCEA_DSM_CNTLA__GMIWR_PAGEMEM_ENABLE_SINGLE_WRITE__SHIFT                                              0x14
#define GCEA_DSM_CNTLA__DRAMRD_PAGEMEM_DSM_IRRITATOR_DATA_MASK                                                0x00000003L
#define GCEA_DSM_CNTLA__DRAMRD_PAGEMEM_ENABLE_SINGLE_WRITE_MASK                                               0x00000004L
#define GCEA_DSM_CNTLA__DRAMWR_PAGEMEM_DSM_IRRITATOR_DATA_MASK                                                0x00000018L
#define GCEA_DSM_CNTLA__DRAMWR_PAGEMEM_ENABLE_SINGLE_WRITE_MASK                                               0x00000020L
#define GCEA_DSM_CNTLA__IORD_CMDMEM_DSM_IRRITATOR_DATA_MASK                                                   0x000000C0L
#define GCEA_DSM_CNTLA__IORD_CMDMEM_ENABLE_SINGLE_WRITE_MASK                                                  0x00000100L
#define GCEA_DSM_CNTLA__IOWR_CMDMEM_DSM_IRRITATOR_DATA_MASK                                                   0x00000600L
#define GCEA_DSM_CNTLA__IOWR_CMDMEM_ENABLE_SINGLE_WRITE_MASK                                                  0x00000800L
#define GCEA_DSM_CNTLA__IOWR_DATAMEM_DSM_IRRITATOR_DATA_MASK                                                  0x00003000L
#define GCEA_DSM_CNTLA__IOWR_DATAMEM_ENABLE_SINGLE_WRITE_MASK                                                 0x00004000L
#define GCEA_DSM_CNTLA__GMIRD_PAGEMEM_DSM_IRRITATOR_DATA_MASK                                                 0x00018000L
#define GCEA_DSM_CNTLA__GMIRD_PAGEMEM_ENABLE_SINGLE_WRITE_MASK                                                0x00020000L
#define GCEA_DSM_CNTLA__GMIWR_PAGEMEM_DSM_IRRITATOR_DATA_MASK                                                 0x000C0000L
#define GCEA_DSM_CNTLA__GMIWR_PAGEMEM_ENABLE_SINGLE_WRITE_MASK                                                0x00100000L
//GCEA_DSM_CNTLB
//GCEA_DSM_CNTL2
#define GCEA_DSM_CNTL2__DRAMRD_CMDMEM_ENABLE_ERROR_INJECT__SHIFT                                              0x0
#define GCEA_DSM_CNTL2__DRAMRD_CMDMEM_SELECT_INJECT_DELAY__SHIFT                                              0x2
#define GCEA_DSM_CNTL2__DRAMWR_CMDMEM_ENABLE_ERROR_INJECT__SHIFT                                              0x3
#define GCEA_DSM_CNTL2__DRAMWR_CMDMEM_SELECT_INJECT_DELAY__SHIFT                                              0x5
#define GCEA_DSM_CNTL2__DRAMWR_DATAMEM_ENABLE_ERROR_INJECT__SHIFT                                             0x6
#define GCEA_DSM_CNTL2__DRAMWR_DATAMEM_SELECT_INJECT_DELAY__SHIFT                                             0x8
#define GCEA_DSM_CNTL2__RRET_TAGMEM_ENABLE_ERROR_INJECT__SHIFT                                                0x9
#define GCEA_DSM_CNTL2__RRET_TAGMEM_SELECT_INJECT_DELAY__SHIFT                                                0xb
#define GCEA_DSM_CNTL2__WRET_TAGMEM_ENABLE_ERROR_INJECT__SHIFT                                                0xc
#define GCEA_DSM_CNTL2__WRET_TAGMEM_SELECT_INJECT_DELAY__SHIFT                                                0xe
#define GCEA_DSM_CNTL2__GMIRD_CMDMEM_ENABLE_ERROR_INJECT__SHIFT                                               0xf
#define GCEA_DSM_CNTL2__GMIRD_CMDMEM_SELECT_INJECT_DELAY__SHIFT                                               0x11
#define GCEA_DSM_CNTL2__GMIWR_CMDMEM_ENABLE_ERROR_INJECT__SHIFT                                               0x12
#define GCEA_DSM_CNTL2__GMIWR_CMDMEM_SELECT_INJECT_DELAY__SHIFT                                               0x14
#define GCEA_DSM_CNTL2__GMIWR_DATAMEM_ENABLE_ERROR_INJECT__SHIFT                                              0x15
#define GCEA_DSM_CNTL2__GMIWR_DATAMEM_SELECT_INJECT_DELAY__SHIFT                                              0x17
#define GCEA_DSM_CNTL2__INJECT_DELAY__SHIFT                                                                   0x1a
#define GCEA_DSM_CNTL2__DRAMRD_CMDMEM_ENABLE_ERROR_INJECT_MASK                                                0x00000003L
#define GCEA_DSM_CNTL2__DRAMRD_CMDMEM_SELECT_INJECT_DELAY_MASK                                                0x00000004L
#define GCEA_DSM_CNTL2__DRAMWR_CMDMEM_ENABLE_ERROR_INJECT_MASK                                                0x00000018L
#define GCEA_DSM_CNTL2__DRAMWR_CMDMEM_SELECT_INJECT_DELAY_MASK                                                0x00000020L
#define GCEA_DSM_CNTL2__DRAMWR_DATAMEM_ENABLE_ERROR_INJECT_MASK                                               0x000000C0L
#define GCEA_DSM_CNTL2__DRAMWR_DATAMEM_SELECT_INJECT_DELAY_MASK                                               0x00000100L
#define GCEA_DSM_CNTL2__RRET_TAGMEM_ENABLE_ERROR_INJECT_MASK                                                  0x00000600L
#define GCEA_DSM_CNTL2__RRET_TAGMEM_SELECT_INJECT_DELAY_MASK                                                  0x00000800L
#define GCEA_DSM_CNTL2__WRET_TAGMEM_ENABLE_ERROR_INJECT_MASK                                                  0x00003000L
#define GCEA_DSM_CNTL2__WRET_TAGMEM_SELECT_INJECT_DELAY_MASK                                                  0x00004000L
#define GCEA_DSM_CNTL2__GMIRD_CMDMEM_ENABLE_ERROR_INJECT_MASK                                                 0x00018000L
#define GCEA_DSM_CNTL2__GMIRD_CMDMEM_SELECT_INJECT_DELAY_MASK                                                 0x00020000L
#define GCEA_DSM_CNTL2__GMIWR_CMDMEM_ENABLE_ERROR_INJECT_MASK                                                 0x000C0000L
#define GCEA_DSM_CNTL2__GMIWR_CMDMEM_SELECT_INJECT_DELAY_MASK                                                 0x00100000L
#define GCEA_DSM_CNTL2__GMIWR_DATAMEM_ENABLE_ERROR_INJECT_MASK                                                0x00600000L
#define GCEA_DSM_CNTL2__GMIWR_DATAMEM_SELECT_INJECT_DELAY_MASK                                                0x00800000L
#define GCEA_DSM_CNTL2__INJECT_DELAY_MASK                                                                     0xFC000000L
//GCEA_DSM_CNTL2A
#define GCEA_DSM_CNTL2A__DRAMRD_PAGEMEM_ENABLE_ERROR_INJECT__SHIFT                                            0x0
#define GCEA_DSM_CNTL2A__DRAMRD_PAGEMEM_SELECT_INJECT_DELAY__SHIFT                                            0x2
#define GCEA_DSM_CNTL2A__DRAMWR_PAGEMEM_ENABLE_ERROR_INJECT__SHIFT                                            0x3
#define GCEA_DSM_CNTL2A__DRAMWR_PAGEMEM_SELECT_INJECT_DELAY__SHIFT                                            0x5
#define GCEA_DSM_CNTL2A__IORD_CMDMEM_ENABLE_ERROR_INJECT__SHIFT                                               0x6
#define GCEA_DSM_CNTL2A__IORD_CMDMEM_SELECT_INJECT_DELAY__SHIFT                                               0x8
#define GCEA_DSM_CNTL2A__IOWR_CMDMEM_ENABLE_ERROR_INJECT__SHIFT                                               0x9
#define GCEA_DSM_CNTL2A__IOWR_CMDMEM_SELECT_INJECT_DELAY__SHIFT                                               0xb
#define GCEA_DSM_CNTL2A__IOWR_DATAMEM_ENABLE_ERROR_INJECT__SHIFT                                              0xc
#define GCEA_DSM_CNTL2A__IOWR_DATAMEM_SELECT_INJECT_DELAY__SHIFT                                              0xe
#define GCEA_DSM_CNTL2A__GMIRD_PAGEMEM_ENABLE_ERROR_INJECT__SHIFT                                             0xf
#define GCEA_DSM_CNTL2A__GMIRD_PAGEMEM_SELECT_INJECT_DELAY__SHIFT                                             0x11
#define GCEA_DSM_CNTL2A__GMIWR_PAGEMEM_ENABLE_ERROR_INJECT__SHIFT                                             0x12
#define GCEA_DSM_CNTL2A__GMIWR_PAGEMEM_SELECT_INJECT_DELAY__SHIFT                                             0x14
#define GCEA_DSM_CNTL2A__DRAMRD_PAGEMEM_ENABLE_ERROR_INJECT_MASK                                              0x00000003L
#define GCEA_DSM_CNTL2A__DRAMRD_PAGEMEM_SELECT_INJECT_DELAY_MASK                                              0x00000004L
#define GCEA_DSM_CNTL2A__DRAMWR_PAGEMEM_ENABLE_ERROR_INJECT_MASK                                              0x00000018L
#define GCEA_DSM_CNTL2A__DRAMWR_PAGEMEM_SELECT_INJECT_DELAY_MASK                                              0x00000020L
#define GCEA_DSM_CNTL2A__IORD_CMDMEM_ENABLE_ERROR_INJECT_MASK                                                 0x000000C0L
#define GCEA_DSM_CNTL2A__IORD_CMDMEM_SELECT_INJECT_DELAY_MASK                                                 0x00000100L
#define GCEA_DSM_CNTL2A__IOWR_CMDMEM_ENABLE_ERROR_INJECT_MASK                                                 0x00000600L
#define GCEA_DSM_CNTL2A__IOWR_CMDMEM_SELECT_INJECT_DELAY_MASK                                                 0x00000800L
#define GCEA_DSM_CNTL2A__IOWR_DATAMEM_ENABLE_ERROR_INJECT_MASK                                                0x00003000L
#define GCEA_DSM_CNTL2A__IOWR_DATAMEM_SELECT_INJECT_DELAY_MASK                                                0x00004000L
#define GCEA_DSM_CNTL2A__GMIRD_PAGEMEM_ENABLE_ERROR_INJECT_MASK                                               0x00018000L
#define GCEA_DSM_CNTL2A__GMIRD_PAGEMEM_SELECT_INJECT_DELAY_MASK                                               0x00020000L
#define GCEA_DSM_CNTL2A__GMIWR_PAGEMEM_ENABLE_ERROR_INJECT_MASK                                               0x000C0000L
#define GCEA_DSM_CNTL2A__GMIWR_PAGEMEM_SELECT_INJECT_DELAY_MASK                                               0x00100000L
//GCEA_DSM_CNTL2B
//GCEA_TCC_XBR_CREDITS
#define GCEA_TCC_XBR_CREDITS__DRAM_RD_LIMIT__SHIFT                                                            0x0
#define GCEA_TCC_XBR_CREDITS__DRAM_RD_RESERVE__SHIFT                                                          0x6
#define GCEA_TCC_XBR_CREDITS__IO_RD_LIMIT__SHIFT                                                              0x8
#define GCEA_TCC_XBR_CREDITS__IO_RD_RESERVE__SHIFT                                                            0xe
#define GCEA_TCC_XBR_CREDITS__DRAM_WR_LIMIT__SHIFT                                                            0x10
#define GCEA_TCC_XBR_CREDITS__DRAM_WR_RESERVE__SHIFT                                                          0x16
#define GCEA_TCC_XBR_CREDITS__IO_WR_LIMIT__SHIFT                                                              0x18
#define GCEA_TCC_XBR_CREDITS__IO_WR_RESERVE__SHIFT                                                            0x1e
#define GCEA_TCC_XBR_CREDITS__DRAM_RD_LIMIT_MASK                                                              0x0000003FL
#define GCEA_TCC_XBR_CREDITS__DRAM_RD_RESERVE_MASK                                                            0x000000C0L
#define GCEA_TCC_XBR_CREDITS__IO_RD_LIMIT_MASK                                                                0x00003F00L
#define GCEA_TCC_XBR_CREDITS__IO_RD_RESERVE_MASK                                                              0x0000C000L
#define GCEA_TCC_XBR_CREDITS__DRAM_WR_LIMIT_MASK                                                              0x003F0000L
#define GCEA_TCC_XBR_CREDITS__DRAM_WR_RESERVE_MASK                                                            0x00C00000L
#define GCEA_TCC_XBR_CREDITS__IO_WR_LIMIT_MASK                                                                0x3F000000L
#define GCEA_TCC_XBR_CREDITS__IO_WR_RESERVE_MASK                                                              0xC0000000L
//GCEA_TCC_XBR_MAXBURST
#define GCEA_TCC_XBR_MAXBURST__DRAM_RD__SHIFT                                                                 0x0
#define GCEA_TCC_XBR_MAXBURST__IO_RD__SHIFT                                                                   0x4
#define GCEA_TCC_XBR_MAXBURST__DRAM_WR__SHIFT                                                                 0x8
#define GCEA_TCC_XBR_MAXBURST__IO_WR__SHIFT                                                                   0xc
#define GCEA_TCC_XBR_MAXBURST__DRAM_RD_MASK                                                                   0x0000000FL
#define GCEA_TCC_XBR_MAXBURST__IO_RD_MASK                                                                     0x000000F0L
#define GCEA_TCC_XBR_MAXBURST__DRAM_WR_MASK                                                                   0x00000F00L
#define GCEA_TCC_XBR_MAXBURST__IO_WR_MASK                                                                     0x0000F000L
//GCEA_PROBE_CNTL
#define GCEA_PROBE_CNTL__REQ2RSP_DELAY__SHIFT                                                                 0x0
#define GCEA_PROBE_CNTL__PRB_FILTER_DISABLE__SHIFT                                                            0x5
#define GCEA_PROBE_CNTL__REQ2RSP_DELAY_MASK                                                                   0x0000001FL
#define GCEA_PROBE_CNTL__PRB_FILTER_DISABLE_MASK                                                              0x00000020L
//GCEA_PROBE_MAP
#define GCEA_PROBE_MAP__CHADDR0_TO_RIGHTTCC__SHIFT                                                            0x0
#define GCEA_PROBE_MAP__CHADDR1_TO_RIGHTTCC__SHIFT                                                            0x1
#define GCEA_PROBE_MAP__CHADDR2_TO_RIGHTTCC__SHIFT                                                            0x2
#define GCEA_PROBE_MAP__CHADDR3_TO_RIGHTTCC__SHIFT                                                            0x3
#define GCEA_PROBE_MAP__CHADDR4_TO_RIGHTTCC__SHIFT                                                            0x4
#define GCEA_PROBE_MAP__CHADDR5_TO_RIGHTTCC__SHIFT                                                            0x5
#define GCEA_PROBE_MAP__CHADDR6_TO_RIGHTTCC__SHIFT                                                            0x6
#define GCEA_PROBE_MAP__CHADDR7_TO_RIGHTTCC__SHIFT                                                            0x7
#define GCEA_PROBE_MAP__CHADDR8_TO_RIGHTTCC__SHIFT                                                            0x8
#define GCEA_PROBE_MAP__CHADDR9_TO_RIGHTTCC__SHIFT                                                            0x9
#define GCEA_PROBE_MAP__CHADDR10_TO_RIGHTTCC__SHIFT                                                           0xa
#define GCEA_PROBE_MAP__CHADDR11_TO_RIGHTTCC__SHIFT                                                           0xb
#define GCEA_PROBE_MAP__CHADDR12_TO_RIGHTTCC__SHIFT                                                           0xc
#define GCEA_PROBE_MAP__CHADDR13_TO_RIGHTTCC__SHIFT                                                           0xd
#define GCEA_PROBE_MAP__CHADDR14_TO_RIGHTTCC__SHIFT                                                           0xe
#define GCEA_PROBE_MAP__CHADDR15_TO_RIGHTTCC__SHIFT                                                           0xf
#define GCEA_PROBE_MAP__INTLV_SIZE__SHIFT                                                                     0x10
#define GCEA_PROBE_MAP__CHADDR0_TO_RIGHTTCC_MASK                                                              0x00000001L
#define GCEA_PROBE_MAP__CHADDR1_TO_RIGHTTCC_MASK                                                              0x00000002L
#define GCEA_PROBE_MAP__CHADDR2_TO_RIGHTTCC_MASK                                                              0x00000004L
#define GCEA_PROBE_MAP__CHADDR3_TO_RIGHTTCC_MASK                                                              0x00000008L
#define GCEA_PROBE_MAP__CHADDR4_TO_RIGHTTCC_MASK                                                              0x00000010L
#define GCEA_PROBE_MAP__CHADDR5_TO_RIGHTTCC_MASK                                                              0x00000020L
#define GCEA_PROBE_MAP__CHADDR6_TO_RIGHTTCC_MASK                                                              0x00000040L
#define GCEA_PROBE_MAP__CHADDR7_TO_RIGHTTCC_MASK                                                              0x00000080L
#define GCEA_PROBE_MAP__CHADDR8_TO_RIGHTTCC_MASK                                                              0x00000100L
#define GCEA_PROBE_MAP__CHADDR9_TO_RIGHTTCC_MASK                                                              0x00000200L
#define GCEA_PROBE_MAP__CHADDR10_TO_RIGHTTCC_MASK                                                             0x00000400L
#define GCEA_PROBE_MAP__CHADDR11_TO_RIGHTTCC_MASK                                                             0x00000800L
#define GCEA_PROBE_MAP__CHADDR12_TO_RIGHTTCC_MASK                                                             0x00001000L
#define GCEA_PROBE_MAP__CHADDR13_TO_RIGHTTCC_MASK                                                             0x00002000L
#define GCEA_PROBE_MAP__CHADDR14_TO_RIGHTTCC_MASK                                                             0x00004000L
#define GCEA_PROBE_MAP__CHADDR15_TO_RIGHTTCC_MASK                                                             0x00008000L
#define GCEA_PROBE_MAP__INTLV_SIZE_MASK                                                                       0x00030000L
//GCEA_ERR_STATUS
#define GCEA_ERR_STATUS__SDP_RDRSP_STATUS__SHIFT                                                              0x0
#define GCEA_ERR_STATUS__SDP_WRRSP_STATUS__SHIFT                                                              0x4
#define GCEA_ERR_STATUS__SDP_RDRSP_DATAPARITY_ERROR__SHIFT                                                    0x8
#define GCEA_ERR_STATUS__CLEAR_ERROR_STATUS__SHIFT                                                            0x9
#define GCEA_ERR_STATUS__BUSY_ON_ERROR__SHIFT                                                                 0xa
#define GCEA_ERR_STATUS__SDP_RDRSP_STATUS_MASK                                                                0x0000000FL
#define GCEA_ERR_STATUS__SDP_WRRSP_STATUS_MASK                                                                0x000000F0L
#define GCEA_ERR_STATUS__SDP_RDRSP_DATAPARITY_ERROR_MASK                                                      0x00000100L
#define GCEA_ERR_STATUS__CLEAR_ERROR_STATUS_MASK                                                              0x00000200L
#define GCEA_ERR_STATUS__BUSY_ON_ERROR_MASK                                                                   0x00000400L
//GCEA_MISC2
#define GCEA_MISC2__CSGROUP_SWAP_IN_DRAM_ARB__SHIFT                                                           0x0
#define GCEA_MISC2__CSGROUP_SWAP_IN_GMI_ARB__SHIFT                                                            0x1
#define GCEA_MISC2__CSGRP_BURST_LIMIT_DATA_DRAM__SHIFT                                                        0x2
#define GCEA_MISC2__CSGRP_BURST_LIMIT_DATA_GMI__SHIFT                                                         0x7
#define GCEA_MISC2__CSGROUP_SWAP_IN_DRAM_ARB_MASK                                                             0x00000001L
#define GCEA_MISC2__CSGROUP_SWAP_IN_GMI_ARB_MASK                                                              0x00000002L
#define GCEA_MISC2__CSGRP_BURST_LIMIT_DATA_DRAM_MASK                                                          0x0000007CL
#define GCEA_MISC2__CSGRP_BURST_LIMIT_DATA_GMI_MASK                                                           0x00000F80L
//GCEA_SDP_BACKDOOR_CMDCREDITS0
#define GCEA_SDP_BACKDOOR_CMDCREDITS0__CREDITS_RECEIVED__SHIFT                                                0x0
#define GCEA_SDP_BACKDOOR_CMDCREDITS0__CREDITS_RECEIVED_MASK                                                  0xFFFFFFFFL
//GCEA_SDP_BACKDOOR_CMDCREDITS1
#define GCEA_SDP_BACKDOOR_CMDCREDITS1__CREDITS_RECEIVED__SHIFT                                                0x0
#define GCEA_SDP_BACKDOOR_CMDCREDITS1__CREDITS_RECEIVED_MASK                                                  0x7FFFFFFFL
//GCEA_SDP_BACKDOOR_DATACREDITS0
#define GCEA_SDP_BACKDOOR_DATACREDITS0__CREDITS_RECEIVED__SHIFT                                               0x0
#define GCEA_SDP_BACKDOOR_DATACREDITS0__CREDITS_RECEIVED_MASK                                                 0xFFFFFFFFL
//GCEA_SDP_BACKDOOR_DATACREDITS1
#define GCEA_SDP_BACKDOOR_DATACREDITS1__CREDITS_RECEIVED__SHIFT                                               0x0
#define GCEA_SDP_BACKDOOR_DATACREDITS1__CREDITS_RECEIVED_MASK                                                 0x7FFFFFFFL
//GCEA_SDP_BACKDOOR_MISCCREDITS
#define GCEA_SDP_BACKDOOR_MISCCREDITS__RDRSP_CREDITS_RELEASED__SHIFT                                          0x0
#define GCEA_SDP_BACKDOOR_MISCCREDITS__WRRSP_CREDITS_RELEASED__SHIFT                                          0x8
#define GCEA_SDP_BACKDOOR_MISCCREDITS__PRB_REQ_CREDITS_RELEASED__SHIFT                                        0x10
#define GCEA_SDP_BACKDOOR_MISCCREDITS__PRB_RSP_CREDITS_RECEIVED__SHIFT                                        0x17
#define GCEA_SDP_BACKDOOR_MISCCREDITS__RDRSP_CREDITS_RELEASED_MASK                                            0x000000FFL
#define GCEA_SDP_BACKDOOR_MISCCREDITS__WRRSP_CREDITS_RELEASED_MASK                                            0x0000FF00L
#define GCEA_SDP_BACKDOOR_MISCCREDITS__PRB_REQ_CREDITS_RELEASED_MASK                                          0x007F0000L
#define GCEA_SDP_BACKDOOR_MISCCREDITS__PRB_RSP_CREDITS_RECEIVED_MASK                                          0x3F800000L
//GCEA_SDP_ENABLE
#define GCEA_SDP_ENABLE__ENABLE__SHIFT                                                                        0x0
#define GCEA_SDP_ENABLE__ENABLE_MASK                                                                          0x00000001L


// addressBlock: gc_rmi_rmidec
//RMI_GENERAL_CNTL
#define RMI_GENERAL_CNTL__BURST_DISABLE__SHIFT                                                                0x0
#define RMI_GENERAL_CNTL__VMID_BYPASS_ENABLE__SHIFT                                                           0x1
#define RMI_GENERAL_CNTL__XBAR_MUX_CONFIG__SHIFT                                                              0x11
#define RMI_GENERAL_CNTL__RB0_HARVEST_EN__SHIFT                                                               0x13
#define RMI_GENERAL_CNTL__RB1_HARVEST_EN__SHIFT                                                               0x14
#define RMI_GENERAL_CNTL__LOOPBACK_DIS_BY_REQ_TYPE__SHIFT                                                     0x15
#define RMI_GENERAL_CNTL__XBAR_MUX_CONFIG_UPDATE__SHIFT                                                       0x19
#define RMI_GENERAL_CNTL__SKID_FIFO_0_OVERFLOW_ERROR_MASK__SHIFT                                              0x1a
#define RMI_GENERAL_CNTL__SKID_FIFO_0_UNDERFLOW_ERROR_MASK__SHIFT                                             0x1b
#define RMI_GENERAL_CNTL__SKID_FIFO_1_OVERFLOW_ERROR_MASK__SHIFT                                              0x1c
#define RMI_GENERAL_CNTL__SKID_FIFO_1_UNDERFLOW_ERROR_MASK__SHIFT                                             0x1d
#define RMI_GENERAL_CNTL__SKID_FIFO_FREESPACE_IS_ZERO_ERROR_MASK__SHIFT                                       0x1e
#define RMI_GENERAL_CNTL__BURST_DISABLE_MASK                                                                  0x00000001L
#define RMI_GENERAL_CNTL__VMID_BYPASS_ENABLE_MASK                                                             0x0001FFFEL
#define RMI_GENERAL_CNTL__XBAR_MUX_CONFIG_MASK                                                                0x00060000L
#define RMI_GENERAL_CNTL__RB0_HARVEST_EN_MASK                                                                 0x00080000L
#define RMI_GENERAL_CNTL__RB1_HARVEST_EN_MASK                                                                 0x00100000L
#define RMI_GENERAL_CNTL__LOOPBACK_DIS_BY_REQ_TYPE_MASK                                                       0x01E00000L
#define RMI_GENERAL_CNTL__XBAR_MUX_CONFIG_UPDATE_MASK                                                         0x02000000L
#define RMI_GENERAL_CNTL__SKID_FIFO_0_OVERFLOW_ERROR_MASK_MASK                                                0x04000000L
#define RMI_GENERAL_CNTL__SKID_FIFO_0_UNDERFLOW_ERROR_MASK_MASK                                               0x08000000L
#define RMI_GENERAL_CNTL__SKID_FIFO_1_OVERFLOW_ERROR_MASK_MASK                                                0x10000000L
#define RMI_GENERAL_CNTL__SKID_FIFO_1_UNDERFLOW_ERROR_MASK_MASK                                               0x20000000L
#define RMI_GENERAL_CNTL__SKID_FIFO_FREESPACE_IS_ZERO_ERROR_MASK_MASK                                         0x40000000L
//RMI_GENERAL_CNTL1
#define RMI_GENERAL_CNTL1__EARLY_WRACK_ENABLE_PER_MTYPE__SHIFT                                                0x0
#define RMI_GENERAL_CNTL1__TCIW0_64B_RD_STALL_MODE__SHIFT                                                     0x4
#define RMI_GENERAL_CNTL1__TCIW1_64B_RD_STALL_MODE__SHIFT                                                     0x6
#define RMI_GENERAL_CNTL1__EARLY_WRACK_DISABLE_FOR_LOOPBACK__SHIFT                                            0x8
#define RMI_GENERAL_CNTL1__POLICY_OVERRIDE_VALUE__SHIFT                                                       0x9
#define RMI_GENERAL_CNTL1__POLICY_OVERRIDE__SHIFT                                                             0xa
#define RMI_GENERAL_CNTL1__UTCL1_PROBE0_RR_ARB_BURST_HINT_EN__SHIFT                                           0xb
#define RMI_GENERAL_CNTL1__UTCL1_PROBE1_RR_ARB_BURST_HINT_EN__SHIFT                                           0xc
#define RMI_GENERAL_CNTL1__EARLY_WRACK_ENABLE_PER_MTYPE_MASK                                                  0x0000000FL
#define RMI_GENERAL_CNTL1__TCIW0_64B_RD_STALL_MODE_MASK                                                       0x00000030L
#define RMI_GENERAL_CNTL1__TCIW1_64B_RD_STALL_MODE_MASK                                                       0x000000C0L
#define RMI_GENERAL_CNTL1__EARLY_WRACK_DISABLE_FOR_LOOPBACK_MASK                                              0x00000100L
#define RMI_GENERAL_CNTL1__POLICY_OVERRIDE_VALUE_MASK                                                         0x00000200L
#define RMI_GENERAL_CNTL1__POLICY_OVERRIDE_MASK                                                               0x00000400L
#define RMI_GENERAL_CNTL1__UTCL1_PROBE0_RR_ARB_BURST_HINT_EN_MASK                                             0x00000800L
#define RMI_GENERAL_CNTL1__UTCL1_PROBE1_RR_ARB_BURST_HINT_EN_MASK                                             0x00001000L
//RMI_GENERAL_STATUS
#define RMI_GENERAL_STATUS__GENERAL_RMI_ERRORS_COMBINED__SHIFT                                                0x0
#define RMI_GENERAL_STATUS__SKID_FIFO_0_OVERFLOW_ERROR__SHIFT                                                 0x1
#define RMI_GENERAL_STATUS__SKID_FIFO_0_UNDERFLOW_ERROR__SHIFT                                                0x2
#define RMI_GENERAL_STATUS__SKID_FIFO_1_OVERFLOW_ERROR__SHIFT                                                 0x3
#define RMI_GENERAL_STATUS__SKID_FIFO_1_UNDERFLOW_ERROR__SHIFT                                                0x4
#define RMI_GENERAL_STATUS__RMI_XBAR_BUSY__SHIFT                                                              0x5
#define RMI_GENERAL_STATUS__RMI_UTCL1_BUSY__SHIFT                                                             0x6
#define RMI_GENERAL_STATUS__RMI_SCOREBOARD_BUSY__SHIFT                                                        0x7
#define RMI_GENERAL_STATUS__TCIW0_PRT_FIFO_BUSY__SHIFT                                                        0x8
#define RMI_GENERAL_STATUS__TCIW_FRMTR0_BUSY__SHIFT                                                           0x9
#define RMI_GENERAL_STATUS__TCIW_RTN_FRMTR0_BUSY__SHIFT                                                       0xa
#define RMI_GENERAL_STATUS__WRREQ_CONSUMER_FIFO_0_BUSY__SHIFT                                                 0xb
#define RMI_GENERAL_STATUS__RDREQ_CONSUMER_FIFO_0_BUSY__SHIFT                                                 0xc
#define RMI_GENERAL_STATUS__TCIW1_PRT_FIFO_BUSY__SHIFT                                                        0xd
#define RMI_GENERAL_STATUS__TCIW_FRMTR1_BUSY__SHIFT                                                           0xe
#define RMI_GENERAL_STATUS__TCIW_RTN_FRMTR1_BUSY__SHIFT                                                       0xf
#define RMI_GENERAL_STATUS__WRREQ_CONSUMER_FIFO_1_BUSY__SHIFT                                                 0x10
#define RMI_GENERAL_STATUS__RDREQ_CONSUMER_FIFO_1_BUSY__SHIFT                                                 0x11
#define RMI_GENERAL_STATUS__UTC_PROBE1_BUSY__SHIFT                                                            0x12
#define RMI_GENERAL_STATUS__UTC_PROBE0_BUSY__SHIFT                                                            0x13
#define RMI_GENERAL_STATUS__RMI_XNACK_BUSY__SHIFT                                                             0x14
#define RMI_GENERAL_STATUS__XNACK_FIFO_NUM_USED__SHIFT                                                        0x15
#define RMI_GENERAL_STATUS__XNACK_FIFO_EMPTY__SHIFT                                                           0x1d
#define RMI_GENERAL_STATUS__XNACK_FIFO_FULL__SHIFT                                                            0x1e
#define RMI_GENERAL_STATUS__SKID_FIFO_FREESPACE_IS_ZERO_ERROR__SHIFT                                          0x1f
#define RMI_GENERAL_STATUS__GENERAL_RMI_ERRORS_COMBINED_MASK                                                  0x00000001L
#define RMI_GENERAL_STATUS__SKID_FIFO_0_OVERFLOW_ERROR_MASK                                                   0x00000002L
#define RMI_GENERAL_STATUS__SKID_FIFO_0_UNDERFLOW_ERROR_MASK                                                  0x00000004L
#define RMI_GENERAL_STATUS__SKID_FIFO_1_OVERFLOW_ERROR_MASK                                                   0x00000008L
#define RMI_GENERAL_STATUS__SKID_FIFO_1_UNDERFLOW_ERROR_MASK                                                  0x00000010L
#define RMI_GENERAL_STATUS__RMI_XBAR_BUSY_MASK                                                                0x00000020L
#define RMI_GENERAL_STATUS__RMI_UTCL1_BUSY_MASK                                                               0x00000040L
#define RMI_GENERAL_STATUS__RMI_SCOREBOARD_BUSY_MASK                                                          0x00000080L
#define RMI_GENERAL_STATUS__TCIW0_PRT_FIFO_BUSY_MASK                                                          0x00000100L
#define RMI_GENERAL_STATUS__TCIW_FRMTR0_BUSY_MASK                                                             0x00000200L
#define RMI_GENERAL_STATUS__TCIW_RTN_FRMTR0_BUSY_MASK                                                         0x00000400L
#define RMI_GENERAL_STATUS__WRREQ_CONSUMER_FIFO_0_BUSY_MASK                                                   0x00000800L
#define RMI_GENERAL_STATUS__RDREQ_CONSUMER_FIFO_0_BUSY_MASK                                                   0x00001000L
#define RMI_GENERAL_STATUS__TCIW1_PRT_FIFO_BUSY_MASK                                                          0x00002000L
#define RMI_GENERAL_STATUS__TCIW_FRMTR1_BUSY_MASK                                                             0x00004000L
#define RMI_GENERAL_STATUS__TCIW_RTN_FRMTR1_BUSY_MASK                                                         0x00008000L
#define RMI_GENERAL_STATUS__WRREQ_CONSUMER_FIFO_1_BUSY_MASK                                                   0x00010000L
#define RMI_GENERAL_STATUS__RDREQ_CONSUMER_FIFO_1_BUSY_MASK                                                   0x00020000L
#define RMI_GENERAL_STATUS__UTC_PROBE1_BUSY_MASK                                                              0x00040000L
#define RMI_GENERAL_STATUS__UTC_PROBE0_BUSY_MASK                                                              0x00080000L
#define RMI_GENERAL_STATUS__RMI_XNACK_BUSY_MASK                                                               0x00100000L
#define RMI_GENERAL_STATUS__XNACK_FIFO_NUM_USED_MASK                                                          0x1FE00000L
#define RMI_GENERAL_STATUS__XNACK_FIFO_EMPTY_MASK                                                             0x20000000L
#define RMI_GENERAL_STATUS__XNACK_FIFO_FULL_MASK                                                              0x40000000L
#define RMI_GENERAL_STATUS__SKID_FIFO_FREESPACE_IS_ZERO_ERROR_MASK                                            0x80000000L
//RMI_SUBBLOCK_STATUS0
#define RMI_SUBBLOCK_STATUS0__UTC_EXT_LAT_HID_FIFO_NUM_USED_PROBE0__SHIFT                                     0x0
#define RMI_SUBBLOCK_STATUS0__UTC_EXT_LAT_HID_FIFO_FULL_PROBE0__SHIFT                                         0x7
#define RMI_SUBBLOCK_STATUS0__UTC_EXT_LAT_HID_FIFO_EMPTY_PROBE0__SHIFT                                        0x8
#define RMI_SUBBLOCK_STATUS0__UTC_EXT_LAT_HID_FIFO_NUM_USED_PROBE1__SHIFT                                     0x9
#define RMI_SUBBLOCK_STATUS0__UTC_EXT_LAT_HID_FIFO_FULL_PROBE1__SHIFT                                         0x10
#define RMI_SUBBLOCK_STATUS0__UTC_EXT_LAT_HID_FIFO_EMPTY_PROBE1__SHIFT                                        0x11
#define RMI_SUBBLOCK_STATUS0__TCIW0_INFLIGHT_CNT__SHIFT                                                       0x12
#define RMI_SUBBLOCK_STATUS0__UTC_EXT_LAT_HID_FIFO_NUM_USED_PROBE0_MASK                                       0x0000007FL
#define RMI_SUBBLOCK_STATUS0__UTC_EXT_LAT_HID_FIFO_FULL_PROBE0_MASK                                           0x00000080L
#define RMI_SUBBLOCK_STATUS0__UTC_EXT_LAT_HID_FIFO_EMPTY_PROBE0_MASK                                          0x00000100L
#define RMI_SUBBLOCK_STATUS0__UTC_EXT_LAT_HID_FIFO_NUM_USED_PROBE1_MASK                                       0x0000FE00L
#define RMI_SUBBLOCK_STATUS0__UTC_EXT_LAT_HID_FIFO_FULL_PROBE1_MASK                                           0x00010000L
#define RMI_SUBBLOCK_STATUS0__UTC_EXT_LAT_HID_FIFO_EMPTY_PROBE1_MASK                                          0x00020000L
#define RMI_SUBBLOCK_STATUS0__TCIW0_INFLIGHT_CNT_MASK                                                         0x0FFC0000L
//RMI_SUBBLOCK_STATUS1
#define RMI_SUBBLOCK_STATUS1__SKID_FIFO_0_FREE_SPACE__SHIFT                                                   0x0
#define RMI_SUBBLOCK_STATUS1__SKID_FIFO_1_FREE_SPACE__SHIFT                                                   0xa
#define RMI_SUBBLOCK_STATUS1__TCIW1_INFLIGHT_CNT__SHIFT                                                       0x14
#define RMI_SUBBLOCK_STATUS1__SKID_FIFO_0_FREE_SPACE_MASK                                                     0x000003FFL
#define RMI_SUBBLOCK_STATUS1__SKID_FIFO_1_FREE_SPACE_MASK                                                     0x000FFC00L
#define RMI_SUBBLOCK_STATUS1__TCIW1_INFLIGHT_CNT_MASK                                                         0x3FF00000L
//RMI_SUBBLOCK_STATUS2
#define RMI_SUBBLOCK_STATUS2__PRT_FIFO_0_NUM_USED__SHIFT                                                      0x0
#define RMI_SUBBLOCK_STATUS2__PRT_FIFO_1_NUM_USED__SHIFT                                                      0x9
#define RMI_SUBBLOCK_STATUS2__PRT_FIFO_0_NUM_USED_MASK                                                        0x000001FFL
#define RMI_SUBBLOCK_STATUS2__PRT_FIFO_1_NUM_USED_MASK                                                        0x0003FE00L
//RMI_SUBBLOCK_STATUS3
#define RMI_SUBBLOCK_STATUS3__SKID_FIFO_0_FREE_SPACE_TOTAL__SHIFT                                             0x0
#define RMI_SUBBLOCK_STATUS3__SKID_FIFO_1_FREE_SPACE_TOTAL__SHIFT                                             0xa
#define RMI_SUBBLOCK_STATUS3__SKID_FIFO_0_FREE_SPACE_TOTAL_MASK                                               0x000003FFL
#define RMI_SUBBLOCK_STATUS3__SKID_FIFO_1_FREE_SPACE_TOTAL_MASK                                               0x000FFC00L
//RMI_XBAR_CONFIG
#define RMI_XBAR_CONFIG__XBAR_MUX_CONFIG_OVERRIDE__SHIFT                                                      0x0
#define RMI_XBAR_CONFIG__XBAR_MUX_CONFIG_REQ_TYPE_OVERRIDE__SHIFT                                             0x2
#define RMI_XBAR_CONFIG__XBAR_MUX_CONFIG_CB_DB_OVERRIDE__SHIFT                                                0x6
#define RMI_XBAR_CONFIG__ARBITER_DIS__SHIFT                                                                   0x7
#define RMI_XBAR_CONFIG__XBAR_EN_IN_REQ__SHIFT                                                                0x8
#define RMI_XBAR_CONFIG__XBAR_EN_IN_REQ_OVERRIDE__SHIFT                                                       0xc
#define RMI_XBAR_CONFIG__XBAR_EN_IN_RB0__SHIFT                                                                0xd
#define RMI_XBAR_CONFIG__XBAR_EN_IN_RB1__SHIFT                                                                0xe
#define RMI_XBAR_CONFIG__XBAR_MUX_CONFIG_OVERRIDE_MASK                                                        0x00000003L
#define RMI_XBAR_CONFIG__XBAR_MUX_CONFIG_REQ_TYPE_OVERRIDE_MASK                                               0x0000003CL
#define RMI_XBAR_CONFIG__XBAR_MUX_CONFIG_CB_DB_OVERRIDE_MASK                                                  0x00000040L
#define RMI_XBAR_CONFIG__ARBITER_DIS_MASK                                                                     0x00000080L
#define RMI_XBAR_CONFIG__XBAR_EN_IN_REQ_MASK                                                                  0x00000F00L
#define RMI_XBAR_CONFIG__XBAR_EN_IN_REQ_OVERRIDE_MASK                                                         0x00001000L
#define RMI_XBAR_CONFIG__XBAR_EN_IN_RB0_MASK                                                                  0x00002000L
#define RMI_XBAR_CONFIG__XBAR_EN_IN_RB1_MASK                                                                  0x00004000L
//RMI_PROBE_POP_LOGIC_CNTL
#define RMI_PROBE_POP_LOGIC_CNTL__EXT_LAT_FIFO_0_MAX_DEPTH__SHIFT                                             0x0
#define RMI_PROBE_POP_LOGIC_CNTL__XLAT_COMBINE0_DIS__SHIFT                                                    0x7
#define RMI_PROBE_POP_LOGIC_CNTL__REDUCE_MAX_XLAT_CHAIN_SIZE_BY_2__SHIFT                                      0x8
#define RMI_PROBE_POP_LOGIC_CNTL__EXT_LAT_FIFO_1_MAX_DEPTH__SHIFT                                             0xa
#define RMI_PROBE_POP_LOGIC_CNTL__XLAT_COMBINE1_DIS__SHIFT                                                    0x11
#define RMI_PROBE_POP_LOGIC_CNTL__EXT_LAT_FIFO_0_MAX_DEPTH_MASK                                               0x0000007FL
#define RMI_PROBE_POP_LOGIC_CNTL__XLAT_COMBINE0_DIS_MASK                                                      0x00000080L
#define RMI_PROBE_POP_LOGIC_CNTL__REDUCE_MAX_XLAT_CHAIN_SIZE_BY_2_MASK                                        0x00000300L
#define RMI_PROBE_POP_LOGIC_CNTL__EXT_LAT_FIFO_1_MAX_DEPTH_MASK                                               0x0001FC00L
#define RMI_PROBE_POP_LOGIC_CNTL__XLAT_COMBINE1_DIS_MASK                                                      0x00020000L
//RMI_UTC_XNACK_N_MISC_CNTL
#define RMI_UTC_XNACK_N_MISC_CNTL__MASTER_XNACK_TIMER_INC__SHIFT                                              0x0
#define RMI_UTC_XNACK_N_MISC_CNTL__IND_XNACK_TIMER_START_VALUE__SHIFT                                         0x8
#define RMI_UTC_XNACK_N_MISC_CNTL__UTCL1_PERM_MODE__SHIFT                                                     0xc
#define RMI_UTC_XNACK_N_MISC_CNTL__CP_VMID_RESET_REQUEST_DISABLE__SHIFT                                       0xd
#define RMI_UTC_XNACK_N_MISC_CNTL__MASTER_XNACK_TIMER_INC_MASK                                                0x000000FFL
#define RMI_UTC_XNACK_N_MISC_CNTL__IND_XNACK_TIMER_START_VALUE_MASK                                           0x00000F00L
#define RMI_UTC_XNACK_N_MISC_CNTL__UTCL1_PERM_MODE_MASK                                                       0x00001000L
#define RMI_UTC_XNACK_N_MISC_CNTL__CP_VMID_RESET_REQUEST_DISABLE_MASK                                         0x00002000L
//RMI_DEMUX_CNTL
#define RMI_DEMUX_CNTL__DEMUX_ARB0_STALL__SHIFT                                                               0x0
#define RMI_DEMUX_CNTL__DEMUX_ARB0_BREAK_LOB_ON_IDLEIN__SHIFT                                                 0x1
#define RMI_DEMUX_CNTL__DEMUX_ARB0_STALL_TIMER_OVERRIDE__SHIFT                                                0x4
#define RMI_DEMUX_CNTL__DEMUX_ARB0_STALL_TIMER_START_VALUE__SHIFT                                             0x6
#define RMI_DEMUX_CNTL__DEMUX_ARB0_MODE__SHIFT                                                                0xe
#define RMI_DEMUX_CNTL__DEMUX_ARB1_STALL__SHIFT                                                               0x10
#define RMI_DEMUX_CNTL__DEMUX_ARB1_BREAK_LOB_ON_IDLEIN__SHIFT                                                 0x11
#define RMI_DEMUX_CNTL__DEMUX_ARB1_STALL_TIMER_OVERRIDE__SHIFT                                                0x14
#define RMI_DEMUX_CNTL__DEMUX_ARB1_STALL_TIMER_START_VALUE__SHIFT                                             0x16
#define RMI_DEMUX_CNTL__DEMUX_ARB1_MODE__SHIFT                                                                0x1e
#define RMI_DEMUX_CNTL__DEMUX_ARB0_STALL_MASK                                                                 0x00000001L
#define RMI_DEMUX_CNTL__DEMUX_ARB0_BREAK_LOB_ON_IDLEIN_MASK                                                   0x00000002L
#define RMI_DEMUX_CNTL__DEMUX_ARB0_STALL_TIMER_OVERRIDE_MASK                                                  0x00000030L
#define RMI_DEMUX_CNTL__DEMUX_ARB0_STALL_TIMER_START_VALUE_MASK                                               0x00003FC0L
#define RMI_DEMUX_CNTL__DEMUX_ARB0_MODE_MASK                                                                  0x0000C000L
#define RMI_DEMUX_CNTL__DEMUX_ARB1_STALL_MASK                                                                 0x00010000L
#define RMI_DEMUX_CNTL__DEMUX_ARB1_BREAK_LOB_ON_IDLEIN_MASK                                                   0x00020000L
#define RMI_DEMUX_CNTL__DEMUX_ARB1_STALL_TIMER_OVERRIDE_MASK                                                  0x00300000L
#define RMI_DEMUX_CNTL__DEMUX_ARB1_STALL_TIMER_START_VALUE_MASK                                               0x3FC00000L
#define RMI_DEMUX_CNTL__DEMUX_ARB1_MODE_MASK                                                                  0xC0000000L
//RMI_UTCL1_CNTL1
#define RMI_UTCL1_CNTL1__FORCE_4K_L2_RESP__SHIFT                                                              0x0
#define RMI_UTCL1_CNTL1__GPUVM_64K_DEF__SHIFT                                                                 0x1
#define RMI_UTCL1_CNTL1__GPUVM_PERM_MODE__SHIFT                                                               0x2
#define RMI_UTCL1_CNTL1__RESP_MODE__SHIFT                                                                     0x3
#define RMI_UTCL1_CNTL1__RESP_FAULT_MODE__SHIFT                                                               0x5
#define RMI_UTCL1_CNTL1__CLIENTID__SHIFT                                                                      0x7
#define RMI_UTCL1_CNTL1__USERVM_DIS__SHIFT                                                                    0x10
#define RMI_UTCL1_CNTL1__ENABLE_PUSH_LFIFO__SHIFT                                                             0x11
#define RMI_UTCL1_CNTL1__ENABLE_LFIFO_PRI_ARB__SHIFT                                                          0x12
#define RMI_UTCL1_CNTL1__REG_INV_VMID__SHIFT                                                                  0x13
#define RMI_UTCL1_CNTL1__REG_INV_ALL_VMID__SHIFT                                                              0x17
#define RMI_UTCL1_CNTL1__REG_INV_TOGGLE__SHIFT                                                                0x18
#define RMI_UTCL1_CNTL1__CLIENT_INVALIDATE_ALL_VMID__SHIFT                                                    0x19
#define RMI_UTCL1_CNTL1__FORCE_MISS__SHIFT                                                                    0x1a
#define RMI_UTCL1_CNTL1__FORCE_IN_ORDER__SHIFT                                                                0x1b
#define RMI_UTCL1_CNTL1__REDUCE_FIFO_DEPTH_BY_2__SHIFT                                                        0x1c
#define RMI_UTCL1_CNTL1__REDUCE_CACHE_SIZE_BY_2__SHIFT                                                        0x1e
#define RMI_UTCL1_CNTL1__FORCE_4K_L2_RESP_MASK                                                                0x00000001L
#define RMI_UTCL1_CNTL1__GPUVM_64K_DEF_MASK                                                                   0x00000002L
#define RMI_UTCL1_CNTL1__GPUVM_PERM_MODE_MASK                                                                 0x00000004L
#define RMI_UTCL1_CNTL1__RESP_MODE_MASK                                                                       0x00000018L
#define RMI_UTCL1_CNTL1__RESP_FAULT_MODE_MASK                                                                 0x00000060L
#define RMI_UTCL1_CNTL1__CLIENTID_MASK                                                                        0x0000FF80L
#define RMI_UTCL1_CNTL1__USERVM_DIS_MASK                                                                      0x00010000L
#define RMI_UTCL1_CNTL1__ENABLE_PUSH_LFIFO_MASK                                                               0x00020000L
#define RMI_UTCL1_CNTL1__ENABLE_LFIFO_PRI_ARB_MASK                                                            0x00040000L
#define RMI_UTCL1_CNTL1__REG_INV_VMID_MASK                                                                    0x00780000L
#define RMI_UTCL1_CNTL1__REG_INV_ALL_VMID_MASK                                                                0x00800000L
#define RMI_UTCL1_CNTL1__REG_INV_TOGGLE_MASK                                                                  0x01000000L
#define RMI_UTCL1_CNTL1__CLIENT_INVALIDATE_ALL_VMID_MASK                                                      0x02000000L
#define RMI_UTCL1_CNTL1__FORCE_MISS_MASK                                                                      0x04000000L
#define RMI_UTCL1_CNTL1__FORCE_IN_ORDER_MASK                                                                  0x08000000L
#define RMI_UTCL1_CNTL1__REDUCE_FIFO_DEPTH_BY_2_MASK                                                          0x30000000L
#define RMI_UTCL1_CNTL1__REDUCE_CACHE_SIZE_BY_2_MASK                                                          0xC0000000L
//RMI_UTCL1_CNTL2
#define RMI_UTCL1_CNTL2__UTC_SPARE__SHIFT                                                                     0x0
#define RMI_UTCL1_CNTL2__MTYPE_OVRD_DIS__SHIFT                                                                0x9
#define RMI_UTCL1_CNTL2__LINE_VALID__SHIFT                                                                    0xa
#define RMI_UTCL1_CNTL2__DIS_EDC__SHIFT                                                                       0xb
#define RMI_UTCL1_CNTL2__GPUVM_INV_MODE__SHIFT                                                                0xc
#define RMI_UTCL1_CNTL2__SHOOTDOWN_OPT__SHIFT                                                                 0xd
#define RMI_UTCL1_CNTL2__FORCE_SNOOP__SHIFT                                                                   0xe
#define RMI_UTCL1_CNTL2__FORCE_GPUVM_INV_ACK__SHIFT                                                           0xf
#define RMI_UTCL1_CNTL2__UTCL1_ARB_BURST_MODE__SHIFT                                                          0x10
#define RMI_UTCL1_CNTL2__UTCL1_ENABLE_PERF_EVENT_RD_WR__SHIFT                                                 0x12
#define RMI_UTCL1_CNTL2__UTCL1_PERF_EVENT_RD_WR__SHIFT                                                        0x13
#define RMI_UTCL1_CNTL2__UTCL1_ENABLE_PERF_EVENT_VMID__SHIFT                                                  0x14
#define RMI_UTCL1_CNTL2__UTCL1_PERF_EVENT_VMID__SHIFT                                                         0x15
#define RMI_UTCL1_CNTL2__UTCL1_DIS_DUAL_L2_REQ__SHIFT                                                         0x19
#define RMI_UTCL1_CNTL2__UTCL1_FORCE_FRAG_2M_TO_64K__SHIFT                                                    0x1a
#define RMI_UTCL1_CNTL2__UTC_SPARE_MASK                                                                       0x000000FFL
#define RMI_UTCL1_CNTL2__MTYPE_OVRD_DIS_MASK                                                                  0x00000200L
#define RMI_UTCL1_CNTL2__LINE_VALID_MASK                                                                      0x00000400L
#define RMI_UTCL1_CNTL2__DIS_EDC_MASK                                                                         0x00000800L
#define RMI_UTCL1_CNTL2__GPUVM_INV_MODE_MASK                                                                  0x00001000L
#define RMI_UTCL1_CNTL2__SHOOTDOWN_OPT_MASK                                                                   0x00002000L
#define RMI_UTCL1_CNTL2__FORCE_SNOOP_MASK                                                                     0x00004000L
#define RMI_UTCL1_CNTL2__FORCE_GPUVM_INV_ACK_MASK                                                             0x00008000L
#define RMI_UTCL1_CNTL2__UTCL1_ARB_BURST_MODE_MASK                                                            0x00030000L
#define RMI_UTCL1_CNTL2__UTCL1_ENABLE_PERF_EVENT_RD_WR_MASK                                                   0x00040000L
#define RMI_UTCL1_CNTL2__UTCL1_PERF_EVENT_RD_WR_MASK                                                          0x00080000L
#define RMI_UTCL1_CNTL2__UTCL1_ENABLE_PERF_EVENT_VMID_MASK                                                    0x00100000L
#define RMI_UTCL1_CNTL2__UTCL1_PERF_EVENT_VMID_MASK                                                           0x01E00000L
#define RMI_UTCL1_CNTL2__UTCL1_DIS_DUAL_L2_REQ_MASK                                                           0x02000000L
#define RMI_UTCL1_CNTL2__UTCL1_FORCE_FRAG_2M_TO_64K_MASK                                                      0x04000000L
//RMI_UTC_UNIT_CONFIG
//RMI_TCIW_FORMATTER0_CNTL
#define RMI_TCIW_FORMATTER0_CNTL__WR_COMBINE0_DIS_OVERRIDE__SHIFT                                             0x0
#define RMI_TCIW_FORMATTER0_CNTL__WR_COMBINE0_TIME_OUT_WINDOW__SHIFT                                          0x1
#define RMI_TCIW_FORMATTER0_CNTL__TCIW0_MAX_ALLOWED_INFLIGHT_REQ__SHIFT                                       0x9
#define RMI_TCIW_FORMATTER0_CNTL__SKID_FIFO_0_FREE_SPACE_DELTA__SHIFT                                         0x13
#define RMI_TCIW_FORMATTER0_CNTL__SKID_FIFO_0_FREE_SPACE_DELTA_UPDATE__SHIFT                                  0x1b
#define RMI_TCIW_FORMATTER0_CNTL__TCIW0_REQ_SAFE_MODE__SHIFT                                                  0x1c
#define RMI_TCIW_FORMATTER0_CNTL__RMI_IN0_REORDER_DIS__SHIFT                                                  0x1d
#define RMI_TCIW_FORMATTER0_CNTL__WR_COMBINE0_DIS_AT_LAST_OF_BURST__SHIFT                                     0x1e
#define RMI_TCIW_FORMATTER0_CNTL__ALL_FAULT_RET0_DATA__SHIFT                                                  0x1f
#define RMI_TCIW_FORMATTER0_CNTL__WR_COMBINE0_DIS_OVERRIDE_MASK                                               0x00000001L
#define RMI_TCIW_FORMATTER0_CNTL__WR_COMBINE0_TIME_OUT_WINDOW_MASK                                            0x000001FEL
#define RMI_TCIW_FORMATTER0_CNTL__TCIW0_MAX_ALLOWED_INFLIGHT_REQ_MASK                                         0x0007FE00L
#define RMI_TCIW_FORMATTER0_CNTL__SKID_FIFO_0_FREE_SPACE_DELTA_MASK                                           0x07F80000L
#define RMI_TCIW_FORMATTER0_CNTL__SKID_FIFO_0_FREE_SPACE_DELTA_UPDATE_MASK                                    0x08000000L
#define RMI_TCIW_FORMATTER0_CNTL__TCIW0_REQ_SAFE_MODE_MASK                                                    0x10000000L
#define RMI_TCIW_FORMATTER0_CNTL__RMI_IN0_REORDER_DIS_MASK                                                    0x20000000L
#define RMI_TCIW_FORMATTER0_CNTL__WR_COMBINE0_DIS_AT_LAST_OF_BURST_MASK                                       0x40000000L
#define RMI_TCIW_FORMATTER0_CNTL__ALL_FAULT_RET0_DATA_MASK                                                    0x80000000L
//RMI_TCIW_FORMATTER1_CNTL
#define RMI_TCIW_FORMATTER1_CNTL__WR_COMBINE1_DIS_OVERRIDE__SHIFT                                             0x0
#define RMI_TCIW_FORMATTER1_CNTL__WR_COMBINE1_TIME_OUT_WINDOW__SHIFT                                          0x1
#define RMI_TCIW_FORMATTER1_CNTL__TCIW1_MAX_ALLOWED_INFLIGHT_REQ__SHIFT                                       0x9
#define RMI_TCIW_FORMATTER1_CNTL__SKID_FIFO_1_FREE_SPACE_DELTA__SHIFT                                         0x13
#define RMI_TCIW_FORMATTER1_CNTL__SKID_FIFO_1_FREE_SPACE_DELTA_UPDATE__SHIFT                                  0x1b
#define RMI_TCIW_FORMATTER1_CNTL__TCIW1_REQ_SAFE_MODE__SHIFT                                                  0x1c
#define RMI_TCIW_FORMATTER1_CNTL__RMI_IN1_REORDER_DIS__SHIFT                                                  0x1d
#define RMI_TCIW_FORMATTER1_CNTL__WR_COMBINE1_DIS_AT_LAST_OF_BURST__SHIFT                                     0x1e
#define RMI_TCIW_FORMATTER1_CNTL__ALL_FAULT_RET1_DATA__SHIFT                                                  0x1f
#define RMI_TCIW_FORMATTER1_CNTL__WR_COMBINE1_DIS_OVERRIDE_MASK                                               0x00000001L
#define RMI_TCIW_FORMATTER1_CNTL__WR_COMBINE1_TIME_OUT_WINDOW_MASK                                            0x000001FEL
#define RMI_TCIW_FORMATTER1_CNTL__TCIW1_MAX_ALLOWED_INFLIGHT_REQ_MASK                                         0x0007FE00L
#define RMI_TCIW_FORMATTER1_CNTL__SKID_FIFO_1_FREE_SPACE_DELTA_MASK                                           0x07F80000L
#define RMI_TCIW_FORMATTER1_CNTL__SKID_FIFO_1_FREE_SPACE_DELTA_UPDATE_MASK                                    0x08000000L
#define RMI_TCIW_FORMATTER1_CNTL__TCIW1_REQ_SAFE_MODE_MASK                                                    0x10000000L
#define RMI_TCIW_FORMATTER1_CNTL__RMI_IN1_REORDER_DIS_MASK                                                    0x20000000L
#define RMI_TCIW_FORMATTER1_CNTL__WR_COMBINE1_DIS_AT_LAST_OF_BURST_MASK                                       0x40000000L
#define RMI_TCIW_FORMATTER1_CNTL__ALL_FAULT_RET1_DATA_MASK                                                    0x80000000L
//RMI_SCOREBOARD_CNTL
#define RMI_SCOREBOARD_CNTL__COMPLETE_RB0_FLUSH__SHIFT                                                        0x0
#define RMI_SCOREBOARD_CNTL__REQ_IN_RE_EN_AFTER_FLUSH_RB0__SHIFT                                              0x1
#define RMI_SCOREBOARD_CNTL__COMPLETE_RB1_FLUSH__SHIFT                                                        0x2
#define RMI_SCOREBOARD_CNTL__REQ_IN_RE_EN_AFTER_FLUSH_RB1__SHIFT                                              0x3
#define RMI_SCOREBOARD_CNTL__TIME_STAMP_FLUSH_RB1__SHIFT                                                      0x4
#define RMI_SCOREBOARD_CNTL__VMID_INVAL_FLUSH_TYPE_OVERRIDE_EN__SHIFT                                         0x5
#define RMI_SCOREBOARD_CNTL__VMID_INVAL_FLUSH_TYPE_OVERRIDE_VALUE__SHIFT                                      0x6
#define RMI_SCOREBOARD_CNTL__TIME_STAMP_FLUSH_RB0__SHIFT                                                      0x7
#define RMI_SCOREBOARD_CNTL__FORCE_VMID_INVAL_DONE_EN__SHIFT                                                  0x8
#define RMI_SCOREBOARD_CNTL__FORCE_VMID_INVAL_DONE_TIMER_START_VALUE__SHIFT                                   0x9
#define RMI_SCOREBOARD_CNTL__COMPLETE_RB0_FLUSH_MASK                                                          0x00000001L
#define RMI_SCOREBOARD_CNTL__REQ_IN_RE_EN_AFTER_FLUSH_RB0_MASK                                                0x00000002L
#define RMI_SCOREBOARD_CNTL__COMPLETE_RB1_FLUSH_MASK                                                          0x00000004L
#define RMI_SCOREBOARD_CNTL__REQ_IN_RE_EN_AFTER_FLUSH_RB1_MASK                                                0x00000008L
#define RMI_SCOREBOARD_CNTL__TIME_STAMP_FLUSH_RB1_MASK                                                        0x00000010L
#define RMI_SCOREBOARD_CNTL__VMID_INVAL_FLUSH_TYPE_OVERRIDE_EN_MASK                                           0x00000020L
#define RMI_SCOREBOARD_CNTL__VMID_INVAL_FLUSH_TYPE_OVERRIDE_VALUE_MASK                                        0x00000040L
#define RMI_SCOREBOARD_CNTL__TIME_STAMP_FLUSH_RB0_MASK                                                        0x00000080L
#define RMI_SCOREBOARD_CNTL__FORCE_VMID_INVAL_DONE_EN_MASK                                                    0x00000100L
#define RMI_SCOREBOARD_CNTL__FORCE_VMID_INVAL_DONE_TIMER_START_VALUE_MASK                                     0x001FFE00L
//RMI_SCOREBOARD_STATUS0
#define RMI_SCOREBOARD_STATUS0__CURRENT_SESSION_ID__SHIFT                                                     0x0
#define RMI_SCOREBOARD_STATUS0__CP_VMID_INV_IN_PROG__SHIFT                                                    0x1
#define RMI_SCOREBOARD_STATUS0__CP_VMID_INV_REQ_VMID__SHIFT                                                   0x2
#define RMI_SCOREBOARD_STATUS0__CP_VMID_INV_UTC_DONE__SHIFT                                                   0x12
#define RMI_SCOREBOARD_STATUS0__CP_VMID_INV_DONE__SHIFT                                                       0x13
#define RMI_SCOREBOARD_STATUS0__CP_VMID_INV_FLUSH_TYPE__SHIFT                                                 0x14
#define RMI_SCOREBOARD_STATUS0__FORCE_VMID_INV_DONE__SHIFT                                                    0x15
#define RMI_SCOREBOARD_STATUS0__CURRENT_SESSION_ID_MASK                                                       0x00000001L
#define RMI_SCOREBOARD_STATUS0__CP_VMID_INV_IN_PROG_MASK                                                      0x00000002L
#define RMI_SCOREBOARD_STATUS0__CP_VMID_INV_REQ_VMID_MASK                                                     0x0003FFFCL
#define RMI_SCOREBOARD_STATUS0__CP_VMID_INV_UTC_DONE_MASK                                                     0x00040000L
#define RMI_SCOREBOARD_STATUS0__CP_VMID_INV_DONE_MASK                                                         0x00080000L
#define RMI_SCOREBOARD_STATUS0__CP_VMID_INV_FLUSH_TYPE_MASK                                                   0x00100000L
#define RMI_SCOREBOARD_STATUS0__FORCE_VMID_INV_DONE_MASK                                                      0x00200000L
//RMI_SCOREBOARD_STATUS1
#define RMI_SCOREBOARD_STATUS1__RUNNING_CNT_RB0__SHIFT                                                        0x0
#define RMI_SCOREBOARD_STATUS1__RUNNING_CNT_UNDERFLOW_RB0__SHIFT                                              0xc
#define RMI_SCOREBOARD_STATUS1__RUNNING_CNT_OVERFLOW_RB0__SHIFT                                               0xd
#define RMI_SCOREBOARD_STATUS1__MULTI_VMID_INVAL_FROM_CP_DETECTED__SHIFT                                      0xe
#define RMI_SCOREBOARD_STATUS1__RUNNING_CNT_RB1__SHIFT                                                        0xf
#define RMI_SCOREBOARD_STATUS1__RUNNING_CNT_UNDERFLOW_RB1__SHIFT                                              0x1b
#define RMI_SCOREBOARD_STATUS1__RUNNING_CNT_OVERFLOW_RB1__SHIFT                                               0x1c
#define RMI_SCOREBOARD_STATUS1__COM_FLUSH_IN_PROG_RB1__SHIFT                                                  0x1d
#define RMI_SCOREBOARD_STATUS1__COM_FLUSH_IN_PROG_RB0__SHIFT                                                  0x1e
#define RMI_SCOREBOARD_STATUS1__RUNNING_CNT_RB0_MASK                                                          0x00000FFFL
#define RMI_SCOREBOARD_STATUS1__RUNNING_CNT_UNDERFLOW_RB0_MASK                                                0x00001000L
#define RMI_SCOREBOARD_STATUS1__RUNNING_CNT_OVERFLOW_RB0_MASK                                                 0x00002000L
#define RMI_SCOREBOARD_STATUS1__MULTI_VMID_INVAL_FROM_CP_DETECTED_MASK                                        0x00004000L
#define RMI_SCOREBOARD_STATUS1__RUNNING_CNT_RB1_MASK                                                          0x07FF8000L
#define RMI_SCOREBOARD_STATUS1__RUNNING_CNT_UNDERFLOW_RB1_MASK                                                0x08000000L
#define RMI_SCOREBOARD_STATUS1__RUNNING_CNT_OVERFLOW_RB1_MASK                                                 0x10000000L
#define RMI_SCOREBOARD_STATUS1__COM_FLUSH_IN_PROG_RB1_MASK                                                    0x20000000L
#define RMI_SCOREBOARD_STATUS1__COM_FLUSH_IN_PROG_RB0_MASK                                                    0x40000000L
//RMI_SCOREBOARD_STATUS2
#define RMI_SCOREBOARD_STATUS2__SNAPSHOT_CNT_RB0__SHIFT                                                       0x0
#define RMI_SCOREBOARD_STATUS2__SNAPSHOT_CNT_UNDERFLOW_RB0__SHIFT                                             0xc
#define RMI_SCOREBOARD_STATUS2__SNAPSHOT_CNT_RB1__SHIFT                                                       0xd
#define RMI_SCOREBOARD_STATUS2__SNAPSHOT_CNT_UNDERFLOW_RB1__SHIFT                                             0x19
#define RMI_SCOREBOARD_STATUS2__COM_FLUSH_DONE_RB1__SHIFT                                                     0x1a
#define RMI_SCOREBOARD_STATUS2__COM_FLUSH_DONE_RB0__SHIFT                                                     0x1b
#define RMI_SCOREBOARD_STATUS2__TIME_STAMP_FLUSH_IN_PROG_RB0__SHIFT                                           0x1c
#define RMI_SCOREBOARD_STATUS2__TIME_STAMP_FLUSH_IN_PROG_RB1__SHIFT                                           0x1d
#define RMI_SCOREBOARD_STATUS2__TIME_STAMP_FLUSH_DONE_RB0__SHIFT                                              0x1e
#define RMI_SCOREBOARD_STATUS2__TIME_STAMP_FLUSH_DONE_RB1__SHIFT                                              0x1f
#define RMI_SCOREBOARD_STATUS2__SNAPSHOT_CNT_RB0_MASK                                                         0x00000FFFL
#define RMI_SCOREBOARD_STATUS2__SNAPSHOT_CNT_UNDERFLOW_RB0_MASK                                               0x00001000L
#define RMI_SCOREBOARD_STATUS2__SNAPSHOT_CNT_RB1_MASK                                                         0x01FFE000L
#define RMI_SCOREBOARD_STATUS2__SNAPSHOT_CNT_UNDERFLOW_RB1_MASK                                               0x02000000L
#define RMI_SCOREBOARD_STATUS2__COM_FLUSH_DONE_RB1_MASK                                                       0x04000000L
#define RMI_SCOREBOARD_STATUS2__COM_FLUSH_DONE_RB0_MASK                                                       0x08000000L
#define RMI_SCOREBOARD_STATUS2__TIME_STAMP_FLUSH_IN_PROG_RB0_MASK                                             0x10000000L
#define RMI_SCOREBOARD_STATUS2__TIME_STAMP_FLUSH_IN_PROG_RB1_MASK                                             0x20000000L
#define RMI_SCOREBOARD_STATUS2__TIME_STAMP_FLUSH_DONE_RB0_MASK                                                0x40000000L
#define RMI_SCOREBOARD_STATUS2__TIME_STAMP_FLUSH_DONE_RB1_MASK                                                0x80000000L
//RMI_XBAR_ARBITER_CONFIG
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB0_MODE__SHIFT                                                        0x0
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB0_BREAK_LOB_ON_WEIGHTEDRR__SHIFT                                     0x2
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB0_STALL__SHIFT                                                       0x3
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB0_BREAK_LOB_ON_IDLEIN__SHIFT                                         0x4
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB0_STALL_TIMER_OVERRIDE__SHIFT                                        0x6
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB0_STALL_TIMER_START_VALUE__SHIFT                                     0x8
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB1_MODE__SHIFT                                                        0x10
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB1_BREAK_LOB_ON_WEIGHTEDRR__SHIFT                                     0x12
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB1_STALL__SHIFT                                                       0x13
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB1_BREAK_LOB_ON_IDLEIN__SHIFT                                         0x14
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB1_STALL_TIMER_OVERRIDE__SHIFT                                        0x16
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB1_STALL_TIMER_START_VALUE__SHIFT                                     0x18
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB0_MODE_MASK                                                          0x00000003L
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB0_BREAK_LOB_ON_WEIGHTEDRR_MASK                                       0x00000004L
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB0_STALL_MASK                                                         0x00000008L
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB0_BREAK_LOB_ON_IDLEIN_MASK                                           0x00000010L
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB0_STALL_TIMER_OVERRIDE_MASK                                          0x000000C0L
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB0_STALL_TIMER_START_VALUE_MASK                                       0x0000FF00L
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB1_MODE_MASK                                                          0x00030000L
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB1_BREAK_LOB_ON_WEIGHTEDRR_MASK                                       0x00040000L
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB1_STALL_MASK                                                         0x00080000L
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB1_BREAK_LOB_ON_IDLEIN_MASK                                           0x00100000L
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB1_STALL_TIMER_OVERRIDE_MASK                                          0x00C00000L
#define RMI_XBAR_ARBITER_CONFIG__XBAR_ARB1_STALL_TIMER_START_VALUE_MASK                                       0xFF000000L
//RMI_XBAR_ARBITER_CONFIG_1
#define RMI_XBAR_ARBITER_CONFIG_1__XBAR_ARB_ROUND_ROBIN_WEIGHT_RB0_RD__SHIFT                                  0x0
#define RMI_XBAR_ARBITER_CONFIG_1__XBAR_ARB_ROUND_ROBIN_WEIGHT_RB0_WR__SHIFT                                  0x8
#define RMI_XBAR_ARBITER_CONFIG_1__XBAR_ARB_ROUND_ROBIN_WEIGHT_RB1_RD__SHIFT                                  0x10
#define RMI_XBAR_ARBITER_CONFIG_1__XBAR_ARB_ROUND_ROBIN_WEIGHT_RB1_WR__SHIFT                                  0x18
#define RMI_XBAR_ARBITER_CONFIG_1__XBAR_ARB_ROUND_ROBIN_WEIGHT_RB0_RD_MASK                                    0x000000FFL
#define RMI_XBAR_ARBITER_CONFIG_1__XBAR_ARB_ROUND_ROBIN_WEIGHT_RB0_WR_MASK                                    0x0000FF00L
#define RMI_XBAR_ARBITER_CONFIG_1__XBAR_ARB_ROUND_ROBIN_WEIGHT_RB1_RD_MASK                                    0x00FF0000L
#define RMI_XBAR_ARBITER_CONFIG_1__XBAR_ARB_ROUND_ROBIN_WEIGHT_RB1_WR_MASK                                    0xFF000000L
//RMI_CLOCK_CNTRL
#define RMI_CLOCK_CNTRL__DYN_CLK_RB0_BUSY_MASK__SHIFT                                                         0x0
#define RMI_CLOCK_CNTRL__DYN_CLK_CMN_BUSY_MASK__SHIFT                                                         0x5
#define RMI_CLOCK_CNTRL__DYN_CLK_RB0_WAKEUP_MASK__SHIFT                                                       0xa
#define RMI_CLOCK_CNTRL__DYN_CLK_CMN_WAKEUP_MASK__SHIFT                                                       0xf
#define RMI_CLOCK_CNTRL__DYN_CLK_RB1_BUSY_MASK__SHIFT                                                         0x14
#define RMI_CLOCK_CNTRL__DYN_CLK_RB1_WAKEUP_MASK__SHIFT                                                       0x19
#define RMI_CLOCK_CNTRL__DYN_CLK_RB0_BUSY_MASK_MASK                                                           0x0000001FL
#define RMI_CLOCK_CNTRL__DYN_CLK_CMN_BUSY_MASK_MASK                                                           0x000003E0L
#define RMI_CLOCK_CNTRL__DYN_CLK_RB0_WAKEUP_MASK_MASK                                                         0x00007C00L
#define RMI_CLOCK_CNTRL__DYN_CLK_CMN_WAKEUP_MASK_MASK                                                         0x000F8000L
#define RMI_CLOCK_CNTRL__DYN_CLK_RB1_BUSY_MASK_MASK                                                           0x01F00000L
#define RMI_CLOCK_CNTRL__DYN_CLK_RB1_WAKEUP_MASK_MASK                                                         0x3E000000L
//RMI_UTCL1_STATUS
#define RMI_UTCL1_STATUS__FAULT_DETECTED__SHIFT                                                               0x0
#define RMI_UTCL1_STATUS__RETRY_DETECTED__SHIFT                                                               0x1
#define RMI_UTCL1_STATUS__PRT_DETECTED__SHIFT                                                                 0x2
#define RMI_UTCL1_STATUS__FAULT_DETECTED_MASK                                                                 0x00000001L
#define RMI_UTCL1_STATUS__RETRY_DETECTED_MASK                                                                 0x00000002L
#define RMI_UTCL1_STATUS__PRT_DETECTED_MASK                                                                   0x00000004L
//RMI_SPARE
#define RMI_SPARE__RMI_ARBITER_STALL_TIMER_ENABLED_ALLOW_STREAMING__SHIFT                                     0x0
#define RMI_SPARE__SPARE_BIT_1__SHIFT                                                                         0x1
#define RMI_SPARE__SPARE_BIT_2__SHIFT                                                                         0x2
#define RMI_SPARE__SPARE_BIT_3__SHIFT                                                                         0x3
#define RMI_SPARE__SPARE_BIT_4__SHIFT                                                                         0x4
#define RMI_SPARE__SPARE_BIT_5__SHIFT                                                                         0x5
#define RMI_SPARE__SPARE_BIT_6__SHIFT                                                                         0x6
#define RMI_SPARE__SPARE_BIT_7__SHIFT                                                                         0x7
#define RMI_SPARE__SPARE_BIT_8_0__SHIFT                                                                       0x8
#define RMI_SPARE__SPARE_BIT_16_0__SHIFT                                                                      0x10
#define RMI_SPARE__RMI_ARBITER_STALL_TIMER_ENABLED_ALLOW_STREAMING_MASK                                       0x00000001L
#define RMI_SPARE__SPARE_BIT_1_MASK                                                                           0x00000002L
#define RMI_SPARE__SPARE_BIT_2_MASK                                                                           0x00000004L
#define RMI_SPARE__SPARE_BIT_3_MASK                                                                           0x00000008L
#define RMI_SPARE__SPARE_BIT_4_MASK                                                                           0x00000010L
#define RMI_SPARE__SPARE_BIT_5_MASK                                                                           0x00000020L
#define RMI_SPARE__SPARE_BIT_6_MASK                                                                           0x00000040L
#define RMI_SPARE__SPARE_BIT_7_MASK                                                                           0x00000080L
#define RMI_SPARE__SPARE_BIT_8_0_MASK                                                                         0x0000FF00L
#define RMI_SPARE__SPARE_BIT_16_0_MASK                                                                        0xFFFF0000L
//RMI_SPARE_1
#define RMI_SPARE_1__SPARE_BIT_8__SHIFT                                                                       0x0
#define RMI_SPARE_1__SPARE_BIT_9__SHIFT                                                                       0x1
#define RMI_SPARE_1__SPARE_BIT_10__SHIFT                                                                      0x2
#define RMI_SPARE_1__SPARE_BIT_11__SHIFT                                                                      0x3
#define RMI_SPARE_1__SPARE_BIT_12__SHIFT                                                                      0x4
#define RMI_SPARE_1__SPARE_BIT_13__SHIFT                                                                      0x5
#define RMI_SPARE_1__SPARE_BIT_14__SHIFT                                                                      0x6
#define RMI_SPARE_1__SPARE_BIT_15__SHIFT                                                                      0x7
#define RMI_SPARE_1__SPARE_BIT_8_1__SHIFT                                                                     0x8
#define RMI_SPARE_1__SPARE_BIT_16_1__SHIFT                                                                    0x10
#define RMI_SPARE_1__SPARE_BIT_8_MASK                                                                         0x00000001L
#define RMI_SPARE_1__SPARE_BIT_9_MASK                                                                         0x00000002L
#define RMI_SPARE_1__SPARE_BIT_10_MASK                                                                        0x00000004L
#define RMI_SPARE_1__SPARE_BIT_11_MASK                                                                        0x00000008L
#define RMI_SPARE_1__SPARE_BIT_12_MASK                                                                        0x00000010L
#define RMI_SPARE_1__SPARE_BIT_13_MASK                                                                        0x00000020L
#define RMI_SPARE_1__SPARE_BIT_14_MASK                                                                        0x00000040L
#define RMI_SPARE_1__SPARE_BIT_15_MASK                                                                        0x00000080L
#define RMI_SPARE_1__SPARE_BIT_8_1_MASK                                                                       0x0000FF00L
#define RMI_SPARE_1__SPARE_BIT_16_1_MASK                                                                      0xFFFF0000L
//RMI_SPARE_2
#define RMI_SPARE_2__SPARE_BIT_16__SHIFT                                                                      0x0
#define RMI_SPARE_2__SPARE_BIT_17__SHIFT                                                                      0x1
#define RMI_SPARE_2__SPARE_BIT_18__SHIFT                                                                      0x2
#define RMI_SPARE_2__SPARE_BIT_19__SHIFT                                                                      0x3
#define RMI_SPARE_2__SPARE_BIT_20__SHIFT                                                                      0x4
#define RMI_SPARE_2__SPARE_BIT_21__SHIFT                                                                      0x5
#define RMI_SPARE_2__SPARE_BIT_22__SHIFT                                                                      0x6
#define RMI_SPARE_2__SPARE_BIT_23__SHIFT                                                                      0x7
#define RMI_SPARE_2__SPARE_BIT_4_0__SHIFT                                                                     0x8
#define RMI_SPARE_2__SPARE_BIT_4_1__SHIFT                                                                     0xc
#define RMI_SPARE_2__SPARE_BIT_8_2__SHIFT                                                                     0x10
#define RMI_SPARE_2__SPARE_BIT_8_3__SHIFT                                                                     0x18
#define RMI_SPARE_2__SPARE_BIT_16_MASK                                                                        0x00000001L
#define RMI_SPARE_2__SPARE_BIT_17_MASK                                                                        0x00000002L
#define RMI_SPARE_2__SPARE_BIT_18_MASK                                                                        0x00000004L
#define RMI_SPARE_2__SPARE_BIT_19_MASK                                                                        0x00000008L
#define RMI_SPARE_2__SPARE_BIT_20_MASK                                                                        0x00000010L
#define RMI_SPARE_2__SPARE_BIT_21_MASK                                                                        0x00000020L
#define RMI_SPARE_2__SPARE_BIT_22_MASK                                                                        0x00000040L
#define RMI_SPARE_2__SPARE_BIT_23_MASK                                                                        0x00000080L
#define RMI_SPARE_2__SPARE_BIT_4_0_MASK                                                                       0x00000F00L
#define RMI_SPARE_2__SPARE_BIT_4_1_MASK                                                                       0x0000F000L
#define RMI_SPARE_2__SPARE_BIT_8_2_MASK                                                                       0x00FF0000L
#define RMI_SPARE_2__SPARE_BIT_8_3_MASK                                                                       0xFF000000L


// addressBlock: gc_dbgu_gfx_dbgudec
//port_a_addr
#define port_a_addr__Index__SHIFT                                                                             0x0
#define port_a_addr__Reserved__SHIFT                                                                          0x8
#define port_a_addr__ReadEnable__SHIFT                                                                        0x1f
#define port_a_addr__Index_MASK                                                                               0x000000FFL
#define port_a_addr__Reserved_MASK                                                                            0x7FFFFF00L
#define port_a_addr__ReadEnable_MASK                                                                          0x80000000L
//port_a_data_lo
#define port_a_data_lo__Data__SHIFT                                                                           0x0
#define port_a_data_lo__Data_MASK                                                                             0xFFFFFFFFL
//port_a_data_hi
#define port_a_data_hi__Data__SHIFT                                                                           0x0
#define port_a_data_hi__Data_MASK                                                                             0xFFFFFFFFL
//port_b_addr
#define port_b_addr__Index__SHIFT                                                                             0x0
#define port_b_addr__Reserved__SHIFT                                                                          0x8
#define port_b_addr__ReadEnable__SHIFT                                                                        0x1f
#define port_b_addr__Index_MASK                                                                               0x000000FFL
#define port_b_addr__Reserved_MASK                                                                            0x7FFFFF00L
#define port_b_addr__ReadEnable_MASK                                                                          0x80000000L
//port_b_data_lo
#define port_b_data_lo__Data__SHIFT                                                                           0x0
#define port_b_data_lo__Data_MASK                                                                             0xFFFFFFFFL
//port_b_data_hi
#define port_b_data_hi__Data__SHIFT                                                                           0x0
#define port_b_data_hi__Data_MASK                                                                             0xFFFFFFFFL
//port_c_addr
#define port_c_addr__Index__SHIFT                                                                             0x0
#define port_c_addr__Reserved__SHIFT                                                                          0x8
#define port_c_addr__ReadEnable__SHIFT                                                                        0x1f
#define port_c_addr__Index_MASK                                                                               0x000000FFL
#define port_c_addr__Reserved_MASK                                                                            0x7FFFFF00L
#define port_c_addr__ReadEnable_MASK                                                                          0x80000000L
//port_c_data_lo
#define port_c_data_lo__Data__SHIFT                                                                           0x0
#define port_c_data_lo__Data_MASK                                                                             0xFFFFFFFFL
//port_c_data_hi
#define port_c_data_hi__Data__SHIFT                                                                           0x0
#define port_c_data_hi__Data_MASK                                                                             0xFFFFFFFFL
//port_d_addr
#define port_d_addr__Index__SHIFT                                                                             0x0
#define port_d_addr__Reserved__SHIFT                                                                          0x8
#define port_d_addr__ReadEnable__SHIFT                                                                        0x1f
#define port_d_addr__Index_MASK                                                                               0x000000FFL
#define port_d_addr__Reserved_MASK                                                                            0x7FFFFF00L
#define port_d_addr__ReadEnable_MASK                                                                          0x80000000L
//port_d_data_lo
#define port_d_data_lo__Data__SHIFT                                                                           0x0
#define port_d_data_lo__Data_MASK                                                                             0xFFFFFFFFL
//port_d_data_hi
#define port_d_data_hi__Data__SHIFT                                                                           0x0
#define port_d_data_hi__Data_MASK                                                                             0xFFFFFFFFL


// addressBlock: gc_utcl2_atcl2dec
//ATC_L2_CNTL
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_READ_REQUESTS__SHIFT                                               0x0
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_WRITE_REQUESTS__SHIFT                                              0x3
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_READS_DEPENDS_ON_ADDR_MOD__SHIFT                                   0x6
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_WRITES_DEPENDS_ON_ADDR_MOD__SHIFT                                  0x7
#define ATC_L2_CNTL__CACHE_INVALIDATE_MODE__SHIFT                                                             0x8
#define ATC_L2_CNTL__ENABLE_DEFAULT_PAGE_OUT_TO_SYSTEM_MEMORY__SHIFT                                          0xb
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_READ_REQUESTS_MASK                                                 0x00000003L
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_WRITE_REQUESTS_MASK                                                0x00000018L
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_READS_DEPENDS_ON_ADDR_MOD_MASK                                     0x00000040L
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_WRITES_DEPENDS_ON_ADDR_MOD_MASK                                    0x00000080L
#define ATC_L2_CNTL__CACHE_INVALIDATE_MODE_MASK                                                               0x00000700L
#define ATC_L2_CNTL__ENABLE_DEFAULT_PAGE_OUT_TO_SYSTEM_MEMORY_MASK                                            0x00000800L
//ATC_L2_CNTL2
#define ATC_L2_CNTL2__BANK_SELECT__SHIFT                                                                      0x0
#define ATC_L2_CNTL2__L2_CACHE_UPDATE_MODE__SHIFT                                                             0x6
#define ATC_L2_CNTL2__ENABLE_L2_CACHE_LRU_UPDATE_BY_WRITE__SHIFT                                              0x8
#define ATC_L2_CNTL2__L2_CACHE_SWAP_TAG_INDEX_LSBS__SHIFT                                                     0x9
#define ATC_L2_CNTL2__L2_CACHE_VMID_MODE__SHIFT                                                               0xc
#define ATC_L2_CNTL2__L2_CACHE_UPDATE_WILDCARD_REFERENCE_VALUE__SHIFT                                         0xf
#define ATC_L2_CNTL2__BANK_SELECT_MASK                                                                        0x0000003FL
#define ATC_L2_CNTL2__L2_CACHE_UPDATE_MODE_MASK                                                               0x000000C0L
#define ATC_L2_CNTL2__ENABLE_L2_CACHE_LRU_UPDATE_BY_WRITE_MASK                                                0x00000100L
#define ATC_L2_CNTL2__L2_CACHE_SWAP_TAG_INDEX_LSBS_MASK                                                       0x00000E00L
#define ATC_L2_CNTL2__L2_CACHE_VMID_MODE_MASK                                                                 0x00007000L
#define ATC_L2_CNTL2__L2_CACHE_UPDATE_WILDCARD_REFERENCE_VALUE_MASK                                           0x001F8000L
//ATC_L2_CACHE_DATA0
#define ATC_L2_CACHE_DATA0__DATA_REGISTER_VALID__SHIFT                                                        0x0
#define ATC_L2_CACHE_DATA0__CACHE_ENTRY_VALID__SHIFT                                                          0x1
#define ATC_L2_CACHE_DATA0__CACHED_ATTRIBUTES__SHIFT                                                          0x2
#define ATC_L2_CACHE_DATA0__VIRTUAL_PAGE_ADDRESS_HIGH__SHIFT                                                  0x17
#define ATC_L2_CACHE_DATA0__DATA_REGISTER_VALID_MASK                                                          0x00000001L
#define ATC_L2_CACHE_DATA0__CACHE_ENTRY_VALID_MASK                                                            0x00000002L
#define ATC_L2_CACHE_DATA0__CACHED_ATTRIBUTES_MASK                                                            0x007FFFFCL
#define ATC_L2_CACHE_DATA0__VIRTUAL_PAGE_ADDRESS_HIGH_MASK                                                    0x07800000L
//ATC_L2_CACHE_DATA1
#define ATC_L2_CACHE_DATA1__VIRTUAL_PAGE_ADDRESS_LOW__SHIFT                                                   0x0
#define ATC_L2_CACHE_DATA1__VIRTUAL_PAGE_ADDRESS_LOW_MASK                                                     0xFFFFFFFFL
//ATC_L2_CACHE_DATA2
#define ATC_L2_CACHE_DATA2__PHYSICAL_PAGE_ADDRESS__SHIFT                                                      0x0
#define ATC_L2_CACHE_DATA2__PHYSICAL_PAGE_ADDRESS_MASK                                                        0xFFFFFFFFL
//ATC_L2_CNTL3
#define ATC_L2_CNTL3__DELAY_SEND_INVALIDATION_REQUEST__SHIFT                                                  0x0
#define ATC_L2_CNTL3__ATS_REQUEST_CREDIT_MINUS1__SHIFT                                                        0x3
#define ATC_L2_CNTL3__DELAY_SEND_INVALIDATION_REQUEST_MASK                                                    0x00000007L
#define ATC_L2_CNTL3__ATS_REQUEST_CREDIT_MINUS1_MASK                                                          0x000001F8L
//ATC_L2_STATUS
#define ATC_L2_STATUS__BUSY__SHIFT                                                                            0x0
#define ATC_L2_STATUS__PARITY_ERROR_INFO__SHIFT                                                               0x1
#define ATC_L2_STATUS__BUSY_MASK                                                                              0x00000001L
#define ATC_L2_STATUS__PARITY_ERROR_INFO_MASK                                                                 0x3FFFFFFEL
//ATC_L2_STATUS2
#define ATC_L2_STATUS2__IFIFO_NON_FATAL_PARITY_ERROR_INFO__SHIFT                                              0x0
#define ATC_L2_STATUS2__IFIFO_FATAL_PARITY_ERROR_INFO__SHIFT                                                  0x8
#define ATC_L2_STATUS2__IFIFO_NON_FATAL_PARITY_ERROR_INFO_MASK                                                0x000000FFL
#define ATC_L2_STATUS2__IFIFO_FATAL_PARITY_ERROR_INFO_MASK                                                    0x0000FF00L
//ATC_L2_MISC_CG
#define ATC_L2_MISC_CG__OFFDLY__SHIFT                                                                         0x6
#define ATC_L2_MISC_CG__ENABLE__SHIFT                                                                         0x12
#define ATC_L2_MISC_CG__MEM_LS_ENABLE__SHIFT                                                                  0x13
#define ATC_L2_MISC_CG__OFFDLY_MASK                                                                           0x00000FC0L
#define ATC_L2_MISC_CG__ENABLE_MASK                                                                           0x00040000L
#define ATC_L2_MISC_CG__MEM_LS_ENABLE_MASK                                                                    0x00080000L
//ATC_L2_MEM_POWER_LS
#define ATC_L2_MEM_POWER_LS__LS_SETUP__SHIFT                                                                  0x0
#define ATC_L2_MEM_POWER_LS__LS_HOLD__SHIFT                                                                   0x6
#define ATC_L2_MEM_POWER_LS__LS_SETUP_MASK                                                                    0x0000003FL
#define ATC_L2_MEM_POWER_LS__LS_HOLD_MASK                                                                     0x00000FC0L
//ATC_L2_CGTT_CLK_CTRL
#define ATC_L2_CGTT_CLK_CTRL__ON_DELAY__SHIFT                                                                 0x0
#define ATC_L2_CGTT_CLK_CTRL__OFF_HYSTERESIS__SHIFT                                                           0x4
#define ATC_L2_CGTT_CLK_CTRL__MGLS_OVERRIDE__SHIFT                                                            0xf
#define ATC_L2_CGTT_CLK_CTRL__SOFT_STALL_OVERRIDE__SHIFT                                                      0x10
#define ATC_L2_CGTT_CLK_CTRL__SOFT_OVERRIDE__SHIFT                                                            0x18
#define ATC_L2_CGTT_CLK_CTRL__ON_DELAY_MASK                                                                   0x0000000FL
#define ATC_L2_CGTT_CLK_CTRL__OFF_HYSTERESIS_MASK                                                             0x00000FF0L
#define ATC_L2_CGTT_CLK_CTRL__MGLS_OVERRIDE_MASK                                                              0x00008000L
#define ATC_L2_CGTT_CLK_CTRL__SOFT_STALL_OVERRIDE_MASK                                                        0x00FF0000L
#define ATC_L2_CGTT_CLK_CTRL__SOFT_OVERRIDE_MASK                                                              0xFF000000L


// addressBlock: gc_utcl2_vml2pfdec
//VM_L2_CNTL
#define VM_L2_CNTL__ENABLE_L2_CACHE__SHIFT                                                                    0x0
#define VM_L2_CNTL__ENABLE_L2_FRAGMENT_PROCESSING__SHIFT                                                      0x1
#define VM_L2_CNTL__L2_CACHE_PTE_ENDIAN_SWAP_MODE__SHIFT                                                      0x2
#define VM_L2_CNTL__L2_CACHE_PDE_ENDIAN_SWAP_MODE__SHIFT                                                      0x4
#define VM_L2_CNTL__L2_PDE0_CACHE_TAG_GENERATION_MODE__SHIFT                                                  0x8
#define VM_L2_CNTL__ENABLE_L2_PTE_CACHE_LRU_UPDATE_BY_WRITE__SHIFT                                            0x9
#define VM_L2_CNTL__ENABLE_L2_PDE0_CACHE_LRU_UPDATE_BY_WRITE__SHIFT                                           0xa
#define VM_L2_CNTL__ENABLE_DEFAULT_PAGE_OUT_TO_SYSTEM_MEMORY__SHIFT                                           0xb
#define VM_L2_CNTL__L2_PDE0_CACHE_SPLIT_MODE__SHIFT                                                           0xc
#define VM_L2_CNTL__EFFECTIVE_L2_QUEUE_SIZE__SHIFT                                                            0xf
#define VM_L2_CNTL__PDE_FAULT_CLASSIFICATION__SHIFT                                                           0x12
#define VM_L2_CNTL__CONTEXT1_IDENTITY_ACCESS_MODE__SHIFT                                                      0x13
#define VM_L2_CNTL__IDENTITY_MODE_FRAGMENT_SIZE__SHIFT                                                        0x15
#define VM_L2_CNTL__L2_PTE_CACHE_ADDR_MODE__SHIFT                                                             0x1a
#define VM_L2_CNTL__ENABLE_L2_CACHE_MASK                                                                      0x00000001L
#define VM_L2_CNTL__ENABLE_L2_FRAGMENT_PROCESSING_MASK                                                        0x00000002L
#define VM_L2_CNTL__L2_CACHE_PTE_ENDIAN_SWAP_MODE_MASK                                                        0x0000000CL
#define VM_L2_CNTL__L2_CACHE_PDE_ENDIAN_SWAP_MODE_MASK                                                        0x00000030L
#define VM_L2_CNTL__L2_PDE0_CACHE_TAG_GENERATION_MODE_MASK                                                    0x00000100L
#define VM_L2_CNTL__ENABLE_L2_PTE_CACHE_LRU_UPDATE_BY_WRITE_MASK                                              0x00000200L
#define VM_L2_CNTL__ENABLE_L2_PDE0_CACHE_LRU_UPDATE_BY_WRITE_MASK                                             0x00000400L
#define VM_L2_CNTL__ENABLE_DEFAULT_PAGE_OUT_TO_SYSTEM_MEMORY_MASK                                             0x00000800L
#define VM_L2_CNTL__L2_PDE0_CACHE_SPLIT_MODE_MASK                                                             0x00007000L
#define VM_L2_CNTL__EFFECTIVE_L2_QUEUE_SIZE_MASK                                                              0x00038000L
#define VM_L2_CNTL__PDE_FAULT_CLASSIFICATION_MASK                                                             0x00040000L
#define VM_L2_CNTL__CONTEXT1_IDENTITY_ACCESS_MODE_MASK                                                        0x00180000L
#define VM_L2_CNTL__IDENTITY_MODE_FRAGMENT_SIZE_MASK                                                          0x03E00000L
#define VM_L2_CNTL__L2_PTE_CACHE_ADDR_MODE_MASK                                                               0x0C000000L
//VM_L2_CNTL2
#define VM_L2_CNTL2__INVALIDATE_ALL_L1_TLBS__SHIFT                                                            0x0
#define VM_L2_CNTL2__INVALIDATE_L2_CACHE__SHIFT                                                               0x1
#define VM_L2_CNTL2__DISABLE_INVALIDATE_PER_DOMAIN__SHIFT                                                     0x15
#define VM_L2_CNTL2__DISABLE_BIGK_CACHE_OPTIMIZATION__SHIFT                                                   0x16
#define VM_L2_CNTL2__L2_PTE_CACHE_VMID_MODE__SHIFT                                                            0x17
#define VM_L2_CNTL2__INVALIDATE_CACHE_MODE__SHIFT                                                             0x1a
#define VM_L2_CNTL2__PDE_CACHE_EFFECTIVE_SIZE__SHIFT                                                          0x1c
#define VM_L2_CNTL2__INVALIDATE_ALL_L1_TLBS_MASK                                                              0x00000001L
#define VM_L2_CNTL2__INVALIDATE_L2_CACHE_MASK                                                                 0x00000002L
#define VM_L2_CNTL2__DISABLE_INVALIDATE_PER_DOMAIN_MASK                                                       0x00200000L
#define VM_L2_CNTL2__DISABLE_BIGK_CACHE_OPTIMIZATION_MASK                                                     0x00400000L
#define VM_L2_CNTL2__L2_PTE_CACHE_VMID_MODE_MASK                                                              0x03800000L
#define VM_L2_CNTL2__INVALIDATE_CACHE_MODE_MASK                                                               0x0C000000L
#define VM_L2_CNTL2__PDE_CACHE_EFFECTIVE_SIZE_MASK                                                            0x70000000L
//VM_L2_CNTL3
#define VM_L2_CNTL3__BANK_SELECT__SHIFT                                                                       0x0
#define VM_L2_CNTL3__L2_CACHE_UPDATE_MODE__SHIFT                                                              0x6
#define VM_L2_CNTL3__L2_CACHE_UPDATE_WILDCARD_REFERENCE_VALUE__SHIFT                                          0x8
#define VM_L2_CNTL3__L2_CACHE_BIGK_FRAGMENT_SIZE__SHIFT                                                       0xf
#define VM_L2_CNTL3__L2_CACHE_BIGK_ASSOCIATIVITY__SHIFT                                                       0x14
#define VM_L2_CNTL3__L2_CACHE_4K_EFFECTIVE_SIZE__SHIFT                                                        0x15
#define VM_L2_CNTL3__L2_CACHE_BIGK_EFFECTIVE_SIZE__SHIFT                                                      0x18
#define VM_L2_CNTL3__L2_CACHE_4K_FORCE_MISS__SHIFT                                                            0x1c
#define VM_L2_CNTL3__L2_CACHE_BIGK_FORCE_MISS__SHIFT                                                          0x1d
#define VM_L2_CNTL3__PDE_CACHE_FORCE_MISS__SHIFT                                                              0x1e
#define VM_L2_CNTL3__L2_CACHE_4K_ASSOCIATIVITY__SHIFT                                                         0x1f
#define VM_L2_CNTL3__BANK_SELECT_MASK                                                                         0x0000003FL
#define VM_L2_CNTL3__L2_CACHE_UPDATE_MODE_MASK                                                                0x000000C0L
#define VM_L2_CNTL3__L2_CACHE_UPDATE_WILDCARD_REFERENCE_VALUE_MASK                                            0x00001F00L
#define VM_L2_CNTL3__L2_CACHE_BIGK_FRAGMENT_SIZE_MASK                                                         0x000F8000L
#define VM_L2_CNTL3__L2_CACHE_BIGK_ASSOCIATIVITY_MASK                                                         0x00100000L
#define VM_L2_CNTL3__L2_CACHE_4K_EFFECTIVE_SIZE_MASK                                                          0x00E00000L
#define VM_L2_CNTL3__L2_CACHE_BIGK_EFFECTIVE_SIZE_MASK                                                        0x0F000000L
#define VM_L2_CNTL3__L2_CACHE_4K_FORCE_MISS_MASK                                                              0x10000000L
#define VM_L2_CNTL3__L2_CACHE_BIGK_FORCE_MISS_MASK                                                            0x20000000L
#define VM_L2_CNTL3__PDE_CACHE_FORCE_MISS_MASK                                                                0x40000000L
#define VM_L2_CNTL3__L2_CACHE_4K_ASSOCIATIVITY_MASK                                                           0x80000000L
//VM_L2_STATUS
#define VM_L2_STATUS__L2_BUSY__SHIFT                                                                          0x0
#define VM_L2_STATUS__CONTEXT_DOMAIN_BUSY__SHIFT                                                              0x1
#define VM_L2_STATUS__FOUND_4K_PTE_CACHE_PARITY_ERRORS__SHIFT                                                 0x11
#define VM_L2_STATUS__FOUND_BIGK_PTE_CACHE_PARITY_ERRORS__SHIFT                                               0x12
#define VM_L2_STATUS__FOUND_PDE0_CACHE_PARITY_ERRORS__SHIFT                                                   0x13
#define VM_L2_STATUS__FOUND_PDE1_CACHE_PARITY_ERRORS__SHIFT                                                   0x14
#define VM_L2_STATUS__FOUND_PDE2_CACHE_PARITY_ERRORS__SHIFT                                                   0x15
#define VM_L2_STATUS__L2_BUSY_MASK                                                                            0x00000001L
#define VM_L2_STATUS__CONTEXT_DOMAIN_BUSY_MASK                                                                0x0001FFFEL
#define VM_L2_STATUS__FOUND_4K_PTE_CACHE_PARITY_ERRORS_MASK                                                   0x00020000L
#define VM_L2_STATUS__FOUND_BIGK_PTE_CACHE_PARITY_ERRORS_MASK                                                 0x00040000L
#define VM_L2_STATUS__FOUND_PDE0_CACHE_PARITY_ERRORS_MASK                                                     0x00080000L
#define VM_L2_STATUS__FOUND_PDE1_CACHE_PARITY_ERRORS_MASK                                                     0x00100000L
#define VM_L2_STATUS__FOUND_PDE2_CACHE_PARITY_ERRORS_MASK                                                     0x00200000L
//VM_DUMMY_PAGE_FAULT_CNTL
#define VM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_FAULT_ENABLE__SHIFT                                              0x0
#define VM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_ADDRESS_LOGICAL__SHIFT                                           0x1
#define VM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_COMPARE_MSBS__SHIFT                                              0x2
#define VM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_FAULT_ENABLE_MASK                                                0x00000001L
#define VM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_ADDRESS_LOGICAL_MASK                                             0x00000002L
#define VM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_COMPARE_MSBS_MASK                                                0x000000FCL
//VM_DUMMY_PAGE_FAULT_ADDR_LO32
#define VM_DUMMY_PAGE_FAULT_ADDR_LO32__DUMMY_PAGE_ADDR_LO32__SHIFT                                            0x0
#define VM_DUMMY_PAGE_FAULT_ADDR_LO32__DUMMY_PAGE_ADDR_LO32_MASK                                              0xFFFFFFFFL
//VM_DUMMY_PAGE_FAULT_ADDR_HI32
#define VM_DUMMY_PAGE_FAULT_ADDR_HI32__DUMMY_PAGE_ADDR_HI4__SHIFT                                             0x0
#define VM_DUMMY_PAGE_FAULT_ADDR_HI32__DUMMY_PAGE_ADDR_HI4_MASK                                               0x0000000FL
//VM_L2_PROTECTION_FAULT_CNTL
#define VM_L2_PROTECTION_FAULT_CNTL__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT                                0x0
#define VM_L2_PROTECTION_FAULT_CNTL__ALLOW_SUBSEQUENT_PROTECTION_FAULT_STATUS_ADDR_UPDATES__SHIFT             0x1
#define VM_L2_PROTECTION_FAULT_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                             0x2
#define VM_L2_PROTECTION_FAULT_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                              0x3
#define VM_L2_PROTECTION_FAULT_CNTL__PDE1_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                              0x4
#define VM_L2_PROTECTION_FAULT_CNTL__PDE2_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                              0x5
#define VM_L2_PROTECTION_FAULT_CNTL__TRANSLATE_FURTHER_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                 0x6
#define VM_L2_PROTECTION_FAULT_CNTL__NACK_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                              0x7
#define VM_L2_PROTECTION_FAULT_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                        0x8
#define VM_L2_PROTECTION_FAULT_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                             0x9
#define VM_L2_PROTECTION_FAULT_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                              0xa
#define VM_L2_PROTECTION_FAULT_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                             0xb
#define VM_L2_PROTECTION_FAULT_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                           0xc
#define VM_L2_PROTECTION_FAULT_CNTL__CLIENT_ID_NO_RETRY_FAULT_INTERRUPT__SHIFT                                0xd
#define VM_L2_PROTECTION_FAULT_CNTL__OTHER_CLIENT_ID_NO_RETRY_FAULT_INTERRUPT__SHIFT                          0x1d
#define VM_L2_PROTECTION_FAULT_CNTL__CRASH_ON_NO_RETRY_FAULT__SHIFT                                           0x1e
#define VM_L2_PROTECTION_FAULT_CNTL__CRASH_ON_RETRY_FAULT__SHIFT                                              0x1f
#define VM_L2_PROTECTION_FAULT_CNTL__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK                                  0x00000001L
#define VM_L2_PROTECTION_FAULT_CNTL__ALLOW_SUBSEQUENT_PROTECTION_FAULT_STATUS_ADDR_UPDATES_MASK               0x00000002L
#define VM_L2_PROTECTION_FAULT_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                               0x00000004L
#define VM_L2_PROTECTION_FAULT_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                0x00000008L
#define VM_L2_PROTECTION_FAULT_CNTL__PDE1_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                0x00000010L
#define VM_L2_PROTECTION_FAULT_CNTL__PDE2_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                0x00000020L
#define VM_L2_PROTECTION_FAULT_CNTL__TRANSLATE_FURTHER_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                   0x00000040L
#define VM_L2_PROTECTION_FAULT_CNTL__NACK_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                0x00000080L
#define VM_L2_PROTECTION_FAULT_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                          0x00000100L
#define VM_L2_PROTECTION_FAULT_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                               0x00000200L
#define VM_L2_PROTECTION_FAULT_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                0x00000400L
#define VM_L2_PROTECTION_FAULT_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                               0x00000800L
#define VM_L2_PROTECTION_FAULT_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                             0x00001000L
#define VM_L2_PROTECTION_FAULT_CNTL__CLIENT_ID_NO_RETRY_FAULT_INTERRUPT_MASK                                  0x1FFFE000L
#define VM_L2_PROTECTION_FAULT_CNTL__OTHER_CLIENT_ID_NO_RETRY_FAULT_INTERRUPT_MASK                            0x20000000L
#define VM_L2_PROTECTION_FAULT_CNTL__CRASH_ON_NO_RETRY_FAULT_MASK                                             0x40000000L
#define VM_L2_PROTECTION_FAULT_CNTL__CRASH_ON_RETRY_FAULT_MASK                                                0x80000000L
//VM_L2_PROTECTION_FAULT_CNTL2
#define VM_L2_PROTECTION_FAULT_CNTL2__CLIENT_ID_PRT_FAULT_INTERRUPT__SHIFT                                    0x0
#define VM_L2_PROTECTION_FAULT_CNTL2__OTHER_CLIENT_ID_PRT_FAULT_INTERRUPT__SHIFT                              0x10
#define VM_L2_PROTECTION_FAULT_CNTL2__ACTIVE_PAGE_MIGRATION_PTE__SHIFT                                        0x11
#define VM_L2_PROTECTION_FAULT_CNTL2__ACTIVE_PAGE_MIGRATION_PTE_READ_RETRY__SHIFT                             0x12
#define VM_L2_PROTECTION_FAULT_CNTL2__ENABLE_RETRY_FAULT_INTERRUPT__SHIFT                                     0x13
#define VM_L2_PROTECTION_FAULT_CNTL2__CLIENT_ID_PRT_FAULT_INTERRUPT_MASK                                      0x0000FFFFL
#define VM_L2_PROTECTION_FAULT_CNTL2__OTHER_CLIENT_ID_PRT_FAULT_INTERRUPT_MASK                                0x00010000L
#define VM_L2_PROTECTION_FAULT_CNTL2__ACTIVE_PAGE_MIGRATION_PTE_MASK                                          0x00020000L
#define VM_L2_PROTECTION_FAULT_CNTL2__ACTIVE_PAGE_MIGRATION_PTE_READ_RETRY_MASK                               0x00040000L
#define VM_L2_PROTECTION_FAULT_CNTL2__ENABLE_RETRY_FAULT_INTERRUPT_MASK                                       0x00080000L
//VM_L2_PROTECTION_FAULT_MM_CNTL3
#define VM_L2_PROTECTION_FAULT_MM_CNTL3__VML1_READ_CLIENT_ID_NO_RETRY_FAULT_INTERRUPT__SHIFT                  0x0
#define VM_L2_PROTECTION_FAULT_MM_CNTL3__VML1_READ_CLIENT_ID_NO_RETRY_FAULT_INTERRUPT_MASK                    0xFFFFFFFFL
//VM_L2_PROTECTION_FAULT_MM_CNTL4
#define VM_L2_PROTECTION_FAULT_MM_CNTL4__VML1_WRITE_CLIENT_ID_NO_RETRY_FAULT_INTERRUPT__SHIFT                 0x0
#define VM_L2_PROTECTION_FAULT_MM_CNTL4__VML1_WRITE_CLIENT_ID_NO_RETRY_FAULT_INTERRUPT_MASK                   0xFFFFFFFFL
//VM_L2_PROTECTION_FAULT_STATUS
#define VM_L2_PROTECTION_FAULT_STATUS__MORE_FAULTS__SHIFT                                                     0x0
#define VM_L2_PROTECTION_FAULT_STATUS__WALKER_ERROR__SHIFT                                                    0x1
#define VM_L2_PROTECTION_FAULT_STATUS__PERMISSION_FAULTS__SHIFT                                               0x4
#define VM_L2_PROTECTION_FAULT_STATUS__MAPPING_ERROR__SHIFT                                                   0x8
#define VM_L2_PROTECTION_FAULT_STATUS__CID__SHIFT                                                             0x9
#define VM_L2_PROTECTION_FAULT_STATUS__RW__SHIFT                                                              0x12
#define VM_L2_PROTECTION_FAULT_STATUS__ATOMIC__SHIFT                                                          0x13
#define VM_L2_PROTECTION_FAULT_STATUS__VMID__SHIFT                                                            0x14
#define VM_L2_PROTECTION_FAULT_STATUS__VF__SHIFT                                                              0x18
#define VM_L2_PROTECTION_FAULT_STATUS__VFID__SHIFT                                                            0x19
#define VM_L2_PROTECTION_FAULT_STATUS__MORE_FAULTS_MASK                                                       0x00000001L
#define VM_L2_PROTECTION_FAULT_STATUS__WALKER_ERROR_MASK                                                      0x0000000EL
#define VM_L2_PROTECTION_FAULT_STATUS__PERMISSION_FAULTS_MASK                                                 0x000000F0L
#define VM_L2_PROTECTION_FAULT_STATUS__MAPPING_ERROR_MASK                                                     0x00000100L
#define VM_L2_PROTECTION_FAULT_STATUS__CID_MASK                                                               0x0003FE00L
#define VM_L2_PROTECTION_FAULT_STATUS__RW_MASK                                                                0x00040000L
#define VM_L2_PROTECTION_FAULT_STATUS__ATOMIC_MASK                                                            0x00080000L
#define VM_L2_PROTECTION_FAULT_STATUS__VMID_MASK                                                              0x00F00000L
#define VM_L2_PROTECTION_FAULT_STATUS__VF_MASK                                                                0x01000000L
#define VM_L2_PROTECTION_FAULT_STATUS__VFID_MASK                                                              0x1E000000L
//VM_L2_PROTECTION_FAULT_ADDR_LO32
#define VM_L2_PROTECTION_FAULT_ADDR_LO32__LOGICAL_PAGE_ADDR_LO32__SHIFT                                       0x0
#define VM_L2_PROTECTION_FAULT_ADDR_LO32__LOGICAL_PAGE_ADDR_LO32_MASK                                         0xFFFFFFFFL
//VM_L2_PROTECTION_FAULT_ADDR_HI32
#define VM_L2_PROTECTION_FAULT_ADDR_HI32__LOGICAL_PAGE_ADDR_HI4__SHIFT                                        0x0
#define VM_L2_PROTECTION_FAULT_ADDR_HI32__LOGICAL_PAGE_ADDR_HI4_MASK                                          0x0000000FL
//VM_L2_PROTECTION_FAULT_DEFAULT_ADDR_LO32
#define VM_L2_PROTECTION_FAULT_DEFAULT_ADDR_LO32__PHYSICAL_PAGE_ADDR_LO32__SHIFT                              0x0
#define VM_L2_PROTECTION_FAULT_DEFAULT_ADDR_LO32__PHYSICAL_PAGE_ADDR_LO32_MASK                                0xFFFFFFFFL
//VM_L2_PROTECTION_FAULT_DEFAULT_ADDR_HI32
#define VM_L2_PROTECTION_FAULT_DEFAULT_ADDR_HI32__PHYSICAL_PAGE_ADDR_HI4__SHIFT                               0x0
#define VM_L2_PROTECTION_FAULT_DEFAULT_ADDR_HI32__PHYSICAL_PAGE_ADDR_HI4_MASK                                 0x0000000FL
//VM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_LO32
#define VM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                       0x0
#define VM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                         0xFFFFFFFFL
//VM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_HI32
#define VM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                        0x0
#define VM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                          0x0000000FL
//VM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_LO32
#define VM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                      0x0
#define VM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                        0xFFFFFFFFL
//VM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_HI32
#define VM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                       0x0
#define VM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                         0x0000000FL
//VM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_LO32
#define VM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_LO32__PHYSICAL_PAGE_OFFSET_LO32__SHIFT                         0x0
#define VM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_LO32__PHYSICAL_PAGE_OFFSET_LO32_MASK                           0xFFFFFFFFL
//VM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_HI32
#define VM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_HI32__PHYSICAL_PAGE_OFFSET_HI4__SHIFT                          0x0
#define VM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_HI32__PHYSICAL_PAGE_OFFSET_HI4_MASK                            0x0000000FL
//VM_L2_CNTL4
#define VM_L2_CNTL4__L2_CACHE_4K_PARTITION_COUNT__SHIFT                                                       0x0
#define VM_L2_CNTL4__VMC_TAP_PDE_REQUEST_PHYSICAL__SHIFT                                                      0x6
#define VM_L2_CNTL4__VMC_TAP_PTE_REQUEST_PHYSICAL__SHIFT                                                      0x7
#define VM_L2_CNTL4__MM_NONRT_IFIFO_ACTIVE_TRANSACTION_LIMIT__SHIFT                                           0x8
#define VM_L2_CNTL4__MM_SOFTRT_IFIFO_ACTIVE_TRANSACTION_LIMIT__SHIFT                                          0x12
#define VM_L2_CNTL4__BPM_CGCGLS_OVERRIDE__SHIFT                                                               0x1c
#define VM_L2_CNTL4__L2_CACHE_4K_PARTITION_COUNT_MASK                                                         0x0000003FL
#define VM_L2_CNTL4__VMC_TAP_PDE_REQUEST_PHYSICAL_MASK                                                        0x00000040L
#define VM_L2_CNTL4__VMC_TAP_PTE_REQUEST_PHYSICAL_MASK                                                        0x00000080L
#define VM_L2_CNTL4__MM_NONRT_IFIFO_ACTIVE_TRANSACTION_LIMIT_MASK                                             0x0003FF00L
#define VM_L2_CNTL4__MM_SOFTRT_IFIFO_ACTIVE_TRANSACTION_LIMIT_MASK                                            0x0FFC0000L
#define VM_L2_CNTL4__BPM_CGCGLS_OVERRIDE_MASK                                                                 0x10000000L
//VM_L2_MM_GROUP_RT_CLASSES
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_0_RT_CLASS__SHIFT                                                    0x0
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_1_RT_CLASS__SHIFT                                                    0x1
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_2_RT_CLASS__SHIFT                                                    0x2
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_3_RT_CLASS__SHIFT                                                    0x3
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_4_RT_CLASS__SHIFT                                                    0x4
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_5_RT_CLASS__SHIFT                                                    0x5
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_6_RT_CLASS__SHIFT                                                    0x6
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_7_RT_CLASS__SHIFT                                                    0x7
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_8_RT_CLASS__SHIFT                                                    0x8
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_9_RT_CLASS__SHIFT                                                    0x9
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_10_RT_CLASS__SHIFT                                                   0xa
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_11_RT_CLASS__SHIFT                                                   0xb
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_12_RT_CLASS__SHIFT                                                   0xc
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_13_RT_CLASS__SHIFT                                                   0xd
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_14_RT_CLASS__SHIFT                                                   0xe
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_15_RT_CLASS__SHIFT                                                   0xf
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_16_RT_CLASS__SHIFT                                                   0x10
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_17_RT_CLASS__SHIFT                                                   0x11
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_18_RT_CLASS__SHIFT                                                   0x12
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_19_RT_CLASS__SHIFT                                                   0x13
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_20_RT_CLASS__SHIFT                                                   0x14
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_21_RT_CLASS__SHIFT                                                   0x15
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_22_RT_CLASS__SHIFT                                                   0x16
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_23_RT_CLASS__SHIFT                                                   0x17
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_24_RT_CLASS__SHIFT                                                   0x18
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_25_RT_CLASS__SHIFT                                                   0x19
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_26_RT_CLASS__SHIFT                                                   0x1a
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_27_RT_CLASS__SHIFT                                                   0x1b
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_28_RT_CLASS__SHIFT                                                   0x1c
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_29_RT_CLASS__SHIFT                                                   0x1d
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_30_RT_CLASS__SHIFT                                                   0x1e
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_31_RT_CLASS__SHIFT                                                   0x1f
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_0_RT_CLASS_MASK                                                      0x00000001L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_1_RT_CLASS_MASK                                                      0x00000002L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_2_RT_CLASS_MASK                                                      0x00000004L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_3_RT_CLASS_MASK                                                      0x00000008L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_4_RT_CLASS_MASK                                                      0x00000010L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_5_RT_CLASS_MASK                                                      0x00000020L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_6_RT_CLASS_MASK                                                      0x00000040L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_7_RT_CLASS_MASK                                                      0x00000080L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_8_RT_CLASS_MASK                                                      0x00000100L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_9_RT_CLASS_MASK                                                      0x00000200L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_10_RT_CLASS_MASK                                                     0x00000400L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_11_RT_CLASS_MASK                                                     0x00000800L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_12_RT_CLASS_MASK                                                     0x00001000L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_13_RT_CLASS_MASK                                                     0x00002000L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_14_RT_CLASS_MASK                                                     0x00004000L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_15_RT_CLASS_MASK                                                     0x00008000L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_16_RT_CLASS_MASK                                                     0x00010000L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_17_RT_CLASS_MASK                                                     0x00020000L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_18_RT_CLASS_MASK                                                     0x00040000L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_19_RT_CLASS_MASK                                                     0x00080000L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_20_RT_CLASS_MASK                                                     0x00100000L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_21_RT_CLASS_MASK                                                     0x00200000L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_22_RT_CLASS_MASK                                                     0x00400000L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_23_RT_CLASS_MASK                                                     0x00800000L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_24_RT_CLASS_MASK                                                     0x01000000L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_25_RT_CLASS_MASK                                                     0x02000000L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_26_RT_CLASS_MASK                                                     0x04000000L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_27_RT_CLASS_MASK                                                     0x08000000L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_28_RT_CLASS_MASK                                                     0x10000000L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_29_RT_CLASS_MASK                                                     0x20000000L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_30_RT_CLASS_MASK                                                     0x40000000L
#define VM_L2_MM_GROUP_RT_CLASSES__GROUP_31_RT_CLASS_MASK                                                     0x80000000L
//VM_L2_BANK_SELECT_RESERVED_CID
#define VM_L2_BANK_SELECT_RESERVED_CID__RESERVED_READ_CLIENT_ID__SHIFT                                        0x0
#define VM_L2_BANK_SELECT_RESERVED_CID__RESERVED_WRITE_CLIENT_ID__SHIFT                                       0xa
#define VM_L2_BANK_SELECT_RESERVED_CID__ENABLE__SHIFT                                                         0x14
#define VM_L2_BANK_SELECT_RESERVED_CID__RESERVED_CACHE_INVALIDATION_MODE__SHIFT                               0x18
#define VM_L2_BANK_SELECT_RESERVED_CID__RESERVED_CACHE_PRIVATE_INVALIDATION__SHIFT                            0x19
#define VM_L2_BANK_SELECT_RESERVED_CID__RESERVED_READ_CLIENT_ID_MASK                                          0x000001FFL
#define VM_L2_BANK_SELECT_RESERVED_CID__RESERVED_WRITE_CLIENT_ID_MASK                                         0x0007FC00L
#define VM_L2_BANK_SELECT_RESERVED_CID__ENABLE_MASK                                                           0x00100000L
#define VM_L2_BANK_SELECT_RESERVED_CID__RESERVED_CACHE_INVALIDATION_MODE_MASK                                 0x01000000L
#define VM_L2_BANK_SELECT_RESERVED_CID__RESERVED_CACHE_PRIVATE_INVALIDATION_MASK                              0x02000000L
//VM_L2_BANK_SELECT_RESERVED_CID2
#define VM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_READ_CLIENT_ID__SHIFT                                       0x0
#define VM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_WRITE_CLIENT_ID__SHIFT                                      0xa
#define VM_L2_BANK_SELECT_RESERVED_CID2__ENABLE__SHIFT                                                        0x14
#define VM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_CACHE_INVALIDATION_MODE__SHIFT                              0x18
#define VM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_CACHE_PRIVATE_INVALIDATION__SHIFT                           0x19
#define VM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_READ_CLIENT_ID_MASK                                         0x000001FFL
#define VM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_WRITE_CLIENT_ID_MASK                                        0x0007FC00L
#define VM_L2_BANK_SELECT_RESERVED_CID2__ENABLE_MASK                                                          0x00100000L
#define VM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_CACHE_INVALIDATION_MODE_MASK                                0x01000000L
#define VM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_CACHE_PRIVATE_INVALIDATION_MASK                             0x02000000L
//VM_L2_CACHE_PARITY_CNTL
#define VM_L2_CACHE_PARITY_CNTL__ENABLE_PARITY_CHECKS_IN_4K_PTE_CACHES__SHIFT                                 0x0
#define VM_L2_CACHE_PARITY_CNTL__ENABLE_PARITY_CHECKS_IN_BIGK_PTE_CACHES__SHIFT                               0x1
#define VM_L2_CACHE_PARITY_CNTL__ENABLE_PARITY_CHECKS_IN_PDE_CACHES__SHIFT                                    0x2
#define VM_L2_CACHE_PARITY_CNTL__FORCE_PARITY_MISMATCH_IN_4K_PTE_CACHE__SHIFT                                 0x3
#define VM_L2_CACHE_PARITY_CNTL__FORCE_PARITY_MISMATCH_IN_BIGK_PTE_CACHE__SHIFT                               0x4
#define VM_L2_CACHE_PARITY_CNTL__FORCE_PARITY_MISMATCH_IN_PDE_CACHE__SHIFT                                    0x5
#define VM_L2_CACHE_PARITY_CNTL__FORCE_CACHE_BANK__SHIFT                                                      0x6
#define VM_L2_CACHE_PARITY_CNTL__FORCE_CACHE_NUMBER__SHIFT                                                    0x9
#define VM_L2_CACHE_PARITY_CNTL__FORCE_CACHE_ASSOC__SHIFT                                                     0xc
#define VM_L2_CACHE_PARITY_CNTL__ENABLE_PARITY_CHECKS_IN_4K_PTE_CACHES_MASK                                   0x00000001L
#define VM_L2_CACHE_PARITY_CNTL__ENABLE_PARITY_CHECKS_IN_BIGK_PTE_CACHES_MASK                                 0x00000002L
#define VM_L2_CACHE_PARITY_CNTL__ENABLE_PARITY_CHECKS_IN_PDE_CACHES_MASK                                      0x00000004L
#define VM_L2_CACHE_PARITY_CNTL__FORCE_PARITY_MISMATCH_IN_4K_PTE_CACHE_MASK                                   0x00000008L
#define VM_L2_CACHE_PARITY_CNTL__FORCE_PARITY_MISMATCH_IN_BIGK_PTE_CACHE_MASK                                 0x00000010L
#define VM_L2_CACHE_PARITY_CNTL__FORCE_PARITY_MISMATCH_IN_PDE_CACHE_MASK                                      0x00000020L
#define VM_L2_CACHE_PARITY_CNTL__FORCE_CACHE_BANK_MASK                                                        0x000001C0L
#define VM_L2_CACHE_PARITY_CNTL__FORCE_CACHE_NUMBER_MASK                                                      0x00000E00L
#define VM_L2_CACHE_PARITY_CNTL__FORCE_CACHE_ASSOC_MASK                                                       0x0000F000L
//VM_L2_CGTT_CLK_CTRL
#define VM_L2_CGTT_CLK_CTRL__ON_DELAY__SHIFT                                                                  0x0
#define VM_L2_CGTT_CLK_CTRL__OFF_HYSTERESIS__SHIFT                                                            0x4
#define VM_L2_CGTT_CLK_CTRL__MGLS_OVERRIDE__SHIFT                                                             0xf
#define VM_L2_CGTT_CLK_CTRL__SOFT_STALL_OVERRIDE__SHIFT                                                       0x10
#define VM_L2_CGTT_CLK_CTRL__SOFT_OVERRIDE__SHIFT                                                             0x18
#define VM_L2_CGTT_CLK_CTRL__ON_DELAY_MASK                                                                    0x0000000FL
#define VM_L2_CGTT_CLK_CTRL__OFF_HYSTERESIS_MASK                                                              0x00000FF0L
#define VM_L2_CGTT_CLK_CTRL__MGLS_OVERRIDE_MASK                                                               0x00008000L
#define VM_L2_CGTT_CLK_CTRL__SOFT_STALL_OVERRIDE_MASK                                                         0x00FF0000L
#define VM_L2_CGTT_CLK_CTRL__SOFT_OVERRIDE_MASK                                                               0xFF000000L


// addressBlock: gc_utcl2_vml2vcdec
//VM_CONTEXT0_CNTL
#define VM_CONTEXT0_CNTL__ENABLE_CONTEXT__SHIFT                                                               0x0
#define VM_CONTEXT0_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                             0x1
#define VM_CONTEXT0_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                        0x3
#define VM_CONTEXT0_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                       0x7
#define VM_CONTEXT0_CNTL__RETRY_OTHER_FAULT__SHIFT                                                            0x8
#define VM_CONTEXT0_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x9
#define VM_CONTEXT0_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0xa
#define VM_CONTEXT0_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                 0xb
#define VM_CONTEXT0_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                   0xc
#define VM_CONTEXT0_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                       0xd
#define VM_CONTEXT0_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                         0xe
#define VM_CONTEXT0_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0xf
#define VM_CONTEXT0_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x10
#define VM_CONTEXT0_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                       0x11
#define VM_CONTEXT0_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                         0x12
#define VM_CONTEXT0_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x13
#define VM_CONTEXT0_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x14
#define VM_CONTEXT0_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x15
#define VM_CONTEXT0_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x16
#define VM_CONTEXT0_CNTL__ENABLE_CONTEXT_MASK                                                                 0x00000001L
#define VM_CONTEXT0_CNTL__PAGE_TABLE_DEPTH_MASK                                                               0x00000006L
#define VM_CONTEXT0_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                          0x00000078L
#define VM_CONTEXT0_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                         0x00000080L
#define VM_CONTEXT0_CNTL__RETRY_OTHER_FAULT_MASK                                                              0x00000100L
#define VM_CONTEXT0_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00000200L
#define VM_CONTEXT0_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00000400L
#define VM_CONTEXT0_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                   0x00000800L
#define VM_CONTEXT0_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                     0x00001000L
#define VM_CONTEXT0_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                         0x00002000L
#define VM_CONTEXT0_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                           0x00004000L
#define VM_CONTEXT0_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00008000L
#define VM_CONTEXT0_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00010000L
#define VM_CONTEXT0_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                         0x00020000L
#define VM_CONTEXT0_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                           0x00040000L
#define VM_CONTEXT0_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00080000L
#define VM_CONTEXT0_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00100000L
#define VM_CONTEXT0_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00200000L
#define VM_CONTEXT0_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00400000L
//VM_CONTEXT1_CNTL
#define VM_CONTEXT1_CNTL__ENABLE_CONTEXT__SHIFT                                                               0x0
#define VM_CONTEXT1_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                             0x1
#define VM_CONTEXT1_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                        0x3
#define VM_CONTEXT1_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                       0x7
#define VM_CONTEXT1_CNTL__RETRY_OTHER_FAULT__SHIFT                                                            0x8
#define VM_CONTEXT1_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x9
#define VM_CONTEXT1_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0xa
#define VM_CONTEXT1_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                 0xb
#define VM_CONTEXT1_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                   0xc
#define VM_CONTEXT1_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                       0xd
#define VM_CONTEXT1_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                         0xe
#define VM_CONTEXT1_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0xf
#define VM_CONTEXT1_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x10
#define VM_CONTEXT1_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                       0x11
#define VM_CONTEXT1_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                         0x12
#define VM_CONTEXT1_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x13
#define VM_CONTEXT1_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x14
#define VM_CONTEXT1_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x15
#define VM_CONTEXT1_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x16
#define VM_CONTEXT1_CNTL__ENABLE_CONTEXT_MASK                                                                 0x00000001L
#define VM_CONTEXT1_CNTL__PAGE_TABLE_DEPTH_MASK                                                               0x00000006L
#define VM_CONTEXT1_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                          0x00000078L
#define VM_CONTEXT1_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                         0x00000080L
#define VM_CONTEXT1_CNTL__RETRY_OTHER_FAULT_MASK                                                              0x00000100L
#define VM_CONTEXT1_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00000200L
#define VM_CONTEXT1_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00000400L
#define VM_CONTEXT1_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                   0x00000800L
#define VM_CONTEXT1_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                     0x00001000L
#define VM_CONTEXT1_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                         0x00002000L
#define VM_CONTEXT1_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                           0x00004000L
#define VM_CONTEXT1_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00008000L
#define VM_CONTEXT1_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00010000L
#define VM_CONTEXT1_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                         0x00020000L
#define VM_CONTEXT1_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                           0x00040000L
#define VM_CONTEXT1_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00080000L
#define VM_CONTEXT1_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00100000L
#define VM_CONTEXT1_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00200000L
#define VM_CONTEXT1_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00400000L
//VM_CONTEXT2_CNTL
#define VM_CONTEXT2_CNTL__ENABLE_CONTEXT__SHIFT                                                               0x0
#define VM_CONTEXT2_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                             0x1
#define VM_CONTEXT2_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                        0x3
#define VM_CONTEXT2_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                       0x7
#define VM_CONTEXT2_CNTL__RETRY_OTHER_FAULT__SHIFT                                                            0x8
#define VM_CONTEXT2_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x9
#define VM_CONTEXT2_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0xa
#define VM_CONTEXT2_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                 0xb
#define VM_CONTEXT2_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                   0xc
#define VM_CONTEXT2_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                       0xd
#define VM_CONTEXT2_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                         0xe
#define VM_CONTEXT2_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0xf
#define VM_CONTEXT2_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x10
#define VM_CONTEXT2_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                       0x11
#define VM_CONTEXT2_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                         0x12
#define VM_CONTEXT2_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x13
#define VM_CONTEXT2_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x14
#define VM_CONTEXT2_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x15
#define VM_CONTEXT2_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x16
#define VM_CONTEXT2_CNTL__ENABLE_CONTEXT_MASK                                                                 0x00000001L
#define VM_CONTEXT2_CNTL__PAGE_TABLE_DEPTH_MASK                                                               0x00000006L
#define VM_CONTEXT2_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                          0x00000078L
#define VM_CONTEXT2_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                         0x00000080L
#define VM_CONTEXT2_CNTL__RETRY_OTHER_FAULT_MASK                                                              0x00000100L
#define VM_CONTEXT2_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00000200L
#define VM_CONTEXT2_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00000400L
#define VM_CONTEXT2_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                   0x00000800L
#define VM_CONTEXT2_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                     0x00001000L
#define VM_CONTEXT2_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                         0x00002000L
#define VM_CONTEXT2_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                           0x00004000L
#define VM_CONTEXT2_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00008000L
#define VM_CONTEXT2_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00010000L
#define VM_CONTEXT2_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                         0x00020000L
#define VM_CONTEXT2_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                           0x00040000L
#define VM_CONTEXT2_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00080000L
#define VM_CONTEXT2_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00100000L
#define VM_CONTEXT2_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00200000L
#define VM_CONTEXT2_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00400000L
//VM_CONTEXT3_CNTL
#define VM_CONTEXT3_CNTL__ENABLE_CONTEXT__SHIFT                                                               0x0
#define VM_CONTEXT3_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                             0x1
#define VM_CONTEXT3_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                        0x3
#define VM_CONTEXT3_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                       0x7
#define VM_CONTEXT3_CNTL__RETRY_OTHER_FAULT__SHIFT                                                            0x8
#define VM_CONTEXT3_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x9
#define VM_CONTEXT3_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0xa
#define VM_CONTEXT3_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                 0xb
#define VM_CONTEXT3_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                   0xc
#define VM_CONTEXT3_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                       0xd
#define VM_CONTEXT3_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                         0xe
#define VM_CONTEXT3_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0xf
#define VM_CONTEXT3_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x10
#define VM_CONTEXT3_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                       0x11
#define VM_CONTEXT3_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                         0x12
#define VM_CONTEXT3_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x13
#define VM_CONTEXT3_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x14
#define VM_CONTEXT3_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x15
#define VM_CONTEXT3_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x16
#define VM_CONTEXT3_CNTL__ENABLE_CONTEXT_MASK                                                                 0x00000001L
#define VM_CONTEXT3_CNTL__PAGE_TABLE_DEPTH_MASK                                                               0x00000006L
#define VM_CONTEXT3_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                          0x00000078L
#define VM_CONTEXT3_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                         0x00000080L
#define VM_CONTEXT3_CNTL__RETRY_OTHER_FAULT_MASK                                                              0x00000100L
#define VM_CONTEXT3_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00000200L
#define VM_CONTEXT3_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00000400L
#define VM_CONTEXT3_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                   0x00000800L
#define VM_CONTEXT3_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                     0x00001000L
#define VM_CONTEXT3_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                         0x00002000L
#define VM_CONTEXT3_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                           0x00004000L
#define VM_CONTEXT3_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00008000L
#define VM_CONTEXT3_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00010000L
#define VM_CONTEXT3_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                         0x00020000L
#define VM_CONTEXT3_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                           0x00040000L
#define VM_CONTEXT3_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00080000L
#define VM_CONTEXT3_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00100000L
#define VM_CONTEXT3_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00200000L
#define VM_CONTEXT3_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00400000L
//VM_CONTEXT4_CNTL
#define VM_CONTEXT4_CNTL__ENABLE_CONTEXT__SHIFT                                                               0x0
#define VM_CONTEXT4_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                             0x1
#define VM_CONTEXT4_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                        0x3
#define VM_CONTEXT4_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                       0x7
#define VM_CONTEXT4_CNTL__RETRY_OTHER_FAULT__SHIFT                                                            0x8
#define VM_CONTEXT4_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x9
#define VM_CONTEXT4_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0xa
#define VM_CONTEXT4_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                 0xb
#define VM_CONTEXT4_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                   0xc
#define VM_CONTEXT4_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                       0xd
#define VM_CONTEXT4_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                         0xe
#define VM_CONTEXT4_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0xf
#define VM_CONTEXT4_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x10
#define VM_CONTEXT4_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                       0x11
#define VM_CONTEXT4_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                         0x12
#define VM_CONTEXT4_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x13
#define VM_CONTEXT4_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x14
#define VM_CONTEXT4_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x15
#define VM_CONTEXT4_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x16
#define VM_CONTEXT4_CNTL__ENABLE_CONTEXT_MASK                                                                 0x00000001L
#define VM_CONTEXT4_CNTL__PAGE_TABLE_DEPTH_MASK                                                               0x00000006L
#define VM_CONTEXT4_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                          0x00000078L
#define VM_CONTEXT4_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                         0x00000080L
#define VM_CONTEXT4_CNTL__RETRY_OTHER_FAULT_MASK                                                              0x00000100L
#define VM_CONTEXT4_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00000200L
#define VM_CONTEXT4_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00000400L
#define VM_CONTEXT4_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                   0x00000800L
#define VM_CONTEXT4_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                     0x00001000L
#define VM_CONTEXT4_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                         0x00002000L
#define VM_CONTEXT4_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                           0x00004000L
#define VM_CONTEXT4_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00008000L
#define VM_CONTEXT4_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00010000L
#define VM_CONTEXT4_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                         0x00020000L
#define VM_CONTEXT4_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                           0x00040000L
#define VM_CONTEXT4_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00080000L
#define VM_CONTEXT4_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00100000L
#define VM_CONTEXT4_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00200000L
#define VM_CONTEXT4_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00400000L
//VM_CONTEXT5_CNTL
#define VM_CONTEXT5_CNTL__ENABLE_CONTEXT__SHIFT                                                               0x0
#define VM_CONTEXT5_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                             0x1
#define VM_CONTEXT5_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                        0x3
#define VM_CONTEXT5_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                       0x7
#define VM_CONTEXT5_CNTL__RETRY_OTHER_FAULT__SHIFT                                                            0x8
#define VM_CONTEXT5_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x9
#define VM_CONTEXT5_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0xa
#define VM_CONTEXT5_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                 0xb
#define VM_CONTEXT5_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                   0xc
#define VM_CONTEXT5_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                       0xd
#define VM_CONTEXT5_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                         0xe
#define VM_CONTEXT5_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0xf
#define VM_CONTEXT5_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x10
#define VM_CONTEXT5_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                       0x11
#define VM_CONTEXT5_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                         0x12
#define VM_CONTEXT5_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x13
#define VM_CONTEXT5_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x14
#define VM_CONTEXT5_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x15
#define VM_CONTEXT5_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x16
#define VM_CONTEXT5_CNTL__ENABLE_CONTEXT_MASK                                                                 0x00000001L
#define VM_CONTEXT5_CNTL__PAGE_TABLE_DEPTH_MASK                                                               0x00000006L
#define VM_CONTEXT5_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                          0x00000078L
#define VM_CONTEXT5_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                         0x00000080L
#define VM_CONTEXT5_CNTL__RETRY_OTHER_FAULT_MASK                                                              0x00000100L
#define VM_CONTEXT5_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00000200L
#define VM_CONTEXT5_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00000400L
#define VM_CONTEXT5_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                   0x00000800L
#define VM_CONTEXT5_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                     0x00001000L
#define VM_CONTEXT5_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                         0x00002000L
#define VM_CONTEXT5_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                           0x00004000L
#define VM_CONTEXT5_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00008000L
#define VM_CONTEXT5_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00010000L
#define VM_CONTEXT5_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                         0x00020000L
#define VM_CONTEXT5_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                           0x00040000L
#define VM_CONTEXT5_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00080000L
#define VM_CONTEXT5_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00100000L
#define VM_CONTEXT5_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00200000L
#define VM_CONTEXT5_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00400000L
//VM_CONTEXT6_CNTL
#define VM_CONTEXT6_CNTL__ENABLE_CONTEXT__SHIFT                                                               0x0
#define VM_CONTEXT6_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                             0x1
#define VM_CONTEXT6_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                        0x3
#define VM_CONTEXT6_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                       0x7
#define VM_CONTEXT6_CNTL__RETRY_OTHER_FAULT__SHIFT                                                            0x8
#define VM_CONTEXT6_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x9
#define VM_CONTEXT6_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0xa
#define VM_CONTEXT6_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                 0xb
#define VM_CONTEXT6_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                   0xc
#define VM_CONTEXT6_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                       0xd
#define VM_CONTEXT6_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                         0xe
#define VM_CONTEXT6_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0xf
#define VM_CONTEXT6_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x10
#define VM_CONTEXT6_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                       0x11
#define VM_CONTEXT6_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                         0x12
#define VM_CONTEXT6_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x13
#define VM_CONTEXT6_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x14
#define VM_CONTEXT6_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x15
#define VM_CONTEXT6_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x16
#define VM_CONTEXT6_CNTL__ENABLE_CONTEXT_MASK                                                                 0x00000001L
#define VM_CONTEXT6_CNTL__PAGE_TABLE_DEPTH_MASK                                                               0x00000006L
#define VM_CONTEXT6_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                          0x00000078L
#define VM_CONTEXT6_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                         0x00000080L
#define VM_CONTEXT6_CNTL__RETRY_OTHER_FAULT_MASK                                                              0x00000100L
#define VM_CONTEXT6_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00000200L
#define VM_CONTEXT6_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00000400L
#define VM_CONTEXT6_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                   0x00000800L
#define VM_CONTEXT6_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                     0x00001000L
#define VM_CONTEXT6_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                         0x00002000L
#define VM_CONTEXT6_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                           0x00004000L
#define VM_CONTEXT6_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00008000L
#define VM_CONTEXT6_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00010000L
#define VM_CONTEXT6_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                         0x00020000L
#define VM_CONTEXT6_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                           0x00040000L
#define VM_CONTEXT6_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00080000L
#define VM_CONTEXT6_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00100000L
#define VM_CONTEXT6_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00200000L
#define VM_CONTEXT6_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00400000L
//VM_CONTEXT7_CNTL
#define VM_CONTEXT7_CNTL__ENABLE_CONTEXT__SHIFT                                                               0x0
#define VM_CONTEXT7_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                             0x1
#define VM_CONTEXT7_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                        0x3
#define VM_CONTEXT7_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                       0x7
#define VM_CONTEXT7_CNTL__RETRY_OTHER_FAULT__SHIFT                                                            0x8
#define VM_CONTEXT7_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x9
#define VM_CONTEXT7_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0xa
#define VM_CONTEXT7_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                 0xb
#define VM_CONTEXT7_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                   0xc
#define VM_CONTEXT7_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                       0xd
#define VM_CONTEXT7_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                         0xe
#define VM_CONTEXT7_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0xf
#define VM_CONTEXT7_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x10
#define VM_CONTEXT7_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                       0x11
#define VM_CONTEXT7_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                         0x12
#define VM_CONTEXT7_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x13
#define VM_CONTEXT7_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x14
#define VM_CONTEXT7_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x15
#define VM_CONTEXT7_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x16
#define VM_CONTEXT7_CNTL__ENABLE_CONTEXT_MASK                                                                 0x00000001L
#define VM_CONTEXT7_CNTL__PAGE_TABLE_DEPTH_MASK                                                               0x00000006L
#define VM_CONTEXT7_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                          0x00000078L
#define VM_CONTEXT7_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                         0x00000080L
#define VM_CONTEXT7_CNTL__RETRY_OTHER_FAULT_MASK                                                              0x00000100L
#define VM_CONTEXT7_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00000200L
#define VM_CONTEXT7_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00000400L
#define VM_CONTEXT7_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                   0x00000800L
#define VM_CONTEXT7_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                     0x00001000L
#define VM_CONTEXT7_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                         0x00002000L
#define VM_CONTEXT7_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                           0x00004000L
#define VM_CONTEXT7_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00008000L
#define VM_CONTEXT7_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00010000L
#define VM_CONTEXT7_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                         0x00020000L
#define VM_CONTEXT7_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                           0x00040000L
#define VM_CONTEXT7_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00080000L
#define VM_CONTEXT7_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00100000L
#define VM_CONTEXT7_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00200000L
#define VM_CONTEXT7_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00400000L
//VM_CONTEXT8_CNTL
#define VM_CONTEXT8_CNTL__ENABLE_CONTEXT__SHIFT                                                               0x0
#define VM_CONTEXT8_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                             0x1
#define VM_CONTEXT8_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                        0x3
#define VM_CONTEXT8_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                       0x7
#define VM_CONTEXT8_CNTL__RETRY_OTHER_FAULT__SHIFT                                                            0x8
#define VM_CONTEXT8_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x9
#define VM_CONTEXT8_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0xa
#define VM_CONTEXT8_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                 0xb
#define VM_CONTEXT8_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                   0xc
#define VM_CONTEXT8_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                       0xd
#define VM_CONTEXT8_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                         0xe
#define VM_CONTEXT8_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0xf
#define VM_CONTEXT8_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x10
#define VM_CONTEXT8_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                       0x11
#define VM_CONTEXT8_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                         0x12
#define VM_CONTEXT8_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x13
#define VM_CONTEXT8_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x14
#define VM_CONTEXT8_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x15
#define VM_CONTEXT8_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x16
#define VM_CONTEXT8_CNTL__ENABLE_CONTEXT_MASK                                                                 0x00000001L
#define VM_CONTEXT8_CNTL__PAGE_TABLE_DEPTH_MASK                                                               0x00000006L
#define VM_CONTEXT8_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                          0x00000078L
#define VM_CONTEXT8_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                         0x00000080L
#define VM_CONTEXT8_CNTL__RETRY_OTHER_FAULT_MASK                                                              0x00000100L
#define VM_CONTEXT8_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00000200L
#define VM_CONTEXT8_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00000400L
#define VM_CONTEXT8_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                   0x00000800L
#define VM_CONTEXT8_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                     0x00001000L
#define VM_CONTEXT8_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                         0x00002000L
#define VM_CONTEXT8_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                           0x00004000L
#define VM_CONTEXT8_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00008000L
#define VM_CONTEXT8_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00010000L
#define VM_CONTEXT8_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                         0x00020000L
#define VM_CONTEXT8_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                           0x00040000L
#define VM_CONTEXT8_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00080000L
#define VM_CONTEXT8_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00100000L
#define VM_CONTEXT8_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00200000L
#define VM_CONTEXT8_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00400000L
//VM_CONTEXT9_CNTL
#define VM_CONTEXT9_CNTL__ENABLE_CONTEXT__SHIFT                                                               0x0
#define VM_CONTEXT9_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                             0x1
#define VM_CONTEXT9_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                        0x3
#define VM_CONTEXT9_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                       0x7
#define VM_CONTEXT9_CNTL__RETRY_OTHER_FAULT__SHIFT                                                            0x8
#define VM_CONTEXT9_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x9
#define VM_CONTEXT9_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0xa
#define VM_CONTEXT9_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                 0xb
#define VM_CONTEXT9_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                   0xc
#define VM_CONTEXT9_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                       0xd
#define VM_CONTEXT9_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                         0xe
#define VM_CONTEXT9_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0xf
#define VM_CONTEXT9_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x10
#define VM_CONTEXT9_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                       0x11
#define VM_CONTEXT9_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                         0x12
#define VM_CONTEXT9_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x13
#define VM_CONTEXT9_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x14
#define VM_CONTEXT9_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x15
#define VM_CONTEXT9_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x16
#define VM_CONTEXT9_CNTL__ENABLE_CONTEXT_MASK                                                                 0x00000001L
#define VM_CONTEXT9_CNTL__PAGE_TABLE_DEPTH_MASK                                                               0x00000006L
#define VM_CONTEXT9_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                          0x00000078L
#define VM_CONTEXT9_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                         0x00000080L
#define VM_CONTEXT9_CNTL__RETRY_OTHER_FAULT_MASK                                                              0x00000100L
#define VM_CONTEXT9_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00000200L
#define VM_CONTEXT9_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00000400L
#define VM_CONTEXT9_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                   0x00000800L
#define VM_CONTEXT9_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                     0x00001000L
#define VM_CONTEXT9_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                         0x00002000L
#define VM_CONTEXT9_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                           0x00004000L
#define VM_CONTEXT9_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00008000L
#define VM_CONTEXT9_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00010000L
#define VM_CONTEXT9_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                         0x00020000L
#define VM_CONTEXT9_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                           0x00040000L
#define VM_CONTEXT9_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00080000L
#define VM_CONTEXT9_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00100000L
#define VM_CONTEXT9_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00200000L
#define VM_CONTEXT9_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00400000L
//VM_CONTEXT10_CNTL
#define VM_CONTEXT10_CNTL__ENABLE_CONTEXT__SHIFT                                                              0x0
#define VM_CONTEXT10_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                            0x1
#define VM_CONTEXT10_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                       0x3
#define VM_CONTEXT10_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                      0x7
#define VM_CONTEXT10_CNTL__RETRY_OTHER_FAULT__SHIFT                                                           0x8
#define VM_CONTEXT10_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0x9
#define VM_CONTEXT10_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0xa
#define VM_CONTEXT10_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                0xb
#define VM_CONTEXT10_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                  0xc
#define VM_CONTEXT10_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0xd
#define VM_CONTEXT10_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0xe
#define VM_CONTEXT10_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0xf
#define VM_CONTEXT10_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0x10
#define VM_CONTEXT10_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x11
#define VM_CONTEXT10_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x12
#define VM_CONTEXT10_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0x13
#define VM_CONTEXT10_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0x14
#define VM_CONTEXT10_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                   0x15
#define VM_CONTEXT10_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                     0x16
#define VM_CONTEXT10_CNTL__ENABLE_CONTEXT_MASK                                                                0x00000001L
#define VM_CONTEXT10_CNTL__PAGE_TABLE_DEPTH_MASK                                                              0x00000006L
#define VM_CONTEXT10_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                         0x00000078L
#define VM_CONTEXT10_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                        0x00000080L
#define VM_CONTEXT10_CNTL__RETRY_OTHER_FAULT_MASK                                                             0x00000100L
#define VM_CONTEXT10_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00000200L
#define VM_CONTEXT10_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00000400L
#define VM_CONTEXT10_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                  0x00000800L
#define VM_CONTEXT10_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                    0x00001000L
#define VM_CONTEXT10_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00002000L
#define VM_CONTEXT10_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00004000L
#define VM_CONTEXT10_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00008000L
#define VM_CONTEXT10_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00010000L
#define VM_CONTEXT10_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00020000L
#define VM_CONTEXT10_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00040000L
#define VM_CONTEXT10_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00080000L
#define VM_CONTEXT10_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00100000L
#define VM_CONTEXT10_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                     0x00200000L
#define VM_CONTEXT10_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                       0x00400000L
//VM_CONTEXT11_CNTL
#define VM_CONTEXT11_CNTL__ENABLE_CONTEXT__SHIFT                                                              0x0
#define VM_CONTEXT11_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                            0x1
#define VM_CONTEXT11_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                       0x3
#define VM_CONTEXT11_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                      0x7
#define VM_CONTEXT11_CNTL__RETRY_OTHER_FAULT__SHIFT                                                           0x8
#define VM_CONTEXT11_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0x9
#define VM_CONTEXT11_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0xa
#define VM_CONTEXT11_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                0xb
#define VM_CONTEXT11_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                  0xc
#define VM_CONTEXT11_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0xd
#define VM_CONTEXT11_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0xe
#define VM_CONTEXT11_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0xf
#define VM_CONTEXT11_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0x10
#define VM_CONTEXT11_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x11
#define VM_CONTEXT11_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x12
#define VM_CONTEXT11_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0x13
#define VM_CONTEXT11_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0x14
#define VM_CONTEXT11_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                   0x15
#define VM_CONTEXT11_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                     0x16
#define VM_CONTEXT11_CNTL__ENABLE_CONTEXT_MASK                                                                0x00000001L
#define VM_CONTEXT11_CNTL__PAGE_TABLE_DEPTH_MASK                                                              0x00000006L
#define VM_CONTEXT11_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                         0x00000078L
#define VM_CONTEXT11_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                        0x00000080L
#define VM_CONTEXT11_CNTL__RETRY_OTHER_FAULT_MASK                                                             0x00000100L
#define VM_CONTEXT11_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00000200L
#define VM_CONTEXT11_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00000400L
#define VM_CONTEXT11_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                  0x00000800L
#define VM_CONTEXT11_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                    0x00001000L
#define VM_CONTEXT11_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00002000L
#define VM_CONTEXT11_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00004000L
#define VM_CONTEXT11_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00008000L
#define VM_CONTEXT11_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00010000L
#define VM_CONTEXT11_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00020000L
#define VM_CONTEXT11_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00040000L
#define VM_CONTEXT11_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00080000L
#define VM_CONTEXT11_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00100000L
#define VM_CONTEXT11_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                     0x00200000L
#define VM_CONTEXT11_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                       0x00400000L
//VM_CONTEXT12_CNTL
#define VM_CONTEXT12_CNTL__ENABLE_CONTEXT__SHIFT                                                              0x0
#define VM_CONTEXT12_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                            0x1
#define VM_CONTEXT12_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                       0x3
#define VM_CONTEXT12_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                      0x7
#define VM_CONTEXT12_CNTL__RETRY_OTHER_FAULT__SHIFT                                                           0x8
#define VM_CONTEXT12_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0x9
#define VM_CONTEXT12_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0xa
#define VM_CONTEXT12_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                0xb
#define VM_CONTEXT12_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                  0xc
#define VM_CONTEXT12_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0xd
#define VM_CONTEXT12_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0xe
#define VM_CONTEXT12_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0xf
#define VM_CONTEXT12_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0x10
#define VM_CONTEXT12_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x11
#define VM_CONTEXT12_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x12
#define VM_CONTEXT12_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0x13
#define VM_CONTEXT12_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0x14
#define VM_CONTEXT12_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                   0x15
#define VM_CONTEXT12_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                     0x16
#define VM_CONTEXT12_CNTL__ENABLE_CONTEXT_MASK                                                                0x00000001L
#define VM_CONTEXT12_CNTL__PAGE_TABLE_DEPTH_MASK                                                              0x00000006L
#define VM_CONTEXT12_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                         0x00000078L
#define VM_CONTEXT12_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                        0x00000080L
#define VM_CONTEXT12_CNTL__RETRY_OTHER_FAULT_MASK                                                             0x00000100L
#define VM_CONTEXT12_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00000200L
#define VM_CONTEXT12_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00000400L
#define VM_CONTEXT12_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                  0x00000800L
#define VM_CONTEXT12_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                    0x00001000L
#define VM_CONTEXT12_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00002000L
#define VM_CONTEXT12_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00004000L
#define VM_CONTEXT12_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00008000L
#define VM_CONTEXT12_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00010000L
#define VM_CONTEXT12_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00020000L
#define VM_CONTEXT12_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00040000L
#define VM_CONTEXT12_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00080000L
#define VM_CONTEXT12_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00100000L
#define VM_CONTEXT12_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                     0x00200000L
#define VM_CONTEXT12_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                       0x00400000L
//VM_CONTEXT13_CNTL
#define VM_CONTEXT13_CNTL__ENABLE_CONTEXT__SHIFT                                                              0x0
#define VM_CONTEXT13_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                            0x1
#define VM_CONTEXT13_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                       0x3
#define VM_CONTEXT13_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                      0x7
#define VM_CONTEXT13_CNTL__RETRY_OTHER_FAULT__SHIFT                                                           0x8
#define VM_CONTEXT13_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0x9
#define VM_CONTEXT13_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0xa
#define VM_CONTEXT13_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                0xb
#define VM_CONTEXT13_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                  0xc
#define VM_CONTEXT13_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0xd
#define VM_CONTEXT13_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0xe
#define VM_CONTEXT13_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0xf
#define VM_CONTEXT13_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0x10
#define VM_CONTEXT13_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x11
#define VM_CONTEXT13_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x12
#define VM_CONTEXT13_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0x13
#define VM_CONTEXT13_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0x14
#define VM_CONTEXT13_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                   0x15
#define VM_CONTEXT13_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                     0x16
#define VM_CONTEXT13_CNTL__ENABLE_CONTEXT_MASK                                                                0x00000001L
#define VM_CONTEXT13_CNTL__PAGE_TABLE_DEPTH_MASK                                                              0x00000006L
#define VM_CONTEXT13_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                         0x00000078L
#define VM_CONTEXT13_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                        0x00000080L
#define VM_CONTEXT13_CNTL__RETRY_OTHER_FAULT_MASK                                                             0x00000100L
#define VM_CONTEXT13_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00000200L
#define VM_CONTEXT13_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00000400L
#define VM_CONTEXT13_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                  0x00000800L
#define VM_CONTEXT13_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                    0x00001000L
#define VM_CONTEXT13_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00002000L
#define VM_CONTEXT13_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00004000L
#define VM_CONTEXT13_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00008000L
#define VM_CONTEXT13_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00010000L
#define VM_CONTEXT13_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00020000L
#define VM_CONTEXT13_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00040000L
#define VM_CONTEXT13_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00080000L
#define VM_CONTEXT13_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00100000L
#define VM_CONTEXT13_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                     0x00200000L
#define VM_CONTEXT13_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                       0x00400000L
//VM_CONTEXT14_CNTL
#define VM_CONTEXT14_CNTL__ENABLE_CONTEXT__SHIFT                                                              0x0
#define VM_CONTEXT14_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                            0x1
#define VM_CONTEXT14_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                       0x3
#define VM_CONTEXT14_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                      0x7
#define VM_CONTEXT14_CNTL__RETRY_OTHER_FAULT__SHIFT                                                           0x8
#define VM_CONTEXT14_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0x9
#define VM_CONTEXT14_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0xa
#define VM_CONTEXT14_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                0xb
#define VM_CONTEXT14_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                  0xc
#define VM_CONTEXT14_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0xd
#define VM_CONTEXT14_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0xe
#define VM_CONTEXT14_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0xf
#define VM_CONTEXT14_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0x10
#define VM_CONTEXT14_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x11
#define VM_CONTEXT14_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x12
#define VM_CONTEXT14_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0x13
#define VM_CONTEXT14_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0x14
#define VM_CONTEXT14_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                   0x15
#define VM_CONTEXT14_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                     0x16
#define VM_CONTEXT14_CNTL__ENABLE_CONTEXT_MASK                                                                0x00000001L
#define VM_CONTEXT14_CNTL__PAGE_TABLE_DEPTH_MASK                                                              0x00000006L
#define VM_CONTEXT14_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                         0x00000078L
#define VM_CONTEXT14_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                        0x00000080L
#define VM_CONTEXT14_CNTL__RETRY_OTHER_FAULT_MASK                                                             0x00000100L
#define VM_CONTEXT14_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00000200L
#define VM_CONTEXT14_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00000400L
#define VM_CONTEXT14_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                  0x00000800L
#define VM_CONTEXT14_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                    0x00001000L
#define VM_CONTEXT14_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00002000L
#define VM_CONTEXT14_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00004000L
#define VM_CONTEXT14_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00008000L
#define VM_CONTEXT14_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00010000L
#define VM_CONTEXT14_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00020000L
#define VM_CONTEXT14_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00040000L
#define VM_CONTEXT14_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00080000L
#define VM_CONTEXT14_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00100000L
#define VM_CONTEXT14_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                     0x00200000L
#define VM_CONTEXT14_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                       0x00400000L
//VM_CONTEXT15_CNTL
#define VM_CONTEXT15_CNTL__ENABLE_CONTEXT__SHIFT                                                              0x0
#define VM_CONTEXT15_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                            0x1
#define VM_CONTEXT15_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                       0x3
#define VM_CONTEXT15_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                      0x7
#define VM_CONTEXT15_CNTL__RETRY_OTHER_FAULT__SHIFT                                                           0x8
#define VM_CONTEXT15_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0x9
#define VM_CONTEXT15_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0xa
#define VM_CONTEXT15_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                0xb
#define VM_CONTEXT15_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                  0xc
#define VM_CONTEXT15_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0xd
#define VM_CONTEXT15_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0xe
#define VM_CONTEXT15_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0xf
#define VM_CONTEXT15_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0x10
#define VM_CONTEXT15_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                      0x11
#define VM_CONTEXT15_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                        0x12
#define VM_CONTEXT15_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0x13
#define VM_CONTEXT15_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0x14
#define VM_CONTEXT15_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                   0x15
#define VM_CONTEXT15_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                     0x16
#define VM_CONTEXT15_CNTL__ENABLE_CONTEXT_MASK                                                                0x00000001L
#define VM_CONTEXT15_CNTL__PAGE_TABLE_DEPTH_MASK                                                              0x00000006L
#define VM_CONTEXT15_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                         0x00000078L
#define VM_CONTEXT15_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                        0x00000080L
#define VM_CONTEXT15_CNTL__RETRY_OTHER_FAULT_MASK                                                             0x00000100L
#define VM_CONTEXT15_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00000200L
#define VM_CONTEXT15_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00000400L
#define VM_CONTEXT15_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                  0x00000800L
#define VM_CONTEXT15_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                    0x00001000L
#define VM_CONTEXT15_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00002000L
#define VM_CONTEXT15_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00004000L
#define VM_CONTEXT15_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00008000L
#define VM_CONTEXT15_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00010000L
#define VM_CONTEXT15_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                        0x00020000L
#define VM_CONTEXT15_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                          0x00040000L
#define VM_CONTEXT15_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00080000L
#define VM_CONTEXT15_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00100000L
#define VM_CONTEXT15_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                     0x00200000L
#define VM_CONTEXT15_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                       0x00400000L
//VM_CONTEXTS_DISABLE
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_0__SHIFT                                                         0x0
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_1__SHIFT                                                         0x1
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_2__SHIFT                                                         0x2
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_3__SHIFT                                                         0x3
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_4__SHIFT                                                         0x4
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_5__SHIFT                                                         0x5
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_6__SHIFT                                                         0x6
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_7__SHIFT                                                         0x7
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_8__SHIFT                                                         0x8
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_9__SHIFT                                                         0x9
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_10__SHIFT                                                        0xa
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_11__SHIFT                                                        0xb
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_12__SHIFT                                                        0xc
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_13__SHIFT                                                        0xd
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_14__SHIFT                                                        0xe
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_15__SHIFT                                                        0xf
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_0_MASK                                                           0x00000001L
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_1_MASK                                                           0x00000002L
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_2_MASK                                                           0x00000004L
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_3_MASK                                                           0x00000008L
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_4_MASK                                                           0x00000010L
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_5_MASK                                                           0x00000020L
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_6_MASK                                                           0x00000040L
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_7_MASK                                                           0x00000080L
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_8_MASK                                                           0x00000100L
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_9_MASK                                                           0x00000200L
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_10_MASK                                                          0x00000400L
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_11_MASK                                                          0x00000800L
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_12_MASK                                                          0x00001000L
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_13_MASK                                                          0x00002000L
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_14_MASK                                                          0x00004000L
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_15_MASK                                                          0x00008000L
//VM_INVALIDATE_ENG0_SEM
#define VM_INVALIDATE_ENG0_SEM__SEMAPHORE__SHIFT                                                              0x0
#define VM_INVALIDATE_ENG0_SEM__SEMAPHORE_MASK                                                                0x00000001L
//VM_INVALIDATE_ENG1_SEM
#define VM_INVALIDATE_ENG1_SEM__SEMAPHORE__SHIFT                                                              0x0
#define VM_INVALIDATE_ENG1_SEM__SEMAPHORE_MASK                                                                0x00000001L
//VM_INVALIDATE_ENG2_SEM
#define VM_INVALIDATE_ENG2_SEM__SEMAPHORE__SHIFT                                                              0x0
#define VM_INVALIDATE_ENG2_SEM__SEMAPHORE_MASK                                                                0x00000001L
//VM_INVALIDATE_ENG3_SEM
#define VM_INVALIDATE_ENG3_SEM__SEMAPHORE__SHIFT                                                              0x0
#define VM_INVALIDATE_ENG3_SEM__SEMAPHORE_MASK                                                                0x00000001L
//VM_INVALIDATE_ENG4_SEM
#define VM_INVALIDATE_ENG4_SEM__SEMAPHORE__SHIFT                                                              0x0
#define VM_INVALIDATE_ENG4_SEM__SEMAPHORE_MASK                                                                0x00000001L
//VM_INVALIDATE_ENG5_SEM
#define VM_INVALIDATE_ENG5_SEM__SEMAPHORE__SHIFT                                                              0x0
#define VM_INVALIDATE_ENG5_SEM__SEMAPHORE_MASK                                                                0x00000001L
//VM_INVALIDATE_ENG6_SEM
#define VM_INVALIDATE_ENG6_SEM__SEMAPHORE__SHIFT                                                              0x0
#define VM_INVALIDATE_ENG6_SEM__SEMAPHORE_MASK                                                                0x00000001L
//VM_INVALIDATE_ENG7_SEM
#define VM_INVALIDATE_ENG7_SEM__SEMAPHORE__SHIFT                                                              0x0
#define VM_INVALIDATE_ENG7_SEM__SEMAPHORE_MASK                                                                0x00000001L
//VM_INVALIDATE_ENG8_SEM
#define VM_INVALIDATE_ENG8_SEM__SEMAPHORE__SHIFT                                                              0x0
#define VM_INVALIDATE_ENG8_SEM__SEMAPHORE_MASK                                                                0x00000001L
//VM_INVALIDATE_ENG9_SEM
#define VM_INVALIDATE_ENG9_SEM__SEMAPHORE__SHIFT                                                              0x0
#define VM_INVALIDATE_ENG9_SEM__SEMAPHORE_MASK                                                                0x00000001L
//VM_INVALIDATE_ENG10_SEM
#define VM_INVALIDATE_ENG10_SEM__SEMAPHORE__SHIFT                                                             0x0
#define VM_INVALIDATE_ENG10_SEM__SEMAPHORE_MASK                                                               0x00000001L
//VM_INVALIDATE_ENG11_SEM
#define VM_INVALIDATE_ENG11_SEM__SEMAPHORE__SHIFT                                                             0x0
#define VM_INVALIDATE_ENG11_SEM__SEMAPHORE_MASK                                                               0x00000001L
//VM_INVALIDATE_ENG12_SEM
#define VM_INVALIDATE_ENG12_SEM__SEMAPHORE__SHIFT                                                             0x0
#define VM_INVALIDATE_ENG12_SEM__SEMAPHORE_MASK                                                               0x00000001L
//VM_INVALIDATE_ENG13_SEM
#define VM_INVALIDATE_ENG13_SEM__SEMAPHORE__SHIFT                                                             0x0
#define VM_INVALIDATE_ENG13_SEM__SEMAPHORE_MASK                                                               0x00000001L
//VM_INVALIDATE_ENG14_SEM
#define VM_INVALIDATE_ENG14_SEM__SEMAPHORE__SHIFT                                                             0x0
#define VM_INVALIDATE_ENG14_SEM__SEMAPHORE_MASK                                                               0x00000001L
//VM_INVALIDATE_ENG15_SEM
#define VM_INVALIDATE_ENG15_SEM__SEMAPHORE__SHIFT                                                             0x0
#define VM_INVALIDATE_ENG15_SEM__SEMAPHORE_MASK                                                               0x00000001L
//VM_INVALIDATE_ENG16_SEM
#define VM_INVALIDATE_ENG16_SEM__SEMAPHORE__SHIFT                                                             0x0
#define VM_INVALIDATE_ENG16_SEM__SEMAPHORE_MASK                                                               0x00000001L
//VM_INVALIDATE_ENG17_SEM
#define VM_INVALIDATE_ENG17_SEM__SEMAPHORE__SHIFT                                                             0x0
#define VM_INVALIDATE_ENG17_SEM__SEMAPHORE_MASK                                                               0x00000001L
//VM_INVALIDATE_ENG0_REQ
#define VM_INVALIDATE_ENG0_REQ__PER_VMID_INVALIDATE_REQ__SHIFT                                                0x0
#define VM_INVALIDATE_ENG0_REQ__FLUSH_TYPE__SHIFT                                                             0x10
#define VM_INVALIDATE_ENG0_REQ__INVALIDATE_L2_PTES__SHIFT                                                     0x12
#define VM_INVALIDATE_ENG0_REQ__INVALIDATE_L2_PDE0__SHIFT                                                     0x13
#define VM_INVALIDATE_ENG0_REQ__INVALIDATE_L2_PDE1__SHIFT                                                     0x14
#define VM_INVALIDATE_ENG0_REQ__INVALIDATE_L2_PDE2__SHIFT                                                     0x15
#define VM_INVALIDATE_ENG0_REQ__INVALIDATE_L1_PTES__SHIFT                                                     0x16
#define VM_INVALIDATE_ENG0_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT                                     0x17
#define VM_INVALIDATE_ENG0_REQ__PER_VMID_INVALIDATE_REQ_MASK                                                  0x0000FFFFL
#define VM_INVALIDATE_ENG0_REQ__FLUSH_TYPE_MASK                                                               0x00030000L
#define VM_INVALIDATE_ENG0_REQ__INVALIDATE_L2_PTES_MASK                                                       0x00040000L
#define VM_INVALIDATE_ENG0_REQ__INVALIDATE_L2_PDE0_MASK                                                       0x00080000L
#define VM_INVALIDATE_ENG0_REQ__INVALIDATE_L2_PDE1_MASK                                                       0x00100000L
#define VM_INVALIDATE_ENG0_REQ__INVALIDATE_L2_PDE2_MASK                                                       0x00200000L
#define VM_INVALIDATE_ENG0_REQ__INVALIDATE_L1_PTES_MASK                                                       0x00400000L
#define VM_INVALIDATE_ENG0_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK                                       0x00800000L
//VM_INVALIDATE_ENG1_REQ
#define VM_INVALIDATE_ENG1_REQ__PER_VMID_INVALIDATE_REQ__SHIFT                                                0x0
#define VM_INVALIDATE_ENG1_REQ__FLUSH_TYPE__SHIFT                                                             0x10
#define VM_INVALIDATE_ENG1_REQ__INVALIDATE_L2_PTES__SHIFT                                                     0x12
#define VM_INVALIDATE_ENG1_REQ__INVALIDATE_L2_PDE0__SHIFT                                                     0x13
#define VM_INVALIDATE_ENG1_REQ__INVALIDATE_L2_PDE1__SHIFT                                                     0x14
#define VM_INVALIDATE_ENG1_REQ__INVALIDATE_L2_PDE2__SHIFT                                                     0x15
#define VM_INVALIDATE_ENG1_REQ__INVALIDATE_L1_PTES__SHIFT                                                     0x16
#define VM_INVALIDATE_ENG1_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT                                     0x17
#define VM_INVALIDATE_ENG1_REQ__PER_VMID_INVALIDATE_REQ_MASK                                                  0x0000FFFFL
#define VM_INVALIDATE_ENG1_REQ__FLUSH_TYPE_MASK                                                               0x00030000L
#define VM_INVALIDATE_ENG1_REQ__INVALIDATE_L2_PTES_MASK                                                       0x00040000L
#define VM_INVALIDATE_ENG1_REQ__INVALIDATE_L2_PDE0_MASK                                                       0x00080000L
#define VM_INVALIDATE_ENG1_REQ__INVALIDATE_L2_PDE1_MASK                                                       0x00100000L
#define VM_INVALIDATE_ENG1_REQ__INVALIDATE_L2_PDE2_MASK                                                       0x00200000L
#define VM_INVALIDATE_ENG1_REQ__INVALIDATE_L1_PTES_MASK                                                       0x00400000L
#define VM_INVALIDATE_ENG1_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK                                       0x00800000L
//VM_INVALIDATE_ENG2_REQ
#define VM_INVALIDATE_ENG2_REQ__PER_VMID_INVALIDATE_REQ__SHIFT                                                0x0
#define VM_INVALIDATE_ENG2_REQ__FLUSH_TYPE__SHIFT                                                             0x10
#define VM_INVALIDATE_ENG2_REQ__INVALIDATE_L2_PTES__SHIFT                                                     0x12
#define VM_INVALIDATE_ENG2_REQ__INVALIDATE_L2_PDE0__SHIFT                                                     0x13
#define VM_INVALIDATE_ENG2_REQ__INVALIDATE_L2_PDE1__SHIFT                                                     0x14
#define VM_INVALIDATE_ENG2_REQ__INVALIDATE_L2_PDE2__SHIFT                                                     0x15
#define VM_INVALIDATE_ENG2_REQ__INVALIDATE_L1_PTES__SHIFT                                                     0x16
#define VM_INVALIDATE_ENG2_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT                                     0x17
#define VM_INVALIDATE_ENG2_REQ__PER_VMID_INVALIDATE_REQ_MASK                                                  0x0000FFFFL
#define VM_INVALIDATE_ENG2_REQ__FLUSH_TYPE_MASK                                                               0x00030000L
#define VM_INVALIDATE_ENG2_REQ__INVALIDATE_L2_PTES_MASK                                                       0x00040000L
#define VM_INVALIDATE_ENG2_REQ__INVALIDATE_L2_PDE0_MASK                                                       0x00080000L
#define VM_INVALIDATE_ENG2_REQ__INVALIDATE_L2_PDE1_MASK                                                       0x00100000L
#define VM_INVALIDATE_ENG2_REQ__INVALIDATE_L2_PDE2_MASK                                                       0x00200000L
#define VM_INVALIDATE_ENG2_REQ__INVALIDATE_L1_PTES_MASK                                                       0x00400000L
#define VM_INVALIDATE_ENG2_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK                                       0x00800000L
//VM_INVALIDATE_ENG3_REQ
#define VM_INVALIDATE_ENG3_REQ__PER_VMID_INVALIDATE_REQ__SHIFT                                                0x0
#define VM_INVALIDATE_ENG3_REQ__FLUSH_TYPE__SHIFT                                                             0x10
#define VM_INVALIDATE_ENG3_REQ__INVALIDATE_L2_PTES__SHIFT                                                     0x12
#define VM_INVALIDATE_ENG3_REQ__INVALIDATE_L2_PDE0__SHIFT                                                     0x13
#define VM_INVALIDATE_ENG3_REQ__INVALIDATE_L2_PDE1__SHIFT                                                     0x14
#define VM_INVALIDATE_ENG3_REQ__INVALIDATE_L2_PDE2__SHIFT                                                     0x15
#define VM_INVALIDATE_ENG3_REQ__INVALIDATE_L1_PTES__SHIFT                                                     0x16
#define VM_INVALIDATE_ENG3_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT                                     0x17
#define VM_INVALIDATE_ENG3_REQ__PER_VMID_INVALIDATE_REQ_MASK                                                  0x0000FFFFL
#define VM_INVALIDATE_ENG3_REQ__FLUSH_TYPE_MASK                                                               0x00030000L
#define VM_INVALIDATE_ENG3_REQ__INVALIDATE_L2_PTES_MASK                                                       0x00040000L
#define VM_INVALIDATE_ENG3_REQ__INVALIDATE_L2_PDE0_MASK                                                       0x00080000L
#define VM_INVALIDATE_ENG3_REQ__INVALIDATE_L2_PDE1_MASK                                                       0x00100000L
#define VM_INVALIDATE_ENG3_REQ__INVALIDATE_L2_PDE2_MASK                                                       0x00200000L
#define VM_INVALIDATE_ENG3_REQ__INVALIDATE_L1_PTES_MASK                                                       0x00400000L
#define VM_INVALIDATE_ENG3_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK                                       0x00800000L
//VM_INVALIDATE_ENG4_REQ
#define VM_INVALIDATE_ENG4_REQ__PER_VMID_INVALIDATE_REQ__SHIFT                                                0x0
#define VM_INVALIDATE_ENG4_REQ__FLUSH_TYPE__SHIFT                                                             0x10
#define VM_INVALIDATE_ENG4_REQ__INVALIDATE_L2_PTES__SHIFT                                                     0x12
#define VM_INVALIDATE_ENG4_REQ__INVALIDATE_L2_PDE0__SHIFT                                                     0x13
#define VM_INVALIDATE_ENG4_REQ__INVALIDATE_L2_PDE1__SHIFT                                                     0x14
#define VM_INVALIDATE_ENG4_REQ__INVALIDATE_L2_PDE2__SHIFT                                                     0x15
#define VM_INVALIDATE_ENG4_REQ__INVALIDATE_L1_PTES__SHIFT                                                     0x16
#define VM_INVALIDATE_ENG4_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT                                     0x17
#define VM_INVALIDATE_ENG4_REQ__PER_VMID_INVALIDATE_REQ_MASK                                                  0x0000FFFFL
#define VM_INVALIDATE_ENG4_REQ__FLUSH_TYPE_MASK                                                               0x00030000L
#define VM_INVALIDATE_ENG4_REQ__INVALIDATE_L2_PTES_MASK                                                       0x00040000L
#define VM_INVALIDATE_ENG4_REQ__INVALIDATE_L2_PDE0_MASK                                                       0x00080000L
#define VM_INVALIDATE_ENG4_REQ__INVALIDATE_L2_PDE1_MASK                                                       0x00100000L
#define VM_INVALIDATE_ENG4_REQ__INVALIDATE_L2_PDE2_MASK                                                       0x00200000L
#define VM_INVALIDATE_ENG4_REQ__INVALIDATE_L1_PTES_MASK                                                       0x00400000L
#define VM_INVALIDATE_ENG4_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK                                       0x00800000L
//VM_INVALIDATE_ENG5_REQ
#define VM_INVALIDATE_ENG5_REQ__PER_VMID_INVALIDATE_REQ__SHIFT                                                0x0
#define VM_INVALIDATE_ENG5_REQ__FLUSH_TYPE__SHIFT                                                             0x10
#define VM_INVALIDATE_ENG5_REQ__INVALIDATE_L2_PTES__SHIFT                                                     0x12
#define VM_INVALIDATE_ENG5_REQ__INVALIDATE_L2_PDE0__SHIFT                                                     0x13
#define VM_INVALIDATE_ENG5_REQ__INVALIDATE_L2_PDE1__SHIFT                                                     0x14
#define VM_INVALIDATE_ENG5_REQ__INVALIDATE_L2_PDE2__SHIFT                                                     0x15
#define VM_INVALIDATE_ENG5_REQ__INVALIDATE_L1_PTES__SHIFT                                                     0x16
#define VM_INVALIDATE_ENG5_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT                                     0x17
#define VM_INVALIDATE_ENG5_REQ__PER_VMID_INVALIDATE_REQ_MASK                                                  0x0000FFFFL
#define VM_INVALIDATE_ENG5_REQ__FLUSH_TYPE_MASK                                                               0x00030000L
#define VM_INVALIDATE_ENG5_REQ__INVALIDATE_L2_PTES_MASK                                                       0x00040000L
#define VM_INVALIDATE_ENG5_REQ__INVALIDATE_L2_PDE0_MASK                                                       0x00080000L
#define VM_INVALIDATE_ENG5_REQ__INVALIDATE_L2_PDE1_MASK                                                       0x00100000L
#define VM_INVALIDATE_ENG5_REQ__INVALIDATE_L2_PDE2_MASK                                                       0x00200000L
#define VM_INVALIDATE_ENG5_REQ__INVALIDATE_L1_PTES_MASK                                                       0x00400000L
#define VM_INVALIDATE_ENG5_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK                                       0x00800000L
//VM_INVALIDATE_ENG6_REQ
#define VM_INVALIDATE_ENG6_REQ__PER_VMID_INVALIDATE_REQ__SHIFT                                                0x0
#define VM_INVALIDATE_ENG6_REQ__FLUSH_TYPE__SHIFT                                                             0x10
#define VM_INVALIDATE_ENG6_REQ__INVALIDATE_L2_PTES__SHIFT                                                     0x12
#define VM_INVALIDATE_ENG6_REQ__INVALIDATE_L2_PDE0__SHIFT                                                     0x13
#define VM_INVALIDATE_ENG6_REQ__INVALIDATE_L2_PDE1__SHIFT                                                     0x14
#define VM_INVALIDATE_ENG6_REQ__INVALIDATE_L2_PDE2__SHIFT                                                     0x15
#define VM_INVALIDATE_ENG6_REQ__INVALIDATE_L1_PTES__SHIFT                                                     0x16
#define VM_INVALIDATE_ENG6_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT                                     0x17
#define VM_INVALIDATE_ENG6_REQ__PER_VMID_INVALIDATE_REQ_MASK                                                  0x0000FFFFL
#define VM_INVALIDATE_ENG6_REQ__FLUSH_TYPE_MASK                                                               0x00030000L
#define VM_INVALIDATE_ENG6_REQ__INVALIDATE_L2_PTES_MASK                                                       0x00040000L
#define VM_INVALIDATE_ENG6_REQ__INVALIDATE_L2_PDE0_MASK                                                       0x00080000L
#define VM_INVALIDATE_ENG6_REQ__INVALIDATE_L2_PDE1_MASK                                                       0x00100000L
#define VM_INVALIDATE_ENG6_REQ__INVALIDATE_L2_PDE2_MASK                                                       0x00200000L
#define VM_INVALIDATE_ENG6_REQ__INVALIDATE_L1_PTES_MASK                                                       0x00400000L
#define VM_INVALIDATE_ENG6_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK                                       0x00800000L
//VM_INVALIDATE_ENG7_REQ
#define VM_INVALIDATE_ENG7_REQ__PER_VMID_INVALIDATE_REQ__SHIFT                                                0x0
#define VM_INVALIDATE_ENG7_REQ__FLUSH_TYPE__SHIFT                                                             0x10
#define VM_INVALIDATE_ENG7_REQ__INVALIDATE_L2_PTES__SHIFT                                                     0x12
#define VM_INVALIDATE_ENG7_REQ__INVALIDATE_L2_PDE0__SHIFT                                                     0x13
#define VM_INVALIDATE_ENG7_REQ__INVALIDATE_L2_PDE1__SHIFT                                                     0x14
#define VM_INVALIDATE_ENG7_REQ__INVALIDATE_L2_PDE2__SHIFT                                                     0x15
#define VM_INVALIDATE_ENG7_REQ__INVALIDATE_L1_PTES__SHIFT                                                     0x16
#define VM_INVALIDATE_ENG7_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT                                     0x17
#define VM_INVALIDATE_ENG7_REQ__PER_VMID_INVALIDATE_REQ_MASK                                                  0x0000FFFFL
#define VM_INVALIDATE_ENG7_REQ__FLUSH_TYPE_MASK                                                               0x00030000L
#define VM_INVALIDATE_ENG7_REQ__INVALIDATE_L2_PTES_MASK                                                       0x00040000L
#define VM_INVALIDATE_ENG7_REQ__INVALIDATE_L2_PDE0_MASK                                                       0x00080000L
#define VM_INVALIDATE_ENG7_REQ__INVALIDATE_L2_PDE1_MASK                                                       0x00100000L
#define VM_INVALIDATE_ENG7_REQ__INVALIDATE_L2_PDE2_MASK                                                       0x00200000L
#define VM_INVALIDATE_ENG7_REQ__INVALIDATE_L1_PTES_MASK                                                       0x00400000L
#define VM_INVALIDATE_ENG7_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK                                       0x00800000L
//VM_INVALIDATE_ENG8_REQ
#define VM_INVALIDATE_ENG8_REQ__PER_VMID_INVALIDATE_REQ__SHIFT                                                0x0
#define VM_INVALIDATE_ENG8_REQ__FLUSH_TYPE__SHIFT                                                             0x10
#define VM_INVALIDATE_ENG8_REQ__INVALIDATE_L2_PTES__SHIFT                                                     0x12
#define VM_INVALIDATE_ENG8_REQ__INVALIDATE_L2_PDE0__SHIFT                                                     0x13
#define VM_INVALIDATE_ENG8_REQ__INVALIDATE_L2_PDE1__SHIFT                                                     0x14
#define VM_INVALIDATE_ENG8_REQ__INVALIDATE_L2_PDE2__SHIFT                                                     0x15
#define VM_INVALIDATE_ENG8_REQ__INVALIDATE_L1_PTES__SHIFT                                                     0x16
#define VM_INVALIDATE_ENG8_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT                                     0x17
#define VM_INVALIDATE_ENG8_REQ__PER_VMID_INVALIDATE_REQ_MASK                                                  0x0000FFFFL
#define VM_INVALIDATE_ENG8_REQ__FLUSH_TYPE_MASK                                                               0x00030000L
#define VM_INVALIDATE_ENG8_REQ__INVALIDATE_L2_PTES_MASK                                                       0x00040000L
#define VM_INVALIDATE_ENG8_REQ__INVALIDATE_L2_PDE0_MASK                                                       0x00080000L
#define VM_INVALIDATE_ENG8_REQ__INVALIDATE_L2_PDE1_MASK                                                       0x00100000L
#define VM_INVALIDATE_ENG8_REQ__INVALIDATE_L2_PDE2_MASK                                                       0x00200000L
#define VM_INVALIDATE_ENG8_REQ__INVALIDATE_L1_PTES_MASK                                                       0x00400000L
#define VM_INVALIDATE_ENG8_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK                                       0x00800000L
//VM_INVALIDATE_ENG9_REQ
#define VM_INVALIDATE_ENG9_REQ__PER_VMID_INVALIDATE_REQ__SHIFT                                                0x0
#define VM_INVALIDATE_ENG9_REQ__FLUSH_TYPE__SHIFT                                                             0x10
#define VM_INVALIDATE_ENG9_REQ__INVALIDATE_L2_PTES__SHIFT                                                     0x12
#define VM_INVALIDATE_ENG9_REQ__INVALIDATE_L2_PDE0__SHIFT                                                     0x13
#define VM_INVALIDATE_ENG9_REQ__INVALIDATE_L2_PDE1__SHIFT                                                     0x14
#define VM_INVALIDATE_ENG9_REQ__INVALIDATE_L2_PDE2__SHIFT                                                     0x15
#define VM_INVALIDATE_ENG9_REQ__INVALIDATE_L1_PTES__SHIFT                                                     0x16
#define VM_INVALIDATE_ENG9_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT                                     0x17
#define VM_INVALIDATE_ENG9_REQ__PER_VMID_INVALIDATE_REQ_MASK                                                  0x0000FFFFL
#define VM_INVALIDATE_ENG9_REQ__FLUSH_TYPE_MASK                                                               0x00030000L
#define VM_INVALIDATE_ENG9_REQ__INVALIDATE_L2_PTES_MASK                                                       0x00040000L
#define VM_INVALIDATE_ENG9_REQ__INVALIDATE_L2_PDE0_MASK                                                       0x00080000L
#define VM_INVALIDATE_ENG9_REQ__INVALIDATE_L2_PDE1_MASK                                                       0x00100000L
#define VM_INVALIDATE_ENG9_REQ__INVALIDATE_L2_PDE2_MASK                                                       0x00200000L
#define VM_INVALIDATE_ENG9_REQ__INVALIDATE_L1_PTES_MASK                                                       0x00400000L
#define VM_INVALIDATE_ENG9_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK                                       0x00800000L
//VM_INVALIDATE_ENG10_REQ
#define VM_INVALIDATE_ENG10_REQ__PER_VMID_INVALIDATE_REQ__SHIFT                                               0x0
#define VM_INVALIDATE_ENG10_REQ__FLUSH_TYPE__SHIFT                                                            0x10
#define VM_INVALIDATE_ENG10_REQ__INVALIDATE_L2_PTES__SHIFT                                                    0x12
#define VM_INVALIDATE_ENG10_REQ__INVALIDATE_L2_PDE0__SHIFT                                                    0x13
#define VM_INVALIDATE_ENG10_REQ__INVALIDATE_L2_PDE1__SHIFT                                                    0x14
#define VM_INVALIDATE_ENG10_REQ__INVALIDATE_L2_PDE2__SHIFT                                                    0x15
#define VM_INVALIDATE_ENG10_REQ__INVALIDATE_L1_PTES__SHIFT                                                    0x16
#define VM_INVALIDATE_ENG10_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT                                    0x17
#define VM_INVALIDATE_ENG10_REQ__PER_VMID_INVALIDATE_REQ_MASK                                                 0x0000FFFFL
#define VM_INVALIDATE_ENG10_REQ__FLUSH_TYPE_MASK                                                              0x00030000L
#define VM_INVALIDATE_ENG10_REQ__INVALIDATE_L2_PTES_MASK                                                      0x00040000L
#define VM_INVALIDATE_ENG10_REQ__INVALIDATE_L2_PDE0_MASK                                                      0x00080000L
#define VM_INVALIDATE_ENG10_REQ__INVALIDATE_L2_PDE1_MASK                                                      0x00100000L
#define VM_INVALIDATE_ENG10_REQ__INVALIDATE_L2_PDE2_MASK                                                      0x00200000L
#define VM_INVALIDATE_ENG10_REQ__INVALIDATE_L1_PTES_MASK                                                      0x00400000L
#define VM_INVALIDATE_ENG10_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK                                      0x00800000L
//VM_INVALIDATE_ENG11_REQ
#define VM_INVALIDATE_ENG11_REQ__PER_VMID_INVALIDATE_REQ__SHIFT                                               0x0
#define VM_INVALIDATE_ENG11_REQ__FLUSH_TYPE__SHIFT                                                            0x10
#define VM_INVALIDATE_ENG11_REQ__INVALIDATE_L2_PTES__SHIFT                                                    0x12
#define VM_INVALIDATE_ENG11_REQ__INVALIDATE_L2_PDE0__SHIFT                                                    0x13
#define VM_INVALIDATE_ENG11_REQ__INVALIDATE_L2_PDE1__SHIFT                                                    0x14
#define VM_INVALIDATE_ENG11_REQ__INVALIDATE_L2_PDE2__SHIFT                                                    0x15
#define VM_INVALIDATE_ENG11_REQ__INVALIDATE_L1_PTES__SHIFT                                                    0x16
#define VM_INVALIDATE_ENG11_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT                                    0x17
#define VM_INVALIDATE_ENG11_REQ__PER_VMID_INVALIDATE_REQ_MASK                                                 0x0000FFFFL
#define VM_INVALIDATE_ENG11_REQ__FLUSH_TYPE_MASK                                                              0x00030000L
#define VM_INVALIDATE_ENG11_REQ__INVALIDATE_L2_PTES_MASK                                                      0x00040000L
#define VM_INVALIDATE_ENG11_REQ__INVALIDATE_L2_PDE0_MASK                                                      0x00080000L
#define VM_INVALIDATE_ENG11_REQ__INVALIDATE_L2_PDE1_MASK                                                      0x00100000L
#define VM_INVALIDATE_ENG11_REQ__INVALIDATE_L2_PDE2_MASK                                                      0x00200000L
#define VM_INVALIDATE_ENG11_REQ__INVALIDATE_L1_PTES_MASK                                                      0x00400000L
#define VM_INVALIDATE_ENG11_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK                                      0x00800000L
//VM_INVALIDATE_ENG12_REQ
#define VM_INVALIDATE_ENG12_REQ__PER_VMID_INVALIDATE_REQ__SHIFT                                               0x0
#define VM_INVALIDATE_ENG12_REQ__FLUSH_TYPE__SHIFT                                                            0x10
#define VM_INVALIDATE_ENG12_REQ__INVALIDATE_L2_PTES__SHIFT                                                    0x12
#define VM_INVALIDATE_ENG12_REQ__INVALIDATE_L2_PDE0__SHIFT                                                    0x13
#define VM_INVALIDATE_ENG12_REQ__INVALIDATE_L2_PDE1__SHIFT                                                    0x14
#define VM_INVALIDATE_ENG12_REQ__INVALIDATE_L2_PDE2__SHIFT                                                    0x15
#define VM_INVALIDATE_ENG12_REQ__INVALIDATE_L1_PTES__SHIFT                                                    0x16
#define VM_INVALIDATE_ENG12_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT                                    0x17
#define VM_INVALIDATE_ENG12_REQ__PER_VMID_INVALIDATE_REQ_MASK                                                 0x0000FFFFL
#define VM_INVALIDATE_ENG12_REQ__FLUSH_TYPE_MASK                                                              0x00030000L
#define VM_INVALIDATE_ENG12_REQ__INVALIDATE_L2_PTES_MASK                                                      0x00040000L
#define VM_INVALIDATE_ENG12_REQ__INVALIDATE_L2_PDE0_MASK                                                      0x00080000L
#define VM_INVALIDATE_ENG12_REQ__INVALIDATE_L2_PDE1_MASK                                                      0x00100000L
#define VM_INVALIDATE_ENG12_REQ__INVALIDATE_L2_PDE2_MASK                                                      0x00200000L
#define VM_INVALIDATE_ENG12_REQ__INVALIDATE_L1_PTES_MASK                                                      0x00400000L
#define VM_INVALIDATE_ENG12_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK                                      0x00800000L
//VM_INVALIDATE_ENG13_REQ
#define VM_INVALIDATE_ENG13_REQ__PER_VMID_INVALIDATE_REQ__SHIFT                                               0x0
#define VM_INVALIDATE_ENG13_REQ__FLUSH_TYPE__SHIFT                                                            0x10
#define VM_INVALIDATE_ENG13_REQ__INVALIDATE_L2_PTES__SHIFT                                                    0x12
#define VM_INVALIDATE_ENG13_REQ__INVALIDATE_L2_PDE0__SHIFT                                                    0x13
#define VM_INVALIDATE_ENG13_REQ__INVALIDATE_L2_PDE1__SHIFT                                                    0x14
#define VM_INVALIDATE_ENG13_REQ__INVALIDATE_L2_PDE2__SHIFT                                                    0x15
#define VM_INVALIDATE_ENG13_REQ__INVALIDATE_L1_PTES__SHIFT                                                    0x16
#define VM_INVALIDATE_ENG13_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT                                    0x17
#define VM_INVALIDATE_ENG13_REQ__PER_VMID_INVALIDATE_REQ_MASK                                                 0x0000FFFFL
#define VM_INVALIDATE_ENG13_REQ__FLUSH_TYPE_MASK                                                              0x00030000L
#define VM_INVALIDATE_ENG13_REQ__INVALIDATE_L2_PTES_MASK                                                      0x00040000L
#define VM_INVALIDATE_ENG13_REQ__INVALIDATE_L2_PDE0_MASK                                                      0x00080000L
#define VM_INVALIDATE_ENG13_REQ__INVALIDATE_L2_PDE1_MASK                                                      0x00100000L
#define VM_INVALIDATE_ENG13_REQ__INVALIDATE_L2_PDE2_MASK                                                      0x00200000L
#define VM_INVALIDATE_ENG13_REQ__INVALIDATE_L1_PTES_MASK                                                      0x00400000L
#define VM_INVALIDATE_ENG13_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK                                      0x00800000L
//VM_INVALIDATE_ENG14_REQ
#define VM_INVALIDATE_ENG14_REQ__PER_VMID_INVALIDATE_REQ__SHIFT                                               0x0
#define VM_INVALIDATE_ENG14_REQ__FLUSH_TYPE__SHIFT                                                            0x10
#define VM_INVALIDATE_ENG14_REQ__INVALIDATE_L2_PTES__SHIFT                                                    0x12
#define VM_INVALIDATE_ENG14_REQ__INVALIDATE_L2_PDE0__SHIFT                                                    0x13
#define VM_INVALIDATE_ENG14_REQ__INVALIDATE_L2_PDE1__SHIFT                                                    0x14
#define VM_INVALIDATE_ENG14_REQ__INVALIDATE_L2_PDE2__SHIFT                                                    0x15
#define VM_INVALIDATE_ENG14_REQ__INVALIDATE_L1_PTES__SHIFT                                                    0x16
#define VM_INVALIDATE_ENG14_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT                                    0x17
#define VM_INVALIDATE_ENG14_REQ__PER_VMID_INVALIDATE_REQ_MASK                                                 0x0000FFFFL
#define VM_INVALIDATE_ENG14_REQ__FLUSH_TYPE_MASK                                                              0x00030000L
#define VM_INVALIDATE_ENG14_REQ__INVALIDATE_L2_PTES_MASK                                                      0x00040000L
#define VM_INVALIDATE_ENG14_REQ__INVALIDATE_L2_PDE0_MASK                                                      0x00080000L
#define VM_INVALIDATE_ENG14_REQ__INVALIDATE_L2_PDE1_MASK                                                      0x00100000L
#define VM_INVALIDATE_ENG14_REQ__INVALIDATE_L2_PDE2_MASK                                                      0x00200000L
#define VM_INVALIDATE_ENG14_REQ__INVALIDATE_L1_PTES_MASK                                                      0x00400000L
#define VM_INVALIDATE_ENG14_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK                                      0x00800000L
//VM_INVALIDATE_ENG15_REQ
#define VM_INVALIDATE_ENG15_REQ__PER_VMID_INVALIDATE_REQ__SHIFT                                               0x0
#define VM_INVALIDATE_ENG15_REQ__FLUSH_TYPE__SHIFT                                                            0x10
#define VM_INVALIDATE_ENG15_REQ__INVALIDATE_L2_PTES__SHIFT                                                    0x12
#define VM_INVALIDATE_ENG15_REQ__INVALIDATE_L2_PDE0__SHIFT                                                    0x13
#define VM_INVALIDATE_ENG15_REQ__INVALIDATE_L2_PDE1__SHIFT                                                    0x14
#define VM_INVALIDATE_ENG15_REQ__INVALIDATE_L2_PDE2__SHIFT                                                    0x15
#define VM_INVALIDATE_ENG15_REQ__INVALIDATE_L1_PTES__SHIFT                                                    0x16
#define VM_INVALIDATE_ENG15_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT                                    0x17
#define VM_INVALIDATE_ENG15_REQ__PER_VMID_INVALIDATE_REQ_MASK                                                 0x0000FFFFL
#define VM_INVALIDATE_ENG15_REQ__FLUSH_TYPE_MASK                                                              0x00030000L
#define VM_INVALIDATE_ENG15_REQ__INVALIDATE_L2_PTES_MASK                                                      0x00040000L
#define VM_INVALIDATE_ENG15_REQ__INVALIDATE_L2_PDE0_MASK                                                      0x00080000L
#define VM_INVALIDATE_ENG15_REQ__INVALIDATE_L2_PDE1_MASK                                                      0x00100000L
#define VM_INVALIDATE_ENG15_REQ__INVALIDATE_L2_PDE2_MASK                                                      0x00200000L
#define VM_INVALIDATE_ENG15_REQ__INVALIDATE_L1_PTES_MASK                                                      0x00400000L
#define VM_INVALIDATE_ENG15_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK                                      0x00800000L
//VM_INVALIDATE_ENG16_REQ
#define VM_INVALIDATE_ENG16_REQ__PER_VMID_INVALIDATE_REQ__SHIFT                                               0x0
#define VM_INVALIDATE_ENG16_REQ__FLUSH_TYPE__SHIFT                                                            0x10
#define VM_INVALIDATE_ENG16_REQ__INVALIDATE_L2_PTES__SHIFT                                                    0x12
#define VM_INVALIDATE_ENG16_REQ__INVALIDATE_L2_PDE0__SHIFT                                                    0x13
#define VM_INVALIDATE_ENG16_REQ__INVALIDATE_L2_PDE1__SHIFT                                                    0x14
#define VM_INVALIDATE_ENG16_REQ__INVALIDATE_L2_PDE2__SHIFT                                                    0x15
#define VM_INVALIDATE_ENG16_REQ__INVALIDATE_L1_PTES__SHIFT                                                    0x16
#define VM_INVALIDATE_ENG16_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT                                    0x17
#define VM_INVALIDATE_ENG16_REQ__PER_VMID_INVALIDATE_REQ_MASK                                                 0x0000FFFFL
#define VM_INVALIDATE_ENG16_REQ__FLUSH_TYPE_MASK                                                              0x00030000L
#define VM_INVALIDATE_ENG16_REQ__INVALIDATE_L2_PTES_MASK                                                      0x00040000L
#define VM_INVALIDATE_ENG16_REQ__INVALIDATE_L2_PDE0_MASK                                                      0x00080000L
#define VM_INVALIDATE_ENG16_REQ__INVALIDATE_L2_PDE1_MASK                                                      0x00100000L
#define VM_INVALIDATE_ENG16_REQ__INVALIDATE_L2_PDE2_MASK                                                      0x00200000L
#define VM_INVALIDATE_ENG16_REQ__INVALIDATE_L1_PTES_MASK                                                      0x00400000L
#define VM_INVALIDATE_ENG16_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK                                      0x00800000L
//VM_INVALIDATE_ENG17_REQ
#define VM_INVALIDATE_ENG17_REQ__PER_VMID_INVALIDATE_REQ__SHIFT                                               0x0
#define VM_INVALIDATE_ENG17_REQ__FLUSH_TYPE__SHIFT                                                            0x10
#define VM_INVALIDATE_ENG17_REQ__INVALIDATE_L2_PTES__SHIFT                                                    0x12
#define VM_INVALIDATE_ENG17_REQ__INVALIDATE_L2_PDE0__SHIFT                                                    0x13
#define VM_INVALIDATE_ENG17_REQ__INVALIDATE_L2_PDE1__SHIFT                                                    0x14
#define VM_INVALIDATE_ENG17_REQ__INVALIDATE_L2_PDE2__SHIFT                                                    0x15
#define VM_INVALIDATE_ENG17_REQ__INVALIDATE_L1_PTES__SHIFT                                                    0x16
#define VM_INVALIDATE_ENG17_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT                                    0x17
#define VM_INVALIDATE_ENG17_REQ__PER_VMID_INVALIDATE_REQ_MASK                                                 0x0000FFFFL
#define VM_INVALIDATE_ENG17_REQ__FLUSH_TYPE_MASK                                                              0x00030000L
#define VM_INVALIDATE_ENG17_REQ__INVALIDATE_L2_PTES_MASK                                                      0x00040000L
#define VM_INVALIDATE_ENG17_REQ__INVALIDATE_L2_PDE0_MASK                                                      0x00080000L
#define VM_INVALIDATE_ENG17_REQ__INVALIDATE_L2_PDE1_MASK                                                      0x00100000L
#define VM_INVALIDATE_ENG17_REQ__INVALIDATE_L2_PDE2_MASK                                                      0x00200000L
#define VM_INVALIDATE_ENG17_REQ__INVALIDATE_L1_PTES_MASK                                                      0x00400000L
#define VM_INVALIDATE_ENG17_REQ__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK                                      0x00800000L
//VM_INVALIDATE_ENG0_ACK
#define VM_INVALIDATE_ENG0_ACK__PER_VMID_INVALIDATE_ACK__SHIFT                                                0x0
#define VM_INVALIDATE_ENG0_ACK__SEMAPHORE__SHIFT                                                              0x10
#define VM_INVALIDATE_ENG0_ACK__PER_VMID_INVALIDATE_ACK_MASK                                                  0x0000FFFFL
#define VM_INVALIDATE_ENG0_ACK__SEMAPHORE_MASK                                                                0x00010000L
//VM_INVALIDATE_ENG1_ACK
#define VM_INVALIDATE_ENG1_ACK__PER_VMID_INVALIDATE_ACK__SHIFT                                                0x0
#define VM_INVALIDATE_ENG1_ACK__SEMAPHORE__SHIFT                                                              0x10
#define VM_INVALIDATE_ENG1_ACK__PER_VMID_INVALIDATE_ACK_MASK                                                  0x0000FFFFL
#define VM_INVALIDATE_ENG1_ACK__SEMAPHORE_MASK                                                                0x00010000L
//VM_INVALIDATE_ENG2_ACK
#define VM_INVALIDATE_ENG2_ACK__PER_VMID_INVALIDATE_ACK__SHIFT                                                0x0
#define VM_INVALIDATE_ENG2_ACK__SEMAPHORE__SHIFT                                                              0x10
#define VM_INVALIDATE_ENG2_ACK__PER_VMID_INVALIDATE_ACK_MASK                                                  0x0000FFFFL
#define VM_INVALIDATE_ENG2_ACK__SEMAPHORE_MASK                                                                0x00010000L
//VM_INVALIDATE_ENG3_ACK
#define VM_INVALIDATE_ENG3_ACK__PER_VMID_INVALIDATE_ACK__SHIFT                                                0x0
#define VM_INVALIDATE_ENG3_ACK__SEMAPHORE__SHIFT                                                              0x10
#define VM_INVALIDATE_ENG3_ACK__PER_VMID_INVALIDATE_ACK_MASK                                                  0x0000FFFFL
#define VM_INVALIDATE_ENG3_ACK__SEMAPHORE_MASK                                                                0x00010000L
//VM_INVALIDATE_ENG4_ACK
#define VM_INVALIDATE_ENG4_ACK__PER_VMID_INVALIDATE_ACK__SHIFT                                                0x0
#define VM_INVALIDATE_ENG4_ACK__SEMAPHORE__SHIFT                                                              0x10
#define VM_INVALIDATE_ENG4_ACK__PER_VMID_INVALIDATE_ACK_MASK                                                  0x0000FFFFL
#define VM_INVALIDATE_ENG4_ACK__SEMAPHORE_MASK                                                                0x00010000L
//VM_INVALIDATE_ENG5_ACK
#define VM_INVALIDATE_ENG5_ACK__PER_VMID_INVALIDATE_ACK__SHIFT                                                0x0
#define VM_INVALIDATE_ENG5_ACK__SEMAPHORE__SHIFT                                                              0x10
#define VM_INVALIDATE_ENG5_ACK__PER_VMID_INVALIDATE_ACK_MASK                                                  0x0000FFFFL
#define VM_INVALIDATE_ENG5_ACK__SEMAPHORE_MASK                                                                0x00010000L
//VM_INVALIDATE_ENG6_ACK
#define VM_INVALIDATE_ENG6_ACK__PER_VMID_INVALIDATE_ACK__SHIFT                                                0x0
#define VM_INVALIDATE_ENG6_ACK__SEMAPHORE__SHIFT                                                              0x10
#define VM_INVALIDATE_ENG6_ACK__PER_VMID_INVALIDATE_ACK_MASK                                                  0x0000FFFFL
#define VM_INVALIDATE_ENG6_ACK__SEMAPHORE_MASK                                                                0x00010000L
//VM_INVALIDATE_ENG7_ACK
#define VM_INVALIDATE_ENG7_ACK__PER_VMID_INVALIDATE_ACK__SHIFT                                                0x0
#define VM_INVALIDATE_ENG7_ACK__SEMAPHORE__SHIFT                                                              0x10
#define VM_INVALIDATE_ENG7_ACK__PER_VMID_INVALIDATE_ACK_MASK                                                  0x0000FFFFL
#define VM_INVALIDATE_ENG7_ACK__SEMAPHORE_MASK                                                                0x00010000L
//VM_INVALIDATE_ENG8_ACK
#define VM_INVALIDATE_ENG8_ACK__PER_VMID_INVALIDATE_ACK__SHIFT                                                0x0
#define VM_INVALIDATE_ENG8_ACK__SEMAPHORE__SHIFT                                                              0x10
#define VM_INVALIDATE_ENG8_ACK__PER_VMID_INVALIDATE_ACK_MASK                                                  0x0000FFFFL
#define VM_INVALIDATE_ENG8_ACK__SEMAPHORE_MASK                                                                0x00010000L
//VM_INVALIDATE_ENG9_ACK
#define VM_INVALIDATE_ENG9_ACK__PER_VMID_INVALIDATE_ACK__SHIFT                                                0x0
#define VM_INVALIDATE_ENG9_ACK__SEMAPHORE__SHIFT                                                              0x10
#define VM_INVALIDATE_ENG9_ACK__PER_VMID_INVALIDATE_ACK_MASK                                                  0x0000FFFFL
#define VM_INVALIDATE_ENG9_ACK__SEMAPHORE_MASK                                                                0x00010000L
//VM_INVALIDATE_ENG10_ACK
#define VM_INVALIDATE_ENG10_ACK__PER_VMID_INVALIDATE_ACK__SHIFT                                               0x0
#define VM_INVALIDATE_ENG10_ACK__SEMAPHORE__SHIFT                                                             0x10
#define VM_INVALIDATE_ENG10_ACK__PER_VMID_INVALIDATE_ACK_MASK                                                 0x0000FFFFL
#define VM_INVALIDATE_ENG10_ACK__SEMAPHORE_MASK                                                               0x00010000L
//VM_INVALIDATE_ENG11_ACK
#define VM_INVALIDATE_ENG11_ACK__PER_VMID_INVALIDATE_ACK__SHIFT                                               0x0
#define VM_INVALIDATE_ENG11_ACK__SEMAPHORE__SHIFT                                                             0x10
#define VM_INVALIDATE_ENG11_ACK__PER_VMID_INVALIDATE_ACK_MASK                                                 0x0000FFFFL
#define VM_INVALIDATE_ENG11_ACK__SEMAPHORE_MASK                                                               0x00010000L
//VM_INVALIDATE_ENG12_ACK
#define VM_INVALIDATE_ENG12_ACK__PER_VMID_INVALIDATE_ACK__SHIFT                                               0x0
#define VM_INVALIDATE_ENG12_ACK__SEMAPHORE__SHIFT                                                             0x10
#define VM_INVALIDATE_ENG12_ACK__PER_VMID_INVALIDATE_ACK_MASK                                                 0x0000FFFFL
#define VM_INVALIDATE_ENG12_ACK__SEMAPHORE_MASK                                                               0x00010000L
//VM_INVALIDATE_ENG13_ACK
#define VM_INVALIDATE_ENG13_ACK__PER_VMID_INVALIDATE_ACK__SHIFT                                               0x0
#define VM_INVALIDATE_ENG13_ACK__SEMAPHORE__SHIFT                                                             0x10
#define VM_INVALIDATE_ENG13_ACK__PER_VMID_INVALIDATE_ACK_MASK                                                 0x0000FFFFL
#define VM_INVALIDATE_ENG13_ACK__SEMAPHORE_MASK                                                               0x00010000L
//VM_INVALIDATE_ENG14_ACK
#define VM_INVALIDATE_ENG14_ACK__PER_VMID_INVALIDATE_ACK__SHIFT                                               0x0
#define VM_INVALIDATE_ENG14_ACK__SEMAPHORE__SHIFT                                                             0x10
#define VM_INVALIDATE_ENG14_ACK__PER_VMID_INVALIDATE_ACK_MASK                                                 0x0000FFFFL
#define VM_INVALIDATE_ENG14_ACK__SEMAPHORE_MASK                                                               0x00010000L
//VM_INVALIDATE_ENG15_ACK
#define VM_INVALIDATE_ENG15_ACK__PER_VMID_INVALIDATE_ACK__SHIFT                                               0x0
#define VM_INVALIDATE_ENG15_ACK__SEMAPHORE__SHIFT                                                             0x10
#define VM_INVALIDATE_ENG15_ACK__PER_VMID_INVALIDATE_ACK_MASK                                                 0x0000FFFFL
#define VM_INVALIDATE_ENG15_ACK__SEMAPHORE_MASK                                                               0x00010000L
//VM_INVALIDATE_ENG16_ACK
#define VM_INVALIDATE_ENG16_ACK__PER_VMID_INVALIDATE_ACK__SHIFT                                               0x0
#define VM_INVALIDATE_ENG16_ACK__SEMAPHORE__SHIFT                                                             0x10
#define VM_INVALIDATE_ENG16_ACK__PER_VMID_INVALIDATE_ACK_MASK                                                 0x0000FFFFL
#define VM_INVALIDATE_ENG16_ACK__SEMAPHORE_MASK                                                               0x00010000L
//VM_INVALIDATE_ENG17_ACK
#define VM_INVALIDATE_ENG17_ACK__PER_VMID_INVALIDATE_ACK__SHIFT                                               0x0
#define VM_INVALIDATE_ENG17_ACK__SEMAPHORE__SHIFT                                                             0x10
#define VM_INVALIDATE_ENG17_ACK__PER_VMID_INVALIDATE_ACK_MASK                                                 0x0000FFFFL
#define VM_INVALIDATE_ENG17_ACK__SEMAPHORE_MASK                                                               0x00010000L
//VM_INVALIDATE_ENG0_ADDR_RANGE_LO32
#define VM_INVALIDATE_ENG0_ADDR_RANGE_LO32__S_BIT__SHIFT                                                      0x0
#define VM_INVALIDATE_ENG0_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31__SHIFT                                  0x1
#define VM_INVALIDATE_ENG0_ADDR_RANGE_LO32__S_BIT_MASK                                                        0x00000001L
#define VM_INVALIDATE_ENG0_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31_MASK                                    0xFFFFFFFEL
//VM_INVALIDATE_ENG0_ADDR_RANGE_HI32
#define VM_INVALIDATE_ENG0_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5__SHIFT                                   0x0
#define VM_INVALIDATE_ENG0_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5_MASK                                     0x0000001FL
//VM_INVALIDATE_ENG1_ADDR_RANGE_LO32
#define VM_INVALIDATE_ENG1_ADDR_RANGE_LO32__S_BIT__SHIFT                                                      0x0
#define VM_INVALIDATE_ENG1_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31__SHIFT                                  0x1
#define VM_INVALIDATE_ENG1_ADDR_RANGE_LO32__S_BIT_MASK                                                        0x00000001L
#define VM_INVALIDATE_ENG1_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31_MASK                                    0xFFFFFFFEL
//VM_INVALIDATE_ENG1_ADDR_RANGE_HI32
#define VM_INVALIDATE_ENG1_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5__SHIFT                                   0x0
#define VM_INVALIDATE_ENG1_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5_MASK                                     0x0000001FL
//VM_INVALIDATE_ENG2_ADDR_RANGE_LO32
#define VM_INVALIDATE_ENG2_ADDR_RANGE_LO32__S_BIT__SHIFT                                                      0x0
#define VM_INVALIDATE_ENG2_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31__SHIFT                                  0x1
#define VM_INVALIDATE_ENG2_ADDR_RANGE_LO32__S_BIT_MASK                                                        0x00000001L
#define VM_INVALIDATE_ENG2_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31_MASK                                    0xFFFFFFFEL
//VM_INVALIDATE_ENG2_ADDR_RANGE_HI32
#define VM_INVALIDATE_ENG2_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5__SHIFT                                   0x0
#define VM_INVALIDATE_ENG2_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5_MASK                                     0x0000001FL
//VM_INVALIDATE_ENG3_ADDR_RANGE_LO32
#define VM_INVALIDATE_ENG3_ADDR_RANGE_LO32__S_BIT__SHIFT                                                      0x0
#define VM_INVALIDATE_ENG3_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31__SHIFT                                  0x1
#define VM_INVALIDATE_ENG3_ADDR_RANGE_LO32__S_BIT_MASK                                                        0x00000001L
#define VM_INVALIDATE_ENG3_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31_MASK                                    0xFFFFFFFEL
//VM_INVALIDATE_ENG3_ADDR_RANGE_HI32
#define VM_INVALIDATE_ENG3_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5__SHIFT                                   0x0
#define VM_INVALIDATE_ENG3_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5_MASK                                     0x0000001FL
//VM_INVALIDATE_ENG4_ADDR_RANGE_LO32
#define VM_INVALIDATE_ENG4_ADDR_RANGE_LO32__S_BIT__SHIFT                                                      0x0
#define VM_INVALIDATE_ENG4_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31__SHIFT                                  0x1
#define VM_INVALIDATE_ENG4_ADDR_RANGE_LO32__S_BIT_MASK                                                        0x00000001L
#define VM_INVALIDATE_ENG4_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31_MASK                                    0xFFFFFFFEL
//VM_INVALIDATE_ENG4_ADDR_RANGE_HI32
#define VM_INVALIDATE_ENG4_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5__SHIFT                                   0x0
#define VM_INVALIDATE_ENG4_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5_MASK                                     0x0000001FL
//VM_INVALIDATE_ENG5_ADDR_RANGE_LO32
#define VM_INVALIDATE_ENG5_ADDR_RANGE_LO32__S_BIT__SHIFT                                                      0x0
#define VM_INVALIDATE_ENG5_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31__SHIFT                                  0x1
#define VM_INVALIDATE_ENG5_ADDR_RANGE_LO32__S_BIT_MASK                                                        0x00000001L
#define VM_INVALIDATE_ENG5_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31_MASK                                    0xFFFFFFFEL
//VM_INVALIDATE_ENG5_ADDR_RANGE_HI32
#define VM_INVALIDATE_ENG5_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5__SHIFT                                   0x0
#define VM_INVALIDATE_ENG5_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5_MASK                                     0x0000001FL
//VM_INVALIDATE_ENG6_ADDR_RANGE_LO32
#define VM_INVALIDATE_ENG6_ADDR_RANGE_LO32__S_BIT__SHIFT                                                      0x0
#define VM_INVALIDATE_ENG6_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31__SHIFT                                  0x1
#define VM_INVALIDATE_ENG6_ADDR_RANGE_LO32__S_BIT_MASK                                                        0x00000001L
#define VM_INVALIDATE_ENG6_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31_MASK                                    0xFFFFFFFEL
//VM_INVALIDATE_ENG6_ADDR_RANGE_HI32
#define VM_INVALIDATE_ENG6_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5__SHIFT                                   0x0
#define VM_INVALIDATE_ENG6_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5_MASK                                     0x0000001FL
//VM_INVALIDATE_ENG7_ADDR_RANGE_LO32
#define VM_INVALIDATE_ENG7_ADDR_RANGE_LO32__S_BIT__SHIFT                                                      0x0
#define VM_INVALIDATE_ENG7_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31__SHIFT                                  0x1
#define VM_INVALIDATE_ENG7_ADDR_RANGE_LO32__S_BIT_MASK                                                        0x00000001L
#define VM_INVALIDATE_ENG7_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31_MASK                                    0xFFFFFFFEL
//VM_INVALIDATE_ENG7_ADDR_RANGE_HI32
#define VM_INVALIDATE_ENG7_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5__SHIFT                                   0x0
#define VM_INVALIDATE_ENG7_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5_MASK                                     0x0000001FL
//VM_INVALIDATE_ENG8_ADDR_RANGE_LO32
#define VM_INVALIDATE_ENG8_ADDR_RANGE_LO32__S_BIT__SHIFT                                                      0x0
#define VM_INVALIDATE_ENG8_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31__SHIFT                                  0x1
#define VM_INVALIDATE_ENG8_ADDR_RANGE_LO32__S_BIT_MASK                                                        0x00000001L
#define VM_INVALIDATE_ENG8_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31_MASK                                    0xFFFFFFFEL
//VM_INVALIDATE_ENG8_ADDR_RANGE_HI32
#define VM_INVALIDATE_ENG8_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5__SHIFT                                   0x0
#define VM_INVALIDATE_ENG8_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5_MASK                                     0x0000001FL
//VM_INVALIDATE_ENG9_ADDR_RANGE_LO32
#define VM_INVALIDATE_ENG9_ADDR_RANGE_LO32__S_BIT__SHIFT                                                      0x0
#define VM_INVALIDATE_ENG9_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31__SHIFT                                  0x1
#define VM_INVALIDATE_ENG9_ADDR_RANGE_LO32__S_BIT_MASK                                                        0x00000001L
#define VM_INVALIDATE_ENG9_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31_MASK                                    0xFFFFFFFEL
//VM_INVALIDATE_ENG9_ADDR_RANGE_HI32
#define VM_INVALIDATE_ENG9_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5__SHIFT                                   0x0
#define VM_INVALIDATE_ENG9_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5_MASK                                     0x0000001FL
//VM_INVALIDATE_ENG10_ADDR_RANGE_LO32
#define VM_INVALIDATE_ENG10_ADDR_RANGE_LO32__S_BIT__SHIFT                                                     0x0
#define VM_INVALIDATE_ENG10_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31__SHIFT                                 0x1
#define VM_INVALIDATE_ENG10_ADDR_RANGE_LO32__S_BIT_MASK                                                       0x00000001L
#define VM_INVALIDATE_ENG10_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31_MASK                                   0xFFFFFFFEL
//VM_INVALIDATE_ENG10_ADDR_RANGE_HI32
#define VM_INVALIDATE_ENG10_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5__SHIFT                                  0x0
#define VM_INVALIDATE_ENG10_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5_MASK                                    0x0000001FL
//VM_INVALIDATE_ENG11_ADDR_RANGE_LO32
#define VM_INVALIDATE_ENG11_ADDR_RANGE_LO32__S_BIT__SHIFT                                                     0x0
#define VM_INVALIDATE_ENG11_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31__SHIFT                                 0x1
#define VM_INVALIDATE_ENG11_ADDR_RANGE_LO32__S_BIT_MASK                                                       0x00000001L
#define VM_INVALIDATE_ENG11_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31_MASK                                   0xFFFFFFFEL
//VM_INVALIDATE_ENG11_ADDR_RANGE_HI32
#define VM_INVALIDATE_ENG11_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5__SHIFT                                  0x0
#define VM_INVALIDATE_ENG11_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5_MASK                                    0x0000001FL
//VM_INVALIDATE_ENG12_ADDR_RANGE_LO32
#define VM_INVALIDATE_ENG12_ADDR_RANGE_LO32__S_BIT__SHIFT                                                     0x0
#define VM_INVALIDATE_ENG12_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31__SHIFT                                 0x1
#define VM_INVALIDATE_ENG12_ADDR_RANGE_LO32__S_BIT_MASK                                                       0x00000001L
#define VM_INVALIDATE_ENG12_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31_MASK                                   0xFFFFFFFEL
//VM_INVALIDATE_ENG12_ADDR_RANGE_HI32
#define VM_INVALIDATE_ENG12_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5__SHIFT                                  0x0
#define VM_INVALIDATE_ENG12_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5_MASK                                    0x0000001FL
//VM_INVALIDATE_ENG13_ADDR_RANGE_LO32
#define VM_INVALIDATE_ENG13_ADDR_RANGE_LO32__S_BIT__SHIFT                                                     0x0
#define VM_INVALIDATE_ENG13_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31__SHIFT                                 0x1
#define VM_INVALIDATE_ENG13_ADDR_RANGE_LO32__S_BIT_MASK                                                       0x00000001L
#define VM_INVALIDATE_ENG13_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31_MASK                                   0xFFFFFFFEL
//VM_INVALIDATE_ENG13_ADDR_RANGE_HI32
#define VM_INVALIDATE_ENG13_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5__SHIFT                                  0x0
#define VM_INVALIDATE_ENG13_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5_MASK                                    0x0000001FL
//VM_INVALIDATE_ENG14_ADDR_RANGE_LO32
#define VM_INVALIDATE_ENG14_ADDR_RANGE_LO32__S_BIT__SHIFT                                                     0x0
#define VM_INVALIDATE_ENG14_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31__SHIFT                                 0x1
#define VM_INVALIDATE_ENG14_ADDR_RANGE_LO32__S_BIT_MASK                                                       0x00000001L
#define VM_INVALIDATE_ENG14_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31_MASK                                   0xFFFFFFFEL
//VM_INVALIDATE_ENG14_ADDR_RANGE_HI32
#define VM_INVALIDATE_ENG14_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5__SHIFT                                  0x0
#define VM_INVALIDATE_ENG14_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5_MASK                                    0x0000001FL
//VM_INVALIDATE_ENG15_ADDR_RANGE_LO32
#define VM_INVALIDATE_ENG15_ADDR_RANGE_LO32__S_BIT__SHIFT                                                     0x0
#define VM_INVALIDATE_ENG15_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31__SHIFT                                 0x1
#define VM_INVALIDATE_ENG15_ADDR_RANGE_LO32__S_BIT_MASK                                                       0x00000001L
#define VM_INVALIDATE_ENG15_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31_MASK                                   0xFFFFFFFEL
//VM_INVALIDATE_ENG15_ADDR_RANGE_HI32
#define VM_INVALIDATE_ENG15_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5__SHIFT                                  0x0
#define VM_INVALIDATE_ENG15_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5_MASK                                    0x0000001FL
//VM_INVALIDATE_ENG16_ADDR_RANGE_LO32
#define VM_INVALIDATE_ENG16_ADDR_RANGE_LO32__S_BIT__SHIFT                                                     0x0
#define VM_INVALIDATE_ENG16_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31__SHIFT                                 0x1
#define VM_INVALIDATE_ENG16_ADDR_RANGE_LO32__S_BIT_MASK                                                       0x00000001L
#define VM_INVALIDATE_ENG16_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31_MASK                                   0xFFFFFFFEL
//VM_INVALIDATE_ENG16_ADDR_RANGE_HI32
#define VM_INVALIDATE_ENG16_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5__SHIFT                                  0x0
#define VM_INVALIDATE_ENG16_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5_MASK                                    0x0000001FL
//VM_INVALIDATE_ENG17_ADDR_RANGE_LO32
#define VM_INVALIDATE_ENG17_ADDR_RANGE_LO32__S_BIT__SHIFT                                                     0x0
#define VM_INVALIDATE_ENG17_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31__SHIFT                                 0x1
#define VM_INVALIDATE_ENG17_ADDR_RANGE_LO32__S_BIT_MASK                                                       0x00000001L
#define VM_INVALIDATE_ENG17_ADDR_RANGE_LO32__LOGI_PAGE_ADDR_RANGE_LO31_MASK                                   0xFFFFFFFEL
//VM_INVALIDATE_ENG17_ADDR_RANGE_HI32
#define VM_INVALIDATE_ENG17_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5__SHIFT                                  0x0
#define VM_INVALIDATE_ENG17_ADDR_RANGE_HI32__LOGI_PAGE_ADDR_RANGE_HI5_MASK                                    0x0000001FL
//VM_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32
#define VM_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32__SHIFT                               0x0
#define VM_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32
#define VM_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32__SHIFT                               0x0
#define VM_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT1_PAGE_TABLE_BASE_ADDR_LO32
#define VM_CONTEXT1_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32__SHIFT                               0x0
#define VM_CONTEXT1_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT1_PAGE_TABLE_BASE_ADDR_HI32
#define VM_CONTEXT1_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32__SHIFT                               0x0
#define VM_CONTEXT1_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT2_PAGE_TABLE_BASE_ADDR_LO32
#define VM_CONTEXT2_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32__SHIFT                               0x0
#define VM_CONTEXT2_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT2_PAGE_TABLE_BASE_ADDR_HI32
#define VM_CONTEXT2_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32__SHIFT                               0x0
#define VM_CONTEXT2_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT3_PAGE_TABLE_BASE_ADDR_LO32
#define VM_CONTEXT3_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32__SHIFT                               0x0
#define VM_CONTEXT3_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT3_PAGE_TABLE_BASE_ADDR_HI32
#define VM_CONTEXT3_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32__SHIFT                               0x0
#define VM_CONTEXT3_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT4_PAGE_TABLE_BASE_ADDR_LO32
#define VM_CONTEXT4_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32__SHIFT                               0x0
#define VM_CONTEXT4_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT4_PAGE_TABLE_BASE_ADDR_HI32
#define VM_CONTEXT4_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32__SHIFT                               0x0
#define VM_CONTEXT4_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT5_PAGE_TABLE_BASE_ADDR_LO32
#define VM_CONTEXT5_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32__SHIFT                               0x0
#define VM_CONTEXT5_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT5_PAGE_TABLE_BASE_ADDR_HI32
#define VM_CONTEXT5_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32__SHIFT                               0x0
#define VM_CONTEXT5_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT6_PAGE_TABLE_BASE_ADDR_LO32
#define VM_CONTEXT6_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32__SHIFT                               0x0
#define VM_CONTEXT6_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT6_PAGE_TABLE_BASE_ADDR_HI32
#define VM_CONTEXT6_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32__SHIFT                               0x0
#define VM_CONTEXT6_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT7_PAGE_TABLE_BASE_ADDR_LO32
#define VM_CONTEXT7_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32__SHIFT                               0x0
#define VM_CONTEXT7_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT7_PAGE_TABLE_BASE_ADDR_HI32
#define VM_CONTEXT7_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32__SHIFT                               0x0
#define VM_CONTEXT7_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT8_PAGE_TABLE_BASE_ADDR_LO32
#define VM_CONTEXT8_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32__SHIFT                               0x0
#define VM_CONTEXT8_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT8_PAGE_TABLE_BASE_ADDR_HI32
#define VM_CONTEXT8_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32__SHIFT                               0x0
#define VM_CONTEXT8_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT9_PAGE_TABLE_BASE_ADDR_LO32
#define VM_CONTEXT9_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32__SHIFT                               0x0
#define VM_CONTEXT9_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT9_PAGE_TABLE_BASE_ADDR_HI32
#define VM_CONTEXT9_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32__SHIFT                               0x0
#define VM_CONTEXT9_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT10_PAGE_TABLE_BASE_ADDR_LO32
#define VM_CONTEXT10_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32__SHIFT                              0x0
#define VM_CONTEXT10_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32_MASK                                0xFFFFFFFFL
//VM_CONTEXT10_PAGE_TABLE_BASE_ADDR_HI32
#define VM_CONTEXT10_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32__SHIFT                              0x0
#define VM_CONTEXT10_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32_MASK                                0xFFFFFFFFL
//VM_CONTEXT11_PAGE_TABLE_BASE_ADDR_LO32
#define VM_CONTEXT11_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32__SHIFT                              0x0
#define VM_CONTEXT11_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32_MASK                                0xFFFFFFFFL
//VM_CONTEXT11_PAGE_TABLE_BASE_ADDR_HI32
#define VM_CONTEXT11_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32__SHIFT                              0x0
#define VM_CONTEXT11_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32_MASK                                0xFFFFFFFFL
//VM_CONTEXT12_PAGE_TABLE_BASE_ADDR_LO32
#define VM_CONTEXT12_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32__SHIFT                              0x0
#define VM_CONTEXT12_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32_MASK                                0xFFFFFFFFL
//VM_CONTEXT12_PAGE_TABLE_BASE_ADDR_HI32
#define VM_CONTEXT12_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32__SHIFT                              0x0
#define VM_CONTEXT12_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32_MASK                                0xFFFFFFFFL
//VM_CONTEXT13_PAGE_TABLE_BASE_ADDR_LO32
#define VM_CONTEXT13_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32__SHIFT                              0x0
#define VM_CONTEXT13_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32_MASK                                0xFFFFFFFFL
//VM_CONTEXT13_PAGE_TABLE_BASE_ADDR_HI32
#define VM_CONTEXT13_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32__SHIFT                              0x0
#define VM_CONTEXT13_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32_MASK                                0xFFFFFFFFL
//VM_CONTEXT14_PAGE_TABLE_BASE_ADDR_LO32
#define VM_CONTEXT14_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32__SHIFT                              0x0
#define VM_CONTEXT14_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32_MASK                                0xFFFFFFFFL
//VM_CONTEXT14_PAGE_TABLE_BASE_ADDR_HI32
#define VM_CONTEXT14_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32__SHIFT                              0x0
#define VM_CONTEXT14_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32_MASK                                0xFFFFFFFFL
//VM_CONTEXT15_PAGE_TABLE_BASE_ADDR_LO32
#define VM_CONTEXT15_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32__SHIFT                              0x0
#define VM_CONTEXT15_PAGE_TABLE_BASE_ADDR_LO32__PAGE_DIRECTORY_ENTRY_LO32_MASK                                0xFFFFFFFFL
//VM_CONTEXT15_PAGE_TABLE_BASE_ADDR_HI32
#define VM_CONTEXT15_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32__SHIFT                              0x0
#define VM_CONTEXT15_PAGE_TABLE_BASE_ADDR_HI32__PAGE_DIRECTORY_ENTRY_HI32_MASK                                0xFFFFFFFFL
//VM_CONTEXT0_PAGE_TABLE_START_ADDR_LO32
#define VM_CONTEXT0_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                               0x0
#define VM_CONTEXT0_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT0_PAGE_TABLE_START_ADDR_HI32
#define VM_CONTEXT0_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                0x0
#define VM_CONTEXT0_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                  0x0000000FL
//VM_CONTEXT1_PAGE_TABLE_START_ADDR_LO32
#define VM_CONTEXT1_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                               0x0
#define VM_CONTEXT1_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT1_PAGE_TABLE_START_ADDR_HI32
#define VM_CONTEXT1_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                0x0
#define VM_CONTEXT1_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                  0x0000000FL
//VM_CONTEXT2_PAGE_TABLE_START_ADDR_LO32
#define VM_CONTEXT2_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                               0x0
#define VM_CONTEXT2_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT2_PAGE_TABLE_START_ADDR_HI32
#define VM_CONTEXT2_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                0x0
#define VM_CONTEXT2_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                  0x0000000FL
//VM_CONTEXT3_PAGE_TABLE_START_ADDR_LO32
#define VM_CONTEXT3_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                               0x0
#define VM_CONTEXT3_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT3_PAGE_TABLE_START_ADDR_HI32
#define VM_CONTEXT3_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                0x0
#define VM_CONTEXT3_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                  0x0000000FL
//VM_CONTEXT4_PAGE_TABLE_START_ADDR_LO32
#define VM_CONTEXT4_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                               0x0
#define VM_CONTEXT4_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT4_PAGE_TABLE_START_ADDR_HI32
#define VM_CONTEXT4_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                0x0
#define VM_CONTEXT4_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                  0x0000000FL
//VM_CONTEXT5_PAGE_TABLE_START_ADDR_LO32
#define VM_CONTEXT5_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                               0x0
#define VM_CONTEXT5_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT5_PAGE_TABLE_START_ADDR_HI32
#define VM_CONTEXT5_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                0x0
#define VM_CONTEXT5_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                  0x0000000FL
//VM_CONTEXT6_PAGE_TABLE_START_ADDR_LO32
#define VM_CONTEXT6_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                               0x0
#define VM_CONTEXT6_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT6_PAGE_TABLE_START_ADDR_HI32
#define VM_CONTEXT6_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                0x0
#define VM_CONTEXT6_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                  0x0000000FL
//VM_CONTEXT7_PAGE_TABLE_START_ADDR_LO32
#define VM_CONTEXT7_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                               0x0
#define VM_CONTEXT7_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT7_PAGE_TABLE_START_ADDR_HI32
#define VM_CONTEXT7_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                0x0
#define VM_CONTEXT7_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                  0x0000000FL
//VM_CONTEXT8_PAGE_TABLE_START_ADDR_LO32
#define VM_CONTEXT8_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                               0x0
#define VM_CONTEXT8_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT8_PAGE_TABLE_START_ADDR_HI32
#define VM_CONTEXT8_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                0x0
#define VM_CONTEXT8_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                  0x0000000FL
//VM_CONTEXT9_PAGE_TABLE_START_ADDR_LO32
#define VM_CONTEXT9_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                               0x0
#define VM_CONTEXT9_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                 0xFFFFFFFFL
//VM_CONTEXT9_PAGE_TABLE_START_ADDR_HI32
#define VM_CONTEXT9_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                0x0
#define VM_CONTEXT9_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                  0x0000000FL
//VM_CONTEXT10_PAGE_TABLE_START_ADDR_LO32
#define VM_CONTEXT10_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                              0x0
#define VM_CONTEXT10_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                0xFFFFFFFFL
//VM_CONTEXT10_PAGE_TABLE_START_ADDR_HI32
#define VM_CONTEXT10_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                               0x0
#define VM_CONTEXT10_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                 0x0000000FL
//VM_CONTEXT11_PAGE_TABLE_START_ADDR_LO32
#define VM_CONTEXT11_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                              0x0
#define VM_CONTEXT11_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                0xFFFFFFFFL
//VM_CONTEXT11_PAGE_TABLE_START_ADDR_HI32
#define VM_CONTEXT11_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                               0x0
#define VM_CONTEXT11_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                 0x0000000FL
//VM_CONTEXT12_PAGE_TABLE_START_ADDR_LO32
#define VM_CONTEXT12_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                              0x0
#define VM_CONTEXT12_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                0xFFFFFFFFL
//VM_CONTEXT12_PAGE_TABLE_START_ADDR_HI32
#define VM_CONTEXT12_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                               0x0
#define VM_CONTEXT12_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                 0x0000000FL
//VM_CONTEXT13_PAGE_TABLE_START_ADDR_LO32
#define VM_CONTEXT13_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                              0x0
#define VM_CONTEXT13_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                0xFFFFFFFFL
//VM_CONTEXT13_PAGE_TABLE_START_ADDR_HI32
#define VM_CONTEXT13_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                               0x0
#define VM_CONTEXT13_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                 0x0000000FL
//VM_CONTEXT14_PAGE_TABLE_START_ADDR_LO32
#define VM_CONTEXT14_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                              0x0
#define VM_CONTEXT14_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                0xFFFFFFFFL
//VM_CONTEXT14_PAGE_TABLE_START_ADDR_HI32
#define VM_CONTEXT14_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                               0x0
#define VM_CONTEXT14_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                 0x0000000FL
//VM_CONTEXT15_PAGE_TABLE_START_ADDR_LO32
#define VM_CONTEXT15_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                              0x0
#define VM_CONTEXT15_PAGE_TABLE_START_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                0xFFFFFFFFL
//VM_CONTEXT15_PAGE_TABLE_START_ADDR_HI32
#define VM_CONTEXT15_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                               0x0
#define VM_CONTEXT15_PAGE_TABLE_START_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                 0x0000000FL
//VM_CONTEXT0_PAGE_TABLE_END_ADDR_LO32
#define VM_CONTEXT0_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                                 0x0
#define VM_CONTEXT0_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                   0xFFFFFFFFL
//VM_CONTEXT0_PAGE_TABLE_END_ADDR_HI32
#define VM_CONTEXT0_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                  0x0
#define VM_CONTEXT0_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                    0x0000000FL
//VM_CONTEXT1_PAGE_TABLE_END_ADDR_LO32
#define VM_CONTEXT1_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                                 0x0
#define VM_CONTEXT1_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                   0xFFFFFFFFL
//VM_CONTEXT1_PAGE_TABLE_END_ADDR_HI32
#define VM_CONTEXT1_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                  0x0
#define VM_CONTEXT1_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                    0x0000000FL
//VM_CONTEXT2_PAGE_TABLE_END_ADDR_LO32
#define VM_CONTEXT2_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                                 0x0
#define VM_CONTEXT2_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                   0xFFFFFFFFL
//VM_CONTEXT2_PAGE_TABLE_END_ADDR_HI32
#define VM_CONTEXT2_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                  0x0
#define VM_CONTEXT2_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                    0x0000000FL
//VM_CONTEXT3_PAGE_TABLE_END_ADDR_LO32
#define VM_CONTEXT3_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                                 0x0
#define VM_CONTEXT3_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                   0xFFFFFFFFL
//VM_CONTEXT3_PAGE_TABLE_END_ADDR_HI32
#define VM_CONTEXT3_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                  0x0
#define VM_CONTEXT3_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                    0x0000000FL
//VM_CONTEXT4_PAGE_TABLE_END_ADDR_LO32
#define VM_CONTEXT4_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                                 0x0
#define VM_CONTEXT4_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                   0xFFFFFFFFL
//VM_CONTEXT4_PAGE_TABLE_END_ADDR_HI32
#define VM_CONTEXT4_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                  0x0
#define VM_CONTEXT4_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                    0x0000000FL
//VM_CONTEXT5_PAGE_TABLE_END_ADDR_LO32
#define VM_CONTEXT5_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                                 0x0
#define VM_CONTEXT5_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                   0xFFFFFFFFL
//VM_CONTEXT5_PAGE_TABLE_END_ADDR_HI32
#define VM_CONTEXT5_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                  0x0
#define VM_CONTEXT5_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                    0x0000000FL
//VM_CONTEXT6_PAGE_TABLE_END_ADDR_LO32
#define VM_CONTEXT6_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                                 0x0
#define VM_CONTEXT6_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                   0xFFFFFFFFL
//VM_CONTEXT6_PAGE_TABLE_END_ADDR_HI32
#define VM_CONTEXT6_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                  0x0
#define VM_CONTEXT6_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                    0x0000000FL
//VM_CONTEXT7_PAGE_TABLE_END_ADDR_LO32
#define VM_CONTEXT7_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                                 0x0
#define VM_CONTEXT7_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                   0xFFFFFFFFL
//VM_CONTEXT7_PAGE_TABLE_END_ADDR_HI32
#define VM_CONTEXT7_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                  0x0
#define VM_CONTEXT7_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                    0x0000000FL
//VM_CONTEXT8_PAGE_TABLE_END_ADDR_LO32
#define VM_CONTEXT8_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                                 0x0
#define VM_CONTEXT8_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                   0xFFFFFFFFL
//VM_CONTEXT8_PAGE_TABLE_END_ADDR_HI32
#define VM_CONTEXT8_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                  0x0
#define VM_CONTEXT8_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                    0x0000000FL
//VM_CONTEXT9_PAGE_TABLE_END_ADDR_LO32
#define VM_CONTEXT9_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                                 0x0
#define VM_CONTEXT9_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                   0xFFFFFFFFL
//VM_CONTEXT9_PAGE_TABLE_END_ADDR_HI32
#define VM_CONTEXT9_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                  0x0
#define VM_CONTEXT9_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                    0x0000000FL
//VM_CONTEXT10_PAGE_TABLE_END_ADDR_LO32
#define VM_CONTEXT10_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                                0x0
#define VM_CONTEXT10_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                  0xFFFFFFFFL
//VM_CONTEXT10_PAGE_TABLE_END_ADDR_HI32
#define VM_CONTEXT10_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                 0x0
#define VM_CONTEXT10_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                   0x0000000FL
//VM_CONTEXT11_PAGE_TABLE_END_ADDR_LO32
#define VM_CONTEXT11_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                                0x0
#define VM_CONTEXT11_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                  0xFFFFFFFFL
//VM_CONTEXT11_PAGE_TABLE_END_ADDR_HI32
#define VM_CONTEXT11_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                 0x0
#define VM_CONTEXT11_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                   0x0000000FL
//VM_CONTEXT12_PAGE_TABLE_END_ADDR_LO32
#define VM_CONTEXT12_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                                0x0
#define VM_CONTEXT12_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                  0xFFFFFFFFL
//VM_CONTEXT12_PAGE_TABLE_END_ADDR_HI32
#define VM_CONTEXT12_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                 0x0
#define VM_CONTEXT12_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                   0x0000000FL
//VM_CONTEXT13_PAGE_TABLE_END_ADDR_LO32
#define VM_CONTEXT13_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                                0x0
#define VM_CONTEXT13_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                  0xFFFFFFFFL
//VM_CONTEXT13_PAGE_TABLE_END_ADDR_HI32
#define VM_CONTEXT13_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                 0x0
#define VM_CONTEXT13_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                   0x0000000FL
//VM_CONTEXT14_PAGE_TABLE_END_ADDR_LO32
#define VM_CONTEXT14_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                                0x0
#define VM_CONTEXT14_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                  0xFFFFFFFFL
//VM_CONTEXT14_PAGE_TABLE_END_ADDR_HI32
#define VM_CONTEXT14_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                 0x0
#define VM_CONTEXT14_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                   0x0000000FL
//VM_CONTEXT15_PAGE_TABLE_END_ADDR_LO32
#define VM_CONTEXT15_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                                0x0
#define VM_CONTEXT15_PAGE_TABLE_END_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                                  0xFFFFFFFFL
//VM_CONTEXT15_PAGE_TABLE_END_ADDR_HI32
#define VM_CONTEXT15_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                                 0x0
#define VM_CONTEXT15_PAGE_TABLE_END_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                                   0x0000000FL


// addressBlock: gc_utcl2_vmsharedpfdec
//MC_VM_NB_MMIOBASE
#define MC_VM_NB_MMIOBASE__MMIOBASE__SHIFT                                                                    0x0
#define MC_VM_NB_MMIOBASE__MMIOBASE_MASK                                                                      0xFFFFFFFFL
//MC_VM_NB_MMIOLIMIT
#define MC_VM_NB_MMIOLIMIT__MMIOLIMIT__SHIFT                                                                  0x0
#define MC_VM_NB_MMIOLIMIT__MMIOLIMIT_MASK                                                                    0xFFFFFFFFL
//MC_VM_NB_PCI_CTRL
#define MC_VM_NB_PCI_CTRL__MMIOENABLE__SHIFT                                                                  0x17
#define MC_VM_NB_PCI_CTRL__MMIOENABLE_MASK                                                                    0x00800000L
//MC_VM_NB_PCI_ARB
#define MC_VM_NB_PCI_ARB__VGA_HOLE__SHIFT                                                                     0x3
#define MC_VM_NB_PCI_ARB__VGA_HOLE_MASK                                                                       0x00000008L
//MC_VM_NB_TOP_OF_DRAM_SLOT1
#define MC_VM_NB_TOP_OF_DRAM_SLOT1__TOP_OF_DRAM__SHIFT                                                        0x17
#define MC_VM_NB_TOP_OF_DRAM_SLOT1__TOP_OF_DRAM_MASK                                                          0xFF800000L
//MC_VM_NB_LOWER_TOP_OF_DRAM2
#define MC_VM_NB_LOWER_TOP_OF_DRAM2__ENABLE__SHIFT                                                            0x0
#define MC_VM_NB_LOWER_TOP_OF_DRAM2__LOWER_TOM2__SHIFT                                                        0x17
#define MC_VM_NB_LOWER_TOP_OF_DRAM2__ENABLE_MASK                                                              0x00000001L
#define MC_VM_NB_LOWER_TOP_OF_DRAM2__LOWER_TOM2_MASK                                                          0xFF800000L
//MC_VM_NB_UPPER_TOP_OF_DRAM2
#define MC_VM_NB_UPPER_TOP_OF_DRAM2__UPPER_TOM2__SHIFT                                                        0x0
#define MC_VM_NB_UPPER_TOP_OF_DRAM2__UPPER_TOM2_MASK                                                          0x00000FFFL
//MC_VM_FB_OFFSET
#define MC_VM_FB_OFFSET__FB_OFFSET__SHIFT                                                                     0x0
#define MC_VM_FB_OFFSET__FB_OFFSET_MASK                                                                       0x00FFFFFFL
//MC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_LSB
#define MC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_LSB__PHYSICAL_PAGE_NUMBER_LSB__SHIFT                               0x0
#define MC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_LSB__PHYSICAL_PAGE_NUMBER_LSB_MASK                                 0xFFFFFFFFL
//MC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_MSB
#define MC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_MSB__PHYSICAL_PAGE_NUMBER_MSB__SHIFT                               0x0
#define MC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_MSB__PHYSICAL_PAGE_NUMBER_MSB_MASK                                 0x0000000FL
//MC_VM_STEERING
#define MC_VM_STEERING__DEFAULT_STEERING__SHIFT                                                               0x0
#define MC_VM_STEERING__DEFAULT_STEERING_MASK                                                                 0x00000003L
//MC_SHARED_VIRT_RESET_REQ
#define MC_SHARED_VIRT_RESET_REQ__VF__SHIFT                                                                   0x0
#define MC_SHARED_VIRT_RESET_REQ__PF__SHIFT                                                                   0x1f
#define MC_SHARED_VIRT_RESET_REQ__VF_MASK                                                                     0x0000FFFFL
#define MC_SHARED_VIRT_RESET_REQ__PF_MASK                                                                     0x80000000L
//MC_MEM_POWER_LS
#define MC_MEM_POWER_LS__LS_SETUP__SHIFT                                                                      0x0
#define MC_MEM_POWER_LS__LS_HOLD__SHIFT                                                                       0x6
#define MC_MEM_POWER_LS__LS_SETUP_MASK                                                                        0x0000003FL
#define MC_MEM_POWER_LS__LS_HOLD_MASK                                                                         0x00000FC0L
//MC_VM_CACHEABLE_DRAM_ADDRESS_START
#define MC_VM_CACHEABLE_DRAM_ADDRESS_START__ADDRESS__SHIFT                                                    0x0
#define MC_VM_CACHEABLE_DRAM_ADDRESS_START__ADDRESS_MASK                                                      0x000FFFFFL
//MC_VM_CACHEABLE_DRAM_ADDRESS_END
#define MC_VM_CACHEABLE_DRAM_ADDRESS_END__ADDRESS__SHIFT                                                      0x0
#define MC_VM_CACHEABLE_DRAM_ADDRESS_END__ADDRESS_MASK                                                        0x000FFFFFL
//MC_VM_APT_CNTL
#define MC_VM_APT_CNTL__FORCE_MTYPE_UC__SHIFT                                                                 0x0
#define MC_VM_APT_CNTL__DIRECT_SYSTEM_EN__SHIFT                                                               0x1
#define MC_VM_APT_CNTL__FORCE_MTYPE_UC_MASK                                                                   0x00000001L
#define MC_VM_APT_CNTL__DIRECT_SYSTEM_EN_MASK                                                                 0x00000002L
//MC_VM_LOCAL_HBM_ADDRESS_START
#define MC_VM_LOCAL_HBM_ADDRESS_START__ADDRESS__SHIFT                                                         0x0
#define MC_VM_LOCAL_HBM_ADDRESS_START__ADDRESS_MASK                                                           0x000FFFFFL
//MC_VM_LOCAL_HBM_ADDRESS_END
#define MC_VM_LOCAL_HBM_ADDRESS_END__ADDRESS__SHIFT                                                           0x0
#define MC_VM_LOCAL_HBM_ADDRESS_END__ADDRESS_MASK                                                             0x000FFFFFL
//MC_VM_LOCAL_HBM_ADDRESS_LOCK_CNTL
#define MC_VM_LOCAL_HBM_ADDRESS_LOCK_CNTL__LOCK__SHIFT                                                        0x0
#define MC_VM_LOCAL_HBM_ADDRESS_LOCK_CNTL__LOCK_MASK                                                          0x00000001L


// addressBlock: gc_utcl2_vmsharedvcdec
//MC_VM_FB_LOCATION_BASE
#define MC_VM_FB_LOCATION_BASE__FB_BASE__SHIFT                                                                0x0
#define MC_VM_FB_LOCATION_BASE__FB_BASE_MASK                                                                  0x00FFFFFFL
//MC_VM_FB_LOCATION_TOP
#define MC_VM_FB_LOCATION_TOP__FB_TOP__SHIFT                                                                  0x0
#define MC_VM_FB_LOCATION_TOP__FB_TOP_MASK                                                                    0x00FFFFFFL
//MC_VM_AGP_TOP
#define MC_VM_AGP_TOP__AGP_TOP__SHIFT                                                                         0x0
#define MC_VM_AGP_TOP__AGP_TOP_MASK                                                                           0x00FFFFFFL
//MC_VM_AGP_BOT
#define MC_VM_AGP_BOT__AGP_BOT__SHIFT                                                                         0x0
#define MC_VM_AGP_BOT__AGP_BOT_MASK                                                                           0x00FFFFFFL
//MC_VM_AGP_BASE
#define MC_VM_AGP_BASE__AGP_BASE__SHIFT                                                                       0x0
#define MC_VM_AGP_BASE__AGP_BASE_MASK                                                                         0x00FFFFFFL
//MC_VM_SYSTEM_APERTURE_LOW_ADDR
#define MC_VM_SYSTEM_APERTURE_LOW_ADDR__LOGICAL_ADDR__SHIFT                                                   0x0
#define MC_VM_SYSTEM_APERTURE_LOW_ADDR__LOGICAL_ADDR_MASK                                                     0x3FFFFFFFL
//MC_VM_SYSTEM_APERTURE_HIGH_ADDR
#define MC_VM_SYSTEM_APERTURE_HIGH_ADDR__LOGICAL_ADDR__SHIFT                                                  0x0
#define MC_VM_SYSTEM_APERTURE_HIGH_ADDR__LOGICAL_ADDR_MASK                                                    0x3FFFFFFFL
//MC_VM_MX_L1_TLB_CNTL
#define MC_VM_MX_L1_TLB_CNTL__ENABLE_L1_TLB__SHIFT                                                            0x0
#define MC_VM_MX_L1_TLB_CNTL__SYSTEM_ACCESS_MODE__SHIFT                                                       0x3
#define MC_VM_MX_L1_TLB_CNTL__SYSTEM_APERTURE_UNMAPPED_ACCESS__SHIFT                                          0x5
#define MC_VM_MX_L1_TLB_CNTL__ENABLE_ADVANCED_DRIVER_MODEL__SHIFT                                             0x6
#define MC_VM_MX_L1_TLB_CNTL__ECO_BITS__SHIFT                                                                 0x7
#define MC_VM_MX_L1_TLB_CNTL__MTYPE__SHIFT                                                                    0xb
#define MC_VM_MX_L1_TLB_CNTL__ATC_EN__SHIFT                                                                   0xd
#define MC_VM_MX_L1_TLB_CNTL__ENABLE_L1_TLB_MASK                                                              0x00000001L
#define MC_VM_MX_L1_TLB_CNTL__SYSTEM_ACCESS_MODE_MASK                                                         0x00000018L
#define MC_VM_MX_L1_TLB_CNTL__SYSTEM_APERTURE_UNMAPPED_ACCESS_MASK                                            0x00000020L
#define MC_VM_MX_L1_TLB_CNTL__ENABLE_ADVANCED_DRIVER_MODEL_MASK                                               0x00000040L
#define MC_VM_MX_L1_TLB_CNTL__ECO_BITS_MASK                                                                   0x00000780L
#define MC_VM_MX_L1_TLB_CNTL__MTYPE_MASK                                                                      0x00001800L
#define MC_VM_MX_L1_TLB_CNTL__ATC_EN_MASK                                                                     0x00002000L


// addressBlock: gc_ea_gceadec
//GCEA_DRAM_RD_CLI2GRP_MAP0
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID0_GROUP__SHIFT                                                          0x0
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID1_GROUP__SHIFT                                                          0x2
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID2_GROUP__SHIFT                                                          0x4
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID3_GROUP__SHIFT                                                          0x6
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID4_GROUP__SHIFT                                                          0x8
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID5_GROUP__SHIFT                                                          0xa
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID6_GROUP__SHIFT                                                          0xc
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID7_GROUP__SHIFT                                                          0xe
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID8_GROUP__SHIFT                                                          0x10
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID9_GROUP__SHIFT                                                          0x12
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID10_GROUP__SHIFT                                                         0x14
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID11_GROUP__SHIFT                                                         0x16
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID12_GROUP__SHIFT                                                         0x18
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID13_GROUP__SHIFT                                                         0x1a
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID14_GROUP__SHIFT                                                         0x1c
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID15_GROUP__SHIFT                                                         0x1e
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID0_GROUP_MASK                                                            0x00000003L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID1_GROUP_MASK                                                            0x0000000CL
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID2_GROUP_MASK                                                            0x00000030L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID3_GROUP_MASK                                                            0x000000C0L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID4_GROUP_MASK                                                            0x00000300L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID5_GROUP_MASK                                                            0x00000C00L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID6_GROUP_MASK                                                            0x00003000L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID7_GROUP_MASK                                                            0x0000C000L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID8_GROUP_MASK                                                            0x00030000L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID9_GROUP_MASK                                                            0x000C0000L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID10_GROUP_MASK                                                           0x00300000L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID11_GROUP_MASK                                                           0x00C00000L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID12_GROUP_MASK                                                           0x03000000L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID13_GROUP_MASK                                                           0x0C000000L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID14_GROUP_MASK                                                           0x30000000L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID15_GROUP_MASK                                                           0xC0000000L
//GCEA_DRAM_RD_CLI2GRP_MAP1
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID16_GROUP__SHIFT                                                         0x0
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID17_GROUP__SHIFT                                                         0x2
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID18_GROUP__SHIFT                                                         0x4
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID19_GROUP__SHIFT                                                         0x6
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID20_GROUP__SHIFT                                                         0x8
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID21_GROUP__SHIFT                                                         0xa
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID22_GROUP__SHIFT                                                         0xc
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID23_GROUP__SHIFT                                                         0xe
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID24_GROUP__SHIFT                                                         0x10
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID25_GROUP__SHIFT                                                         0x12
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID26_GROUP__SHIFT                                                         0x14
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID27_GROUP__SHIFT                                                         0x16
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID28_GROUP__SHIFT                                                         0x18
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID29_GROUP__SHIFT                                                         0x1a
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID30_GROUP__SHIFT                                                         0x1c
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID31_GROUP__SHIFT                                                         0x1e
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID16_GROUP_MASK                                                           0x00000003L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID17_GROUP_MASK                                                           0x0000000CL
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID18_GROUP_MASK                                                           0x00000030L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID19_GROUP_MASK                                                           0x000000C0L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID20_GROUP_MASK                                                           0x00000300L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID21_GROUP_MASK                                                           0x00000C00L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID22_GROUP_MASK                                                           0x00003000L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID23_GROUP_MASK                                                           0x0000C000L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID24_GROUP_MASK                                                           0x00030000L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID25_GROUP_MASK                                                           0x000C0000L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID26_GROUP_MASK                                                           0x00300000L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID27_GROUP_MASK                                                           0x00C00000L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID28_GROUP_MASK                                                           0x03000000L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID29_GROUP_MASK                                                           0x0C000000L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID30_GROUP_MASK                                                           0x30000000L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID31_GROUP_MASK                                                           0xC0000000L
//GCEA_DRAM_WR_CLI2GRP_MAP0
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID0_GROUP__SHIFT                                                          0x0
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID1_GROUP__SHIFT                                                          0x2
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID2_GROUP__SHIFT                                                          0x4
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID3_GROUP__SHIFT                                                          0x6
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID4_GROUP__SHIFT                                                          0x8
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID5_GROUP__SHIFT                                                          0xa
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID6_GROUP__SHIFT                                                          0xc
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID7_GROUP__SHIFT                                                          0xe
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID8_GROUP__SHIFT                                                          0x10
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID9_GROUP__SHIFT                                                          0x12
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID10_GROUP__SHIFT                                                         0x14
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID11_GROUP__SHIFT                                                         0x16
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID12_GROUP__SHIFT                                                         0x18
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID13_GROUP__SHIFT                                                         0x1a
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID14_GROUP__SHIFT                                                         0x1c
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID15_GROUP__SHIFT                                                         0x1e
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID0_GROUP_MASK                                                            0x00000003L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID1_GROUP_MASK                                                            0x0000000CL
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID2_GROUP_MASK                                                            0x00000030L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID3_GROUP_MASK                                                            0x000000C0L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID4_GROUP_MASK                                                            0x00000300L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID5_GROUP_MASK                                                            0x00000C00L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID6_GROUP_MASK                                                            0x00003000L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID7_GROUP_MASK                                                            0x0000C000L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID8_GROUP_MASK                                                            0x00030000L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID9_GROUP_MASK                                                            0x000C0000L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID10_GROUP_MASK                                                           0x00300000L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID11_GROUP_MASK                                                           0x00C00000L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID12_GROUP_MASK                                                           0x03000000L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID13_GROUP_MASK                                                           0x0C000000L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID14_GROUP_MASK                                                           0x30000000L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID15_GROUP_MASK                                                           0xC0000000L
//GCEA_DRAM_WR_CLI2GRP_MAP1
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID16_GROUP__SHIFT                                                         0x0
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID17_GROUP__SHIFT                                                         0x2
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID18_GROUP__SHIFT                                                         0x4
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID19_GROUP__SHIFT                                                         0x6
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID20_GROUP__SHIFT                                                         0x8
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID21_GROUP__SHIFT                                                         0xa
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID22_GROUP__SHIFT                                                         0xc
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID23_GROUP__SHIFT                                                         0xe
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID24_GROUP__SHIFT                                                         0x10
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID25_GROUP__SHIFT                                                         0x12
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID26_GROUP__SHIFT                                                         0x14
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID27_GROUP__SHIFT                                                         0x16
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID28_GROUP__SHIFT                                                         0x18
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID29_GROUP__SHIFT                                                         0x1a
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID30_GROUP__SHIFT                                                         0x1c
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID31_GROUP__SHIFT                                                         0x1e
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID16_GROUP_MASK                                                           0x00000003L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID17_GROUP_MASK                                                           0x0000000CL
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID18_GROUP_MASK                                                           0x00000030L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID19_GROUP_MASK                                                           0x000000C0L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID20_GROUP_MASK                                                           0x00000300L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID21_GROUP_MASK                                                           0x00000C00L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID22_GROUP_MASK                                                           0x00003000L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID23_GROUP_MASK                                                           0x0000C000L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID24_GROUP_MASK                                                           0x00030000L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID25_GROUP_MASK                                                           0x000C0000L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID26_GROUP_MASK                                                           0x00300000L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID27_GROUP_MASK                                                           0x00C00000L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID28_GROUP_MASK                                                           0x03000000L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID29_GROUP_MASK                                                           0x0C000000L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID30_GROUP_MASK                                                           0x30000000L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID31_GROUP_MASK                                                           0xC0000000L
//GCEA_DRAM_RD_GRP2VC_MAP
#define GCEA_DRAM_RD_GRP2VC_MAP__GROUP0_VC__SHIFT                                                             0x0
#define GCEA_DRAM_RD_GRP2VC_MAP__GROUP1_VC__SHIFT                                                             0x3
#define GCEA_DRAM_RD_GRP2VC_MAP__GROUP2_VC__SHIFT                                                             0x6
#define GCEA_DRAM_RD_GRP2VC_MAP__GROUP3_VC__SHIFT                                                             0x9
#define GCEA_DRAM_RD_GRP2VC_MAP__GROUP0_VC_MASK                                                               0x00000007L
#define GCEA_DRAM_RD_GRP2VC_MAP__GROUP1_VC_MASK                                                               0x00000038L
#define GCEA_DRAM_RD_GRP2VC_MAP__GROUP2_VC_MASK                                                               0x000001C0L
#define GCEA_DRAM_RD_GRP2VC_MAP__GROUP3_VC_MASK                                                               0x00000E00L
//GCEA_DRAM_WR_GRP2VC_MAP
#define GCEA_DRAM_WR_GRP2VC_MAP__GROUP0_VC__SHIFT                                                             0x0
#define GCEA_DRAM_WR_GRP2VC_MAP__GROUP1_VC__SHIFT                                                             0x3
#define GCEA_DRAM_WR_GRP2VC_MAP__GROUP2_VC__SHIFT                                                             0x6
#define GCEA_DRAM_WR_GRP2VC_MAP__GROUP3_VC__SHIFT                                                             0x9
#define GCEA_DRAM_WR_GRP2VC_MAP__GROUP0_VC_MASK                                                               0x00000007L
#define GCEA_DRAM_WR_GRP2VC_MAP__GROUP1_VC_MASK                                                               0x00000038L
#define GCEA_DRAM_WR_GRP2VC_MAP__GROUP2_VC_MASK                                                               0x000001C0L
#define GCEA_DRAM_WR_GRP2VC_MAP__GROUP3_VC_MASK                                                               0x00000E00L
//GCEA_DRAM_RD_LAZY
#define GCEA_DRAM_RD_LAZY__GROUP0_DELAY__SHIFT                                                                0x0
#define GCEA_DRAM_RD_LAZY__GROUP1_DELAY__SHIFT                                                                0x3
#define GCEA_DRAM_RD_LAZY__GROUP2_DELAY__SHIFT                                                                0x6
#define GCEA_DRAM_RD_LAZY__GROUP3_DELAY__SHIFT                                                                0x9
#define GCEA_DRAM_RD_LAZY__GROUP0_DELAY_MASK                                                                  0x00000007L
#define GCEA_DRAM_RD_LAZY__GROUP1_DELAY_MASK                                                                  0x00000038L
#define GCEA_DRAM_RD_LAZY__GROUP2_DELAY_MASK                                                                  0x000001C0L
#define GCEA_DRAM_RD_LAZY__GROUP3_DELAY_MASK                                                                  0x00000E00L
//GCEA_DRAM_WR_LAZY
#define GCEA_DRAM_WR_LAZY__GROUP0_DELAY__SHIFT                                                                0x0
#define GCEA_DRAM_WR_LAZY__GROUP1_DELAY__SHIFT                                                                0x3
#define GCEA_DRAM_WR_LAZY__GROUP2_DELAY__SHIFT                                                                0x6
#define GCEA_DRAM_WR_LAZY__GROUP3_DELAY__SHIFT                                                                0x9
#define GCEA_DRAM_WR_LAZY__GROUP0_DELAY_MASK                                                                  0x00000007L
#define GCEA_DRAM_WR_LAZY__GROUP1_DELAY_MASK                                                                  0x00000038L
#define GCEA_DRAM_WR_LAZY__GROUP2_DELAY_MASK                                                                  0x000001C0L
#define GCEA_DRAM_WR_LAZY__GROUP3_DELAY_MASK                                                                  0x00000E00L
//GCEA_DRAM_RD_CAM_CNTL
#define GCEA_DRAM_RD_CAM_CNTL__DEPTH_GROUP0__SHIFT                                                            0x0
#define GCEA_DRAM_RD_CAM_CNTL__DEPTH_GROUP1__SHIFT                                                            0x4
#define GCEA_DRAM_RD_CAM_CNTL__DEPTH_GROUP2__SHIFT                                                            0x8
#define GCEA_DRAM_RD_CAM_CNTL__DEPTH_GROUP3__SHIFT                                                            0xc
#define GCEA_DRAM_RD_CAM_CNTL__REORDER_LIMIT_GROUP0__SHIFT                                                    0x10
#define GCEA_DRAM_RD_CAM_CNTL__REORDER_LIMIT_GROUP1__SHIFT                                                    0x13
#define GCEA_DRAM_RD_CAM_CNTL__REORDER_LIMIT_GROUP2__SHIFT                                                    0x16
#define GCEA_DRAM_RD_CAM_CNTL__REORDER_LIMIT_GROUP3__SHIFT                                                    0x19
#define GCEA_DRAM_RD_CAM_CNTL__DEPTH_GROUP0_MASK                                                              0x0000000FL
#define GCEA_DRAM_RD_CAM_CNTL__DEPTH_GROUP1_MASK                                                              0x000000F0L
#define GCEA_DRAM_RD_CAM_CNTL__DEPTH_GROUP2_MASK                                                              0x00000F00L
#define GCEA_DRAM_RD_CAM_CNTL__DEPTH_GROUP3_MASK                                                              0x0000F000L
#define GCEA_DRAM_RD_CAM_CNTL__REORDER_LIMIT_GROUP0_MASK                                                      0x00070000L
#define GCEA_DRAM_RD_CAM_CNTL__REORDER_LIMIT_GROUP1_MASK                                                      0x00380000L
#define GCEA_DRAM_RD_CAM_CNTL__REORDER_LIMIT_GROUP2_MASK                                                      0x01C00000L
#define GCEA_DRAM_RD_CAM_CNTL__REORDER_LIMIT_GROUP3_MASK                                                      0x0E000000L
//GCEA_DRAM_WR_CAM_CNTL
#define GCEA_DRAM_WR_CAM_CNTL__DEPTH_GROUP0__SHIFT                                                            0x0
#define GCEA_DRAM_WR_CAM_CNTL__DEPTH_GROUP1__SHIFT                                                            0x4
#define GCEA_DRAM_WR_CAM_CNTL__DEPTH_GROUP2__SHIFT                                                            0x8
#define GCEA_DRAM_WR_CAM_CNTL__DEPTH_GROUP3__SHIFT                                                            0xc
#define GCEA_DRAM_WR_CAM_CNTL__REORDER_LIMIT_GROUP0__SHIFT                                                    0x10
#define GCEA_DRAM_WR_CAM_CNTL__REORDER_LIMIT_GROUP1__SHIFT                                                    0x13
#define GCEA_DRAM_WR_CAM_CNTL__REORDER_LIMIT_GROUP2__SHIFT                                                    0x16
#define GCEA_DRAM_WR_CAM_CNTL__REORDER_LIMIT_GROUP3__SHIFT                                                    0x19
#define GCEA_DRAM_WR_CAM_CNTL__DEPTH_GROUP0_MASK                                                              0x0000000FL
#define GCEA_DRAM_WR_CAM_CNTL__DEPTH_GROUP1_MASK                                                              0x000000F0L
#define GCEA_DRAM_WR_CAM_CNTL__DEPTH_GROUP2_MASK                                                              0x00000F00L
#define GCEA_DRAM_WR_CAM_CNTL__DEPTH_GROUP3_MASK                                                              0x0000F000L
#define GCEA_DRAM_WR_CAM_CNTL__REORDER_LIMIT_GROUP0_MASK                                                      0x00070000L
#define GCEA_DRAM_WR_CAM_CNTL__REORDER_LIMIT_GROUP1_MASK                                                      0x00380000L
#define GCEA_DRAM_WR_CAM_CNTL__REORDER_LIMIT_GROUP2_MASK                                                      0x01C00000L
#define GCEA_DRAM_WR_CAM_CNTL__REORDER_LIMIT_GROUP3_MASK                                                      0x0E000000L
//GCEA_DRAM_PAGE_BURST
#define GCEA_DRAM_PAGE_BURST__RD_LIMIT_LO__SHIFT                                                              0x0
#define GCEA_DRAM_PAGE_BURST__RD_LIMIT_HI__SHIFT                                                              0x8
#define GCEA_DRAM_PAGE_BURST__WR_LIMIT_LO__SHIFT                                                              0x10
#define GCEA_DRAM_PAGE_BURST__WR_LIMIT_HI__SHIFT                                                              0x18
#define GCEA_DRAM_PAGE_BURST__RD_LIMIT_LO_MASK                                                                0x000000FFL
#define GCEA_DRAM_PAGE_BURST__RD_LIMIT_HI_MASK                                                                0x0000FF00L
#define GCEA_DRAM_PAGE_BURST__WR_LIMIT_LO_MASK                                                                0x00FF0000L
#define GCEA_DRAM_PAGE_BURST__WR_LIMIT_HI_MASK                                                                0xFF000000L
//GCEA_DRAM_RD_PRI_AGE
#define GCEA_DRAM_RD_PRI_AGE__GROUP0_AGING_RATE__SHIFT                                                        0x0
#define GCEA_DRAM_RD_PRI_AGE__GROUP1_AGING_RATE__SHIFT                                                        0x3
#define GCEA_DRAM_RD_PRI_AGE__GROUP2_AGING_RATE__SHIFT                                                        0x6
#define GCEA_DRAM_RD_PRI_AGE__GROUP3_AGING_RATE__SHIFT                                                        0x9
#define GCEA_DRAM_RD_PRI_AGE__GROUP0_AGE_COEFFICIENT__SHIFT                                                   0xc
#define GCEA_DRAM_RD_PRI_AGE__GROUP1_AGE_COEFFICIENT__SHIFT                                                   0xf
#define GCEA_DRAM_RD_PRI_AGE__GROUP2_AGE_COEFFICIENT__SHIFT                                                   0x12
#define GCEA_DRAM_RD_PRI_AGE__GROUP3_AGE_COEFFICIENT__SHIFT                                                   0x15
#define GCEA_DRAM_RD_PRI_AGE__GROUP0_AGING_RATE_MASK                                                          0x00000007L
#define GCEA_DRAM_RD_PRI_AGE__GROUP1_AGING_RATE_MASK                                                          0x00000038L
#define GCEA_DRAM_RD_PRI_AGE__GROUP2_AGING_RATE_MASK                                                          0x000001C0L
#define GCEA_DRAM_RD_PRI_AGE__GROUP3_AGING_RATE_MASK                                                          0x00000E00L
#define GCEA_DRAM_RD_PRI_AGE__GROUP0_AGE_COEFFICIENT_MASK                                                     0x00007000L
#define GCEA_DRAM_RD_PRI_AGE__GROUP1_AGE_COEFFICIENT_MASK                                                     0x00038000L
#define GCEA_DRAM_RD_PRI_AGE__GROUP2_AGE_COEFFICIENT_MASK                                                     0x001C0000L
#define GCEA_DRAM_RD_PRI_AGE__GROUP3_AGE_COEFFICIENT_MASK                                                     0x00E00000L
//GCEA_DRAM_WR_PRI_AGE
#define GCEA_DRAM_WR_PRI_AGE__GROUP0_AGING_RATE__SHIFT                                                        0x0
#define GCEA_DRAM_WR_PRI_AGE__GROUP1_AGING_RATE__SHIFT                                                        0x3
#define GCEA_DRAM_WR_PRI_AGE__GROUP2_AGING_RATE__SHIFT                                                        0x6
#define GCEA_DRAM_WR_PRI_AGE__GROUP3_AGING_RATE__SHIFT                                                        0x9
#define GCEA_DRAM_WR_PRI_AGE__GROUP0_AGE_COEFFICIENT__SHIFT                                                   0xc
#define GCEA_DRAM_WR_PRI_AGE__GROUP1_AGE_COEFFICIENT__SHIFT                                                   0xf
#define GCEA_DRAM_WR_PRI_AGE__GROUP2_AGE_COEFFICIENT__SHIFT                                                   0x12
#define GCEA_DRAM_WR_PRI_AGE__GROUP3_AGE_COEFFICIENT__SHIFT                                                   0x15
#define GCEA_DRAM_WR_PRI_AGE__GROUP0_AGING_RATE_MASK                                                          0x00000007L
#define GCEA_DRAM_WR_PRI_AGE__GROUP1_AGING_RATE_MASK                                                          0x00000038L
#define GCEA_DRAM_WR_PRI_AGE__GROUP2_AGING_RATE_MASK                                                          0x000001C0L
#define GCEA_DRAM_WR_PRI_AGE__GROUP3_AGING_RATE_MASK                                                          0x00000E00L
#define GCEA_DRAM_WR_PRI_AGE__GROUP0_AGE_COEFFICIENT_MASK                                                     0x00007000L
#define GCEA_DRAM_WR_PRI_AGE__GROUP1_AGE_COEFFICIENT_MASK                                                     0x00038000L
#define GCEA_DRAM_WR_PRI_AGE__GROUP2_AGE_COEFFICIENT_MASK                                                     0x001C0000L
#define GCEA_DRAM_WR_PRI_AGE__GROUP3_AGE_COEFFICIENT_MASK                                                     0x00E00000L
//GCEA_DRAM_RD_PRI_QUEUING
#define GCEA_DRAM_RD_PRI_QUEUING__GROUP0_QUEUING_COEFFICIENT__SHIFT                                           0x0
#define GCEA_DRAM_RD_PRI_QUEUING__GROUP1_QUEUING_COEFFICIENT__SHIFT                                           0x3
#define GCEA_DRAM_RD_PRI_QUEUING__GROUP2_QUEUING_COEFFICIENT__SHIFT                                           0x6
#define GCEA_DRAM_RD_PRI_QUEUING__GROUP3_QUEUING_COEFFICIENT__SHIFT                                           0x9
#define GCEA_DRAM_RD_PRI_QUEUING__GROUP0_QUEUING_COEFFICIENT_MASK                                             0x00000007L
#define GCEA_DRAM_RD_PRI_QUEUING__GROUP1_QUEUING_COEFFICIENT_MASK                                             0x00000038L
#define GCEA_DRAM_RD_PRI_QUEUING__GROUP2_QUEUING_COEFFICIENT_MASK                                             0x000001C0L
#define GCEA_DRAM_RD_PRI_QUEUING__GROUP3_QUEUING_COEFFICIENT_MASK                                             0x00000E00L
//GCEA_DRAM_WR_PRI_QUEUING
#define GCEA_DRAM_WR_PRI_QUEUING__GROUP0_QUEUING_COEFFICIENT__SHIFT                                           0x0
#define GCEA_DRAM_WR_PRI_QUEUING__GROUP1_QUEUING_COEFFICIENT__SHIFT                                           0x3
#define GCEA_DRAM_WR_PRI_QUEUING__GROUP2_QUEUING_COEFFICIENT__SHIFT                                           0x6
#define GCEA_DRAM_WR_PRI_QUEUING__GROUP3_QUEUING_COEFFICIENT__SHIFT                                           0x9
#define GCEA_DRAM_WR_PRI_QUEUING__GROUP0_QUEUING_COEFFICIENT_MASK                                             0x00000007L
#define GCEA_DRAM_WR_PRI_QUEUING__GROUP1_QUEUING_COEFFICIENT_MASK                                             0x00000038L
#define GCEA_DRAM_WR_PRI_QUEUING__GROUP2_QUEUING_COEFFICIENT_MASK                                             0x000001C0L
#define GCEA_DRAM_WR_PRI_QUEUING__GROUP3_QUEUING_COEFFICIENT_MASK                                             0x00000E00L
//GCEA_DRAM_RD_PRI_FIXED
#define GCEA_DRAM_RD_PRI_FIXED__GROUP0_FIXED_COEFFICIENT__SHIFT                                               0x0
#define GCEA_DRAM_RD_PRI_FIXED__GROUP1_FIXED_COEFFICIENT__SHIFT                                               0x3
#define GCEA_DRAM_RD_PRI_FIXED__GROUP2_FIXED_COEFFICIENT__SHIFT                                               0x6
#define GCEA_DRAM_RD_PRI_FIXED__GROUP3_FIXED_COEFFICIENT__SHIFT                                               0x9
#define GCEA_DRAM_RD_PRI_FIXED__GROUP0_FIXED_COEFFICIENT_MASK                                                 0x00000007L
#define GCEA_DRAM_RD_PRI_FIXED__GROUP1_FIXED_COEFFICIENT_MASK                                                 0x00000038L
#define GCEA_DRAM_RD_PRI_FIXED__GROUP2_FIXED_COEFFICIENT_MASK                                                 0x000001C0L
#define GCEA_DRAM_RD_PRI_FIXED__GROUP3_FIXED_COEFFICIENT_MASK                                                 0x00000E00L
//GCEA_DRAM_WR_PRI_FIXED
#define GCEA_DRAM_WR_PRI_FIXED__GROUP0_FIXED_COEFFICIENT__SHIFT                                               0x0
#define GCEA_DRAM_WR_PRI_FIXED__GROUP1_FIXED_COEFFICIENT__SHIFT                                               0x3
#define GCEA_DRAM_WR_PRI_FIXED__GROUP2_FIXED_COEFFICIENT__SHIFT                                               0x6
#define GCEA_DRAM_WR_PRI_FIXED__GROUP3_FIXED_COEFFICIENT__SHIFT                                               0x9
#define GCEA_DRAM_WR_PRI_FIXED__GROUP0_FIXED_COEFFICIENT_MASK                                                 0x00000007L
#define GCEA_DRAM_WR_PRI_FIXED__GROUP1_FIXED_COEFFICIENT_MASK                                                 0x00000038L
#define GCEA_DRAM_WR_PRI_FIXED__GROUP2_FIXED_COEFFICIENT_MASK                                                 0x000001C0L
#define GCEA_DRAM_WR_PRI_FIXED__GROUP3_FIXED_COEFFICIENT_MASK                                                 0x00000E00L
//GCEA_DRAM_RD_PRI_URGENCY
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP0_URGENCY_COEFFICIENT__SHIFT                                           0x0
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP1_URGENCY_COEFFICIENT__SHIFT                                           0x3
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP2_URGENCY_COEFFICIENT__SHIFT                                           0x6
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP3_URGENCY_COEFFICIENT__SHIFT                                           0x9
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP0_URGENCY_MODE__SHIFT                                                  0xc
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP1_URGENCY_MODE__SHIFT                                                  0xd
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP2_URGENCY_MODE__SHIFT                                                  0xe
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP3_URGENCY_MODE__SHIFT                                                  0xf
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP0_URGENCY_COEFFICIENT_MASK                                             0x00000007L
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP1_URGENCY_COEFFICIENT_MASK                                             0x00000038L
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP2_URGENCY_COEFFICIENT_MASK                                             0x000001C0L
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP3_URGENCY_COEFFICIENT_MASK                                             0x00000E00L
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP0_URGENCY_MODE_MASK                                                    0x00001000L
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP1_URGENCY_MODE_MASK                                                    0x00002000L
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP2_URGENCY_MODE_MASK                                                    0x00004000L
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP3_URGENCY_MODE_MASK                                                    0x00008000L
//GCEA_DRAM_WR_PRI_URGENCY
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP0_URGENCY_COEFFICIENT__SHIFT                                           0x0
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP1_URGENCY_COEFFICIENT__SHIFT                                           0x3
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP2_URGENCY_COEFFICIENT__SHIFT                                           0x6
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP3_URGENCY_COEFFICIENT__SHIFT                                           0x9
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP0_URGENCY_MODE__SHIFT                                                  0xc
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP1_URGENCY_MODE__SHIFT                                                  0xd
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP2_URGENCY_MODE__SHIFT                                                  0xe
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP3_URGENCY_MODE__SHIFT                                                  0xf
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP0_URGENCY_COEFFICIENT_MASK                                             0x00000007L
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP1_URGENCY_COEFFICIENT_MASK                                             0x00000038L
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP2_URGENCY_COEFFICIENT_MASK                                             0x000001C0L
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP3_URGENCY_COEFFICIENT_MASK                                             0x00000E00L
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP0_URGENCY_MODE_MASK                                                    0x00001000L
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP1_URGENCY_MODE_MASK                                                    0x00002000L
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP2_URGENCY_MODE_MASK                                                    0x00004000L
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP3_URGENCY_MODE_MASK                                                    0x00008000L
//GCEA_DRAM_RD_PRI_QUANT_PRI1
#define GCEA_DRAM_RD_PRI_QUANT_PRI1__GROUP0_THRESHOLD__SHIFT                                                  0x0
#define GCEA_DRAM_RD_PRI_QUANT_PRI1__GROUP1_THRESHOLD__SHIFT                                                  0x8
#define GCEA_DRAM_RD_PRI_QUANT_PRI1__GROUP2_THRESHOLD__SHIFT                                                  0x10
#define GCEA_DRAM_RD_PRI_QUANT_PRI1__GROUP3_THRESHOLD__SHIFT                                                  0x18
#define GCEA_DRAM_RD_PRI_QUANT_PRI1__GROUP0_THRESHOLD_MASK                                                    0x000000FFL
#define GCEA_DRAM_RD_PRI_QUANT_PRI1__GROUP1_THRESHOLD_MASK                                                    0x0000FF00L
#define GCEA_DRAM_RD_PRI_QUANT_PRI1__GROUP2_THRESHOLD_MASK                                                    0x00FF0000L
#define GCEA_DRAM_RD_PRI_QUANT_PRI1__GROUP3_THRESHOLD_MASK                                                    0xFF000000L
//GCEA_DRAM_RD_PRI_QUANT_PRI2
#define GCEA_DRAM_RD_PRI_QUANT_PRI2__GROUP0_THRESHOLD__SHIFT                                                  0x0
#define GCEA_DRAM_RD_PRI_QUANT_PRI2__GROUP1_THRESHOLD__SHIFT                                                  0x8
#define GCEA_DRAM_RD_PRI_QUANT_PRI2__GROUP2_THRESHOLD__SHIFT                                                  0x10
#define GCEA_DRAM_RD_PRI_QUANT_PRI2__GROUP3_THRESHOLD__SHIFT                                                  0x18
#define GCEA_DRAM_RD_PRI_QUANT_PRI2__GROUP0_THRESHOLD_MASK                                                    0x000000FFL
#define GCEA_DRAM_RD_PRI_QUANT_PRI2__GROUP1_THRESHOLD_MASK                                                    0x0000FF00L
#define GCEA_DRAM_RD_PRI_QUANT_PRI2__GROUP2_THRESHOLD_MASK                                                    0x00FF0000L
#define GCEA_DRAM_RD_PRI_QUANT_PRI2__GROUP3_THRESHOLD_MASK                                                    0xFF000000L
//GCEA_DRAM_RD_PRI_QUANT_PRI3
#define GCEA_DRAM_RD_PRI_QUANT_PRI3__GROUP0_THRESHOLD__SHIFT                                                  0x0
#define GCEA_DRAM_RD_PRI_QUANT_PRI3__GROUP1_THRESHOLD__SHIFT                                                  0x8
#define GCEA_DRAM_RD_PRI_QUANT_PRI3__GROUP2_THRESHOLD__SHIFT                                                  0x10
#define GCEA_DRAM_RD_PRI_QUANT_PRI3__GROUP3_THRESHOLD__SHIFT                                                  0x18
#define GCEA_DRAM_RD_PRI_QUANT_PRI3__GROUP0_THRESHOLD_MASK                                                    0x000000FFL
#define GCEA_DRAM_RD_PRI_QUANT_PRI3__GROUP1_THRESHOLD_MASK                                                    0x0000FF00L
#define GCEA_DRAM_RD_PRI_QUANT_PRI3__GROUP2_THRESHOLD_MASK                                                    0x00FF0000L
#define GCEA_DRAM_RD_PRI_QUANT_PRI3__GROUP3_THRESHOLD_MASK                                                    0xFF000000L
//GCEA_DRAM_WR_PRI_QUANT_PRI1
#define GCEA_DRAM_WR_PRI_QUANT_PRI1__GROUP0_THRESHOLD__SHIFT                                                  0x0
#define GCEA_DRAM_WR_PRI_QUANT_PRI1__GROUP1_THRESHOLD__SHIFT                                                  0x8
#define GCEA_DRAM_WR_PRI_QUANT_PRI1__GROUP2_THRESHOLD__SHIFT                                                  0x10
#define GCEA_DRAM_WR_PRI_QUANT_PRI1__GROUP3_THRESHOLD__SHIFT                                                  0x18
#define GCEA_DRAM_WR_PRI_QUANT_PRI1__GROUP0_THRESHOLD_MASK                                                    0x000000FFL
#define GCEA_DRAM_WR_PRI_QUANT_PRI1__GROUP1_THRESHOLD_MASK                                                    0x0000FF00L
#define GCEA_DRAM_WR_PRI_QUANT_PRI1__GROUP2_THRESHOLD_MASK                                                    0x00FF0000L
#define GCEA_DRAM_WR_PRI_QUANT_PRI1__GROUP3_THRESHOLD_MASK                                                    0xFF000000L
//GCEA_DRAM_WR_PRI_QUANT_PRI2
#define GCEA_DRAM_WR_PRI_QUANT_PRI2__GROUP0_THRESHOLD__SHIFT                                                  0x0
#define GCEA_DRAM_WR_PRI_QUANT_PRI2__GROUP1_THRESHOLD__SHIFT                                                  0x8
#define GCEA_DRAM_WR_PRI_QUANT_PRI2__GROUP2_THRESHOLD__SHIFT                                                  0x10
#define GCEA_DRAM_WR_PRI_QUANT_PRI2__GROUP3_THRESHOLD__SHIFT                                                  0x18
#define GCEA_DRAM_WR_PRI_QUANT_PRI2__GROUP0_THRESHOLD_MASK                                                    0x000000FFL
#define GCEA_DRAM_WR_PRI_QUANT_PRI2__GROUP1_THRESHOLD_MASK                                                    0x0000FF00L
#define GCEA_DRAM_WR_PRI_QUANT_PRI2__GROUP2_THRESHOLD_MASK                                                    0x00FF0000L
#define GCEA_DRAM_WR_PRI_QUANT_PRI2__GROUP3_THRESHOLD_MASK                                                    0xFF000000L
//GCEA_DRAM_WR_PRI_QUANT_PRI3
#define GCEA_DRAM_WR_PRI_QUANT_PRI3__GROUP0_THRESHOLD__SHIFT                                                  0x0
#define GCEA_DRAM_WR_PRI_QUANT_PRI3__GROUP1_THRESHOLD__SHIFT                                                  0x8
#define GCEA_DRAM_WR_PRI_QUANT_PRI3__GROUP2_THRESHOLD__SHIFT                                                  0x10
#define GCEA_DRAM_WR_PRI_QUANT_PRI3__GROUP3_THRESHOLD__SHIFT                                                  0x18
#define GCEA_DRAM_WR_PRI_QUANT_PRI3__GROUP0_THRESHOLD_MASK                                                    0x000000FFL
#define GCEA_DRAM_WR_PRI_QUANT_PRI3__GROUP1_THRESHOLD_MASK                                                    0x0000FF00L
#define GCEA_DRAM_WR_PRI_QUANT_PRI3__GROUP2_THRESHOLD_MASK                                                    0x00FF0000L
#define GCEA_DRAM_WR_PRI_QUANT_PRI3__GROUP3_THRESHOLD_MASK                                                    0xFF000000L
//GCEA_ADDRNORM_BASE_ADDR0
#define GCEA_ADDRNORM_BASE_ADDR0__ADDR_RNG_VAL__SHIFT                                                         0x0
#define GCEA_ADDRNORM_BASE_ADDR0__LGCY_MMIO_HOLE_EN__SHIFT                                                    0x1
#define GCEA_ADDRNORM_BASE_ADDR0__INTLV_NUM_CHAN__SHIFT                                                       0x4
#define GCEA_ADDRNORM_BASE_ADDR0__INTLV_ADDR_SEL__SHIFT                                                       0x8
#define GCEA_ADDRNORM_BASE_ADDR0__BASE_ADDR__SHIFT                                                            0xc
#define GCEA_ADDRNORM_BASE_ADDR0__ADDR_RNG_VAL_MASK                                                           0x00000001L
#define GCEA_ADDRNORM_BASE_ADDR0__LGCY_MMIO_HOLE_EN_MASK                                                      0x00000002L
#define GCEA_ADDRNORM_BASE_ADDR0__INTLV_NUM_CHAN_MASK                                                         0x000000F0L
#define GCEA_ADDRNORM_BASE_ADDR0__INTLV_ADDR_SEL_MASK                                                         0x00000700L
#define GCEA_ADDRNORM_BASE_ADDR0__BASE_ADDR_MASK                                                              0xFFFFF000L
//GCEA_ADDRNORM_LIMIT_ADDR0
#define GCEA_ADDRNORM_LIMIT_ADDR0__DST_FABRIC_ID__SHIFT                                                       0x0
#define GCEA_ADDRNORM_LIMIT_ADDR0__INTLV_NUM_SOCKETS__SHIFT                                                   0x8
#define GCEA_ADDRNORM_LIMIT_ADDR0__INTLV_NUM_DIES__SHIFT                                                      0xa
#define GCEA_ADDRNORM_LIMIT_ADDR0__LIMIT_ADDR__SHIFT                                                          0xc
#define GCEA_ADDRNORM_LIMIT_ADDR0__DST_FABRIC_ID_MASK                                                         0x0000000FL
#define GCEA_ADDRNORM_LIMIT_ADDR0__INTLV_NUM_SOCKETS_MASK                                                     0x00000100L
#define GCEA_ADDRNORM_LIMIT_ADDR0__INTLV_NUM_DIES_MASK                                                        0x00000C00L
#define GCEA_ADDRNORM_LIMIT_ADDR0__LIMIT_ADDR_MASK                                                            0xFFFFF000L
//GCEA_ADDRNORM_BASE_ADDR1
#define GCEA_ADDRNORM_BASE_ADDR1__ADDR_RNG_VAL__SHIFT                                                         0x0
#define GCEA_ADDRNORM_BASE_ADDR1__LGCY_MMIO_HOLE_EN__SHIFT                                                    0x1
#define GCEA_ADDRNORM_BASE_ADDR1__INTLV_NUM_CHAN__SHIFT                                                       0x4
#define GCEA_ADDRNORM_BASE_ADDR1__INTLV_ADDR_SEL__SHIFT                                                       0x8
#define GCEA_ADDRNORM_BASE_ADDR1__BASE_ADDR__SHIFT                                                            0xc
#define GCEA_ADDRNORM_BASE_ADDR1__ADDR_RNG_VAL_MASK                                                           0x00000001L
#define GCEA_ADDRNORM_BASE_ADDR1__LGCY_MMIO_HOLE_EN_MASK                                                      0x00000002L
#define GCEA_ADDRNORM_BASE_ADDR1__INTLV_NUM_CHAN_MASK                                                         0x000000F0L
#define GCEA_ADDRNORM_BASE_ADDR1__INTLV_ADDR_SEL_MASK                                                         0x00000700L
#define GCEA_ADDRNORM_BASE_ADDR1__BASE_ADDR_MASK                                                              0xFFFFF000L
//GCEA_ADDRNORM_LIMIT_ADDR1
#define GCEA_ADDRNORM_LIMIT_ADDR1__DST_FABRIC_ID__SHIFT                                                       0x0
#define GCEA_ADDRNORM_LIMIT_ADDR1__INTLV_NUM_SOCKETS__SHIFT                                                   0x8
#define GCEA_ADDRNORM_LIMIT_ADDR1__INTLV_NUM_DIES__SHIFT                                                      0xa
#define GCEA_ADDRNORM_LIMIT_ADDR1__LIMIT_ADDR__SHIFT                                                          0xc
#define GCEA_ADDRNORM_LIMIT_ADDR1__DST_FABRIC_ID_MASK                                                         0x0000000FL
#define GCEA_ADDRNORM_LIMIT_ADDR1__INTLV_NUM_SOCKETS_MASK                                                     0x00000100L
#define GCEA_ADDRNORM_LIMIT_ADDR1__INTLV_NUM_DIES_MASK                                                        0x00000C00L
#define GCEA_ADDRNORM_LIMIT_ADDR1__LIMIT_ADDR_MASK                                                            0xFFFFF000L
//GCEA_ADDRNORM_OFFSET_ADDR1
#define GCEA_ADDRNORM_OFFSET_ADDR1__HI_ADDR_OFFSET_EN__SHIFT                                                  0x0
#define GCEA_ADDRNORM_OFFSET_ADDR1__HI_ADDR_OFFSET__SHIFT                                                     0x14
#define GCEA_ADDRNORM_OFFSET_ADDR1__HI_ADDR_OFFSET_EN_MASK                                                    0x00000001L
#define GCEA_ADDRNORM_OFFSET_ADDR1__HI_ADDR_OFFSET_MASK                                                       0xFFF00000L
//GCEA_ADDRNORM_HOLE_CNTL
#define GCEA_ADDRNORM_HOLE_CNTL__DRAM_HOLE_VALID__SHIFT                                                       0x0
#define GCEA_ADDRNORM_HOLE_CNTL__DRAM_HOLE_OFFSET__SHIFT                                                      0x7
#define GCEA_ADDRNORM_HOLE_CNTL__DRAM_HOLE_VALID_MASK                                                         0x00000001L
#define GCEA_ADDRNORM_HOLE_CNTL__DRAM_HOLE_OFFSET_MASK                                                        0x0000FF80L
//GCEA_ADDRDEC_BANK_CFG
#define GCEA_ADDRDEC_BANK_CFG__BANK_MASK_DRAM__SHIFT                                                          0x0
#define GCEA_ADDRDEC_BANK_CFG__BANK_MASK_GMI__SHIFT                                                           0x5
#define GCEA_ADDRDEC_BANK_CFG__BANKGROUP_SEL_DRAM__SHIFT                                                      0xa
#define GCEA_ADDRDEC_BANK_CFG__BANKGROUP_SEL_GMI__SHIFT                                                       0xd
#define GCEA_ADDRDEC_BANK_CFG__BANKGROUP_INTERLEAVE_DRAM__SHIFT                                               0x10
#define GCEA_ADDRDEC_BANK_CFG__BANKGROUP_INTERLEAVE_GMI__SHIFT                                                0x11
#define GCEA_ADDRDEC_BANK_CFG__BANK_MASK_DRAM_MASK                                                            0x0000001FL
#define GCEA_ADDRDEC_BANK_CFG__BANK_MASK_GMI_MASK                                                             0x000003E0L
#define GCEA_ADDRDEC_BANK_CFG__BANKGROUP_SEL_DRAM_MASK                                                        0x00001C00L
#define GCEA_ADDRDEC_BANK_CFG__BANKGROUP_SEL_GMI_MASK                                                         0x0000E000L
#define GCEA_ADDRDEC_BANK_CFG__BANKGROUP_INTERLEAVE_DRAM_MASK                                                 0x00010000L
#define GCEA_ADDRDEC_BANK_CFG__BANKGROUP_INTERLEAVE_GMI_MASK                                                  0x00020000L
//GCEA_ADDRDEC_MISC_CFG
#define GCEA_ADDRDEC_MISC_CFG__VCM_EN0__SHIFT                                                                 0x0
#define GCEA_ADDRDEC_MISC_CFG__VCM_EN1__SHIFT                                                                 0x1
#define GCEA_ADDRDEC_MISC_CFG__VCM_EN2__SHIFT                                                                 0x2
#define GCEA_ADDRDEC_MISC_CFG__VCM_EN3__SHIFT                                                                 0x3
#define GCEA_ADDRDEC_MISC_CFG__VCM_EN4__SHIFT                                                                 0x4
#define GCEA_ADDRDEC_MISC_CFG__PCH_MASK_DRAM__SHIFT                                                           0x8
#define GCEA_ADDRDEC_MISC_CFG__PCH_MASK_GMI__SHIFT                                                            0x9
#define GCEA_ADDRDEC_MISC_CFG__CH_MASK_DRAM__SHIFT                                                            0xc
#define GCEA_ADDRDEC_MISC_CFG__CH_MASK_GMI__SHIFT                                                             0x10
#define GCEA_ADDRDEC_MISC_CFG__CS_MASK_DRAM__SHIFT                                                            0x14
#define GCEA_ADDRDEC_MISC_CFG__CS_MASK_GMI__SHIFT                                                             0x16
#define GCEA_ADDRDEC_MISC_CFG__RM_MASK_DRAM__SHIFT                                                            0x18
#define GCEA_ADDRDEC_MISC_CFG__RM_MASK_GMI__SHIFT                                                             0x1b
#define GCEA_ADDRDEC_MISC_CFG__VCM_EN0_MASK                                                                   0x00000001L
#define GCEA_ADDRDEC_MISC_CFG__VCM_EN1_MASK                                                                   0x00000002L
#define GCEA_ADDRDEC_MISC_CFG__VCM_EN2_MASK                                                                   0x00000004L
#define GCEA_ADDRDEC_MISC_CFG__VCM_EN3_MASK                                                                   0x00000008L
#define GCEA_ADDRDEC_MISC_CFG__VCM_EN4_MASK                                                                   0x00000010L
#define GCEA_ADDRDEC_MISC_CFG__PCH_MASK_DRAM_MASK                                                             0x00000100L
#define GCEA_ADDRDEC_MISC_CFG__PCH_MASK_GMI_MASK                                                              0x00000200L
#define GCEA_ADDRDEC_MISC_CFG__CH_MASK_DRAM_MASK                                                              0x0000F000L
#define GCEA_ADDRDEC_MISC_CFG__CH_MASK_GMI_MASK                                                               0x000F0000L
#define GCEA_ADDRDEC_MISC_CFG__CS_MASK_DRAM_MASK                                                              0x00300000L
#define GCEA_ADDRDEC_MISC_CFG__CS_MASK_GMI_MASK                                                               0x00C00000L
#define GCEA_ADDRDEC_MISC_CFG__RM_MASK_DRAM_MASK                                                              0x07000000L
#define GCEA_ADDRDEC_MISC_CFG__RM_MASK_GMI_MASK                                                               0x38000000L
//GCEA_ADDRDECDRAM_ADDR_HASH_BANK0
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK0__XOR_ENABLE__SHIFT                                                   0x0
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK0__COL_XOR__SHIFT                                                      0x1
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK0__ROW_XOR__SHIFT                                                      0xe
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK0__XOR_ENABLE_MASK                                                     0x00000001L
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK0__COL_XOR_MASK                                                        0x00003FFEL
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK0__ROW_XOR_MASK                                                        0xFFFFC000L
//GCEA_ADDRDECDRAM_ADDR_HASH_BANK1
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK1__XOR_ENABLE__SHIFT                                                   0x0
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK1__COL_XOR__SHIFT                                                      0x1
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK1__ROW_XOR__SHIFT                                                      0xe
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK1__XOR_ENABLE_MASK                                                     0x00000001L
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK1__COL_XOR_MASK                                                        0x00003FFEL
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK1__ROW_XOR_MASK                                                        0xFFFFC000L
//GCEA_ADDRDECDRAM_ADDR_HASH_BANK2
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK2__XOR_ENABLE__SHIFT                                                   0x0
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK2__COL_XOR__SHIFT                                                      0x1
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK2__ROW_XOR__SHIFT                                                      0xe
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK2__XOR_ENABLE_MASK                                                     0x00000001L
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK2__COL_XOR_MASK                                                        0x00003FFEL
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK2__ROW_XOR_MASK                                                        0xFFFFC000L
//GCEA_ADDRDECDRAM_ADDR_HASH_BANK3
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK3__XOR_ENABLE__SHIFT                                                   0x0
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK3__COL_XOR__SHIFT                                                      0x1
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK3__ROW_XOR__SHIFT                                                      0xe
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK3__XOR_ENABLE_MASK                                                     0x00000001L
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK3__COL_XOR_MASK                                                        0x00003FFEL
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK3__ROW_XOR_MASK                                                        0xFFFFC000L
//GCEA_ADDRDECDRAM_ADDR_HASH_BANK4
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK4__XOR_ENABLE__SHIFT                                                   0x0
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK4__COL_XOR__SHIFT                                                      0x1
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK4__ROW_XOR__SHIFT                                                      0xe
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK4__XOR_ENABLE_MASK                                                     0x00000001L
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK4__COL_XOR_MASK                                                        0x00003FFEL
#define GCEA_ADDRDECDRAM_ADDR_HASH_BANK4__ROW_XOR_MASK                                                        0xFFFFC000L
//GCEA_ADDRDECDRAM_ADDR_HASH_PC
#define GCEA_ADDRDECDRAM_ADDR_HASH_PC__XOR_ENABLE__SHIFT                                                      0x0
#define GCEA_ADDRDECDRAM_ADDR_HASH_PC__COL_XOR__SHIFT                                                         0x1
#define GCEA_ADDRDECDRAM_ADDR_HASH_PC__ROW_XOR__SHIFT                                                         0xe
#define GCEA_ADDRDECDRAM_ADDR_HASH_PC__XOR_ENABLE_MASK                                                        0x00000001L
#define GCEA_ADDRDECDRAM_ADDR_HASH_PC__COL_XOR_MASK                                                           0x00003FFEL
#define GCEA_ADDRDECDRAM_ADDR_HASH_PC__ROW_XOR_MASK                                                           0xFFFFC000L
//GCEA_ADDRDECDRAM_ADDR_HASH_PC2
#define GCEA_ADDRDECDRAM_ADDR_HASH_PC2__BANK_XOR__SHIFT                                                       0x0
#define GCEA_ADDRDECDRAM_ADDR_HASH_PC2__BANK_XOR_MASK                                                         0x0000001FL
//GCEA_ADDRDECDRAM_ADDR_HASH_CS0
#define GCEA_ADDRDECDRAM_ADDR_HASH_CS0__XOR_ENABLE__SHIFT                                                     0x0
#define GCEA_ADDRDECDRAM_ADDR_HASH_CS0__NA_XOR__SHIFT                                                         0x1
#define GCEA_ADDRDECDRAM_ADDR_HASH_CS0__XOR_ENABLE_MASK                                                       0x00000001L
#define GCEA_ADDRDECDRAM_ADDR_HASH_CS0__NA_XOR_MASK                                                           0xFFFFFFFEL
//GCEA_ADDRDECDRAM_ADDR_HASH_CS1
#define GCEA_ADDRDECDRAM_ADDR_HASH_CS1__XOR_ENABLE__SHIFT                                                     0x0
#define GCEA_ADDRDECDRAM_ADDR_HASH_CS1__NA_XOR__SHIFT                                                         0x1
#define GCEA_ADDRDECDRAM_ADDR_HASH_CS1__XOR_ENABLE_MASK                                                       0x00000001L
#define GCEA_ADDRDECDRAM_ADDR_HASH_CS1__NA_XOR_MASK                                                           0xFFFFFFFEL
//GCEA_ADDRDECDRAM_HARVEST_ENABLE
#define GCEA_ADDRDECDRAM_HARVEST_ENABLE__FORCE_B3_EN__SHIFT                                                   0x0
#define GCEA_ADDRDECDRAM_HARVEST_ENABLE__FORCE_B3_VAL__SHIFT                                                  0x1
#define GCEA_ADDRDECDRAM_HARVEST_ENABLE__FORCE_B4_EN__SHIFT                                                   0x2
#define GCEA_ADDRDECDRAM_HARVEST_ENABLE__FORCE_B4_VAL__SHIFT                                                  0x3
#define GCEA_ADDRDECDRAM_HARVEST_ENABLE__FORCE_B3_EN_MASK                                                     0x00000001L
#define GCEA_ADDRDECDRAM_HARVEST_ENABLE__FORCE_B3_VAL_MASK                                                    0x00000002L
#define GCEA_ADDRDECDRAM_HARVEST_ENABLE__FORCE_B4_EN_MASK                                                     0x00000004L
#define GCEA_ADDRDECDRAM_HARVEST_ENABLE__FORCE_B4_VAL_MASK                                                    0x00000008L
//GCEA_ADDRDEC0_BASE_ADDR_CS0
#define GCEA_ADDRDEC0_BASE_ADDR_CS0__CS_ENABLE__SHIFT                                                         0x0
#define GCEA_ADDRDEC0_BASE_ADDR_CS0__BASE_ADDR__SHIFT                                                         0x1
#define GCEA_ADDRDEC0_BASE_ADDR_CS0__CS_ENABLE_MASK                                                           0x00000001L
#define GCEA_ADDRDEC0_BASE_ADDR_CS0__BASE_ADDR_MASK                                                           0xFFFFFFFEL
//GCEA_ADDRDEC0_BASE_ADDR_CS1
#define GCEA_ADDRDEC0_BASE_ADDR_CS1__CS_ENABLE__SHIFT                                                         0x0
#define GCEA_ADDRDEC0_BASE_ADDR_CS1__BASE_ADDR__SHIFT                                                         0x1
#define GCEA_ADDRDEC0_BASE_ADDR_CS1__CS_ENABLE_MASK                                                           0x00000001L
#define GCEA_ADDRDEC0_BASE_ADDR_CS1__BASE_ADDR_MASK                                                           0xFFFFFFFEL
//GCEA_ADDRDEC0_BASE_ADDR_CS2
#define GCEA_ADDRDEC0_BASE_ADDR_CS2__CS_ENABLE__SHIFT                                                         0x0
#define GCEA_ADDRDEC0_BASE_ADDR_CS2__BASE_ADDR__SHIFT                                                         0x1
#define GCEA_ADDRDEC0_BASE_ADDR_CS2__CS_ENABLE_MASK                                                           0x00000001L
#define GCEA_ADDRDEC0_BASE_ADDR_CS2__BASE_ADDR_MASK                                                           0xFFFFFFFEL
//GCEA_ADDRDEC0_BASE_ADDR_CS3
#define GCEA_ADDRDEC0_BASE_ADDR_CS3__CS_ENABLE__SHIFT                                                         0x0
#define GCEA_ADDRDEC0_BASE_ADDR_CS3__BASE_ADDR__SHIFT                                                         0x1
#define GCEA_ADDRDEC0_BASE_ADDR_CS3__CS_ENABLE_MASK                                                           0x00000001L
#define GCEA_ADDRDEC0_BASE_ADDR_CS3__BASE_ADDR_MASK                                                           0xFFFFFFFEL
//GCEA_ADDRDEC0_BASE_ADDR_SECCS0
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS0__CS_ENABLE__SHIFT                                                      0x0
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS0__BASE_ADDR__SHIFT                                                      0x1
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS0__CS_ENABLE_MASK                                                        0x00000001L
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS0__BASE_ADDR_MASK                                                        0xFFFFFFFEL
//GCEA_ADDRDEC0_BASE_ADDR_SECCS1
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS1__CS_ENABLE__SHIFT                                                      0x0
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS1__BASE_ADDR__SHIFT                                                      0x1
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS1__CS_ENABLE_MASK                                                        0x00000001L
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS1__BASE_ADDR_MASK                                                        0xFFFFFFFEL
//GCEA_ADDRDEC0_BASE_ADDR_SECCS2
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS2__CS_ENABLE__SHIFT                                                      0x0
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS2__BASE_ADDR__SHIFT                                                      0x1
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS2__CS_ENABLE_MASK                                                        0x00000001L
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS2__BASE_ADDR_MASK                                                        0xFFFFFFFEL
//GCEA_ADDRDEC0_BASE_ADDR_SECCS3
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS3__CS_ENABLE__SHIFT                                                      0x0
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS3__BASE_ADDR__SHIFT                                                      0x1
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS3__CS_ENABLE_MASK                                                        0x00000001L
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS3__BASE_ADDR_MASK                                                        0xFFFFFFFEL
//GCEA_ADDRDEC0_ADDR_MASK_CS01
#define GCEA_ADDRDEC0_ADDR_MASK_CS01__ADDR_MASK__SHIFT                                                        0x1
#define GCEA_ADDRDEC0_ADDR_MASK_CS01__ADDR_MASK_MASK                                                          0xFFFFFFFEL
//GCEA_ADDRDEC0_ADDR_MASK_CS23
#define GCEA_ADDRDEC0_ADDR_MASK_CS23__ADDR_MASK__SHIFT                                                        0x1
#define GCEA_ADDRDEC0_ADDR_MASK_CS23__ADDR_MASK_MASK                                                          0xFFFFFFFEL
//GCEA_ADDRDEC0_ADDR_MASK_SECCS01
#define GCEA_ADDRDEC0_ADDR_MASK_SECCS01__ADDR_MASK__SHIFT                                                     0x1
#define GCEA_ADDRDEC0_ADDR_MASK_SECCS01__ADDR_MASK_MASK                                                       0xFFFFFFFEL
//GCEA_ADDRDEC0_ADDR_MASK_SECCS23
#define GCEA_ADDRDEC0_ADDR_MASK_SECCS23__ADDR_MASK__SHIFT                                                     0x1
#define GCEA_ADDRDEC0_ADDR_MASK_SECCS23__ADDR_MASK_MASK                                                       0xFFFFFFFEL
//GCEA_ADDRDEC0_ADDR_CFG_CS01
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_BANK_GROUPS__SHIFT                                                   0x2
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_RM__SHIFT                                                            0x4
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_ROW_LO__SHIFT                                                        0x8
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_ROW_HI__SHIFT                                                        0xc
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_COL__SHIFT                                                           0x10
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_BANKS__SHIFT                                                         0x14
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_BANK_GROUPS_MASK                                                     0x0000000CL
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_RM_MASK                                                              0x00000030L
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_ROW_LO_MASK                                                          0x00000F00L
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_ROW_HI_MASK                                                          0x0000F000L
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_COL_MASK                                                             0x000F0000L
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_BANKS_MASK                                                           0x00300000L
//GCEA_ADDRDEC0_ADDR_CFG_CS23
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_BANK_GROUPS__SHIFT                                                   0x2
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_RM__SHIFT                                                            0x4
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_ROW_LO__SHIFT                                                        0x8
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_ROW_HI__SHIFT                                                        0xc
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_COL__SHIFT                                                           0x10
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_BANKS__SHIFT                                                         0x14
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_BANK_GROUPS_MASK                                                     0x0000000CL
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_RM_MASK                                                              0x00000030L
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_ROW_LO_MASK                                                          0x00000F00L
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_ROW_HI_MASK                                                          0x0000F000L
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_COL_MASK                                                             0x000F0000L
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_BANKS_MASK                                                           0x00300000L
//GCEA_ADDRDEC0_ADDR_SEL_CS01
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__BANK0__SHIFT                                                             0x0
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__BANK1__SHIFT                                                             0x4
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__BANK2__SHIFT                                                             0x8
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__BANK3__SHIFT                                                             0xc
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__BANK4__SHIFT                                                             0x10
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__ROW_LO__SHIFT                                                            0x18
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__ROW_HI__SHIFT                                                            0x1c
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__BANK0_MASK                                                               0x0000000FL
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__BANK1_MASK                                                               0x000000F0L
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__BANK2_MASK                                                               0x00000F00L
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__BANK3_MASK                                                               0x0000F000L
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__BANK4_MASK                                                               0x000F0000L
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__ROW_LO_MASK                                                              0x0F000000L
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__ROW_HI_MASK                                                              0xF0000000L
//GCEA_ADDRDEC0_ADDR_SEL_CS23
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__BANK0__SHIFT                                                             0x0
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__BANK1__SHIFT                                                             0x4
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__BANK2__SHIFT                                                             0x8
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__BANK3__SHIFT                                                             0xc
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__BANK4__SHIFT                                                             0x10
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__ROW_LO__SHIFT                                                            0x18
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__ROW_HI__SHIFT                                                            0x1c
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__BANK0_MASK                                                               0x0000000FL
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__BANK1_MASK                                                               0x000000F0L
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__BANK2_MASK                                                               0x00000F00L
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__BANK3_MASK                                                               0x0000F000L
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__BANK4_MASK                                                               0x000F0000L
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__ROW_LO_MASK                                                              0x0F000000L
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__ROW_HI_MASK                                                              0xF0000000L
//GCEA_ADDRDEC0_COL_SEL_LO_CS01
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL0__SHIFT                                                            0x0
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL1__SHIFT                                                            0x4
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL2__SHIFT                                                            0x8
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL3__SHIFT                                                            0xc
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL4__SHIFT                                                            0x10
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL5__SHIFT                                                            0x14
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL6__SHIFT                                                            0x18
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL7__SHIFT                                                            0x1c
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL0_MASK                                                              0x0000000FL
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL1_MASK                                                              0x000000F0L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL2_MASK                                                              0x00000F00L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL3_MASK                                                              0x0000F000L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL4_MASK                                                              0x000F0000L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL5_MASK                                                              0x00F00000L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL6_MASK                                                              0x0F000000L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL7_MASK                                                              0xF0000000L
//GCEA_ADDRDEC0_COL_SEL_LO_CS23
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL0__SHIFT                                                            0x0
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL1__SHIFT                                                            0x4
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL2__SHIFT                                                            0x8
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL3__SHIFT                                                            0xc
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL4__SHIFT                                                            0x10
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL5__SHIFT                                                            0x14
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL6__SHIFT                                                            0x18
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL7__SHIFT                                                            0x1c
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL0_MASK                                                              0x0000000FL
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL1_MASK                                                              0x000000F0L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL2_MASK                                                              0x00000F00L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL3_MASK                                                              0x0000F000L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL4_MASK                                                              0x000F0000L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL5_MASK                                                              0x00F00000L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL6_MASK                                                              0x0F000000L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL7_MASK                                                              0xF0000000L
//GCEA_ADDRDEC0_COL_SEL_HI_CS01
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL8__SHIFT                                                            0x0
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL9__SHIFT                                                            0x4
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL10__SHIFT                                                           0x8
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL11__SHIFT                                                           0xc
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL12__SHIFT                                                           0x10
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL13__SHIFT                                                           0x14
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL14__SHIFT                                                           0x18
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL15__SHIFT                                                           0x1c
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL8_MASK                                                              0x0000000FL
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL9_MASK                                                              0x000000F0L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL10_MASK                                                             0x00000F00L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL11_MASK                                                             0x0000F000L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL12_MASK                                                             0x000F0000L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL13_MASK                                                             0x00F00000L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL14_MASK                                                             0x0F000000L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL15_MASK                                                             0xF0000000L
//GCEA_ADDRDEC0_COL_SEL_HI_CS23
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL8__SHIFT                                                            0x0
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL9__SHIFT                                                            0x4
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL10__SHIFT                                                           0x8
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL11__SHIFT                                                           0xc
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL12__SHIFT                                                           0x10
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL13__SHIFT                                                           0x14
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL14__SHIFT                                                           0x18
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL15__SHIFT                                                           0x1c
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL8_MASK                                                              0x0000000FL
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL9_MASK                                                              0x000000F0L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL10_MASK                                                             0x00000F00L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL11_MASK                                                             0x0000F000L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL12_MASK                                                             0x000F0000L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL13_MASK                                                             0x00F00000L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL14_MASK                                                             0x0F000000L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL15_MASK                                                             0xF0000000L
//GCEA_ADDRDEC0_RM_SEL_CS01
#define GCEA_ADDRDEC0_RM_SEL_CS01__RM0__SHIFT                                                                 0x0
#define GCEA_ADDRDEC0_RM_SEL_CS01__RM1__SHIFT                                                                 0x4
#define GCEA_ADDRDEC0_RM_SEL_CS01__RM2__SHIFT                                                                 0x8
#define GCEA_ADDRDEC0_RM_SEL_CS01__CHAN_BIT__SHIFT                                                            0xc
#define GCEA_ADDRDEC0_RM_SEL_CS01__INVERT_ROW_MSBS_EVEN__SHIFT                                                0x10
#define GCEA_ADDRDEC0_RM_SEL_CS01__INVERT_ROW_MSBS_ODD__SHIFT                                                 0x12
#define GCEA_ADDRDEC0_RM_SEL_CS01__RM0_MASK                                                                   0x0000000FL
#define GCEA_ADDRDEC0_RM_SEL_CS01__RM1_MASK                                                                   0x000000F0L
#define GCEA_ADDRDEC0_RM_SEL_CS01__RM2_MASK                                                                   0x00000F00L
#define GCEA_ADDRDEC0_RM_SEL_CS01__CHAN_BIT_MASK                                                              0x0000F000L
#define GCEA_ADDRDEC0_RM_SEL_CS01__INVERT_ROW_MSBS_EVEN_MASK                                                  0x00030000L
#define GCEA_ADDRDEC0_RM_SEL_CS01__INVERT_ROW_MSBS_ODD_MASK                                                   0x000C0000L
//GCEA_ADDRDEC0_RM_SEL_CS23
#define GCEA_ADDRDEC0_RM_SEL_CS23__RM0__SHIFT                                                                 0x0
#define GCEA_ADDRDEC0_RM_SEL_CS23__RM1__SHIFT                                                                 0x4
#define GCEA_ADDRDEC0_RM_SEL_CS23__RM2__SHIFT                                                                 0x8
#define GCEA_ADDRDEC0_RM_SEL_CS23__CHAN_BIT__SHIFT                                                            0xc
#define GCEA_ADDRDEC0_RM_SEL_CS23__INVERT_ROW_MSBS_EVEN__SHIFT                                                0x10
#define GCEA_ADDRDEC0_RM_SEL_CS23__INVERT_ROW_MSBS_ODD__SHIFT                                                 0x12
#define GCEA_ADDRDEC0_RM_SEL_CS23__RM0_MASK                                                                   0x0000000FL
#define GCEA_ADDRDEC0_RM_SEL_CS23__RM1_MASK                                                                   0x000000F0L
#define GCEA_ADDRDEC0_RM_SEL_CS23__RM2_MASK                                                                   0x00000F00L
#define GCEA_ADDRDEC0_RM_SEL_CS23__CHAN_BIT_MASK                                                              0x0000F000L
#define GCEA_ADDRDEC0_RM_SEL_CS23__INVERT_ROW_MSBS_EVEN_MASK                                                  0x00030000L
#define GCEA_ADDRDEC0_RM_SEL_CS23__INVERT_ROW_MSBS_ODD_MASK                                                   0x000C0000L
//GCEA_ADDRDEC0_RM_SEL_SECCS01
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__RM0__SHIFT                                                              0x0
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__RM1__SHIFT                                                              0x4
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__RM2__SHIFT                                                              0x8
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__CHAN_BIT__SHIFT                                                         0xc
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__INVERT_ROW_MSBS_EVEN__SHIFT                                             0x10
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__INVERT_ROW_MSBS_ODD__SHIFT                                              0x12
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__RM0_MASK                                                                0x0000000FL
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__RM1_MASK                                                                0x000000F0L
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__RM2_MASK                                                                0x00000F00L
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__CHAN_BIT_MASK                                                           0x0000F000L
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__INVERT_ROW_MSBS_EVEN_MASK                                               0x00030000L
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__INVERT_ROW_MSBS_ODD_MASK                                                0x000C0000L
//GCEA_ADDRDEC0_RM_SEL_SECCS23
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__RM0__SHIFT                                                              0x0
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__RM1__SHIFT                                                              0x4
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__RM2__SHIFT                                                              0x8
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__CHAN_BIT__SHIFT                                                         0xc
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__INVERT_ROW_MSBS_EVEN__SHIFT                                             0x10
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__INVERT_ROW_MSBS_ODD__SHIFT                                              0x12
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__RM0_MASK                                                                0x0000000FL
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__RM1_MASK                                                                0x000000F0L
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__RM2_MASK                                                                0x00000F00L
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__CHAN_BIT_MASK                                                           0x0000F000L
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__INVERT_ROW_MSBS_EVEN_MASK                                               0x00030000L
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__INVERT_ROW_MSBS_ODD_MASK                                                0x000C0000L
//GCEA_ADDRDEC1_BASE_ADDR_CS0
#define GCEA_ADDRDEC1_BASE_ADDR_CS0__CS_ENABLE__SHIFT                                                         0x0
#define GCEA_ADDRDEC1_BASE_ADDR_CS0__BASE_ADDR__SHIFT                                                         0x1
#define GCEA_ADDRDEC1_BASE_ADDR_CS0__CS_ENABLE_MASK                                                           0x00000001L
#define GCEA_ADDRDEC1_BASE_ADDR_CS0__BASE_ADDR_MASK                                                           0xFFFFFFFEL
//GCEA_ADDRDEC1_BASE_ADDR_CS1
#define GCEA_ADDRDEC1_BASE_ADDR_CS1__CS_ENABLE__SHIFT                                                         0x0
#define GCEA_ADDRDEC1_B