/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetAddressContainer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketInputStream;
import java.net.SocketOutputStream;
import java.net.UnknownHostException;
import java.security.AccessController;
import sun.net.ConnectionResetException;
import sun.net.NetHooks;
import sun.net.ResourceManager;
import sun.security.action.LoadLibraryAction;

abstract class AbstractPlainSocketImpl
extends SocketImpl {
    int timeout;
    private int trafficClass;
    private boolean shut_rd = false;
    private boolean shut_wr = false;
    private SocketInputStream socketInputStream = null;
    protected int fdUseCount = 0;
    protected final Object fdLock = new Object();
    protected boolean closePending = false;
    private int CONNECTION_NOT_RESET = 0;
    private int CONNECTION_RESET_PENDING = 1;
    private int CONNECTION_RESET = 2;
    private int resetState;
    private final Object resetLock = new Object();
    protected boolean stream;
    public static final int SHUT_RD = 0;
    public static final int SHUT_WR = 1;

    AbstractPlainSocketImpl() {
    }

    @Override
    protected synchronized void create(boolean bl) throws IOException {
        this.stream = bl;
        if (!bl) {
            ResourceManager.beforeUdpCreate();
            this.fd = new FileDescriptor();
            try {
                this.socketCreate(false);
            }
            catch (IOException iOException) {
                ResourceManager.afterUdpClose();
                this.fd = null;
                throw iOException;
            }
        } else {
            this.fd = new FileDescriptor();
            this.socketCreate(true);
        }
        if (this.socket != null) {
            this.socket.setCreated();
        }
        if (this.serverSocket != null) {
            this.serverSocket.setCreated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connect(String string, int n) throws UnknownHostException, IOException {
        boolean bl = false;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.port = n;
            this.address = inetAddress;
            this.connectToAddress(inetAddress, n, this.timeout);
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    this.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected void connect(InetAddress inetAddress, int n) throws IOException {
        this.port = n;
        this.address = inetAddress;
        try {
            this.connectToAddress(inetAddress, n, this.timeout);
            return;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connect(SocketAddress socketAddress, int n) throws IOException {
        boolean bl = false;
        try {
            if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("unsupported address type");
            }
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            if (inetSocketAddress.isUnresolved()) {
                throw new UnknownHostException(inetSocketAddress.getHostName());
            }
            this.port = inetSocketAddress.getPort();
            this.address = inetSocketAddress.getAddress();
            this.connectToAddress(this.address, this.port, n);
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    this.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void connectToAddress(InetAddress inetAddress, int n, int n2) throws IOException {
        if (inetAddress.isAnyLocalAddress()) {
            this.doConnect(InetAddress.getLocalHost(), n, n2);
        } else {
            this.doConnect(inetAddress, n, n2);
        }
    }

    @Override
    public void setOption(int n, Object object) throws SocketException {
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket Closed");
        }
        boolean bl = true;
        switch (n) {
            case 128: {
                if (object == null || !(object instanceof Integer) && !(object instanceof Boolean)) {
                    throw new SocketException("Bad parameter for option");
                }
                if (!(object instanceof Boolean)) break;
                bl = false;
                break;
            }
            case 4102: {
                if (object == null || !(object instanceof Integer)) {
                    throw new SocketException("Bad parameter for SO_TIMEOUT");
                }
                int n2 = (Integer)object;
                if (n2 < 0) {
                    throw new IllegalArgumentException("timeout < 0");
                }
                this.timeout = n2;
                break;
            }
            case 3: {
                if (object == null || !(object instanceof Integer)) {
                    throw new SocketException("bad argument for IP_TOS");
                }
                this.trafficClass = (Integer)object;
                break;
            }
            case 15: {
                throw new SocketException("Cannot re-bind socket");
            }
            case 1: {
                if (object == null || !(object instanceof Boolean)) {
                    throw new SocketException("bad parameter for TCP_NODELAY");
                }
                bl = (Boolean)object;
                break;
            }
            case 4097: 
            case 4098: {
                if (object != null && object instanceof Integer && (Integer)object > 0) break;
                throw new SocketException("bad parameter for SO_SNDBUF or SO_RCVBUF");
            }
            case 8: {
                if (object == null || !(object instanceof Boolean)) {
                    throw new SocketException("bad parameter for SO_KEEPALIVE");
                }
                bl = (Boolean)object;
                break;
            }
            case 4099: {
                if (object == null || !(object instanceof Boolean)) {
                    throw new SocketException("bad parameter for SO_OOBINLINE");
                }
                bl = (Boolean)object;
                break;
            }
            case 4: {
                if (object == null || !(object instanceof Boolean)) {
                    throw new SocketException("bad parameter for SO_REUSEADDR");
                }
                bl = (Boolean)object;
                break;
            }
            default: {
                throw new SocketException("unrecognized TCP option: " + n);
            }
        }
        this.socketSetOption(n, bl, object);
    }

    @Override
    public Object getOption(int n) throws SocketException {
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket Closed");
        }
        if (n == 4102) {
            return new Integer(this.timeout);
        }
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = this.socketGetOption(n, null);
                return n2 != -1;
            }
            case 4099: {
                n2 = this.socketGetOption(n, null);
                return n2 != -1;
            }
            case 128: {
                n2 = this.socketGetOption(n, null);
                return n2 == -1 ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)new Integer(n2);
            }
            case 4: {
                n2 = this.socketGetOption(n, null);
                return n2 != -1;
            }
            case 15: {
                InetAddressContainer inetAddressContainer = new InetAddressContainer();
                n2 = this.socketGetOption(n, inetAddressContainer);
                return inetAddressContainer.addr;
            }
            case 4097: 
            case 4098: {
                n2 = this.socketGetOption(n, null);
                return new Integer(n2);
            }
            case 3: {
                n2 = this.socketGetOption(n, null);
                if (n2 == -1) {
                    return new Integer(this.trafficClass);
                }
                return new Integer(n2);
            }
            case 8: {
                n2 = this.socketGetOption(n, null);
                return n2 != -1;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doConnect(InetAddress inetAddress, int n, int n2) throws IOException {
        Object object = this.fdLock;
        synchronized (object) {
            if (!(this.closePending || this.socket != null && this.socket.isBound())) {
                NetHooks.beforeTcpConnect(this.fd, inetAddress, n);
            }
        }
        try {
            this.acquireFD();
            try {
                this.socketConnect(inetAddress, n, n2);
                object = this.fdLock;
                synchronized (object) {
                    if (this.closePending) {
                        throw new SocketException("Socket closed");
                    }
                }
                if (this.socket != null) {
                    this.socket.setBound();
                    this.socket.setConnected();
                }
            }
            finally {
                this.releaseFD();
            }
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void bind(InetAddress inetAddress, int n) throws IOException {
        Object object = this.fdLock;
        synchronized (object) {
            if (!(this.closePending || this.socket != null && this.socket.isBound())) {
                NetHooks.beforeTcpBind(this.fd, inetAddress, n);
            }
        }
        this.socketBind(inetAddress, n);
        if (this.socket != null) {
            this.socket.setBound();
        }
        if (this.serverSocket != null) {
            this.serverSocket.setBound();
        }
    }

    @Override
    protected synchronized void listen(int n) throws IOException {
        this.socketListen(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void accept(SocketImpl socketImpl) throws IOException {
        this.acquireFD();
        try {
            this.socketAccept(socketImpl);
        }
        finally {
            this.releaseFD();
        }
    }

    @Override
    protected synchronized InputStream getInputStream() throws IOException {
        if (this.isClosedOrPending()) {
            throw new IOException("Socket Closed");
        }
        if (this.shut_rd) {
            throw new IOException("Socket input is shutdown");
        }
        if (this.socketInputStream == null) {
            this.socketInputStream = new SocketInputStream(this);
        }
        return this.socketInputStream;
    }

    void setInputStream(SocketInputStream socketInputStream) {
        this.socketInputStream = socketInputStream;
    }

    @Override
    protected synchronized OutputStream getOutputStream() throws IOException {
        if (this.isClosedOrPending()) {
            throw new IOException("Socket Closed");
        }
        if (this.shut_wr) {
            throw new IOException("Socket output is shutdown");
        }
        return new SocketOutputStream(this);
    }

    void setFileDescriptor(FileDescriptor fileDescriptor) {
        this.fd = fileDescriptor;
    }

    void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    void setPort(int n) {
        this.port = n;
    }

    void setLocalPort(int n) {
        this.localport = n;
    }

    @Override
    protected synchronized int available() throws IOException {
        if (this.isClosedOrPending()) {
            throw new IOException("Stream closed.");
        }
        if (this.isConnectionReset()) {
            return 0;
        }
        int n = 0;
        try {
            n = this.socketAvailable();
            if (n == 0 && this.isConnectionResetPending()) {
                this.setConnectionReset();
            }
        }
        catch (ConnectionResetException connectionResetException) {
            this.setConnectionResetPending();
            try {
                n = this.socketAvailable();
                if (n == 0) {
                    this.setConnectionReset();
                }
            }
            catch (ConnectionResetException connectionResetException2) {
                // empty catch block
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        Object object = this.fdLock;
        synchronized (object) {
            if (this.fd != null) {
                if (!this.stream) {
                    ResourceManager.afterUdpClose();
                }
                if (this.fdUseCount == 0) {
                    if (this.closePending) {
                        return;
                    }
                    this.closePending = true;
                    try {
                        this.socketPreClose();
                    }
                    finally {
                        this.socketClose();
                    }
                    this.fd = null;
                    return;
                }
                if (!this.closePending) {
                    this.closePending = true;
                    --this.fdUseCount;
                    this.socketPreClose();
                }
            }
        }
    }

    @Override
    void reset() throws IOException {
        if (this.fd != null) {
            this.socketClose();
        }
        this.fd = null;
        super.reset();
    }

    @Override
    protected void shutdownInput() throws IOException {
        if (this.fd != null) {
            this.socketShutdown(0);
            if (this.socketInputStream != null) {
                this.socketInputStream.setEOF(true);
            }
            this.shut_rd = true;
        }
    }

    @Override
    protected void shutdownOutput() throws IOException {
        if (this.fd != null) {
            this.socketShutdown(1);
            this.shut_wr = true;
        }
    }

    @Override
    protected boolean supportsUrgentData() {
        return true;
    }

    @Override
    protected void sendUrgentData(int n) throws IOException {
        if (this.fd == null) {
            throw new IOException("Socket Closed");
        }
        this.socketSendUrgentData(n);
    }

    protected void finalize() throws IOException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileDescriptor acquireFD() {
        Object object = this.fdLock;
        synchronized (object) {
            ++this.fdUseCount;
            return this.fd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseFD() {
        Object object = this.fdLock;
        synchronized (object) {
            --this.fdUseCount;
            if (this.fdUseCount == -1 && this.fd != null) {
                try {
                    this.socketClose();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.fd = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionReset() {
        Object object = this.resetLock;
        synchronized (object) {
            return this.resetState == this.CONNECTION_RESET;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionResetPending() {
        Object object = this.resetLock;
        synchronized (object) {
            return this.resetState == this.CONNECTION_RESET_PENDING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionReset() {
        Object object = this.resetLock;
        synchronized (object) {
            this.resetState = this.CONNECTION_RESET;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionResetPending() {
        Object object = this.resetLock;
        synchronized (object) {
            if (this.resetState == this.CONNECTION_NOT_RESET) {
                this.resetState = this.CONNECTION_RESET_PENDING;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosedOrPending() {
        Object object = this.fdLock;
        synchronized (object) {
            return this.closePending || this.fd == null;
            {
            }
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    private void socketPreClose() throws IOException {
        this.socketClose0(true);
    }

    protected void socketClose() throws IOException {
        this.socketClose0(false);
    }

    abstract void socketCreate(boolean var1) throws IOException;

    abstract void socketConnect(InetAddress var1, int var2, int var3) throws IOException;

    abstract void socketBind(InetAddress var1, int var2) throws IOException;

    abstract void socketListen(int var1) throws IOException;

    abstract void socketAccept(SocketImpl var1) throws IOException;

    abstract int socketAvailable() throws IOException;

    abstract void socketClose0(boolean var1) throws IOException;

    abstract void socketShutdown(int var1) throws IOException;

    abstract void socketSetOption(int var1, boolean var2, Object var3) throws SocketException;

    abstract int socketGetOption(int var1, Object var2) throws SocketException;

    abstract void socketSendUrgentData(int var1) throws IOException;

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
    }
}

