/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import sun.misc.IoTrace;
import sun.nio.ch.FileChannelImpl;

public class FileOutputStream
extends OutputStream {
    private final FileDescriptor fd;
    private final String path;
    private final boolean append;
    private FileChannel channel;
    private final Object closeLock = new Object();
    private volatile boolean closed = false;
    private static final ThreadLocal<Boolean> runningFinalize = new ThreadLocal();

    private static boolean isRunningFinalize() {
        Boolean bl = runningFinalize.get();
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public FileOutputStream(String string) throws FileNotFoundException {
        this(string != null ? new File(string) : null, false);
    }

    public FileOutputStream(String string, boolean bl) throws FileNotFoundException {
        this(string != null ? new File(string) : null, bl);
    }

    public FileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public FileOutputStream(File file, boolean bl) throws FileNotFoundException {
        String string = file != null ? file.getPath() : null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(string);
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (file.isInvalid()) {
            throw new FileNotFoundException("Invalid file path");
        }
        this.fd = new FileDescriptor();
        this.append = bl;
        this.path = string;
        this.fd.incrementAndGetUseCount();
        this.open(string, bl);
    }

    public FileOutputStream(FileDescriptor fileDescriptor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        if (securityManager != null) {
            securityManager.checkWrite(fileDescriptor);
        }
        this.fd = fileDescriptor;
        this.path = null;
        this.append = false;
        this.fd.incrementAndGetUseCount();
    }

    private native void open(String var1, boolean var2) throws FileNotFoundException;

    private native void write(int var1, boolean var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) throws IOException {
        Object object = IoTrace.fileWriteBegin(this.path);
        int n2 = 0;
        try {
            this.write(n, this.append);
            n2 = 1;
        }
        finally {
            IoTrace.fileWriteEnd(object, n2);
        }
    }

    private native void writeBytes(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray) throws IOException {
        Object object = IoTrace.fileWriteBegin(this.path);
        int n = 0;
        try {
            this.writeBytes(byArray, 0, byArray.length, this.append);
            n = byArray.length;
        }
        finally {
            IoTrace.fileWriteEnd(object, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        Object object = IoTrace.fileWriteBegin(this.path);
        int n3 = 0;
        try {
            this.writeBytes(byArray, n, n2, this.append);
            n3 = n2;
        }
        finally {
            IoTrace.fileWriteEnd(object, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        int n;
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.channel != null) {
            this.fd.decrementAndGetUseCount();
            this.channel.close();
        }
        if ((n = this.fd.decrementAndGetUseCount()) <= 0 || !FileOutputStream.isRunningFinalize()) {
            this.close0();
        }
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileOutputStream fileOutputStream = this;
        synchronized (fileOutputStream) {
            if (this.channel == null) {
                this.channel = FileChannelImpl.open(this.fd, this.path, false, true, this.append, this);
                this.fd.incrementAndGetUseCount();
            }
            return this.channel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws IOException {
        if (this.fd != null) {
            if (this.fd == FileDescriptor.out || this.fd == FileDescriptor.err) {
                this.flush();
            } else {
                runningFinalize.set(Boolean.TRUE);
                try {
                    this.close();
                }
                finally {
                    runningFinalize.set(Boolean.FALSE);
                }
            }
        }
    }

    private native void close0() throws IOException;

    private static native void initIDs();

    static {
        FileOutputStream.initIDs();
    }
}

