/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Arrays;
import java.util.IntSummaryStatistics;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSpliterators;
import java.util.stream.StreamSupport;
import java.util.stream.Streams;

public interface IntStream
extends BaseStream<Integer, IntStream> {
    public IntStream filter(IntPredicate var1);

    public IntStream map(IntUnaryOperator var1);

    public <U> Stream<U> mapToObj(IntFunction<? extends U> var1);

    public LongStream mapToLong(IntToLongFunction var1);

    public DoubleStream mapToDouble(IntToDoubleFunction var1);

    public IntStream flatMap(IntFunction<? extends IntStream> var1);

    public IntStream distinct();

    public IntStream sorted();

    public IntStream peek(IntConsumer var1);

    public IntStream limit(long var1);

    public IntStream skip(long var1);

    public void forEach(IntConsumer var1);

    public void forEachOrdered(IntConsumer var1);

    public int[] toArray();

    public int reduce(int var1, IntBinaryOperator var2);

    public OptionalInt reduce(IntBinaryOperator var1);

    public <R> R collect(Supplier<R> var1, ObjIntConsumer<R> var2, BiConsumer<R, R> var3);

    public int sum();

    public OptionalInt min();

    public OptionalInt max();

    public long count();

    public OptionalDouble average();

    public IntSummaryStatistics summaryStatistics();

    public boolean anyMatch(IntPredicate var1);

    public boolean allMatch(IntPredicate var1);

    public boolean noneMatch(IntPredicate var1);

    public OptionalInt findFirst();

    public OptionalInt findAny();

    public LongStream asLongStream();

    public DoubleStream asDoubleStream();

    public Stream<Integer> boxed();

    @Override
    public IntStream sequential();

    @Override
    public IntStream parallel();

    public PrimitiveIterator.OfInt iterator();

    public Spliterator.OfInt spliterator();

    public static Builder builder() {
        return new Streams.IntStreamBuilderImpl();
    }

    public static IntStream empty() {
        return StreamSupport.intStream(Spliterators.emptyIntSpliterator(), false);
    }

    public static IntStream of(int n) {
        return StreamSupport.intStream(new Streams.IntStreamBuilderImpl(n), false);
    }

    public static IntStream of(int ... nArray) {
        return Arrays.stream(nArray);
    }

    public static IntStream iterate(final int n, final IntUnaryOperator intUnaryOperator) {
        Objects.requireNonNull(intUnaryOperator);
        PrimitiveIterator.OfInt ofInt = new PrimitiveIterator.OfInt(){
            int t;
            {
                this.t = n;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public int nextInt() {
                int n2 = this.t;
                this.t = intUnaryOperator.applyAsInt(this.t);
                return n2;
            }
        };
        return StreamSupport.intStream(Spliterators.spliteratorUnknownSize(ofInt, 1296), false);
    }

    public static IntStream generate(IntSupplier intSupplier) {
        Objects.requireNonNull(intSupplier);
        return StreamSupport.intStream(new StreamSpliterators.InfiniteSupplyingSpliterator.OfInt(Long.MAX_VALUE, intSupplier), false);
    }

    public static IntStream range(int n, int n2) {
        if (n >= n2) {
            return IntStream.empty();
        }
        return StreamSupport.intStream(new Streams.RangeIntSpliterator(n, n2, false), false);
    }

    public static IntStream rangeClosed(int n, int n2) {
        if (n > n2) {
            return IntStream.empty();
        }
        return StreamSupport.intStream(new Streams.RangeIntSpliterator(n, n2, true), false);
    }

    public static IntStream concat(IntStream intStream, IntStream intStream2) {
        Objects.requireNonNull(intStream);
        Objects.requireNonNull(intStream2);
        Streams.ConcatSpliterator.OfInt ofInt = new Streams.ConcatSpliterator.OfInt(intStream.spliterator(), intStream2.spliterator());
        IntStream intStream3 = StreamSupport.intStream(ofInt, intStream.isParallel() || intStream2.isParallel());
        return (IntStream)intStream3.onClose(Streams.composedClose(intStream, intStream2));
    }

    public static interface Builder
    extends IntConsumer {
        @Override
        public void accept(int var1);

        default public Builder add(int n) {
            this.accept(n);
            return this;
        }

        public IntStream build();
    }
}

