/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import java.util.Arrays;
import sun.awt.geom.PathConsumer2D;
import sun.java2d.pisces.Curve;
import sun.java2d.pisces.Helpers;
import sun.java2d.pisces.PiscesCache;

final class Renderer
implements PathConsumer2D {
    private static final int YMAX = 0;
    private static final int CURX = 1;
    private static final int OR = 2;
    private static final int SLOPE = 3;
    private static final int NEXT = 4;
    private float edgeMinY = Float.POSITIVE_INFINITY;
    private float edgeMaxY = Float.NEGATIVE_INFINITY;
    private float edgeMinX = Float.POSITIVE_INFINITY;
    private float edgeMaxX = Float.NEGATIVE_INFINITY;
    private static final int SIZEOF_EDGE = 5;
    private static final int NULL = -5;
    private float[] edges = null;
    private static final int INIT_NUM_EDGES = 8;
    private int[] edgeBuckets = null;
    private int[] edgeBucketCounts = null;
    private int numEdges;
    private static final float DEC_BND = 20.0f;
    private static final float INC_BND = 8.0f;
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    private final int SUBPIXEL_LG_POSITIONS_X;
    private final int SUBPIXEL_LG_POSITIONS_Y;
    private final int SUBPIXEL_POSITIONS_X;
    private final int SUBPIXEL_POSITIONS_Y;
    private final int SUBPIXEL_MASK_X;
    private final int SUBPIXEL_MASK_Y;
    final int MAX_AA_ALPHA;
    PiscesCache cache;
    private final int boundsMinX;
    private final int boundsMinY;
    private final int boundsMaxX;
    private final int boundsMaxY;
    private final int windingRule;
    private float x0;
    private float y0;
    private float pix_sx0;
    private float pix_sy0;
    private Curve c = new Curve();

    private void addEdgeToBucket(int n, int n2) {
        this.edges[n + 4] = this.edgeBuckets[n2];
        this.edgeBuckets[n2] = n;
        int n3 = n2;
        this.edgeBucketCounts[n3] = this.edgeBucketCounts[n3] + 2;
    }

    private void quadBreakIntoLinesAndAdd(float f, float f2, Curve curve, float f3, float f4) {
        int n = 16;
        int n2 = n * n;
        float f5 = Math.max(curve.dbx / (float)n2, curve.dby / (float)n2);
        while (f5 > 32.0f) {
            f5 /= 4.0f;
            n <<= 1;
        }
        n2 = n * n;
        float f6 = curve.dbx / (float)n2;
        float f7 = curve.dby / (float)n2;
        float f8 = curve.bx / (float)n2 + curve.cx / (float)n;
        float f9 = curve.by / (float)n2 + curve.cy / (float)n;
        while (n-- > 1) {
            float f10 = f + f8;
            f8 += f6;
            float f11 = f2 + f9;
            f9 += f7;
            this.addLine(f, f2, f10, f11);
            f = f10;
            f2 = f11;
        }
        this.addLine(f, f2, f3, f4);
    }

    private void curveBreakIntoLinesAndAdd(float f, float f2, Curve curve, float f3, float f4) {
        int n = 8;
        float f5 = 2.0f * curve.dax / 512.0f;
        float f6 = 2.0f * curve.day / 512.0f;
        float f7 = f5 + curve.dbx / 64.0f;
        float f8 = f6 + curve.dby / 64.0f;
        float f9 = curve.ax / 512.0f + curve.bx / 64.0f + curve.cx / 8.0f;
        float f10 = curve.ay / 512.0f + curve.by / 64.0f + curve.cy / 8.0f;
        float f11 = f;
        float f12 = f2;
        while (n > 0) {
            while (Math.abs(f7) > 20.0f || Math.abs(f8) > 20.0f) {
                f7 = f7 / 4.0f - (f5 /= 8.0f);
                f8 = f8 / 4.0f - (f6 /= 8.0f);
                f9 = (f9 - f7) / 2.0f;
                f10 = (f10 - f8) / 2.0f;
                n <<= 1;
            }
            while (n % 2 == 0 && Math.abs(f9) <= 8.0f && Math.abs(f10) <= 8.0f) {
                f9 = 2.0f * f9 + f7;
                f10 = 2.0f * f10 + f8;
                f7 = 4.0f * (f7 + f5);
                f8 = 4.0f * (f8 + f6);
                f5 = 8.0f * f5;
                f6 = 8.0f * f6;
                n >>= 1;
            }
            if (--n > 0) {
                f11 += f9;
                f9 += f7;
                f7 += f5;
                f12 += f10;
                f10 += f8;
                f8 += f6;
            } else {
                f11 = f3;
                f12 = f4;
            }
            this.addLine(f, f2, f11, f12);
            f = f11;
            f2 = f12;
        }
    }

    private void addLine(float f, float f2, float f3, float f4) {
        float f5;
        int n;
        int n2;
        float f6 = 1.0f;
        if (f4 < f2) {
            f6 = f4;
            f4 = f2;
            f2 = f6;
            f6 = f3;
            f3 = f;
            f = f6;
            f6 = 0.0f;
        }
        if ((n2 = Math.max((int)Math.ceil(f2), this.boundsMinY)) >= (n = Math.min((int)Math.ceil(f4), this.boundsMaxY))) {
            return;
        }
        if (f2 < this.edgeMinY) {
            this.edgeMinY = f2;
        }
        if (f4 > this.edgeMaxY) {
            this.edgeMaxY = f4;
        }
        if ((f5 = (f3 - f) / (f4 - f2)) > 0.0f) {
            if (f < this.edgeMinX) {
                this.edgeMinX = f;
            }
            if (f3 > this.edgeMaxX) {
                this.edgeMaxX = f3;
            }
        } else {
            if (f3 < this.edgeMinX) {
                this.edgeMinX = f3;
            }
            if (f > this.edgeMaxX) {
                this.edgeMaxX = f;
            }
        }
        int n3 = this.numEdges * 5;
        this.edges = Helpers.widenArray(this.edges, n3, 5);
        ++this.numEdges;
        this.edges[n3 + 2] = f6;
        this.edges[n3 + 1] = f + ((float)n2 - f2) * f5;
        this.edges[n3 + 3] = f5;
        this.edges[n3 + 0] = n;
        int n4 = n2 - this.boundsMinY;
        this.addEdgeToBucket(n3, n4);
        int n5 = n - this.boundsMinY;
        this.edgeBucketCounts[n5] = this.edgeBucketCounts[n5] | 1;
    }

    public Renderer(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.SUBPIXEL_LG_POSITIONS_X = n;
        this.SUBPIXEL_LG_POSITIONS_Y = n2;
        this.SUBPIXEL_MASK_X = (1 << this.SUBPIXEL_LG_POSITIONS_X) - 1;
        this.SUBPIXEL_MASK_Y = (1 << this.SUBPIXEL_LG_POSITIONS_Y) - 1;
        this.SUBPIXEL_POSITIONS_X = 1 << this.SUBPIXEL_LG_POSITIONS_X;
        this.SUBPIXEL_POSITIONS_Y = 1 << this.SUBPIXEL_LG_POSITIONS_Y;
        this.MAX_AA_ALPHA = this.SUBPIXEL_POSITIONS_X * this.SUBPIXEL_POSITIONS_Y;
        this.windingRule = n7;
        this.boundsMinX = n3 * this.SUBPIXEL_POSITIONS_X;
        this.boundsMinY = n4 * this.SUBPIXEL_POSITIONS_Y;
        this.boundsMaxX = (n3 + n5) * this.SUBPIXEL_POSITIONS_X;
        this.boundsMaxY = (n4 + n6) * this.SUBPIXEL_POSITIONS_Y;
        this.edges = new float[40];
        this.numEdges = 0;
        this.edgeBuckets = new int[this.boundsMaxY - this.boundsMinY];
        Arrays.fill(this.edgeBuckets, -5);
        this.edgeBucketCounts = new int[this.edgeBuckets.length + 1];
    }

    private float tosubpixx(float f) {
        return f * (float)this.SUBPIXEL_POSITIONS_X;
    }

    private float tosubpixy(float f) {
        return f * (float)this.SUBPIXEL_POSITIONS_Y;
    }

    @Override
    public void moveTo(float f, float f2) {
        this.closePath();
        this.pix_sx0 = f;
        this.pix_sy0 = f2;
        this.y0 = this.tosubpixy(f2);
        this.x0 = this.tosubpixx(f);
    }

    @Override
    public void lineTo(float f, float f2) {
        float f3 = this.tosubpixx(f);
        float f4 = this.tosubpixy(f2);
        this.addLine(this.x0, this.y0, f3, f4);
        this.x0 = f3;
        this.y0 = f4;
    }

    @Override
    public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = this.tosubpixx(f5);
        float f8 = this.tosubpixy(f6);
        this.c.set(this.x0, this.y0, this.tosubpixx(f), this.tosubpixy(f2), this.tosubpixx(f3), this.tosubpixy(f4), f7, f8);
        this.curveBreakIntoLinesAndAdd(this.x0, this.y0, this.c, f7, f8);
        this.x0 = f7;
        this.y0 = f8;
    }

    @Override
    public void quadTo(float f, float f2, float f3, float f4) {
        float f5 = this.tosubpixx(f3);
        float f6 = this.tosubpixy(f4);
        this.c.set(this.x0, this.y0, this.tosubpixx(f), this.tosubpixy(f2), f5, f6);
        this.quadBreakIntoLinesAndAdd(this.x0, this.y0, this.c, f5, f6);
        this.x0 = f5;
        this.y0 = f6;
    }

    @Override
    public void closePath() {
        this.lineTo(this.pix_sx0, this.pix_sy0);
    }

    @Override
    public void pathDone() {
        this.closePath();
    }

    @Override
    public long getNativeConsumer() {
        throw new InternalError("Renderer does not use a native consumer.");
    }

    private void _endRendering(int n, int n2, int n3, int n4) {
        int n5 = this.windingRule == 0 ? 1 : -1;
        int n6 = n2 - n;
        int[] nArray = new int[n6 + 2];
        int n7 = n << this.SUBPIXEL_LG_POSITIONS_X;
        int n8 = n2 << this.SUBPIXEL_LG_POSITIONS_X;
        int n9 = Integer.MIN_VALUE;
        int n10 = Integer.MAX_VALUE;
        int n11 = this.boundsMinY;
        ScanlineIterator scanlineIterator = new ScanlineIterator(n3, n4);
        while (scanlineIterator.hasNext()) {
            int n12;
            int n13;
            int n14;
            int n15;
            int n16 = scanlineIterator.next();
            int[] nArray2 = scanlineIterator.crossings;
            n11 = scanlineIterator.curY();
            if (n16 > 0) {
                n15 = nArray2[0] >> 1;
                n14 = nArray2[n16 - 1] >> 1;
                n13 = Math.max(n15, n7);
                n12 = Math.min(n14, n8);
                n10 = Math.min(n10, n13 >> this.SUBPIXEL_LG_POSITIONS_X);
                n9 = Math.max(n9, n12 >> this.SUBPIXEL_LG_POSITIONS_X);
            }
            n15 = 0;
            n14 = n7;
            for (n13 = 0; n13 < n16; ++n13) {
                int n17;
                int n18;
                n12 = nArray2[n13];
                int n19 = n12 >> 1;
                int n20 = ((n12 & 1) << 1) - 1;
                if ((n15 & n5) != 0 && (n18 = Math.max(n14, n7)) < (n17 = Math.min(n19, n8))) {
                    int n21 = (n18 -= n7) >> this.SUBPIXEL_LG_POSITIONS_X;
                    int n22 = (n17 -= n7) - 1 >> this.SUBPIXEL_LG_POSITIONS_X;
                    if (n21 == n22) {
                        int n23 = n21;
                        nArray[n23] = nArray[n23] + (n17 - n18);
                        int n24 = n21 + 1;
                        nArray[n24] = nArray[n24] - (n17 - n18);
                    } else {
                        int n25 = n17 >> this.SUBPIXEL_LG_POSITIONS_X;
                        int n26 = n21;
                        nArray[n26] = nArray[n26] + (this.SUBPIXEL_POSITIONS_X - (n18 & this.SUBPIXEL_MASK_X));
                        int n27 = n21 + 1;
                        nArray[n27] = nArray[n27] + (n18 & this.SUBPIXEL_MASK_X);
                        int n28 = n25;
                        nArray[n28] = nArray[n28] - (this.SUBPIXEL_POSITIONS_X - (n17 & this.SUBPIXEL_MASK_X));
                        int n29 = n25 + 1;
                        nArray[n29] = nArray[n29] - (n17 & this.SUBPIXEL_MASK_X);
                    }
                }
                n15 += n20;
                n14 = n19;
            }
            if ((n11 & this.SUBPIXEL_MASK_Y) != this.SUBPIXEL_MASK_Y) continue;
            this.emitRow(nArray, n11 >> this.SUBPIXEL_LG_POSITIONS_Y, n10, n9);
            n10 = Integer.MAX_VALUE;
            n9 = Integer.MIN_VALUE;
        }
        if (n9 >= n10) {
            this.emitRow(nArray, n11 >> this.SUBPIXEL_LG_POSITIONS_Y, n10, n9);
        }
    }

    public void endRendering() {
        int n = Math.max((int)Math.ceil(this.edgeMinX), this.boundsMinX);
        int n2 = Math.min((int)Math.ceil(this.edgeMaxX), this.boundsMaxX);
        int n3 = Math.max((int)Math.ceil(this.edgeMinY), this.boundsMinY);
        int n4 = Math.min((int)Math.ceil(this.edgeMaxY), this.boundsMaxY);
        int n5 = n >> this.SUBPIXEL_LG_POSITIONS_X;
        int n6 = n2 + this.SUBPIXEL_MASK_X >> this.SUBPIXEL_LG_POSITIONS_X;
        int n7 = n3 >> this.SUBPIXEL_LG_POSITIONS_Y;
        int n8 = n4 + this.SUBPIXEL_MASK_Y >> this.SUBPIXEL_LG_POSITIONS_Y;
        if (n5 > n6 || n7 > n8) {
            this.cache = new PiscesCache(this.boundsMinX >> this.SUBPIXEL_LG_POSITIONS_X, this.boundsMinY >> this.SUBPIXEL_LG_POSITIONS_Y, this.boundsMaxX >> this.SUBPIXEL_LG_POSITIONS_X, this.boundsMaxY >> this.SUBPIXEL_LG_POSITIONS_Y);
            return;
        }
        this.cache = new PiscesCache(n5, n7, n6, n8);
        this._endRendering(n5, n6, n3, n4);
    }

    public PiscesCache getCache() {
        if (this.cache == null) {
            throw new InternalError("cache not yet initialized");
        }
        return this.cache;
    }

    private void emitRow(int[] nArray, int n, int n2, int n3) {
        if (this.cache != null && n3 >= n2) {
            this.cache.startRow(n, n2);
            int n4 = n2 - this.cache.bboxX0;
            int n5 = n3 - this.cache.bboxX0;
            int n6 = 1;
            int n7 = nArray[n4];
            for (int i = n4 + 1; i <= n5; ++i) {
                int n8 = n7 + nArray[i];
                if (n8 == n7) {
                    ++n6;
                    continue;
                }
                this.cache.addRLERun(n7, n6);
                n6 = 1;
                n7 = n8;
            }
            this.cache.addRLERun(n7, n6);
        }
        Arrays.fill(nArray, 0);
    }

    private class ScanlineIterator {
        private int[] crossings = new int[10];
        private final int maxY;
        private int nextY;
        private int edgeCount;
        private int[] edgePtrs = new int[10];
        private static final int INIT_CROSSINGS_SIZE = 10;

        private ScanlineIterator(int n, int n2) {
            this.nextY = n;
            this.maxY = n2;
            this.edgeCount = 0;
        }

        private int next() {
            int n;
            int n2;
            int n3;
            int n4 = this.nextY++;
            int n5 = n4 - Renderer.this.boundsMinY;
            int n6 = this.edgeCount;
            int[] nArray = this.edgePtrs;
            int n7 = Renderer.this.edgeBucketCounts[n5];
            if ((n7 & 1) != 0) {
                n3 = 0;
                for (n2 = 0; n2 < n6; ++n2) {
                    n = nArray[n2];
                    if (!(Renderer.this.edges[n + 0] > (float)n4)) continue;
                    nArray[n3++] = n;
                }
                n6 = n3;
            }
            nArray = Helpers.widenArray(nArray, n6, n7 >> 1);
            n3 = Renderer.this.edgeBuckets[n5];
            while (n3 != -5) {
                nArray[n6++] = n3;
                n3 = (int)Renderer.this.edges[n3 + 4];
            }
            this.edgePtrs = nArray;
            this.edgeCount = n6;
            int[] nArray2 = this.crossings;
            if (nArray2.length < n6) {
                this.crossings = nArray2 = new int[nArray.length];
            }
            for (n2 = 0; n2 < n6; ++n2) {
                int n8;
                n = nArray[n2];
                float f = Renderer.this.edges[n + 1];
                int n9 = (int)f << 1;
                ((Renderer)Renderer.this).edges[n + 1] = f + Renderer.this.edges[n + 3];
                if (Renderer.this.edges[n + 2] > 0.0f) {
                    n9 |= 1;
                }
                int n10 = n2;
                while (--n10 >= 0 && (n8 = nArray2[n10]) > n9) {
                    nArray2[n10 + 1] = n8;
                    nArray[n10 + 1] = nArray[n10];
                }
                nArray2[n10 + 1] = n9;
                nArray[n10 + 1] = n;
            }
            return n6;
        }

        private boolean hasNext() {
            return this.nextY < this.maxY;
        }

        private int curY() {
            return this.nextY - 1;
        }
    }
}

