/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.generics.reflectiveObjects;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.reflectiveObjects.LazyReflectiveObjectGenerator;
import sun.reflect.generics.tree.FieldTypeSignature;
import sun.reflect.generics.visitor.Reifier;

public class WildcardTypeImpl
extends LazyReflectiveObjectGenerator
implements WildcardType {
    private Type[] upperBounds;
    private Type[] lowerBounds;
    private FieldTypeSignature[] upperBoundASTs;
    private FieldTypeSignature[] lowerBoundASTs;

    private WildcardTypeImpl(FieldTypeSignature[] fieldTypeSignatureArray, FieldTypeSignature[] fieldTypeSignatureArray2, GenericsFactory genericsFactory) {
        super(genericsFactory);
        this.upperBoundASTs = fieldTypeSignatureArray;
        this.lowerBoundASTs = fieldTypeSignatureArray2;
    }

    public static WildcardTypeImpl make(FieldTypeSignature[] fieldTypeSignatureArray, FieldTypeSignature[] fieldTypeSignatureArray2, GenericsFactory genericsFactory) {
        return new WildcardTypeImpl(fieldTypeSignatureArray, fieldTypeSignatureArray2, genericsFactory);
    }

    private FieldTypeSignature[] getUpperBoundASTs() {
        assert (this.upperBounds == null);
        return this.upperBoundASTs;
    }

    private FieldTypeSignature[] getLowerBoundASTs() {
        assert (this.lowerBounds == null);
        return this.lowerBoundASTs;
    }

    @Override
    public Type[] getUpperBounds() {
        if (this.upperBounds == null) {
            FieldTypeSignature[] fieldTypeSignatureArray = this.getUpperBoundASTs();
            Type[] typeArray = new Type[fieldTypeSignatureArray.length];
            for (int i = 0; i < fieldTypeSignatureArray.length; ++i) {
                Reifier reifier = this.getReifier();
                fieldTypeSignatureArray[i].accept(reifier);
                typeArray[i] = reifier.getResult();
            }
            this.upperBounds = typeArray;
        }
        return (Type[])this.upperBounds.clone();
    }

    @Override
    public Type[] getLowerBounds() {
        if (this.lowerBounds == null) {
            FieldTypeSignature[] fieldTypeSignatureArray = this.getLowerBoundASTs();
            Type[] typeArray = new Type[fieldTypeSignatureArray.length];
            for (int i = 0; i < fieldTypeSignatureArray.length; ++i) {
                Reifier reifier = this.getReifier();
                fieldTypeSignatureArray[i].accept(reifier);
                typeArray[i] = reifier.getResult();
            }
            this.lowerBounds = typeArray;
        }
        return (Type[])this.lowerBounds.clone();
    }

    public String toString() {
        Type[] typeArray;
        Type[] typeArray2 = typeArray = this.getLowerBounds();
        StringBuilder stringBuilder = new StringBuilder();
        if (typeArray.length > 0) {
            stringBuilder.append("? super ");
        } else {
            Type[] typeArray3 = this.getUpperBounds();
            if (typeArray3.length > 0 && !typeArray3[0].equals(Object.class)) {
                typeArray2 = typeArray3;
                stringBuilder.append("? extends ");
            } else {
                return "?";
            }
        }
        assert (typeArray2.length > 0);
        boolean bl = true;
        for (Type type : typeArray2) {
            if (!bl) {
                stringBuilder.append(" & ");
            }
            bl = false;
            if (type instanceof Class) {
                stringBuilder.append(((Class)type).getName());
                continue;
            }
            stringBuilder.append(type.toString());
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)object;
            return Arrays.equals(this.getLowerBounds(), wildcardType.getLowerBounds()) && Arrays.equals(this.getUpperBounds(), wildcardType.getUpperBounds());
        }
        return false;
    }

    public int hashCode() {
        Object[] objectArray = this.getLowerBounds();
        Object[] objectArray2 = this.getUpperBounds();
        return Arrays.hashCode(objectArray) ^ Arrays.hashCode(objectArray2);
    }
}

