/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.CRLReason;
import java.security.cert.X509CRLEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.security.auth.x500.X500Principal;
import sun.misc.HexDumpEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.CRLExtensions;
import sun.security.x509.CRLReasonCodeExtension;
import sun.security.x509.CertificateIssuerExtension;
import sun.security.x509.Extension;
import sun.security.x509.OIDMap;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.SerialNumber;

public class X509CRLEntryImpl
extends X509CRLEntry
implements Comparable<X509CRLEntryImpl> {
    private SerialNumber serialNumber = null;
    private Date revocationDate = null;
    private CRLExtensions extensions = null;
    private byte[] revokedCert = null;
    private X500Principal certIssuer;
    private static final boolean isExplicit = false;
    private static final long YR_2050 = 2524636800000L;

    public X509CRLEntryImpl(BigInteger bigInteger, Date date) {
        this.serialNumber = new SerialNumber(bigInteger);
        this.revocationDate = date;
    }

    public X509CRLEntryImpl(BigInteger bigInteger, Date date, CRLExtensions cRLExtensions) {
        this.serialNumber = new SerialNumber(bigInteger);
        this.revocationDate = date;
        this.extensions = cRLExtensions;
    }

    public X509CRLEntryImpl(byte[] byArray) throws CRLException {
        try {
            this.parse(new DerValue(byArray));
        }
        catch (IOException iOException) {
            this.revokedCert = null;
            throw new CRLException("Parsing error: " + iOException.toString());
        }
    }

    public X509CRLEntryImpl(DerValue derValue) throws CRLException {
        try {
            this.parse(derValue);
        }
        catch (IOException iOException) {
            this.revokedCert = null;
            throw new CRLException("Parsing error: " + iOException.toString());
        }
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public void encode(DerOutputStream derOutputStream) throws CRLException {
        try {
            if (this.revokedCert == null) {
                DerOutputStream derOutputStream2 = new DerOutputStream();
                this.serialNumber.encode(derOutputStream2);
                if (this.revocationDate.getTime() < 2524636800000L) {
                    derOutputStream2.putUTCTime(this.revocationDate);
                } else {
                    derOutputStream2.putGeneralizedTime(this.revocationDate);
                }
                if (this.extensions != null) {
                    this.extensions.encode(derOutputStream2, false);
                }
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.write((byte)48, derOutputStream2);
                this.revokedCert = derOutputStream3.toByteArray();
            }
            derOutputStream.write(this.revokedCert);
        }
        catch (IOException iOException) {
            throw new CRLException("Encoding error: " + iOException.toString());
        }
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        return (byte[])this.getEncoded0().clone();
    }

    private byte[] getEncoded0() throws CRLException {
        if (this.revokedCert == null) {
            this.encode(new DerOutputStream());
        }
        return this.revokedCert;
    }

    @Override
    public X500Principal getCertificateIssuer() {
        return this.certIssuer;
    }

    void setCertificateIssuer(X500Principal x500Principal, X500Principal x500Principal2) {
        this.certIssuer = x500Principal.equals(x500Principal2) ? null : x500Principal2;
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.serialNumber.getNumber();
    }

    @Override
    public Date getRevocationDate() {
        return new Date(this.revocationDate.getTime());
    }

    @Override
    public CRLReason getRevocationReason() {
        Extension extension = this.getExtension(PKIXExtensions.ReasonCode_Id);
        if (extension == null) {
            return null;
        }
        CRLReasonCodeExtension cRLReasonCodeExtension = (CRLReasonCodeExtension)extension;
        return cRLReasonCodeExtension.getReasonCode();
    }

    public static CRLReason getRevocationReason(X509CRLEntry x509CRLEntry) {
        try {
            byte[] byArray = x509CRLEntry.getExtensionValue("2.5.29.21");
            if (byArray == null) {
                return null;
            }
            DerValue derValue = new DerValue(byArray);
            byte[] byArray2 = derValue.getOctetString();
            CRLReasonCodeExtension cRLReasonCodeExtension = new CRLReasonCodeExtension(Boolean.FALSE, byArray2);
            return cRLReasonCodeExtension.getReasonCode();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Integer getReasonCode() throws IOException {
        Extension extension = this.getExtension(PKIXExtensions.ReasonCode_Id);
        if (extension == null) {
            return null;
        }
        CRLReasonCodeExtension cRLReasonCodeExtension = (CRLReasonCodeExtension)extension;
        return cRLReasonCodeExtension.get("reason");
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.serialNumber.toString());
        stringBuilder.append("  On: " + this.revocationDate.toString());
        if (this.certIssuer != null) {
            stringBuilder.append("\n    Certificate issuer: " + this.certIssuer);
        }
        if (this.extensions != null) {
            Collection<Extension> collection = this.extensions.getAllExtensions();
            Extension[] extensionArray = collection.toArray(new Extension[0]);
            stringBuilder.append("\n    CRL Entry Extensions: " + extensionArray.length);
            for (int i = 0; i < extensionArray.length; ++i) {
                stringBuilder.append("\n    [" + (i + 1) + "]: ");
                Extension extension = extensionArray[i];
                try {
                    if (OIDMap.getClass(extension.getExtensionId()) == null) {
                        stringBuilder.append(extension.toString());
                        byte[] byArray = extension.getExtensionValue();
                        if (byArray == null) continue;
                        DerOutputStream derOutputStream = new DerOutputStream();
                        derOutputStream.putOctetString(byArray);
                        byArray = derOutputStream.toByteArray();
                        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                        stringBuilder.append("Extension unknown: DER encoded OCTET string =\n" + hexDumpEncoder.encodeBuffer(byArray) + "\n");
                        continue;
                    }
                    stringBuilder.append(extension.toString());
                    continue;
                }
                catch (Exception exception) {
                    stringBuilder.append(", Error parsing this extension");
                }
            }
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        if (this.extensions == null) {
            return false;
        }
        return this.extensions.hasUnsupportedCriticalExtension();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Extension extension : this.extensions.getAllExtensions()) {
            if (!extension.isCritical()) continue;
            treeSet.add(extension.getExtensionId().toString());
        }
        return treeSet;
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Extension extension : this.extensions.getAllExtensions()) {
            if (extension.isCritical()) continue;
            treeSet.add(extension.getExtensionId().toString());
        }
        return treeSet;
    }

    @Override
    public byte[] getExtensionValue(String string) {
        if (this.extensions == null) {
            return null;
        }
        try {
            Object object;
            Object object2;
            String string2 = OIDMap.getName(new ObjectIdentifier(string));
            Object object3 = null;
            if (string2 == null) {
                object2 = new ObjectIdentifier(string);
                object = null;
                Enumeration<Extension> enumeration = this.extensions.getElements();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    ObjectIdentifier objectIdentifier = ((Extension)object).getExtensionId();
                    if (!objectIdentifier.equals(object2)) continue;
                    object3 = object;
                    break;
                }
            } else {
                object3 = this.extensions.get(string2);
            }
            if (object3 == null) {
                return null;
            }
            object2 = ((Extension)object3).getExtensionValue();
            if (object2 == null) {
                return null;
            }
            object = new DerOutputStream();
            ((DerOutputStream)object).putOctetString((byte[])object2);
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Extension getExtension(ObjectIdentifier objectIdentifier) {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.get(OIDMap.getName(objectIdentifier));
    }

    private void parse(DerValue derValue) throws CRLException, IOException {
        if (derValue.tag != 48) {
            throw new CRLException("Invalid encoded RevokedCertificate, starting sequence tag missing.");
        }
        if (derValue.data.available() == 0) {
            throw new CRLException("No data encoded for RevokedCertificates");
        }
        this.revokedCert = derValue.toByteArray();
        DerInputStream derInputStream = derValue.toDerInputStream();
        DerValue derValue2 = derInputStream.getDerValue();
        this.serialNumber = new SerialNumber(derValue2);
        int n = derValue.data.peekByte();
        if ((byte)n == 23) {
            this.revocationDate = derValue.data.getUTCTime();
        } else if ((byte)n == 24) {
            this.revocationDate = derValue.data.getGeneralizedTime();
        } else {
            throw new CRLException("Invalid encoding for revocation date");
        }
        if (derValue.data.available() == 0) {
            return;
        }
        this.extensions = new CRLExtensions(derValue.toDerInputStream());
    }

    public static X509CRLEntryImpl toImpl(X509CRLEntry x509CRLEntry) throws CRLException {
        if (x509CRLEntry instanceof X509CRLEntryImpl) {
            return (X509CRLEntryImpl)x509CRLEntry;
        }
        return new X509CRLEntryImpl(x509CRLEntry.getEncoded());
    }

    CertificateIssuerExtension getCertificateIssuerExtension() {
        return (CertificateIssuerExtension)this.getExtension(PKIXExtensions.CertificateIssuer_Id);
    }

    public Map<String, java.security.cert.Extension> getExtensions() {
        if (this.extensions == null) {
            return Collections.emptyMap();
        }
        Collection<Extension> collection = this.extensions.getAllExtensions();
        TreeMap<String, java.security.cert.Extension> treeMap = new TreeMap<String, java.security.cert.Extension>();
        for (Extension extension : collection) {
            treeMap.put(extension.getId(), extension);
        }
        return treeMap;
    }

    @Override
    public int compareTo(X509CRLEntryImpl x509CRLEntryImpl) {
        int n = this.getSerialNumber().compareTo(x509CRLEntryImpl.getSerialNumber());
        if (n != 0) {
            return n;
        }
        try {
            byte[] byArray = this.getEncoded0();
            byte[] byArray2 = x509CRLEntryImpl.getEncoded0();
            for (int i = 0; i < byArray.length && i < byArray2.length; ++i) {
                int n2 = byArray[i] & 0xFF;
                int n3 = byArray2[i] & 0xFF;
                if (n2 == n3) continue;
                return n2 - n3;
            }
            return byArray.length - byArray2.length;
        }
        catch (CRLException cRLException) {
            return -1;
        }
    }
}

