/*
 * Decompiled with CFR 0.152.
 */
package apple.applescript;

import apple.applescript.AppleScriptEngineFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;

public class AppleScriptEngine
implements ScriptEngine {
    private final ScriptEngineFactory factory;
    private ScriptContext context;

    private static native void initNative();

    private static native long createContextFrom(Object var0);

    private static native Object createObjectFrom(long var0);

    private static native void disposeContext(long var0);

    private static native long evalScript(String var0, long var1);

    private static native long evalScriptFromURL(String var0, long var1);

    static void checkSecurity() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExec("/usr/bin/osascript");
        }
    }

    static void TRACE(String string) {
    }

    protected static String getEngine() {
        AppleScriptEngine.TRACE("getEngine()");
        return "AppleScriptEngine";
    }

    protected static String getEngineVersion() {
        AppleScriptEngine.TRACE("getEngineVersion()");
        return "1.1";
    }

    protected static String getName() {
        AppleScriptEngine.TRACE("getName()");
        return "AppleScriptEngine";
    }

    protected static String getLanguage() {
        AppleScriptEngine.TRACE("getLanguage()");
        return "AppleScript";
    }

    public AppleScriptEngine() {
        AppleScriptEngine.TRACE("<ctor>()");
        this.factory = AppleScriptEngineFactory.getFactory();
        this.setContext(new SimpleScriptContext());
        this.put("javax.script.argv", "");
        this.init();
    }

    public AppleScriptEngine(ScriptEngineFactory scriptEngineFactory) {
        this.factory = scriptEngineFactory;
        this.setContext(new SimpleScriptContext());
        this.put("javax.script.argv", "");
        this.init();
    }

    private void init() {
        AppleScriptEngine.TRACE("init()");
        this.put("javax.script.filename", "");
        this.put("javax.script.engine", AppleScriptEngine.getEngine());
        this.put("javax.script.engine_version", AppleScriptEngine.getEngineVersion());
        this.put("javax.script.name", AppleScriptEngine.getName());
        this.put("javax.script.language", AppleScriptEngine.getLanguage());
        this.put("javax.script.language_version", this.getLanguageVersion());
        this.put("THREADING", null);
    }

    protected String getLanguageVersion() {
        AppleScriptEngine.TRACE("AppleScriptEngine.getLanguageVersion()");
        try {
            Object object = this.eval("get the version of AppleScript");
            if (object instanceof String) {
                return (String)object;
            }
        }
        catch (ScriptException scriptException) {
            scriptException.printStackTrace();
        }
        return "unknown";
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public ScriptContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(ScriptContext scriptContext) {
        this.context = scriptContext;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public Bindings getBindings(int n) {
        return this.context.getBindings(n);
    }

    @Override
    public void setBindings(Bindings bindings, int n) {
        this.context.setBindings(bindings, n);
    }

    @Override
    public void put(String string, Object object) {
        this.getBindings(100).put(string, object);
    }

    @Override
    public Object get(String string) {
        return this.getBindings(100).get(string);
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        return this.eval(reader, this.getContext());
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        Bindings bindings2 = this.getContext().getBindings(100);
        this.getContext().setBindings(bindings, 100);
        Object object = this.eval(reader);
        this.getContext().setBindings(bindings2, 100);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        Object object;
        int n;
        AppleScriptEngine.checkSecurity();
        File file = Files.createTempFile("AppleScriptEngine.", ".scpt", new FileAttribute[0]).toFile();
        FileWriter fileWriter = new FileWriter(file);
        while ((n = reader.read()) != -1) {
            fileWriter.write(n);
        }
        fileWriter.close();
        long l = this.scriptContextToNSDictionary(scriptContext);
        try {
            long l2 = AppleScriptEngine.evalScriptFromURL("file://" + file.getCanonicalPath(), l);
            Object object2 = l2 == 0L ? null : AppleScriptEngine.createObjectFrom(l2);
            AppleScriptEngine.disposeContext(l2);
            object = object2;
        }
        catch (Throwable throwable) {
            try {
                AppleScriptEngine.disposeContext(l);
                file.delete();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new ScriptException(iOException);
            }
        }
        AppleScriptEngine.disposeContext(l);
        file.delete();
        return object;
    }

    @Override
    public Object eval(String string) throws ScriptException {
        return this.eval(string, this.getContext());
    }

    @Override
    public Object eval(String string, Bindings bindings) throws ScriptException {
        Bindings bindings2 = this.getContext().getBindings(100);
        this.getContext().setBindings(bindings, 100);
        Object object = this.eval(string);
        this.getContext().setBindings(bindings2, 100);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(String string, ScriptContext scriptContext) throws ScriptException {
        AppleScriptEngine.checkSecurity();
        long l = this.scriptContextToNSDictionary(scriptContext);
        try {
            long l2 = AppleScriptEngine.evalScript(string, l);
            Object object = l2 == 0L ? null : AppleScriptEngine.createObjectFrom(l2);
            AppleScriptEngine.disposeContext(l2);
            Object object2 = object;
            return object2;
        }
        finally {
            AppleScriptEngine.disposeContext(l);
        }
    }

    private long scriptContextToNSDictionary(ScriptContext scriptContext) throws ScriptException {
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : scriptContext.getBindings(100).entrySet()) {
            hashMap.put(((String)entry.getKey()).replaceAll("\\.", "_"), entry.getValue());
        }
        return AppleScriptEngine.createContextFrom(hashMap);
    }

    static {
        System.loadLibrary("AppleScriptEngine");
        AppleScriptEngine.initNative();
        AppleScriptEngine.TRACE("<static-init>");
    }
}

