# Copyright 2004 "Il gatto e la volpe"
# Distributed under the terms of the GNU General Public License v2
# $Header: /home/cvsroot/gentoo-x86/sys-apps/baselayout-db/baselayout-db-1.0_pre1.ebuild,v 1.2 2004/02/27 20:21:45 pebenito Exp $

IUSE=""

DESCRIPTION="Baselayout for Dyne::Bolic"
HOMEPAGE="http://www.autistici.org/bolic1/portage/dynebolic/"
SRC_URI="http://www.autistici.org/bolic1/${P}.tar.gz"
LICENSE="GPL-2"
SLOT="0"
KEYWORDS="-*"

S="${WORKDIR}/${PN}"

src_install() {
	keepdir /bin /etc /etc/init.d /home /lib /sbin /usr /var /proc /root /mnt

	insinto /etc
	doins ${S}/{fstab,group,nsswitch.conf,passwd,profile.env,protocols,shells}
	doins ${S}/init/inittab

	#exeinto /etc/init.d
	doexe ${S}/rc[SK]
}

pkg_preinst() {
	mkdir -p ${ROOT}/proc
}

pkg_postinst() {

	# Touching /etc/passwd and /etc/shadow after install can be fatal, as many
	# new users do not update them properly.  thus remove all ._cfg files if
	# we are not busy with a build.
	if [ -z "`use build`" -a -z "`use bootstrap`" ]
	then
		ewarn "Removing invalid backup copies of critical config files..."
		rm -f ${ROOT}/etc/._cfg????_{passwd,shadow}
	fi
}

