/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class StreamHandler
extends Handler {
    private OutputStream output;
    private boolean doneHeader;
    private volatile Writer writer;

    private void configure() {
        LogManager logManager = LogManager.getLogManager();
        String string = this.getClass().getName();
        this.setLevel(logManager.getLevelProperty(string + ".level", Level.INFO));
        this.setFilter(logManager.getFilterProperty(string + ".filter", null));
        this.setFormatter(logManager.getFormatterProperty(string + ".formatter", new SimpleFormatter()));
        try {
            this.setEncoding(logManager.getStringProperty(string + ".encoding", null));
        }
        catch (Exception exception) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public StreamHandler() {
        this.sealed = false;
        this.configure();
        this.sealed = true;
    }

    public StreamHandler(OutputStream outputStream, Formatter formatter) {
        this.sealed = false;
        this.configure();
        this.setFormatter(formatter);
        this.setOutputStream(outputStream);
        this.sealed = true;
    }

    protected synchronized void setOutputStream(OutputStream outputStream) throws SecurityException {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        this.flushAndClose();
        this.output = outputStream;
        this.doneHeader = false;
        String string = this.getEncoding();
        if (string == null) {
            this.writer = new OutputStreamWriter(this.output);
        } else {
            try {
                this.writer = new OutputStreamWriter(this.output, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Error("Unexpected exception " + unsupportedEncodingException);
            }
        }
    }

    @Override
    public synchronized void setEncoding(String string) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(string);
        if (this.output == null) {
            return;
        }
        this.flush();
        this.writer = string == null ? new OutputStreamWriter(this.output) : new OutputStreamWriter(this.output, string);
    }

    @Override
    public synchronized void publish(LogRecord logRecord) {
        String string;
        if (!this.isLoggable(logRecord)) {
            return;
        }
        try {
            string = this.getFormatter().format(logRecord);
        }
        catch (Exception exception) {
            this.reportError(null, exception, 5);
            return;
        }
        try {
            if (!this.doneHeader) {
                this.writer.write(this.getFormatter().getHead(this));
                this.doneHeader = true;
            }
            this.writer.write(string);
        }
        catch (Exception exception) {
            this.reportError(null, exception, 1);
        }
    }

    @Override
    public boolean isLoggable(LogRecord logRecord) {
        if (this.writer == null || logRecord == null) {
            return false;
        }
        return super.isLoggable(logRecord);
    }

    @Override
    public synchronized void flush() {
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (Exception exception) {
                this.reportError(null, exception, 2);
            }
        }
    }

    private synchronized void flushAndClose() throws SecurityException {
        this.checkPermission();
        if (this.writer != null) {
            try {
                if (!this.doneHeader) {
                    this.writer.write(this.getFormatter().getHead(this));
                    this.doneHeader = true;
                }
                this.writer.write(this.getFormatter().getTail(this));
                this.writer.flush();
                this.writer.close();
            }
            catch (Exception exception) {
                this.reportError(null, exception, 3);
            }
            this.writer = null;
            this.output = null;
        }
    }

    @Override
    public synchronized void close() throws SecurityException {
        this.flushAndClose();
    }
}

