/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class Extension
implements java.security.cert.Extension {
    protected ObjectIdentifier extensionId = null;
    protected boolean critical = false;
    protected byte[] extensionValue = null;
    private static final int hashMagic = 31;

    public Extension() {
    }

    public Extension(DerValue derValue) throws IOException {
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.extensionId = derInputStream.getOID();
        DerValue derValue2 = derInputStream.getDerValue();
        if (derValue2.tag == 1) {
            this.critical = derValue2.getBoolean();
            derValue2 = derInputStream.getDerValue();
            this.extensionValue = derValue2.getOctetString();
        } else {
            this.critical = false;
            this.extensionValue = derValue2.getOctetString();
        }
    }

    public Extension(ObjectIdentifier objectIdentifier, boolean bl, byte[] byArray) throws IOException {
        this.extensionId = objectIdentifier;
        this.critical = bl;
        DerValue derValue = new DerValue(byArray);
        this.extensionValue = derValue.getOctetString();
    }

    public Extension(Extension extension) {
        this.extensionId = extension.extensionId;
        this.critical = extension.critical;
        this.extensionValue = extension.extensionValue;
    }

    public static Extension newExtension(ObjectIdentifier objectIdentifier, boolean bl, byte[] byArray) throws IOException {
        Extension extension = new Extension();
        extension.extensionId = objectIdentifier;
        extension.critical = bl;
        extension.extensionValue = byArray;
        return extension;
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.extensionId);
        if (this.critical) {
            derOutputStream.putBoolean(this.critical);
        }
        derOutputStream.putOctetString(this.extensionValue);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (this.extensionId == null) {
            throw new IOException("Null OID to encode for the extension!");
        }
        if (this.extensionValue == null) {
            throw new IOException("No value to encode for the extension!");
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.extensionId);
        if (this.critical) {
            derOutputStream2.putBoolean(this.critical);
        }
        derOutputStream2.putOctetString(this.extensionValue);
        derOutputStream.write((byte)48, derOutputStream2);
    }

    @Override
    public boolean isCritical() {
        return this.critical;
    }

    public ObjectIdentifier getExtensionId() {
        return this.extensionId;
    }

    @Override
    public byte[] getValue() {
        return (byte[])this.extensionValue.clone();
    }

    public byte[] getExtensionValue() {
        return this.extensionValue;
    }

    @Override
    public String getId() {
        return this.extensionId.toString();
    }

    public String toString() {
        String string = "ObjectId: " + this.extensionId.toString();
        string = this.critical ? string + " Criticality=true\n" : string + " Criticality=false\n";
        return string;
    }

    public int hashCode() {
        int n = 0;
        if (this.extensionValue != null) {
            byte[] byArray = this.extensionValue;
            int n2 = byArray.length;
            while (n2 > 0) {
                n += n2-- * byArray[n2];
            }
        }
        n = n * 31 + this.extensionId.hashCode();
        n = n * 31 + (this.critical ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Extension)) {
            return false;
        }
        Extension extension = (Extension)object;
        if (this.critical != extension.critical) {
            return false;
        }
        if (!this.extensionId.equals((Object)extension.extensionId)) {
            return false;
        }
        return Arrays.equals(this.extensionValue, extension.extensionValue);
    }
}

