/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.security.AlgorithmConstraints;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.EnumSet;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;
import sun.security.ssl.JsseJce;

final class ECDHCrypt {
    private PrivateKey privateKey;
    private ECPublicKey publicKey;

    ECDHCrypt(PrivateKey privateKey, PublicKey publicKey) {
        this.privateKey = privateKey;
        this.publicKey = (ECPublicKey)publicKey;
    }

    ECDHCrypt(String string, SecureRandom secureRandom) {
        try {
            KeyPairGenerator keyPairGenerator = JsseJce.getKeyPairGenerator("EC");
            ECGenParameterSpec eCGenParameterSpec = new ECGenParameterSpec(string);
            keyPairGenerator.initialize(eCGenParameterSpec, secureRandom);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            this.privateKey = keyPair.getPrivate();
            this.publicKey = (ECPublicKey)keyPair.getPublic();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("Could not generate DH keypair", generalSecurityException);
        }
    }

    ECDHCrypt(ECParameterSpec eCParameterSpec, SecureRandom secureRandom) {
        try {
            KeyPairGenerator keyPairGenerator = JsseJce.getKeyPairGenerator("EC");
            keyPairGenerator.initialize(eCParameterSpec, secureRandom);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            this.privateKey = keyPair.getPrivate();
            this.publicKey = (ECPublicKey)keyPair.getPublic();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("Could not generate DH keypair", generalSecurityException);
        }
    }

    PublicKey getPublicKey() {
        return this.publicKey;
    }

    SecretKey getAgreedSecret(PublicKey publicKey) throws SSLHandshakeException {
        try {
            KeyAgreement keyAgreement = JsseJce.getKeyAgreement("ECDH");
            keyAgreement.init(this.privateKey);
            keyAgreement.doPhase(publicKey, true);
            return keyAgreement.generateSecret("TlsPremasterSecret");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(generalSecurityException);
        }
    }

    SecretKey getAgreedSecret(byte[] byArray) throws SSLHandshakeException {
        try {
            ECParameterSpec eCParameterSpec = this.publicKey.getParams();
            ECPoint eCPoint = JsseJce.decodePoint(byArray, eCParameterSpec.getCurve());
            KeyFactory keyFactory = JsseJce.getKeyFactory("EC");
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
            PublicKey publicKey = keyFactory.generatePublic(eCPublicKeySpec);
            return this.getAgreedSecret(publicKey);
        }
        catch (IOException | GeneralSecurityException exception) {
            throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(exception);
        }
    }

    void checkConstraints(AlgorithmConstraints algorithmConstraints, byte[] byArray) throws SSLHandshakeException {
        try {
            ECParameterSpec eCParameterSpec = this.publicKey.getParams();
            ECPoint eCPoint = JsseJce.decodePoint(byArray, eCParameterSpec.getCurve());
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
            KeyFactory keyFactory = JsseJce.getKeyFactory("EC");
            ECPublicKey eCPublicKey = (ECPublicKey)keyFactory.generatePublic(eCPublicKeySpec);
            if (!algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), eCPublicKey)) {
                throw new SSLHandshakeException("ECPublicKey does not comply to algorithm constraints");
            }
        }
        catch (IOException | GeneralSecurityException exception) {
            throw (SSLHandshakeException)new SSLHandshakeException("Could not generate ECPublicKey").initCause(exception);
        }
    }
}

