/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.AsynchronousChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import sun.nio.ch.Cancellable;

final class PendingFuture<V, A>
implements Future<V> {
    private static final CancellationException CANCELLED = new CancellationException();
    private final AsynchronousChannel channel;
    private final CompletionHandler<V, ? super A> handler;
    private final A attachment;
    private volatile boolean haveResult;
    private volatile V result;
    private volatile Throwable exc;
    private CountDownLatch latch;
    private Future<?> timeoutTask;
    private volatile Object context;

    PendingFuture(AsynchronousChannel asynchronousChannel, CompletionHandler<V, ? super A> completionHandler, A a, Object object) {
        this.channel = asynchronousChannel;
        this.handler = completionHandler;
        this.attachment = a;
        this.context = object;
    }

    PendingFuture(AsynchronousChannel asynchronousChannel, CompletionHandler<V, ? super A> completionHandler, A a) {
        this.channel = asynchronousChannel;
        this.handler = completionHandler;
        this.attachment = a;
    }

    PendingFuture(AsynchronousChannel asynchronousChannel) {
        this(asynchronousChannel, null, null);
    }

    PendingFuture(AsynchronousChannel asynchronousChannel, Object object) {
        this(asynchronousChannel, null, null, object);
    }

    AsynchronousChannel channel() {
        return this.channel;
    }

    CompletionHandler<V, ? super A> handler() {
        return this.handler;
    }

    A attachment() {
        return this.attachment;
    }

    void setContext(Object object) {
        this.context = object;
    }

    Object getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimeoutTask(Future<?> future) {
        PendingFuture pendingFuture = this;
        synchronized (pendingFuture) {
            if (this.haveResult) {
                future.cancel(false);
            } else {
                this.timeoutTask = future;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareForWait() {
        PendingFuture pendingFuture = this;
        synchronized (pendingFuture) {
            if (this.haveResult) {
                return false;
            }
            if (this.latch == null) {
                this.latch = new CountDownLatch(1);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setResult(V v) {
        PendingFuture pendingFuture = this;
        synchronized (pendingFuture) {
            if (this.haveResult) {
                return;
            }
            this.result = v;
            this.haveResult = true;
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel(false);
            }
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFailure(Throwable throwable) {
        if (!(throwable instanceof IOException) && !(throwable instanceof SecurityException)) {
            throwable = new IOException(throwable);
        }
        PendingFuture pendingFuture = this;
        synchronized (pendingFuture) {
            if (this.haveResult) {
                return;
            }
            this.exc = throwable;
            this.haveResult = true;
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel(false);
            }
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
    }

    void setResult(V v, Throwable throwable) {
        if (throwable == null) {
            this.setResult(v);
        } else {
            this.setFailure(throwable);
        }
    }

    @Override
    public V get() throws ExecutionException, InterruptedException {
        boolean bl;
        if (!this.haveResult && (bl = this.prepareForWait())) {
            this.latch.await();
        }
        if (this.exc != null) {
            if (this.exc == CANCELLED) {
                throw new CancellationException();
            }
            throw new ExecutionException(this.exc);
        }
        return this.result;
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        boolean bl;
        if (!this.haveResult && (bl = this.prepareForWait()) && !this.latch.await(l, timeUnit)) {
            throw new TimeoutException();
        }
        if (this.exc != null) {
            if (this.exc == CANCELLED) {
                throw new CancellationException();
            }
            throw new ExecutionException(this.exc);
        }
        return this.result;
    }

    Throwable exception() {
        return this.exc != CANCELLED ? this.exc : null;
    }

    V value() {
        return this.result;
    }

    @Override
    public boolean isCancelled() {
        return this.exc == CANCELLED;
    }

    @Override
    public boolean isDone() {
        return this.haveResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        PendingFuture pendingFuture = this;
        synchronized (pendingFuture) {
            if (this.haveResult) {
                return false;
            }
            if (this.channel() instanceof Cancellable) {
                ((Cancellable)((Object)this.channel())).onCancel(this);
            }
            this.exc = CANCELLED;
            this.haveResult = true;
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel(false);
            }
        }
        if (bl) {
            try {
                this.channel().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.latch != null) {
            this.latch.countDown();
        }
        return true;
    }
}

