/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig.spec;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class XPathType {
    private final String expression;
    private final Filter filter;
    private Map<String, String> nsMap;

    public XPathType(String string, Filter filter) {
        if (string == null) {
            throw new NullPointerException("expression cannot be null");
        }
        if (filter == null) {
            throw new NullPointerException("filter cannot be null");
        }
        this.expression = string;
        this.filter = filter;
        this.nsMap = Collections.emptyMap();
    }

    public XPathType(String string, Filter filter, Map map) {
        this(string, filter);
        Map.Entry entry2;
        if (map == null) {
            throw new NullPointerException("namespaceMap cannot be null");
        }
        HashMap hashMap = new HashMap(map);
        for (Map.Entry entry2 : hashMap.entrySet()) {
            if (entry2.getKey() instanceof String && entry2.getValue() instanceof String) continue;
            throw new ClassCastException("not a String");
        }
        entry2 = hashMap;
        this.nsMap = Collections.unmodifiableMap(entry2);
    }

    public String getExpression() {
        return this.expression;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Map getNamespaceMap() {
        return this.nsMap;
    }

    public static class Filter {
        private final String operation;
        public static final Filter INTERSECT = new Filter("intersect");
        public static final Filter SUBTRACT = new Filter("subtract");
        public static final Filter UNION = new Filter("union");

        private Filter(String string) {
            this.operation = string;
        }

        public String toString() {
            return this.operation;
        }
    }
}

