/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.DocumentFilter;

final class ValueFormatter
extends JFormattedTextField.AbstractFormatter
implements FocusListener,
Runnable {
    private final DocumentFilter filter = new DocumentFilter(){

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            if (ValueFormatter.this.isValid(filterBypass.getDocument().getLength() - n2)) {
                filterBypass.remove(n, n2);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (ValueFormatter.this.isValid(filterBypass.getDocument().getLength() + string.length() - n2) && ValueFormatter.this.isValid(string)) {
                filterBypass.replace(n, n2, string.toUpperCase(Locale.ENGLISH), attributeSet);
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (ValueFormatter.this.isValid(filterBypass.getDocument().getLength() + string.length()) && ValueFormatter.this.isValid(string)) {
                filterBypass.insertString(n, string.toUpperCase(Locale.ENGLISH), attributeSet);
            }
        }
    };
    private final int length;
    private final int radix;
    private JFormattedTextField text;

    static void init(int n, boolean bl, JFormattedTextField jFormattedTextField) {
        ValueFormatter valueFormatter = new ValueFormatter(n, bl);
        jFormattedTextField.setColumns(n);
        jFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(valueFormatter));
        jFormattedTextField.setHorizontalAlignment(4);
        jFormattedTextField.setMinimumSize(jFormattedTextField.getPreferredSize());
        jFormattedTextField.addFocusListener(valueFormatter);
    }

    ValueFormatter(int n, boolean bl) {
        this.length = n;
        this.radix = bl ? 16 : 10;
    }

    @Override
    public Object stringToValue(String string) throws ParseException {
        try {
            return Integer.valueOf(string, this.radix);
        }
        catch (NumberFormatException numberFormatException) {
            ParseException parseException = new ParseException("illegal format", 0);
            parseException.initCause(numberFormatException);
            throw parseException;
        }
    }

    @Override
    public String valueToString(Object object) throws ParseException {
        if (object instanceof Integer) {
            if (this.radix == 10) {
                return object.toString();
            }
            int n = (Integer)object;
            int n2 = this.length;
            char[] cArray = new char[n2];
            while (0 < n2--) {
                cArray[n2] = Character.forDigit(n & 0xF, this.radix);
                n >>= 4;
            }
            return new String(cArray).toUpperCase(Locale.ENGLISH);
        }
        throw new ParseException("illegal object", 0);
    }

    @Override
    protected DocumentFilter getDocumentFilter() {
        return this.filter;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof JFormattedTextField) {
            this.text = (JFormattedTextField)object;
            SwingUtilities.invokeLater(this);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void run() {
        if (this.text != null) {
            this.text.selectAll();
        }
    }

    private boolean isValid(int n) {
        return 0 <= n && n <= this.length;
    }

    private boolean isValid(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.digit(c, this.radix) >= 0) continue;
            return false;
        }
        return true;
    }
}

