/*
 * Decompiled with CFR 0.152.
 */
package sun.text.bidi;

import java.text.Bidi;
import java.util.Arrays;
import sun.text.bidi.BidiBase;
import sun.text.bidi.BidiRun;

public final class BidiLine {
    static void setTrailingWSStart(BidiBase bidiBase) {
        int n;
        byte[] byArray = bidiBase.dirProps;
        byte[] byArray2 = bidiBase.levels;
        byte by = bidiBase.paraLevel;
        if (BidiBase.NoContextRTL(byArray[n - 1]) == 7) {
            bidiBase.trailingWSStart = n;
            return;
        }
        for (n = bidiBase.length; n > 0 && (BidiBase.DirPropFlagNC(byArray[n - 1]) & BidiBase.MASK_WS) != 0; --n) {
        }
        while (n > 0 && byArray2[n - 1] == by) {
            --n;
        }
        bidiBase.trailingWSStart = n;
    }

    public static Bidi setLine(Bidi bidi, BidiBase bidiBase, Bidi bidi2, BidiBase bidiBase2, int n, int n2) {
        BidiBase bidiBase3 = bidiBase2;
        bidiBase3.originalLength = bidiBase3.resultLength = n2 - n;
        bidiBase3.length = bidiBase3.resultLength;
        int n3 = bidiBase3.resultLength;
        bidiBase3.text = new char[n3];
        System.arraycopy(bidiBase.text, n, bidiBase3.text, 0, n3);
        bidiBase3.paraLevel = bidiBase.GetParaLevelAt(n);
        bidiBase3.paraCount = bidiBase.paraCount;
        bidiBase3.runs = new BidiRun[0];
        if (bidiBase.controlCount > 0) {
            for (int i = n; i < n2; ++i) {
                if (!BidiBase.IsBidiControlChar(bidiBase.text[i])) continue;
                ++bidiBase3.controlCount;
            }
            bidiBase3.resultLength -= bidiBase3.controlCount;
        }
        bidiBase3.getDirPropsMemory(n3);
        bidiBase3.dirProps = bidiBase3.dirPropsMemory;
        System.arraycopy(bidiBase.dirProps, n, bidiBase3.dirProps, 0, n3);
        bidiBase3.getLevelsMemory(n3);
        bidiBase3.levels = bidiBase3.levelsMemory;
        System.arraycopy(bidiBase.levels, n, bidiBase3.levels, 0, n3);
        bidiBase3.runCount = -1;
        if (bidiBase.direction != 2) {
            bidiBase3.direction = bidiBase.direction;
            bidiBase3.trailingWSStart = bidiBase.trailingWSStart <= n ? 0 : (bidiBase.trailingWSStart < n2 ? bidiBase.trailingWSStart - n : n3);
        } else {
            byte[] byArray = bidiBase3.levels;
            BidiLine.setTrailingWSStart(bidiBase3);
            int n4 = bidiBase3.trailingWSStart;
            if (n4 == 0) {
                bidiBase3.direction = (byte)(bidiBase3.paraLevel & 1);
            } else {
                byte by = (byte)(byArray[0] & 1);
                if (n4 < n3 && (bidiBase3.paraLevel & 1) != by) {
                    bidiBase3.direction = (byte)2;
                } else {
                    int n5 = 1;
                    while (true) {
                        if (n5 == n4) {
                            bidiBase3.direction = by;
                            break;
                        }
                        if ((byArray[n5] & 1) != by) {
                            bidiBase3.direction = (byte)2;
                            break;
                        }
                        ++n5;
                    }
                }
            }
            switch (bidiBase3.direction) {
                case 0: {
                    bidiBase3.paraLevel = (byte)(bidiBase3.paraLevel + 1 & 0xFFFFFFFE);
                    bidiBase3.trailingWSStart = 0;
                    break;
                }
                case 1: {
                    bidiBase3.paraLevel = (byte)(bidiBase3.paraLevel | 1);
                    bidiBase3.trailingWSStart = 0;
                    break;
                }
            }
        }
        bidiBase2.paraBidi = bidiBase;
        return bidi2;
    }

    static byte getLevelAt(BidiBase bidiBase, int n) {
        if (bidiBase.direction != 2 || n >= bidiBase.trailingWSStart) {
            return bidiBase.GetParaLevelAt(n);
        }
        return bidiBase.levels[n];
    }

    static byte[] getLevels(BidiBase bidiBase) {
        int n = bidiBase.trailingWSStart;
        int n2 = bidiBase.length;
        if (n != n2) {
            Arrays.fill(bidiBase.levels, n, n2, bidiBase.paraLevel);
            bidiBase.trailingWSStart = n2;
        }
        if (n2 < bidiBase.levels.length) {
            byte[] byArray = new byte[n2];
            System.arraycopy(bidiBase.levels, 0, byArray, 0, n2);
            return byArray;
        }
        return bidiBase.levels;
    }

    static BidiRun getLogicalRun(BidiBase bidiBase, int n) {
        BidiRun bidiRun = new BidiRun();
        BidiLine.getRuns(bidiBase);
        int n2 = bidiBase.runCount;
        int n3 = 0;
        int n4 = 0;
        BidiRun bidiRun2 = bidiBase.runs[0];
        for (int i = 0; i < n2; ++i) {
            bidiRun2 = bidiBase.runs[i];
            n4 = bidiRun2.start + bidiRun2.limit - n3;
            if (n >= bidiRun2.start && n < n4) break;
            n3 = bidiRun2.limit;
        }
        bidiRun.start = bidiRun2.start;
        bidiRun.limit = n4;
        bidiRun.level = bidiRun2.level;
        return bidiRun;
    }

    private static void getSingleRun(BidiBase bidiBase, byte by) {
        bidiBase.runs = bidiBase.simpleRuns;
        bidiBase.runCount = 1;
        bidiBase.runs[0] = new BidiRun(0, bidiBase.length, by);
    }

    private static void reorderLine(BidiBase bidiBase, byte by, byte by2) {
        BidiRun bidiRun;
        int n;
        if (by2 <= (by | 1)) {
            return;
        }
        by = (byte)(by + 1);
        BidiRun[] bidiRunArray = bidiBase.runs;
        byte[] byArray = bidiBase.levels;
        int n2 = bidiBase.runCount;
        if (bidiBase.trailingWSStart < bidiBase.length) {
            --n2;
        }
        block0: while ((by2 = (byte)(by2 - 1)) >= by) {
            n = 0;
            while (true) {
                if (n < n2 && byArray[bidiRunArray[n].start] < by2) {
                    ++n;
                    continue;
                }
                if (n >= n2) continue block0;
                int n3 = n;
                while (++n3 < n2 && byArray[bidiRunArray[n3].start] >= by2) {
                }
                for (int i = n3 - 1; n < i; ++n, --i) {
                    bidiRun = bidiRunArray[n];
                    bidiRunArray[n] = bidiRunArray[i];
                    bidiRunArray[i] = bidiRun;
                }
                if (n3 == n2) continue block0;
                n = n3 + 1;
            }
        }
        if ((by & 1) == 0) {
            n = 0;
            if (bidiBase.trailingWSStart == bidiBase.length) {
                --n2;
            }
            while (n < n2) {
                bidiRun = bidiRunArray[n];
                bidiRunArray[n] = bidiRunArray[n2];
                bidiRunArray[n2] = bidiRun;
                ++n;
                --n2;
            }
        }
    }

    static int getRunFromLogicalIndex(BidiBase bidiBase, int n) {
        BidiRun[] bidiRunArray = bidiBase.runs;
        int n2 = bidiBase.runCount;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = bidiRunArray[i].limit - n3;
            int n5 = bidiRunArray[i].start;
            if (n >= n5 && n < n5 + n4) {
                return i;
            }
            n3 += n4;
        }
        throw new IllegalStateException("Internal ICU error in getRunFromLogicalIndex");
    }

    static void getRuns(BidiBase bidiBase) {
        int n;
        int n2;
        if (bidiBase.runCount >= 0) {
            return;
        }
        if (bidiBase.direction != 2) {
            BidiLine.getSingleRun(bidiBase, bidiBase.paraLevel);
        } else {
            int n3;
            n2 = bidiBase.length;
            byte[] byArray = bidiBase.levels;
            byte by = 126;
            n = bidiBase.trailingWSStart;
            int n4 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                if (byArray[n3] == by) continue;
                ++n4;
                by = byArray[n3];
            }
            if (n4 == 1 && n == n2) {
                BidiLine.getSingleRun(bidiBase, byArray[0]);
            } else {
                byte by2 = 62;
                byte by3 = 0;
                if (n < n2) {
                    ++n4;
                }
                bidiBase.getRunsMemory(n4);
                BidiRun[] bidiRunArray = bidiBase.runsMemory;
                int n5 = 0;
                n3 = 0;
                do {
                    int n6 = n3;
                    by = byArray[n3];
                    if (by < by2) {
                        by2 = by;
                    }
                    if (by > by3) {
                        by3 = by;
                    }
                    while (++n3 < n && byArray[n3] == by) {
                    }
                    bidiRunArray[n5] = new BidiRun(n6, n3 - n6, by);
                    ++n5;
                } while (n3 < n);
                if (n < n2) {
                    bidiRunArray[n5] = new BidiRun(n, n2 - n, bidiBase.paraLevel);
                    if (bidiBase.paraLevel < by2) {
                        by2 = bidiBase.paraLevel;
                    }
                }
                bidiBase.runs = bidiRunArray;
                bidiBase.runCount = n4;
                BidiLine.reorderLine(bidiBase, by2, by3);
                n = 0;
                for (n3 = 0; n3 < n4; ++n3) {
                    bidiRunArray[n3].level = byArray[bidiRunArray[n3].start];
                    n = bidiRunArray[n3].limit += n;
                }
                if (n5 < n4) {
                    int n7 = (bidiBase.paraLevel & 1) != 0 ? 0 : n5;
                    bidiRunArray[n7].level = bidiBase.paraLevel;
                }
            }
        }
        if (bidiBase.insertPoints.size > 0) {
            for (int i = 0; i < bidiBase.insertPoints.size; ++i) {
                BidiBase.Point point = bidiBase.insertPoints.points[i];
                n = BidiLine.getRunFromLogicalIndex(bidiBase, point.pos);
                bidiBase.runs[n].insertRemove |= point.flag;
            }
        }
        if (bidiBase.controlCount > 0) {
            for (n = 0; n < bidiBase.length; ++n) {
                char c = bidiBase.text[n];
                if (!BidiBase.IsBidiControlChar(c)) continue;
                n2 = BidiLine.getRunFromLogicalIndex(bidiBase, n);
                --bidiBase.runs[n2].insertRemove;
            }
        }
    }

    static int[] prepareReorder(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray == null || byArray.length <= 0) {
            return null;
        }
        byte by = 62;
        byte by2 = 0;
        int n = byArray.length;
        while (n > 0) {
            byte by3;
            if ((by3 = byArray[--n]) > 62) {
                return null;
            }
            if (by3 < by) {
                by = by3;
            }
            if (by3 <= by2) continue;
            by2 = by3;
        }
        byArray2[0] = by;
        byArray3[0] = by2;
        int[] nArray = new int[byArray.length];
        n = byArray.length;
        while (n > 0) {
            nArray[--n] = n;
        }
        return nArray;
    }

    static int[] reorderVisual(byte[] byArray) {
        byte[] byArray2 = new byte[1];
        byte[] byArray3 = new byte[1];
        int[] nArray = BidiLine.prepareReorder(byArray, byArray2, byArray3);
        if (nArray == null) {
            return null;
        }
        byte by = byArray2[0];
        byte by2 = byArray3[0];
        if (by == by2 && (by & 1) == 0) {
            return nArray;
        }
        by = (byte)(by | 1);
        block0: do {
            int n = 0;
            while (true) {
                if (n < byArray.length && byArray[n] < by2) {
                    ++n;
                    continue;
                }
                if (n >= byArray.length) continue block0;
                int n2 = n;
                while (++n2 < byArray.length && byArray[n2] >= by2) {
                }
                for (int i = n2 - 1; n < i; ++n, --i) {
                    int n3 = nArray[n];
                    nArray[n] = nArray[i];
                    nArray[i] = n3;
                }
                if (n2 == byArray.length) continue block0;
                n = n2 + 1;
            }
        } while ((by2 = (byte)(by2 - 1)) >= by);
        return nArray;
    }

    static int[] getVisualMap(BidiBase bidiBase) {
        int n;
        int n2;
        int n3;
        BidiRun[] bidiRunArray = bidiBase.runs;
        int n4 = bidiBase.length > bidiBase.resultLength ? bidiBase.length : bidiBase.resultLength;
        int[] nArray = new int[n4];
        int n5 = 0;
        int n6 = 0;
        for (n3 = 0; n3 < bidiBase.runCount; ++n3) {
            n2 = bidiRunArray[n3].start;
            n = bidiRunArray[n3].limit;
            if (bidiRunArray[n3].isEvenRun()) {
                do {
                    nArray[n6++] = n2++;
                } while (++n5 < n);
                continue;
            }
            n2 += n - n5;
            do {
                nArray[n6++] = --n2;
            } while (++n5 < n);
        }
        if (bidiBase.insertPoints.size > 0) {
            int n7;
            int n8;
            n3 = 0;
            int n9 = bidiBase.runCount;
            bidiRunArray = bidiBase.runs;
            for (n8 = 0; n8 < n9; ++n8) {
                n7 = bidiRunArray[n8].insertRemove;
                if ((n7 & 5) > 0) {
                    ++n3;
                }
                if ((n7 & 0xA) <= 0) continue;
                ++n3;
            }
            int n10 = bidiBase.resultLength;
            for (n8 = n9 - 1; n8 >= 0 && n3 > 0; --n8) {
                n7 = bidiRunArray[n8].insertRemove;
                if ((n7 & 0xA) > 0) {
                    nArray[--n10] = -1;
                    --n3;
                }
                n5 = n8 > 0 ? bidiRunArray[n8 - 1].limit : 0;
                for (int i = bidiRunArray[n8].limit - 1; i >= n5 && n3 > 0; --i) {
                    nArray[--n10] = nArray[i];
                }
                if ((n7 & 5) <= 0) continue;
                nArray[--n10] = -1;
                --n3;
            }
        } else if (bidiBase.controlCount > 0) {
            n3 = bidiBase.runCount;
            bidiRunArray = bidiBase.runs;
            n5 = 0;
            int n11 = 0;
            int n12 = 0;
            while (n12 < n3) {
                int n13;
                int n14 = bidiRunArray[n12].limit - n5;
                int n15 = bidiRunArray[n12].insertRemove;
                if (n15 == 0 && n11 == n5) {
                    n11 += n14;
                } else if (n15 == 0) {
                    n = bidiRunArray[n12].limit;
                    for (n13 = n5; n13 < n; ++n13) {
                        nArray[n11++] = nArray[n13];
                    }
                } else {
                    n2 = bidiRunArray[n12].start;
                    boolean bl = bidiRunArray[n12].isEvenRun();
                    int n16 = n2 + n14 - 1;
                    for (n13 = 0; n13 < n14; ++n13) {
                        int n17 = bl ? n2 + n13 : n16 - n13;
                        char c = bidiBase.text[n17];
                        if (BidiBase.IsBidiControlChar(c)) continue;
                        nArray[n11++] = n17;
                    }
                }
                ++n12;
                n5 += n14;
            }
        }
        if (n4 == bidiBase.resultLength) {
            return nArray;
        }
        int[] nArray2 = new int[bidiBase.resultLength];
        System.arraycopy(nArray, 0, nArray2, 0, bidiBase.resultLength);
        return nArray2;
    }
}

