;; Copyright (C) 2019-2025 Free Software Foundation, Inc.
;;
;; This file is part of LIBF7, which is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify it under
;; the terms of the GNU General Public License as published by the Free
;; Software Foundation; either version 3, or (at your option) any later
;; version.
;;
;; GCC is distributed in the hope that it will be useful, but WITHOUT ANY
;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.
;;
;; Under Section 7 of GPL version 3, you are granted additional
;; permissions described in the GCC Runtime Library Exception, version
;; 3.1, as published by the Free Software Foundation.
;;
;; You should have received a copy of the GNU General Public License and
;; a copy of the GCC Runtime Library Exception along with this program;
;; see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
;; <http://www.gnu.org/licenses/>.  */

;; Auto-generated file, do not change by hand.
;;
;; Wrappers for double and long double functions to use functions that
;; operate on f7_t, and get f7_t* and const f7_t*.
;;
;; Generated by: f7wraps.sh
;; Included by : libf7-asm.sx
;; WITH_LIBF7_MATH_FUNCTIONS=1
;; WITH_LIBF7_MATH_SYMBOLS=1

;; Functions that usually live in libgcc: __<name>df3 for <name> in:
;; add sub mul div

;; double __adddf3 (double, double)  ; add
#ifdef F7MOD_D_add_
_DEFUN __adddf3
    ALIAS __add
    .global F7_NAME(add)
    ldi     ZH,     hi8(gs(F7_NAME(add)))
    ldi     ZL,     lo8(gs(F7_NAME(add)))
    F7jmp   call_ddd
_ENDF __adddf3
#endif /* F7MOD_D_add_ */

;; double __subdf3 (double, double)  ; sub
#ifdef F7MOD_D_sub_
_DEFUN __subdf3
    ALIAS __sub
    .global F7_NAME(sub)
    ldi     ZH,     hi8(gs(F7_NAME(sub)))
    ldi     ZL,     lo8(gs(F7_NAME(sub)))
    F7jmp   call_ddd
_ENDF __subdf3
#endif /* F7MOD_D_sub_ */

;; double __muldf3 (double, double)  ; mul
#ifdef F7MOD_D_mul_
_DEFUN __muldf3
    ALIAS __mul
    .global F7_NAME(mul)
    ldi     ZH,     hi8(gs(F7_NAME(mul)))
    ldi     ZL,     lo8(gs(F7_NAME(mul)))
    F7jmp   call_ddd
_ENDF __muldf3
#endif /* F7MOD_D_mul_ */

;; double __divdf3 (double, double)  ; div
#ifdef F7MOD_D_div_
_DEFUN __divdf3
    ALIAS __div
    .global F7_NAME(div)
    ldi     ZH,     hi8(gs(F7_NAME(div)))
    ldi     ZL,     lo8(gs(F7_NAME(div)))
    F7jmp   call_ddd
_ENDF __divdf3
#endif /* F7MOD_D_div_ */

;; Functions that usually live in libgcc: __<name>df2 for <name> in:
;; le lt ge gt ne eq unord

;; bool __ledf2 (double, double)  ; le
#ifdef F7MOD_D_le_
_DEFUN __ledf2
    .global F7_NAME(le_impl)
    ldi     ZH,     hi8(gs(F7_NAME(le_impl)))
    ldi     ZL,     lo8(gs(F7_NAME(le_impl)))
    F7jmp   call_xdd
_ENDF __ledf2
#endif /* F7MOD_D_le_ */

;; bool __ltdf2 (double, double)  ; lt
#ifdef F7MOD_D_lt_
_DEFUN __ltdf2
    .global F7_NAME(lt_impl)
    ldi     ZH,     hi8(gs(F7_NAME(lt_impl)))
    ldi     ZL,     lo8(gs(F7_NAME(lt_impl)))
    F7jmp   call_xdd
_ENDF __ltdf2
#endif /* F7MOD_D_lt_ */

;; bool __gedf2 (double, double)  ; ge
#ifdef F7MOD_D_ge_
_DEFUN __gedf2
    .global F7_NAME(ge_impl)
    ldi     ZH,     hi8(gs(F7_NAME(ge_impl)))
    ldi     ZL,     lo8(gs(F7_NAME(ge_impl)))
    F7jmp   call_xdd
_ENDF __gedf2
#endif /* F7MOD_D_ge_ */

;; bool __gtdf2 (double, double)  ; gt
#ifdef F7MOD_D_gt_
_DEFUN __gtdf2
    .global F7_NAME(gt_impl)
    ldi     ZH,     hi8(gs(F7_NAME(gt_impl)))
    ldi     ZL,     lo8(gs(F7_NAME(gt_impl)))
    F7jmp   call_xdd
_ENDF __gtdf2
#endif /* F7MOD_D_gt_ */

;; bool __nedf2 (double, double)  ; ne
#ifdef F7MOD_D_ne_
_DEFUN __nedf2
    .global F7_NAME(ne_impl)
    ldi     ZH,     hi8(gs(F7_NAME(ne_impl)))
    ldi     ZL,     lo8(gs(F7_NAME(ne_impl)))
    F7jmp   call_xdd
_ENDF __nedf2
#endif /* F7MOD_D_ne_ */

;; bool __eqdf2 (double, double)  ; eq
#ifdef F7MOD_D_eq_
_DEFUN __eqdf2
    .global F7_NAME(eq_impl)
    ldi     ZH,     hi8(gs(F7_NAME(eq_impl)))
    ldi     ZL,     lo8(gs(F7_NAME(eq_impl)))
    F7jmp   call_xdd
_ENDF __eqdf2
#endif /* F7MOD_D_eq_ */

;; bool __unorddf2 (double, double)  ; unord
#ifdef F7MOD_D_unord_
_DEFUN __unorddf2
    .global F7_NAME(unord_impl)
    ldi     ZH,     hi8(gs(F7_NAME(unord_impl)))
    ldi     ZL,     lo8(gs(F7_NAME(unord_impl)))
    F7jmp   call_xdd
_ENDF __unorddf2
#endif /* F7MOD_D_unord_ */

;; Functions that usually live in libgcc: __<name> for <name> in:
;; fixdfsi fixdfdi fixunsdfdi fixunsdfsi truncdfsf2

;; type_t __fixdfsi (double)  ; fixdfsi
#ifdef F7MOD_D_fixdfsi_
_DEFUN __fixdfsi
    .global F7_NAME(fixdfsi)
    ldi     ZH,     hi8(gs(F7_NAME(fixdfsi)))
    ldi     ZL,     lo8(gs(F7_NAME(fixdfsi)))
    F7jmp   call_xd
_ENDF __fixdfsi
#endif /* F7MOD_D_fixdfsi_ */

;; type_t __fixdfdi (double)  ; fixdfdi
#ifdef F7MOD_D_fixdfdi_
_DEFUN __fixdfdi
    .global F7_NAME(fixdfdi)
    ldi     ZH,     hi8(gs(F7_NAME(fixdfdi)))
    ldi     ZL,     lo8(gs(F7_NAME(fixdfdi)))
    F7jmp   call_xd
_ENDF __fixdfdi
#endif /* F7MOD_D_fixdfdi_ */

;; type_t __fixunsdfdi (double)  ; fixunsdfdi
#ifdef F7MOD_D_fixunsdfdi_
_DEFUN __fixunsdfdi
    .global F7_NAME(fixunsdfdi)
    ldi     ZH,     hi8(gs(F7_NAME(fixunsdfdi)))
    ldi     ZL,     lo8(gs(F7_NAME(fixunsdfdi)))
    F7jmp   call_xd
_ENDF __fixunsdfdi
#endif /* F7MOD_D_fixunsdfdi_ */

;; type_t __fixunsdfsi (double)  ; fixunsdfsi
#ifdef F7MOD_D_fixunsdfsi_
_DEFUN __fixunsdfsi
    .global F7_NAME(fixunsdfsi)
    ldi     ZH,     hi8(gs(F7_NAME(fixunsdfsi)))
    ldi     ZL,     lo8(gs(F7_NAME(fixunsdfsi)))
    F7jmp   call_xd
_ENDF __fixunsdfsi
#endif /* F7MOD_D_fixunsdfsi_ */

;; type_t __truncdfsf2 (double)  ; truncdfsf2
#ifdef F7MOD_D_truncdfsf2_
_DEFUN __truncdfsf2
    .global F7_NAME(truncdfsf2)
    ldi     ZH,     hi8(gs(F7_NAME(truncdfsf2)))
    ldi     ZL,     lo8(gs(F7_NAME(truncdfsf2)))
    F7jmp   call_xd
_ENDF __truncdfsf2
#endif /* F7MOD_D_truncdfsf2_ */

;; Functions that usually live in libgcc: __<name> for <name> in:
;; floatunsidf floatsidf extendsfdf2

;; double __floatunsidf (type_t)  ; floatunsidf
#ifdef F7MOD_D_floatunsidf_
_DEFUN __floatunsidf
    .global F7_NAME(floatunsidf)
    ldi     ZH,     hi8(gs(F7_NAME(floatunsidf)))
    ldi     ZL,     lo8(gs(F7_NAME(floatunsidf)))
    F7jmp   call_dx
_ENDF __floatunsidf
#endif /* F7MOD_D_floatunsidf_ */

;; double __floatsidf (type_t)  ; floatsidf
#ifdef F7MOD_D_floatsidf_
_DEFUN __floatsidf
    .global F7_NAME(floatsidf)
    ldi     ZH,     hi8(gs(F7_NAME(floatsidf)))
    ldi     ZL,     lo8(gs(F7_NAME(floatsidf)))
    F7jmp   call_dx
_ENDF __floatsidf
#endif /* F7MOD_D_floatsidf_ */

;; double __extendsfdf2 (type_t)  ; extendsfdf2
#ifdef F7MOD_D_extendsfdf2_
_DEFUN __extendsfdf2
    .global F7_NAME(extendsfdf2)
    ldi     ZH,     hi8(gs(F7_NAME(extendsfdf2)))
    ldi     ZL,     lo8(gs(F7_NAME(extendsfdf2)))
    F7jmp   call_dx
_ENDF __extendsfdf2
#endif /* F7MOD_D_extendsfdf2_ */

;; Functions that usually live in libm:  Depending on [long] double layout,
;; define <name> and <name>l as weak alias(es) of __<name> for <name> in:
;; pow fmin fmax fmod hypot atan2

;; double __pow (double, double)
#ifdef F7MOD_D_pow_
_DEFUN __pow
    DALIAS pow
    LALIAS powl
    .global F7_NAME(pow)
    ldi     ZH,     hi8(gs(F7_NAME(pow)))
    ldi     ZL,     lo8(gs(F7_NAME(pow)))
    F7jmp   call_ddd
_ENDF __pow
#endif /* F7MOD_D_pow_ */

;; double __fmin (double, double)
#ifdef F7MOD_D_fmin_
_DEFUN __fmin
    DALIAS fmin
    LALIAS fminl
    .global F7_NAME(fmin)
    ldi     ZH,     hi8(gs(F7_NAME(fmin)))
    ldi     ZL,     lo8(gs(F7_NAME(fmin)))
    F7jmp   call_ddd
_ENDF __fmin
#endif /* F7MOD_D_fmin_ */

;; double __fmax (double, double)
#ifdef F7MOD_D_fmax_
_DEFUN __fmax
    DALIAS fmax
    LALIAS fmaxl
    .global F7_NAME(fmax)
    ldi     ZH,     hi8(gs(F7_NAME(fmax)))
    ldi     ZL,     lo8(gs(F7_NAME(fmax)))
    F7jmp   call_ddd
_ENDF __fmax
#endif /* F7MOD_D_fmax_ */

;; double __fmod (double, double)
#ifdef F7MOD_D_fmod_
_DEFUN __fmod
    DALIAS fmod
    LALIAS fmodl
    .global F7_NAME(fmod)
    ldi     ZH,     hi8(gs(F7_NAME(fmod)))
    ldi     ZL,     lo8(gs(F7_NAME(fmod)))
    F7jmp   call_ddd
_ENDF __fmod
#endif /* F7MOD_D_fmod_ */

;; double __hypot (double, double)
#ifdef F7MOD_D_hypot_
_DEFUN __hypot
    DALIAS hypot
    LALIAS hypotl
    .global F7_NAME(hypot)
    ldi     ZH,     hi8(gs(F7_NAME(hypot)))
    ldi     ZL,     lo8(gs(F7_NAME(hypot)))
    F7jmp   call_ddd
_ENDF __hypot
#endif /* F7MOD_D_hypot_ */

;; double __atan2 (double, double)
#ifdef F7MOD_D_atan2_
_DEFUN __atan2
    DALIAS atan2
    LALIAS atan2l
    .global F7_NAME(atan2)
    ldi     ZH,     hi8(gs(F7_NAME(atan2)))
    ldi     ZL,     lo8(gs(F7_NAME(atan2)))
    F7jmp   call_ddd
_ENDF __atan2
#endif /* F7MOD_D_atan2_ */

;; Functions that usually live in libm:  Depending on [long] double layout,
;; define <name> and <name>l as weak alias(es) of __<name> for <name> in:
;; ldexp frexp

;; double __ldexp (double, word_t)
#ifdef F7MOD_D_ldexp_
_DEFUN __ldexp
    DALIAS ldexp
    LALIAS ldexpl
    .global F7_NAME(ldexp)
    ldi     ZH,     hi8(gs(F7_NAME(ldexp)))
    ldi     ZL,     lo8(gs(F7_NAME(ldexp)))
    F7jmp   call_ddx
_ENDF __ldexp
#endif /* F7MOD_D_ldexp_ */

;; double __frexp (double, word_t)
#ifdef F7MOD_D_frexp_
_DEFUN __frexp
    DALIAS frexp
    LALIAS frexpl
    .global F7_NAME(frexp)
    ldi     ZH,     hi8(gs(F7_NAME(frexp)))
    ldi     ZL,     lo8(gs(F7_NAME(frexp)))
    F7jmp   call_ddx
_ENDF __frexp
#endif /* F7MOD_D_frexp_ */

;; Functions that usually live in libm:  Depending on [long] double layout,
;; define <name> and <name>l as weak alias(es) of __<name> for <name> in:
;; sqrt cbrt exp exp10 pow10 log log10 log2 sin cos tan cotan asin acos atan ceil floor trunc round sinh cosh tanh

;; double __sqrt (double)
#ifdef F7MOD_D_sqrt_
_DEFUN __sqrt
    DALIAS sqrt
    LALIAS sqrtl
    .global F7_NAME(sqrt)
    ldi     ZH,     hi8(gs(F7_NAME(sqrt)))
    ldi     ZL,     lo8(gs(F7_NAME(sqrt)))
    F7jmp   call_dd
_ENDF __sqrt
#endif /* F7MOD_D_sqrt_ */

;; double __cbrt (double)
#ifdef F7MOD_D_cbrt_
_DEFUN __cbrt
    DALIAS cbrt
    LALIAS cbrtl
    .global F7_NAME(cbrt)
    ldi     ZH,     hi8(gs(F7_NAME(cbrt)))
    ldi     ZL,     lo8(gs(F7_NAME(cbrt)))
    F7jmp   call_dd
_ENDF __cbrt
#endif /* F7MOD_D_cbrt_ */

;; double __exp (double)
#ifdef F7MOD_D_exp_
_DEFUN __exp
    DALIAS exp
    LALIAS expl
    .global F7_NAME(exp)
    ldi     ZH,     hi8(gs(F7_NAME(exp)))
    ldi     ZL,     lo8(gs(F7_NAME(exp)))
    F7jmp   call_dd
_ENDF __exp
#endif /* F7MOD_D_exp_ */

;; double __exp10 (double)
#ifdef F7MOD_D_exp10_
_DEFUN __exp10
    DALIAS exp10
    LALIAS exp10l
    .global F7_NAME(exp10)
    ldi     ZH,     hi8(gs(F7_NAME(exp10)))
    ldi     ZL,     lo8(gs(F7_NAME(exp10)))
    F7jmp   call_dd
_ENDF __exp10
#endif /* F7MOD_D_exp10_ */

;; double __pow10 (double)
#ifdef F7MOD_D_pow10_
_DEFUN __pow10
    DALIAS pow10
    LALIAS pow10l
    .global F7_NAME(pow10)
    ldi     ZH,     hi8(gs(F7_NAME(pow10)))
    ldi     ZL,     lo8(gs(F7_NAME(pow10)))
    F7jmp   call_dd
_ENDF __pow10
#endif /* F7MOD_D_pow10_ */

;; double __log (double)
#ifdef F7MOD_D_log_
_DEFUN __log
    DALIAS log
    LALIAS logl
    .global F7_NAME(log)
    ldi     ZH,     hi8(gs(F7_NAME(log)))
    ldi     ZL,     lo8(gs(F7_NAME(log)))
    F7jmp   call_dd
_ENDF __log
#endif /* F7MOD_D_log_ */

;; double __log10 (double)
#ifdef F7MOD_D_log10_
_DEFUN __log10
    DALIAS log10
    LALIAS log10l
    .global F7_NAME(log10)
    ldi     ZH,     hi8(gs(F7_NAME(log10)))
    ldi     ZL,     lo8(gs(F7_NAME(log10)))
    F7jmp   call_dd
_ENDF __log10
#endif /* F7MOD_D_log10_ */

;; double __log2 (double)
#ifdef F7MOD_D_log2_
_DEFUN __log2
    DALIAS log2
    LALIAS log2l
    .global F7_NAME(log2)
    ldi     ZH,     hi8(gs(F7_NAME(log2)))
    ldi     ZL,     lo8(gs(F7_NAME(log2)))
    F7jmp   call_dd
_ENDF __log2
#endif /* F7MOD_D_log2_ */

;; double __sin (double)
#ifdef F7MOD_D_sin_
_DEFUN __sin
    DALIAS sin
    LALIAS sinl
    .global F7_NAME(sin)
    ldi     ZH,     hi8(gs(F7_NAME(sin)))
    ldi     ZL,     lo8(gs(F7_NAME(sin)))
    F7jmp   call_dd
_ENDF __sin
#endif /* F7MOD_D_sin_ */

;; double __cos (double)
#ifdef F7MOD_D_cos_
_DEFUN __cos
    DALIAS cos
    LALIAS cosl
    .global F7_NAME(cos)
    ldi     ZH,     hi8(gs(F7_NAME(cos)))
    ldi     ZL,     lo8(gs(F7_NAME(cos)))
    F7jmp   call_dd
_ENDF __cos
#endif /* F7MOD_D_cos_ */

;; double __tan (double)
#ifdef F7MOD_D_tan_
_DEFUN __tan
    DALIAS tan
    LALIAS tanl
    .global F7_NAME(tan)
    ldi     ZH,     hi8(gs(F7_NAME(tan)))
    ldi     ZL,     lo8(gs(F7_NAME(tan)))
    F7jmp   call_dd
_ENDF __tan
#endif /* F7MOD_D_tan_ */

;; double __cotan (double)
#ifdef F7MOD_D_cotan_
_DEFUN __cotan
    DALIAS cotan
    LALIAS cotanl
    .global F7_NAME(cotan)
    ldi     ZH,     hi8(gs(F7_NAME(cotan)))
    ldi     ZL,     lo8(gs(F7_NAME(cotan)))
    F7jmp   call_dd
_ENDF __cotan
#endif /* F7MOD_D_cotan_ */

;; double __asin (double)
#ifdef F7MOD_D_asin_
_DEFUN __asin
    DALIAS asin
    LALIAS asinl
    .global F7_NAME(asin)
    ldi     ZH,     hi8(gs(F7_NAME(asin)))
    ldi     ZL,     lo8(gs(F7_NAME(asin)))
    F7jmp   call_dd
_ENDF __asin
#endif /* F7MOD_D_asin_ */

;; double __acos (double)
#ifdef F7MOD_D_acos_
_DEFUN __acos
    DALIAS acos
    LALIAS acosl
    .global F7_NAME(acos)
    ldi     ZH,     hi8(gs(F7_NAME(acos)))
    ldi     ZL,     lo8(gs(F7_NAME(acos)))
    F7jmp   call_dd
_ENDF __acos
#endif /* F7MOD_D_acos_ */

;; double __atan (double)
#ifdef F7MOD_D_atan_
_DEFUN __atan
    DALIAS atan
    LALIAS atanl
    .global F7_NAME(atan)
    ldi     ZH,     hi8(gs(F7_NAME(atan)))
    ldi     ZL,     lo8(gs(F7_NAME(atan)))
    F7jmp   call_dd
_ENDF __atan
#endif /* F7MOD_D_atan_ */

;; double __ceil (double)
#ifdef F7MOD_D_ceil_
_DEFUN __ceil
    DALIAS ceil
    LALIAS ceill
    .global F7_NAME(ceil)
    ldi     ZH,     hi8(gs(F7_NAME(ceil)))
    ldi     ZL,     lo8(gs(F7_NAME(ceil)))
    F7jmp   call_dd
_ENDF __ceil
#endif /* F7MOD_D_ceil_ */

;; double __floor (double)
#ifdef F7MOD_D_floor_
_DEFUN __floor
    DALIAS floor
    LALIAS floorl
    .global F7_NAME(floor)
    ldi     ZH,     hi8(gs(F7_NAME(floor)))
    ldi     ZL,     lo8(gs(F7_NAME(floor)))
    F7jmp   call_dd
_ENDF __floor
#endif /* F7MOD_D_floor_ */

;; double __trunc (double)
#ifdef F7MOD_D_trunc_
_DEFUN __trunc
    DALIAS trunc
    LALIAS truncl
    .global F7_NAME(trunc)
    ldi     ZH,     hi8(gs(F7_NAME(trunc)))
    ldi     ZL,     lo8(gs(F7_NAME(trunc)))
    F7jmp   call_dd
_ENDF __trunc
#endif /* F7MOD_D_trunc_ */

;; double __round (double)
#ifdef F7MOD_D_round_
_DEFUN __round
    DALIAS round
    LALIAS roundl
    .global F7_NAME(round)
    ldi     ZH,     hi8(gs(F7_NAME(round)))
    ldi     ZL,     lo8(gs(F7_NAME(round)))
    F7jmp   call_dd
_ENDF __round
#endif /* F7MOD_D_round_ */

;; double __sinh (double)
#ifdef F7MOD_D_sinh_
_DEFUN __sinh
    DALIAS sinh
    LALIAS sinhl
    .global F7_NAME(sinh)
    ldi     ZH,     hi8(gs(F7_NAME(sinh)))
    ldi     ZL,     lo8(gs(F7_NAME(sinh)))
    F7jmp   call_dd
_ENDF __sinh
#endif /* F7MOD_D_sinh_ */

;; double __cosh (double)
#ifdef F7MOD_D_cosh_
_DEFUN __cosh
    DALIAS cosh
    LALIAS coshl
    .global F7_NAME(cosh)
    ldi     ZH,     hi8(gs(F7_NAME(cosh)))
    ldi     ZL,     lo8(gs(F7_NAME(cosh)))
    F7jmp   call_dd
_ENDF __cosh
#endif /* F7MOD_D_cosh_ */

;; double __tanh (double)
#ifdef F7MOD_D_tanh_
_DEFUN __tanh
    DALIAS tanh
    LALIAS tanhl
    .global F7_NAME(tanh)
    ldi     ZH,     hi8(gs(F7_NAME(tanh)))
    ldi     ZL,     lo8(gs(F7_NAME(tanh)))
    F7jmp   call_dd
_ENDF __tanh
#endif /* F7MOD_D_tanh_ */

;; Functions that usually live in libm:  Depending on [long] double layout,
;; define <name> and <name>l as weak alias(es) of __<name> for <name> in:
;; lrint lround

;; type_t __lrint (double)
#ifdef F7MOD_D_lrint_
_DEFUN __lrint
    DALIAS lrint
    LALIAS lrintl
    .global F7_NAME(lrint)
    ldi     ZH,     hi8(gs(F7_NAME(lrint)))
    ldi     ZL,     lo8(gs(F7_NAME(lrint)))
    F7jmp   call_xd
_ENDF __lrint
#endif /* F7MOD_D_lrint_ */

;; type_t __lround (double)
#ifdef F7MOD_D_lround_
_DEFUN __lround
    DALIAS lround
    LALIAS lroundl
    .global F7_NAME(lround)
    ldi     ZH,     hi8(gs(F7_NAME(lround)))
    ldi     ZL,     lo8(gs(F7_NAME(lround)))
    F7jmp   call_xd
_ENDF __lround
#endif /* F7MOD_D_lround_ */
