/* SPDX-License-Identifier: GPL-2.0 */
#ifndef __DRM_MCDE_DSI_REGS
#define __DRM_MCDE_DSI_REGS

#define DSI_MCTL_INTEGRATION_MODE 0x00000000

#define DSI_MCTL_MAIN_DATA_CTL 0x00000004
#define DSI_MCTL_MAIN_DATA_CTL_LINK_EN BIT(0)
#define DSI_MCTL_MAIN_DATA_CTL_IF1_MODE BIT(1)
#define DSI_MCTL_MAIN_DATA_CTL_VID_EN BIT(2)
#define DSI_MCTL_MAIN_DATA_CTL_TVG_SEL BIT(3)
#define DSI_MCTL_MAIN_DATA_CTL_TBG_SEL BIT(4)
#define DSI_MCTL_MAIN_DATA_CTL_IF1_TE_EN BIT(5)
#define DSI_MCTL_MAIN_DATA_CTL_IF2_TE_EN BIT(6)
#define DSI_MCTL_MAIN_DATA_CTL_REG_TE_EN BIT(7)
#define DSI_MCTL_MAIN_DATA_CTL_READ_EN BIT(8)
#define DSI_MCTL_MAIN_DATA_CTL_BTA_EN BIT(9)
#define DSI_MCTL_MAIN_DATA_CTL_DISP_GEN_ECC BIT(10)
#define DSI_MCTL_MAIN_DATA_CTL_DISP_GEN_CHECKSUM BIT(11)
#define DSI_MCTL_MAIN_DATA_CTL_HOST_EOT_GEN BIT(12)
#define DSI_MCTL_MAIN_DATA_CTL_DISP_EOT_GEN BIT(13)
#define DSI_MCTL_MAIN_DATA_CTL_DLX_REMAP_EN BIT(14)
#define DSI_MCTL_MAIN_DATA_CTL_TE_POLLING_EN BIT(15)

#define DSI_MCTL_MAIN_PHY_CTL 0x00000008
#define DSI_MCTL_MAIN_PHY_CTL_LANE2_EN BIT(0)
#define DSI_MCTL_MAIN_PHY_CTL_FORCE_STOP_MODE BIT(1)
#define DSI_MCTL_MAIN_PHY_CTL_CLK_CONTINUOUS BIT(2)
#define DSI_MCTL_MAIN_PHY_CTL_CLK_ULPM_EN BIT(3)
#define DSI_MCTL_MAIN_PHY_CTL_DAT1_ULPM_EN BIT(4)
#define DSI_MCTL_MAIN_PHY_CTL_DAT2_ULPM_EN BIT(5)
#define DSI_MCTL_MAIN_PHY_CTL_WAIT_BURST_TIME_SHIFT 6
#define DSI_MCTL_MAIN_PHY_CTL_WAIT_BURST_TIME_MASK 0x000003C0
#define DSI_MCTL_MAIN_PHY_CTL_CLOCK_FORCE_STOP_MODE BIT(10)

#define DSI_MCTL_PLL_CTL 0x0000000C
#define DSI_MCTL_LANE_STS 0x00000010

#define DSI_MCTL_DPHY_TIMEOUT 0x00000014
#define DSI_MCTL_DPHY_TIMEOUT_CLK_DIV_SHIFT 0
#define DSI_MCTL_DPHY_TIMEOUT_CLK_DIV_MASK 0x0000000F
#define DSI_MCTL_DPHY_TIMEOUT_HSTX_TO_VAL_SHIFT 4
#define DSI_MCTL_DPHY_TIMEOUT_HSTX_TO_VAL_MASK 0x0003FFF0
#define DSI_MCTL_DPHY_TIMEOUT_LPRX_TO_VAL_SHIFT 18
#define DSI_MCTL_DPHY_TIMEOUT_LPRX_TO_VAL_MASK 0xFFFC0000

#define DSI_MCTL_ULPOUT_TIME 0x00000018
#define DSI_MCTL_ULPOUT_TIME_CKLANE_ULPOUT_TIME_SHIFT 0
#define DSI_MCTL_ULPOUT_TIME_CKLANE_ULPOUT_TIME_MASK 0x000001FF
#define DSI_MCTL_ULPOUT_TIME_DATA_ULPOUT_TIME_SHIFT 9
#define DSI_MCTL_ULPOUT_TIME_DATA_ULPOUT_TIME_MASK 0x0003FE00

#define DSI_MCTL_DPHY_STATIC 0x0000001C
#define DSI_MCTL_DPHY_STATIC_SWAP_PINS_CLK BIT(0)
#define DSI_MCTL_DPHY_STATIC_HS_INVERT_CLK BIT(1)
#define DSI_MCTL_DPHY_STATIC_SWAP_PINS_DAT1 BIT(2)
#define DSI_MCTL_DPHY_STATIC_HS_INVERT_DAT1 BIT(3)
#define DSI_MCTL_DPHY_STATIC_SWAP_PINS_DAT2 BIT(4)
#define DSI_MCTL_DPHY_STATIC_HS_INVERT_DAT2 BIT(5)
#define DSI_MCTL_DPHY_STATIC_UI_X4_SHIFT 6
#define DSI_MCTL_DPHY_STATIC_UI_X4_MASK 0x00000FC0

#define DSI_MCTL_MAIN_EN 0x00000020
#define DSI_MCTL_MAIN_EN_PLL_START BIT(0)
#define DSI_MCTL_MAIN_EN_CKLANE_EN BIT(3)
#define DSI_MCTL_MAIN_EN_DAT1_EN BIT(4)
#define DSI_MCTL_MAIN_EN_DAT2_EN BIT(5)
#define DSI_MCTL_MAIN_EN_CLKLANE_ULPM_REQ BIT(6)
#define DSI_MCTL_MAIN_EN_DAT1_ULPM_REQ BIT(7)
#define DSI_MCTL_MAIN_EN_DAT2_ULPM_REQ BIT(8)
#define DSI_MCTL_MAIN_EN_IF1_EN BIT(9)
#define DSI_MCTL_MAIN_EN_IF2_EN BIT(10)

#define DSI_MCTL_MAIN_STS 0x00000024
#define DSI_MCTL_MAIN_STS_PLL_LOCK BIT(0)
#define DSI_MCTL_MAIN_STS_CLKLANE_READY BIT(1)
#define DSI_MCTL_MAIN_STS_DAT1_READY BIT(2)
#define DSI_MCTL_MAIN_STS_DAT2_READY BIT(3)
#define DSI_MCTL_MAIN_STS_HSTX_TO_ERR BIT(4)
#define DSI_MCTL_MAIN_STS_LPRX_TO_ERR BIT(5)
#define DSI_MCTL_MAIN_STS_CRS_UNTERM_PCK BIT(6)
#define DSI_MCTL_MAIN_STS_VRS_UNTERM_PCK BIT(7)

#define DSI_MCTL_DPHY_ERR 0x00000028
#define DSI_INT_VID_RDDATA 0x00000030
#define DSI_INT_VID_GNT 0x00000034
#define DSI_INT_CMD_RDDATA 0x00000038
#define DSI_INT_CMD_GNT 0x0000003C
#define DSI_INT_INTERRUPT_CTL 0x00000040

#define DSI_CMD_MODE_CTL 0x00000050
#define DSI_CMD_MODE_CTL_IF1_ID_SHIFT 0
#define DSI_CMD_MODE_CTL_IF1_ID_MASK 0x00000003
#define DSI_CMD_MODE_CTL_IF2_ID_SHIFT 2
#define DSI_CMD_MODE_CTL_IF2_ID_MASK 0x0000000C
#define DSI_CMD_MODE_CTL_IF1_LP_EN BIT(4)
#define DSI_CMD_MODE_CTL_IF2_LP_EN BIT(5)
#define DSI_CMD_MODE_CTL_ARB_MODE BIT(6)
#define DSI_CMD_MODE_CTL_ARB_PRI BIT(7)
#define DSI_CMD_MODE_CTL_FIL_VALUE_SHIFT 8
#define DSI_CMD_MODE_CTL_FIL_VALUE_MASK 0x0000FF00
#define DSI_CMD_MODE_CTL_TE_TIMEOUT_SHIFT 16
#define DSI_CMD_MODE_CTL_TE_TIMEOUT_MASK 0x03FF0000

#define DSI_CMD_MODE_STS 0x00000054
#define DSI_CMD_MODE_STS_ERR_NO_TE BIT(0)
#define DSI_CMD_MODE_STS_ERR_TE_MISS BIT(1)
#define DSI_CMD_MODE_STS_ERR_SDI1_UNDERRUN BIT(2)
#define DSI_CMD_MODE_STS_ERR_SDI2_UNDERRUN BIT(3)
#define DSI_CMD_MODE_STS_ERR_UNWANTED_RD BIT(4)
#define DSI_CMD_MODE_STS_CSM_RUNNING BIT(5)

#define DSI_DIRECT_CMD_SEND 0x00000060

#define DSI_DIRECT_CMD_MAIN_SETTINGS 0x00000064
#define DSI_DIRECT_CMD_MAIN_SETTINGS_CMD_NAT_SHIFT 0
#define DSI_DIRECT_CMD_MAIN_SETTINGS_CMD_NAT_MASK 0x00000007
#define DSI_DIRECT_CMD_MAIN_SETTINGS_CMD_NAT_WRITE 0
#define DSI_DIRECT_CMD_MAIN_SETTINGS_CMD_NAT_READ 1
#define DSI_DIRECT_CMD_MAIN_SETTINGS_CMD_NAT_TE_REQ 4
#define DSI_DIRECT_CMD_MAIN_SETTINGS_CMD_NAT_TRIG_REQ 5
#define DSI_DIRECT_CMD_MAIN_SETTINGS_CMD_NAT_BTA_REQ 6
#define DSI_DIRECT_CMD_MAIN_SETTINGS_CMD_LONGNOTSHORT BIT(3)
#define DSI_DIRECT_CMD_MAIN_SETTINGS_CMD_HEAD_SHIFT 8
#define DSI_DIRECT_CMD_MAIN_SETTINGS_CMD_HEAD_MASK 0x00003F00
#define DSI_DIRECT_CMD_MAIN_SETTINGS_CMD_ID_SHIFT 14
#define DSI_DIRECT_CMD_MAIN_SETTINGS_CMD_SIZE_SHIFT 16
#define DSI_DIRECT_CMD_MAIN_SETTINGS_CMD_LP_EN BIT(21)
#define DSI_DIRECT_CMD_MAIN_SETTINGS_TRIGGER_VAL_SHIFT 24
#define DSI_DIRECT_CMD_MAIN_SETTINGS_TRIGGER_VAL_MASK 0x0F000000

#define DSI_DIRECT_CMD_STS 0x00000068
#define DSI_DIRECT_CMD_STS_CMD_TRANSMISSION BIT(0)
#define DSI_DIRECT_CMD_STS_WRITE_COMPLETED BIT(1)
#define DSI_DIRECT_CMD_STS_TRIGGER_COMPLETED BIT(2)
#define DSI_DIRECT_CMD_STS_READ_COMPLETED BIT(3)
#define DSI_DIRECT_CMD_STS_ACKNOWLEDGE_RECEIVED_SHIFT BIT(4)
#define DSI_DIRECT_CMD_STS_ACKNOWLEDGE_WITH_ERR_RECEIVED BIT(5)
#define DSI_DIRECT_CMD_STS_TRIGGER_RECEIVED BIT(6)
#define DSI_DIRECT_CMD_STS_TE_RECEIVED BIT(7)
#define DSI_DIRECT_CMD_STS_BTA_COMPLETED BIT(8)
#define DSI_DIRECT_CMD_STS_BTA_FINISHED BIT(9)
#define DSI_DIRECT_CMD_STS_READ_COMPLETED_WITH_ERR BIT(10)
#define DSI_DIRECT_CMD_STS_TRIGGER_VAL_MASK 0x00007800
#define DSI_DIRECT_CMD_STS_TRIGGER_VAL_SHIFT 11
#define DSI_DIRECT_CMD_STS_ACK_VAL_SHIFT 16
#define DSI_DIRECT_CMD_STS_ACK_VAL_MASK 0xFFFF0000

#define DSI_DIRECT_CMD_RD_INIT 0x0000006C
#define DSI_DIRECT_CMD_RD_INIT_RESET_SHIFT 0
#define DSI_DIRECT_CMD_RD_INIT_RESET_MASK 0xFFFFFFFF

#define DSI_DIRECT_CMD_WRDAT0 0x00000070
#define DSI_DIRECT_CMD_WRDAT1 0x00000074
#define DSI_DIRECT_CMD_WRDAT2 0x00000078
#define DSI_DIRECT_CMD_WRDAT3 0x0000007C

#define DSI_DIRECT_CMD_RDDAT 0x00000080

#define DSI_DIRECT_CMD_RD_PROPERTY 0x00000084
#define DSI_DIRECT_CMD_RD_PROPERTY_RD_SIZE_SHIFT 0
#define DSI_DIRECT_CMD_RD_PROPERTY_RD_SIZE_MASK 0x0000FFFF
#define DSI_DIRECT_CMD_RD_PROPERTY_RD_ID_SHIFT 16
#define DSI_DIRECT_CMD_RD_PROPERTY_RD_ID_MASK 0x00030000
#define DSI_DIRECT_CMD_RD_PROPERTY_RD_DCSNOTGENERIC_SHIFT 18
#define DSI_DIRECT_CMD_RD_PROPERTY_RD_DCSNOTGENERIC_MASK 0x00040000

#define DSI_DIRECT_CMD_RD_STS 0x00000088

#define DSI_VID_MAIN_CTL 0x00000090
#define DSI_VID_MAIN_CTL_START_MODE_SHIFT 0
#define DSI_VID_MAIN_CTL_START_MODE_MASK 0x00000003
#define DSI_VID_MAIN_CTL_STOP_MODE_SHIFT 2
#define DSI_VID_MAIN_CTL_STOP_MODE_MASK 0x0000000C
#define DSI_VID_MAIN_CTL_VID_ID_SHIFT 4
#define DSI_VID_MAIN_CTL_VID_ID_MASK 0x00000030
#define DSI_VID_MAIN_CTL_HEADER_SHIFT 6
#define DSI_VID_MAIN_CTL_HEADER_MASK 0x00000FC0
#define DSI_VID_MAIN_CTL_VID_PIXEL_MODE_16BITS 0
#define DSI_VID_MAIN_CTL_VID_PIXEL_MODE_18BITS BIT(12)
#define DSI_VID_MAIN_CTL_VID_PIXEL_MODE_18BITS_LOOSE BIT(13)
#define DSI_VID_MAIN_CTL_VID_PIXEL_MODE_24BITS (BIT(12) | BIT(13))
#define DSI_VID_MAIN_CTL_BURST_MODE BIT(14)
#define DSI_VID_MAIN_CTL_SYNC_PULSE_ACTIVE BIT(15)
#define DSI_VID_MAIN_CTL_SYNC_PULSE_HORIZONTAL BIT(16)
#define DSI_VID_MAIN_CTL_REG_BLKLINE_MODE_NULL 0
#define DSI_VID_MAIN_CTL_REG_BLKLINE_MODE_BLANKING BIT(17)
#define DSI_VID_MAIN_CTL_REG_BLKLINE_MODE_LP_0 BIT(18)
#define DSI_VID_MAIN_CTL_REG_BLKLINE_MODE_LP_1 (BIT(17) | BIT(18))
#define DSI_VID_MAIN_CTL_REG_BLKEOL_MODE_NULL 0
#define DSI_VID_MAIN_CTL_REG_BLKEOL_MODE_BLANKING BIT(19)
#define DSI_VID_MAIN_CTL_REG_BLKEOL_MODE_LP_0 BIT(20)
#define DSI_VID_MAIN_CTL_REG_BLKEOL_MODE_LP_1 (BIT(19) | BIT(20))
#define DSI_VID_MAIN_CTL_RECOVERY_MODE_SHIFT 21
#define DSI_VID_MAIN_CTL_RECOVERY_MODE_MASK 0x00600000

#define DSI_VID_VSIZE 0x00000094
#define DSI_VID_VSIZE_VSA_LENGTH_SHIFT 0
#define DSI_VID_VSIZE_VSA_LENGTH_MASK 0x0000003F
#define DSI_VID_VSIZE_VBP_LENGTH_SHIFT 6
#define DSI_VID_VSIZE_VBP_LENGTH_MASK 0x00000FC0
#define DSI_VID_VSIZE_VFP_LENGTH_SHIFT 12
#define DSI_VID_VSIZE_VFP_LENGTH_MASK 0x000FF000
#define DSI_VID_VSIZE_VACT_LENGTH_SHIFT 20
#define DSI_VID_VSIZE_VACT_LENGTH_MASK 0x7FF00000

#define DSI_VID_HSIZE1 0x00000098
#define DSI_VID_HSIZE1_HSA_LENGTH_SHIFT 0
#define DSI_VID_HSIZE1_HSA_LENGTH_MASK 0x000003FF
#define DSI_VID_HSIZE1_HBP_LENGTH_SHIFT 10
#define DSI_VID_HSIZE1_HBP_LENGTH_MASK 0x000FFC00
#define DSI_VID_HSIZE1_HFP_LENGTH_SHIFT 20
#define DSI_VID_HSIZE1_HFP_LENGTH_MASK 0x7FF00000

#define DSI_VID_HSIZE2 0x0000009C
#define DSI_VID_HSIZE2_RGB_SIZE_SHIFT 0
#define DSI_VID_HSIZE2_RGB_SIZE_MASK 0x00001FFF

#define DSI_VID_BLKSIZE1 0x000000A0
#define DSI_VID_BLKSIZE1_BLKLINE_EVENT_PCK_SHIFT 0
#define DSI_VID_BLKSIZE1_BLKLINE_EVENT_PCK_MASK 0x00001FFF
#define DSI_VID_BLKSIZE1_BLKEOL_PCK_SHIFT 13
#define DSI_VID_BLKSIZE1_BLKEOL_PCK_MASK 0x03FFE000

#define DSI_VID_BLKSIZE2 0x000000A4
#define DSI_VID_BLKSIZE2_BLKLINE_PULSE_PCK_SHIFT 0
#define DSI_VID_BLKSIZE2_BLKLINE_PULSE_PCK_MASK 0x00001FFF

#define DSI_VID_PCK_TIME 0x000000A8
#define DSI_VID_PCK_TIME_BLKEOL_DURATION_SHIFT 0
#define DSI_VID_PCK_TIME_BLKEOL_DURATION_MASK 0x00000FFF

#define DSI_VID_DPHY_TIME 0x000000AC
#define DSI_VID_DPHY_TIME_REG_LINE_DURATION_SHIFT 0
#define DSI_VID_DPHY_TIME_REG_LINE_DURATION_MASK 0x00001FFF
#define DSI_VID_DPHY_TIME_REG_WAKEUP_TIME_SHIFT 13
#define DSI_VID_DPHY_TIME_REG_WAKEUP_TIME_MASK 0x00FFE000

#define DSI_VID_MODE_STS 0x000000BC
#define DSI_VID_MODE_STS_VSG_RUNNING BIT(0)
#define DSI_VID_MODE_STS_ERR_MISSING_DATA BIT(1)
#define DSI_VID_MODE_STS_ERR_MISSING_HSYNC BIT(2)
#define DSI_VID_MODE_STS_ERR_MISSING_VSYNC BIT(3)
#define DSI_VID_MODE_STS_REG_ERR_SMALL_LENGTH BIT(4)
#define DSI_VID_MODE_STS_REG_ERR_SMALL_HEIGHT BIT(5)
#define DSI_VID_MODE_STS_ERR_BURSTWRITE BIT(6)
#define DSI_VID_MODE_STS_ERR_LINEWRITE BIT(7)
#define DSI_VID_MODE_STS_ERR_LONGREAD BIT(8)
#define DSI_VID_MODE_STS_ERR_VRS_WRONG_LENGTH BIT(9)
#define DSI_VID_MODE_STS_VSG_RECOVERY BIT(10)

#define DSI_VID_VCA_SETTING1 0x000000C0
#define DSI_VID_VCA_SETTING1_MAX_BURST_LIMIT_SHIFT 0
#define DSI_VID_VCA_SETTING1_MAX_BURST_LIMIT_MASK 0x0000FFFF
#define DSI_VID_VCA_SETTING1_BURST_LP BIT(16)

#define DSI_VID_VCA_SETTING2 0x000000C4
#define DSI_VID_VCA_SETTING2_EXACT_BURST_LIMIT_SHIFT 0
#define DSI_VID_VCA_SETTING2_EXACT_BURST_LIMIT_MASK 0x0000FFFF
#define DSI_VID_VCA_SETTING2_MAX_LINE_LIMIT_SHIFT 16
#define DSI_VID_VCA_SETTING2_MAX_LINE_LIMIT_MASK 0xFFFF0000

#define DSI_CMD_MODE_STS_CTL 0x000000F4
#define DSI_CMD_MODE_STS_CTL_ERR_NO_TE_EN BIT(0)
#define DSI_CMD_MODE_STS_CTL_ERR_TE_MISS_EN BIT(1)
#define DSI_CMD_MODE_STS_CTL_ERR_SDI1_UNDERRUN_EN BIT(2)
#define DSI_CMD_MODE_STS_CTL_ERR_SDI2_UNDERRUN_EN BIT(3)
#define DSI_CMD_MODE_STS_CTL_ERR_UNWANTED_RD_EN BIT(4)
#define DSI_CMD_MODE_STS_CTL_CSM_RUNNING_EN BIT(5)
#define DSI_CMD_MODE_STS_CTL_ERR_NO_TE_EDGE BIT(16)
#define DSI_CMD_MODE_STS_CTL_ERR_TE_MISS_EDGE BIT(17)
#define DSI_CMD_MODE_STS_CTL_ERR_SDI1_UNDERRUN_EDGE BIT(18)
#define DSI_CMD_MODE_STS_CTL_ERR_SDI2_UNDERRUN_EDGE BIT(19)
#define DSI_CMD_MODE_STS_CTL_ERR_UNWANTED_RD_EDGE BIT(20)
#define DSI_CMD_MODE_STS_CTL_CSM_RUNNING_EDGE BIT(21)

#define DSI_DIRECT_CMD_STS_CTL 0x000000F8
#define DSI_DIRECT_CMD_STS_CTL_CMD_TRANSMISSION_EN BIT(0)
#define DSI_DIRECT_CMD_STS_CTL_WRITE_COMPLETED_EN BIT(1)
#define DSI_DIRECT_CMD_STS_CTL_TRIGGER_COMPLETED_EN BIT(2)
#define DSI_DIRECT_CMD_STS_CTL_READ_COMPLETED_EN BIT(3)
#define DSI_DIRECT_CMD_STS_CTL_ACKNOWLEDGE_RECEIVED_EN BIT(4)
#define DSI_DIRECT_CMD_STS_CTL_ACKNOWLEDGE_WITH_ERR_EN BIT(5)
#define DSI_DIRECT_CMD_STS_CTL_TRIGGER_RECEIVED_EN BIT(6)
#define DSI_DIRECT_CMD_STS_CTL_TE_RECEIVED_EN BIT(7)
#define DSI_DIRECT_CMD_STS_CTL_BTA_COMPLETED_EN BIT(8)
#define DSI_DIRECT_CMD_STS_CTL_BTA_FINISHED_EN BIT(9)
#define DSI_DIRECT_CMD_STS_CTL_READ_COMPLETED_WITH_ERR_EN BIT(10)
#define DSI_DIRECT_CMD_STS_CTL_CMD_TRANSMISSION_EDGE BIT(16)
#define DSI_DIRECT_CMD_STS_CTL_WRITE_COMPLETED_EDGE BIT(17)
#define DSI_DIRECT_CMD_STS_CTL_TRIGGER_COMPLETED_EDGE BIT(18)
#define DSI_DIRECT_CMD_STS_CTL_READ_COMPLETED_EDGE BIT(19)
#define DSI_DIRECT_CMD_STS_CTL_ACKNOWLEDGE_RECEIVED_EDGE BIT(20)
#define DSI_DIRECT_CMD_STS_CTL_ACKNOWLEDGE_WITH_ERR_EDGE BIT(21)
#define DSI_DIRECT_CMD_STS_CTL_TRIGGER_RECEIVED_EDGE BIT(22)
#define DSI_DIRECT_CMD_STS_CTL_TE_RECEIVED_EDGE BIT(23)
#define DSI_DIRECT_CMD_STS_CTL_BTA_COMPLETED_EDGE BIT(24)
#define DSI_DIRECT_CMD_STS_CTL_BTA_FINISHED_EDGE BIT(25)
#define DSI_DIRECT_CMD_STS_CTL_READ_COMPLETED_WITH_ERR_EDGE BIT(26)

#define DSI_VID_MODE_STS_CTL 0x00000100
#define DSI_VID_MODE_STS_CTL_VSG_RUNNING BIT(0)
#define DSI_VID_MODE_STS_CTL_ERR_MISSING_DATA BIT(1)
#define DSI_VID_MODE_STS_CTL_ERR_MISSING_HSYNC BIT(2)
#define DSI_VID_MODE_STS_CTL_ERR_MISSING_VSYNC BIT(3)
#define DSI_VID_MODE_STS_CTL_REG_ERR_SMALL_LENGTH BIT(4)
#define DSI_VID_MODE_STS_CTL_REG_ERR_SMALL_HEIGHT BIT(5)
#define DSI_VID_MODE_STS_CTL_ERR_BURSTWRITE BIT(6)
#define DSI_VID_MODE_STS_CTL_ERR_LONGWRITE BIT(7)
#define DSI_VID_MODE_STS_CTL_ERR_LONGREAD BIT(8)
#define DSI_VID_MODE_STS_CTL_ERR_VRS_WRONG_LENGTH BIT(9)
#define DSI_VID_MODE_STS_CTL_VSG_RUNNING_EDGE BIT(16)
#define DSI_VID_MODE_STS_CTL_ERR_MISSING_DATA_EDGE BIT(17)
#define DSI_VID_MODE_STS_CTL_ERR_MISSING_HSYNC_EDGE BIT(18)
#define DSI_VID_MODE_STS_CTL_ERR_MISSING_VSYNC_EDGE BIT(19)
#define DSI_VID_MODE_STS_CTL_REG_ERR_SMALL_LENGTH_EDGE BIT(20)
#define DSI_VID_MODE_STS_CTL_REG_ERR_SMALL_HEIGHT_EDGE BIT(21)
#define DSI_VID_MODE_STS_CTL_ERR_BURSTWRITE_EDGE BIT(22)
#define DSI_VID_MODE_STS_CTL_ERR_LONGWRITE_EDGE BIT(23)
#define DSI_VID_MODE_STS_CTL_ERR_LONGREAD_EDGE BIT(24)
#define DSI_VID_MODE_STS_CTL_ERR_VRS_WRONG_LENGTH_EDGE BIT(25)
#define DSI_VID_MODE_STS_CTL_VSG_RECOVERY_EDGE BIT(26)

#define DSI_TG_STS_CTL 0x00000104
#define DSI_MCTL_DHPY_ERR_CTL 0x00000108
#define DSI_MCTL_MAIN_STS_CLR 0x00000110

#define DSI_CMD_MODE_STS_CLR 0x00000114
#define DSI_CMD_MODE_STS_CLR_ERR_NO_TE_CLR BIT(0)
#define DSI_CMD_MODE_STS_CLR_ERR_TE_MISS_CLR BIT(1)
#define DSI_CMD_MODE_STS_CLR_ERR_SDI1_UNDERRUN_CLR BIT(2)
#define DSI_CMD_MODE_STS_CLR_ERR_SDI2_UNDERRUN_CLR BIT(3)
#define DSI_CMD_MODE_STS_CLR_ERR_UNWANTED_RD_CLR BIT(4)
#define DSI_CMD_MODE_STS_CLR_CSM_RUNNING_CLR BIT(5)

#define DSI_DIRECT_CMD_STS_CLR 0x00000118
#define DSI_DIRECT_CMD_STS_CLR_CMD_TRANSMISSION_CLR BIT(0)
#define DSI_DIRECT_CMD_STS_CLR_WRITE_COMPLETED_CLR BIT(1)
#define DSI_DIRECT_CMD_STS_CLR_TRIGGER_COMPLETED_CLR BIT(2)
#define DSI_DIRECT_CMD_STS_CLR_READ_COMPLETED_CLR BIT(3)
#define DSI_DIRECT_CMD_STS_CLR_ACKNOWLEDGE_RECEIVED_CLR BIT(4)
#define DSI_DIRECT_CMD_STS_CLR_ACKNOWLEDGE_WITH_ERR_RECEIVED_CLR BIT(5)
#define DSI_DIRECT_CMD_STS_CLR_TRIGGER_RECEIVED_CLR BIT(6)
#define DSI_DIRECT_CMD_STS_CLR_TE_RECEIVED_CLR BIT(7)
#define DSI_DIRECT_CMD_STS_CLR_BTA_COMPLETED_CLR BIT(8)
#define DSI_DIRECT_CMD_STS_CLR_BTA_FINISHED_CLR BIT(9)
#define DSI_DIRECT_CMD_STS_CLR_READ_COMPLETED_WITH_ERR_CLR BIT(10)

#define DSI_DIRECT_CMD_RD_STS_CLR 0x0000011C
#define DSI_VID_MODE_STS_CLR 0x00000120
#define DSI_TG_STS_CLR 0x00000124
#define DSI_MCTL_DPHY_ERR_CLR 0x00000128
#define DSI_MCTL_MAIN_STS_FLAG 0x00000130
#define DSI_CMD_MODE_STS_FLAG 0x00000134
#define DSI_DIRECT_CMD_STS_FLAG 0x00000138
#define DSI_DIRECT_CMD_RD_STS_FLAG 0x0000013C
#define DSI_VID_MODE_STS_FLAG 0x00000140
#define DSI_TG_STS_FLAG 0x00000144

#define DSI_DPHY_LANES_TRIM 0x00000150
#define DSI_DPHY_LANES_TRIM_DPHY_SKEW_DAT1_SHIFT 0
#define DSI_DPHY_LANES_TRIM_DPHY_SKEW_DAT1_MASK 0x00000003
#define DSI_DPHY_LANES_TRIM_DPHY_CD_OFF_DAT1 BIT(2)
#define DSI_DPHY_LANES_TRIM_DPHY_HSTX_SLEWRATE_UP_DAT1 BIT(3)
#define DSI_DPHY_LANES_TRIM_DPHY_HSTX_SLEWRATE_DOWN_DAT1 BIT(4)
#define DSI_DPHY_LANES_TRIM_DPHY_TEST_RESERVED_1_DAT1 BIT(5)
#define DSI_DPHY_LANES_TRIM_DPHY_SKEW_CLK_SHIFT 6
#define DSI_DPHY_LANES_TRIM_DPHY_SKEW_CLK_MASK 0x000000C0
#define DSI_DPHY_LANES_TRIM_DPHY_LP_RX_VIL_CLK_SHIFT 8
#define DSI_DPHY_LANES_TRIM_DPHY_LP_RX_VIL_CLK_MASK 0x00000300
#define DSI_DPHY_LANES_TRIM_DPHY_LP_TX_SLEWRATE_CLK_SHIFT 10
#define DSI_DPHY_LANES_TRIM_DPHY_LP_TX_SLEWRATE_CLK_MASK 0x00000C00
#define DSI_DPHY_LANES_TRIM_DPHY_SPECS_90_81B_0_81 0
#define DSI_DPHY_LANES_TRIM_DPHY_SPECS_90_81B_0_90 BIT(12)
#define DSI_DPHY_LANES_TRIM_DPHY_HSTX_SLEWRATE_UP_CLK BIT(13)
#define DSI_DPHY_LANES_TRIM_DPHY_HSTX_SLEWRATE_DOWN_CLK BIT(14)
#define DSI_DPHY_LANES_TRIM_DPHY_TEST_RESERVED_1_CLK BIT(15)
#define DSI_DPHY_LANES_TRIM_DPHY_SKEW_DAT2 BIT(16)
#define DSI_DPHY_LANES_TRIM_DPHY_HSTX_SLEWRATE_UP_DAT2 BIT(18)
#define DSI_DPHY_LANES_TRIM_DPHY_HSTX_SLEWRATE_DOWN_DAT2 BIT(19)
#define DSI_DPHY_LANES_TRIM_DPHY_TEST_RESERVED_1_DAT2 BIT(20)

#define DSI_ID_REG	0x00000FF0

#endif /* __DRM_MCDE_DSI_REGS */
