/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

public class Phaser {
    private volatile long state;
    private static final int MAX_PARTIES = 65535;
    private static final int MAX_PHASE = Integer.MAX_VALUE;
    private static final int PARTIES_SHIFT = 16;
    private static final int PHASE_SHIFT = 32;
    private static final int UNARRIVED_MASK = 65535;
    private static final long PARTIES_MASK = 0xFFFF0000L;
    private static final long TERMINATION_BIT = Long.MIN_VALUE;
    private static final int ONE_ARRIVAL = 1;
    private static final int ONE_PARTY = 65536;
    private static final int EMPTY = 1;
    private final Phaser parent;
    private final Phaser root;
    private final AtomicReference<QNode> evenQ;
    private final AtomicReference<QNode> oddQ;
    private static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final int SPINS_PER_ARRIVAL = NCPU < 2 ? 1 : 256;
    private static final Unsafe UNSAFE;
    private static final long stateOffset;

    private static int unarrivedOf(long l) {
        int n = (int)l;
        return n == 1 ? 0 : n & 0xFFFF;
    }

    private static int partiesOf(long l) {
        return (int)l >>> 16;
    }

    private static int phaseOf(long l) {
        return (int)(l >>> 32);
    }

    private static int arrivedOf(long l) {
        int n = (int)l;
        return n == 1 ? 0 : (n >>> 16) - (n & 0xFFFF);
    }

    private AtomicReference<QNode> queueFor(int n) {
        return (n & 1) == 0 ? this.evenQ : this.oddQ;
    }

    private String badArrive(long l) {
        return "Attempted arrival of unregistered party for " + this.stateToString(l);
    }

    private String badRegister(long l) {
        return "Attempt to register more than 65535 parties for " + this.stateToString(l);
    }

    private int doArrive(boolean bl) {
        int n;
        int n2;
        long l;
        int n3 = bl ? 65537 : 1;
        Phaser phaser = this.root;
        while (true) {
            l = phaser == this ? this.state : this.reconcileState();
            n2 = (int)(l >>> 32);
            int n4 = (int)l;
            n = (n4 & 0xFFFF) - 1;
            if (n2 < 0) {
                return n2;
            }
            if (n4 == 1 || n < 0) {
                if (phaser != this && this.reconcileState() != l) continue;
                throw new IllegalStateException(this.badArrive(l));
            }
            if (UNSAFE.compareAndSwapLong(this, stateOffset, l, l -= (long)n3)) break;
        }
        if (n == 0) {
            long l2 = l & 0xFFFF0000L;
            int n5 = (int)l2 >>> 16;
            if (phaser != this) {
                return this.parent.doArrive(n5 == 0);
            }
            l2 = this.onAdvance(n2, n5) ? (l2 |= Long.MIN_VALUE) : (n5 == 0 ? (l2 |= 1L) : (l2 |= (long)n5));
            UNSAFE.compareAndSwapLong(this, stateOffset, l, l2 |= (long)(n2 + 1 & Integer.MAX_VALUE) << 32);
            this.releaseWaiters(n2);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRegister(int n) {
        int n2;
        long l = (long)n << 16 | (long)n;
        Phaser phaser = this.parent;
        while (true) {
            long l2 = this.state;
            int n3 = (int)l2;
            int n4 = n3 >>> 16;
            int n5 = n3 & 0xFFFF;
            if (n > 65535 - n4) {
                throw new IllegalStateException(this.badRegister(l2));
            }
            n2 = (int)(l2 >>> 32);
            if (n2 < 0) break;
            if (n3 != 1) {
                if (phaser != null && this.reconcileState() != l2) continue;
                if (n5 == 0) {
                    this.root.internalAwaitAdvance(n2, null);
                    continue;
                }
                if (!UNSAFE.compareAndSwapLong(this, stateOffset, l2, l2 + l)) continue;
                break;
            }
            if (phaser == null) {
                long l3 = (long)n2 << 32 | l;
                if (!UNSAFE.compareAndSwapLong(this, stateOffset, l2, l3)) continue;
                break;
            }
            Phaser phaser2 = this;
            synchronized (phaser2) {
                if (this.state == l2) {
                    phaser.doRegister(1);
                    while (!UNSAFE.compareAndSwapLong(this, stateOffset, this.state, (long)(n2 = (int)(this.root.state >>> 32)) << 32 | l)) {
                    }
                    break;
                }
            }
        }
        return n2;
    }

    private long reconcileState() {
        Phaser phaser = this.root;
        long l = this.state;
        if (phaser != this) {
            int n;
            while ((n = (int)(phaser.state >>> 32)) != (int)(l >>> 32)) {
                int n2;
                int n3 = (int)l >>> 16;
                if (UNSAFE.compareAndSwapLong(this, stateOffset, l, l = (long)n << 32 | l & 0xFFFF0000L | (long)(n3 == 0 ? 1 : ((n2 = (int)l & 0xFFFF) == 0 ? n3 : n2)))) break;
                l = this.state;
            }
        }
        return l;
    }

    public Phaser() {
        this(null, 0);
    }

    public Phaser(int n) {
        this(null, n);
    }

    public Phaser(Phaser phaser) {
        this(phaser, 0);
    }

    public Phaser(Phaser phaser, int n) {
        if (n >>> 16 != 0) {
            throw new IllegalArgumentException("Illegal number of parties");
        }
        int n2 = 0;
        this.parent = phaser;
        if (phaser != null) {
            Phaser phaser2;
            this.root = phaser2 = phaser.root;
            this.evenQ = phaser2.evenQ;
            this.oddQ = phaser2.oddQ;
            if (n != 0) {
                n2 = phaser.doRegister(1);
            }
        } else {
            this.root = this;
            this.evenQ = new AtomicReference();
            this.oddQ = new AtomicReference();
        }
        this.state = n == 0 ? 1L : (long)n2 << 32 | (long)n << 16 | (long)n;
    }

    public int register() {
        return this.doRegister(1);
    }

    public int bulkRegister(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this.getPhase();
        }
        return this.doRegister(n);
    }

    public int arrive() {
        return this.doArrive(false);
    }

    public int arriveAndDeregister() {
        return this.doArrive(true);
    }

    public int arriveAndAwaitAdvance() {
        int n;
        int n2;
        long l;
        Phaser phaser = this.root;
        while (true) {
            l = phaser == this ? this.state : this.reconcileState();
            n2 = (int)(l >>> 32);
            int n3 = (int)l;
            n = (n3 & 0xFFFF) - 1;
            if (n2 < 0) {
                return n2;
            }
            if (n3 == 1 || n < 0) {
                if (this.reconcileState() != l) continue;
                throw new IllegalStateException(this.badArrive(l));
            }
            if (UNSAFE.compareAndSwapLong(this, stateOffset, l--, l)) break;
        }
        if (n != 0) {
            return phaser.internalAwaitAdvance(n2, null);
        }
        if (phaser != this) {
            return this.parent.arriveAndAwaitAdvance();
        }
        long l2 = l & 0xFFFF0000L;
        int n4 = (int)l2 >>> 16;
        l2 = this.onAdvance(n2, n4) ? (l2 |= Long.MIN_VALUE) : (n4 == 0 ? (l2 |= 1L) : (l2 |= (long)n4));
        int n5 = n2 + 1 & Integer.MAX_VALUE;
        if (!UNSAFE.compareAndSwapLong(this, stateOffset, l, l2 |= (long)n5 << 32)) {
            return (int)(this.state >>> 32);
        }
        this.releaseWaiters(n2);
        return n5;
    }

    public int awaitAdvance(int n) {
        Phaser phaser = this.root;
        long l = phaser == this ? this.state : this.reconcileState();
        int n2 = (int)(l >>> 32);
        if (n < 0) {
            return n;
        }
        if (n2 == n) {
            return phaser.internalAwaitAdvance(n, null);
        }
        return n2;
    }

    public int awaitAdvanceInterruptibly(int n) throws InterruptedException {
        Phaser phaser = this.root;
        long l = phaser == this ? this.state : this.reconcileState();
        int n2 = (int)(l >>> 32);
        if (n < 0) {
            return n;
        }
        if (n2 == n) {
            QNode qNode = new QNode(this, n, true, false, 0L);
            n2 = phaser.internalAwaitAdvance(n, qNode);
            if (qNode.wasInterrupted) {
                throw new InterruptedException();
            }
        }
        return n2;
    }

    public int awaitAdvanceInterruptibly(int n, long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        long l2 = timeUnit.toNanos(l);
        Phaser phaser = this.root;
        long l3 = phaser == this ? this.state : this.reconcileState();
        int n2 = (int)(l3 >>> 32);
        if (n < 0) {
            return n;
        }
        if (n2 == n) {
            QNode qNode = new QNode(this, n, true, true, l2);
            n2 = phaser.internalAwaitAdvance(n, qNode);
            if (qNode.wasInterrupted) {
                throw new InterruptedException();
            }
            if (n2 == n) {
                throw new TimeoutException();
            }
        }
        return n2;
    }

    public void forceTermination() {
        long l;
        Phaser phaser = this.root;
        while ((l = phaser.state) >= 0L) {
            if (!UNSAFE.compareAndSwapLong(phaser, stateOffset, l, l | Long.MIN_VALUE)) continue;
            this.releaseWaiters(0);
            this.releaseWaiters(1);
            return;
        }
    }

    public final int getPhase() {
        return (int)(this.root.state >>> 32);
    }

    public int getRegisteredParties() {
        return Phaser.partiesOf(this.state);
    }

    public int getArrivedParties() {
        return Phaser.arrivedOf(this.reconcileState());
    }

    public int getUnarrivedParties() {
        return Phaser.unarrivedOf(this.reconcileState());
    }

    public Phaser getParent() {
        return this.parent;
    }

    public Phaser getRoot() {
        return this.root;
    }

    public boolean isTerminated() {
        return this.root.state < 0L;
    }

    protected boolean onAdvance(int n, int n2) {
        return n2 == 0;
    }

    public String toString() {
        return this.stateToString(this.reconcileState());
    }

    private String stateToString(long l) {
        return super.toString() + "[phase = " + Phaser.phaseOf(l) + " parties = " + Phaser.partiesOf(l) + " arrived = " + Phaser.arrivedOf(l) + "]";
    }

    private void releaseWaiters(int n) {
        QNode qNode;
        AtomicReference<QNode> atomicReference;
        AtomicReference<QNode> atomicReference2 = atomicReference = (n & 1) == 0 ? this.evenQ : this.oddQ;
        while ((qNode = atomicReference.get()) != null && qNode.phase != (int)(this.root.state >>> 32)) {
            Thread thread;
            if (!atomicReference.compareAndSet(qNode, qNode.next) || (thread = qNode.thread) == null) continue;
            qNode.thread = null;
            LockSupport.unpark(thread);
        }
    }

    private int abortWait(int n) {
        AtomicReference<QNode> atomicReference = (n & 1) == 0 ? this.evenQ : this.oddQ;
        while (true) {
            Thread thread;
            QNode qNode = atomicReference.get();
            int n2 = (int)(this.root.state >>> 32);
            if (qNode == null || (thread = qNode.thread) != null && qNode.phase == n2) {
                return n2;
            }
            if (!atomicReference.compareAndSet(qNode, qNode.next) || thread == null) continue;
            qNode.thread = null;
            LockSupport.unpark(thread);
        }
    }

    private int internalAwaitAdvance(int n, QNode qNode) {
        long l;
        int n2;
        this.releaseWaiters(n - 1);
        boolean bl = false;
        int n3 = 0;
        int n4 = SPINS_PER_ARRIVAL;
        while ((n2 = (int)((l = this.state) >>> 32)) == n) {
            if (qNode == null) {
                boolean bl2;
                int n5 = (int)l & 0xFFFF;
                if (n5 != n3 && (n3 = n5) < NCPU) {
                    n4 += SPINS_PER_ARRIVAL;
                }
                if (!(bl2 = Thread.interrupted()) && --n4 >= 0) continue;
                qNode = new QNode(this, n, false, false, 0L);
                qNode.wasInterrupted = bl2;
                continue;
            }
            if (qNode.isReleasable()) break;
            if (!bl) {
                AtomicReference<QNode> atomicReference = (n & 1) == 0 ? this.evenQ : this.oddQ;
                qNode.next = atomicReference.get();
                QNode qNode2 = qNode.next;
                if (qNode2 != null && qNode2.phase != n || (int)(this.state >>> 32) != n) continue;
                bl = atomicReference.compareAndSet(qNode2, qNode);
                continue;
            }
            try {
                ForkJoinPool.managedBlock(qNode);
            }
            catch (InterruptedException interruptedException) {
                qNode.wasInterrupted = true;
            }
        }
        if (qNode != null) {
            if (qNode.thread != null) {
                qNode.thread = null;
            }
            if (qNode.wasInterrupted && !qNode.interruptible) {
                Thread.currentThread().interrupt();
            }
            if (n2 == n && (n2 = (int)(this.state >>> 32)) == n) {
                return this.abortWait(n);
            }
        }
        this.releaseWaiters(n);
        return n2;
    }

    static {
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<Phaser> clazz = Phaser.class;
            stateOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("state"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    static final class QNode
    implements ForkJoinPool.ManagedBlocker {
        final Phaser phaser;
        final int phase;
        final boolean interruptible;
        final boolean timed;
        boolean wasInterrupted;
        long nanos;
        long lastTime;
        volatile Thread thread;
        QNode next;

        QNode(Phaser phaser, int n, boolean bl, boolean bl2, long l) {
            this.phaser = phaser;
            this.phase = n;
            this.interruptible = bl;
            this.nanos = l;
            this.timed = bl2;
            this.lastTime = bl2 ? System.nanoTime() : 0L;
            this.thread = Thread.currentThread();
        }

        @Override
        public boolean isReleasable() {
            if (this.thread == null) {
                return true;
            }
            if (this.phaser.getPhase() != this.phase) {
                this.thread = null;
                return true;
            }
            if (Thread.interrupted()) {
                this.wasInterrupted = true;
            }
            if (this.wasInterrupted && this.interruptible) {
                this.thread = null;
                return true;
            }
            if (this.timed) {
                if (this.nanos > 0L) {
                    long l = System.nanoTime();
                    this.nanos -= l - this.lastTime;
                    this.lastTime = l;
                }
                if (this.nanos <= 0L) {
                    this.thread = null;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean block() {
            if (this.isReleasable()) {
                return true;
            }
            if (!this.timed) {
                LockSupport.park(this);
            } else if (this.nanos > 0L) {
                LockSupport.parkNanos(this, this.nanos);
            }
            return this.isReleasable();
        }
    }
}

