/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

final class PrivateKeyInfo {
    private static final BigInteger VERSION = BigInteger.ZERO;
    private AlgorithmId algid;
    private byte[] privkey;

    PrivateKeyInfo(byte[] byArray) throws IOException {
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag != 48) {
            throw new IOException("private key parse error: not a sequence");
        }
        BigInteger bigInteger = derValue.data.getBigInteger();
        if (!bigInteger.equals(VERSION)) {
            throw new IOException("version mismatch: (supported: " + VERSION + ", parsed: " + bigInteger);
        }
        this.algid = AlgorithmId.parse(derValue.data.getDerValue());
        this.privkey = derValue.data.getOctetString();
    }

    AlgorithmId getAlgorithm() {
        return this.algid;
    }
}

