/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale;

import java.lang.ref.SoftReference;
import sun.util.locale.LocaleObjectCache;
import sun.util.locale.LocaleUtils;

public final class BaseLocale {
    public static final String SEP = "_";
    private static final Cache CACHE = new Cache();
    private final String language;
    private final String script;
    private final String region;
    private final String variant;
    private volatile int hash = 0;

    private BaseLocale(String string, String string2) {
        this.language = string;
        this.script = "";
        this.region = string2;
        this.variant = "";
    }

    private BaseLocale(String string, String string2, String string3, String string4) {
        this.language = string != null ? LocaleUtils.toLowerString(string).intern() : "";
        this.script = string2 != null ? LocaleUtils.toTitleString(string2).intern() : "";
        this.region = string3 != null ? LocaleUtils.toUpperString(string3).intern() : "";
        this.variant = string4 != null ? string4.intern() : "";
    }

    public static BaseLocale createInstance(String string, String string2) {
        BaseLocale baseLocale = new BaseLocale(string, string2);
        CACHE.put(new Key(string, string2), baseLocale);
        return baseLocale;
    }

    public static BaseLocale getInstance(String string, String string2, String string3, String string4) {
        if (string != null) {
            if (LocaleUtils.caseIgnoreMatch(string, "he")) {
                string = "iw";
            } else if (LocaleUtils.caseIgnoreMatch(string, "yi")) {
                string = "ji";
            } else if (LocaleUtils.caseIgnoreMatch(string, "id")) {
                string = "in";
            }
        }
        Key key = new Key(string, string2, string3, string4);
        BaseLocale baseLocale = (BaseLocale)CACHE.get(key);
        return baseLocale;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getScript() {
        return this.script;
    }

    public String getRegion() {
        return this.region;
    }

    public String getVariant() {
        return this.variant;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseLocale)) {
            return false;
        }
        BaseLocale baseLocale = (BaseLocale)object;
        return this.language == baseLocale.language && this.script == baseLocale.script && this.region == baseLocale.region && this.variant == baseLocale.variant;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.language.length() > 0) {
            stringBuilder.append("language=");
            stringBuilder.append(this.language);
        }
        if (this.script.length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("script=");
            stringBuilder.append(this.script);
        }
        if (this.region.length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("region=");
            stringBuilder.append(this.region);
        }
        if (this.variant.length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("variant=");
            stringBuilder.append(this.variant);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            n = this.language.hashCode();
            n = 31 * n + this.script.hashCode();
            n = 31 * n + this.region.hashCode();
            this.hash = n = 31 * n + this.variant.hashCode();
        }
        return n;
    }

    private static class Cache
    extends LocaleObjectCache<Key, BaseLocale> {
        @Override
        protected Key normalizeKey(Key key) {
            assert (key.lang.get() != null && key.scrt.get() != null && key.regn.get() != null && key.vart.get() != null);
            return Key.normalize(key);
        }

        @Override
        protected BaseLocale createObject(Key key) {
            return new BaseLocale((String)key.lang.get(), (String)key.scrt.get(), (String)key.regn.get(), (String)key.vart.get());
        }
    }

    private static final class Key {
        private final SoftReference<String> lang;
        private final SoftReference<String> scrt;
        private final SoftReference<String> regn;
        private final SoftReference<String> vart;
        private final boolean normalized;
        private final int hash;

        private Key(String string, String string2) {
            assert (string.intern() == string && string2.intern() == string2);
            this.lang = new SoftReference<String>(string);
            this.scrt = new SoftReference<String>("");
            this.regn = new SoftReference<String>(string2);
            this.vart = new SoftReference<String>("");
            this.normalized = true;
            int n = string.hashCode();
            if (string2 != "") {
                int n2 = string2.length();
                for (int i = 0; i < n2; ++i) {
                    n = 31 * n + LocaleUtils.toLower(string2.charAt(i));
                }
            }
            this.hash = n;
        }

        public Key(String string, String string2, String string3, String string4) {
            this(string, string2, string3, string4, false);
        }

        private Key(String string, String string2, String string3, String string4, boolean bl) {
            int n;
            int n2;
            int n3 = 0;
            if (string != null) {
                this.lang = new SoftReference<String>(string);
                n2 = string.length();
                for (n = 0; n < n2; ++n) {
                    n3 = 31 * n3 + LocaleUtils.toLower(string.charAt(n));
                }
            } else {
                this.lang = new SoftReference<String>("");
            }
            if (string2 != null) {
                this.scrt = new SoftReference<String>(string2);
                n2 = string2.length();
                for (n = 0; n < n2; ++n) {
                    n3 = 31 * n3 + LocaleUtils.toLower(string2.charAt(n));
                }
            } else {
                this.scrt = new SoftReference<String>("");
            }
            if (string3 != null) {
                this.regn = new SoftReference<String>(string3);
                n2 = string3.length();
                for (n = 0; n < n2; ++n) {
                    n3 = 31 * n3 + LocaleUtils.toLower(string3.charAt(n));
                }
            } else {
                this.regn = new SoftReference<String>("");
            }
            if (string4 != null) {
                this.vart = new SoftReference<String>(string4);
                n2 = string4.length();
                for (n = 0; n < n2; ++n) {
                    n3 = 31 * n3 + string4.charAt(n);
                }
            } else {
                this.vart = new SoftReference<String>("");
            }
            this.hash = n3;
            this.normalized = bl;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Key && this.hash == ((Key)object).hash) {
                String string = this.lang.get();
                String string2 = ((Key)object).lang.get();
                if (string != null && string2 != null && LocaleUtils.caseIgnoreMatch(string2, string)) {
                    String string3 = this.scrt.get();
                    String string4 = ((Key)object).scrt.get();
                    if (string3 != null && string4 != null && LocaleUtils.caseIgnoreMatch(string4, string3)) {
                        String string5 = this.regn.get();
                        String string6 = ((Key)object).regn.get();
                        if (string5 != null && string6 != null && LocaleUtils.caseIgnoreMatch(string6, string5)) {
                            String string7 = this.vart.get();
                            String string8 = ((Key)object).vart.get();
                            return string8 != null && string8.equals(string7);
                        }
                    }
                }
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }

        public static Key normalize(Key key) {
            if (key.normalized) {
                return key;
            }
            String string = LocaleUtils.toLowerString(key.lang.get()).intern();
            String string2 = LocaleUtils.toTitleString(key.scrt.get()).intern();
            String string3 = LocaleUtils.toUpperString(key.regn.get()).intern();
            String string4 = key.vart.get().intern();
            return new Key(string, string2, string3, string4, true);
        }
    }
}

