/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import sun.java2d.SunGraphics2D;
import sun.java2d.loops.ProcessPath;
import sun.java2d.pipe.LoopPipe;
import sun.java2d.pipe.ParallelogramPipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RenderBuffer;
import sun.java2d.pipe.RenderQueue;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.ShapeSpanIterator;
import sun.java2d.pipe.SpanIterator;

public abstract class BufferedRenderPipe
implements PixelDrawPipe,
PixelFillPipe,
ShapeDrawPipe,
ParallelogramPipe {
    ParallelogramPipe aapgrampipe = new AAParallelogramPipe();
    static final int BYTES_PER_POLY_POINT = 8;
    static final int BYTES_PER_SCANLINE = 12;
    static final int BYTES_PER_SPAN = 16;
    protected RenderQueue rq;
    protected RenderBuffer buf;
    private BufferedDrawHandler drawHandler;

    public BufferedRenderPipe(RenderQueue renderQueue) {
        this.rq = renderQueue;
        this.buf = renderQueue.getBuffer();
        this.drawHandler = new BufferedDrawHandler();
    }

    public ParallelogramPipe getAAParallelogramPipe() {
        return this.aapgrampipe;
    }

    protected abstract void validateContext(SunGraphics2D var1);

    protected abstract void validateContextAA(SunGraphics2D var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        int n5 = sunGraphics2D.transX;
        int n6 = sunGraphics2D.transY;
        this.rq.lock();
        try {
            this.validateContext(sunGraphics2D);
            this.rq.ensureCapacity(20);
            this.buf.putInt(10);
            this.buf.putInt(n + n5);
            this.buf.putInt(n2 + n6);
            this.buf.putInt(n3 + n5);
            this.buf.putInt(n4 + n6);
        }
        finally {
            this.rq.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.rq.lock();
        try {
            this.validateContext(sunGraphics2D);
            this.rq.ensureCapacity(20);
            this.buf.putInt(11);
            this.buf.putInt(n + sunGraphics2D.transX);
            this.buf.putInt(n2 + sunGraphics2D.transY);
            this.buf.putInt(n3);
            this.buf.putInt(n4);
        }
        finally {
            this.rq.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.rq.lock();
        try {
            this.validateContext(sunGraphics2D);
            this.rq.ensureCapacity(20);
            this.buf.putInt(20);
            this.buf.putInt(n + sunGraphics2D.transX);
            this.buf.putInt(n2 + sunGraphics2D.transY);
            this.buf.putInt(n3);
            this.buf.putInt(n4);
        }
        finally {
            this.rq.unlock();
        }
    }

    @Override
    public void drawRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(sunGraphics2D, new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    @Override
    public void fillRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(sunGraphics2D, new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    @Override
    public void drawOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.draw(sunGraphics2D, new Ellipse2D.Float(n, n2, n3, n4));
    }

    @Override
    public void fillOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.fill(sunGraphics2D, new Ellipse2D.Float(n, n2, n3, n4));
    }

    @Override
    public void drawArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(sunGraphics2D, new Arc2D.Float(n, n2, n3, n4, n5, n6, 0));
    }

    @Override
    public void fillArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(sunGraphics2D, new Arc2D.Float(n, n2, n3, n4, n5, n6, 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawPoly(final SunGraphics2D sunGraphics2D, final int[] nArray, final int[] nArray2, final int n, final boolean bl) {
        if (nArray == null || nArray2 == null) {
            throw new NullPointerException("coordinate array");
        }
        if (nArray.length < n || nArray2.length < n) {
            throw new ArrayIndexOutOfBoundsException("coordinate array");
        }
        if (n < 2) {
            return;
        }
        if (n == 2 && !bl) {
            this.drawLine(sunGraphics2D, nArray[0], nArray2[0], nArray[1], nArray2[1]);
            return;
        }
        this.rq.lock();
        try {
            this.validateContext(sunGraphics2D);
            int n2 = n * 8;
            int n3 = 20 + n2;
            if (n3 <= this.buf.capacity()) {
                if (n3 > this.buf.remaining()) {
                    this.rq.flushNow();
                }
                this.buf.putInt(12);
                this.buf.putInt(n);
                this.buf.putInt(bl ? 1 : 0);
                this.buf.putInt(sunGraphics2D.transX);
                this.buf.putInt(sunGraphics2D.transY);
                this.buf.put(nArray, 0, n);
                this.buf.put(nArray2, 0, n);
            } else {
                this.rq.flushAndInvokeNow(new Runnable(){

                    @Override
                    public void run() {
                        BufferedRenderPipe.this.drawPoly(nArray, nArray2, n, bl, sunGraphics2D.transX, sunGraphics2D.transY);
                    }
                });
            }
        }
        finally {
            this.rq.unlock();
        }
    }

    protected abstract void drawPoly(int[] var1, int[] var2, int var3, boolean var4, int var5, int var6);

    @Override
    public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.drawPoly(sunGraphics2D, nArray, nArray2, n, false);
    }

    @Override
    public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.drawPoly(sunGraphics2D, nArray, nArray2, n, true);
    }

    @Override
    public void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.fill(sunGraphics2D, new Polygon(nArray, nArray2, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawPath(SunGraphics2D sunGraphics2D, Path2D.Float float_, int n, int n2) {
        this.rq.lock();
        try {
            this.validateContext(sunGraphics2D);
            this.drawHandler.validate(sunGraphics2D);
            ProcessPath.drawPath(this.drawHandler, float_, n, n2);
        }
        finally {
            this.rq.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillPath(SunGraphics2D sunGraphics2D, Path2D.Float float_, int n, int n2) {
        this.rq.lock();
        try {
            this.validateContext(sunGraphics2D);
            this.drawHandler.validate(sunGraphics2D);
            this.drawHandler.startFillPath();
            ProcessPath.fillPath(this.drawHandler, float_, n, n2);
            this.drawHandler.endFillPath();
        }
        finally {
            this.rq.unlock();
        }
    }

    private native int fillSpans(RenderQueue var1, long var2, int var4, int var5, SpanIterator var6, long var7, int var9, int var10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillSpans(SunGraphics2D sunGraphics2D, SpanIterator spanIterator, int n, int n2) {
        this.rq.lock();
        try {
            this.validateContext(sunGraphics2D);
            this.rq.ensureCapacity(24);
            int n3 = this.fillSpans(this.rq, this.buf.getAddress(), this.buf.position(), this.buf.capacity(), spanIterator, spanIterator.getNativeIterator(), n, n2);
            this.buf.position(n3);
        }
        finally {
            this.rq.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillParallelogram(SunGraphics2D sunGraphics2D, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        this.rq.lock();
        try {
            this.validateContext(sunGraphics2D);
            this.rq.ensureCapacity(28);
            this.buf.putInt(22);
            this.buf.putFloat((float)d5);
            this.buf.putFloat((float)d6);
            this.buf.putFloat((float)d7);
            this.buf.putFloat((float)d8);
            this.buf.putFloat((float)d9);
            this.buf.putFloat((float)d10);
        }
        finally {
            this.rq.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawParallelogram(SunGraphics2D sunGraphics2D, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        this.rq.lock();
        try {
            this.validateContext(sunGraphics2D);
            this.rq.ensureCapacity(36);
            this.buf.putInt(15);
            this.buf.putFloat((float)d5);
            this.buf.putFloat((float)d6);
            this.buf.putFloat((float)d7);
            this.buf.putFloat((float)d8);
            this.buf.putFloat((float)d9);
            this.buf.putFloat((float)d10);
            this.buf.putFloat((float)d11);
            this.buf.putFloat((float)d12);
        }
        finally {
            this.rq.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        if (sunGraphics2D.strokeState == 0) {
            int n;
            int n2;
            Path2D.Float float_;
            if (shape instanceof Polygon) {
                if (sunGraphics2D.transformState < 3) {
                    Polygon polygon = (Polygon)shape;
                    this.drawPolygon(sunGraphics2D, polygon.xpoints, polygon.ypoints, polygon.npoints);
                    return;
                }
            }
            if (sunGraphics2D.transformState <= 1) {
                float_ = shape instanceof Path2D.Float ? (Path2D.Float)shape : new Path2D.Float(shape);
                n2 = sunGraphics2D.transX;
                n = sunGraphics2D.transY;
            } else {
                float_ = new Path2D.Float(shape, sunGraphics2D.transform);
                n2 = 0;
                n = 0;
            }
            this.drawPath(sunGraphics2D, float_, n2, n);
        } else if (sunGraphics2D.strokeState < 3) {
            ShapeSpanIterator shapeSpanIterator = LoopPipe.getStrokeSpans(sunGraphics2D, shape);
            try {
                this.fillSpans(sunGraphics2D, shapeSpanIterator, 0, 0);
            }
            finally {
                shapeSpanIterator.dispose();
            }
        } else {
            this.fill(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(shape));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        int n;
        int n2;
        AffineTransform affineTransform;
        if (sunGraphics2D.strokeState == 0) {
            int n3;
            int n4;
            Path2D.Float float_;
            if (sunGraphics2D.transformState <= 1) {
                float_ = shape instanceof Path2D.Float ? (Path2D.Float)shape : new Path2D.Float(shape);
                n4 = sunGraphics2D.transX;
                n3 = sunGraphics2D.transY;
            } else {
                float_ = new Path2D.Float(shape, sunGraphics2D.transform);
                n4 = 0;
                n3 = 0;
            }
            this.fillPath(sunGraphics2D, float_, n4, n3);
            return;
        }
        if (sunGraphics2D.transformState <= 1) {
            affineTransform = null;
            n2 = sunGraphics2D.transX;
            n = sunGraphics2D.transY;
        } else {
            affineTransform = sunGraphics2D.transform;
            n = 0;
            n2 = 0;
        }
        ShapeSpanIterator shapeSpanIterator = LoopPipe.getFillSSI(sunGraphics2D);
        try {
            Region region = sunGraphics2D.getCompClip();
            shapeSpanIterator.setOutputAreaXYXY(region.getLoX() - n2, region.getLoY() - n, region.getHiX() - n2, region.getHiY() - n);
            shapeSpanIterator.appendPath(shape.getPathIterator(affineTransform));
            this.fillSpans(sunGraphics2D, shapeSpanIterator, n2, n);
        }
        finally {
            shapeSpanIterator.dispose();
        }
    }

    private class AAParallelogramPipe
    implements ParallelogramPipe {
        private AAParallelogramPipe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fillParallelogram(SunGraphics2D sunGraphics2D, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
            BufferedRenderPipe.this.rq.lock();
            try {
                BufferedRenderPipe.this.validateContextAA(sunGraphics2D);
                BufferedRenderPipe.this.rq.ensureCapacity(28);
                BufferedRenderPipe.this.buf.putInt(23);
                BufferedRenderPipe.this.buf.putFloat((float)d5);
                BufferedRenderPipe.this.buf.putFloat((float)d6);
                BufferedRenderPipe.this.buf.putFloat((float)d7);
                BufferedRenderPipe.this.buf.putFloat((float)d8);
                BufferedRenderPipe.this.buf.putFloat((float)d9);
                BufferedRenderPipe.this.buf.putFloat((float)d10);
            }
            finally {
                BufferedRenderPipe.this.rq.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drawParallelogram(SunGraphics2D sunGraphics2D, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
            BufferedRenderPipe.this.rq.lock();
            try {
                BufferedRenderPipe.this.validateContextAA(sunGraphics2D);
                BufferedRenderPipe.this.rq.ensureCapacity(36);
                BufferedRenderPipe.this.buf.putInt(16);
                BufferedRenderPipe.this.buf.putFloat((float)d5);
                BufferedRenderPipe.this.buf.putFloat((float)d6);
                BufferedRenderPipe.this.buf.putFloat((float)d7);
                BufferedRenderPipe.this.buf.putFloat((float)d8);
                BufferedRenderPipe.this.buf.putFloat((float)d9);
                BufferedRenderPipe.this.buf.putFloat((float)d10);
                BufferedRenderPipe.this.buf.putFloat((float)d11);
                BufferedRenderPipe.this.buf.putFloat((float)d12);
            }
            finally {
                BufferedRenderPipe.this.rq.unlock();
            }
        }
    }

    private class BufferedDrawHandler
    extends ProcessPath.DrawHandler {
        private int scanlineCount;
        private int scanlineCountIndex;
        private int remainingScanlines;

        BufferedDrawHandler() {
            super(0, 0, 0, 0);
        }

        void validate(SunGraphics2D sunGraphics2D) {
            Region region = sunGraphics2D.getCompClip();
            this.setBounds(region.getLoX(), region.getLoY(), region.getHiX(), region.getHiY(), sunGraphics2D.strokeHint);
        }

        @Override
        public void drawLine(int n, int n2, int n3, int n4) {
            BufferedRenderPipe.this.rq.ensureCapacity(20);
            BufferedRenderPipe.this.buf.putInt(10);
            BufferedRenderPipe.this.buf.putInt(n);
            BufferedRenderPipe.this.buf.putInt(n2);
            BufferedRenderPipe.this.buf.putInt(n3);
            BufferedRenderPipe.this.buf.putInt(n4);
        }

        @Override
        public void drawPixel(int n, int n2) {
            BufferedRenderPipe.this.rq.ensureCapacity(12);
            BufferedRenderPipe.this.buf.putInt(13);
            BufferedRenderPipe.this.buf.putInt(n);
            BufferedRenderPipe.this.buf.putInt(n2);
        }

        private void resetFillPath() {
            BufferedRenderPipe.this.buf.putInt(14);
            this.scanlineCountIndex = BufferedRenderPipe.this.buf.position();
            BufferedRenderPipe.this.buf.putInt(0);
            this.scanlineCount = 0;
            this.remainingScanlines = BufferedRenderPipe.this.buf.remaining() / 12;
        }

        private void updateScanlineCount() {
            BufferedRenderPipe.this.buf.putInt(this.scanlineCountIndex, this.scanlineCount);
        }

        public void startFillPath() {
            BufferedRenderPipe.this.rq.ensureCapacity(20);
            this.resetFillPath();
        }

        @Override
        public void drawScanline(int n, int n2, int n3) {
            if (this.remainingScanlines == 0) {
                this.updateScanlineCount();
                BufferedRenderPipe.this.rq.flushNow();
                this.resetFillPath();
            }
            BufferedRenderPipe.this.buf.putInt(n);
            BufferedRenderPipe.this.buf.putInt(n2);
            BufferedRenderPipe.this.buf.putInt(n3);
            ++this.scanlineCount;
            --this.remainingScanlines;
        }

        public void endFillPath() {
            this.updateScanlineCount();
        }
    }
}

