/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import javax.sql.rowset.serial.SQLOutputImpl;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;
import javax.sql.rowset.serial.SerialRef;

public class SerialStruct
implements Struct,
Serializable,
Cloneable {
    private String SQLTypeName;
    private Object[] attribs;
    static final long serialVersionUID = -8322445504027483372L;

    public SerialStruct(Struct struct, Map<String, Class<?>> map) throws SerialException {
        try {
            this.SQLTypeName = struct.getSQLTypeName();
            System.out.println("SQLTypeName: " + this.SQLTypeName);
            this.attribs = struct.getAttributes(map);
            this.mapToSerial(map);
        }
        catch (SQLException sQLException) {
            throw new SerialException(sQLException.getMessage());
        }
    }

    public SerialStruct(SQLData sQLData, Map<String, Class<?>> map) throws SerialException {
        try {
            this.SQLTypeName = sQLData.getSQLTypeName();
            Vector vector = new Vector();
            sQLData.writeSQL(new SQLOutputImpl(vector, map));
            this.attribs = vector.toArray();
        }
        catch (SQLException sQLException) {
            throw new SerialException(sQLException.getMessage());
        }
    }

    @Override
    public String getSQLTypeName() throws SerialException {
        return this.SQLTypeName;
    }

    @Override
    public Object[] getAttributes() throws SerialException {
        Object[] objectArray = this.attribs;
        return objectArray == null ? null : Arrays.copyOf(objectArray, objectArray.length);
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SerialException {
        Object[] objectArray = this.attribs;
        return objectArray == null ? null : Arrays.copyOf(objectArray, objectArray.length);
    }

    private void mapToSerial(Map<String, Class<?>> map) throws SerialException {
        try {
            for (int i = 0; i < this.attribs.length; ++i) {
                if (this.attribs[i] instanceof Struct) {
                    this.attribs[i] = new SerialStruct((Struct)this.attribs[i], map);
                    continue;
                }
                if (this.attribs[i] instanceof SQLData) {
                    this.attribs[i] = new SerialStruct((SQLData)this.attribs[i], map);
                    continue;
                }
                if (this.attribs[i] instanceof Blob) {
                    this.attribs[i] = new SerialBlob((Blob)this.attribs[i]);
                    continue;
                }
                if (this.attribs[i] instanceof Clob) {
                    this.attribs[i] = new SerialClob((Clob)this.attribs[i]);
                    continue;
                }
                if (this.attribs[i] instanceof Ref) {
                    this.attribs[i] = new SerialRef((Ref)this.attribs[i]);
                    continue;
                }
                if (!(this.attribs[i] instanceof Array)) continue;
                this.attribs[i] = new SerialArray((Array)this.attribs[i], map);
            }
        }
        catch (SQLException sQLException) {
            throw new SerialException(sQLException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SerialStruct) {
            SerialStruct serialStruct = (SerialStruct)object;
            return this.SQLTypeName.equals(serialStruct.SQLTypeName) && Arrays.equals(this.attribs, serialStruct.attribs);
        }
        return false;
    }

    public int hashCode() {
        return (31 + Arrays.hashCode(this.attribs)) * 31 * 31 + this.SQLTypeName.hashCode();
    }

    public Object clone() {
        try {
            SerialStruct serialStruct = (SerialStruct)super.clone();
            serialStruct.attribs = Arrays.copyOf(this.attribs, this.attribs.length);
            return serialStruct;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Object[] objectArray = (Object[])getField.get("attribs", null);
        this.attribs = objectArray == null ? null : (Object[])objectArray.clone();
        this.SQLTypeName = (String)getField.get("SQLTypeName", null);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("attribs", this.attribs);
        putField.put("SQLTypeName", this.SQLTypeName);
        objectOutputStream.writeFields();
    }
}

