/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.x11;

import java.awt.Color;
import java.awt.Transparency;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import sun.awt.X11GraphicsConfig;
import sun.java2d.SurfaceData;
import sun.java2d.SurfaceDataProxy;
import sun.java2d.loops.CompositeType;
import sun.java2d.x11.X11SurfaceData;

public abstract class X11SurfaceDataProxy
extends SurfaceDataProxy
implements Transparency {
    X11GraphicsConfig x11gc;

    public static SurfaceDataProxy createProxy(SurfaceData surfaceData, X11GraphicsConfig x11GraphicsConfig) {
        if (surfaceData instanceof X11SurfaceData) {
            return UNCACHED;
        }
        ColorModel colorModel = surfaceData.getColorModel();
        int n = colorModel.getTransparency();
        if (n == 1) {
            return new Opaque(x11GraphicsConfig);
        }
        if (n == 2) {
            if (colorModel instanceof IndexColorModel && colorModel.getPixelSize() == 8) {
                return new Bitmask(x11GraphicsConfig);
            }
            if (colorModel instanceof DirectColorModel) {
                DirectColorModel directColorModel = (DirectColorModel)colorModel;
                int n2 = directColorModel.getRedMask() | directColorModel.getGreenMask() | directColorModel.getBlueMask();
                int n3 = directColorModel.getAlphaMask();
                if ((n2 & 0xFF000000) == 0 && (n3 & 0xFF000000) != 0) {
                    return new Bitmask(x11GraphicsConfig);
                }
            }
        }
        return UNCACHED;
    }

    public X11SurfaceDataProxy(X11GraphicsConfig x11GraphicsConfig) {
        this.x11gc = x11GraphicsConfig;
    }

    @Override
    public SurfaceData validateSurfaceData(SurfaceData surfaceData, SurfaceData surfaceData2, int n, int n2) {
        if (surfaceData2 == null) {
            surfaceData2 = X11SurfaceData.createData(this.x11gc, n, n2, this.x11gc.getColorModel(), null, 0L, this.getTransparency());
        }
        return surfaceData2;
    }

    public static class Bitmask
    extends X11SurfaceDataProxy {
        public Bitmask(X11GraphicsConfig x11GraphicsConfig) {
            super(x11GraphicsConfig);
        }

        @Override
        public int getTransparency() {
            return 2;
        }

        @Override
        public boolean isSupportedOperation(SurfaceData surfaceData, int n, CompositeType compositeType, Color color) {
            if (n >= 3) {
                return false;
            }
            if (color != null && color.getTransparency() != 1) {
                return false;
            }
            return CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcNoEa.equals(compositeType) && color != null;
        }
    }

    public static class Opaque
    extends X11SurfaceDataProxy {
        public Opaque(X11GraphicsConfig x11GraphicsConfig) {
            super(x11GraphicsConfig);
        }

        @Override
        public int getTransparency() {
            return 1;
        }

        @Override
        public boolean isSupportedOperation(SurfaceData surfaceData, int n, CompositeType compositeType, Color color) {
            return n < 3 && (CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcNoEa.equals(compositeType));
        }
    }
}

