/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XImage
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 88 : 136;
    }

    @Override
    public int getDataSize() {
        return XImage.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XImage(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XImage() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XImage.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_width() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_width(int n) {
        log.finest("");
        Native.putInt(this.pData + 0L, n);
    }

    public int get_height() {
        log.finest("");
        return Native.getInt(this.pData + 4L);
    }

    public void set_height(int n) {
        log.finest("");
        Native.putInt(this.pData + 4L, n);
    }

    public int get_xoffset() {
        log.finest("");
        return Native.getInt(this.pData + 8L);
    }

    public void set_xoffset(int n) {
        log.finest("");
        Native.putInt(this.pData + 8L, n);
    }

    public int get_format() {
        log.finest("");
        return Native.getInt(this.pData + 12L);
    }

    public void set_format(int n) {
        log.finest("");
        Native.putInt(this.pData + 12L, n);
    }

    public byte get_data(int n) {
        log.finest("");
        return Native.getByte(Native.getLong(this.pData + 16L) + (long)(n * 1));
    }

    public long get_data() {
        log.finest("");
        return Native.getLong(this.pData + 16L);
    }

    public void set_data(long l) {
        log.finest("");
        Native.putLong(this.pData + 16L, l);
    }

    public int get_byte_order() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 20 : 24));
    }

    public void set_byte_order(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 20 : 24), n);
    }

    public int get_bitmap_unit() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 24 : 28));
    }

    public void set_bitmap_unit(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 24 : 28), n);
    }

    public int get_bitmap_bit_order() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 28 : 32));
    }

    public void set_bitmap_bit_order(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 28 : 32), n);
    }

    public int get_bitmap_pad() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 36));
    }

    public void set_bitmap_pad(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 36), n);
    }

    public int get_depth() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 36 : 40));
    }

    public void set_depth(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 36 : 40), n);
    }

    public int get_bytes_per_line() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 40 : 44));
    }

    public void set_bytes_per_line(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 40 : 44), n);
    }

    public int get_bits_per_pixel() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 44 : 48));
    }

    public void set_bits_per_pixel(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 44 : 48), n);
    }

    public long get_red_mask() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 48 : 56));
    }

    public void set_red_mask(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 48 : 56), l);
    }

    public long get_green_mask() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 52 : 64));
    }

    public void set_green_mask(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 52 : 64), l);
    }

    public long get_blue_mask() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 56 : 72));
    }

    public void set_blue_mask(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 56 : 72), l);
    }

    public long get_obdata(int n) {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 60 : 80)) + (long)(n * Native.getLongSize());
    }

    public long get_obdata() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 60 : 80));
    }

    public void set_obdata(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 60 : 80), l);
    }

    public long get_f_create_image(int n) {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 64 : 88)) + (long)(n * Native.getLongSize());
    }

    public long get_f_create_image() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 64 : 88));
    }

    public void set_f_create_image(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 64 : 88), l);
    }

    public long get_f_destroy_image(int n) {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 68 : 96)) + (long)(n * Native.getLongSize());
    }

    public long get_f_destroy_image() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 68 : 96));
    }

    public void set_f_destroy_image(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 68 : 96), l);
    }

    public long get_f_get_pixel(int n) {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 72 : 104)) + (long)(n * Native.getLongSize());
    }

    public long get_f_get_pixel() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 72 : 104));
    }

    public void set_f_get_pixel(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 72 : 104), l);
    }

    public long get_f_put_pixel(int n) {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 76 : 112)) + (long)(n * Native.getLongSize());
    }

    public long get_f_put_pixel() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 76 : 112));
    }

    public void set_f_put_pixel(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 76 : 112), l);
    }

    public long get_f_sub_image(int n) {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 80 : 120)) + (long)(n * Native.getLongSize());
    }

    public long get_f_sub_image() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 80 : 120));
    }

    public void set_f_sub_image(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 80 : 120), l);
    }

    public long get_f_add_pixel(int n) {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 84 : 128)) + (long)(n * Native.getLongSize());
    }

    public long get_f_add_pixel() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 84 : 128));
    }

    public void set_f_add_pixel(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 84 : 128), l);
    }

    @Override
    String getName() {
        return "XImage";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(880);
        stringBuilder.append("width = ").append(this.get_width()).append(", ");
        stringBuilder.append("height = ").append(this.get_height()).append(", ");
        stringBuilder.append("xoffset = ").append(this.get_xoffset()).append(", ");
        stringBuilder.append("format = ").append(this.get_format()).append(", ");
        stringBuilder.append("data = ").append(this.get_data()).append(", ");
        stringBuilder.append("byte_order = ").append(this.get_byte_order()).append(", ");
        stringBuilder.append("bitmap_unit = ").append(this.get_bitmap_unit()).append(", ");
        stringBuilder.append("bitmap_bit_order = ").append(this.get_bitmap_bit_order()).append(", ");
        stringBuilder.append("bitmap_pad = ").append(this.get_bitmap_pad()).append(", ");
        stringBuilder.append("depth = ").append(this.get_depth()).append(", ");
        stringBuilder.append("bytes_per_line = ").append(this.get_bytes_per_line()).append(", ");
        stringBuilder.append("bits_per_pixel = ").append(this.get_bits_per_pixel()).append(", ");
        stringBuilder.append("red_mask = ").append(this.get_red_mask()).append(", ");
        stringBuilder.append("green_mask = ").append(this.get_green_mask()).append(", ");
        stringBuilder.append("blue_mask = ").append(this.get_blue_mask()).append(", ");
        stringBuilder.append("obdata = ").append(this.get_obdata()).append(", ");
        stringBuilder.append("f_create_image = ").append(this.get_f_create_image()).append(", ");
        stringBuilder.append("f_destroy_image = ").append(this.get_f_destroy_image()).append(", ");
        stringBuilder.append("f_get_pixel = ").append(this.get_f_get_pixel()).append(", ");
        stringBuilder.append("f_put_pixel = ").append(this.get_f_put_pixel()).append(", ");
        stringBuilder.append("f_sub_image = ").append(this.get_f_sub_image()).append(", ");
        stringBuilder.append("f_add_pixel = ").append(this.get_f_add_pixel()).append(", ");
        return stringBuilder.toString();
    }
}

