/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidApplicationException;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.StringValueExp;

class InstanceOfQueryExp
extends QueryEval
implements QueryExp {
    private static final long serialVersionUID = -1081892073854801359L;
    private StringValueExp classNameValue;

    public InstanceOfQueryExp(StringValueExp stringValueExp) {
        if (stringValueExp == null) {
            throw new IllegalArgumentException("Null class name.");
        }
        this.classNameValue = stringValueExp;
    }

    public StringValueExp getClassNameValue() {
        return this.classNameValue;
    }

    @Override
    public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        StringValueExp stringValueExp;
        try {
            stringValueExp = (StringValueExp)this.classNameValue.apply(objectName);
        }
        catch (ClassCastException classCastException) {
            BadStringOperationException badStringOperationException = new BadStringOperationException(classCastException.toString());
            badStringOperationException.initCause(classCastException);
            throw badStringOperationException;
        }
        try {
            return InstanceOfQueryExp.getMBeanServer().isInstanceOf(objectName, stringValueExp.getValue());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            return false;
        }
    }

    public String toString() {
        return "InstanceOf " + this.classNameValue.toString();
    }
}

