/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolTipUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class BasicToolTipUI
extends ToolTipUI {
    static BasicToolTipUI sharedInstance = new BasicToolTipUI();
    private static PropertyChangeListener sharedPropertyChangedListener;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return sharedInstance;
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.installDefaults(jComponent);
        this.installComponents(jComponent);
        this.installListeners(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults(jComponent);
        this.uninstallComponents(jComponent);
        this.uninstallListeners(jComponent);
    }

    protected void installDefaults(JComponent jComponent) {
        LookAndFeel.installColorsAndFont(jComponent, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        LookAndFeel.installProperty(jComponent, "opaque", Boolean.TRUE);
        this.componentChanged(jComponent);
    }

    protected void uninstallDefaults(JComponent jComponent) {
        LookAndFeel.uninstallBorder(jComponent);
    }

    private void installComponents(JComponent jComponent) {
        BasicHTML.updateRenderer(jComponent, ((JToolTip)jComponent).getTipText());
    }

    private void uninstallComponents(JComponent jComponent) {
        BasicHTML.updateRenderer(jComponent, "");
    }

    protected void installListeners(JComponent jComponent) {
        this.propertyChangeListener = this.createPropertyChangeListener(jComponent);
        jComponent.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallListeners(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    private PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        if (sharedPropertyChangedListener == null) {
            sharedPropertyChangedListener = new PropertyChangeHandler();
        }
        return sharedPropertyChangedListener;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics, font);
        Dimension dimension = jComponent.getSize();
        graphics.setColor(jComponent.getForeground());
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null) {
            string = "";
        }
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle(insets.left + 3, insets.top, dimension.width - (insets.left + insets.right) - 6, dimension.height - (insets.top + insets.bottom));
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            graphics.setFont(font);
            SwingUtilities2.drawString(jComponent, graphics, string, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = jComponent.getFontMetrics(font);
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null || string.equals("")) {
            string = "";
        } else {
            View view;
            View view2 = view = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
            if (view != null) {
                dimension.width += (int)view.getPreferredSpan(0) + 6;
                dimension.height += (int)view.getPreferredSpan(1);
            } else {
                dimension.width += SwingUtilities2.stringWidth(jComponent, fontMetrics, string) + 6;
                dimension.height += fontMetrics.getHeight();
            }
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    private void componentChanged(JComponent jComponent) {
        JComponent jComponent2 = ((JToolTip)jComponent).getComponent();
        if (jComponent2 != null && !jComponent2.isEnabled()) {
            if (UIManager.getBorder("ToolTip.borderInactive") != null) {
                LookAndFeel.installBorder(jComponent, "ToolTip.borderInactive");
            } else {
                LookAndFeel.installBorder(jComponent, "ToolTip.border");
            }
            if (UIManager.getColor("ToolTip.backgroundInactive") != null) {
                LookAndFeel.installColors(jComponent, "ToolTip.backgroundInactive", "ToolTip.foregroundInactive");
            } else {
                LookAndFeel.installColors(jComponent, "ToolTip.background", "ToolTip.foreground");
            }
        } else {
            LookAndFeel.installBorder(jComponent, "ToolTip.border");
            LookAndFeel.installColors(jComponent, "ToolTip.background", "ToolTip.foreground");
        }
    }

    private static class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JToolTip jToolTip;
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("tiptext") || "font".equals(string) || "foreground".equals(string)) {
                JToolTip jToolTip2 = (JToolTip)propertyChangeEvent.getSource();
                String string2 = jToolTip2.getTipText();
                BasicHTML.updateRenderer(jToolTip2, string2);
            } else if ("component".equals(string) && (jToolTip = (JToolTip)propertyChangeEvent.getSource()).getUI() instanceof BasicToolTipUI) {
                ((BasicToolTipUI)jToolTip.getUI()).componentChanged(jToolTip);
            }
        }
    }
}

