/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import java.text.CharacterIterator;
import sun.text.normalizer.UCharacterIterator;

public class CharacterIteratorWrapper
extends UCharacterIterator {
    private CharacterIterator iterator;

    public CharacterIteratorWrapper(CharacterIterator characterIterator) {
        if (characterIterator == null) {
            throw new IllegalArgumentException();
        }
        this.iterator = characterIterator;
    }

    @Override
    public int current() {
        char c = this.iterator.current();
        if (c == '\uffff') {
            return -1;
        }
        return c;
    }

    @Override
    public int getLength() {
        return this.iterator.getEndIndex() - this.iterator.getBeginIndex();
    }

    @Override
    public int getIndex() {
        return this.iterator.getIndex();
    }

    @Override
    public int next() {
        char c = this.iterator.current();
        this.iterator.next();
        if (c == '\uffff') {
            return -1;
        }
        return c;
    }

    @Override
    public int previous() {
        char c = this.iterator.previous();
        if (c == '\uffff') {
            return -1;
        }
        return c;
    }

    @Override
    public void setIndex(int n) {
        this.iterator.setIndex(n);
    }

    @Override
    public int getText(char[] cArray, int n) {
        int n2 = this.iterator.getEndIndex() - this.iterator.getBeginIndex();
        int n3 = this.iterator.getIndex();
        if (n < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException(Integer.toString(n2));
        }
        char c = this.iterator.first();
        while (c != '\uffff') {
            cArray[n++] = c;
            c = this.iterator.next();
        }
        this.iterator.setIndex(n3);
        return n2;
    }

    @Override
    public Object clone() {
        try {
            CharacterIteratorWrapper characterIteratorWrapper = (CharacterIteratorWrapper)super.clone();
            characterIteratorWrapper.iterator = (CharacterIterator)this.iterator.clone();
            return characterIteratorWrapper;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

