#ifdef GL_ES
#extension GL_OES_standard_derivatives : enable
precision highp float;
precision highp int;
#define HIGHP highp
#define MEDIUMP mediump
#define LOWP lowp
#else
#define HIGHP
#define MEDIUMP
#define LOWP
#endif
varying vec2 texCoord0;
varying vec2 texCoord1;
varying LOWP vec4 perVertexColor;
uniform sampler2D dstColor;
uniform sampler2D glyphColor;
uniform vec3 gamma;
LOWP vec4 paint(vec2 texCoord, vec2 texCoord2, vec4 jslVertexColor) {
float unitXCoord = gamma.z;
vec2 dTexCoord = texCoord;
vec3 glyphClr;
dTexCoord.x = texCoord.x - unitXCoord;
glyphClr.r = texture2D(glyphColor, dTexCoord).a;
glyphClr.g = texture2D(glyphColor, texCoord).a;
dTexCoord.x = texCoord.x + unitXCoord;
glyphClr.b = texture2D(glyphColor, dTexCoord).a;
if (dot(glyphClr, glyphClr) == 0.0){
discard;}
vec3 dstClr = texture2D(dstColor, texCoord2).rgb;
vec3 dstAdj = pow(dstClr, vec3(gamma.y, gamma.y, gamma.y));
vec3 result = dstAdj + glyphClr * (jslVertexColor.rgb - jslVertexColor.a * dstAdj);
vec3 resultAdj = pow(result, vec3(gamma.x, gamma.x, gamma.x));
return vec4(resultAdj.r, resultAdj.g, resultAdj.b, 1.0);
}
void main() {
gl_FragColor = paint(texCoord0, texCoord1, perVertexColor);
}
