/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import javax.security.auth.DestroyFailedException;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.krb5.Krb5CredElement;
import sun.security.jgss.krb5.Krb5InitCredential;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.krb5.ServiceCreds;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.PrincipalName;

public class Krb5AcceptCredential
implements Krb5CredElement {
    private final Krb5NameElement name;
    private final ServiceCreds screds;

    private Krb5AcceptCredential(Krb5NameElement krb5NameElement, ServiceCreds serviceCreds) {
        this.name = krb5NameElement;
        this.screds = serviceCreds;
    }

    static Krb5AcceptCredential getInstance(final GSSCaller gSSCaller, Krb5NameElement krb5NameElement) throws GSSException {
        String string;
        final String string2 = krb5NameElement == null ? null : krb5NameElement.getKrb5PrincipalName().getName();
        final AccessControlContext accessControlContext = AccessController.getContext();
        ServiceCreds serviceCreds = null;
        try {
            serviceCreds = AccessController.doPrivileged(new PrivilegedExceptionAction<ServiceCreds>(){

                @Override
                public ServiceCreds run() throws Exception {
                    return Krb5Util.getServiceCreds(gSSCaller == GSSCaller.CALLER_UNKNOWN ? GSSCaller.CALLER_ACCEPT : gSSCaller, string2, accessControlContext);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            GSSException gSSException = new GSSException(13, -1, "Attempt to obtain new ACCEPT credentials failed!");
            gSSException.initCause(privilegedActionException.getException());
            throw gSSException;
        }
        if (serviceCreds == null) {
            throw new GSSException(13, -1, "Failed to find any Kerberos credentails");
        }
        if (krb5NameElement == null && (string = serviceCreds.getName()) != null) {
            krb5NameElement = Krb5NameElement.getInstance(string, Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL);
        }
        return new Krb5AcceptCredential(krb5NameElement, serviceCreds);
    }

    @Override
    public final GSSNameSpi getName() throws GSSException {
        return this.name;
    }

    @Override
    public int getInitLifetime() throws GSSException {
        return 0;
    }

    @Override
    public int getAcceptLifetime() throws GSSException {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isInitiatorCredential() throws GSSException {
        return false;
    }

    @Override
    public boolean isAcceptorCredential() throws GSSException {
        return true;
    }

    @Override
    public final Oid getMechanism() {
        return Krb5MechFactory.GSS_KRB5_MECH_OID;
    }

    @Override
    public final Provider getProvider() {
        return Krb5MechFactory.PROVIDER;
    }

    public EncryptionKey[] getKrb5EncryptionKeys(PrincipalName principalName) {
        return this.screds.getEKeys(principalName);
    }

    @Override
    public void dispose() throws GSSException {
        try {
            this.destroy();
        }
        catch (DestroyFailedException destroyFailedException) {
            GSSException gSSException = new GSSException(11, -1, "Could not destroy credentials - " + destroyFailedException.getMessage());
            gSSException.initCause(destroyFailedException);
        }
    }

    public void destroy() throws DestroyFailedException {
        this.screds.destroy();
    }

    @Override
    public GSSCredentialSpi impersonate(GSSNameSpi gSSNameSpi) throws GSSException {
        Credentials credentials = this.screds.getInitCred();
        if (credentials != null) {
            return Krb5InitCredential.getInstance(this.name, credentials).impersonate(gSSNameSpi);
        }
        throw new GSSException(11, -1, "Only an initiate credentials can impersonate");
    }
}

